var VPL = VPL || {};
VPL.Utils = {
	
	showCommentForm: function ()
	{
		document.getElementById('vpl_comment_message_container').style.display = "none";
		document.getElementById('vpl_comment_form').style.display = "block";
		window.location.href = "#vpl_comment_form";
	},
	closeCommentForm: function ()
	{
		document.getElementById('vpl_comment_message_container').style.display = "block";
		document.getElementById('vpl_comment_form').style.display = "none";
	},
	
	showAllOrLess: function(source, target)
	{
		document.getElementById(source).style.display = "none";
		document.getElementById(target).style.display = "block";
	},
	
	submitRequest : function (event, formName, containerId) {
		
		var postData = [],
			re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
			msg = '',
			name = document.forms[formName].name,
			email = document.forms[formName].email,
			password = document.forms[formName].password,
			login_password = document.forms[formName].login_password,
			forgot_email = document.forms[formName].forgot_email,
			login_email = document.forms[formName].login_email,
			retype_password = document.forms[formName].retype_password,
			comment = document.forms[formName].comment,
			captcha = document.forms[formName].captcha;
		
		var err_container = document.getElementById(containerId);
		
		if (name && name.value == '') {
			msg += '<li>' + VPL.Msg.bf_name + '</li>';
		}
		
		if (email) {
			if (email.value == '') {
				msg += '<li>' + VPL.Msg.bf_email + '</li>';
			}
			if (email.value != '' && email.value.match(re) == null) {
				msg += '<li>' + VPL.Msg.bf_email_inv + '</li>';
			}
		}
		if (login_email) {
			if (login_email.value == '') {
				msg += '<li>' + VPL.Msg.bf_email + '</li>';
			}
			if (login_email.value != '' && login_email.value.match(re) == null) {
				msg += '<li>' + VPL.Msg.bf_email_inv + '</li>';
			}
		}
		if (forgot_email) {
			if (forgot_email.value == '') {
				msg += '<li>' + VPL.Msg.bf_email + '</li>';
			}
			if (forgot_email.value != '' && forgot_email.value.match(re) == null) {
				msg += '<li>' + VPL.Msg.bf_email_inv + '</li>';
			}
		}
		if (password && password.value == '') {
			msg += '<li>' + VPL.Msg.bf_password + '</li>';
		}
		if (login_password && login_password.value == '') {
			msg += '<li>' + VPL.Msg.bf_password + '</li>';
		}
		if (retype_password && retype_password.value == '') {
			msg += '<li>' + VPL.Msg.bf_retype_password + '</li>';
		}
		if ((password && password.value != '') && (retype_password && retype_password.value != '')) {
			if(password.value != retype_password.value)
			{
				msg += '<li>' + VPL.Msg.bf_not_match_password + '</li>';
			}
		}
		if (comment && comment.value == '') {
			msg += '<li>' + VPL.Msg.bf_comment + '</li>';
		}
		if (captcha && captcha.value == '') {
			msg += '<li>' + VPL.Msg.bf_captcha + '</li>';
		}
		
		if (msg != '') {
			err_container.innerHTML = msg;
			err_container.style.display = "block";
		} else {
		
			var folder = document.forms[formName].folder.value;
			
			if(captcha)
			{
				var captcha_inc = VPL.Msg.bf_captcha_inc;
				var param_comment = '';
				if(comment)
				{
					param_comment = "&comment=1";
				}
				JABB.Ajax.sendRequest(folder + 'index.php?controller=pjFront&action=pjActionCheckCaptcha&captcha=' + captcha.value + param_comment, function (resp) {
					var code = resp.responseText;
					if(code == 100){
						document.forms[formName].submit();
					}else{
						msg = '<li>' + captcha_inc + '</li>';
						err_container.innerHTML = msg;
						err_container.style.display = "block";
					}
				});
			}else{
				document.forms[formName].submit();
			}
			
		}
		
		if (event.preventDefault) {
			event.preventDefault();
		}
	}	
};

(function (window, undefined) {
	function VP(options) {
		if (!(this instanceof VP)) {
			return new VP(options);
		}
		this.opts = {};
		this.init.call(this, options);
		return this;
	};
	VP.prototype = {
		bindProperty: function () {
			var date_from = document.getElementById("vpl_date_from"),
				date_to = document.getElementById("vpl_date_to"),
				date_from_api, date_to_api;
			
			if (date_from) {
				date_from_api = new Calendar({
					element: "vpl_date_from",
					disablePast: true,
					dateFormat: this.opts.dateFormat,
					startDay: this.opts.startDay,					
					onSelect: function (element, selectedDate, date, cell) {
						var newDate = new Date(date);
						date_to_api.option({
							"minDate": newDate,
							"month": newDate.getMonth(),
							"year": newDate.getFullYear()
						}).refresh();

						if (date_to_api.selectedDate < newDate) {
							date_to_api.setDate(date);
							date_to_api.element.value = selectedDate;
						}
					}
				});
				var picker_icon_from = document.getElementById("vpl_datepicker_from");
				if (picker_icon_from) {
					picker_icon_from.onclick = function () {
						date_from_api.open();
					};
				}
			}
			if (date_to) {
				date_to_api = new Calendar({
					element: "vpl_date_to",
					disablePast: true,
					dateFormat: this.opts.dateFormat,
					startDay: this.opts.startDay,
					onSelect: function (element, selectedDate, date, cell) {
						
					}
				});
				var picker_icon_to = document.getElementById("vpl_datepicker_to");
				if (picker_icon_to) {
					picker_icon_to.onclick = function () {
						date_to_api.open();
					};
				}
			}
		},
		bindRating: function()
		{
			var $this = this;
			if(document.getElementById("rating_value") != undefined)
			{
				var rating_value = document.getElementById("rating_value").value;
				$this.bindStarHover.call(null, [rating_value]);
				
				var stars = JABB.Utils.getElementsByClass("vpl-star", null, "SPAN");
				for (var i = 0; i < stars.length; i++) {
					stars[i].onmouseover = function (e) {
						var star = this.getAttribute("lang");
						$this.bindStarHover.call(null, [star]);
					};
					stars[i].onmouseout = function (e) {
						var star = document.getElementById("rating_value").value;
						$this.bindStarHover.call(null, [star]);
					};
					stars[i].onclick = function(e){
						var star = this.getAttribute("lang");
						document.getElementById("rating_value").value = star;
					}
				}
			}
		},
		bindStarHover: function(star)
		{
			for(var i = 1; i <= 5; i++)
			{
				if(i <= star)
				{	
					JABB.Utils.addClass(document.getElementById('star_' + i), 'star-hover');
				}else{
					JABB.Utils.removeClass(document.getElementById('star_' + i), 'star-hover');
				}
			}
		},
		bindFilterBox: function()
		{
			var filter_heading = JABB.Utils.getElementsByClass("heading", null, "DIV");
			for (var i = 0; i < filter_heading.length; i++) {
				filter_heading[i].onclick = function(e){
					var parent_node = this.parentNode;
					var status = parent_node.getAttribute("lang");
					if(status == '0')
					{
						JABB.Utils.addClass(parent_node, 'filter-box-active');
						parent_node.setAttribute("lang", "1");
					}else{
						JABB.Utils.removeClass(parent_node, 'filter-box-active');
						parent_node.setAttribute("lang", "0");
					}
				}
			}
		},
		bindItemPerPage: function()
		{
			var paging_options = document.getElementById('vpl_item_per_page');
			if(paging_options != undefined)
			{
				paging_options.onchange = function(e){
					var item = this.options[this.selectedIndex].value,
						url = this.getAttribute('lang') + '&item_per_page=' + item;
					window.location.href = url;
				}
			}
		},
		formatCurrency: function(price, currency)
		{
			var format = '---';
			switch (currency)
			{
				case 'USD':
					format = "$" + price;
					break;
				case 'GBP':
					format = "&pound;" + price;
					break;
				case 'EUR':
					format = "&euro;" + price;
					break;
				case 'JPY':
					format = "&yen;" + price;
					break;
				case 'AUD':
				case 'CAD':
				case 'NZD':
				case 'CHF':
				case 'HKD':
				case 'SGD':
				case 'SEK':
				case 'DKK':
				case 'PLN':
					format = price + currency;
					break;
				case 'NOK':
				case 'HUF':
				case 'CZK':
				case 'ILS':
				case 'MXN':
					format = currency + price;
					break;
				default:
					format = price + $currency;
					break;
			}
			return format;
		},
		init: function (options) {
			this.opts = options;
			this.bindProperty.call(this);
			this.bindRating.call(this);
			this.bindFilterBox.call(this);
			this.bindItemPerPage.call(this);
			return this;
		}
	};
	window.VP = VP;
})(window);

var stivaVP = new VP(VPL.Opts);

var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		if($("#vpl_filter_autocomplete" ).length > 0)
		{
			$( "#vpl_filter_autocomplete" ).autocomplete({
				minLength: 0,
				source: stivaVP.opts.location,
				focus: function( event, ui ) {
				 	$( "#vpl_filter_autocomplete" ).val( ui.item.label );
				 		return false;
			 	},
			 	select: function( event, ui ) {
		 			$( "#vpl_filter_autocomplete" ).val( ui.item.label );
		 			if(ui.item.label != '')
		 			{
		 				var url = $( "#vpl_filter_autocomplete" ).attr('lang') + '&location=' + ui.item.label;
		 				window.location.href = url;
		 			}
		 			return false;
			 	},
			 	open: function () {
			        $(this).data("ui-autocomplete").menu.element.addClass("vpl-autocomplete-ui");
			    }
			 })
			 .data( "ui-autocomplete" )._renderItem = function( ul, item ) {
				 return $( "<li>" )
				 .append( "<a>" + item.label + "</a>" )
				 .appendTo( ul );
			 };
			 $( "#vpl_filter_autocomplete" ).keypress(function (e) {
				 if (e.which == 13) {
					 var url = $( "#vpl_filter_autocomplete" ).attr('lang') + '&location=' + $(this).val();
					 window.location.href = url;
				 }
			 });
		}
		if($('.vpl-season-filter').length > 0)
		{
			$('.vpl-season-filter').click(function() {
				var id = $(this).attr('id');
				if($(this).attr('checked') == 'checked')
				{
					$(this).next('label').addClass('vpl-checkbox-filter-active');
				}else{
					$(this).next('label').removeClass('vpl-checkbox-filter-active');
				}
				var season_arr = [];
				$('.vpl-season-filter').each(function( index ) {
					if($(this).attr('checked') == 'checked')
					{
						season_arr.push($(this).val());
					}
				});
				window.location.href = $(this).attr('lang') + '&season=' + season_arr.join(',');
			});
		}
		if($('.vpl-type-filter').length > 0)
		{
			$('.vpl-type-filter').click(function() {
				var id = $(this).attr('id');
				if($(this).attr('checked') == 'checked')
				{
					$(this).next('label').addClass('vpl-checkbox-filter-active');
				}else{
					$(this).next('label').removeClass('vpl-checkbox-filter-active');
				}
				var type_arr = [];
				$('.vpl-type-filter').each(function( index ) {
					if($(this).attr('checked') == 'checked')
					{
						type_arr.push($(this).val());
					}
				});
				
				window.location.href = $(this).attr('lang') + '&type=' + type_arr.join(',');
			});
		}
		if($('#vpl_rating_slider').length > 0)
		{
			$( "#vpl_rating_slider" ).slider({
				range: true,
				min: 1,
				max: 5,
				values: [ parseInt(stivaVP.opts.rating_from, 10), parseInt(stivaVP.opts.rating_to, 10) ],
				slide: function( event, ui ) {
					
				},
				stop: function( event, ui ) {
					var slider_value_from = parseInt(ui.values[0], 10),
						slider_value_to = parseInt(ui.values[1], 10);
					$( "#vpl_rating_slider" ).slider({ disabled: true });
					var url = $( "#vpl_rating_slider" ).attr('lang');
					window.location.href = url + '&rating_from=' + slider_value_from + '&rating_to=' + slider_value_to;
				}
			});
		}
		
		if($('#vpl_price_slider').length > 0)
		{
			var url = $( "#vpl_price_slider" ).attr('lang'),
				currency = $( "#vpl_filter_price" ).attr('lang');
			$( "#vpl_price_slider" ).slider({
				range: true,
				min: 0,
				max: 1500,
				step: 10,
				values: [ parseInt(stivaVP.opts.price_from, 10), parseInt(stivaVP.opts.price_to, 10) ],
				slide: function( event, ui ) {
					var filter_price_from = stivaVP.formatCurrency(parseInt(ui.values[0], 10), currency),
						filter_price_to = stivaVP.formatCurrency(parseInt(ui.values[1], 10), currency);
					$( "#vpl_filter_price" ).html(filter_price_from + ' - ' + filter_price_to);
				},
				stop: function( event, ui ) {
					var slider_value_from = parseInt(ui.values[0], 10),
						slider_value_to = parseInt(ui.values[1], 10);
					$( "#vpl_price_slider" ).slider({ disabled: true });
					window.location.href = url + '&price_from=' + slider_value_from + '&price_to=' + slider_value_to;
				}
			});
		}
		if($('.vpl-package-pic').length > 0)
		{
			$(".vpl-package-pic").hover(
				function () {
					var id = $(this).attr('lang');
					$('#vpl_package_overlay_' + id).css('display', 'block');
					$('#vpl_package_short_desc_' + id).css('display', 'block');
				}, 
				function () {
					var id = $(this).attr('lang');
					$('#vpl_package_overlay_' + id).css('display', 'none');
					$('#vpl_package_short_desc_' + id).css('display', 'none');
				}
			);
		}
		if($('.vpl-grid-layout2').length > 0)
		{
			$(".vpl-package-grid-box").hover(
				function () {
					var id = $(this).attr('lang');
					$('#vpl_package_overlay_' + id).css('display', 'block');
					$('#vpl_package_short_desc_' + id).css('display', 'block');
				}, 
				function () {
					var id = $(this).attr('lang');
					$('#vpl_package_overlay_' + id).css('display', 'none');
					$('#vpl_package_short_desc_' + id).css('display', 'none');
				}
			);
		}
		
		if($('#vpl_package_totop').length > 0)
		{
			$("#vpl_package_totop").hide();
			$(window).scroll(function () {
				if ($(this).scrollTop() > 200) {
					$('#vpl_package_totop').fadeIn();
				} else {
					$('#vpl_package_totop').fadeOut();
				}
			});
			$('#vpl_package_totop').click(function () {
				$('body,html').animate({
					scrollTop: 0
				}, 800);
				return false;
			});
		}
		
		if($('.vpl-filter-tab').length > 0)
		{
			$('.vpl-filter-tab').click(function() {
				var tab = $(this).attr('lang');
				$('.vpl-content').css('display', 'none');
				$('.vpl-filter-tab').removeClass('vpl-active-tab');
				
				$('.vpl-by'+tab+'-content').css('display', 'block');
				$(this).addClass('vpl-active-tab');
			});
		}
	});
})(jQuery_1_8_2);