var jQuery_1_11_0 = jQuery_1_11_0 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		
		var owlCarousel = ($.fn.owlCarousel !== undefined);
		
		function syncPosition(el) {
			var current = this.currentItem,
				$sync2 = $("#sync2");
			
			$sync2
				.find(".owl-item")
				.removeClass("synced")
				.eq(current)
				.addClass("synced");
			if ($sync2.data("owlCarousel") !== undefined) {
				center.call(null, current);
			}
		}
		
		function center(number) {
			var i,
				sync2visible = sync2.data("owlCarousel").owl.visibleItems,
				num = number,
				found = false;
			
			for (i in sync2visible) {
				if (num === sync2visible[i]) {
					found = true;
				}
			}

			if (found === false) {
				if (num > sync2visible[sync2visible.length - 1]) {
					sync2.trigger("owl.goTo", num - sync2visible.length + 2);
				} else {
					if (num - 1 === -1) {
						num = 0;
					}
					sync2.trigger("owl.goTo", num);
				}
			} else if (num === sync2visible[sync2visible.length - 1]) {
				sync2.trigger("owl.goTo", sync2visible[1])
			} else if (num === sync2visible[0]) {
				sync2.trigger("owl.goTo", num - 1)
			}
		}
		
		if (owlCarousel) {
			
			var sync1 = $("#sync1"),
				sync2 = $("#sync2");
			 
			sync1.owlCarousel({
				singleItem: true,
				slideSpeed: 1000,
				navigation: false,//true
				pagination: false,
				afterAction: syncPosition,
				responsiveRefreshRate: 200
			});
			 
			sync2.owlCarousel({
				items: 5,
				itemsCustom: [
				    [0,1],
				    [480,2],
				    [768,3],
				    [1024,5]
				],
				pagination: false,
				responsiveRefreshRate: 100,
				afterInit: function(el) {
					el.find(".owl-item").eq(0).addClass("synced");
			    }
			});
			 
			$("#sync2").on("click", ".owl-item", function(e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var number = $(this).data("owlItem");
				sync1.trigger("owl.goTo", number);
				return false;
			})
			
			$(document).on("click", ".gallery-prev", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				sync1.trigger("owl.prev");
				return false;
			}).on("click", ".gallery-next", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				sync1.trigger("owl.next");
				return false;
			});
		}
	});
})(jQuery_1_11_0);