var jQuery_1_11_0 = jQuery_1_11_0 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		
		var validate = ($.fn.validate !== undefined),
			datepicker = ($.fn.datepicker !== undefined),
			$formLogin = $("#form-login"),
			$formForgot = $("#form-forgot"),
			$formRegister = $("#form-register"),
			$formSubscribe = $("#form-subscribe"),
			$formContact = $("#form-contact"),
			$formEnquiry = $("#form-enquiry"),
			$formComment = $("#form-comment");
		
		if ($formLogin.length > 0 && validate) {
			$formLogin.validate({
				rules: {
					"login_email": {
						required: true,
						email: true
					},
					"login_password": "required"
				},
				errorClass: "js-error",
				validClass: "js-valid",
				wrapper: "em",
				errorPlacement: function (error, element) {
					error.insertAfter(element.closest(".form-field-wrap"));
				}
			});
		}
		
		if ($formForgot.length > 0 && validate) {
			$formForgot.validate({
				rules: {
					"email": {
						required: true,
						email: true
					}
				},
				errorClass: "js-error",
				validClass: "js-valid",
				wrapper: "em",
				errorPlacement: function (error, element) {
					error.insertAfter(element.closest(".form-field-wrap"));
				}
			});
		}
		
		if ($formRegister.length > 0 && validate) {
			$formRegister.on("click", ".form-captcha", function (e) {
				var $this = $(this);
				$this.attr("src", $this.attr("src").replace(/(\?rand=)(\d+)/, '\$1' + Math.floor(Math.random() * 999999)));
			}).validate({
				rules: {
					"email": {
						required: true,
						email: true
					},
					"password": "required",
					"retype_password": {
						required: true,
						equalTo: "#password"
					},
					"name": "required",
					"captcha": {
						required: true,
						minlength: 6,
						maxlength: 6,
						remote: tConfig.folder + "checkCaptcha/"
					}
				},
				onkeyup: false,
				errorClass: "js-error",
				validClass: "js-valid",
				wrapper: "em",
				errorPlacement: function (error, element) {
					error.insertAfter(element.closest(".form-field-wrap"));
				}
			});
		}
		
		if ($formSubscribe.length > 0 && validate) {
			$formSubscribe.validate({
				rules: {
					"subscriber_email": {
						required: true,
						email: true
					}
				},
				onkeyup: false,
				onclick: false,
				onfocusout: false,
				errorClass: "js-error",
				validClass: "js-valid",
				wrapper: "em",
				errorPlacement: function (error, element) {
					error.insertAfter(element.closest(".form-field-wrap"));
				},
				submitHandler: function (form) {
					var $form = $(form);
					$.post($form.attr("action"), $form.serialize()).done(function (data) {
						if (data.status == 'OK') {
							$form.find("#subscriber_email").val("").removeClass("js-valid js-error").focus();
						}
						$form.find(".form-message").html(data.text).show();
					});
					return false;
				}
			});
		}
		
		if ($formContact.length > 0 && validate) {
			$formContact.on("click", ".form-captcha", function (e) {
				var $this = $(this);
				$this.attr("src", $this.attr("src").replace(/(\?rand=)(\d+)/, '\$1' + Math.floor(Math.random() * 999999)));
			}).validate({
				rules: {
					"name": "required",
					"email": {
						required: true,
						email: true
					},
					"phone": "required",
					"question": "required",
					"captcha": {
						required: true,
						minlength: 6,
						maxlength: 6,
						remote: tConfig.folder + "checkCaptcha/"
					}
				},
				onkeyup: false,
				onclick: false,
				onfocusout: false,
				errorClass: "js-error",
				validClass: "js-valid",
				wrapper: "em",
				errorPlacement: function (error, element) {
					error.insertAfter(element.closest(".form-field-wrap"));
				}
			});
		}
		
		if ($formEnquiry.length > 0 && validate) {
			$formEnquiry.on("click", ".form-captcha", function (e) {
				var $this = $(this);
				$this.attr("src", $this.attr("src").replace(/(\?rand=)(\d+)/, '\$1' + Math.floor(Math.random() * 999999)));
			});
			var validatorEnquiry = $formEnquiry.validate({
				rules: {
					"name": "required",
					"email": {
						required: true,
						email: true
					},
					"phone": "required",
					"date_from": "required",
					"date_to": "required",
					"notes": "required",
					"captcha": {
						required: true,
						minlength: 6,
						maxlength: 6,
						remote: tConfig.folder + "checkCaptcha/"
					}
				},
				onkeyup: false,
				onclick: false,
				onfocusout: false,
				errorClass: "js-error",
				validClass: "js-valid",
				wrapper: "em",
				errorPlacement: function (error, element) {
					error.insertAfter(element.closest(".form-field-wrap"));
				},
				submitHandler: function (form) {
					var $form = $(form);
					$.post(tConfig.folder + "enquiry/", $form.serialize()).done(function (data) {
						if (data.status == "OK") {
							$form.find(":input").removeClass("js-valid js-error");
							form.reset();
							validatorEnquiry.resetForm();
							$formEnquiry.find(".form-captcha").trigger("click");
						}
						$form.find(".form-message").html(data.text).show();
					});
					return false;
				}
			});
		}
		
		if ($formComment.length > 0 && validate) {
			$formComment.on("click", ".form-captcha", function (e) {
				var $this = $(this);
				$this.attr("src", $this.attr("src").replace(/(\?rand=)(\d+)/, '\$1' + Math.floor(Math.random() * 999999)));
			}).on("click", ".form-rating-star", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = $(this);
				$("input[name='rating']").val( $this.data("rating") );
				$this
					.siblings().addBack().removeClass("form-rating-star-active")
					.end().end()
					.prevAll().addBack().addClass("form-rating-star-active");
				return false;
			}).on("mouseenter", ".form-rating-star", function (e) {
				$(this).prevAll().addClass("form-rating-star-hover");
			}).on("mouseleave", ".form-rating-star", function (e) {
				$(this).prevAll().removeClass("form-rating-star-hover");
			}).on("reset", function (e) {
				$(this).slideUp();
				$(".selector-comment-form-toggle").show();
			})
			
			var validatorComment = $formComment.validate({
				rules: {
					"name": "required",
					"email": {
						required: true,
						email: true
					},
					"title": "required",
					"comment": "required",
					"captcha": {
						required: true,
						minlength: 6,
						maxlength: 6,
						remote: tConfig.folder + "checkCaptcha/?comment"
					}
				},
				onkeyup: false,
				onclick: false,
				onfocusout: false,
				errorClass: "js-error",
				validClass: "js-valid",
				wrapper: "em",
				errorPlacement: function (error, element) {
					error.insertAfter(element.closest(".form-field-wrap"));
				},
				submitHandler: function (form) {
					var $form = $(form);
					$.post(tConfig.folder + "comment/", $form.serialize()).done(function (data) {
						if (data.status == "OK") {
							$form.find(":input").removeClass("js-valid js-error");
							form.reset();
							validatorComment.resetForm();
							$formComment.find(".form-captcha").trigger("click");
							
							$.get([tConfig.folder, "getComments/", $form.find("input[name='listing_id']").val(), "/"].join("")).done(function (data) {
								$("#comments-box").html(data);
							});
						}
					});
					return false;
				}
			});
		}
		
		$(document).on("focusin", ".form-field-date", function () {
			var $this = $(this);
			if (datepicker) {
				$this.datepicker({
					firstDay: $this.attr("data-first"),
					dateFormat: $this.attr("data-format"),
					minDate: 0
				});
			}
		}).on("click", ".selector-comment-form-toggle", function (e) {
			$(this).hide();
			$("#form-comment").slideToggle();
		});
	});
})(jQuery_1_11_0);