var jQuery_1_11_0 = jQuery_1_11_0 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		
		var owlCarousel = ($.fn.owlCarousel !== undefined);
		
		if (owlCarousel) {
			var owlOptions = {
				items: 3,
				itemsCustom: [
				    [0,1],
				    [480,2],
				    [768,2],
				    [1024,3]
				],
				scrollPerPage: true,
				pagination: false
			};
			
			$("#carousel-featured").owlCarousel(owlOptions);
			$("#carousel-deals").owlCarousel(owlOptions);
			
			$("#carousel-landing").owlCarousel($.extend(owlOptions, {
				autoPlay: 5000,
				stopOnHover: true,
				itemsCustom: [
				    [0,1],
				    [767,2],
				    [989,3]
				]
			}));
			
			$(document).on("click", ".landing-prev", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$("#carousel-landing").data('owlCarousel').prev();
				return false;
			}).on("click", ".landing-next", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$("#carousel-landing").data('owlCarousel').next();
				return false;
			}).on("click", ".featured-prev", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$("#carousel-featured").data('owlCarousel').prev();
				return false;
			}).on("click", ".featured-next", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$("#carousel-featured").data('owlCarousel').next();
				return false;
			}).on("click", ".deals-prev", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$("#carousel-deals").data('owlCarousel').prev();
				return false;
			}).on("click", ".deals-next", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$("#carousel-deals").data('owlCarousel').next();
				return false;
			});
		}
	});
})(jQuery_1_11_0);