<?php

Doo::loadHelper('DooPager');
Doo::loadLibrary('request');
Doo::loadLibrary('service');
Doo::loadLibrary('form');

# 后台 auth

class base extends DooController{
    
    public $ip;
    public $request;
    public $time;
    public $admin;
    public $data;
    public $page;
    public $host;
    /*
     * ##### 保留的名称 #####
     * tid
     * name
     * from
     */

    private $hash_string;
    
    public function beforeRun($controller, $method){
        $this->host = 'http://'.$_SERVER['HTTP_HOST'].'/'.CATALOG;
        # 1.one
        $doo = Doo::session(Doo::conf()->SESSION_NAME);
        if (!$doo->uid || !$doo->rnd){
            $this->loginPage();
            return;
        }
        $this->ip = $ip = $this->clientIP();
        # 2.two
        $session_md5 = md5(md5($doo->rnd.'-JsonClouds.Com').'-'.$ip.'-'.$_SERVER['HTTP_USER_AGENT'].'-'.$doo->uid.'-'.$doo->admin.'-'.$doo->rnd);
        if ($doo->md5 <> $session_md5){
            $this->loginPage();
            return;
        }
        # 3.three
        $cache_file = 'admin_login_'.$doo->uid.'_'.md5(md5($doo->admin.'-JsonClouds.Com.file'.$doo->truetime.'-'.$doo->rnd).'-'.$ip.'-'.$doo->uid.'-'.$doo->rnd).'.cache';
        $path = Doo::conf()->ADMIN_PATH.'cache/login/';
        if (!file_exists($path.$cache_file)){
            $this->loginPage();
            return;
        }
        # 4.four
        $cache_content = file_get_contents($path.$cache_file);
        list($id, $hash_field, $hash_value, $login_hash) = explode('=', $cache_content);
        if (!$login_hash || $login_hash <> $doo->ckrnd){
            $this->loginPage();
            return;
        }
        $this->hash_string = $hash_field.'='.$hash_value;
        # 5.five        
        $this->request = $request = new request();
        if ($request->hasQuery($hash_field) && $request->getQuery($hash_field) == $hash_value){
            # get
        }elseif ($request->hasPost($hash_field) && $request->getPost($hash_field) == $hash_value){
            # post
        }else{
            $this->loginPage();
            return;
        }
        # 6.six
        Doo::loadModel('Admin', false, true);
        $admin = new Admin();
        $admin->id = $id;
        $admin->rnd = $doo->rnd;
        $admin->checked = 1;
        $db = $admin->getOne(array('asArray' => true));
        if ($db){
            # have
        }else{
            $this->loginPage();
            return;
        }
        # 7.seven
        Doo::loadModel('AdminRnd', false, true);
        $ar = new AdminRnd();
        $ar->id = $id;
        $arDB = $ar->getOne(array('asArray' => true));
        $sql_rnd = md5(md5($doo->rnd.'-'.$doo->uid.'-JsonClouds.Com.auth'.$doo->truetime.'-').'-'.$ip.'-'.$doo->uid.$doo->rnd);
        if (empty($arDB) || $arDB['rnd'] <> $sql_rnd){
            $this->loginPage();
            return;
        }
        # 8.eight
        $this->time = time();
        if ($doo->last){
            if ($this->time - $doo->last >= 3600){
                $doo->rnd = '';
                $this->loginPage();
                return;
            }
            $doo->last = $this->time;
        }
        $this->admin = $db;        
        $this->_page();   
        $this->_data();
        if ($db['level'] == 1 || $controller == 'frame'){
            # 系统管理员
            # allow
        }else{
            # check it
            $this->_perm($db['level'], $controller, $method);
        }
        $this->_hooks($controller, $method);
        # 全局钩子
        service::do_action('base', array($this));
    }
    
    private function _hooks($controller, $method){
        # hook
        Doo::loadClass('hooks');
        $action = $controller.'_'.$method;
        service::do_action($action, array($this));
    }
    
    private function _page(){
        $this->page = $this->request->has('page') ? $this->request->get('page', 'int') : 1;
    }
    
    private function _perm($level, $controller, $method){
        if (strstr($method, 'AJAX')){
            $method = str_replace('AJAX', '', $method);
        }
        $db = service::common_get_one('AdminAccess', array(
            'model_id' => PROJECT_ID,
            'level' => $level,
            'controller' => $controller,
            'method' => $method
        ), false, true);
        if ($db){
            # allow
        }else{
            # deny
            if ($this->request->isAjax() == true){
                echo "<权限不足>你无权操作";
                exit;
            }else{
                $this->message('你无权访问此页面', '<权限不足>');                
            }
        }
    }
    
    private function _data(){
        $this->data = array(
            'admin' => $this->admin, # 后台用户数据
            'base' => $this, # 句柄
            'base_url' => $this->host.ROOT_ADMIN.'/', # admin 地址
            'page' => $this->page, # 分页
            'host' => $this->host, # 域名
            'hashString' => $this->hash_string, # 后台校验码
            'current_url' => $this->host.PROJECT.'/' # 当前项目地址
        );
    }
    
    private function loginPage(){
        $this->renderc_admin("admin/login");
        exit(1);
    }
    
    public function get_url($params = array()){
        $url = $this->host.ROOT_ADMIN.'/index.php?c='.$params['c'].'&'.$this->hash_string;
        unset($params['c']);
        if ($params){
            foreach ($params as $field=>$value){
                $url .= '&'.$field.'='.$value;
            }
        }
        return $url;
    }
    
    public function get_model_url($params = array()){
        $url = $this->host.PROJECT.'/index.php?c='.$params['c'].'&'.$this->hash_string;
        unset($params['c']);
        if ($params){
            foreach ($params as $field=>$value){
                $url .= '&'.$field.'='.$value;
            }
        }
        return $url;
    }
    
    public function message($title, $msg, $jump = ''){
        $this->data['title'] = $title;
        $this->data['content'] = $msg;
        if (empty($jump)){
            $jump = "javascript:history.back();";
        }
        $this->data['jump'] = $jump;
        $this->renderc_admin('admin/message', $this->data);
        exit(1);
    }
    
    # get
    public function http_get_id($param = 'cid'){
        $field = 0;
        if ($this->request->hasQuery($param)){
            $field = intval($this->request->get($param, 'int'));
        }
        $this->data[$param] = $field;
        return $field;
    }
    
    public function get_model($cid){
        $channels = service::channels(true);
        return $channels[$cid];
    }
    
    # form ajax post check
    public function http_ajax_post($nonce = ''){
        if ($this->request->isPost() == true && $this->request->isAjax() == true){
            if (form::verify_nonce($this->admin['id'], $this->request->getPost('_nonce'), $nonce)){
                return true;
            }
        }
        return false;
    }
}
