<?php

Doo::loadController('base');

# 模块管理

class channel extends base{
    
    private function _exits(){
        $opt = array(
            'asArray' => true,
            'where' => 'id = ?',
            'param' => array(intval($this->request->get('id', 'int')))
        );
        $db = Doo::db()->getOne('AdminChannel', $opt);
        if (empty($db)){
            $this->message('没有找到这个模块系统', '<请检查是否有添加此模块>');
        }else{
            return $db;
        }
    }
    
    public function index(){
        $this->data['result'] = service::common_query('AdminChannel', $this->get_url(array('c' => 'channel')), $this->page);
        $this->renderc('channel/index', $this->data);
    }
    
    public function open(){
        $db = $this->_exits();
        $status = $db['status'] == 1 ? 0 : 1;
        Doo::loadModel('AdminChannel');
        $ac = new AdminChannel();
        $ac->id = $db['id'];
        $ac->status = $status;
        $ac->update();
        $this->message('此模块系统', '<'.($status ? '已开启' : '已关闭').'>', $this->get_url(array('c' => 'channel')));
    }
    
    public function create(){
        $this->renderc('channel/create', $this->data);
    }
    
    public function edit(){
        $this->data['db'] = $this->_exits();
        $this->renderc('channel/edit', $this->data);
    }
    
    public function delete(){
        if ($this->http_ajax_post('deleteChannel')){
            $id = intval($this->request->getPost('id', 'int'));
            Doo::loadModel('AdminChannel');
            $ac = new AdminChannel();
            $ac->id = $id;
            $db = $ac->getOne(array('asArray' => true));
            if (empty($db)){
                echo "<模块>不存在";
                return;
            }
            $pre = $db['path'];
            $ac->delete();
            # 删除所有数据表前缀为 {$pre}_ 的数据表
            Doo::loadCore('db/manage/adapters/DooManageMySqlDb');
            $MDB = new DooManageMySqlDb();
            $list = $MDB->tables();
            if ($list){
                foreach ($list as $table){
                    $name = current($table);
                    if ($name == 'admin' || strstr($name, 'admin_')){
                        // no no ...
                    }else{
                        // yes
                        if ($name == $pre || strstr($name, $pre.'_')){
                            $MDB->dropTable($name);
                        }
                    }
                }
            }
            echo "ok";
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function editAJAX(){
        if ($this->http_ajax_post('editChannel')){
            $id = intval($this->request->getPost('id', 'int'));
            $name = $this->request->getPost('name');
            if (empty($name)){
                echo "请输入系统名称";
                return;
            }
            $checkid = $this->_check_name('name', $name);
            if ($checkid && $checkid <> $id){
                echo "<系统名称>已存在";
                return;
            }
            $path = $this->request->getPost('path', 'alphanum');
            if (empty($path)){
                echo "请输入系统目录";
                return;
            }
            $checkid = $this->_check_name('path', $path);
            if ($checkid && $checkid <> $id){
                echo "<系统目录>已存在";
                return;
            }
            Doo::loadModel('AdminChannel');
            $ac = new AdminChannel;
            $ac->id = $id;
            $db = $ac->getOne();
            if ($db->name == $name && $db->path == $path){
                echo "ok";
                return;
            }
            $db->name = $name;
            $db->path = $path;
            if ($db->update()){
                // success
                echo 'ok';
            }else{
                echo '<数据>更新失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    private function _check_name($field = 'name', $value = ''){
        if (($field == 'name' && $value == '系统核心模块') || ($field == 'path' && $value == ROOT_ADMIN)){
            return true;
        }
        Doo::loadModel('AdminChannel');
        $ac = new AdminChannel();
        $ac->$field = $value;
        $db = $ac->getOne();
        return $db ? $db->id : 0;
    }
    
    public function createAJAX(){
        if ($this->http_ajax_post('createChannel')){
            $name = $this->request->getPost('name');
            if (empty($name)){
                echo "请输入系统名称";
                return;
            }
            $checkid = $this->_check_name('name', $name);
            if ($checkid){
                echo "<系统名称>你输入的已存在";
                return;
            }
            $path = $this->request->getPost('path', 'alphanum');
            if (empty($path)){
                echo "请输入系统目录";
                return;
            }
            $checkid = $this->_check_name('path', $path);
            if ($checkid){
                echo "<系统目录>你输入的已存在";
                return;
            }
            Doo::loadModel('AdminChannel');
            $ac = new AdminChannel();
            $ac->name = $name;
            $ac->path = $path;
            $ac->status = 0;
            $ac->installed = 0;
            if ($ac->insert()){
                // success
                echo 'ok';
            }else{
                echo '<数据>写入失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }

}
