<?php

Doo::loadController('base');

# 数据表管理

class database extends base{        
    
    public function index(){
        $cid = $this->http_get_id();
        $channels = service::channels();
        ksort($channels);
        unset($channels[0]);
        $this->data['channels'] = $channels;
        if (!$cid){
            $current = current($channels);
            $cid = $current['id'];
            $this->data['cid'] = $cid;
        }
        $option = array(
            'desc' => 'id', 'where' => 'model_id = ? and fid = 0', 'param' => array($cid)
        );
        $this->data['result'] = service::common_query('AdminTable', $this->get_url(array('c' => 'database', 'cid' => $cid)), $this->page, $option);
        $this->renderc('database/index', $this->data);
    }
    
    public function search(){
        $cid = $this->http_get_id();
        $tid = $this->http_get_id('tid');
        $db = service::common_get_one('AdminTable', array('id' => $tid, 'model_id' => $cid));
        if (empty($db)){
            $this->message('这个数据表不存在', '点击确认返回');
        }
        $this->data['db'] = $db;
        $this->data['fields'] = service::common_index_by_id('AdminField', array('asc' => '_orderby, id', 'where' => 'tid = ? and _soso = 1', 'param' => array($tid)));
        $this->renderc('database/search', $this->data);
    }
    
    public function filtrate(){
        $cid = $this->http_get_id();
        $tid = $this->http_get_id('tid');
        $id = $this->http_get_id('id');
        $db = service::common_get_one('AdminTable', array('id' => $tid, 'model_id' => $cid));
        if (empty($db)){
            $this->message('这个数据表不存在', '点击确认返回');
        }
        $rs = service::common_get_one('AdminField', array('id' => $id, '_soso' => 1));
        if (empty($rs)){
            $this->message('你要设置的字段不是筛选项', '点击确认返回');
        }
        $this->data['db'] = $db;
        $this->data['rs'] = $rs;
        $this->renderc('database/filtrate', $this->data);
    }
    
    public function optionAJAX(){
        if ($this->http_ajax_post('setOption')){
            $content = $this->request->getPost('content');
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminField', array('id' => $id, '_soso' => 1), false);
            if ($db->_options == $content){
                echo 'ok';
                return;
            }
            $db->_options = $content;
            if ($db->update()){
                echo 'ok';
            }else{
                echo '<数据>更新失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function childTable(){
        $cid = $this->http_get_id();
        $tid = $this->http_get_id('tid');
        $db = service::common_get_one('AdminTable', array('id' => $tid, 'model_id' => $cid)); 
        $option = array(
            'desc' => 'id', 'where' => 'model_id = ? and fid = ?', 'param' => array($cid, $tid)
        );
        $this->data['db'] = $db;        
        $this->data['result'] = service::common_query('AdminTable', $this->get_url(array('c' => 'database', 'm' => 'childTable', 'cid' => $cid, 'tid' => $tid)), $this->page, $option);        
        $this->renderc('database/childTable', $this->data);
    }
    
    private function _forms(){
        $types = array(
            array('type' => 'text', 'name' => '简短 (R)'),
            array('type' => 'int', 'name' => '整数 (R)'),
            array('type' => 'float', 'name' => '小数'),
            array('type' => 'select', 'name' => '下拉.文本 (R)'),
            array('type' => 'select_int', 'name' => '下拉.数字 (R)'),
            array('type' => 'textarea', 'name' => '文本'),
            array('type' => 'radio', 'name' => '单选.文本'),
            array('type' => 'radio_int', 'name' => '单选.数字'),
            array('type' => 'checkbox', 'name' => '多选'),
            array('type' => 'singleImage', 'name' => '单图'),
            array('type' => 'groupPictures', 'name' => '组图'),
            array('type' => 'timepicker', 'name' => '时间'),
            array('type' => 'editor', 'name' => '编辑器')
        );
        $types = service::do_action('_database_fields', array($this, $types), 1); 
        $this->data['_forms'] = $types;
    }
    
    private function _default_arr($content){
        $arrs = array();
        $ex = explode("\n", $content);
        if ($ex){
            foreach ($ex as $v){
                if ($v){
                    list($id, $name) = explode('=', $v);
                    $arrs[$id] = array('id' => $id, 'name' => $name);
                }
            }
        }
        return $arrs;
    }
    
    public function ajaxView(){
        $tid = intval($this->request->get('connect_id', 'int'));
        $table = service::common_get_one('AdminTable', array('id' => $tid));
        $fields = service::common_index_by_id('AdminField', array(
            'asc' => '_orderby, id',
            'where' => 'tid = ?',
            'param' => array($tid)
        ));
        $shows = array();
        $lists = array();
        if ($fields){
            foreach ($fields as $field){
                if ($field['_view']){
                    $shows[$field['name']] = $field;
                }
                switch ($field['_form']){
                    case 'select':
                    case 'radio':
                    case 'checkbox':
                    case 'radio_int':
                    case 'select_int':
                        $field['content'] = $this->_default_arr($field['content']);
                        break;
                }
                $lists[$field['name']] = $field;
            }
        }
        $url = $this->get_url(array('c' => 'database', 'm' => 'ajaxView', 'connect_id' => $tid));
        $options = array();
        $key = '';
        if ($this->request->hasQuery('key')){
            $key = $this->request->get('key');
            $first = current($shows);
            $firstField = $first['name'];
            $options['where'] = $firstField.' like ?';
            $options['param'] = array('%'. str_replace('%20', ' ', $key).'%');
            $url = $this->get_url(array('c' => 'database', 'm' => 'ajaxView', 'connect_id' => $tid, 'key' => $key));
        }
        $model = $table['mode'];
        Doo::loader($model, ROOT.$table['model'].'/model/');
        $object = new $model();
        $pager = new DooPager($url, $object->count($options), 20, 6);
        $pager->paginate($this->page, 0, 'javascript:_data_ajax_page');
        $options['asArray'] = true;
        $data = $object->limit($pager->limit, null, 'id', $options);
        $output = $pager->totalItem ? $pager->output : '';
        $this->data['lists'] = $data;
        $this->data['pager'] = $output;
        $this->data['url'] = $url;
        $this->data['table'] = $table;
        $this->data['shows'] = $shows;
        $this->data['fields'] = $lists;
        $this->data['key'] = $key;
        $this->renderc('database/ajaxView', $this->data);
    }
    
    public function ajaxFetch(){
        $tid = intval($this->request->get('tid'));
        $val = $this->request->get('val');
        $table = service::common_get_one('AdminTable', array('id' => $tid));        
        $field = $table['_connect'];
        $model = $table['mode'];
        Doo::loader($model, ROOT.$table['model'].'/model/');
        $object = new $model();
        $list = $object->find(array(
            'where' => 'id in ('.$val.')',
            'asArray' => true
        ));
        $ret = array();
        if ($list){
            foreach ($list as $item){
                $ret[] = $item[$field];
            }
        }
        if ($ret){
            echo implode(',', $ret);
        }
    }
    
    public function fields(){
        $cid = $this->http_get_id();
        $id = intval($this->request->get('id', 'int'));
        $db = service::common_get_one('AdminTable', array('id' => $id, 'model_id' => $cid));
        if (empty($db)){
            $this->message('这个数据表不存在', '点击确认返回');
        }
        $this->data['db'] = $db;
        $this->data['fields'] = service::common_index_by_id('AdminField', array('asc' => '_orderby, id', 'where' => 'tid = ?', 'param' => array($id)));
        $this->data['count'] = service::common_count('AdminTable', array('where' => 'fid = ?', 'param' => array($id)));
        $this->data['up'] = service::common_get_one('AdminTable', array('id' => $db['fid'], 'model_id' => $cid)); 
        $this->renderc('database/fields', $this->data);
    }
    
    public function createField(){
        $cid = $this->http_get_id();
        $tid = $this->http_get_id('tid');
        $this->data['db'] = service::common_get_one('AdminTable', array('id' => $tid, 'model_id' => $cid));        
        $this->_forms();
        $this->data['connect'] = service::common_index_by_id('AdminTable', array('asc' => 'id'));
        $this->renderc('database/createField', $this->data);
    }
    
    public function editField(){
        $id = $this->http_get_id('id');
        $db = service::common_get_one('AdminField', array('id' => $id));
        if (empty($db)){
            $this->message('你要编辑的字段不存在', '点击确认返回');
        }
        $cid = $this->http_get_id();
        $tid = $this->http_get_id('tid');
        $this->data['db'] = service::common_get_one('AdminTable', array('id' => $tid, 'model_id' => $cid));
        $this->data['field'] = $db;
        $this->data['connect'] = service::common_index_by_id('AdminTable', array('asc' => 'id'));
        $this->_forms();
        $this->renderc('database/editField', $this->data);
    }
    
    private function _default_name($tid){
        $tid = intval($this->request->get('tid'));
        Doo::loadModel('AdminField');
        $af = new AdminField();
        $af->tid = $tid;
        $af->_view = 1;
        $firstField = $af->getOne(array('asc' => '_orderby', 'asArray' => true));
        $field = $firstField['name'];
        Doo::loadModel('AdminTable');
        $at = new AdminTable();
        $at->id = $tid;
        $at->_connect = $field;
        $at->update();
    }
    
    private function _create_field($_form, $table, $name, $oldname = '', $connect_id = 0){
        $query = "";
        $act = $oldname ? 'change '.$oldname : 'add';
        switch ($_form){
            case 'text':
            case 'singleImage':
            case 'select':
            case 'checkbox':
            case 'radio':
                $query = "ALTER TABLE `".$table['full_name']."` ".$act." `".$name."` varchar(200) not null default ''";
                break;
            case 'textarea':
            case 'groupPictures':
                $query = "ALTER TABLE `".$table['full_name']."` ".$act." `".$name."` text not null";
                break;
            case 'editor':
                $query = "ALTER TABLE `".$table['full_name']."` ".$act." `".$name."` mediumtext not null";
                break;
            case 'select_int':
            case 'radio_int':
            case 'int':
            case 'timepicker':
                $query = "ALTER TABLE `".$table['full_name']."` ".$act." `".$name."` int(10) not null default '0'";
                break;
            case 'float':
                $query = "ALTER TABLE `".$table['full_name']."` ".$act." `".$name."` float(10,2) not null default '0.00'";
                break;
        }
        if ($query){
            $query = service::do_action('_database_create_field', array($this, $query, $_form), 1);
            Doo::db()->query($query);
            if ($connect_id){
                $act = $oldname ? 'change '.$oldname.'_value' : 'add';
                $query = "ALTER TABLE `".$table['full_name']."` ".$act." `".$name."_value` varchar(200) not null default ''";
                Doo::db()->query($query);
            }
        }
    }
    
    private function _reserved($field = ''){
        $reserved = array('add', 'all', 'alter', 'analyze', 'and', 'as', 'asc', 'asensitive', 'before', 'between',
            'bigint', 'binary', 'blob', 'both', 'by', 'call', 'cascade', 'case', 'change', 'char', 'character',
            'maxvalue', 'check', 'collate', 'column', 'condition', 'connection', 'constraint', 'continue', 'convert', 'create',
            'cross', 'current_date', 'current_time', 'current_timestamp', 'current_user', 'cursor', 'database', 'databases',
            'day_hour', 'day_microsecond', 'day_minute', 'day_second', 'dec', 'decimal', 'declare', 'default', 'delayed',
            'delete', 'desc', 'describe', 'deterministic', 'distinct', 'distinctrow', 'div', 'double', 'drop', 'dual',
            'each', 'else', 'elseif', 'enclosed', 'escaped', 'exists', 'exit', 'explain', 'false', 'fetch', 'float',
            'float4', 'float8', 'for', 'force', 'foreign', 'from', 'fulltext', 'goto', 'grant', 'group', 'having',
            'high_priority', 'hour_microsecond', 'hour_minute', 'hour_second', 'if', 'ignore', 'in', 'index', 'infile',
            'inner', 'inout', 'insensitive', 'insert', 'int', 'int1', 'int2', 'int3', 'int4', 'int8', 'integer', 'interval',
            'into', 'is', 'iterate', 'join', 'key', 'keys', 'kill', 'label', 'leading', 'leave', 'left', 'like', 'limit',
            'linear', 'localtimestamp', 'match', 'minute_microsecond', 'low_priority', 'minute_second', 'natural',
            'middleint', 'no_write_to_binlog', 'mediumtext', 'longtext', 'primary', 'procedure', 'option', 'not',
            'lines', 'load', 'localtime', 'lock', 'long', 'loop', 'longblob', 'mediumblob', 'mediumint', 'mod',
            'modifies', 'null', 'numeric', 'optimize', 'on', 'optionally', 'or', 'order', 'out', 'outer', 'outfile',
            'precision', 'purge', 'raid0', 'range', 'read', 'reads', 'real', 'references', 'regexp', 'release', 'rename',
            'repeat', 'replace', 'require', 'restrict', 'return', 'revoke', 'right', 'rlike', 'schema', 'schemas',
            'second_microsecond', 'select', 'sensitive', 'separator', 'set', 'show', 'smallint', 'spatial', 'specific',
            'sql', 'sqlexception', 'sqlstate', 'sqlwarning', 'sql_big_result', 'sql_calc_found_rows', 'sql_small_result',
            'ssl', 'starting', 'straight_join', 'table', 'terminated', 'then', 'tinyblob', 'tinyint', 'tinytext', 'to',
            'trailing', 'trigger', 'true', 'undo', 'union', 'unique', 'unlock', 'unsigned', 'update', 'usage', 'use',
            'using', 'utc_date', 'utc_time', 'utc_timestamp', 'values', 'varbinary', 'varchar', 'varcharacter', 'varying',
            'when', 'where', 'while', 'with', 'write', 'x509', 'xor', 'year_month', 'zerofill', 'time', 'date', 'id', 'adminid',
            'dateline');
        if (in_array($field, $reserved)){
            echo $field.'为系统保留字';
            exit;
        }
    }
    
    public function changeView(){
        if ($this->request->isPost() == true && $this->request->isAjax() == true){
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminField', array('id' => $id), false);
            $_view = $db->_view ? 0 : 1;
            $db->_view = $_view;
            $db->update();
            echo $_view;
        }
    }
    
    public function changeSoso(){
        if ($this->request->isPost() == true && $this->request->isAjax() == true){
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminField', array('id' => $id), false);
            $_soso = $db->_soso ? 0 : 1;
            $db->_soso = $_soso;
            $db->update();
            echo $_soso;
        }
    }
    
    public function createFieldAJAX(){
        if ($this->http_ajax_post('createField')){
            $tid = intval($this->request->getPost('tid', 'int'));
            $_form = $this->request->getPost('_form');
            if (empty($_form)){
                echo "<请选择>类型";
                return;
            }
            $name = $this->request->getPost('name', 'alphanum');
            if (empty($name)){
                echo "<请输入>字段名";
                return;
            }
            $this->_reserved($name);
            $tag = $this->request->getPost('tag');
            if (empty($tag)){
                echo "<请输入>简称";
                return;
            }
            $connect_id = intval($this->request->getPost('connect_id', 'int'));
            $connect = array();
            if ($connect_id){
                $connect = service::common_get_one('AdminTable', array('id' => $connect_id));
            }
            $table = service::common_get_one('AdminTable', array('id' => $tid));
            if (empty($table)){
                echo "<数据模型>不存在";
                return;
            }
            $content = $this->request->getPost('content');
            if ($connect_id == 0 && in_array($_form, array('select', 'checkbox', 'radio')) && empty($content)){
                echo "<默认值>不能为空";
                return;
            }
            # 创建字段
            if ($connect_id && $_form == 'select'){
                $this->_create_field('int', $table, $name, '', $connect_id);
            }else{
                $this->_create_field($_form, $table, $name, '', $connect_id);
            }
            # 写入数据
            Doo::loadModel('AdminField');
            $af = new AdminField();
            $af->tid = $tid;
            $af->name = $name;
            $af->tag = $tag;
            $af->_form = $_form;
            $af->dateline = time();
            $af->connect_id = $connect_id;
            $af->connect_table = $connect ? $connect['full_name'] : '';
            $af->content = $content;
            $af->_must = intval($this->request->getPost('_must', 'int'));
            if ($af->insert()){
                $this->_default_name($tid);
                echo 'ok';
            }else{
                echo '<数据>写入失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function editFieldAJAX(){
        if ($this->http_ajax_post('editField')){
            Doo::loadCore('db/manage/adapters/DooManageMySqlDb');
            $MDB = new DooManageMySqlDb();
            $tid = intval($this->request->getPost('tid', 'int'));
            $_form = $this->request->getPost('_form');
            if (empty($_form)){
                echo "<请选择>类型";
                return;
            }
            $name = $this->request->getPost('name', 'alphanum');
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminField', array('id' => $id));
            if (empty($db)){
                echo "<字段>不存在";
                return;
            }
            if (empty($name)){
                echo "<请输入>字段名";
                return;
            }
            $this->_reserved($name);
            $table = service::common_get_one('AdminTable', array('id' => $tid));
            if (empty($table)){
                echo '<数据表>不存在';
                return;
            }
            # 检查字段是否存在
            if ($name != $db['name']){                  
                $exits = $MDB->columnExists($table['full_name'], $name);
                if ($exits){
                    echo "<字段名>已存在";
                    return;
                }
            }
            $tag = $this->request->getPost('tag');
            if (empty($tag)){
                echo "<请输入>简称";
                return;
            }
            $connect_id = intval($this->request->getPost('connect_id', 'int'));
            $connect = array();
            if ($connect_id){
                $connect = service::common_get_one('AdminTable', array('id' => $connect_id));
            }
            $content = $this->request->getPost('content');
            if ($connect_id == 0 && in_array($_form, array('select', 'checkbox', 'radio')) && empty($content)){
                echo "<默认值>不能为空";
                return;
            }
            # 创建字段
            if ($connect_id && $_form == 'select'){
                $this->_create_field('int', $table, $name, $db['name'], $connect_id);
            }else{
                $this->_create_field($_form, $table, $name, $db['name'], $connect_id);
            }
            # 更新数据
            Doo::loadModel('AdminField');
            $af = new AdminField();
            $af->id = $id;
            $af->name = $name;
            $af->tag = $tag;
            $af->_form = $_form;
            $af->dateline = time();
            $af->connect_id = $connect_id;
            $af->connect_table = $connect ? $connect['full_name'] : '';
            $af->content = $content;
            $af->_must = intval($this->request->getPost('_must', 'int'));
            if ($af->update()){
                $this->_default_name($tid);
                echo 'ok';
            }else{
                echo '<数据>更新失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function deleteField(){
        if ($this->http_ajax_post('deleteField')){
            Doo::loadCore('db/manage/adapters/DooManageMySqlDb');
            $MDB = new DooManageMySqlDb();
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminField', array('id' => $id), false);
            if (empty($db)){
                echo "<字段>不存在";
                return;
            }
            $table = service::common_get_one('AdminTable', array('id' => $db->tid));
            if (empty($table)){
                echo "<数据表>不存在";
                return;
            }
            $MDB->dropColumn($table['full_name'], $db->name);
            $db->delete();
            if ($db->connect_id){
                $MDB->dropColumn($table['full_name'], $db->name.'_value');
            }
            echo "ok";
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function sortField(){
        if ($this->http_ajax_post('sortField')){
            $tid = intval($this->request->getPost('tid', 'int'));
            $table = service::common_get_one('AdminTable', array('id' => $tid));
            if (empty($table)){
                echo "<数据表>不存在";
                return;
            }
            $sort = $this->request->getPost('sort');
            if ($sort){
                # 排序
                Doo::loadModel('AdminField');
                $af = new AdminField();
                foreach ($sort as $id=>$value){
                    $af->id = $id;
                    $af->_orderby = $value;
                    $af->update();
                }
            }
            $this->_default_name($tid);
            echo 'ok';
            return;
        }
        echo '<越狱>非法请求';
    }

    public function createModels(){
        Doo::loadCore('db/DooModelGen');
        Doo::loadHelper('DooFile');
        $cid = $this->http_get_id();
        if (!$cid){
            $this->message('此系统模块不存在', '点击确认返回');
        }
        $model = $this->get_model($cid);
        $path = ROOT.$model['path'].'/model/';
        $is_writable = is_writable($path);
        if (!$is_writable){
            $this->message('模型目录不存在或不可写', $path);
        }
        Doo::loadCore('db/manage/adapters/DooManageMySqlDb');
        $MDB = new DooManageMySqlDb();
        $list = $MDB->tables();
        $tables = array();
        if ($list){
            foreach ($list as $table){
                $name = current($table);
                if (strstr($name, $model['path'].'_')){
                    $tables[] = $name;
                }
            }
        }
        $msg = '';
        if ($tables){
            foreach ($tables as $tblname){
                $smt2 = null;
                unset($smt2);
                $smt2 = Doo::db()->query("DESC `$tblname`");
                $fields = $smt2->fetchAll();
                $classname = service::model_name($tblname);
                $filestr = "<?php\nDoo::loadCore('db/DooModel');\n\nclass $classname extends DooModel{\n";
                $pkey = '';
                $fieldnames = array();
                foreach($fields as $f) {
                    $fstring='';
                    $filestr .= "$fstring    public \${$f['Field']};\n";
                    $fieldnames[] = $f['Field'];
                    if($f['Key']=='PRI') {
                        $pkey = $f['Field'];
                    }
                }
                $fieldnames = implode($fieldnames, "','");
                $filestr .= "\n    public \$_table = '$tblname';\n";
                $filestr .= "    public \$_primarykey = '$pkey';\n";
                $filestr .= "    public \$_fields = array('$fieldnames');\n";
                $filestr .= "}";
                $fileManager = new DooFile();
                if($fileManager->create($path. "$classname.php", $filestr, 'w+')) {
                    $msg .= "$classname --- <font color='green'>SUCCESS</font><br/>";
                }else{
                    $msg .= "$classname --- <font color='red'>FAIL</font><br/>";
                }                
            }
            $total = sizeof($tables);
            $msg .= "共生成 $total 个模型文件";
            $this->message('模型生成成功', $msg);
        }else{
            $this->message('模型生成失败', '因为根本就没有数据表');
        }
    }        
    
    public function deleteTable(){
        if ($this->http_ajax_post('deleteTable')){
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminTable', array('id' => $id), false);
            if (empty($db)){
                echo '<数据表>不存在';
                return;
            }
            # 检查是否存在下级模型
            $last = service::common_count('AdminTable', array('where' => 'fid = ?', 'param' => array($id)));
            if ($last){
                echo "<下级模型>请先删除它";
                return;
            }
            $db->delete();
            Doo::loadCore('db/manage/adapters/DooManageMySqlDb');
            $MDB = new DooManageMySqlDb();
            $MDB->dropTable($db->full_name);
            # 删除模型文件
            $path = ROOT.$db->model.'/model/';
            @unlink($path.$db->mode.'.php');
            # 删除字段
            Doo::loadModel('AdminField');
            $af = new AdminField();
            $af->tid = $id;
            $af->delete();
            echo 'ok';
            return;
        }
        echo '<越狱>非法请求';
    }

    public function createAJAX(){
        # 创建数据表
        if ($this->http_ajax_post('createTable')){
            $cid = intval($this->request->getPost('cid', 'int'));
            $model = $this->get_model($cid);
            $table_pre = $model['path'];
            $table_name = $this->request->getPost('table_name', 'alphanum');
            if (empty($table_name)){
                echo "<数据表名>请输入";
                return;
            }
            $table_tag = $this->request->getPost('table_tag');
            if (empty($table_tag)){
                echo "<数据表简称>请输入";
                return;
            }
            Doo::loadCore('db/manage/adapters/DooManageMySqlDb');
            $MDB = new DooManageMySqlDb();
            $full_name = $table_pre.'_'.$table_name;
            $exits = $MDB->tableExists($full_name);
            if ($exits){
                echo "<数据表名>已存在";
                return;
            }
            $cols = array(
                'id' => array(
                    'type' => DooManageDb::COL_TYPE_INT,
                    'require' => 'NOT NULL',
                    'autoinc' => true,
                    'primary' => true
                ),
                'adminid' => array(
                    'type' => DooManageDb::COL_TYPE_INT,
                    'require' => 'NOT NULL',
                    'default' => 0
                ),
                'dateline' => array(
                    'type' => DooManageDb::COL_TYPE_INT,
                    'require' => 'NOT NULL',
                    'default' => 0
                )
            );
            $cols = service::do_action('_database_default_fields', array($this, $cols), 1);
            # try create table
            $MDB->createTable($full_name, $cols);
            $MDB->createIndex($full_name, 'adminid', false);
            Doo::loadModel('AdminTable');
            $at = new AdminTable();
            $at->name = $table_name;
            $at->tag = $table_tag;
            $at->full_name = $full_name;
            $at->dateline = time();
            $at->model_id = $cid;
            $at->model = $table_pre;
            $at->mode = service::model_name($full_name);
            if ($this->request->hasPost('tid')){
                $at->fid = intval($this->request->getPost('tid', 'int'));
            }
            if ($at->insert()){
                echo "ok";
            }else{
                echo "<数据>写入失败";
            }
            return;
        }
        echo '<越狱>非法请求';
    }
}
