<?php

Doo::loadController('base');

# 后台用户组

class group extends base{
    
    private function _exits(){
        $opt = array(
            'asArray' => true,
            'where' => 'id = ?',
            'param' => array(intval($this->request->get('id', 'int')))
        );
        $db = Doo::db()->getOne('AdminGroup', $opt);
        if (empty($db)){
            $this->message('没有找到这个用户组', '<请不要随意访问>');
        }else{
            return $db;
        }
    }
    
    public function index(){
        $this->data['result'] = service::common_query('AdminGroup', $this->get_url(array('c' => 'group')), $this->page);
        $this->renderc('group/index', $this->data);
    }
    
    public function create(){
        $this->renderc('group/create', $this->data);
    }
    
    public function edit(){
        $this->data['db'] = $this->_exits();
        $this->renderc('group/edit', $this->data);
    }
    
    public function perm(){
        $this->http_get_id();
        $this->data['db'] = $this->_exits();
        $this->renderc('group/perm', $this->data);
    }
    
    public function delete(){
        if ($this->http_ajax_post('deleteGroup')){
            $id = intval($this->request->getPost('id', 'int'));
            if ($id == 1){
                echo "<不可>删除系统管理员";
                return;
            }
            Doo::loadModel('AdminGroup');
            $ag = new AdminGroup();
            $ag->id = $id;
            $db = $ag->getOne(array('asArray' => true));
            if (empty($db)){
                echo '<用户组>不存在';
                return;
            }
            # 检查是否有人
            Doo::loadModel('Admin');
            $admin = new Admin();
            $admin->level = $id;
            $count = $admin->count();
            if ($count){
                echo "<有人>在此用户组内";
                return;
            }
            $ag->delete();
            # 清空权限
            Doo::loadModel('AdminAccess');
            $ac = new AdminAccess();
            $ac->level = $id;
            $ac->delete();
            echo "ok";
            return;
        }
        echo '<越狱>非法请求';
    }

    public function createAJAX(){
        if ($this->http_ajax_post('createGroup')){
            $name = $this->request->getPost('name');
            $modelID = intval($this->request->getPost('modelID', 'int'));
            $model = $this->get_model($modelID);
            if (empty($name)){
                echo "<请输入>用户组名称";
                return;
            }
            Doo::loadModel('AdminGroup');
            $ag = new AdminGroup();
            $ag->model = $model['path'];
            $ag->model_id = $modelID;
            $ag->model_name = $model['name'];
            $ag->name = $name;
            if ($ag->insert()){
                echo 'ok';
            }else{
                echo '<数据>写入失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function editAJAX(){
        if ($this->http_ajax_post('editGroup')){
            $name = $this->request->getPost('name');
            $modelID = intval($this->request->getPost('modelID', 'int'));
            if (empty($name)){
                echo "<请输入>用户组名称";
                return;
            }
            $id = intval($this->request->getPost('id', 'int'));
            if ($id == 1){
                echo "<不可>修改系统管理员";
                return;
            }
            Doo::loadModel('AdminGroup');
            $ag = new AdminGroup();
            $ag->id = $id;
            $db = $ag->getOne();
            if ($db->name == $name && $db->model_id == $modelID){
                echo 'ok';
                return;
            }
            if ($db->model_id != $modelID){
                $model = $this->get_model($modelID);
                $db->model_id = $modelID;
                $db->model_name = $model['name'];
                $db->model = $model['path'];
            }
            $db->name = $name;
            if ($db->update()){
                echo 'ok';
            }else{
                echo '<数据>更新失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function permAJAX(){
        if ($this->http_ajax_post('permSet')){
            $perm = array();
            if ($this->request->hasPost('perm')){
                $perm = $this->request->getPost('perm');
            }
            $gid = intval($this->request->getPost('gid', 'int'));
            $cid = intval($this->request->getPost('cid', 'int'));
            if ($perm){
                $ids = array(); # 新的
                $new = array();
                foreach ($perm as $controller=>$value){
                    if ($value){
                        foreach ($value as $method=>$val){
                            $new[$val] = array(
                                'controller' => $controller,
                                'method' => $method,
                                'id' => $val
                            );
                            $ids[] = $val;
                        }
                    }
                }
                # 当前的
                $old = service::common_index_by_id('AdminAccess', array(
                    'where' => 'level = ? and model_id = ?',
                    'param' => array($gid, $cid)
                ));
                $old_ids = array();
                if ($old){
                    foreach ($old as $v){
                        $old_ids[] = $v['node_id'];
                    }
                }
                $insert = array();
                $delete = array();
                if ($old_ids){
                    # 比较差集
                    $insert = array_diff($ids, $old_ids);
                    $delete = array_diff($old_ids, $ids);
                }else{
                    $insert = $ids;
                }
                Doo::loadModel('AdminAccess');
                # 写入
                if ($insert){
                    foreach ($insert as $id){
                        $node = $new[$id];
                        $ac_insert = new AdminAccess();
                        $ac_insert->level = $gid;
                        $ac_insert->controller = $node['controller'];
                        $ac_insert->method = $node['method'];
                        $ac_insert->model_id = $cid;
                        $ac_insert->node_id = $id;
                        Doo::db()->insert($ac_insert);
                    }
                }
                # 删除
                if ($delete){
                    foreach ($delete as $id){
                        Doo::db()->delete('AdminAccess', array(
                            'where' => 'level = ? and model_id = ? and node_id = ?',
                            'param' => array($gid, $cid, $id)
                        ));
                    }
                }
                echo 'ok';
            }else{
                # 清空
                Doo::db()->delete('AdminAccess', array(
                    'where' => 'level = ? and model_id = ?',
                    'param' => array($gid, $cid)
                ));
                echo 'ok';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
}