<?php

Doo::loadController('base');

# 后台管理员

class manager extends base{
    
    public function index(){
        $this->data['result'] = service::common_query('Admin', $this->get_url(array('c' => 'manager')), $this->page);        
        $this->data['groups'] = service::common_index_by_id('AdminGroup');
        $this->renderc('manager/index', $this->data);
    }
    
    public function create(){
        $this->data['groups'] = service::common_index_by_id('AdminGroup');
        $this->renderc('manager/create', $this->data);
    }
    
    public function edit(){
        $this->data['groups'] = service::common_index_by_id('AdminGroup');
        $opt = array(
            'asArray' => true,
            'where' => 'id = ?',
            'param' => array(intval($this->request->get('id', 'int')))
        );
        $this->data['db'] = Doo::db()->getOne('Admin', $opt);
        if (empty($this->data['db'])){
            $this->message('没有找到此管理员', '<此管理员已移民到火星>');
        }
        $this->renderc('manager/edit', $this->data);
    }
    
    public function delete(){
        if ($this->http_ajax_post('deleteAdmin')){
            $id = intval($this->request->getPost('id', 'int'));
            if ($this->admin['id'] == $id){
                echo "<自己>是不能被删除的";
                return;
            }
            if ($id == 1){
                echo "<创始人>是不能被删除的";
                return;
            }
            Doo::loadModel('Admin');
            $admin = new Admin();
            $admin->id = $id;
            $admin->delete();
            # 删除所有数据表里含adminid的数据
            $config = Doo::db()->getDefaultDbConfig();
            $sql = "select table_name from information_schema.columns where column_name = 'adminid' AND `TABLE_SCHEMA` = '".$config[1]."';";
            $result = Doo::db()->fetchAll($sql);
            if ($result){
                foreach ($result as $table){
                    $name = current($table);
                    Doo::db()->query("delete from ".$name." where adminid='".$id."'");
                }
            }
            echo "ok";
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function createAJAX(){
        if ($this->http_ajax_post('createAdmin')){
            $must = array(
                'username' => '请输入用户名',
                'password' => '请输入密码',
                'password_again' => '请再次输入密码'
            );
            foreach ($must as $field=>$msg){
                if (!isset($_POST[$field]) || empty($_POST[$field])){
                    echo $msg;
                    return;
                }
            }
            if ($this->request->getPost('password') <> $this->request->getPost('password_again')){
                echo '你二次输入的密码不相同';
                return;
            }
            $username = $this->request->getPost('username', 'alphanum');
            if (empty($username)){
                echo '请输入用户名';
                return;
            }
            $checkid = $this->_check_username($username);
            if ($checkid){
                echo "<用户名>已存在";
                return;
            }
            Doo::loadLibrary('PasswordHash');
            Doo::loadModel('Admin');
            $admin = new Admin();
            $ph = new PasswordHash(8, true);
            $admin->username = $username;
            $admin->password = $ph->HashPassword($this->request->getPost('password'));
            $admin->checked = intval($this->request->getPost('checked', 'int'));
            $admin->lasttime = $this->time;
            $admin->lastip = $this->ip;
            $admin->addtime = $this->time;
            $admin->addip = $this->ip;
            $admin->level = intval($this->request->getPost('level', 'int'));
            if ($admin->insert()){
                // success
                echo 'ok';
            }else{
                echo "<数据>写入失败";
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    private function _check_username($username){
        Doo::loadModel('Admin');
        $admin = new Admin();
        $admin->username = $username;
        $db = $admin->getOne();
        return $db ? $db->id : 0;
    }
    
    public function editAJAX(){
        if ($this->http_ajax_post('editAdmin')){
            $username = $this->request->getPost('username', 'alphanum');
            if (empty($username)){
                echo '请输入用户名';
                return;
            }
            $id = intval($this->request->getPost('id', 'int'));         
            $checkid = $this->_check_username($username);
            if ($checkid && $checkid <> $id){
                echo "<用户名>已存在";
                return;
            }
            $password = $this->request->getPost('password');
            if ($password && $password <> $this->request->getPost('password_again')){
                echo '你二次输入的密码不相同';
                return;
            }
            Doo::loadModel('Admin');
            $admin = new Admin();
            $admin->id = $id;
            $db = $admin->getOne(array('asArray' => true));
            if (empty($db)){
                echo "<编辑>管理员不存在";
                return;
            }
            if ($password){
                Doo::loadLibrary('PasswordHash');
                $ph = new PasswordHash(8, true);
                $admin->password = $ph->HashPassword($password);
            }
            if ($id > 1 && $id <> $this->admin['id']){
                $admin->checked = intval($this->request->getPost('checked', 'int'));
                $admin->level = intval($this->request->getPost('level', 'int'));
            }
            $admin->lastip = $this->ip;
            $admin->lasttime = $this->time;
            if ($username <> $db['username']){
                $admin->username = $username;
            }                
            if ($admin->update()){
                // success
                echo "ok";
            }else{
                echo "<数据>更新失败";
            }
            return;
        }
        echo '<越狱>非法请求';
    }
}