<?php

Doo::loadController('base');

# 节点管理

class node extends base{
    
    public function index(){
        $cid = $this->http_get_id();
        $pre = array('c' => 'node');
        if ($cid){
            $pre['cid'] = $cid;
        }
        $option = array(
            'where' => 'pid=0 and model_id=?',
            'param' => array($cid),
            'asc' => 'id'
        );
        $this->data['result'] = service::common_query('AdminNode', $this->get_url($pre), $this->page, $option);  
        $id = 0;
        $db = array();
        if ($this->request->hasQuery('id')){
            $id = intval($this->request->get('id', 'int'));
            $db = service::common_get_one('AdminNode', array(
                'id' => $id
            ));
        }
        $this->data['db'] = $db;
        $this->renderc('node/index', $this->data);
    }
    
    public function delete(){
        if ($this->http_ajax_post('deleteNode')){
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminNode', array('id' => $id), false);
            if (empty($db)){
                echo "<节点>不存在";
                return;
            }
            $db->delete();
            Doo::loadModel('AdminNode');
            $an = new AdminNode();
            $an->pid = $id;
            $an->delete();
            Doo::loadModel('AdminAccess');
            $ac = new AdminAccess();
            $ac->node_id = $id;
            $ac->delete();
            echo 'ok';
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function createAJAX(){
        if ($this->http_ajax_post('createNode')){
            $cid = intval($this->request->getPost('cid', 'int'));
            $pid = intval($this->request->getPost('pid', 'int'));
            $pid = intval($pid);
            $name = $this->request->getPost('name');
            if (empty($name)){
                echo "<请输入>节点名称";
                return;
            }
            $controller = $this->request->getPost('controller', 'alphanum');
            if (empty($controller)){
                echo "<请输入>控制器名称";
                return;
            }
            $method = $this->request->getPost('method', 'alphanum');
            $model = $this->get_model($cid);
            Doo::loadModel('AdminNode');
            $an = new AdminNode();
            $an->model = $model['path'];
            $an->model_id = $cid;
            $an->model_name = $model['name'];
            $an->controller = $controller;
            $an->method = $method;
            $an->name = $name;
            $an->pid = $pid;
            if ($an->insert()){
                echo "ok";
            }else{
                echo '<数据>写入失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function editAJAX(){
        if ($this->http_ajax_post('editNode')){
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminNode', array('id' => $id), false);
            if (empty($db)){
                echo "<节点>不存在";
                return;
            }
            $pid = intval($this->request->getPost('pid', 'int'));
            $name = $this->request->getPost('name');
            $controller = $this->request->getPost('controller', 'alphanum');
            if (empty($controller)){
                echo "<请输入>控制器名称";
                return;
            }
            $method = $this->request->getPost('method', 'alphanum');
            if ($pid == $db->pid && $name == $db->name && $controller == $db->controller && $method == $db->method){
                echo 'ok';
                return;
            }
            $db->name = $name;
            $db->pid = $pid;
            $db->controller = $controller;
            $db->method = $method;
            if ($db->update()){
                echo 'ok';
            }else{
                echo '<数据>更新失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function child(){
        if ($this->request->isGet() == true && $this->request->isAjax() == true){
            $id = intval($this->request->get('id'));
            $list = service::common_index_by_id('AdminNode', array(
                'where' => 'pid=?', 'param' => array($id), 'asc' => 'id'
            ));
            $cid = intval($this->request->get('cid', 'int'));
            if ($list){
                foreach ($list as $item){
                    echo '<tr class="child_node">
                        <td>'.$item['id'].'</td>
                        <td>|-- '.$item['name'].'</td>
                        <td>'.$item['controller'].'</td>
                        <td>'.$item['method'].'</td>
                        <td>
                            <a href="'.$this->get_url(array('c' => 'node', 'cid' => $cid, 'id' => $item['id'])).'" class="tablelink">[编辑]</a>
                            <a href="javascript:;" class="tablelink" onclick="_delete('.$item['id'].', \''.$item['name'].'\');">[删除]</a>
                        </td>
                    </tr>';
                }
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
}