<?php

Doo::loadController('base');

# 参数管理

class param extends base{
    
    private function _types(){
        $_types = array(
            array('id' => '0', 'name' => '文本'),
            array('id' => '1', 'name' => '数组'),
            array('id' => '2', 'name' => '代码')
        );
        $this->data['_types'] = $_types;
        return $_types;
    }
    
    public function index(){
        $cid = $this->http_get_id();
        $this->_types();
        $option = array(
            'desc' => 'id',
            'where' => 'model_id = ?',
            'param' => array($cid)
        );
        $this->data['result'] = service::common_query('AdminOption', $this->get_url(array('c' => 'param', 'cid' => $cid)), $this->page, $option); 
        $this->renderc('param/index', $this->data);
    }    
    
    public function create(){
        $this->http_get_id();
        $this->_types();
        $this->renderc('param/create', $this->data);
    }
    
    public function edit(){
        $this->http_get_id();
        $this->_types();
        $db = service::common_get_one('AdminOption', array(
            'id' => intval($this->request->get('id', 'int'))
        ));
        if (empty($db)){
            $this->message('此参数不存在', '点击确认返回');
        }
        $this->data['db'] = $db;
        $this->renderc('param/edit', $this->data);
    }
    
    public function delete(){
        if ($this->http_ajax_post('deleteParam')){
            $id = intval($this->request->getPost('id', 'int'));
            $db = service::common_get_one('AdminOption', array('id' => $id), false);
            if (empty($db)){
                echo "<参数>不存在";
                return;
            }
            $db->delete();
            echo 'ok';
            return;
        }
        echo '<越狱>非法请求';
    }
    
    public function editAJAX(){
        if ($this->http_ajax_post('editParam')){
            $name = $this->request->getPost('name', 'alphanum');
            if (empty($name)){
                echo "<参数名称>请输入";
                return;
            }
            $content = $this->request->getPost('content');
            if (empty($content)){
                echo "<参数内容>请输入";
                return;
            }
            $id = intval($this->request->getPost('id', 'int'));
            if ($this->_exits($name, $id)){
                echo "<".$name.">已存在";
                return;
            }
            $_type = intval($this->request->getPost('_type', 'int'));
            Doo::loadModel('AdminOption');
            $ao = new AdminOption();
            $ao->id = $id;
            $ao->option_name = $name;
            $ao->option_value = $content;
            $ao->_type = $_type;
            $ao->dateline = time();
            if ($ao->update()){
                echo 'ok';
            }else{
                echo '<数据>更新失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    private function _exits($name, $id = 0){
        $db = service::common_get_one('AdminOption', array(
            'option_name' => $name
        ));
        if ($db){
            # 编辑时
            if ($id == $db['id']){
                return false;
            }
            return true;
        }else{
            return false;
        }
    }
    
    public function createAJAX(){
        if ($this->http_ajax_post('createParam')){
            $name = $this->request->getPost('name', 'alphanum');
            if (empty($name)){
                echo "<参数名称>请输入";
                return;
            }
            $content = $this->request->getPost('content');
            if (empty($content)){
                echo "<参数内容>请输入";
                return;
            }
            $cid = intval($this->request->getPost('cid', 'int'));
            if ($this->_exits($name)){
                echo "<".$name.">已存在";
                return;
            }
            $_type = intval($this->request->getPost('_type', 'int'));
            Doo::loadModel('AdminOption');
            $ao = new AdminOption();
            $ao->option_name = $name;
            $ao->option_value = $content;
            $ao->model_id = $cid;
            $ao->_type = $_type;
            $ao->dateline = time();
            if ($ao->insert()){
                echo 'ok';
            }else{
                echo '<数据>写入失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
}