<?php

Doo::loadController('base');
require ROOT.'library/qiniu/autoload.php';
use Qiniu\Auth;
use Qiniu\Storage\UploadManager;

# 后台上传

class upload extends base{
    
    private function _file_model($cid){
        $model = $this->get_model($cid);
        $table = $model['path'].'_files';
        $mode = service::model_name($table);
        Doo::loader($mode, ROOT.$model['path'].'/model/');
        return new $mode();
    }
    
    # 图片列表
    public function index(){
        $v = 0;
        if ($this->request->hasQuery('v')){
            $v = intval($this->request->get('v', 'int'));
        }
        $cid = intval($this->request->get('cid'));
        $this->data['tab'] = $v;
        $object = $this->_file_model($cid);
        $pager = new DooPager(
            $this->get_url(array('c' => 'upload', 'm' => 'index', 'cid' => $cid)), 
            $object->count(), 
            12, 
            6
        );
        $pager->paginate($this->page, 0, 'javascript:_file_ajax_page');
        $lists = $object->limit($pager->limit, null, 'id', array('asArray' => true));
        $output = $pager->totalItem ? $pager->output : '';
        $this->data['files'] = $lists;
        $this->data['pager'] = $output;
        $this->data['domain'] = service::get_option('qiniudomain');
        $this->renderc_admin('file/index', $this->data);
    }
    
    # 删除图片
    public function delete(){
        if ($this->request->isPost() == true && $this->request->isAjax() == true){
            $cid = intval($this->request->get('cid'));
            $id = intval($this->request->get('id'));
            $object = $this->_file_model($cid);
            $object->id = $id;
            $db = $object->getOne();
            if ($db){
                $bucket = service::get_option('qiniubucket');
                $secretKey = service::get_option('qiniusecretKey');
                $accessKey = service::get_option('qiniuaccessKey');
                $auth = new Auth($accessKey, $secretKey);
                $BucketManager = new Qiniu\Storage\BucketManager($auth);
                $BucketManager->delete($bucket, $db->hash);
                $db->delete();
                echo 'ok';
            }else{
                echo '删除失败';
            }
            return;
        }
        echo '<越狱>非法请求';
    }
    
    # 编辑描述
    public function editIntro(){
        if ($this->request->isPost() == true && $this->request->isAjax() == true){
            $intro = $this->request->getPost('intro');
            if (empty($intro)){
                echo '--';
                return;
            }
            $id = intval($this->request->getPost('id', 'int'));
            $cid = intval($this->request->get('cid'));
            $object = $this->_file_model($cid);
            $object->id = $id;
            $object->intro = $intro;
            $object->dateline = time();
            $object->update();
            echo $intro;
            return;
        }
        echo '<越狱>非法请求';
    }
    
    # 上传
    public function file(){
        if ($this->request->isPost() == true && $this->request->isAjax() == true){
            $bucket = service::get_option('qiniubucket');
            $secretKey = service::get_option('qiniusecretKey');
            $accessKey = service::get_option('qiniuaccessKey');
            $files = $this->request->getPost('files');
            $cid = intval($this->request->get('cid'));
            $obj = $this->_file_model($cid);
            if ($files){
                $auth = new Auth($accessKey, $secretKey);
                $opts = array(
                    'callbackUrl' => 'http://www.callback.com/',  
                    'callbackBody' => 'name=$(fname)&hash=$(etag)'
                );
                $token = $auth->uploadToken($bucket, null, 3600, $opts);
                $token = $auth->uploadToken($bucket);
                $uploadMgr = new UploadManager();
                $BucketManager = new Qiniu\Storage\BucketManager($auth);
                foreach ($files as $file){
                    $info = getimagesize($file);
                    list($type, $data) = explode(',', $file);
                    list($ret, $err) = $uploadMgr->put($token, null, base64_decode($data));
                    if ($err !== null) {
                        # 失败
                    }else{
                        $type = '';
                        $key = $ret['key'];
                        $stat = $BucketManager->stat($bucket, $key);
                        if (isset($stat[0])){
                            $file_info = $stat[0];
                            # insert
                            $obj->adminid = $this->admin['id'];
                            $obj->dateline = time();
                            $obj->hash = $key;
                            $obj->width = $info[0];
                            $obj->height = $info[1];
                            $obj->size = $file_info['fsize'];
                            $obj->type = $file_info['mimeType'];
                            $obj->insert();
                        }
                    }
                }
                echo 1;
                return;
            }
        }
        echo 0;        
    }
}