<?php

header("Content-type: text/html; charset=utf-8");

#ini_set('display_errors', 1);
#error_reporting(E_ALL);

# 根目录
define('ROOT', __DIR__.'/');
# 安装在目录下
define('CATALOG', '');
# 核心管理目录
define('ROOT_ADMIN', 'admin');
# 默认访问的控制器
if (!defined('DEFAULT_CONTROLLER')){
    define('DEFAULT_CONTROLLER', 'main');
}

date_default_timezone_set('PRC');

if (!defined('PROJECT')){
    echo "There is no project ...";
    exit(1);
}

$config = array();
$config['START_TIME'] = microtime(true);
$config['SITE_PATH'] = ROOT.PROJECT.'/';
$config['ADMIN_PATH'] = ROOT.ROOT_ADMIN.'/';
$config['BASE_PATH'] = ROOT.'dooframework/';
$config['PROTECTED_FOLDER'] = '';
$config['APP_MODE'] = 'prod';
$config['APP_URL'] = 'http://'.$_SERVER['HTTP_HOST'].'/'.CATALOG.PROJECT.'/';
$config['ADMIN_URL'] = 'http://'.$_SERVER['HTTP_HOST'].'/'.CATALOG.ROOT_ADMIN.'/';
$config['AUTOROUTE'] = true;
$config['SUBFOLDER'] = '/'.CATALOG.PROJECT.'/';
$config['VIEWC_PATH'] = $config['SITE_PATH'].'viewc/';
$config['APP_NAMESPACE_ID'] = 'doo';
$config['SESSION_NAME'] = 'PfTXKns3';

include $config['ADMIN_PATH'].'config/db.php';
include $config['BASE_PATH'].'Doo.php';
include $config['BASE_PATH'].'app/DooConfig.php';

Doo::conf()->set($config);

Doo::db()->setDb($dbconfig, $config['APP_MODE']);
Doo::db()->sql_tracking = true;

Doo::app()->run();