<?php

# 前台

Doo::loadLibrary('request');
Doo::loadLibrary('service');
Doo::loadLibrary('Wechat');
Doo::loadLibrary('jssdk');

class front extends DooController{
    
    public $wx;
    public $request;
    public $openid;
    public $user;
    public $data;
    public $time;
    public $sitename;
    public $joinNums;
    public $cachOutMinPrice;
    public $ios;
    public $qun = 0;
  
    public function beforeRun($controller, $method){
        $session = Doo::session('wYU9F2qtuXo6WK2x');
        $wxappId = service::get_option('wxappId');
        $wxappSecret = service::get_option('wxappSecret');
        $wxtoken = service::get_option('wxtoken');
        $wxAESKey = service::get_option('wxAESKey');
        $this->sitename = service::get_option('wxSiteName');
        $this->wx = new Wechat(array(
            'token' => $wxtoken,
            'encodingaeskey' => $wxAESKey,
            'appid' => $wxappId,
            'appsecret' => $wxappSecret
        ));
        if (isset($_GET["echostr"])){
            $this->wx->valid();
        }
        if ($_SERVER['REQUEST_METHOD'] == "POST"){            
            $postStr = file_get_contents("php://input");
            if ($this->xml_parser($postStr)){
                $this->wx->valid();
                Doo::loadController('wx');
                $wxapi = new wxapi();
                $wxapi->wx = $this->wx;
                $wxapi->init();
                exit;
            }
        }
        $this->request = new request();
        if (!$session->openid){
            $callback_url = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
            if ($this->request->hasQuery('state') && $this->request->get('state') == 1){
                $oauth = $this->wx->getOauthAccessToken();
                $wxDB = $this->wx->getOauthUserinfo($oauth['access_token'], $oauth['openid']);
                $wx = $this->wx->getUserInfo($oauth['openid']);
                if (empty($wxDB) || empty($wx)){
                    $session->openid = '';
                    echo '<数据获取>失败';
                    exit;
                }
                if ($wx['subscribe'] == 1){
                    $wxDB = $wx;
                }
                Doo::loadModel('ShopUsers');                
                $SU = new ShopUsers();
                $SU->openid = $oauth['openid'];
                $db = $SU->getOne();
                $comefrom = '';
                $SU->dateline = time();
                $SU->province = $wxDB['province'];
                $SU->city = $wxDB['city'];
                $SU->sex = $wxDB['sex'];
                $SU->subscribe = $wx['subscribe'];
                $SU->headimgurl = $wxDB['headimgurl'];
                if ($db && empty($db->nickname)){
                    $SU->nickname = $wxDB['nickname'];
                }else{
                    $SU->nickname = $wxDB['nickname'];
                }
                if ($db){
                    $SU->id = $db->id;
                    if ($SU->update()){
                        
                    }else{
                        $session->openid = '';
                        echo '<数据更新>失败';
                        exit;
                    }
                }else{
                    $SU->comefrom = $comefrom;
                    $SU->type = 0;
                    $lastid = $SU->insert();
                    if ($lastid){
                        $lastSU = new ShopUsers();
                        $lastSU->id = $lastid;
                        $lastDB = $lastSU->getOne();
                        if ($this->request->hasQuery('shareid')){
                            $shareid = intval($this->request->get('shareid'));
                            $shareid = intval($this->request->get('shareid'));
                            if ($shareid != $lastid){
                                $shareObj = new ShopUsers();
                                $shareObj->id = $shareid;
                                $shareOne = $shareObj->getOne();
                                if ($shareOne){
                                    service::lock_link($shareOne, $lastDB, $this->wx, 1);
                                }
                            }
                        }
                        service::lock_is_me($lastDB);
                    }else{
                        $session->openid = '';
                        echo '<数据新建>失败';
                        exit;
                    }
                }
                $session->openid = $oauth['openid'];
                header("Location:".$callback_url);
                exit;
            }else{
                $url = $this->wx->getOauthRedirect($callback_url, 1);
                header("Location:".$url);
                exit;
            }
        }else{
            $this->openid = $session->openid;
        }
        Doo::loadModel('ShopUsers');
        $SU = new ShopUsers();
        $SU->openid = $this->openid;
        $db = $SU->getOne();
        $this->user = $db;
        if (empty($db)){
            $session->openid = '';
            echo '<用户>数据错误, 请退出微信后重试';
            exit;
        }
        if ($db && empty($db->headimgurl)){
            $session->openid = '';
            echo '<头像>读取失败, 请退出微信后重试';
            exit;
        }        
        $this->init_data();
        $jssdk = new JSSDK($wxappId, $wxappSecret);   
        $this->data['sdk'] = $jssdk->getSignPackage();
        if(strpos($_SERVER['HTTP_USER_AGENT'], 'iPhone')||strpos($_SERVER['HTTP_USER_AGENT'], 'iPad')){
            $this->ios = 1;
        }else{
            $this->ios = 0;
        }
        $this->data['ios'] = $this->ios;
        $this->ban();
    }
    
    private function xml_parser($str){
        $xml_parser = xml_parser_create(); 
        if(!xml_parse($xml_parser,$str,true)){ 
            xml_parser_free($xml_parser); 
            return false;
        }else{
            return true;
        }
    }
    
    private function init_data(){
        Doo::loadModel('ShopFollows');
        $FO = new ShopFollows();
        $FO->userid = $this->user->id;
        $count = $FO->count();
        $this->joinNums = $count;
        $cachOutMinPrice = intval(service::get_option('cachOutMinPrice'));
        $this->cachOutMinPrice = $cachOutMinPrice;
        if ($this->request->hasQuery('qun')){
            $this->qun = 1;
        }
        $this->data = array(
            'app_url' => Doo::conf()->APP_URL,
            'base' => $this,
            'user' => $this->user,
            'time' => $this->time,
            'sitename' => $this->sitename,
            'joins' => $count,
            'cachOutMinPrice' => $cachOutMinPrice,
            'qun' => $this->qun
        );
    }
    
    public function url($params = array()){
        $url = Doo::conf()->APP_URL.'index.php?c='.$params['c'];
        unset($params['c']);
        if ($params){
            foreach ($params as $field=>$value){
                $url .= '&'.$field.'='.$value;
            }
        }
        return $url;
    }
    
    public function ban(){
        $banIDS = service::get_option('banIDS');
        if ($banIDS){
            $arr = explode(',', $banIDS);
            if (in_array($this->user->id, $arr)){
                echo '此帐号已被禁用, 如有疑问, 请联系我们';
                exit;
            }
        }
    }
}