<?php

Doo::loadLibrary('service');
Doo::loadClass('hooks', false, true);
# 登录

class main extends DooController{
    
    public function index(){
        $this->renderc_admin("admin/login");
    }
    
    public function loginout(){
        $doo = Doo::session(Doo::conf()->SESSION_NAME);
        $doo->rnd = '';
        Doo::session()->destroy();
        $this->renderc_admin("admin/login");
        exit(1);
    }
    
    public function login(){
        Doo::loadLibrary('request');
        $request = new request();
        if ($request->isAjax() == true && $request->isPost() == true){
            # 1.one
            $username = $request->getPost('username', 'alphanum');
            if (empty($username)){
                echo "<不能为空>请输入帐号";
                return;
            }
            $password = $request->getPost('password');
            if (empty($password)){
                echo "<不能为空>请输入密码";
                return;
            }
            $remember = 0;
            if ($request->hasPost('remember')){
                $remember = 1;
            }
            # 2.two
            $ip = $this->clientIP();
            $time = time();
            $msg = $this->loginedNums($ip, $time);
            if ($msg){
                echo $msg;
                return;
            }            
            # 3.three
            Doo::loadModel('Admin');
            $admin = new Admin();
            $admin->username = $username;
            $db = $admin->getOne();
            if ($db){
                # have
            }else{
                $msg = $this->loginFail($ip, $time);
                echo "<登录失败>帐号密码错误";
                return;
            }
            # 4.four
            Doo::loadLibrary('PasswordHash');
            $ph = new PasswordHash(8, true);
            $check = $ph->CheckPassword($password, $db->password);
            if ($check){
                # in
            }else{
                $msg = $this->loginFail($ip, $time);
                echo "<登录失败>帐号密码错误";
                return;
            }
            # 5.five
            if ($db->checked == 0){
                echo "<帐号>未激活";
                return;
            }
            # 6.six
            $rnd = $this->rand(20);
            $db->rnd = $rnd;
            $db->loginnum = $db->loginnum + 1;
            $db->lasttime = $time;
            $db->lastip = $ip;
            if ($db->update()){
                # success
            }else{
                echo "<帐号>更新失败";
                return;
            }
            # 7.seven
            $doo = Doo::session(Doo::conf()->SESSION_NAME);
            $doo->uid = $db->id;
            $doo->rnd = $rnd;
            $doo->admin = $username;
            # 8.eight
            $path = Doo::conf()->SITE_PATH.'cache/login/';
            $hand = opendir($path);
            while($file = readdir($hand)){
                if($file == '.' || $file == '..'){
                    continue;
                }
                if(strstr($file,'admin_login_'.$db->id.'_')){
                    @unlink($path.$file);
                }
            }
            $session_md5 = md5(md5($rnd.'-JsonClouds.Com').'-'.$ip.'-'.$_SERVER['HTTP_USER_AGENT'].'-'.$db->id.'-'.$username.'-'.$rnd);
            $doo->md5 = $session_md5;
            $cache_file = 'admin_login_'.$db->id.'_'.md5(md5($username.'-JsonClouds.Com.file'.$time.'-'.$rnd).'-'.$ip.'-'.$db->id.'-'.$rnd).'.cache';
            $hash_field = 'hash_'.$this->rand(4);
            $hash_value = $this->rand(12);
            $login_hash = $this->rand(27);
            $doo->ckrnd = $login_hash;
            $cache_string = $db->id.'='.$hash_field.'='.$hash_value.'='.$login_hash;
            file_put_contents($path.$cache_file, $cache_string);
            # 9.nine
            $sql_rnd = md5(md5($rnd.'-'.$db->id.'-JsonClouds.Com.auth'.$time.'-').'-'.$ip.'-'.$db->id.$rnd);
            Doo::loadModel('AdminRnd');
            $ar = new AdminRnd();
            $ar->id = $db->id;
            $arDB = $ar->getOne();
            $ar->rnd = $sql_rnd;
            $arDB ? $ar->update() : $ar->insert();
            $doo->last = $time;
            $doo->truetime = $time;
            # 10.ten
            echo $hash_field.'='.$hash_value;
            return;
        }
        echo "<越狱>非法请求";
    }
    
    private function rand($pw_length){
        $password1 = '';
        $low_ascii_bound=48;
	$upper_ascii_bound=122;
	$notuse=array(58,59,60,61,62,63,64,91,92,93,94,95,96);
        $i = 0;
	while($i < $pw_length){
            if(PHP_VERSION<'4.2.0'){
                mt_srand((double)microtime()*1000000);
            }
            $randnum=mt_rand($low_ascii_bound,$upper_ascii_bound);
            if(!in_array($randnum,$notuse)){
                $password1=$password1.chr($randnum);
                $i++;
            }
	}
	return $password1;
    }
    
    private function loginFail($ip, $time){
        $logintime = $time;
        $num = 0;
        $doo = Doo::session(Doo::conf()->SESSION_NAME);
        $num = $doo->get('num');
        $last = $doo->get('last');
        if ($num && $last){
            if ($last && ($logintime - $last > 1800)){
                $num = 0;
            }
        }
        $num++;
        $doo->num = $num;
        $doo->last = $logintime;
        Doo::loadModel('AdminLogin');
        $al = new AdminLogin();
        $al->ip = $ip;
        $db = $al->getOne();
        $al->lasttime = $time;
        $al->num = $num;
        $db ? $al->update() : $al->insert();     
    }
    
    private function loginedNums($ip, $time){
        $msg = '<冻结半小时>当前IP登录失败超5次';
        $doo = Doo::session(Doo::conf()->SESSION_NAME);
        $num = $doo->get('num');
        $last = $doo->get('last');
        if ($num && $last){
            if ($time - $last < 1800){
                if ($num >= 5){
                    return $msg;
                }
            }
        }
        $chtime = $time - 1800;
        $al = Doo::loadModel('AdminLogin', true);
        $count = $al->count(array(
            'where' => 'ip = ? and num >= 5 and lasttime > ?',
            'param' => array($ip, $chtime)
        ));
        if ($count){
            return $msg;
        }
        return false;
    }
}