<?php

# 微信通信接口

class wxapi extends DooController{
    
    public $wx;
    public $openid;
    public $user;
    public $content;
    public $wxUser;
    public $siteName;
    
    public function init(){
        $revType = $this->wx->getRev()->getRevType();
        $this->content = $this->wx->getRevContent();
        $this->openid = $this->wx->getRevFrom();
        $this->wxUser = $this->wx->getUserInfo($this->openid);
        $this->siteName = service::get_option('wxSiteName');
        $this->getUser();
        if ($revType == 'event'){
            $event = $this->wx->getRevEvent();
            switch ($event['event']){
                case 'subscribe':
                    $this->subscribe($event);
                    break;
                case 'unsubscribe':
                    $this->unsubscribe();
                    break;
                case 'SCAN':
                    $this->scan($event);
                    break;
                case 'CLICK':
                    $this->click($event);
                    break;
            }
        }
        $this->text();
    }
    
    private function getUser(){
        Doo::loadModel('ShopUsers');
        $SU = new ShopUsers();
        $SU->openid = $this->openid;
        $db = $SU->getOne();
        $SU->dateline = time();
        $SU->province = $this->wxUser['province'];
        $SU->city = $this->wxUser['city'];
        $SU->sex = $this->wxUser['sex'];
        $SU->headimgurl = $this->wxUser['headimgurl'];
        $SU->subscribe = 1;
        if ($db){
            $SU->id = $db->id;
            # 检查过期时间
            if ($db->type == 1){
                if (time() > $db->endtime){
                    $SU->endtime = 0;
                    $SU->type = 0;
                }
            }
            $SU->update();
        }else{
            # 创建会员
            $SU->comefrom = '';
            $SU->nickname = $this->wxUser['nickname'];
            $SU->type = 0;
            $SU->insert();
            $last = new ShopUsers();
            $last->openid = $this->openid;
            $db = $last->getOne();
        }
        $this->user = $db;
    }    
    
    # 文本
    private function text(){
        # 查看自己的openid
        if ($this->content == 'openid'){
            $this->wx->text($this->openid)->reply();
        }
        # 推广海报
        if ($this->content == '二维码'){
            $content = '我的赚钱二维码海报
分享到朋友圈可以赚钱

<a href="'.Doo::conf()->APP_URL.'index.php?c=welcome&view=user">点击【我的二维码】生成</a>';            
            //$this->wx->text($content)->reply();            
            if ($this->user->type == 1 || $this->user->type == 2){
                $qrcodeParams = service::get_option('qrcodeParams');
                if (empty($qrcodeParams)){
                    $this->wx->text('请设置二维码参数')->reply();
                }
                service::qrcode($this->user, $this->wx, $qrcodeParams);
                exit;
            }else{
                $this->wx->text('VIP会员方可生成二维码')->reply();
            }                                    
        }
        # 微信多客服
        if ($this->content == '客服'){
            //$this->wx->transfer_customer_service()->reply();
            $this->wx->text('感谢您使用'.$this->siteName.'，若在使用中有问题请联系'.$this->siteName.'客服。微信：chenxyhz')->reply();
        }
        if ($this->content == 'test'){
            $this->wx->news(array(
                '0' => array(
                    'Title' => '8块钱轻松加爆5000粉丝，赚取100倍以上推广佣金',
                    'Description' => '欢迎您加入'.$this->siteName.'！100万微信粉丝等你来加哦！',
                    'PicUrl' => 'http://7xlk5i.com1.z0.glb.clouddn.com/640.jpeg',
                    'Url' => 'http://mp.weixin.qq.com/s?__biz=MzIzMTA3Njk5Mw==&mid=400019636&idx=1&sn=fb3c926e0353b62d31cf9a3811b20689'
                )
            ))->reply();
        }
        # 没有回复
        $this->wx->text('亲，没有找到相关数据，如需人工客服，请输入“客服”，谢谢。')->reply();
    }
    
    # 发布客服消息
    private function _send($content){
        $message = $this->wx->sendCustomMessage(array(
            'touser' => $this->openid,
            'msgtype' => 'text',
            'text' => array(
                'content' => $content
            )
        ));
        if ($message){
            return true;
        }
        return false;
    }
    
    # 关注
    private function subscribe($event){
        $content = '恭喜成为'.$this->siteName.'的粉丝！'.$this->siteName.'百万优质粉丝，现在购买'.$this->siteName.'即可上传自己的微信二维码，结识更多的新朋友！

>><a href="'.Doo::conf()->APP_URL.'index.php?c=welcome&view=user&pay=1">点击这里</a>购买VIP会员，获得更多特权，还能生成专属的二维码海报。

>><a href="'.Doo::conf()->APP_URL.'">点击进入【'.$this->siteName.'】</a>';
        //$this->_send($content);
        if (isset($event['key']) && $event['key']){
            # 带参数的二维码
            $key = str_replace('qrscene_', '', $event['key']);
            $uid = intval($key);
            $this->fromQrcode($uid);
        }else{
            # 直接锁定关系
            service::lock_is_me($this->user);
        }
        //$this->wx->text($content)->reply();
        $this->wx->news(array(
            '0' => array(
                'Title' => '8块钱轻松加爆5000粉丝，赚取100倍以上推广佣金',
                'Description' => '欢迎您加入'.$this->siteName.'！100万微信粉丝等你来加哦！',
                'PicUrl' => 'http://7xlk5i.com1.z0.glb.clouddn.com/640.jpeg',
                'Url' => 'http://mp.weixin.qq.com/s?__biz=MzIzMTA3Njk5Mw==&mid=400019636&idx=1&sn=fb3c926e0353b62d31cf9a3811b20689'
            )
        ))->reply();
    }
    
    # 处理带参数的二维码
    private function fromQrcode($uid){
        $SU = new ShopUsers();
        $SU->id = $uid;
        $db = $SU->getOne();
        if ($db && $this->user && $uid != $this->user->id){            
            service::lock_link($db, $this->user, $this->wx);
        }else{
            # 直接锁定关系
            service::lock_is_me($this->user);
        }
    }
    
    # 扫描带参数的二维码
    private function scan($event){
        if (isset($event['key']) && $event['key']){
            # 带参数的二维码
            $key = str_replace('qrscene_', '', $event['key']);
            $uid = intval($key);
            $this->fromQrcode($uid);
        }
        $this->text();
    }
    
    # 点击自定义菜单
    private function click($event){
        if (isset($event['key'])){
            if ($event['key']){
                # 事件关键字
                $this->content = $event['key'];
                $this->text();
            }
        }
    }
    
    # 取消关注
    private function unsubscribe(){
        $SU = new ShopUsers();
        $SU->openid = $this->openid;
        $db = $SU->getOne();        
        $db->subscribe = 0;
        //$db->type = 0;
        //$db->endtime = 0;
        $db->update();
        Doo::loadModel('ShopJifen');
        $JF = new ShopJifen();
        $JF->openid2 = $this->openid;
        $JFS = $JF->getOne();
        if($JFS){      
            $US = new ShopUsers();
            $US->id = $JFS->uid1;
            $USS = $US->getOne();
            $US->jifen = intval($USS->jifen) - intval($JFS->jifen);
            if($US->update()){
                $JF->delete();
            }
        }        
    }
}