var module = ons.bootstrap('wxContactsApp', ['onsen']);

var searchUrl = '';
var searchType = 0;
var qrcodeId = 0;
var payBack = 0;

// 长按事件
$.fn.longPress = function(fn) {
    var timeout = undefined;
    var $this = this;
    $this[0].addEventListener('touchstart', function(event) {
        timeout = setTimeout(fn, 1000);
    }, false);
    $this[0].addEventListener('touchend', function(event) {
        clearTimeout(timeout);
    }, false);
};

function topped(){
    if (userType == 0){
        toppedModal.show();
        return;
    }
    modal.show();
    $.post(base + '&m=topped', function(ret){
        alert(ret);
        modal.hide();
        tabbar.setActiveTab(0);
    });    
}

function topped_hide(){
    toppedModal.hide();
    tabbar.setActiveTab(0);
}

// user.php 会员中心
module.controller('UserController', function ($scope){
    ons.ready(function() {
        modal.hide();
        if (payBack == 0){
            var pay = $('#payPage').val();
            if (pay == 1){
                userNavigator.pushPage(base + '&m=buy');
            }
        }
    });
    $scope.dialogs = {};
    $scope.a = 0;
    $scope.b = 0;
    $scope.c = 0;
    $scope.show = function (dlg, a, b, c) {
        $scope.a = a;
        $scope.b = b;
        $scope.c = c;
        if (!$scope.dialogs[dlg]) {
            ons.createDialog(dlg, {parentScope: $scope}).then(function (dialog) {
                $scope.dialogs[dlg] = dialog;
                dialog.show();                
            });
        } else {
            $scope.dialogs[dlg].show();
        }
    };
    $scope.myQrcode = function (){
        modal.show();
        $.get(base + '&m=getQrcode', function(ret){
            if (ret.indexOf('ok') >= 0){
                alert('推广二维码已发送至您的微信');
            }else{
                alert(ret);
            }
            modal.hide();
        });
    };
});

function saveMyNickname(){
    var name = $('#mynickname').val();
    if (!name){
        alert('请输入昵称');
        return;
    }
    $.post(base + '&m=postNickname', {name: name}, function (){
        $('#userNickname').text(name);
        dialog.hide();
    });
}

function buyNow(e){
    var action = $("input[name='buyChecked']:checked").val();
    var checked = action ? 1 : 0;
    if (checked == 0){
        alert('请先阅读并同意《VIP会员服务协议》和《平台许可及服务协议》');
        return;
    }
    var price = $('input:radio[name=buyTime]:checked').val(); 
    var name = $('#buyNickname').val();
    if (!name){
        alert('请输入姓名');
        return;
    }
    var tel = $('#buyPhone').val();
    if (!tel){
        alert('请输入手机');
        return;
    }
    payBack = 1;
    e.attr('disabled', 'disabled');
    var payUrl = base + '&m=pay&price=' + price + '&name=' + name + '&tel=' + tel;
    $.get(payUrl, function (ret){
        if (ret.indexOf('失败') >= 0){
            alert(ret);
        }else{
            callpay($.parseJSON(ret));
        }
        e.removeAttr('disabled');
    });
}

function jsApiCall(jsApiParameters){
    WeixinJSBridge.invoke(
        'getBrandWCPayRequest',
        jsApiParameters,
        function(res){
            if(res.err_msg == 'get_brand_wcpay_request:ok') {
                alert('支付成功');
                tabbar.setActiveTab(4);
            }else if (res.err_msg == 'get_brand_wcpay_request:cancel'){
                alert('你已取消支付');
            }else{
                alert('支付失败，错误为: ' + res.err_desc);
            }
        }
    );
}

function callpay(jsApiParameters){
    if (typeof WeixinJSBridge == "undefined"){
        if( document.addEventListener ){
            document.addEventListener('WeixinJSBridgeReady', function(){ jsApiCall(jsApiParameters); }, false);
        }else if (document.attachEvent){
            document.attachEvent('WeixinJSBridgeReady', function(){ jsApiCall(jsApiParameters); }); 
            document.attachEvent('onWeixinJSBridgeReady', function(){ jsApiCall(jsApiParameters); });
        }
    }else{
        jsApiCall(jsApiParameters);
    }
}

// lists.php 二维码列表
module.controller('ListsController', function ($scope, $http){
    $scope.items = null;
    $scope.page = 1;
    $scope.count = 0;
    $scope.type = 'getWeixin';
    $scope.join = '加好友';
    $scope.load = function() {
        $scope.type = 'getWeixin';
        $scope.join = '加好友';
        qun = 0;
        $http.get(base + '&m=getWeixin&page=1' + searchUrl).success(function(data){
            $scope.items = data.lists;
            $scope.count = data.count;
            modal.hide();
        });            
    };
    $scope.loadQun = function (){
        $scope.type = 'getQun';
        $scope.join = '加入群';
        qun = 1;
        $http.get(base + '&m=getQun&page=1' + searchUrl).success(function(data){
            $scope.items = data.lists;
            $scope.count = data.count;
            modal.hide();
        });
    };
    $scope.loadMore = function (){
        modal.show();
        $http.get(base + '&m=' + $scope.type + '&page=' + ($scope.page + 1) + searchUrl).success(function(data){
            $scope.page = $scope.page + 1;
            $scope.items = $scope.items.concat(data.lists);
            $scope.count = data.count;
            modal.hide();
            if (ios == 1){
                $('#fixedNav').css({
                    'position': '-webkit-sticky',
                    'position': 'sticky',
                    'top': '0px',
                    'z-index': '999'
                });
            }
        });
    };
    ons.ready(function() {
        if (searchType == 1){
            $("input:radio[name='listTabs']").eq(1).attr("checked",true);
            $scope.loadQun();
        }else{
            if (qun == 1){
                $("input:radio[name='listTabs']").eq(1).attr("checked",true);
                $scope.loadQun();
            }else{
                $("input:radio[name='listTabs']").eq(0).attr("checked",true);
                $scope.load();
            }
        }
        //searchType == 1 ? $scope.loadQun() : $scope.load();
        // 长按二维码识别
        $('#qrcodeImg div').longPress(function(){
            $.post(base + '&m=follow', {id: qrcodeId}, function (ret){
                joinNums = ret;
            });
        });
    });
});

function qrcode(e){
    if (userType == 0 && joinNums > 15){
        alert('购买VIP会员后可无限加好友');
        return;
    }
    var src = e.attr('data');
    qrcodeId = e.attr('data-id');
    $('#qrcodeImg div').html('<img src="' + src + '" style="max-width:100%; height: auto;"/>');
    qrcodeModal.show();
}

function qrcodeModalClose(){
    qrcodeModal.hide();
}

function listShow(){
    searchUrl = '';
    searchType = 0;
    modal.show();
}

// post.php 发布二维码
module.controller('PostController', function ($scope){
    ons.ready(function() {
        modal.hide();
        postNavigator.on('prepush', function(event) {
            modal.show();
        });
        postNavigator.on("postpush", function(event){
            modal.hide();
        });
    });
    $scope.ajax = function (){
        modal.show();
        $.post(base + '&m=postQrcode', $('#postForm').serializeArray(), function (ret){                
            if (ret.indexOf('ok') >= 0){
                alert('成功发布');
                tabbar.setActiveTab(0);
            }else{
                alert(ret);
            }
            modal.hide();
        });
    };
    $scope.post = function (){
        if (userType == 0 && joinNums <= 15){
            alert('只有VIP会员或普通会员加满15个好友(已加' + joinNums + '个)方可发布');
            return;
        }
        if (!$('#qrcodeNickname').val()){
            alert('请输入昵称');
            return;
        }
        if (!$('#qrcodeProvince').val()){
            alert('请输入省份');
            return;
        }
        if (!$('#qrcodeCity').val()){
            alert('请输入城市');
            return;
        }
        if (!$('#qrcodeIntro').val()){
            alert('请简单描述下自己');
            return;
        }
        if (!$('#qrcodeIndustry').val()){
            alert('请选择行业');
            return;
        }
        var src = $('#postQrcodeSrc').attr('src');
        if (!src){
            alert('请上传二维码');
            return;
        }
        if (src.indexOf('http') >= 0){
            $scope.ajax();
        }else{
            wx.uploadImage({
                localId: src,
                isShowProgressTips: 1,
                success: function (res){
                    var serverId = res.serverId;
                    $('#postQrcodeInput').val(serverId);
                    $scope.ajax();
                }
            });
        }
    };
    $scope.postSelectPic = function (){
        wx.chooseImage({
            count: 1, // 默认9
            sizeType: ['original', 'compressed'],
            sourceType: ['album', 'camera'],
            success: function (res) {
                var localIds = res.localIds;
                $('#postQrcodeSrc').attr('src', localIds);
            }
        });
    };
    $scope.deleteMyQrcode = function(){
        if (confirm('确认要删除您的二维码吗?')){
            $.post(base + '&m=deleteMyQrcode', function (){
                alert('删除成功, 您随时可以发布您的二维码, 加更多好友!');
                tabbar.setActiveTab(3);
            });
        }
    };
});

// post_more.php 发布微信群二维码
module.controller('PostMoreController', function ($scope){
    ons.ready(function() {
        if (userType == 0){
            alert('只有VIP会员方可发布微信群');
            $scope.postNavigator.popPage();
            modal.hide();
        }
    });    
    $scope.ajax = function (){
        modal.show();
        $.post(base + '&m=postQun', $('#postMoreForm').serializeArray(), function (ret){                
            if (ret.indexOf('ok') >= 0){
                alert('成功发布, 群二维码的有效期为7天, 过期后将不再显示');
                tabbar.setActiveTab(0);
            }else{
                alert(ret);
            }
            modal.hide();
        });
    };
    $scope.post = function (){
        function avatarUpload(avatar, post){
            wx.uploadImage({
                localId: avatar,
                isShowProgressTips: 1,
                success: function (res){
                    var serverId = res.serverId;
                    $('#qunAvatarInput').val(serverId);
                    if (post){
                        $scope.ajax();
                    }
                }
            });
        }
        function qrcodeUpload(qrcode, post){
            wx.uploadImage({
                localId: qrcode,
                isShowProgressTips: 1,
                success: function (res){
                    var serverId = res.serverId;
                    $('#qunQrcodeInput').val(serverId);
                    if (post){
                        $scope.ajax();
                    }
                }
            });
        }
        if (!$('#qunNickname').val()){
            alert('请输入群昵称');
            return;
        }
        if (!$('#qunProvince').val()){
            alert('请输入省份');
            return;
        }
        if (!$('#qunCity').val()){
            alert('请输入城市');
            return;
        }
        if (!$('#qunIntro').val()){
            alert('请简单描述下群');
            return;
        }
        var avatar = $('#qunAvatar').attr('src');
        if (!avatar){
            alert('请上传群头像');
            return;
        }
        var qrcode = $('#qunQrcode').attr('src');
        if (!qrcode){
            alert('请上传群二维码');
            return;
        }
        if (!$('#industryQun').val()){
            alert('请选择群兴趣');
            return;
        }
        if (avatar.indexOf('http') >= 0 && qrcode.indexOf('http') >= 0){
            $scope.ajax();
        }else{
            if (avatar.indexOf('http') < 0 && qrcode.indexOf('http') < 0){
                // 同时上传群二维码与群头像
                wx.uploadImage({
                    localId: avatar,
                    isShowProgressTips: 1,
                    success: function (res){
                        var serverId = res.serverId;
                        $('#qunAvatarInput').val(serverId);
                        wx.uploadImage({
                            localId: qrcode,
                            isShowProgressTips: 1,
                            success: function (res){
                                var serverId = res.serverId;
                                $('#qunQrcodeInput').val(serverId);
                                $scope.ajax();
                            }
                        });
                    }
                });                
            }else if (avatar.indexOf('http') >= 0 && qrcode.indexOf('http') < 0){
                // 上传群二维码
                qrcodeUpload(qrcode, 1);
            }else if (avatar.indexOf('http') < 0 && qrcode.indexOf('http') >= 0){
                // 上传群头像
                avatarUpload(avatar, 1);
            }
        }
    };
    $scope.selectQunAvatar = function (){
        wx.chooseImage({
            count: 1, // 默认9
            sizeType: ['original', 'compressed'], 
            sourceType: ['album', 'camera'],
            success: function (res) {
                var localIds = res.localIds; 
                $('#qunAvatar').attr('src', localIds);
            }
        });
    };
    $scope.selectQunQrcode = function (){
        wx.chooseImage({
            count: 1, // 默认9
            sizeType: ['original', 'compressed'],
            sourceType: ['album', 'camera'],
            success: function (res) {
                var localIds = res.localIds;                
                $('#qunQrcode').attr('src', localIds);
            }
        });
    };
});

// search.php 搜索
function getCity(){
    var arr = new  Array();
    arr[0]="东城,西城,崇文,宣武,朝阳,丰台,石景山,海淀,门头沟,房山,通州,顺义,昌平,大兴,平谷,怀柔,密云,延庆" ;
    arr[1]="黄浦,卢湾,徐汇,长宁,静安,普陀,闸北,虹口,杨浦,闵行,宝山,嘉定,浦东,金山,松江,青浦,南汇,奉贤,崇明";
    arr[2]="和平,东丽,河东,西青,河西,津南,南开,北辰,河北,武清,红挢,塘沽,汉沽,大港,宁河,静海,宝坻,蓟县" ;
    arr[3]="万州,涪陵,渝中,大渡口,江北,沙坪坝,九龙坡,南岸,北碚,万盛,双挢,渝北,巴南,黔江,长寿,綦江,潼南,铜梁,大足,荣昌,壁山,梁平,城口,丰都,垫江,武隆,忠县,开县,云阳,奉节,巫山,巫溪,石柱,秀山,酉阳,彭水,江津,合川,永川,南川" ;
    arr[4]="石家庄,邯郸,邢台,保定,张家口,承德,廊坊,唐山,秦皇岛,沧州,衡水" ;
    arr[5]="太原,大同,阳泉,长治,晋城,朔州,吕梁,忻州,晋中,临汾,运城" ;
    arr[6]="呼和浩特,包头,乌海,赤峰,呼伦贝尔盟,阿拉善盟,哲里木盟,兴安盟,乌兰察布盟,锡林郭勒盟,巴彦淖尔盟,伊克昭盟" ;
    arr[7]="沈阳,大连,鞍山,抚顺,本溪,丹东,锦州,营口,阜新,辽阳,盘锦,铁岭,朝阳,葫芦岛" ;
    arr[8]="长春,吉林,四平,辽源,通化,白山,松原,白城,延边" ;
    arr[9]="哈尔滨,齐齐哈尔,牡丹江,佳木斯,大庆,绥化,鹤岗,鸡西,黑河,双鸭山,伊春,七台河,大兴安岭" ;
    arr[10]="南京,镇江,苏州,南通,扬州,盐城,徐州,连云港,常州,无锡,宿迁,泰州,淮安" ;
    arr[11]="杭州,宁波,温州,嘉兴,湖州,绍兴,金华,衢州,舟山,台州,丽水" ;
    arr[12]="合肥,芜湖,蚌埠,马鞍山,淮北,铜陵,安庆,黄山,滁州,宿州,池州,淮南,巢湖,阜阳,六安,宣城,亳州" ;
    arr[13]="福州,厦门,莆田,三明,泉州,漳州,南平,龙岩,宁德" ;
    arr[14]="南昌市,景德镇,九江,鹰潭,萍乡,新馀,赣州,吉安,宜春,抚州,上饶" ;
    arr[15]="济南,青岛,淄博,枣庄,东营,烟台,潍坊,济宁,泰安,威海,日照,莱芜,临沂,德州,聊城,滨州,菏泽" ;
    arr[16]="郑州,开封,洛阳,平顶山,安阳,鹤壁,新乡,焦作,濮阳,许昌,漯河,三门峡,南阳,商丘,信阳,周口,驻马店,济源" ;
    arr[17]="武汉,宜昌,荆州,襄樊,黄石,荆门,黄冈,十堰,恩施,潜江,天门,仙桃,随州,咸宁,孝感,鄂州" ;
    arr[18]="长沙,常德,株洲,湘潭,衡阳,岳阳,邵阳,益阳,娄底,怀化,郴州,永州,湘西,张家界" ;
    arr[19]="广州,深圳,珠海,汕头,东莞,中山,佛山,韶关,江门,湛江,茂名,肇庆,惠州,梅州,汕尾,河源,阳江,清远,潮州,揭阳,云浮" ;
    arr[20]="南宁,柳州,桂林,梧州,北海,防城港,钦州,贵港,玉林,南宁地区,柳州地区,贺州,百色,河池" ;
    arr[21]="海口,三亚" ;
    arr[22]="成都,绵阳,德阳,自贡,攀枝花,广元,内江,乐山,南充,宜宾,广安,达川,雅安,眉山,甘孜,凉山,泸州" ;
    arr[23]="贵阳,六盘水,遵义,安顺,铜仁,黔西南,毕节,黔东南,黔南" ;
    arr[24]="昆明,大理,曲靖,玉溪,昭通,楚雄,红河,文山,思茅,西双版纳,保山,德宏,丽江,怒江,迪庆,临沧" ;
    arr[25]="拉萨,日喀则,山南,林芝,昌都,阿里,那曲" ;
    arr[26]="西安,宝鸡,咸阳,铜川,渭南,延安,榆林,汉中,安康,商洛" ;
    arr[27]="兰州,嘉峪关,金昌,白银,天水,酒泉,张掖,武威,定西,陇南,平凉,庆阳,临夏,甘南" ;
    arr[28]="银川,石嘴山,吴忠,固原" ;
    arr[29]="西宁,海东,海南,海北,黄南,玉树,果洛,海西" ;
    arr[30]="乌鲁木齐,石河子,克拉玛依,伊犁,巴音郭勒,昌吉,克孜勒苏柯尔克孜,博 尔塔拉,吐鲁番,哈密,喀什,和田,阿克苏" ;
    arr[31]="香港" ;
    arr[32]="澳门" ;
    arr[33]="台北,高雄,台中,台南,屏东,南投,云林,新竹,彰化,苗栗,嘉义,花莲,桃园,宜兰,基隆,台东,金门,马祖,澎湖";
    var pro = document.getElementById("province");
    var city = document.getElementById("city");
    var index = pro.selectedIndex - 1;
    if (index >= 0){
        var cityArr = arr[index].split(","); 
        city.length = 0;
        for(var i=0;i<cityArr.length;i++){
            city[i]=new Option(cityArr[i],cityArr[i]);
        }
    }
}

module.controller('SearchController', function ($scope, $http){
    ons.ready(function() {
        modal.hide();
    });
    $scope.search = function (){
        modal.show();        
        var arr = $('#searchForm').serializeArray();
        var params = [];
        $.each(arr, function(i, item){
            params.push(item.name + '=' + item.value);
        });
        searchUrl =  '&' + params.join('&');
        searchType = $('#searchType').val();
        tabbar.setActiveTab(0);
    };
});

// user_qun.php 我的微信群
module.controller('UserQunController', function ($scope, $http){
    $scope.items = null;
    $scope.page = 1;
    $scope.count = 0;
    $scope.load = function() {
        $http.get(base + '&m=getQun&my=1&page=1').success(function(data){
            $scope.items = data.lists;
            $scope.count = data.count;
            modal.hide();
        });
    };
    $scope.reset = function(){
        $scope.items.length = 0;
    };
    $scope.loadMore = function (){
        modal.show();
        $http.get(base + '&m=getQun&my=1&page=' + ($scope.page + 1)).success(function(data){
            $scope.page = $scope.page + 1;
            $scope.items = $scope.items.concat(data.lists);
            $scope.count = data.count;
            modal.hide();
        });
    };
    $scope.delete = function (id){
        if (confirm('确认删除?')){
            $.post(base + '&m=deleteQun', {id: id}, function (){
                $scope.load();
            });
        }
    };
    ons.ready(function() {
        $scope.load();
    });
});

// user_order.php 我的订单
module.controller('UserOrderController', function($scope, $http){
    $scope.count = 0;
    $scope.page = 1;
    $scope.items = null;
    $scope.loadMore = function (){
        modal.show();
        $http.get(base + '&m=getOrders&page=' + ($scope.page + 1)).success(function(data){
            $scope.page = $scope.page + 1;
            $scope.items = $scope.items.concat(data.lists);
            $scope.count = data.count;
            modal.hide();
        });
    };
    $scope.load = function (){
        $http.get(base + '&m=getOrders&page=1').success(function(data){
            $scope.items = data.lists;
            $scope.count = data.count;
            modal.hide();
        });
    };
    ons.ready(function() {
        $scope.load();
    });
});

// user_invite.php 我的邀请
module.controller('UserInviteController', function ($scope, $http){
    $scope.count = 0;
    $scope.page = 1;
    $scope.items = null;
    $scope.loadMore = function (){
        modal.show();
        $http.get(base + '&m=getInvite&page=' + ($scope.page + 1)).success(function(data){
            $scope.page = $scope.page + 1;
            $scope.items = $scope.items.concat(data.lists);
            $scope.count = data.count;
            modal.hide();
        });
    };
    $scope.load = function (){
        $http.get(base + '&m=getInvite&page=1').success(function(data){
            $scope.items = data.lists;
            $scope.count = data.count;
            modal.hide();
        });
    };
    ons.ready(function() {
        $scope.load();
    });
});

// user_cash.php 我的提现
module.controller('UserCashController', function ($scope, $http){
    $scope.cashIt = function (){
        var price = $('#cash_price').val();
        if (!price){
            alert('请输入提现金额');
            return;
        }
        modal.show();
        $.post(base + '&m=cashOut', {price: price}, function (ret){
            alert(ret);
            modal.hide();
            userNavigator.popPage();
        });
    };
    ons.ready(function() {
        modal.hide();
    });
});

// user_cash_admin.php 提现管理
module.controller('UserCashAdminController', function ($scope, $http){
    $scope.items = null;
    $scope.load = function (){
        $http.get(base + '&m=myAdmin&get=1').success(function(data){
            if (data.allow == 'allow'){
                $scope.items = data.lists;
            }else{
                $scope.items.length = 0;
                userNavigator.popPage();
            }
            modal.hide();
        });
    };
    $scope.doit = function (id){
        modal.show();
        $.post(base + '&m=adminCashConfirm', {id: id}, function (ret){
            alert(ret);
            $scope.load();
        });
    };
    ons.ready(function() {
        $scope.load();
    });
});

// jifen.php 积分商城
module.controller('JifenController', function ($scope, $http){
    $scope.count = 0;
    $scope.page = 1;
    $scope.items = null;
    $scope.loadMore = function (){
        modal.show();
        $http.get(base + '&m=getjiFen&page=' + ($scope.page + 1)).success(function(data){
            $scope.page = $scope.page + 1;
            $scope.items = $scope.items.concat(data.lists);
            $scope.count = data.count;
            modal.hide();
        });
    };
    $scope.duihuan = function (id){
        if (confirm('确认兑换?')){
            $.post(base + '&m=duiHuan', {id: id}, function (ret){
                alert(ret);
                tabbar.setActiveTab(4);
            });
        }
    };
    $scope.load = function (){
        $http.get(base + '&m=getjiFen&page=1').success(function(data){
            $scope.items = data.lists;
            $scope.count = data.count;            
            modal.hide();
        });
    };
    ons.ready(function() {
        $scope.load();
    });
});

// jifen_list.php 兑换历史
module.controller('JifenListController', function ($scope, $http){
    $scope.count = 0;
    $scope.page = 1;
    $scope.items = null;
    $scope.loadMore = function (){
        modal.show();
        $http.get(base + '&m=getjiFenList&page=' + ($scope.page + 1)).success(function(data){
            $scope.page = $scope.page + 1;
            $scope.items = $scope.items.concat(data.lists);
            $scope.count = data.count;
            modal.hide();
        });
    };
    $scope.load = function (){
        $http.get(base + '&m=getjiFenList&page=1').success(function(data){
            $scope.items = data.lists;
            $scope.count = data.count;            
            modal.hide();
        });
    };
    ons.ready(function() {
        $scope.load();
    });
});