/*
SQLyog 企业版 - MySQL GUI v7.14 
MySQL - 5.0.41-community-nt : Database - nets_installtest
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

CREATE DATABASE /*!32312 IF NOT EXISTS*/`nets_installtest` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `nets_installtest`;

/*Table structure for table `gsnavigation_cmsadv` */

DROP TABLE IF EXISTS `gsnavigation_cmsadv`;

CREATE TABLE `gsnavigation_cmsadv` (
  `catID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `catName` varchar(180) default '-' COMMENT '名称',
  `catNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `catParid` int(11) default '0' COMMENT '类型',
  `catRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `catChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `catOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `catCreateBy` int(11) default '0' COMMENT '发布人',
  `catCreateTime` datetime default NULL COMMENT '发布时间',
  `catSign` varchar(42) default '-' COMMENT '表内唯一标识符',
  `catType` int(2) default '0' COMMENT '广告类型',
  `catTimeType` int(2) default '0' COMMENT '广告过期时间类型',
  `catEndTime` datetime default NULL COMMENT '广告过期时间',
  PRIMARY KEY  (`catID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsadv` */

insert  into `gsnavigation_cmsadv`(`catID`,`catName`,`catNumCode`,`catParid`,`catRecycle`,`catChecked`,`catOrderBy`,`catCreateBy`,`catCreateTime`,`catSign`,`catType`,`catTimeType`,`catEndTime`) values (9,'团购上部_A','N_2010110916141815423',4,0,2,0,1,'2010-11-09 16:15:36','Gsnavigation_Top_A',0,1,'2010-08-18 10:38:47');
insert  into `gsnavigation_cmsadv`(`catID`,`catName`,`catNumCode`,`catParid`,`catRecycle`,`catChecked`,`catOrderBy`,`catCreateBy`,`catCreateTime`,`catSign`,`catType`,`catTimeType`,`catEndTime`) values (10,'团购首页右铡公告_A','N_2010110916161385946',4,0,2,0,1,'2010-11-09 16:16:13','Gsnavigation_Homeright_A',0,1,'2010-08-18 10:38:47');
insert  into `gsnavigation_cmsadv`(`catID`,`catName`,`catNumCode`,`catParid`,`catRecycle`,`catChecked`,`catOrderBy`,`catCreateBy`,`catCreateTime`,`catSign`,`catType`,`catTimeType`,`catEndTime`) values (11,'团购首页右铡公告_B','N_2010110916162296969',4,0,2,0,1,'2010-11-09 16:16:22','Gsnavigation_Homeright_B',0,1,'2010-08-18 10:38:47');
insert  into `gsnavigation_cmsadv`(`catID`,`catName`,`catNumCode`,`catParid`,`catRecycle`,`catChecked`,`catOrderBy`,`catCreateBy`,`catCreateTime`,`catSign`,`catType`,`catTimeType`,`catEndTime`) values (12,'团购首页右铡公告_C','N_2010110916162988671',4,0,2,0,1,'2010-11-09 16:16:29','Gsnavigation_Homeright_C',0,1,'2010-08-18 10:38:47');

/*Table structure for table `gsnavigation_cmsadvcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsadvcont`;

CREATE TABLE `gsnavigation_cmsadvcont` (
  `cactID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cactIndexID` int(11) default '0' COMMENT '主表ID号',
  `cactLink` varchar(180) default '-' COMMENT '广告链接地址',
  `cactWidth` varchar(180) default '0' COMMENT '资源宽度',
  `cactHeight` varchar(180) default '0' COMMENT '资源高度',
  `cactStyle` varchar(180) default '-' COMMENT '文字样式',
  `cactEndLink` varchar(180) default '-' COMMENT '过期后的链接地址',
  `cactEndContent` text COMMENT '广告过期后的内容',
  `cactZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `cactCount_Views` int(11) default '0' COMMENT '查看数',
  `cactSpicalPosition` text COMMENT '特殊位置',
  `cactIntroduct` text COMMENT '详细介绍',
  `cactContent` text COMMENT '内容',
  `cactRemark` text COMMENT '备注',
  `cdtLink` varchar(180) default '-' COMMENT '如果链接不为空，则点标题链到链接所在地址',
  PRIMARY KEY  (`cactID`),
  KEY `cactIndexID` (`cactIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsadvcont` */

insert  into `gsnavigation_cmsadvcont`(`cactID`,`cactIndexID`,`cactLink`,`cactWidth`,`cactHeight`,`cactStyle`,`cactEndLink`,`cactEndContent`,`cactZoneChoose`,`cactCount_Views`,`cactSpicalPosition`,`cactIntroduct`,`cactContent`,`cactRemark`,`cdtLink`) values (9,9,'#Here','','','','','','1,-1,-1,-1,-1,',0,'0','','../../../Uploadfiles/ADV/Groupsalenavigation_0/Img_2.jpg','','-');
insert  into `gsnavigation_cmsadvcont`(`cactID`,`cactIndexID`,`cactLink`,`cactWidth`,`cactHeight`,`cactStyle`,`cactEndLink`,`cactEndContent`,`cactZoneChoose`,`cactCount_Views`,`cactSpicalPosition`,`cactIntroduct`,`cactContent`,`cactRemark`,`cdtLink`) values (10,10,'#Here','','','','','','1,-1,-1,-1,-1,',0,'0','','../../../Uploadfiles/ADV/Groupsalenavigation_0/Img_0.jpg','','-');
insert  into `gsnavigation_cmsadvcont`(`cactID`,`cactIndexID`,`cactLink`,`cactWidth`,`cactHeight`,`cactStyle`,`cactEndLink`,`cactEndContent`,`cactZoneChoose`,`cactCount_Views`,`cactSpicalPosition`,`cactIntroduct`,`cactContent`,`cactRemark`,`cdtLink`) values (11,11,'#Here','','','','','','1,-1,-1,-1,-1,',0,'0','','../../../Uploadfiles/ADV/Groupsalenavigation_0/Img_0.jpg','','-');
insert  into `gsnavigation_cmsadvcont`(`cactID`,`cactIndexID`,`cactLink`,`cactWidth`,`cactHeight`,`cactStyle`,`cactEndLink`,`cactEndContent`,`cactZoneChoose`,`cactCount_Views`,`cactSpicalPosition`,`cactIntroduct`,`cactContent`,`cactRemark`,`cdtLink`) values (12,12,'#Here','','','','','','1,-1,-1,-1,-1,',0,'0','','../../../Uploadfiles/ADV/Groupsalenavigation_0/Img_0.jpg','','-');

/*Table structure for table `gsnavigation_cmsadvgroup` */

DROP TABLE IF EXISTS `gsnavigation_cmsadvgroup`;

CREATE TABLE `gsnavigation_cmsadvgroup` (
  `cagtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cagtName` varchar(180) default '-' COMMENT '名称',
  `cagtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cagtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cagtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cagtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cagtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cagtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cagtCreateBy` int(11) default '0' COMMENT '发布人',
  `cagtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cagtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsadvgroup` */

insert  into `gsnavigation_cmsadvgroup`(`cagtID`,`cagtName`,`cagtNameStyle`,`cagtNumCode`,`cagtParid`,`cagtRecycle`,`cagtChecked`,`cagtOrderBy`,`cagtCreateBy`,`cagtCreateTime`) values (1,'ROOT','','N_2010110916082154553',0,0,2,0,1,'2010-11-09 16:08:21');
insert  into `gsnavigation_cmsadvgroup`(`cagtID`,`cagtName`,`cagtNameStyle`,`cagtNumCode`,`cagtParid`,`cagtRecycle`,`cagtChecked`,`cagtOrderBy`,`cagtCreateBy`,`cagtCreateTime`) values (2,'网集广告','','N_2010110916083479983',1,0,2,0,1,'2010-11-09 16:08:34');

/*Table structure for table `gsnavigation_cmsadvgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsadvgroupcont`;

CREATE TABLE `gsnavigation_cmsadvgroupcont` (
  `cagctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cagctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cagctIntroduct` text COMMENT '介绍',
  `cagctContent` text COMMENT '内容',
  `cagctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`cagctID`),
  KEY `cagctIndexID` (`cagctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsadvgroupcont` */

insert  into `gsnavigation_cmsadvgroupcont`(`cagctID`,`cagctIndexID`,`cagctIntroduct`,`cagctContent`,`cagctRemark`) values (1,1,'','','');
insert  into `gsnavigation_cmsadvgroupcont`(`cagctID`,`cagctIndexID`,`cagctIntroduct`,`cagctContent`,`cagctRemark`) values (2,2,'','','');

/*Table structure for table `gsnavigation_cmschannel` */

DROP TABLE IF EXISTS `gsnavigation_cmschannel`;

CREATE TABLE `gsnavigation_cmschannel` (
  `cctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cctName` varchar(180) default '-' COMMENT '名称',
  `cctNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cctNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cctParid` int(11) default '0' COMMENT '上级或分类ID',
  `cctRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cctChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cctOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cctCreateBy` int(11) default '0' COMMENT '发布人',
  `cctCreateTime` datetime default NULL COMMENT '发布时间',
  `cctTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`cctID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmschannel` */

insert  into `gsnavigation_cmschannel`(`cctID`,`cctName`,`cctNameStyle`,`cctNumCode`,`cctParid`,`cctRecycle`,`cctChecked`,`cctOrderBy`,`cctCreateBy`,`cctCreateTime`,`cctTag`) values (1,'ROOT','-','-',0,0,2,0,0,NULL,'-');

/*Table structure for table `gsnavigation_cmschannelcont` */

DROP TABLE IF EXISTS `gsnavigation_cmschannelcont`;

CREATE TABLE `gsnavigation_cmschannelcont` (
  `ccctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ccctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ccctCount_Views` int(11) default '0' COMMENT '查看数',
  `ccctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `ccctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `ccctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `ccctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `ccctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `ccctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `ccctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `ccctSmallContent` varchar(180) default '-' COMMENT '简介',
  `ccctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `ccctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `ccctMetaDescription` text COMMENT 'MetaDescription',
  `ccctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `ccctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `ccctSources` text COMMENT '图集',
  `ccctIntroduct` text COMMENT '详细介绍',
  `ccctContent` text COMMENT '内容',
  `ccctRemark` text COMMENT '备注',
  PRIMARY KEY  (`ccctID`),
  KEY `ccctIndexID` (`ccctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmschannelcont` */

insert  into `gsnavigation_cmschannelcont`(`ccctID`,`ccctIndexID`,`ccctCount_Views`,`ccctCount_Info`,`ccctCount_InfoAll`,`ccctCount_Discuss`,`ccctCount_DiscussAll`,`ccctCode_Positive`,`ccctCode_Negative`,`ccctSmallTitle`,`ccctSmallContent`,`ccctMetaTitle`,`ccctMetaKeyword`,`ccctMetaDescription`,`ccctSourceR00`,`ccctSourceR01`,`ccctSources`,`ccctIntroduct`,`ccctContent`,`ccctRemark`) values (1,1,0,0,0,0,0,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);

/*Table structure for table `gsnavigation_cmsdoc` */

DROP TABLE IF EXISTS `gsnavigation_cmsdoc`;

CREATE TABLE `gsnavigation_cmsdoc` (
  `cdtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdtName` varchar(180) default '-' COMMENT '名称',
  `cdtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cdtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cdtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cdtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cdtType` int(5) default NULL COMMENT '类型',
  `cdtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cdtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cdtCreateBy` int(11) default '0' COMMENT '发布人',
  `cdtCreateTime` datetime default NULL COMMENT '发布时间',
  `cdtTag` varchar(180) default '-' COMMENT '标签',
  `cdtUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  `cdtUserPublicGroupid` int(11) default '0' COMMENT '用户分类：0.管理员发布的,1.用户发布的，发布到个人博客,2.用户发布的，发布到企业网站,3.用户发布的，发布到企业网站和个人博客',
  PRIMARY KEY  (`cdtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsdoc` */

/*Table structure for table `gsnavigation_cmsdoccont` */

DROP TABLE IF EXISTS `gsnavigation_cmsdoccont`;

CREATE TABLE `gsnavigation_cmsdoccont` (
  `cdctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cdctFrom` varchar(42) default '0' COMMENT '来源',
  `cdctAuthor` varchar(42) default '0' COMMENT '作者',
  `cdctZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `cdctEvaluation` text COMMENT '评价或打分',
  `cdctCount_Views` int(11) default '0' COMMENT '查看数',
  `cdctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `cdctCode_Main` int(11) default '8' COMMENT '总评分',
  `cdctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cdctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cdctChannelid` text COMMENT '所属频道',
  `cdctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `cdctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `cdctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `cdctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `cdctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `cdctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `cdctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `cdctPageAble` int(2) default '0' COMMENT '是否分页',
  `cdctPower_View` text COMMENT '用户查看权限',
  `cdctSpicalPosition` text COMMENT '特殊位置',
  `cdctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cdctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cdctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cdctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cdctMetaDescription` text COMMENT 'MetaDescription',
  `cdctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cdctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cdctSources` text COMMENT '图集',
  `cdctIntroduct` text COMMENT '详细介绍',
  `cdctContent` text COMMENT '内容',
  `cdctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cdctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cdctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cdctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cdctID`),
  KEY `cdctIndexID` (`cdctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsdoccont` */

/*Table structure for table `gsnavigation_cmsdocdiscuss` */

DROP TABLE IF EXISTS `gsnavigation_cmsdocdiscuss`;

CREATE TABLE `gsnavigation_cmsdocdiscuss` (
  `cddtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cddtName` varchar(180) default '-' COMMENT '名称',
  `cddtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cddtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cddtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cddtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cddtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cddtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cddtCreateBy` int(11) default '0' COMMENT '发布人',
  `cddtCreateTime` datetime default NULL COMMENT '发布时间',
  `cddtType` int(5) default '0' COMMENT '类型',
  PRIMARY KEY  (`cddtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsdocdiscuss` */

/*Table structure for table `gsnavigation_cmsdocdiscusscont` */

DROP TABLE IF EXISTS `gsnavigation_cmsdocdiscusscont`;

CREATE TABLE `gsnavigation_cmsdocdiscusscont` (
  `cddctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cddctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cddctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cddctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cddctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `cddctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `cddctPower_View` text COMMENT '用户查看权限',
  `cddctSpicalPosition` text COMMENT '特殊位置',
  `cddctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cddctContent` text COMMENT '内容',
  `cddctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cddctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cddctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cddctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `cddctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `cddctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `cddctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `cddctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cddctID`),
  KEY `cddctIndexID` (`cddctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsdocdiscusscont` */

/*Table structure for table `gsnavigation_cmsdocgroup` */

DROP TABLE IF EXISTS `gsnavigation_cmsdocgroup`;

CREATE TABLE `gsnavigation_cmsdocgroup` (
  `cdgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdgtName` varchar(180) default '-' COMMENT '名称',
  `cdgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cdgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cdgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cdgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cdgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cdgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cdgtCreateBy` int(11) default '0' COMMENT '发布人',
  `cdgtCreateTime` datetime default NULL COMMENT '发布时间',
  `cdgtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`cdgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsdocgroup` */

insert  into `gsnavigation_cmsdocgroup`(`cdgtID`,`cdgtName`,`cdgtNameStyle`,`cdgtNumCode`,`cdgtParid`,`cdgtRecycle`,`cdgtChecked`,`cdgtOrderBy`,`cdgtCreateBy`,`cdgtCreateTime`,`cdgtTag`) values (1,'ROOT','','N_2010040215433963296',0,0,2,0,1,'2010-04-02 15:43:39','');
insert  into `gsnavigation_cmsdocgroup`(`cdgtID`,`cdgtName`,`cdgtNameStyle`,`cdgtNumCode`,`cdgtParid`,`cdgtRecycle`,`cdgtChecked`,`cdgtOrderBy`,`cdgtCreateBy`,`cdgtCreateTime`,`cdgtTag`) values (2,'网集文档','','N_2010040215434741680',1,0,2,0,1,'2010-04-02 15:47:51','');

/*Table structure for table `gsnavigation_cmsdocgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsdocgroupcont`;

CREATE TABLE `gsnavigation_cmsdocgroupcont` (
  `cdgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cdgctCount_Views` int(11) default '0' COMMENT '查看数',
  `cdgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cdgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cdgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `cdgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `cdgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cdgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cdgctChannelid` text COMMENT '所属频道',
  `cdgctModelid_List` int(11) default '0' COMMENT '列表模型',
  `cdgctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `cdgctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `cdgctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `cdgctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `cdgctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `cdgctPower_Public` int(11) default '0' COMMENT '用户发布权限',
  `cdgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cdgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cdgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cdgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cdgctMetaDescription` text COMMENT 'MetaDescription',
  `cdgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cdgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cdgctSources` text COMMENT '图集',
  `cdgctIntroduct` text COMMENT '详细介绍',
  `cdgctContent` text COMMENT '内容',
  `cdgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cdgctID`),
  KEY `cdgctIndexID` (`cdgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsdocgroupcont` */

insert  into `gsnavigation_cmsdocgroupcont`(`cdgctID`,`cdgctIndexID`,`cdgctCount_Views`,`cdgctCount_Info`,`cdgctCount_InfoAll`,`cdgctCount_Discuss`,`cdgctCount_DiscussAll`,`cdgctCode_Positive`,`cdgctCode_Negative`,`cdgctChannelid`,`cdgctModelid_List`,`cdgctModelid_Detail`,`cdgctTemplateid_Home`,`cdgctTemplateid_List`,`cdgctTemplateid_Detail`,`cdgctPower_View`,`cdgctPower_Public`,`cdgctSmallTitle`,`cdgctSmallContent`,`cdgctMetaTitle`,`cdgctMetaKeyword`,`cdgctMetaDescription`,`cdgctSourceR00`,`cdgctSourceR01`,`cdgctSources`,`cdgctIntroduct`,`cdgctContent`,`cdgctRemark`) values (1,1,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_cmsdocgroupcont`(`cdgctID`,`cdgctIndexID`,`cdgctCount_Views`,`cdgctCount_Info`,`cdgctCount_InfoAll`,`cdgctCount_Discuss`,`cdgctCount_DiscussAll`,`cdgctCode_Positive`,`cdgctCode_Negative`,`cdgctChannelid`,`cdgctModelid_List`,`cdgctModelid_Detail`,`cdgctTemplateid_Home`,`cdgctTemplateid_List`,`cdgctTemplateid_Detail`,`cdgctPower_View`,`cdgctPower_Public`,`cdgctSmallTitle`,`cdgctSmallContent`,`cdgctMetaTitle`,`cdgctMetaKeyword`,`cdgctMetaDescription`,`cdgctSourceR00`,`cdgctSourceR01`,`cdgctSources`,`cdgctIntroduct`,`cdgctContent`,`cdgctRemark`) values (2,2,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);

/*Table structure for table `gsnavigation_cmsdocusergroup` */

DROP TABLE IF EXISTS `gsnavigation_cmsdocusergroup`;

CREATE TABLE `gsnavigation_cmsdocusergroup` (
  `cdugtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdugtName` varchar(180) default '-' COMMENT '名称',
  `cdugtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cdugtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cdugtSign` varchar(180) default '-' COMMENT '标志',
  `cdugtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cdugtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cdugtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cdugtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cdugtCreateBy` int(11) default '0' COMMENT '发布人',
  `cdugtCreateTime` datetime default NULL COMMENT '发布时间',
  `cdugtTag` varchar(180) default '-' COMMENT '文档分类的标签',
  `cdugtPublicType` int(2) default '0' COMMENT '分类类型：0.个人博客分类,1.企业网站分类',
  PRIMARY KEY  (`cdugtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsdocusergroup` */

/*Table structure for table `gsnavigation_cmsdocusergroupcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsdocusergroupcont`;

CREATE TABLE `gsnavigation_cmsdocusergroupcont` (
  `cdugctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdugctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cdugctCount_Views` int(11) default '0' COMMENT '查看数',
  `cdugctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cdugctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cdugctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `cdugctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `cdugctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cdugctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cdugctChannelid` text COMMENT '所属频道',
  `cdugctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `cdugctPower_Public` int(11) default '0' COMMENT '用户发布权限',
  `cdugctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cdugctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cdugctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cdugctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cdugctMetaDescription` text COMMENT 'MetaDescription',
  `cdugctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cdugctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cdugctSources` text COMMENT '图集',
  `cdugctIntroduct` text COMMENT '详细介绍',
  `cdugctContent` text COMMENT '内容',
  `cdugctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cdugctID`),
  KEY `cdguctIndexID` (`cdugctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsdocusergroupcont` */

/*Table structure for table `gsnavigation_cmsfeedback` */

DROP TABLE IF EXISTS `gsnavigation_cmsfeedback`;

CREATE TABLE `gsnavigation_cmsfeedback` (
  `cfbtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfbtName` varchar(180) default '-' COMMENT '名称，留言标题',
  `cfbtNameStyle` varchar(42) default '-' COMMENT '标题样式',
  `cfbtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cfbtType` int(2) default '0' COMMENT '留言类型',
  `cfbtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cfbtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cfbtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cfbtCreateBy` int(11) default '0' COMMENT '发布人',
  `cfbtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cfbtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsfeedback` */

/*Table structure for table `gsnavigation_cmsfeedbackcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsfeedbackcont`;

CREATE TABLE `gsnavigation_cmsfeedbackcont` (
  `cfbctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfbctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cfbctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cfbctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cfbctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `cfbctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `cfbctPower_View` text COMMENT '用户查看权限',
  `cfbctSpicalPosition` text COMMENT '特殊位置',
  `cfbctBackContent` text COMMENT '留言回复内容',
  `cfbctBackTime` datetime default NULL COMMENT '回复时间',
  `cfbctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cfbctContent` text COMMENT '内容',
  `cfbctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cfbctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cfbctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cfbctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `cfbctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `cfbctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `cfbctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `cfbctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cfbctID`),
  KEY `cfbctIndexID` (`cfbctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsfeedbackcont` */

/*Table structure for table `gsnavigation_cmsfriend` */

DROP TABLE IF EXISTS `gsnavigation_cmsfriend`;

CREATE TABLE `gsnavigation_cmsfriend` (
  `cftID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cftName` varchar(180) default '-' COMMENT '名称',
  `cftNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cftParid` int(11) default '0' COMMENT '类型',
  `cftRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cftChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cftOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cftCreateBy` int(11) default '0' COMMENT '发布人',
  `cftCreateTime` datetime default NULL COMMENT '发布时间',
  `cftType` int(2) default '0' COMMENT '友情链接类型',
  `cftLink` varchar(180) default '-' COMMENT '链接地址',
  `cftText` varchar(180) default '-' COMMENT '链接文本',
  `cftTextStyle` varchar(42) default '-' COMMENT '文字或图片的样式',
  `cftSourceR00` varchar(180) default '-' COMMENT '链接图片',
  `cftUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  PRIMARY KEY  (`cftID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsfriend` */

/*Table structure for table `gsnavigation_cmsfriendcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsfriendcont`;

CREATE TABLE `gsnavigation_cmsfriendcont` (
  `cfctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cfctCount_Views` int(11) default '0' COMMENT '查看数',
  `cfctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `cfctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cfctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cfctChannelid` text COMMENT '所属频道',
  `cfctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `cfctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `cfctPower_View` text COMMENT '用户查看权限',
  `cfctPower_Public` text COMMENT '用户发布权限',
  `cfctSpicalPosition` text COMMENT '特殊位置',
  `cfctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cfctContent` text COMMENT '内容',
  `cfctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cfctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cfctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cfctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cfctID`),
  KEY `cfctIndexID` (`cfctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsfriendcont` */

/*Table structure for table `gsnavigation_cmsfriendgroup` */

DROP TABLE IF EXISTS `gsnavigation_cmsfriendgroup`;

CREATE TABLE `gsnavigation_cmsfriendgroup` (
  `cfgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfgtName` varchar(180) default '-' COMMENT '名称',
  `cfgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cfgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cfgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cfgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cfgtChecked` int(5) default '0' COMMENT '审核',
  `cfgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cfgtCreateBy` int(11) default '0' COMMENT '发布人',
  `cfgtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cfgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsfriendgroup` */

insert  into `gsnavigation_cmsfriendgroup`(`cfgtID`,`cfgtName`,`cfgtNameStyle`,`cfgtNumCode`,`cfgtParid`,`cfgtRecycle`,`cfgtChecked`,`cfgtOrderBy`,`cfgtCreateBy`,`cfgtCreateTime`) values (1,'ROOT','','N_2010111314385453945',0,0,2,0,1,'2010-11-13 14:38:54');
insert  into `gsnavigation_cmsfriendgroup`(`cfgtID`,`cfgtName`,`cfgtNameStyle`,`cfgtNumCode`,`cfgtParid`,`cfgtRecycle`,`cfgtChecked`,`cfgtOrderBy`,`cfgtCreateBy`,`cfgtCreateTime`) values (2,'网集友情链接','','N_2010111314390433676',1,0,2,0,1,'2010-11-13 14:39:04');
insert  into `gsnavigation_cmsfriendgroup`(`cfgtID`,`cfgtName`,`cfgtNameStyle`,`cfgtNumCode`,`cfgtParid`,`cfgtRecycle`,`cfgtChecked`,`cfgtOrderBy`,`cfgtCreateBy`,`cfgtCreateTime`) values (3,'友情链接','','N_201011131439139967',2,0,2,0,1,'2010-11-13 14:39:13');
insert  into `gsnavigation_cmsfriendgroup`(`cfgtID`,`cfgtName`,`cfgtNameStyle`,`cfgtNumCode`,`cfgtParid`,`cfgtRecycle`,`cfgtChecked`,`cfgtOrderBy`,`cfgtCreateBy`,`cfgtCreateTime`) values (4,'合作伙伴','','N_2010111314392353686',2,0,2,0,1,'2010-11-13 14:39:23');

/*Table structure for table `gsnavigation_cmsfriendgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsfriendgroupcont`;

CREATE TABLE `gsnavigation_cmsfriendgroupcont` (
  `cfgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cfgctCount_Views` int(11) default '0' COMMENT '查看数',
  `cfgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cfgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cfgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cfgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cfgctPower_View` text COMMENT '用户查看权限',
  `cfgctSpicalPosition` text COMMENT '特殊位置',
  `cfgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cfgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cfgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cfgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cfgctMetaDescription` text COMMENT 'MetaDescription',
  `cfgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cfgctIntroduct` text COMMENT '详细介绍',
  `cfgctContent` text COMMENT '内容',
  `cfgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cfgctID`),
  KEY `cfgctIndexID` (`cfgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsfriendgroupcont` */

insert  into `gsnavigation_cmsfriendgroupcont`(`cfgctID`,`cfgctIndexID`,`cfgctCount_Views`,`cfgctCount_Info`,`cfgctCount_InfoAll`,`cfgctCode_Positive`,`cfgctCode_Negative`,`cfgctPower_View`,`cfgctSpicalPosition`,`cfgctSmallTitle`,`cfgctSmallContent`,`cfgctMetaTitle`,`cfgctMetaKeyword`,`cfgctMetaDescription`,`cfgctSourceR00`,`cfgctIntroduct`,`cfgctContent`,`cfgctRemark`) values (1,1,0,0,0,0,0,'0','0','','','','','','','','','');
insert  into `gsnavigation_cmsfriendgroupcont`(`cfgctID`,`cfgctIndexID`,`cfgctCount_Views`,`cfgctCount_Info`,`cfgctCount_InfoAll`,`cfgctCode_Positive`,`cfgctCode_Negative`,`cfgctPower_View`,`cfgctSpicalPosition`,`cfgctSmallTitle`,`cfgctSmallContent`,`cfgctMetaTitle`,`cfgctMetaKeyword`,`cfgctMetaDescription`,`cfgctSourceR00`,`cfgctIntroduct`,`cfgctContent`,`cfgctRemark`) values (2,2,0,0,0,0,0,'0','0','','','','','','','','','');
insert  into `gsnavigation_cmsfriendgroupcont`(`cfgctID`,`cfgctIndexID`,`cfgctCount_Views`,`cfgctCount_Info`,`cfgctCount_InfoAll`,`cfgctCode_Positive`,`cfgctCode_Negative`,`cfgctPower_View`,`cfgctSpicalPosition`,`cfgctSmallTitle`,`cfgctSmallContent`,`cfgctMetaTitle`,`cfgctMetaKeyword`,`cfgctMetaDescription`,`cfgctSourceR00`,`cfgctIntroduct`,`cfgctContent`,`cfgctRemark`) values (3,3,0,0,0,0,0,'0','0','','','','','','','','','');
insert  into `gsnavigation_cmsfriendgroupcont`(`cfgctID`,`cfgctIndexID`,`cfgctCount_Views`,`cfgctCount_Info`,`cfgctCount_InfoAll`,`cfgctCode_Positive`,`cfgctCode_Negative`,`cfgctPower_View`,`cfgctSpicalPosition`,`cfgctSmallTitle`,`cfgctSmallContent`,`cfgctMetaTitle`,`cfgctMetaKeyword`,`cfgctMetaDescription`,`cfgctSourceR00`,`cfgctIntroduct`,`cfgctContent`,`cfgctRemark`) values (4,4,0,0,0,0,0,'0','0','','','','','','','','','');

/*Table structure for table `gsnavigation_cmsipaddress` */

DROP TABLE IF EXISTS `gsnavigation_cmsipaddress`;

CREATE TABLE `gsnavigation_cmsipaddress` (
  `ciadtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ciadtName` varchar(180) default '-' COMMENT '名称',
  `ciadtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `ciadtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ciadtCreateTime` datetime default NULL COMMENT '发布时间',
  `ciadtFrom` varchar(180) default '-' COMMENT '来路',
  `ciadtFromIp` varchar(42) default '-' COMMENT '访问者IP',
  `ciadtFromZone` varchar(42) default '-' COMMENT '访问者地区',
  `ciadtViewPage` varchar(180) default '-' COMMENT '访问页面',
  `ciadtViewTime` varchar(42) default '-' COMMENT '访问停留时间',
  PRIMARY KEY  (`ciadtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsipaddress` */

/*Table structure for table `gsnavigation_cmsipaddresscont` */

DROP TABLE IF EXISTS `gsnavigation_cmsipaddresscont`;

CREATE TABLE `gsnavigation_cmsipaddresscont` (
  `ciadctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ciadctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ciadctOS` varchar(42) default '-' COMMENT '操作系统',
  `ciadctLanguage` varchar(42) default '-' COMMENT '语言',
  `ciadctISP` varchar(42) default '-' COMMENT '网络接入商',
  `ciadctResolution` varchar(42) default '-' COMMENT '分辨率',
  `ciadctBrower` varchar(42) default '-' COMMENT '浏览器',
  `ciadctIntroduct` text COMMENT '详细介绍',
  `ciadctContent` text COMMENT '内容',
  `ciadctRemark` text COMMENT '备注',
  PRIMARY KEY  (`ciadctID`),
  KEY `ciadctIndexID` (`ciadctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsipaddresscont` */

/*Table structure for table `gsnavigation_cmslink` */

DROP TABLE IF EXISTS `gsnavigation_cmslink`;

CREATE TABLE `gsnavigation_cmslink` (
  `cltID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cltName` varchar(180) default '-' COMMENT '名称',
  `cltNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cltNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cltParid` int(11) default '0' COMMENT '上级或分类ID',
  `cltRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cltChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cltOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cltCreateBy` int(11) default '0' COMMENT '发布人',
  `cltCreateTime` datetime default NULL COMMENT '发布时间',
  `cltURL` varchar(180) default '-' COMMENT '链接地址',
  `cltType` int(2) default '0' COMMENT '类型',
  `cltTarget` varchar(42) default '_blank' COMMENT '对象',
  PRIMARY KEY  (`cltID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmslink` */

insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (1,'ROOT','','N_2010101517465027447',0,0,2,0,1,'2010-10-15 17:46:50','',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (2,'网集链接','','N_2010101517465939337',1,0,2,0,1,'2010-10-15 17:46:59','#',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (3,'商务系统','','N_2010101517471279605',2,0,2,0,1,'2010-10-15 17:47:12','#',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (4,'微博','','N_201010151747251327',3,0,2,0,1,'2010-10-15 17:47:25','#',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (5,'导航','','N_201010151747419799',4,0,2,0,1,'2010-10-15 17:47:41','#',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (6,'微博首页','','N_2010101517483369317',5,0,2,6,1,'2010-10-15 17:48:33','../../../Plus/m_default/comm/microbloggingHome.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (7,'我的主页','','N_2010101517484590185',5,0,2,5,1,'2010-10-15 17:48:45','../../../Plus/Common/Place_Microblogging/default.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (8,'广播大厅','','N_2010101517490376098',5,0,2,4,1,'2010-10-15 17:49:03','../../../Plus/m_default/comm/microbloggingList.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (9,'找人','','N_2010101517491569924',5,0,2,3,1,'2010-10-15 17:49:15','../../../Plus/m_default/comm/userList.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (10,'群组','','N_2010101517492220428',5,0,2,2,1,'2010-10-15 17:49:22','../../../Plus/m_default/comm/circleList.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (11,'话题','','N_2010101517492980001',5,0,2,1,1,'2010-10-15 17:51:49','../../../Plus/m_default/comm/microbloggingspeakHome.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (12,'团购','','N_2010102322184654583',3,0,2,0,1,'2010-10-23 22:18:46','#',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (13,'导航','-','N_2010102322201215426',12,0,2,0,1,'2010-10-23 22:20:12','#',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (14,'网站首页','-','N_2010102322201258239',13,0,2,5,1,'2010-10-23 22:20:12','../../../Plus/m_default/groupsale/groupsaleHome.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (15,'今日团购','-','N_2010102322201217056',13,0,2,4,1,'2010-10-23 22:20:12','../../../Plus/m_default/groupsale/groupsaleHome.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (16,'往期团购','-','N_2010102322201276495',13,0,2,3,1,'2010-10-23 22:20:12','../../../Plus/m_default/groupsale/groupsaleList.php',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (17,'如何团购','-','N_2010102322201235043',13,0,2,2,1,'2010-10-23 22:20:12','../../../Plus/m_default/cms/docDetail.php?ID=0',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (18,'常见问题','-','N_201010232220122709',13,0,2,1,1,'2010-10-23 22:20:12','../../../Plus/m_default/cms/docDetail.php?ID=0',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (19,'链接模板','-','N_2010110311155046029',2,0,2,1,1,'2010-11-03 11:15:50','#',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (20,'外部分享','-','N_2010110311160575219',19,0,2,1,1,'2010-11-03 11:16:05','#',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (21,'开心','-','N_2010110311181159100',20,0,2,1,1,'2010-11-03 11:40:29','http://www.kaixin001.com/repaste/share.php?rurl={Nets.URL}&rcontent={Nets.URL}&rtitle={Nets.CONTENT}',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (22,'人人','-','N_2010110311182224124',20,0,2,1,1,'2010-11-03 11:40:45','http://share.renren.com/share/buttonshare.do?link={Nets.URL}&title={Nets.CONTENT}',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (23,'豆瓣','-','N_2010110311183078143',20,0,2,1,1,'2010-11-03 11:40:59','http://www.douban.com/recommend/?url={Nets.URL}&title={Nets.CONTENT}',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (24,'新浪微博','-','N_2010110311183595236',20,0,2,1,1,'2010-11-03 11:41:32','http://v.t.sina.com.cn/share/share.php?appkey={Nets.KEY}&url={Nets.URL}&title={Nets.CONTENT}&pic={Nets.IMG}',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (25,'白社会','-','N_2010110311184240802',20,0,2,1,1,'2010-11-03 11:41:51','http://bai.sohu.com/share/blank/addbutton.do?from={Nets.UNAME}&link={Nets.URL}',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (26,'邮件','-','N_2010110311184994982',20,0,2,1,1,'2010-11-03 11:42:06','mailto:?body={Nets.CONTENT}',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (27,'手机','-','N_2010110311185619467',20,0,2,1,1,'2010-11-03 11:42:24','http://go.139.com/ishare.do?shareUrl={Nets.URL}&title={Nets.CONTENT}&sid={Nets.KEY}',0,'_blank');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (28,'团购导航','','N_2010110912253512902',3,0,2,0,1,'2010-11-09 12:25:35','#',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (29,'导航','','N_2010110912254562265',28,0,2,0,1,'2010-11-09 12:25:45','#',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (30,'底部链接','','N_2010110912260072824',28,0,2,0,1,'2010-11-09 12:26:00','#',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (31,'今日团购','','N_2010110912262827062',29,0,2,7,1,'2010-11-09 12:27:07','../../../Plus/m_default/Gsnavigation/gsnavigationactiveList.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (32,'团购导航','','N_2010110912271332373',29,0,2,6,1,'2010-11-09 12:33:57','../../../Plus/m_default/Gsnavigation/gsnavigationunitList.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (33,'团购排名','','N_2010110912271881289',29,0,2,5,1,'2010-11-09 12:33:50','../../../Plus/m_default/Gsnavigation/gsnavigationRangHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (34,'个人中心','','N_2010110912272391336',29,0,2,3,1,'2010-11-09 12:34:15','../../../Plus/Common/User/main.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (35,'团购地图','','N_2010110912273991741',29,0,2,4,1,'2010-11-09 12:34:43','../../../Plus/m_default/Gsnavigation/gsnavigationMap.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (36,'团购论坛','','N_2010110912274559228',29,0,2,2,1,'2010-11-09 12:34:59','../../../Plus/m_default/Comm/postsHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (37,'积分兑换','','N_2010110912275090435',29,0,1,1,1,'2011-01-25 06:30:46','../../../Plus/m_default/Shop/codeHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (38,'团购导航','','N_2010110912291317050',30,0,2,9,1,'2010-11-09 12:29:13','../../../Plus/m_default/Gsnavigation/gsnavigationactiveList.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (39,'关于我们','','N_2010110912292140670',30,0,2,8,1,'2010-11-09 12:29:21','../../../Plus/m_default/cms/docDetail.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (40,'使用指南','','N_2010110912292568582',30,0,2,7,1,'2010-11-09 12:29:25','../../../Plus/m_default/cms/docDetail.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (41,'诚聘英才','','N_2010110912293184851',30,0,2,6,1,'2010-11-09 12:29:31','../../../Plus/m_default/cms/docDetail.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (42,'意见反馈','','N_2010110912293761566',30,0,2,5,1,'2010-11-09 12:29:37','../../../Plus/m_default/Cms/feedback.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (43,'团购网站收录','','N_2010110912294392691',30,0,2,4,1,'2010-11-09 12:29:43','../../../Plus/Common/Gsnavigation/gsnavigationunit_Publish.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (44,'开放API','','N_201011091229481510',30,0,2,3,1,'2010-11-09 12:29:48','../../../Html/Xml/Gsnavigation/Gsnavigation_Data.xml',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (45,'官方微博','','N_2010110912295395684',30,0,2,2,1,'2010-11-09 12:29:53','../../../Plus/m_default/cms/docDetail.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (46,'友情链接','','N_2010110912295966394',30,0,2,1,1,'2010-11-09 12:29:59','../../../Plus/m_default/Cms/friendshipHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (47,'公共链接','','N_2010111316402045956',3,0,2,0,1,'2010-11-13 16:40:20','#',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (48,'关于我们导航','','N_2010111316403543551',47,0,2,0,1,'2010-11-13 16:40:35','#',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (49,'关于我们','','N_2010111316410697262',48,0,2,6,1,'2010-11-13 16:41:06','../../../Plus/m_default/Cms/docDetail.php?ID=0',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (50,'联系方式','','N_2010111316411878356',48,0,2,5,1,'2010-11-13 16:41:18','../../../Plus/m_default/Cms/docDetail.php?ID=0',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (51,'友情链接','','N_2010111316413817712',48,0,2,4,1,'2010-11-13 16:41:38','../../../Plus/m_default/Cms/friendshipHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (52,'在线留言','','N_201011131642054736',48,0,2,3,1,'2010-11-13 16:42:05','../../../Plus/m_default/Cms/feedback.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (53,'商城','','N_201011300553512685',3,0,2,0,1,'2010-11-30 05:53:51','#',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (54,'导航链接','-','N_2010113005550794793',53,0,2,0,1,'2010-11-30 05:55:07','#',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (55,'论坛','-','N_2010113005550710812',54,0,2,6,1,'2011-03-05 15:57:18','../../../Plus/m_default/Comm/postsHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (56,'优惠券','-','N_2010113005550717785',54,0,2,5,1,'2011-01-30 14:52:21','../../../Plus/m_default/shop/favourableHome.php',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (57,'团购','-','N_2010113005550720059',54,0,2,4,1,'2011-03-05 15:57:25','../../../Plus/m_default/Groupsale/groupsaleHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (58,'品牌','-','N_2010113005550766314',54,0,2,3,1,'2011-03-05 15:57:09','../../../Plus/m_default/shop/brandHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (59,'热门商品','-','N_2010113005550737850',54,0,2,2,1,'2011-01-30 14:52:21','../../../Plus/m_default/shop/saleList.php?ID=-1&DKeyword=&DSearch=0,1,-1,-1',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (60,'下底帮助链接','-','N_2010113007340632449',53,0,2,0,1,'2010-11-30 07:34:06','#',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (61,'新手帮助','-','N_2010113007342823089',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (62,'正品保证','-','N_201011300734287565',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (63,'品牌授权','-','N_2010113007342826354',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (64,'购鞋常识','-','N_2010113007342866616',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (65,'防伪标签','-','N_201011300734283594',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (66,'常见问题','-','N_2010113007342813900',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (67,'促销说明','-','N_2010113007342823168',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (68,'购物指南','-','N_20101130073428588',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (69,'量脚方法','-','N_2010113007342862811',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (70,'尺码测量纸','-','N_2010113007342899728',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (71,'尺码选择','-','N_2010113007342884631',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (72,'我的订单','-','N_2010113007342881240',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (73,'购物保障','-','N_2010113007342810113',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (74,'差额支付','-','N_2010113007342886923',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (75,'付款方式','-','N_2010113007342895117',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (76,'货到付款','-','N_201011300734285447',75,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (77,'支付宝','-','N_201011300734284876',75,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (78,'网上银行','-','N_2010113007342847360',75,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (79,'财付通','-','N_2010113007342889001',75,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (80,'配送方式','-','N_2010113007342820083',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (81,'运费说明','-','N_2010113007342856475',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (82,'宅急送','-','N_201011300734282914',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (83,'EMS快递','-','N_2010113007342850659',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (84,'中通快递','-','N_2010113007342822024',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (85,'圆通快递','-','N_2010113007342824285',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (86,'配送查询','-','N_2010113007342825460',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (87,'收货说明','-','N_2010113007342814465',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (88,'售后服务','-','N_2010113007342858145',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (89,'退换货政策','-','N_2010113007342817681',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (90,'退换货流程','-','N_2010113007342836874',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (91,'价格保护','-','N_2010113007342864794',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (92,'商品售后须知','-','N_2010113007342825320',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (93,'退款流程','-','N_2010113007342896038',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (94,'三包规定','-','N_201011300734289030',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (95,'会员服务','-','N_2010113007342836022',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (96,'优惠券使用','-','N_2010113007342870425',95,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (97,'如何咨询','-','N_2010113007342868731',95,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (98,'CEO邮箱','-','N_2010113007342863803',95,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (99,'服务协议','-','N_2010113007342812524',95,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (100,'底部导航','','N_2011012317410391488',12,0,2,0,1,'2011-01-23 17:41:03','#Here',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (101,'用户帮助','-','N_2011012317414353274',100,0,2,4,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (102,'玩转团购','-','N_2011012317414330535',101,0,2,4,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (103,'常见问题','-','N_201101231741436710',101,0,2,3,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (104,'邮箱白名单设置','-','N_2011012317414370715',101,0,2,2,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (105,'开放API','-','N_2011012317414389395',101,0,2,1,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (106,'获取更新','-','N_2011012317414323931',100,0,2,3,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (107,'邮件订阅','-','N_2011012317414318124',106,0,2,3,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (108,'团购微博','-','N_2011012317414421044',106,0,2,2,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (109,'网站首页','-','N_2011012317414456570',106,0,2,1,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (110,'商务合作','-','N_201101231741442288',100,0,2,2,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (111,'提供团购信息','-','N_2011012317414490280',110,0,2,3,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (112,'市场合作','-','N_2011012317414492272',110,0,2,2,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (113,'加盟我们','-','N_201101231741441675',110,0,2,1,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (114,'公司信息','-','N_2011012317414474981',100,0,2,1,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (115,'关于我们','-','N_2011012317414445053',114,0,2,4,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (116,'媒体报道','-','N_2011012317414468774',114,0,2,3,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (117,'加入我们','-','N_2011012317414421585',114,0,2,2,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (118,'隐私声明','-','N_201101231741441385',114,0,2,1,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (119,'最新上市','-','N_2011013014464336911',54,0,2,1,1,'2011-01-30 14:52:21','../../../Plus/m_default/shop/saleList.php?ID=-1&DKeyword=&DSearch=0,2,-1,-1',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (120,'最上导航','-','N_2011013015291092028',53,0,2,0,1,'2011-01-30 15:29:10','#',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (121,'积分商城','-','N_2011020114092096276',54,0,2,5,1,'2011-02-01 14:09:20','../../../Plus/m_default/shop/codeHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (122,'商家','-','N_2011022309024846734',54,0,2,3,1,'2011-03-05 15:57:35','../../../Plus/m_default/shop/unitHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (123,'拍卖','-','N_2011030515561339450',54,0,2,3,1,'2011-03-05 15:56:13','../../../Plus/m_default/shop/auctionHome.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (124,'近期订单','-','N_2011030515565176794',54,0,2,3,1,'2011-03-14 19:48:53','../../../Plus/m_default/shop/orderHome.php',0,'_self');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (125,'推广链接','','N_2011050500584295065',48,0,2,2,1,'2011-05-05 00:58:42','../../../Plus/m_default/Cms/promotion_Link.php',0,'0');
insert  into `gsnavigation_cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (126,'推广表单','','N_2011050500590278915',48,0,2,1,1,'2011-05-05 00:59:02','../../../Plus/m_default/Cms/promotion_Form.php',0,'0');

/*Table structure for table `gsnavigation_cmslinkcont` */

DROP TABLE IF EXISTS `gsnavigation_cmslinkcont`;

CREATE TABLE `gsnavigation_cmslinkcont` (
  `clctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `clctIndexID` int(11) default '0' COMMENT '主表ID号',
  `clctCount_Views` int(11) default '0' COMMENT '查看数',
  `clctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `clctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `clctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `clctChannelid` text COMMENT '所属频道',
  `clctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `clctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `clctPower_View` text COMMENT '用户查看权限',
  `clctPower_Public` text COMMENT '用户发布权限',
  `clctSpicalPosition` text COMMENT '特殊位置',
  `clctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `clctSmallContent` varchar(180) default '-' COMMENT '简介',
  `clctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `clctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `clctMetaDescription` text COMMENT 'MetaDescription',
  `clctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `clctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `clctSources` text COMMENT '图集',
  `clctIntroduct` text COMMENT '详细介绍',
  `clctContent` text COMMENT '内容',
  `clctRemark` text COMMENT '备注',
  PRIMARY KEY  (`clctID`),
  KEY `clctIndexID` (`clctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmslinkcont` */

insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (1,1,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (2,2,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (3,3,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (4,4,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (5,5,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (6,6,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (7,7,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (8,8,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (9,9,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (10,10,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (11,11,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (12,12,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (13,13,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (14,14,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (15,15,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (16,16,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (17,17,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (18,18,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (19,19,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (20,20,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (21,21,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_1.jpg','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (22,22,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_2.jpg','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (23,23,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_3.jpg','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (24,24,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_4.jpg','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (25,25,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_6.jpg','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (26,26,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_5.jpg','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (27,27,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_7.jpg','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (28,28,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (29,29,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (30,30,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (31,31,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (32,32,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (33,33,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (34,34,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (35,35,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (36,36,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (37,37,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (38,38,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (39,39,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (40,40,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (41,41,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (42,42,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (43,43,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (44,44,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (45,45,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (46,46,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (47,47,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (48,48,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (49,49,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (50,50,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (51,51,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (52,52,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (53,53,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (54,54,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (55,55,0,0,0,0,'-',0,0,'0','-','0','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (56,56,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (57,57,0,0,0,0,'-',0,0,'0','-','0','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (58,58,0,0,0,0,'-',0,0,'0','-','0','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (59,59,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (60,60,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (61,61,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (62,62,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (63,63,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (64,64,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (65,65,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (66,66,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (67,67,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (68,68,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (69,69,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (70,70,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (71,71,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (72,72,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (73,73,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (74,74,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (75,75,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (76,76,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (77,77,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (78,78,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (79,79,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (80,80,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (81,81,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (82,82,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (83,83,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (84,84,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (85,85,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (86,86,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (87,87,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (88,88,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (89,89,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (90,90,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (91,91,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (92,92,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (93,93,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (94,94,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (95,95,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (96,96,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (97,97,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (98,98,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (99,99,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (100,100,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (101,101,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (102,102,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (103,103,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (104,104,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (105,105,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (106,106,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (107,107,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (108,108,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (109,109,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (110,110,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (111,111,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (112,112,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (113,113,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (114,114,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (115,115,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (116,116,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (117,117,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (118,118,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (119,119,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (120,120,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (121,121,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (122,122,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (123,123,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (124,124,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (125,125,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `gsnavigation_cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (126,126,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');

/*Table structure for table `gsnavigation_cmssearchkeyword` */

DROP TABLE IF EXISTS `gsnavigation_cmssearchkeyword`;

CREATE TABLE `gsnavigation_cmssearchkeyword` (
  `csktID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `csktName` varchar(180) default '-' COMMENT '名称',
  `csktNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `csktNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `csktParid` int(11) default '0' COMMENT '上级或分类ID',
  `csktRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `csktChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `csktOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `csktCreateBy` int(11) default '0' COMMENT '发布人',
  `csktCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`csktID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmssearchkeyword` */

/*Table structure for table `gsnavigation_cmssearchkeywordcont` */

DROP TABLE IF EXISTS `gsnavigation_cmssearchkeywordcont`;

CREATE TABLE `gsnavigation_cmssearchkeywordcont` (
  `cskctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cskctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cskctLink` varchar(180) default '-' COMMENT '链接地址',
  `cskctCount_Views` int(11) default '0' COMMENT '查看数',
  `cskctPower_View` text COMMENT '用户查看权限',
  `cskctSpicalPosition` text COMMENT '特殊位置',
  `cskctIntroduct` text COMMENT '介绍',
  `cskctContent` text COMMENT '内容',
  `cskctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`cskctID`),
  KEY `cskctIndexID` (`cskctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmssearchkeywordcont` */

/*Table structure for table `gsnavigation_cmssearchkeywordgroup` */

DROP TABLE IF EXISTS `gsnavigation_cmssearchkeywordgroup`;

CREATE TABLE `gsnavigation_cmssearchkeywordgroup` (
  `cskgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cskgtName` varchar(180) default '-' COMMENT '名称',
  `cskgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cskgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cskgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cskgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cskgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cskgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cskgtCreateBy` int(11) default '0' COMMENT '发布人',
  `cskgtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cskgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmssearchkeywordgroup` */

/*Table structure for table `gsnavigation_cmssearchkeywordgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_cmssearchkeywordgroupcont`;

CREATE TABLE `gsnavigation_cmssearchkeywordgroupcont` (
  `cskgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cskgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cskgctCount_Views` int(11) default '0' COMMENT '查看数',
  `cskgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cskgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cskgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cskgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cskgctPower_View` text COMMENT '用户查看权限',
  `cskgctSpicalPosition` text COMMENT '特殊位置',
  `cskgctIntroduct` text COMMENT '详细介绍',
  `cskgctContent` text COMMENT '内容',
  `cskgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cskgctID`),
  KEY `cskgctIndexID` (`cskgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmssearchkeywordgroupcont` */

/*Table structure for table `gsnavigation_cmsvote` */

DROP TABLE IF EXISTS `gsnavigation_cmsvote`;

CREATE TABLE `gsnavigation_cmsvote` (
  `cvtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvtName` varchar(180) default '-' COMMENT '名称',
  `cvtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cvtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cvtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cvtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvtCreateBy` int(11) default '0' COMMENT '发布人',
  `cvtCreateTime` datetime default NULL COMMENT '发布时间',
  `cvtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`cvtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvote` */

/*Table structure for table `gsnavigation_cmsvotecont` */

DROP TABLE IF EXISTS `gsnavigation_cmsvotecont`;

CREATE TABLE `gsnavigation_cmsvotecont` (
  `cvctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvctSet_Page` int(5) default '0' COMMENT '所在页',
  `cvctTime_End` varchar(42) default NULL COMMENT '结束时间',
  `cvctControl_Type` varchar(42) default 'RadioAR' COMMENT '控件类型',
  `cvctControl_Len` int(5) default '8' COMMENT '控件长度',
  `cvctControl_Default` varchar(180) default NULL COMMENT '默认值',
  `cvctControl_Need` int(2) default '0' COMMENT '是否为必填',
  `cvctControl_Input` int(2) default '0' COMMENT '是否有附加输入框',
  `cvctCount_Views` int(11) default '0' COMMENT '查看数',
  `cvctCount_Discuss` int(11) default '0' COMMENT '回复数_投票数',
  `cvctChannelid` text COMMENT '所属频道',
  `cvctPower_View` text COMMENT '用户查看权限',
  `cvctPower_Public` text COMMENT '用户发布权限',
  `cvctSpicalPosition` text COMMENT '特殊位置',
  `cvctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cvctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cvctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cvctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cvctMetaDescription` text COMMENT 'MetaDescription',
  `cvctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cvctSources` text COMMENT '图集',
  `cvctIntroduct` text COMMENT '详细介绍',
  `cvctContent` text COMMENT '内容',
  `cvctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cvctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cvctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cvctRemark` text COMMENT '备注',
  `cvctSet_Result` text COMMENT '上页值包含此内容时显示本投票，为空为不限制',
  PRIMARY KEY  (`cvctID`),
  KEY `cvctIndexID` (`cvctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvotecont` */

/*Table structure for table `gsnavigation_cmsvotediscuss` */

DROP TABLE IF EXISTS `gsnavigation_cmsvotediscuss`;

CREATE TABLE `gsnavigation_cmsvotediscuss` (
  `cvdtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvdtName` varchar(180) default '-' COMMENT '名称',
  `cvdtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cvdtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvdtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cvdtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvdtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cvdtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvdtCreateBy` int(11) default '0' COMMENT '发布人',
  `cvdtCreateTime` datetime default NULL COMMENT '发布时间',
  `cvdtType` int(5) default '0' COMMENT '类型',
  PRIMARY KEY  (`cvdtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvotediscuss` */

/*Table structure for table `gsnavigation_cmsvotediscusscont` */

DROP TABLE IF EXISTS `gsnavigation_cmsvotediscusscont`;

CREATE TABLE `gsnavigation_cmsvotediscusscont` (
  `cvdctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvdctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvdctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cvdctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cvdctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `cvdctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `cvdctPower_View` text COMMENT '用户查看权限',
  `cvdctSpicalPosition` text COMMENT '特殊位置',
  `cvdctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvdctContent` text COMMENT '内容',
  `cvdctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cvdctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cvdctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cvdctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `cvdctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `cvdctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `cvdctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `cvdctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cvdctID`),
  KEY `cvdctIndexID` (`cvdctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvotediscusscont` */

/*Table structure for table `gsnavigation_cmsvotegroup` */

DROP TABLE IF EXISTS `gsnavigation_cmsvotegroup`;

CREATE TABLE `gsnavigation_cmsvotegroup` (
  `cvgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvgtName` varchar(180) default '-' COMMENT '名称',
  `cvgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cvgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cvgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvgtChecked` int(5) default '0' COMMENT '审核',
  `cvgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvgtCreateBy` int(11) default '0' COMMENT '发布人',
  `cvgtCreateTime` datetime default NULL COMMENT '发布时间',
  `cvgtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`cvgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvotegroup` */

insert  into `gsnavigation_cmsvotegroup`(`cvgtID`,`cvgtName`,`cvgtNameStyle`,`cvgtNumCode`,`cvgtParid`,`cvgtRecycle`,`cvgtChecked`,`cvgtOrderBy`,`cvgtCreateBy`,`cvgtCreateTime`,`cvgtTag`) values (1,'ROOT','','N_2010112501433173086',0,0,2,0,1,'2010-11-25 01:43:31','');
insert  into `gsnavigation_cmsvotegroup`(`cvgtID`,`cvgtName`,`cvgtNameStyle`,`cvgtNumCode`,`cvgtParid`,`cvgtRecycle`,`cvgtChecked`,`cvgtOrderBy`,`cvgtCreateBy`,`cvgtCreateTime`,`cvgtTag`) values (2,'网集投票与问卷调查','','N_2010112501433648648',1,0,2,0,1,'2010-11-25 01:43:36','');

/*Table structure for table `gsnavigation_cmsvotegroupcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsvotegroupcont`;

CREATE TABLE `gsnavigation_cmsvotegroupcont` (
  `cvgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvgctCount_Views` int(11) default '0' COMMENT '查看数',
  `cvgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cvgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cvgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `cvgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `cvgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cvgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cvgctChannelid` text COMMENT '所属频道',
  `cvgctPower_View` text COMMENT '用户查看权限',
  `cvgctSpicalPosition` text COMMENT '特殊位置',
  `cvgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cvgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cvgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cvgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cvgctMetaDescription` text COMMENT 'MetaDescription',
  `cvgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cvgctSources` text COMMENT '图集',
  `cvgctIntroduct` text COMMENT '详细介绍',
  `cvgctContent` text COMMENT '内容',
  `cvgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cvgctID`),
  KEY `cvgctIndexID` (`cvgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvotegroupcont` */

insert  into `gsnavigation_cmsvotegroupcont`(`cvgctID`,`cvgctIndexID`,`cvgctCount_Views`,`cvgctCount_Info`,`cvgctCount_InfoAll`,`cvgctCount_Discuss`,`cvgctCount_DiscussAll`,`cvgctCode_Positive`,`cvgctCode_Negative`,`cvgctChannelid`,`cvgctPower_View`,`cvgctSpicalPosition`,`cvgctSmallTitle`,`cvgctSmallContent`,`cvgctMetaTitle`,`cvgctMetaKeyword`,`cvgctMetaDescription`,`cvgctSourceR00`,`cvgctSourceR01`,`cvgctSources`,`cvgctIntroduct`,`cvgctContent`,`cvgctRemark`) values (1,1,0,0,0,0,0,0,0,'','0','0','','','','','','','','','','','');
insert  into `gsnavigation_cmsvotegroupcont`(`cvgctID`,`cvgctIndexID`,`cvgctCount_Views`,`cvgctCount_Info`,`cvgctCount_InfoAll`,`cvgctCount_Discuss`,`cvgctCount_DiscussAll`,`cvgctCode_Positive`,`cvgctCode_Negative`,`cvgctChannelid`,`cvgctPower_View`,`cvgctSpicalPosition`,`cvgctSmallTitle`,`cvgctSmallContent`,`cvgctMetaTitle`,`cvgctMetaKeyword`,`cvgctMetaDescription`,`cvgctSourceR00`,`cvgctSourceR01`,`cvgctSources`,`cvgctIntroduct`,`cvgctContent`,`cvgctRemark`) values (2,2,0,0,0,0,0,0,0,'','0','0','','','','','','','','','','','');

/*Table structure for table `gsnavigation_cmsvoteoption` */

DROP TABLE IF EXISTS `gsnavigation_cmsvoteoption`;

CREATE TABLE `gsnavigation_cmsvoteoption` (
  `cvotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvotName` varchar(250) default '-' COMMENT '名称',
  `cvotNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cvotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvotParid` int(11) default '0' COMMENT '上级或分类ID',
  `cvotRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvotChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cvotOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvotCreateBy` int(11) default '0' COMMENT '发布人',
  `cvotCreateTime` datetime default NULL COMMENT '发布时间',
  `cvotValue` varchar(250) default '0' COMMENT '值',
  `cvotCount` int(11) default '0' COMMENT '已投票数',
  PRIMARY KEY  (`cvotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvoteoption` */

/*Table structure for table `gsnavigation_cmsvoteoptioncont` */

DROP TABLE IF EXISTS `gsnavigation_cmsvoteoptioncont`;

CREATE TABLE `gsnavigation_cmsvoteoptioncont` (
  `cvoctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvoctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvoctScript` text COMMENT '选中后，响应的脚本，只支持JS脚本',
  `cvoctPower_View` text COMMENT '用户查看权限',
  `cvoctSpicalPosition` text COMMENT '特殊位置',
  `cvoctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvoctIntroduct` text COMMENT '详细介绍',
  `cvoctContent` text COMMENT '内容',
  `cvoctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cvoctID`),
  KEY `cvoctIndexID` (`cvoctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvoteoptioncont` */

/*Table structure for table `gsnavigation_cmsvoteresult` */

DROP TABLE IF EXISTS `gsnavigation_cmsvoteresult`;

CREATE TABLE `gsnavigation_cmsvoteresult` (
  `cvrtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvrtName` varchar(180) default '-' COMMENT '名称',
  `cvrtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `cvrtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvrtParid` int(11) default '0' COMMENT '所投票分组、所调查问卷',
  `cvrtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvrtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cvrtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvrtCreateBy` int(11) default '0' COMMENT '发布人',
  `cvrtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cvrtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvoteresult` */

/*Table structure for table `gsnavigation_cmsvoteresultcont` */

DROP TABLE IF EXISTS `gsnavigation_cmsvoteresultcont`;

CREATE TABLE `gsnavigation_cmsvoteresultcont` (
  `cvrctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvrctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvrctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cvrctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cvrctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `cvrctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `cvrctPower_View` text COMMENT '用户查看权限',
  `cvrctSpicalPosition` text COMMENT '特殊位置',
  `cvrctConContent` text COMMENT '填表-留言内容',
  `cvrctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvrctContent` text COMMENT '内容',
  `cvrctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cvrctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cvrctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cvrctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `cvrctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `cvrctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `cvrctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `cvrctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cvrctID`),
  KEY `cvrctIndexID` (`cvrctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_cmsvoteresultcont` */

/*Table structure for table `gsnavigation_commposts` */

DROP TABLE IF EXISTS `gsnavigation_commposts`;

CREATE TABLE `gsnavigation_commposts` (
  `coptID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `coptName` varchar(180) default '-' COMMENT '名称',
  `coptNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `coptNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `coptParid` int(11) default '0' COMMENT '上级或分类ID',
  `coptCircleid` int(11) default '0' COMMENT '所属圈子',
  `coptRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `coptChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `coptOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `coptCreateBy` int(11) default '0' COMMENT '发布人',
  `coptCreateTime` datetime default NULL COMMENT '发布时间',
  `coptTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`coptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_commposts` */

/*Table structure for table `gsnavigation_commpostscont` */

DROP TABLE IF EXISTS `gsnavigation_commpostscont`;

CREATE TABLE `gsnavigation_commpostscont` (
  `copctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copctIndexID` int(11) default '0' COMMENT '主表ID号',
  `copctType` int(5) default '0' COMMENT '类型',
  `copctIcon` int(5) default '0' COMMENT '小图标类型',
  `copctTop` int(2) default '0' COMMENT '是否置顶',
  `copctHot` int(2) default '0' COMMENT '是否热门',
  `copctEssence` int(2) default '0' COMMENT '是否精华:0,精1-现定5级',
  `copctZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `copctCount_Views` int(11) default '0' COMMENT '查看数',
  `copctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `copctCode_Main` int(11) default '8' COMMENT '总评分',
  `copctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `copctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `copctChannelid` text COMMENT '所属频道',
  `copctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `copctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `copctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `copctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `copctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `copctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `copctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `copctPageAble` int(2) default '0' COMMENT '是否分页',
  `copctPower_View` text COMMENT '用户查看权限',
  `copctSpicalPosition` text COMMENT '特殊位置',
  `copctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `copctSmallContent` varchar(180) default '-' COMMENT '简介',
  `copctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `copctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `copctMetaDescription` text COMMENT 'MetaDescription',
  `copctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `copctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `copctSources` text COMMENT '图集',
  `copctIntroduct` text COMMENT '详细介绍',
  `copctContent` text COMMENT '内容',
  `copctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `copctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `copctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `copctRemark` text COMMENT '备注',
  `copctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `copctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `copctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `copctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  PRIMARY KEY  (`copctID`),
  KEY `copctIndexID` (`copctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_commpostscont` */

/*Table structure for table `gsnavigation_commpostsdiscuss` */

DROP TABLE IF EXISTS `gsnavigation_commpostsdiscuss`;

CREATE TABLE `gsnavigation_commpostsdiscuss` (
  `copdtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copdtName` varchar(180) default '-' COMMENT '名称',
  `copdtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `copdtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `copdtParid` int(11) default '0' COMMENT '上级或分类ID',
  `copdtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `copdtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `copdtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `copdtCreateBy` int(11) default '0' COMMENT '发布人',
  `copdtCreateTime` datetime default NULL COMMENT '发布时间',
  `copdtTag` varchar(180) default '-' COMMENT '标签',
  `copdtBest` int(2) default '0' COMMENT '最佳回复',
  PRIMARY KEY  (`copdtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_commpostsdiscuss` */

/*Table structure for table `gsnavigation_commpostsdiscusscont` */

DROP TABLE IF EXISTS `gsnavigation_commpostsdiscusscont`;

CREATE TABLE `gsnavigation_commpostsdiscusscont` (
  `copdctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copdctIndexID` int(11) default '0' COMMENT '主表ID号',
  `copdctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `copdctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `copdctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `copdctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `copdctPower_View` text COMMENT '用户查看权限',
  `copdctSpicalPosition` text COMMENT '特殊位置',
  `copdctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `copdctContent` text COMMENT '内容',
  `copdctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `copdctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `copdctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `copdctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `copdctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `copdctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `copdctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `copdctRemark` text COMMENT '备注',
  PRIMARY KEY  (`copdctID`),
  KEY `copdctIndexID` (`copdctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_commpostsdiscusscont` */

/*Table structure for table `gsnavigation_commpostsgroup` */

DROP TABLE IF EXISTS `gsnavigation_commpostsgroup`;

CREATE TABLE `gsnavigation_commpostsgroup` (
  `copgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copgtName` varchar(180) default '-' COMMENT '名称',
  `copgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `copgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `copgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `copgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `copgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `copgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `copgtCreateBy` int(11) default '0' COMMENT '发布人',
  `copgtCreateTime` datetime default NULL COMMENT '发布时间',
  `copgtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`copgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_commpostsgroup` */

insert  into `gsnavigation_commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (1,'ROOT','-','-',0,0,2,31,0,NULL,'-');
insert  into `gsnavigation_commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (2,'网集分类','-','-',1,0,2,30,0,NULL,'-');
insert  into `gsnavigation_commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (3,'营销综合专区','-','-',2,0,2,29,0,'2010-10-05 15:26:22','-');

/*Table structure for table `gsnavigation_commpostsgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_commpostsgroupcont`;

CREATE TABLE `gsnavigation_commpostsgroupcont` (
  `copgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `copgctCount_Views` int(11) default '0' COMMENT '查看数',
  `copgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `copgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `copgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `copgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `copgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `copgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `copgctChannelid` text COMMENT '所属频道',
  `copgctModelid_List` int(11) default '0' COMMENT '列表模型',
  `copgctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `copgctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `copgctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `copgctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `copgctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `copgctPower_Public` int(11) default '0' COMMENT '用户发布权限',
  `copgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `copgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `copgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `copgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `copgctMetaDescription` text COMMENT 'MetaDescription',
  `copgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `copgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `copgctSources` text COMMENT '图集',
  `copgctIntroduct` text COMMENT '详细介绍',
  `copgctContent` text COMMENT '内容',
  `copgctRemark` text COMMENT '备注',
  `copgctMasterModerator` text COMMENT '超级版主',
  `copgctModerator` text COMMENT '版主',
  `copgctInfo_MasterModerator` varchar(180) default '-' COMMENT '超级版主文本',
  `copgctInfo_Moderator` varchar(180) default '-' COMMENT '版主文本',
  PRIMARY KEY  (`copgctID`),
  KEY `copgctIndexID` (`copgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_commpostsgroupcont` */

insert  into `gsnavigation_commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (1,1,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'../../../Uploadfiles/m_nimg/twitter-48px.png','-',NULL,NULL,NULL,NULL,NULL,NULL,'-','-');
insert  into `gsnavigation_commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (2,2,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'../../../Uploadfiles/m_nimg/twitter-48px.png','-',NULL,NULL,NULL,NULL,NULL,NULL,'-','-');
insert  into `gsnavigation_commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (3,3,0,0,0,0,0,0,0,'0',0,0,0,0,0,0,0,'-','-','-','-','','../../../Uploadfiles/m_nimg/twitter-48px.png','-','','','网络营销版块主要有网络营销论文、网络营销策略、网络营销策划、网络营销方案、网络营销案例等网络营销人学习的资料。','','','','-','营销论文、网络营销策略');

/*Table structure for table `gsnavigation_gsnavigationactive` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationactive`;

CREATE TABLE `gsnavigation_gsnavigationactive` (
  `gsnatID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnatName` varchar(250) default '-' COMMENT '名称',
  `gsnatNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `gsnatNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnatParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnatUnitid` int(11) default '0' COMMENT '团购导航供应商ID',
  `gsnatRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnatState` int(5) default '0' COMMENT '团购状态',
  `gsnatChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnatOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnatCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnatCreateTime` datetime default NULL COMMENT '发布时间',
  `gsnatTag` varchar(180) default '-' COMMENT '标签',
  `gsnatUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  `gsnatUserPublicGroupid` int(11) default '0' COMMENT '用户分类：0.管理员发布的,1.用户发布的，发布到个人博客,2.用户发布的，发布到企业网站,3.用户发布的，发布到企业网站和个人博客',
  `gsnatAlphabet` varchar(42) default 'A' COMMENT '首字母',
  `gsnatURL` varchar(180) default NULL COMMENT '网址',
  `gsnatZoneid` int(11) default '0' COMMENT '所属地区',
  `gsnatShoppingid` int(11) default '0' COMMENT '所属商圈',
  `gsnatBrandid` int(11) default '0' COMMENT '品牌ID',
  `gsnatRealshopid` int(11) default '0' COMMENT '所属实体店',
  `gsnatClassid` int(11) default '0' COMMENT '商品所属类别ID',
  PRIMARY KEY  (`gsnatID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationactive` */

/*Table structure for table `gsnavigation_gsnavigationactivecont` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationactivecont`;

CREATE TABLE `gsnavigation_gsnavigationactivecont` (
  `gsnactID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnactIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnactInfo_Numcode` varchar(180) default '-' COMMENT '团购站内，团购标识号',
  `gsnactPrice_StartTime` datetime default NULL COMMENT '团购开始时间',
  `gsnactPrice_EndTime` datetime default NULL COMMENT '团购结束时间',
  `gsnactPrice_Origin` decimal(9,2) default '0.00' COMMENT '原价',
  `gsnactPrice_Now` decimal(9,2) default '0.00' COMMENT '现价',
  `gsnactPrice_Sale` decimal(9,2) default '0.00' COMMENT '折扣',
  `gsnactPrice_Save` decimal(9,2) default '0.00' COMMENT '节省',
  `gsnactPrice_LimitPeople` int(11) default '12' COMMENT '最低团购人数',
  `gsnactPrice_LimitOnes` int(11) default '1' COMMENT '单人可购数量',
  `gsnactPrice_TotalCount` int(11) default '100' COMMENT '可订总数',
  `gsnactSpeak` text COMMENT '用户感言',
  `gsnactCom_Logo` varchar(180) default '..' COMMENT '公司LOGO',
  `gsnactCom_Introduct` text COMMENT '公司介绍',
  `gsnactMapIntroduct` text COMMENT '地图标签名称',
  `gsnactMapX` varchar(42) default '0' COMMENT '地图X座标',
  `gsnactMapY` varchar(42) default '0' COMMENT '地图Y座标',
  `gsnactCount_Order` int(11) default '0' COMMENT '订购人数',
  `gsnactCount_Views` int(11) default '0' COMMENT '查看数',
  `gsnactCount_Discuss` int(11) default '0' COMMENT '回复数',
  `gsnactCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnactCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnactChannelid` text COMMENT '所属频道',
  `gsnactRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `gsnactRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `gsnactModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `gsnactTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `gsnactDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `gsnactKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `gsnactKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `gsnactPageAble` int(2) default '0' COMMENT '是否分页',
  `gsnactPower_View` text COMMENT '用户查看权限',
  `gsnactPower_Public` text COMMENT '用户发布权限',
  `gsnactSpicalPosition` text COMMENT '特殊位置',
  `gsnactSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `gsnactSmallContent` varchar(180) default '-' COMMENT '简介',
  `gsnactMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `gsnactMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `gsnactMetaDescription` text COMMENT 'MetaDescription',
  `gsnactSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnactSourceR01` varchar(180) default '-' COMMENT '大图片',
  `gsnactSources` text COMMENT '图集',
  `gsnactIntroduct` text COMMENT '详细介绍',
  `gsnactContent` text COMMENT '内容',
  `gsnactPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `gsnactPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `gsnactPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `gsnactPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `gsnactPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `gsnactPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `gsnactPublisher_Address` varchar(180) default '-' COMMENT '联系地址',
  `gsnactPublisher_Numcode` varchar(180) default '-' COMMENT '邮编',
  `gsnactPublisher_Fax` varchar(180) default '-' COMMENT '传真',
  `gsnactPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `gsnactRemark` text COMMENT '备注',
  `gsnactZones` text COMMENT '开通地区',
  `gsnactShoppings` text COMMENT '开通商圈',
  `gsnactBrands` text COMMENT '所属品牌',
  `gsnactRealshops` text COMMENT '所属实体店',
  `gsnactUnits` text COMMENT '所属商家',
  PRIMARY KEY  (`gsnactID`),
  KEY `gsnactIndexID` (`gsnactIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationactivecont` */

/*Table structure for table `gsnavigation_gsnavigationactivediscuss` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationactivediscuss`;

CREATE TABLE `gsnavigation_gsnavigationactivediscuss` (
  `gsnadtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnadtName` varchar(180) default '-' COMMENT '名称',
  `gsnadtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `gsnadtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnadtParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnadtType` int(5) default '0' COMMENT '类型',
  `gsnadtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnadtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnadtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnadtCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnadtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`gsnadtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationactivediscuss` */

insert  into `gsnavigation_gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (1,'0','0','N_2011010921490153353',4,0,0,2,0,1,'2011-01-09 21:49:01');
insert  into `gsnavigation_gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (2,'0','0','N_2011011116550258483',0,0,0,0,0,1,'2011-01-11 16:55:02');
insert  into `gsnavigation_gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (3,'0','0','N_2011011116591893255',1,0,0,2,0,1,'2011-01-11 16:59:18');
insert  into `gsnavigation_gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (4,'0','0','N_2011011116595785644',7,0,0,2,0,1,'2011-01-11 16:59:57');
insert  into `gsnavigation_gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (5,'0','0','N_2011011117232768722',7,0,0,2,0,1,'2011-01-11 17:23:27');

/*Table structure for table `gsnavigation_gsnavigationactivediscusscont` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationactivediscusscont`;

CREATE TABLE `gsnavigation_gsnavigationactivediscusscont` (
  `gsnadctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnadctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnadctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnadctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnadctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `gsnadctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `gsnadctPower_View` text COMMENT '用户查看权限',
  `gsnadctSpicalPosition` text COMMENT '特殊位置',
  `gsnadctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnadctContent` text COMMENT '内容',
  `gsnadctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `gsnadctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `gsnadctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `gsnadctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `gsnadctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `gsnadctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `gsnadctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `gsnadctRemark` text COMMENT '备注',
  PRIMARY KEY  (`gsnadctID`),
  KEY `gsnadctIndexID` (`gsnadctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationactivediscusscont` */

insert  into `gsnavigation_gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (1,1,0,0,0,0,'0','0','0','有效期截止至2011年3月31日\r\n全国皆可购买，只限北京使用\r\n只接受电话预定，网上预定无效\r\n请提前预备200元/日押金\r\n请至少提前48小时电话预约 \r\n美团券之外续住按酒店门市价\r\n不可同时享受店内其他优惠','0','0','0','0','0','0','0','0');
insert  into `gsnavigation_gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (2,2,0,0,0,0,'0','0','0','123123123','0','0','0','0','0','0','0','0');
insert  into `gsnavigation_gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (3,3,0,0,0,0,'0','0','0','平时非常活泼的一个女孩被拍摄得唯美宁静，顿时让我对青禾很有信心，于是义无反顾','0','0','0','0','0','0','0','0');
insert  into `gsnavigation_gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (4,4,0,0,0,0,'0','0','0','全国范围均可购买，每人可购买多套\r\n仅限市区配送，购买前请致电快递公司确认是否配送\r\n团购结束后的第1个工作日开始配送','0','0','0','0','0','0','0','0');
insert  into `gsnavigation_gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (5,5,0,0,0,0,'0','0','0','24240','0','0','0','0','0','0','0','0');

/*Table structure for table `gsnavigation_gsnavigationactivegroup` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationactivegroup`;

CREATE TABLE `gsnavigation_gsnavigationactivegroup` (
  `gsnagtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnagtName` varchar(180) default '-' COMMENT '名称',
  `gsnagtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `gsnagtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnagtParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnagtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnagtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnagtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnagtCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnagtCreateTime` datetime default NULL COMMENT '发布时间',
  `gsnagtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`gsnagtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationactivegroup` */

insert  into `gsnavigation_gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (1,'ROOT','-','-',0,0,2,10,1,'2010-11-07 20:13:58','-');
insert  into `gsnavigation_gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (2,'网集团购网站分类','-','-',1,0,2,9,1,'2010-11-07 20:13:58','-');
insert  into `gsnavigation_gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (3,'餐饮美食','-','-',2,0,2,8,1,'2010-11-07 20:13:58','-');
insert  into `gsnavigation_gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (4,'休闲娱乐','-','-',2,0,2,7,1,'2010-11-07 20:13:58','-');
insert  into `gsnavigation_gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (5,'美容健身','-','-',2,0,2,6,1,'2010-11-07 20:13:58','-');
insert  into `gsnavigation_gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (8,'精品购物','-','-',2,0,2,3,1,'2010-11-07 20:13:59','-');
insert  into `gsnavigation_gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (9,'摄影写真','-','-',2,0,2,2,1,'2010-11-07 20:13:59','-');
insert  into `gsnavigation_gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (10,'其它','-','-',2,0,2,1,1,'2010-11-07 20:13:59','-');

/*Table structure for table `gsnavigation_gsnavigationactivegroupcont` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationactivegroupcont`;

CREATE TABLE `gsnavigation_gsnavigationactivegroupcont` (
  `gsnagctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnagctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnagctCount_Views` int(11) default '0' COMMENT '查看数',
  `gsnagctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `gsnagctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `gsnagctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `gsnagctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `gsnagctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnagctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnagctChannelid` text COMMENT '所属频道',
  `gsnagctModelid_List` int(11) default '0' COMMENT '列表模型',
  `gsnagctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `gsnagctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `gsnagctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `gsnagctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `gsnagctPower_View` text COMMENT '用户查看权限',
  `gsnagctPower_Public` text COMMENT '用户发布权限',
  `gsnagctSpicalPosition` text COMMENT '特殊位置',
  `gsnagctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `gsnagctSmallContent` varchar(180) default '-' COMMENT '简介',
  `gsnagctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `gsnagctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `gsnagctMetaDescription` text COMMENT 'MetaDescription',
  `gsnagctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnagctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `gsnagctSources` text COMMENT '图集',
  `gsnagctIntroduct` text COMMENT '详细介绍',
  `gsnagctContent` text COMMENT '内容',
  `gsnagctRemark` text COMMENT '备注',
  PRIMARY KEY  (`gsnagctID`),
  KEY `gsnagctIndexID` (`gsnagctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationactivegroupcont` */

insert  into `gsnavigation_gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (1,1,0,558,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (2,2,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (3,3,0,21,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (4,4,0,10,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (5,5,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (8,8,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (9,9,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (10,10,0,17,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);

/*Table structure for table `gsnavigation_gsnavigationunit` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationunit`;

CREATE TABLE `gsnavigation_gsnavigationunit` (
  `gsnutID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnutName` varchar(180) default '-' COMMENT '名称',
  `gsnutNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `gsnutNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnutParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnutRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnutChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnutOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnutCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnutCreateTime` datetime default NULL COMMENT '发布时间',
  `gsnutTag` varchar(180) default '-' COMMENT '标签',
  `gsnutUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  `gsnutUserPublicGroupid` int(11) default '0' COMMENT '用户分类：0.管理员发布的,1.用户发布的，发布到个人博客,2.用户发布的，发布到企业网站,3.用户发布的，发布到企业网站和个人博客',
  `gsnutAlphabet` varchar(42) default 'A' COMMENT '首字母',
  `gsnutURL` varchar(180) default '-' COMMENT '网址',
  `gsnutZoneid` int(11) default '0' COMMENT '所属地区',
  `gsnutShoppingid` int(11) default '0' COMMENT '所属商圈',
  `gsnutType` int(2) default '0' COMMENT '类型',
  PRIMARY KEY  (`gsnutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationunit` */

insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (1,'美团','-','-',1,0,2,0,1,'2011-06-04 16:01:38','-',0,0,'A','http://www.meituan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (2,'拉手','-','GS_201001010101212',1,0,2,0,1,'2011-06-04 18:52:01','-',0,0,'A','http://www.lashou.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (3,'24券','-','-',1,0,2,0,1,'2011-06-04 18:58:27','-',0,0,'A','http://www.24quan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (4,'满座','-','-',1,0,2,0,1,'2011-06-04 19:09:14','-',0,0,'A','http://www.manzuo.com/i/68883.htm',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (5,'格鲁','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.gelu.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (6,'米奇网','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.miqi.cn/r.php?r=5859',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (7,'G团网','-','-',1,0,2,0,1,'2011-06-04 19:15:13','-',0,0,'A','http://www.gtuan.com/',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (8,'易购团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.egotuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (9,'饭统饭团','-','-',1,0,2,0,1,'2011-06-04 19:12:12','-',0,0,'A','http://tuan.fantong.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (10,'57团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.95171.cn/buy/invite/510998500',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (11,'葆生团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.baoshengtuan.com/index.php',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (12,'80社团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.80stuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (13,'姐妹团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.sistuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (14,'聚美优品','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.jumei.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (15,'唯伊团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.w1.cn/tuan.html',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (16,'窝窝团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.55tuan.com/?u=46308',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (17,'糯米','-','-',1,0,2,0,1,'2011-06-04 19:18:31','-',0,0,'A','http://www.nuomi.com/',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (18,'新浪团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://life.sina.com.cn/tuan/r/1JVfHrwrJP-HrDz7UrBvjMYSAM6',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (19,'爱帮团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.aibang.com/?area=tuan',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (20,'F团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.ftuan.com/r.php?r=56036',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (21,'团宝','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.groupon.cn',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (22,'YOKA优享团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.yoka.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (23,'搜狐爱家','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.sohu.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (24,'酷团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.kutuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (25,'快团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.pclady.com.cn/invite/i37608',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (26,'喜团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.xituan.com/r.php?r=NTQ1NTQ=',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (27,'阿丫团','-','-',1,0,2,0,1,'2011-06-04 19:11:12','-',0,0,'A','http://www.ayatuan.com/',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (28,'联合购买','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.cobuy.net',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (29,'58团购','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://t.58.com/invite/bj/garrclke',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (30,'点评团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://t.dianping.com/i/6476533/c/1',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (31,'如意团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.ruyituan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (32,'嘀嗒团','-','-',1,0,2,0,1,'2011-06-04 19:19:51','-',0,0,'A','http://www.didatuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (33,'品牌团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.pptg.cn/index.php?res=tuan138.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (34,'偶的团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://oudetuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (35,'聚乐淘','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://j.juletao.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (36,'粉皮儿','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://fenpier.com/r.php?r=54760',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (37,'美尚','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.makeups.cn/Index.html',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (38,'买美诚品','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.51maimei.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (39,'梧桐团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://t.wutoo.cn/r.php?r=18778',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (40,'5151团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.5151tuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (41,'中团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.029678.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (42,'购乐团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.goletuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (43,'婚嫁团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuangou.6899.cn',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (44,'婴团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.Ytuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (45,'赶团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.runtuan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (46,'团酷','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.tuanku.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (47,'红爪网','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.hongzhua.cn',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (48,'疯狂卖客','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://crazymike.cn/index.asp?utm_source=refer&utm_campaign=referer50&partner=user_refer&affcode=user_refer_27039',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (49,'现在团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.xianzaituan.com',0,0,0);
insert  into `gsnavigation_gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (50,'小团团购','-','-',3,0,2,0,1,'2011-05-28 20:40:55','-',0,0,'X','http://groupsale.unionnets.com',0,0,0);

/*Table structure for table `gsnavigation_gsnavigationunitcont` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationunitcont`;

CREATE TABLE `gsnavigation_gsnavigationunitcont` (
  `gsnuctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnuctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnuctCount_Views` int(11) default '0' COMMENT '查看数',
  `gsnuctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `gsnuctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnuctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnuctChannelid` text COMMENT '所属频道',
  `gsnuctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `gsnuctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `gsnuctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `gsnuctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `gsnuctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `gsnuctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `gsnuctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `gsnuctPageAble` int(2) default '0' COMMENT '是否分页',
  `gsnuctPower_View` text COMMENT '用户查看权限',
  `gsnuctPower_Public` text COMMENT '用户发布权限',
  `gsnuctSpicalPosition` text COMMENT '特殊位置',
  `gsnuctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `gsnuctSmallContent` varchar(180) default '-' COMMENT '简介',
  `gsnuctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `gsnuctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `gsnuctMetaDescription` text COMMENT 'MetaDescription',
  `gsnuctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnuctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `gsnuctSources` text COMMENT '图集',
  `gsnuctIntroduct` text COMMENT '详细介绍',
  `gsnuctContent` text COMMENT '内容',
  `gsnuctRemark` text COMMENT '备注',
  `gsnuctInfo_Zones` text COMMENT '开通地区',
  `gsnuctInfo_PublishTime` varchar(180) default '-' COMMENT '上线时间',
  `gsnuctInfo_SaleType` int(5) default '0' COMMENT '购买类型',
  `gsnuctInfo_SiteType` int(5) default '0' COMMENT '网站类型',
  `gsnuctInfo_ActiveFrequency` int(5) default '0' COMMENT '组织频率',
  `gsnuctInfo_OrderCount` int(5) default '0' COMMENT '购买人数',
  `gsnuctInfo_Contact` text COMMENT '联系方式',
  `gsnuctFlow_Alex` varchar(180) default '-' COMMENT '网站流量与排名情况(Alex)',
  `gsnuctURL_API` varchar(180) default '-' COMMENT '数据API地址',
  `gsnuctMapIntroduct` varchar(180) default '-' COMMENT '地图标签名称',
  `gsnuctMapX` varchar(42) default '-' COMMENT '地图X座标',
  `gsnuctMapY` varchar(42) default '-' COMMENT '地图Y座标',
  `gsnuctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `gsnuctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `gsnuctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `gsnuctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `gsnuctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `gsnuctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `gsnuctPublisher_Address` varchar(180) default '-' COMMENT '联系地址',
  `gsnuctPublisher_Numcode` varchar(180) default '-' COMMENT '邮编',
  `gsnuctPublisher_Fax` varchar(180) default '-' COMMENT '传真',
  `gsnudctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `gsnuctURL_XML` varchar(180) default '-' COMMENT 'XML方式采集地址，由供应商提供',
  `gsnuctURL_Type` int(5) default '0' COMMENT '采集方式',
  `gsnuctURL_Auto` int(2) default '0' COMMENT '是否自动采集，0否，1是',
  `gsnuctURL_Lasttime` varchar(42) default '' COMMENT '最后采集时间',
  `gsnuctURL_Charset` varchar(42) default 'UTF-8' COMMENT '字符设置',
  `gsnuctURL_Weburl` text COMMENT 'WEB采集方式地址集',
  `gsnuctZones` text COMMENT '开通地区',
  `gsnuctShoppings` text COMMENT '开通商圈',
  `gsnuctCount_Good` int(5) default '0' COMMENT '好评',
  `gsnuctCount_Active` int(5) default '0' COMMENT '活跃',
  `gsnuctCount_Groupsale` int(11) default '0' COMMENT '团购数',
  `gsnuctCount_Complaints` int(11) default '0' COMMENT '总投拆',
  `gsnuctCount_Resolution` decimal(9,2) default '0.00' COMMENT '解决率',
  PRIMARY KEY  (`gsnuctID`),
  KEY `gsnuctIndexID` (`gsnuctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationunitcont` */

insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (1,1,5,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','http://www.meituan.com/wuhan<!---RTB.SPLIT1--->http://www.meituan.com/wuhan\r\n\r\nRULE/meituan_com_groupsalelist.php<!---RTB.SPLIT1--->RULE/meituan_com_groupsaledetail.php<!---RTB.SPLIT1--->RULE/meituan_com_groupsaleclass.php','394,180,149,88,52,','-',0,0,0,0,'-','-','http://www.meituan.com/api/v1/','-','-','-','-','-','-','-','-','-','-','-','-','-','http://www.meituan.com/api/v1/',3,0,'2011-01-28 13:47:44','UTF-8','美团北京地区采集\r\nhttp://www.meituan.com/api/v1/beijing/deals\r\nhttp://www.meituan.com/api/v1/beijing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n北京\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团上海地区采集\r\nhttp://www.meituan.com/api/v1/shanghai/deals\r\nhttp://www.meituan.com/api/v1/shanghai/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n上海\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团广州地区采集\r\nhttp://www.meituan.com/api/v1/guangzhou/deals\r\nhttp://www.meituan.com/api/v1/guangzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n广州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团深圳地区采集\r\nhttp://www.meituan.com/api/v1/shenzhen/deals\r\nhttp://www.meituan.com/api/v1/shenzhen/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n深圳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团天津地区采集\r\nhttp://www.meituan.com/api/v1/tianjin/deals\r\nhttp://www.meituan.com/api/v1/tianjin/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n天津\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团西安地区采集\r\nhttp://www.meituan.com/api/v1/xian/deals\r\nhttp://www.meituan.com/api/v1/xian/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n西安\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团福州地区采集\r\nhttp://www.meituan.com/api/v1/fuzhou/deals\r\nhttp://www.meituan.com/api/v1/fuzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n福州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团重庆地区采集\r\nhttp://www.meituan.com/api/v1/chongqing/deals\r\nhttp://www.meituan.com/api/v1/chongqing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n重庆\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团杭州地区采集\r\nhttp://www.meituan.com/api/v1/hangzhou/deals\r\nhttp://www.meituan.com/api/v1/hangzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n杭州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团南京地区采集\r\nhttp://www.meituan.com/api/v1/nanjing/deals\r\nhttp://www.meituan.com/api/v1/nanjing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n南京\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团合肥地区采集\r\nhttp://www.meituan.com/api/v1/hefei/deals\r\nhttp://www.meituan.com/api/v1/hefei/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n合肥\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团武汉地区采集\r\nhttp://www.meituan.com/api/v1/wuhan/deals\r\nhttp://www.meituan.com/api/v1/wuhan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n武汉\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团郑州地区采集\r\nhttp://www.meituan.com/api/v1/zhengzhou/deals\r\nhttp://www.meituan.com/api/v1/zhengzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n郑州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团成都地区采集\r\nhttp://www.meituan.com/api/v1/chengdu/deals\r\nhttp://www.meituan.com/api/v1/chengdu/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n成都\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团青岛地区采集\r\nhttp://www.meituan.com/api/v1/qingdao/deals\r\nhttp://www.meituan.com/api/v1/qingdao/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n青岛\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团厦门地区采集\r\nhttp://www.meituan.com/api/v1/xiamen/deals\r\nhttp://www.meituan.com/api/v1/xiamen/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n厦门\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团大连地区采集\r\nhttp://www.meituan.com/api/v1/dalian/deals\r\nhttp://www.meituan.com/api/v1/dalian/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n大连\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团沈阳地区采集\r\nhttp://www.meituan.com/api/v1/shenyang/deals\r\nhttp://www.meituan.com/api/v1/shenyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n沈阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团长沙地区采集\r\nhttp://www.meituan.com/api/v1/changsha/deals\r\nhttp://www.meituan.com/api/v1/changsha/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n长沙\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团石家庄地区采集\r\nhttp://www.meituan.com/api/v1/shijiazhuang/deals\r\nhttp://www.meituan.com/api/v1/shijiazhuang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n石家庄\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团苏州地区采集\r\nhttp://www.meituan.com/api/v1/suzhou/deals\r\nhttp://www.meituan.com/api/v1/suzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n苏州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团宁波地区采集\r\nhttp://www.meituan.com/api/v1/ningbo/deals\r\nhttp://www.meituan.com/api/v1/ningbo/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n宁波\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团无锡地区采集\r\nhttp://www.meituan.com/api/v1/wuxi/deals\r\nhttp://www.meituan.com/api/v1/wuxi/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n无锡\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团昆明地区采集\r\nhttp://www.meituan.com/api/v1/kunming/deals\r\nhttp://www.meituan.com/api/v1/kunming/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n昆明\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团济南地区采集\r\nhttp://www.meituan.com/api/v1/jinan/deals\r\nhttp://www.meituan.com/api/v1/jinan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n济南\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团哈尔滨地区采集\r\nhttp://www.meituan.com/api/v1/haerbin/deals\r\nhttp://www.meituan.com/api/v1/haerbin/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n哈尔滨\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团南通地区采集\r\nhttp://www.meituan.com/api/v1/nantong/deals\r\nhttp://www.meituan.com/api/v1/nantong/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n南通\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团东莞地区采集\r\nhttp://www.meituan.com/api/v1/dongguan/deals\r\nhttp://www.meituan.com/api/v1/dongguan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n东莞\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团南宁地区采集\r\nhttp://www.meituan.com/api/v1/nanning/deals\r\nhttp://www.meituan.com/api/v1/nanning/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n南宁\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团长春地区采集\r\nhttp://www.meituan.com/api/v1/changchun/deals\r\nhttp://www.meituan.com/api/v1/changchun/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n长春\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团汕头地区采集\r\nhttp://www.meituan.com/api/v1/shantou/deals\r\nhttp://www.meituan.com/api/v1/shantou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n汕头\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团贵阳地区采集\r\nhttp://www.meituan.com/api/v1/guiyang/deals\r\nhttp://www.meituan.com/api/v1/guiyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n贵阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团温州地区采集\r\nhttp://www.meituan.com/api/v1/wenzhou/deals\r\nhttp://www.meituan.com/api/v1/wenzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n温州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团太原地区采集\r\nhttp://www.meituan.com/api/v1/taiyuan/deals\r\nhttp://www.meituan.com/api/v1/taiyuan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n太原\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团烟台地区采集\r\nhttp://www.meituan.com/api/v1/yantai/deals\r\nhttp://www.meituan.com/api/v1/yantai/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n烟台\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团常州地区采集\r\nhttp://www.meituan.com/api/v1/changzhou/deals\r\nhttp://www.meituan.com/api/v1/changzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n常州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团乌鲁木齐地区采集\r\nhttp://www.meituan.com/api/v1/wulumuqi/deals\r\nhttp://www.meituan.com/api/v1/wulumuqi/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n乌鲁木齐\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团佛山地区采集\r\nhttp://www.meituan.com/api/v1/foshan/deals\r\nhttp://www.meituan.com/api/v1/foshan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n佛山\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团保定地区采集\r\nhttp://www.meituan.com/api/v1/baoding/deals\r\nhttp://www.meituan.com/api/v1/baoding/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n保定\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团兰州地区采集\r\nhttp://www.meituan.com/api/v1/lanzhou/deals\r\nhttp://www.meituan.com/api/v1/lanzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n兰州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团包头地区采集\r\nhttp://www.meituan.com/api/v1/baotou/deals\r\nhttp://www.meituan.com/api/v1/baotou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n包头\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团南昌地区采集\r\nhttp://www.meituan.com/api/v1/nanchang/deals\r\nhttp://www.meituan.com/api/v1/nanchang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n南昌\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团呼和浩特地区采集\r\nhttp://www.meituan.com/api/v1/huhehaote/deals\r\nhttp://www.meituan.com/api/v1/huhehaote/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n呼和浩特\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团唐山地区采集\r\nhttp://www.meituan.com/api/v1/tangshan/deals\r\nhttp://www.meituan.com/api/v1/tangshan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n唐山\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团嘉兴地区采集\r\nhttp://www.meituan.com/api/v1/jiaxing/deals\r\nhttp://www.meituan.com/api/v1/jiaxing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n嘉兴\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团大庆地区采集\r\nhttp://www.meituan.com/api/v1/daqing/deals\r\nhttp://www.meituan.com/api/v1/daqing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n大庆\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团岳阳地区采集\r\nhttp://www.meituan.com/api/v1/yueyang/deals\r\nhttp://www.meituan.com/api/v1/yueyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n岳阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团徐州地区采集\r\nhttp://www.meituan.com/api/v1/xuzhou/deals\r\nhttp://www.meituan.com/api/v1/xuzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n徐州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团惠州地区采集\r\nhttp://www.meituan.com/api/v1/huizhou/deals\r\nhttp://www.meituan.com/api/v1/huizhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n惠州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团扬州地区采集\r\nhttp://www.meituan.com/api/v1/yangzhou/deals\r\nhttp://www.meituan.com/api/v1/yangzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n扬州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团拉萨地区采集\r\nhttp://www.meituan.com/api/v1/lasa/deals\r\nhttp://www.meituan.com/api/v1/lasa/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n拉萨\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团柳州地区采集\r\nhttp://www.meituan.com/api/v1/liuzhou/deals\r\nhttp://www.meituan.com/api/v1/liuzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n柳州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团泉州地区采集\r\nhttp://www.meituan.com/api/v1/quanzhou/deals\r\nhttp://www.meituan.com/api/v1/quanzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n泉州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团泰州地区采集\r\nhttp://www.meituan.com/api/v1/taizhou/deals\r\nhttp://www.meituan.com/api/v1/taizhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n泰州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团洛阳地区采集\r\nhttp://www.meituan.com/api/v1/luoyang/deals\r\nhttp://www.meituan.com/api/v1/luoyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n洛阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团海口地区采集\r\nhttp://www.meituan.com/api/v1/haikou/deals\r\nhttp://www.meituan.com/api/v1/haikou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n海口\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团湛江地区采集\r\nhttp://www.meituan.com/api/v1/zhanjiang/deals\r\nhttp://www.meituan.com/api/v1/zhanjiang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n湛江\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团潍坊地区采集\r\nhttp://www.meituan.com/api/v1/weifang/deals\r\nhttp://www.meituan.com/api/v1/weifang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n潍坊\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团珠海地区采集\r\nhttp://www.meituan.com/api/v1/zhuhai/deals\r\nhttp://www.meituan.com/api/v1/zhuhai/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n珠海\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团盐城地区采集\r\nhttp://www.meituan.com/api/v1/yancheng/deals\r\nhttp://www.meituan.com/api/v1/yancheng/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n盐城\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团秦皇岛地区采集\r\nhttp://www.meituan.com/api/v1/qinhuangdao/deals\r\nhttp://www.meituan.com/api/v1/qinhuangdao/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n秦皇岛\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团绍兴地区采集\r\nhttp://www.meituan.com/api/v1/shaoxing/deals\r\nhttp://www.meituan.com/api/v1/shaoxing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n绍兴\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团芜湖地区采集\r\nhttp://www.meituan.com/api/v1/wuhu/deals\r\nhttp://www.meituan.com/api/v1/wuhu/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n芜湖\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团衡阳地区采集\r\nhttp://www.meituan.com/api/v1/hengyang/deals\r\nhttp://www.meituan.com/api/v1/hengyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n衡阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团西宁地区采集\r\nhttp://www.meituan.com/api/v1/xining/deals\r\nhttp://www.meituan.com/api/v1/xining/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n西宁\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团银川地区采集\r\nhttp://www.meituan.com/api/v1/yinchuan/deals\r\nhttp://www.meituan.com/api/v1/yinchuan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n银川\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团镇江地区采集\r\nhttp://www.meituan.com/api/v1/zhenjiang/deals\r\nhttp://www.meituan.com/api/v1/zhenjiang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n镇江\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团香港地区采集\r\nhttp://www.meituan.com/api/v1/xianggang/deals\r\nhttp://www.meituan.com/api/v1/xianggang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n香港\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团澳门地区采集\r\nhttp://www.meituan.com/api/v1/aomen/deals\r\nhttp://www.meituan.com/api/v1/aomen/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n澳门\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团台北地区采集\r\nhttp://www.meituan.com/api/v1/taibei/deals\r\nhttp://www.meituan.com/api/v1/taibei/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n台北\r\n1\r\n<!---RTB.SPLIT1--->','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (2,2,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','0','-',0,0,0,0,'-','-','http://127.0.0.1:8080/_PROGRAM/MYPROJECT/Project0/unionNets/Program/version_0.042/unionNets/User/project/_DemoCore/webSite/Html/Xml/Groupsale/Groupsale_Data.xml','-','-','-','-','-','-','-','-','-','-','-','-','-','http://open.client.lashou.com/v1/hao123',2,0,'2011-02-17 14:16:57','UTF-8','拉手当日采集\r\nhttp://open.client.lashou.com/list/api/\r\nhttp://open.client.lashou.com/list/api/\r\nRULE/lashou_api_gsactivelist.php\r\nRULE/lashou_api_gsactivedetail.php\r\nRULE/lashou_api_gsactiveclass.php\r\n1\r\n1\r\n<!---RTB.SPLIT1--->','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (3,3,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','0','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://www.24quan.com/api/alliance.php',4,0,'2011-01-28 13:47:44','UTF-8','24券当日采集\r\nhttp://www.24quan.com/api/alliance.php\r\nhttp://www.24quan.com/api/alliance.php\r\nRULE/24quan_api_gsactivelist.php\r\nRULE/24quan_api_gsactivedetail.php\r\nRULE/24quan_api_gsactiveclass.php\r\n1\r\n1\r\n<!---RTB.SPLIT1--->','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (4,4,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://api.manzuo.com/common.xml',5,0,'2011-01-08 02:38:31','UTF-8','','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (5,5,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'2011-01-08 02:38:31','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (6,6,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (7,7,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://all.gtuan.com/api/',2,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (8,8,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (9,9,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (10,10,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (11,11,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (12,12,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (13,13,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (14,14,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (15,15,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (16,16,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (17,17,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://www.nuomi.com/api/dailydeal?version=v1&city=wuhan&city=xian',2,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (18,18,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (19,19,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (20,20,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (21,21,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (22,22,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (23,23,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (24,24,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (25,25,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (26,26,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (27,27,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://api.ayatuan.com/api/hao123/apihao123.xml',2,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (28,28,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (29,29,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (30,30,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (31,31,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (32,32,1,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://didatuan.com/api/baidu.php',2,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (33,33,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (34,34,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (35,35,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (36,36,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (37,37,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (38,38,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (39,39,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (40,40,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (41,41,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (42,42,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (43,43,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (44,44,1,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (45,45,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (46,46,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (47,47,1,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (48,48,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (49,49,1,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `gsnavigation_gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (50,50,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://127.0.0.1:8080/_PROGRAM/MYPROJECT/unionnets_com/unionnets_0042/webSite/Site_0/User/Project/_DemoCore/webSite/Html/Xml/Groupsale/Groupsale_Data.xml',1,0,'','UTF-8','','','',0,0,0,0,'0.00');

/*Table structure for table `gsnavigation_gsnavigationunitdiscuss` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationunitdiscuss`;

CREATE TABLE `gsnavigation_gsnavigationunitdiscuss` (
  `gsnudtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnudtName` varchar(180) default '-' COMMENT '名称',
  `gsnudtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `gsnudtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnudtParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnudtType` int(5) default '0' COMMENT '类型',
  `gsnudtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnudtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnudtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnudtCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnudtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`gsnudtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationunitdiscuss` */

/*Table structure for table `gsnavigation_gsnavigationunitdiscusscont` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationunitdiscusscont`;

CREATE TABLE `gsnavigation_gsnavigationunitdiscusscont` (
  `gsnudctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnudctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnudctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnudctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnudctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `gsnudctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `gsnudctPower_View` text COMMENT '用户查看权限',
  `gsnudctSpicalPosition` text COMMENT '特殊位置',
  `gsnudctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnudctContent` text COMMENT '内容',
  `gsnudctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `gsnudctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `gsnudctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `gsnudctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `gsnudctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `gsnudctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `gsnudctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `gsnudctRemark` text COMMENT '备注',
  PRIMARY KEY  (`gsnudctID`),
  KEY `gsnudctIndexID` (`gsnudctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationunitdiscusscont` */

/*Table structure for table `gsnavigation_gsnavigationunitgroup` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationunitgroup`;

CREATE TABLE `gsnavigation_gsnavigationunitgroup` (
  `gsnugtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnugtName` varchar(180) default '-' COMMENT '名称',
  `gsnugtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `gsnugtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnugtParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnugtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnugtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnugtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnugtCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnugtCreateTime` datetime default NULL COMMENT '发布时间',
  `gsnugtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`gsnugtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationunitgroup` */

insert  into `gsnavigation_gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (1,'ROOT','-','-',0,0,2,10,0,NULL,'-');
insert  into `gsnavigation_gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (2,'网集团购网站分类','-','-',1,0,2,9,0,NULL,'-');
insert  into `gsnavigation_gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (3,'餐饮美食','-','-',2,0,2,8,0,NULL,'-');
insert  into `gsnavigation_gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (4,'休闲娱乐','-','-',2,0,2,7,0,NULL,'-');
insert  into `gsnavigation_gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (5,'美容健身','-','-',2,0,2,6,0,NULL,'-');
insert  into `gsnavigation_gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (8,'精品购物','-','-',2,0,2,3,0,NULL,'-');
insert  into `gsnavigation_gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (9,'摄影写真','-','-',2,0,2,2,0,NULL,'-');
insert  into `gsnavigation_gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (10,'其它','-','-',2,0,2,1,0,NULL,'-');

/*Table structure for table `gsnavigation_gsnavigationunitgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_gsnavigationunitgroupcont`;

CREATE TABLE `gsnavigation_gsnavigationunitgroupcont` (
  `gsnugctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnugctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnugctCount_Views` int(11) default '0' COMMENT '查看数',
  `gsnugctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `gsnugctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `gsnugctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `gsnugctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `gsnugctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnugctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnugctChannelid` text COMMENT '所属频道',
  `gsnugctModelid_List` int(11) default '0' COMMENT '列表模型',
  `gsnugctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `gsnugctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `gsnugctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `gsnugctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `gsnugctPower_View` text COMMENT '用户查看权限',
  `gsnugctPower_Public` text COMMENT '用户发布权限',
  `gsnugctSpicalPosition` text COMMENT '特殊位置',
  `gsnugctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `gsnugctSmallContent` varchar(180) default '-' COMMENT '简介',
  `gsnugctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `gsnugctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `gsnugctMetaDescription` text COMMENT 'MetaDescription',
  `gsnugctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnugctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `gsnugctSources` text COMMENT '图集',
  `gsnugctIntroduct` text COMMENT '详细介绍',
  `gsnugctContent` text COMMENT '内容',
  `gsnugctRemark` text COMMENT '备注',
  PRIMARY KEY  (`gsnugctID`),
  KEY `gsnugctIndexID` (`gsnugctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_gsnavigationunitgroupcont` */

insert  into `gsnavigation_gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (1,1,0,9,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (2,2,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (3,3,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (4,4,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (5,5,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (8,8,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (9,9,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (10,10,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);

/*Table structure for table `gsnavigation_netssysconfiggroup` */

DROP TABLE IF EXISTS `gsnavigation_netssysconfiggroup`;

CREATE TABLE `gsnavigation_netssysconfiggroup` (
  `scgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `scgtName` varchar(180) default '-' COMMENT '名称',
  `scgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `scgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `scgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `scgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `scgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  PRIMARY KEY  (`scgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysconfiggroup` */

insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (1,'Root','-',0,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (2,'核心配置','-',1,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (3,'基本设置','-',2,0,2,20);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (4,'平台路径','-',2,0,2,19);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (5,'高级','-',2,0,2,18);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (6,'网址路径','-',2,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (7,'模块功能','-',15,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (8,'附件','-',2,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (9,'系统设置路径','-',2,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (10,'手机','-',2,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (11,'其它','-',2,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (12,'缓存','-',2,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (13,'其它','N_2009110911274745043',15,0,2,10);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (14,'上传','N_2009110913023356506',15,0,2,14);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (15,'商务平台配置','N_2009112021054835998',1,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (16,'基本设置','N_2009112021104980264',15,0,2,15);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (17,'电子邮件','N_2009120200440589990',15,0,2,12);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (18,'过滤','N_2009120200482964440',15,0,2,13);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (19,'用户','N_2009120200484617984',2,0,2,11);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (20,'审核默认','N_2010031223360780554',15,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (21,'地图','N_2010031805113553512',2,0,2,0);
insert  into `gsnavigation_netssysconfiggroup`(`scgtID`,`scgtName`,`scgtNumCode`,`scgtParid`,`scgtRecycle`,`scgtChecked`,`scgtOrderBy`) values (22,'电子邮件','N_20100615003958506',2,0,2,0);

/*Table structure for table `gsnavigation_netssysconfiginfo` */

DROP TABLE IF EXISTS `gsnavigation_netssysconfiginfo`;

CREATE TABLE `gsnavigation_netssysconfiginfo` (
  `scitID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `scitName` varchar(180) default '-' COMMENT '名称',
  `scitNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `scitSign` varchar(42) default '-' COMMENT '标志位',
  `scitParid` int(11) default '0' COMMENT '上级或分类ID',
  `scitRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `scitChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `scitOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `scitUiType` varchar(42) default 'Non' COMMENT 'UI控件类型',
  `scitUiLen` int(9) default '180' COMMENT 'UI控件长度',
  `scitDefaultValue` text COMMENT '默认值',
  `scitUserValue` text COMMENT '用户值',
  `scitEnable` int(2) default '0' COMMENT '是否可以修改',
  `scitOptionAR` int(11) default '0' COMMENT '绑定值',
  `scitIntroduct` text COMMENT '说明',
  PRIMARY KEY  (`scitID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysconfiginfo` */

insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (1,'原始Title','-','sysTitle',3,0,2,10,'Text',180,'网集软件 - 在线商务办公平台','网集软件 - 商务办公平台',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (2,'原始Keyword','-','sysKeyword',3,0,2,9,'Text',180,'内容管理平台,客户关系管理平台,理财平台,项目管理平台,财务管理平台','内容管理、客户关系管理、项目管理、团购、团购导航、财务管理、物流管理、虚拟主机管理、界面库、商城、社区',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (3,'原始Description','-','sysDescription',3,0,2,8,'TextArea',180,'网集软件.在线商务办公平台:主要有内容管理、客户关系管理、理财、项目管理、财务管理平台','网集软件：内容管理、客户关系管理、项目管理、团购、团购导航、财务管理、物流管理、虚拟主机管理、界面库、商城、社区',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (4,'原始Version','-','sysVersion',3,0,2,7,'TextArea',180,'网集 - 在线商务办公平台 v0.042 beta 1','网集软件 - 商务办公平台 v0.042 beta 1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (5,'核心版本号','-','netsCoreVersion',5,0,2,19,'Text',180,'Nets core version 0.042 beta 1 , prower by: www.unionnets.com','Nets core version 0.042 beta 1 , prower by: www.unionnets.com',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (6,'核心加密字符串','-','coreKeyword',5,0,2,69,'Text',180,'4JGBN96JSFDSF','4JGBN96JSFDSF',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (7,'用户目录分片大小','-','UserDirSectionSize',5,0,2,68,'Text',180,'300','300',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (8,'用户目录，模板路径','-','UserDirPathTemplate',4,0,2,100,'Text',180,'../../../../../../../User/n0_0/Template/','../../../../../../../User/n0_0/Template/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (9,'用户目录存放路径字符模板','-','UserDirPathString',4,0,2,99,'Text',180,'../../../../../../../User/','../../../../../../../User/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (10,'数据库存放路径(Access)','-','UserDirDataPath',9,0,2,98,'Text',180,'Inc/netsDb/','Inc/netsDb/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (11,'核心平台登陆地址','-','SystemLoginAddress',6,0,2,90,'Text',180,'Mana/m_nets/user/default.php','Mana/m_nets/user/default.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (12,'核心平台主页地址','-','SystemMainAddress',6,0,2,89,'Text',180,'Mana/m_nets/user/main.php','Mana/m_nets/user/main.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (13,'核心平台登出地址','-','SystemLogoutAddress',6,0,2,88,'Text',180,'Mana/m_nets/Other/Logout.php','Mana/m_nets/Other/Logout.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (14,'用户平台登陆地址','-','PlatformLoginAddress',6,0,2,80,'Text',180,'Platform/m_nets/user/default.php','Platform/m_nets/user/default.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (15,'用户平台主页地址','-','PlatformMainAddress',6,0,2,79,'Text',180,'Platform/m_nets/user/main.php','Platform/m_nets/user/main.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (16,'用户平台登出地址','-','PlatformLogoutAddress',6,0,2,78,'Text',180,'Platform/m_nets/Other/Logout.php','Platform/m_nets/Other/Logout.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (17,'是否启用邮件帐号','-','EmailAble',17,0,2,8,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (18,'平台网址','-','userSiteUrl',0,0,2,0,'Text',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (19,'平台名称(Meta.Title)','-','userMetaTitle',0,0,2,0,'Text',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (20,'平台关键字(Meta.Keyword)','-','userMetaKeyword',0,0,2,0,'Text',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (21,'平台描述(Meta.Description)','-','userMetaDescription',0,0,2,0,'TextArea',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (22,'允许上传的附件类型','-','userUploadFileType',0,0,2,0,'Text',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (23,'邮件服务器地址','-','EmailHost',17,0,2,7,'Text',180,'mail.unionnets.com','mail.unionnets.com',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (24,'邮件服务器用户名','-','EmailName',17,0,2,4,'Text',180,'vir@unionnets.com','vir@unionnets.com',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (25,'缩略图大小','-','userUploadThumbSize',14,0,2,18,'Text',180,'100','100',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (26,'邮件服务器密码','-','EmailPxd',17,0,2,3,'Pxd',180,'1234567abc','1234567abc',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (27,'水印添加条件','-','ThumbWaterCondition',14,0,2,3,'Text',180,'120,120','120,120',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (28,'注册时发送的邮件模板','-','EmailRegTemplate',22,0,2,2,'TextArea',180,'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户注册通知邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）注册通知邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n欢迎您加入{Nets.Title}！我们希望能您带来更好的服务与产品。<br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户注册通知邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）注册通知邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n欢迎您加入{Nets.Title}！我们希望能您带来更好的服务与产品。<br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (29,'找回密码时发送的邮件模板','-','EmailFindpxdTemplate',22,0,2,1,'TextArea',180,'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户找回密码邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）的用户找回密码邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n请点击以下链接进入密码修改页面（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/Common/User/FindPxd.php?ActionType=Sendcode&Sendcode={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/Common/User/FindPxd.php?ActionType=Sendcode&Sendcode={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户找回密码邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）的用户找回密码邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n请点击以下链接进入密码修改页面（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/Common/User/FindPxd.php?ActionType=Sendcode&Sendcode={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/Common/User/FindPxd.php?ActionType=Sendcode&Sendcode={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (30,'水印透明度','-','ThumbWaterDiaphaneity',14,0,2,8,'Text',180,'50','50',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (31,'JPEG水印质量','-','ThumbWaterQuality',14,0,2,9,'Text',180,'100','100',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (32,'用户登陆日志模板','-','UserLogTemplate',5,0,2,0,'TextArea',180,'用户[{Nets.ID}]{Nets.Name}于{Nets.Time}{Nets.ActionType}{Nets.Platform}；\r\n用户所在单位为{Nets.Unit}；\r\n用户所在用户类型为{Nets.Type}；\r\n用户所在用户分组为{Nets.Group}。\r\n','用户[{Nets.ID}]{Nets.Name}于{Nets.Time}{Nets.ActionType}{Nets.Platform}；\r\n用户所在单位为{Nets.Unit}；\r\n用户所在用户类型为{Nets.Type}；\r\n用户所在用户分组为{Nets.Group}。',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (33,'非图片文件缩略图','-','userUploadOtherFileThumb',14,0,2,26,'Text',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (34,'非法信息处理设置','-','userWordLimitAble',18,0,2,4,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (35,'非法词语列表','-','userWordLimitContent',18,0,2,3,'TextArea',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (36,'文字过滤设置','-','userWordFilterAble',18,0,2,2,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (37,'文字过滤词语列表','-','userWordFilterContent',18,0,2,1,'TextArea',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (38,'允许新用户注册','-','userUserRegAble',19,0,2,118,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (39,'会员取回密码次数','-','userUserFindPxdCount',19,0,2,117,'Text',180,'5','5',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (40,'同一IP注册间隔时间','-','userUserSameIpRegCount',19,0,2,116,'Text',180,'10','10',0,0,'单位：秒');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (41,'禁止的邮件地址','-','userUserLimitEmailList',19,0,2,115,'TextArea',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (42,'注册需要管理员认证','-','userUserCheckAble',19,0,2,114,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (43,'发送注册信息邮件','-','userUserRegSendEmail',19,0,2,113,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (44,'默认密码','-','userUserDefaultPxd',19,0,2,112,'Text',180,'123456','123456',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (45,'资金积分对换比例','-','userUserMoneyToCodeRare',19,0,2,111,'Text',180,'10','10',0,0,'资金*本比例=积分');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (46,'广告缓存路径','-','PathAdvCache',9,0,2,0,'Text',180,'Cache/DbCache/Adv/','Cache/DbCache/Adv/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (47,'上传文件是否自动改名','-','UploadFileRename',14,0,2,30,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (48,'错误信息附加信息','-','normalErrorAddInfo',5,0,2,20,'Text',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (49,'管理根目录','-','sysManaRoot',4,0,2,10,'Text',180,'Mana/','Mana/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (50,'平台根目录','-','sysPlatformRoot',4,0,2,9,'Text',180,'Platform/','Platform/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (51,'公共平台路径','-','sysCoreRoot',4,0,2,80,'Text',180,'../../../','../../../',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (52,'商务平台用户登陆地址','-','businessLoginAddress',6,0,2,60,'Text',180,'../../../Plus/Common/User/default.php','../../../Plus/Common/User/default.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (53,'商务平台用户注册地址','-','businessRegisterAddress',6,0,2,59,'Text',180,'../../../Plus/Common/User/Register.php','../../../Plus/Common/User/Register.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (54,'商务平台用户登出地址','-','businessLogoutAddress',6,0,2,58,'Text',180,'../../../Plus/Common/Other/Logout.php','../../../Plus/Common/Other/Logout.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (55,'商务平台用户主页地址','-','businessMainAddress',6,0,2,57,'Text',180,'../../../Plus/Common/User/main.php','../../../Plus/Common/User/main.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (56,'平台用户注册地址','-','PlatformRegisterAddress',6,0,2,77,'Text',180,'Platform/m_nets/user/Register.php','Platform/m_nets/user/Register.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (57,'商务平台Title','-','bussinessMetaTitle',16,0,2,29,'Text',180,'网集平台','网集平台',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (58,'商务平台Keyword','-','bussinessMetaKeyword',16,0,2,4,'Text',180,'团购、团购导航、客户关系管理、项目管理','团购、团购导航、客户关系管理、项目管理',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (59,'商务平台Description','-','bussinessMetaDescription',16,0,2,3,'TextArea',180,'团购、团购导航、客户关系管理、项目管理','团购、团购导航、客户关系管理、项目管理',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (60,'商务平台Version','-','bussinessMetaVersion',16,0,2,2,'TextArea',180,'网集平台 v0.042 beta 1<br />','网集平台 0.042 beta 1<br />',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (61,'默认图片地址','-','defaultImgPath',5,0,2,67,'Text',180,'Ui/Common/Img/Common/Noimg.jpg','Ui/Common/Img/Common/Noimg.jpg',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (62,'公共界面路径','-','sysUiCoreRoot',4,0,2,79,'Text',180,'../../../','../../../',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (63,'项目数据库配置','N_2009103121175050765','sysDbConfigString',5,0,2,70,'Text',180,'DbName,PxdExtend,Host,Port,Username,Pxd,0','DbName,PxdExtend,Host,Port,Username,Pxd,0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (64,'商务平台模板路径','N_2009110116013881335','bussinessTemplatePackagePath',4,0,2,60,'Text',180,'../../../Template/Main/m_default/','../../../Template/Main/m_default/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (65,'手机平台界面路径','N_2009110116192077844','wapUiPackagePath',4,0,2,59,'Text',180,'../../../Ui/m_wap/','../../../Ui/m_wap/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (66,'本地数据缓存路径','N_2009110723400518280','sysDataCachePath',9,0,2,97,'Text',180,'Cache/DbCache/','Cache/DbCache/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (67,'单页提交最大次数','N_2009110723405445822','sysSubmitCount',5,0,2,50,'Text',180,'5','5',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (68,'提交禁固时间长度(秒)','N_200911072342208850','sysSubmitConfinementTimeLong',5,0,2,49,'Text',180,'300','300',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (69,'Html编辑器类型','N_2009110911331684963','HtmlEditorType',13,0,2,3,'RadioAR',180,'0','0',0,38,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (70,'FCKEditor控件路径','N_2009110911355459686','FCKEditorPath',11,0,2,2,'Text',180,'../../../Component/FCKeditor/fckeditor.php','../../../Component/FCKeditor/fckeditor.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (71,'FCKEditor控件基路径','N_2009110911365059103','FCKEditorBasePath',11,0,2,1,'Text',180,'../../../Component/FCKeditor/','../../../Component/FCKeditor/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (72,'附件上传路径','N_2009110913061643551','AttachUrlPath',14,0,2,27,'Text',180,'../../../Uploadfiles/','../../../Uploadfiles/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (73,'可上传的文件类型','N_2009110913155415615','UploadFileType',14,0,2,28,'Text',180,'jpg,gif,png','jpg,gif,png',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (74,'上传文件最大大小','N_2009110913244336700','UploadFileSize',14,0,2,0,'Text',180,'1024','1024',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (75,'是否生成缩略图','N_2009110913260772396','ThumbEnable',14,0,2,20,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (76,'缩略图保存路径','N_2009110913264373742','ThumbPath',14,0,2,19,'Text',180,'Thumb/','Thumb/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (77,'是否添加水印','N_2009110913275849243','ThumbWater',14,0,2,10,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (78,'水印图片路径','N_2009110913284092678','ThumbWaterPath',14,0,2,6,'Text',180,'../../../Uploadfiles/Logo.gif','../../../Uploadfiles/Logo.gif',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (79,'水印位置','N_2009110913295048364','ThumbWaterPosition',14,0,2,1,'RadioAR',3,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (80,'无图片文件地址','N_2009111007570363534','NoImgFileThumbPath',14,0,2,29,'Hidden',180,'../../../CommonSkin/Ui/Img/NImg/nophoto.jpg','../../../CommonSkin/Ui/Img/NImg/nophoto.jpg',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (81,'用户框架消息地址','N_2009120206323353744','PathUserFrameMessage',6,0,2,5,'Text',0,'Plus/Common/Other/Message_Frame.php','Plus/Common/Other/Message_Frame.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (82,'邮件服务器端口号','N_2009120206330066137','EmailHostPost',17,0,2,6,'Text',0,'25','25',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (83,'网站地图模板','N_2009120818103283654','SitemapTemplate',5,0,2,0,'TextArea',180,'Open_Introduct,1\r\nStart_IntroductgroupID,1\r\nLevel_Introductgroup,1\r\nStart_DocgroupID,3\r\nLevel_Docgroup,1\r\nContainDoc_DocgroupID,\r\n<!---RTB.SPLIT2--->\r\n<a href=\"../../../Plus/m_unionnets/Cms/default.php\" class=\"Link1 FBlack2 FStrong\">网站首页</a><br /><br />\r\n<span class=\"FBlack2 FStrong\"><Nets.IntroductgroupName></span><br />\r\n<a href=\"../../../Plus/m_unionnets/Cms/introduct0.php?ID=<Nets.IntroductID>\" class=\"Link1 FBlack3\" style=\"margin:auto auto auto 8px;\"><Nets.IntroductName></a>\r\n<a href=\"../../../Plus/m_unionnets/Cms/docList0.php?ID=<Nets.docgroupID>\" class=\"Link1 FBlack2 FStrong\"><Nets.docgroupName></a><br />\r\n<a href=\"../../../Plus/m_unionnets/Cms/docList0.php?ID=<Nets.docgroupID>\" class=\"Link1 FBlack3\" style=\"margin:auto auto auto 8px;\"><Nets.docgroupName></a>','Open_Introduct,1\r\nStart_IntroductgroupID,1\r\nLevel_Introductgroup,1\r\nStart_DocgroupID,3\r\nLevel_Docgroup,1\r\nContainDoc_DocgroupID,\r\n<!---RTB.SPLIT2--->\r\n<a href=\"../../../Plus/m_unionnets/Cms/default.php\" class=\"Link1 FBlack2 FStrong\">网站首页</a><br /><br />\r\n<span class=\"FBlack2 FStrong\"><Nets.IntroductgroupName></span><br />\r\n<a href=\"../../../Plus/m_unionnets/Cms/introduct0.php?ID=<Nets.IntroductID>\" class=\"Link1 FBlack3\" style=\"margin:auto auto auto 8px;\"><Nets.IntroductName></a>\r\n<a href=\"../../../Plus/m_unionnets/Cms/docList0.php?ID=<Nets.docgroupID>\" class=\"Link1 FBlack2 FStrong\"><Nets.docgroupName></a><br />\r\n<a href=\"../../../Plus/m_unionnets/Cms/docList0.php?ID=<Nets.docgroupID>\" class=\"Link1 FBlack3\" style=\"margin:auto auto auto 8px;\"><Nets.docgroupName></a>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (84,'脚本超时时间','N_2009120818103283655','ScriptOutTime',5,0,2,0,'Text',180,'12','12',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (85,'电子邮件认证邮件模板','N_2009120818103283656','EmailConfirmTemplate',22,0,2,0,'TextArea',180,'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户注册认证邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）的用户注册认证邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n请点击以下链接完成邮件注册认证（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/Common/User/ResendRegisterEmail.php?ActionType=DChecked&DChecked={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/Common/User/ResendRegisterEmail.php?ActionType=DChecked&DChecked={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户注册认证邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）的用户注册认证邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n请点击以下链接完成邮件注册认证（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/Common/User/ResendRegisterEmail.php?ActionType=DChecked&DChecked={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/Common/User/ResendRegisterEmail.php?ActionType=DChecked&DChecked={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (86,'默认用户充值金额','N_2010011712071329946','Pay_DefaultUserorderAmount',13,0,2,0,'Text',180,'100','100',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (87,'用户充值单编号头','N_2010011712101817028','NumCodeHead_Userpay',5,0,2,0,'Text',0,'UP','UP',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (88,'菜单缓存路径','N_2010012000360020822','PathMenuCache',9,0,2,0,'Text',0,'Cache/DbCache/Menu/','Cache/DbCache/Menu/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (89,'网站根目录(PATH)','N_2010012000372883850','PathRoot',4,0,2,58,'Text',180,'../../../','../../../',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (90,'静态生成分段大小','N_2010012118004084335','MakeHtmlSegmentSize',5,0,2,0,'Text',0,'30','30',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (91,'问答初始悬赏积分','N_2010012617130988348','QuestionsInitialCode',13,0,2,0,'Text',0,'50','3',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (92,'时间间隔内可提交次数','N_2010021322414564575','SubmitLimitViews',13,0,2,0,'Text',0,'5','5',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (93,'时间间隔(秒)','N_2010021322422113870','SubmitLimitTime',13,0,2,0,'Text',0,'30','30',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (94,'冻结时间','N_2010021322450010467','SubmitLimitFreeze',13,0,2,0,'Text',0,'30','30',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (95,'注册需要邮件认证','N_2010030407353926663','userUserMailCheckAble',19,0,2,110,'RadioAR',180,'0','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (96,'平台版本号','N_2010030911390194232','NetsVersion',3,0,2,0,'Text',180,'网集(unionNets.com)在线平台 version 0.041 beta 1','网集软件(UNIONNETS.COM) version 0.042 beta 1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (97,'平台简单介绍','N_2010030911393237106','NetsIntroduct',3,0,2,0,'TextArea',180,'您使用的是网集在线平台在线版。网集在线平台集内容管理、大型电子商务、社区论坛、人才系统、企业办公、客户关系、财务管理于一身，利用高效灵活的产品架构、众多丰富的子系统、严密的安全性为广大用户提供一个强大、高效、实用的营销与管理平台。','您使用的是网集平台在线版。网集平台集内容管理、客户关系管理、项目管理、团购、团购导航、财务管理、物流管理、虚拟主机管理、界面库、商城、社区于一身，利用高效灵活的产品架构、众多丰富的子系统、严密的安全性为广大用户提供一个强大、高效、实用的营销与管理平台。',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (98,'界面参数文件路径','N_201003122334576686','sysUiParameterPath',9,0,2,20,'Text',180,'Cache/UiParameter/','Cache/UiParameter/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (99,'文档','-','CheckCmsDoc',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (100,'文档评论','-','CheckCmsDocDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (101,'问答','-','CheckCmsAsk',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (102,'问答回复','-','CheckCmsAskReply',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (103,'商品','-','CheckShopSale',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (104,'商品评论','-','CheckShopSaleDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (105,'赠品','-','CheckShopPresent',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (106,'优惠券','-','CheckShopFavourable',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (107,'供应','-','CheckRequireSupply',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (108,'供应评论','-','CheckRequireSupplyDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (109,'求购','-','CheckRequireRequire',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (110,'求购评论','-','CheckRequireRequireDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (111,'点评单位','-','CheckSortUnit',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (112,'点评单位评论','-','CheckSortUnitDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (113,'单位产品','-','CheckSortUnitProduct',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (114,'单位产品评论','-','CheckSortUnitProductDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (115,'圈子','-','CheckCommCircle',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (116,'圈子评论','-','CheckCommCircleDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (117,'帖子','-','CheckCommPosts',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (118,'帖子回复','-','CheckCommPostsReply',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (119,'小说','-','CheckStoryVolume',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (120,'小说评论','-','CheckStoryVolumeDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (121,'章节','-','CheckStoryNode',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (122,'章节评论','-','CheckStoryNodeDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (123,'文章','-','CheckStoryArticle',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (124,'文章评论','-','CheckStoryArticleDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (125,'地图类型','N_201003180520079606','MapType',21,0,2,30,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (126,'地图服务供应商首页','N_2010031805204214721','MapServiceHome',21,0,2,29,'Text',180,'http://code.google.com/intl/zh-CN/apis/maps/','http://code.google.com/intl/zh-CN/apis/maps/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (127,'地图管理帐号','N_201003180521084837','MapUName',21,0,2,28,'Text',180,'vir@unionnets.com','vir@unionnets.com',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (128,'地图管理帐号密码','N_2010031805212550848','MapUPxd',21,0,2,27,'Text',180,'1234567abc','1234567abc',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (129,'地图密钥','N_2010031805214920773','MapAPIKey',21,0,2,26,'Text',180,'ABQIAAAAlh1-cPv1-KOVfR0v0XgG4RTBfUk9TZrBRaIteybtnU2KziHEpRSTYyRmytqgGO9s0PuQNQ9RElC19Q','ABQIAAAAlh1-cPv1-KOVfR0v0XgG4RTBfUk9TZrBRaIteybtnU2KziHEpRSTYyRmytqgGO9s0PuQNQ9RElC19Q',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (130,'地图选择控件宽度','N_201003180522133527','MapControlWidth',21,0,2,24,'Text',180,'600','600',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (131,'地图选择控件高度','N_2010031805222965957','MapControlHeight',21,0,2,23,'Text',180,'400','400',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (132,'地图显示类型','N_2010031805230369244','MapControlShowType',21,0,2,25,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (133,'地图调用脚本路径','N_2010031805495470294','MapControlJscriptPath',21,0,2,17,'Text',180,'Component/Nets/netsJscript/netsMap_Google.js','Component/Nets/netsJscript/netsMap_Google.js',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (134,'地图服务供应商脚本路径','N_2010031806141372183','MapServiceJscriptPath',21,0,2,18,'Text',180,'http://ditu.google.cn/maps?file=api&hl=zh-CN&amp;v=2&amp;key=','http://ditu.google.cn/maps?file=api&hl=zh-CN&v=2&key=',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (135,'地图初始位置X','N_2010031810372722854','MapPositionX',21,0,2,19,'Text',180,'39.917','39.917',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (136,'地图初始位置Y','N_2010031810374789764','MapPositionY',21,0,2,20,'Text',180,'116.397','116.397',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (137,'是否自动获取地图位置','N_2010031810375937619','MapPositionFromZone',21,0,2,21,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (138,'显示时是否使用静态地图','N_2010031810381414709','MapStaticShow',21,0,2,22,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (139,'分类信息活动','N_2010031816363880319','CheckSortActive',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (140,'分类信息活动评论','N_201003181636506530','CheckSortActiveDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (141,'分类信息优惠券','N_2010031816365955776','CheckSortCoupon',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (142,'分类信息优惠券评论','N_2010031816370972052','CheckSortCouponDiscuss',20,0,2,0,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (143,'是否启用数据库缓存','N_2010032012353578155','CacheDbAble',12,0,2,0,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (144,'是否启用页面缓存','N_2010032012355866000','CachePageAble',12,0,2,0,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (145,'文档打分设置','N_2010040205391961254','CmsDocEvaluationSetting',11,0,2,0,'TextArea',180,'欠扁,Ui/m_nets/Img/Icon/Icon_0/A_1.gif\r\n支持,Ui/m_nets/Img/Icon/Icon_0/A_2.gif\r\n很棒,Ui/m_nets/Img/Icon/Icon_0/A_3.gif\r\n找骂,Ui/m_nets/Img/Icon/Icon_0/A_4.gif\r\n搞笑,Ui/m_nets/Img/Icon/Icon_0/A_5.gif\r\n扯淡,Ui/m_nets/Img/Icon/Icon_0/A_6.gif\r\n不解,Ui/m_nets/Img/Icon/Icon_0/A_7.gif\r\n头晕,Ui/m_nets/Img/Icon/Icon_0/A_8.gif','欠扁,Ui/m_nets/Img/Icon/Icon_0/A_1.gif\r\n支持,Ui/m_nets/Img/Icon/Icon_0/A_2.gif\r\n很棒,Ui/m_nets/Img/Icon/Icon_0/A_3.gif\r\n找骂,Ui/m_nets/Img/Icon/Icon_0/A_4.gif\r\n搞笑,Ui/m_nets/Img/Icon/Icon_0/A_5.gif\r\n扯淡,Ui/m_nets/Img/Icon/Icon_0/A_6.gif\r\n不解,Ui/m_nets/Img/Icon/Icon_0/A_7.gif\r\n头晕,Ui/m_nets/Img/Icon/Icon_0/A_8.gif',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (146,'用户HTML编辑器类型','N_2010040205435583843','UserEditorType',13,0,2,3,'RadioAR',180,'0','0',0,38,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (147,'商务平台名称','N_2010041615100137292','bussinessName',16,0,2,30,'Text',180,'网集平台','网集平台',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (148,'商务平台Logo','N_2010041615101858804','bussinessLogo',16,0,2,1,'Source',180,'.','.',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (149,'收藏提交地址','N_2010043016311014871','FavoriteAddress',6,0,2,77,'Text',180,'Plus/Common/Oa/favorite.php','Plus/Common/Oa/favorite.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (150,'用户订单编号头','N_2010050320141940994','NumCodeHead_Order',5,0,2,0,'Text',0,'O','O',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (151,'提示框停留时间','N_2010051011080864627','MessageBoxShowTime',11,0,2,0,'Text',0,'5','5',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (152,'框架消息地址','N_201005251928276033','ContentBoxErrorPATH',6,0,2,77,'Text',180,'Plus/m_keepu/Other/Frame_Message.php','Plus/m_keepu/Other/Frame_Message.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (153,'短信帐号设置路径','N_2010052519303436538','MobileAccountsPATH',10,0,2,77,'Text',180,'Inc/netsCache/DbCache/oa/Mobile_Account.php','Inc/netsCache/DbCache/oa/Mobile_Account.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (154,'短信帐号索引路径','N_2010052519305525079','MobileAccountIndexPATH',10,0,2,77,'Text',180,'Inc/netsCache/DbCache/oa/Mobile_AccountIndex.php','Inc/netsCache/DbCache/oa/Mobile_AccountIndex.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (155,'短信发送接口地址','N_2010052519311355697','MobileSendURL',10,0,2,77,'Text',180,'http://http.c123.com/tx/','http://http.c123.com/tx/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (156,'短信接收地址','N_2010052519312979028','MobileReceiveURL',10,0,2,77,'Text',180,'http://http.c123.com/rx/','http://http.c123.com/rx/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (157,'短信数量获取地址','N_2010052519314589260','MobileCountURL',10,0,2,77,'Text',180,'http://http.c123.com/mm/','http://http.c123.com/mm/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (158,'是否可以重复登陆','N_2010052702273455462','LoginRepeateAble',19,0,2,109,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (159,'平台框架消息地址','N_2010061500375157815','PathPlatformFrameMessage',6,0,2,0,'Text',0,'Platform/m_nets/Other/Message_Frame.php','Platform/m_nets/Other/Message_Frame.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (160,'核心管理框架消息地址','N_2010061617590898474','PathManaFrameMessage',6,0,2,5,'Text',0,'Mana/m_nets/Other/Message_Frame.php','Mana/m_nets/Other/Message_Frame.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (161,'用户普通消息地址','N_2010061618222424423','PathUserNormalMessage',6,0,2,5,'Text',0,'Plus/Common/Other/Message_Normal.php','Plus/Common/Other/Message_Normal.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (162,'平台普通消息地址','N_2010061618225135302','PathPlatformNormalMessage',6,0,2,5,'Text',0,'Platform/m_nets/Other/Message_Normal.php','Platform/m_nets/Other/Message_Normal.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (163,'核心管理普通消息地址','N_2010061618231110671','PathManaNormalMessage',6,0,2,5,'Text',0,'Mana/m_nets/Other/Message_Normal.php','Mana/m_nets/Other/Message_Normal.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (164,'核心平台网址路径','N_2010071404072984500','sysURLCoreRoot',4,0,2,78,'Text',180,'http://127.0.0.1:8080/_PROGRAM/MYPROJECT/Project0/unionNets/Program/version_0.042/unionNets/Common/Core/version_0042/webSite/','http://127.0.0.1:8080/_PROGRAM/MYPROJECT/Project0/unionNets/Program/version_0.042/unionNets/Common/Core/version_0042/webSite/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (165,'单位与用户数据缓存路径','N_2010071422443874990','sysUnitCachePath',9,0,2,97,'Text',180,'Cache/Unit/','Cache/Unit/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (166,'公共接口_操作_最后操作记录文件路径','N_2010071714335049218','sysInterfaceError_LastOption',9,0,2,78,'Text',180,'Error_LastOption.xml','Error_LastOption.xml',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (167,'公共接口_操作_我的消息数文件路径','N_201007171434292517','sysInterfaceError_MessageCount_MY',9,0,2,78,'Text',180,'Error_MessageCount_MY.xml','Error_MessageCount_MY.xml',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (168,'公共接口_操作_用户消息数文件路径','N_2010071813413196777','sysInterfaceError_UserMessageCount',9,0,2,78,'Text',180,'Error_MessageCount_User.xml','Error_MessageCount_User.xml',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (169,'应用平台网址路径','N_201007241800502792','sysURLbussinessRoot',16,0,2,7,'Text',180,'http://127.0.0.1:8080/_PROGRAM/MYPROJECT/Project0/unionNets/Program/version_0.042/unionNets/User/project/_DemoCore/webSite/','http://127.0.0.1:8080/_PROGRAM/GPORJECT/_unionnets_com/gsnavigation_unionnets_com/webSite/Site_0/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (170,'注销时发送的邮件模板','N_2010072823323029861','EmailOffTemplate',22,0,2,2,'TextArea',180,'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户注销通知邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）注销通知邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n感谢您使用{Nets.Title}！我们希望能您带来更好的服务与产品。欢迎您参与本平台的改进计划，来提出您对本平台的宝贵意见或建议。<br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户注销通知邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）注销通知邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n感谢您使用{Nets.Title}！我们希望能您带来更好的服务与产品。欢迎您参与本平台的改进计划，来提出您对本平台的宝贵意见或建议。<br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (171,'自动注册用户过期时间','N_2010073105370345880','userAutoRegisterPassTime',19,0,2,108,'Text',180,'31536000','31536000',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (172,'注册用户过期时间','N_2010073105375133587','userRegisterPassTime',19,0,2,107,'Text',180,'3153600000','3153600000',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (173,'注册单位过期时间','N_2010073105381745401','unitRegisterPassTime',19,0,2,106,'Text',180,'3153600000','3153600000',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (174,'自动注册用户所属单位','N_2010073105411976852','userAutoRegisterUnitid',19,0,2,105,'Text',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (175,'自动注册用户名头','N_201007310555403649','userAutoRegisterNameHead',19,0,2,104,'Text',180,'tmpu','tmpu',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (176,'自动注册用户人名头','N_2010073105562253570','userAutoRegisterNicknameHead',19,0,2,103,'Text',180,'临时用户','临时用户',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (177,'生成唯一随机数重复验证次数','N_2010073106040276358','NumcodeMakeCount',5,0,2,9,'Text',180,'30','30',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (178,'自动注册用户邮件域名','N_2010073106092887014','userAutoRegisterEmailHead',19,0,2,102,'Text',180,'@unionnets.com','@unionnets.com',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (179,'自动注册用户密码种子','N_2010073106103277886','userAutoRegisterPxdSeed',19,0,2,101,'Text',180,'99999999999','99999999999',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (180,'自动注册用户备注模板','N_2010073106171574227','userAutoRegisterIntroductTemplate',19,0,2,100,'TextArea',180,'平台为您生成了临时用户，您可以通过修改本用户资料成为平台的正式用户；本用户的登陆信息如如下，您可以再已后通过本用户再次登陆本平台（临时用户使用期限为{Nets.PassDayCount}天）：<br />\r\n<span class=\"FStrong\">临时用户名：</span><br />\r\n{Nets.Name}<br /><br />\r\n<span class=\"FStrong\">临时用户密码：</span><br />\r\n{Nets.Pxd}<br /><br />\r\n<span class=\"FStrong\">临时用户人名：</span><br />\r\n{Nets.Nickname}<br /><br />\r\n<span class=\"FStrong\">临时用户邮箱（本邮箱不可用）：</span><br />\r\n{Nets.Email}<br /><br />','平台为您生成了临时用户，您可以通过修改本用户资料成为平台的正式用户；本用户的登陆信息如如下，您可以再已后通过本用户再次登陆本平台（临时用户使用期限为{Nets.PassDayCount}天）：<br />\r\n<span class=\"FStrong\">临时用户名：</span><br />\r\n{Nets.Name}<br /><br />\r\n<span class=\"FStrong\">临时用户密码：</span><br />\r\n{Nets.Pxd}<br /><br />\r\n<span class=\"FStrong\">临时用户人名：</span><br />\r\n{Nets.Nickname}<br /><br />\r\n<span class=\"FStrong\">临时用户邮箱（本邮箱不可用）：</span><br />\r\n{Nets.Email}<br /><br />',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (181,'错误日志文件目录','N_2010073107083490164','sysErrorPath',9,0,2,9,'Text',180,'Cache/Log/','Cache/Log/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (182,'公共接口_操作_收信用户消息数路径','N_201008031731317812','sysInterfaceError_MessageCountPath',9,0,2,78,'Text',180,'USER_MESSAGE/','USER_MESSAGE/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (183,'商务平台界面路径','N_2010082513472060824','bussinessUiPackagePath',4,0,2,59,'Text',180,'../../../Ui/m_default/','../../../Ui/m_default/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (184,'手机平台模板路径','N_2010082513475023840','wapTemplatePackagePath',4,0,2,60,'Text',180,'../../../Template/Main/m_wap/','../../../Template/Main/m_wap/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (185,'电子邮件认证模板（功能）','N_2010091417441372113','EmailPowerTemplate',22,0,2,9,'TextArea',180,'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户注册认证邮件（享有更多服务与功能）</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）的用户注册认证邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n请点击以下链接完成邮件注册认证，以方便您能在本平台的享有更多服务与功能（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/Common/User/ResendRegisterEmail.php?ActionType=DChecked&DChecked={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/Common/User/ResendRegisterEmail.php?ActionType=DChecked&DChecked={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户注册认证邮件（享有更多服务与功能）</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）的用户注册认证邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n请点击以下链接完成邮件注册认证，以方便您能在本平台的享有更多服务与功能（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/Common/User/ResendRegisterEmail.php?ActionType=DChecked&DChecked={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/Common/User/ResendRegisterEmail.php?ActionType=DChecked&DChecked={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (186,'匿名用户_名称','-','AnonymousUser_Name',19,0,2,7,'Text',180,'匿名用户','匿名用户',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (187,'匿名用户_电子邮件','-','AnonymousUser_Email',19,0,2,6,'Text',180,'vir@unionnets.com','vir@unionnets.com',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (188,'匿名用户_图片','-','AnonymousUser_Source',19,0,2,5,'Text',180,'../../../','../../../',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (189,'匿名用户_手机号','-','AnonymousUser_Mobile',19,0,2,4,'Text',180,'13900000000','13900000000',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (190,'匿名用户_电话','-','AnonymousUser_Tele',19,0,2,3,'Text',180,'86-027-80000000','86-027-80000000',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (191,'匿名用户_通信软件','-','AnonymousUser_Software',19,0,2,2,'Text',180,'10000000','10000000',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (192,'匿名用户_网址','-','AnonymousUser_Website',19,0,2,1,'Text',180,'unionnets.com','unionnets.com',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (193,'商务平台模板根路径','N_2010100113294195593','bussinessTemplateRootPath',4,0,2,60,'Text',180,'../../../Template/','../../../Template/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (194,'用户主页_商铺','N_2010100113380963244','bussinessUserHome_Shop',6,0,2,60,'Text',180,'Place_Shop/default/','Place_Shop/default/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (195,'用户主页_企业主页','N_2010100113384288','bussinessUserHome_Unit',6,0,2,60,'Text',180,'Place_Unit/default/','Place_Unit/default/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (196,'用户主页_博客','N_2010100113390446133','bussinessUserHome_Blog',6,0,2,60,'Text',180,'Place_Blog/default/','Place_Blog/default/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (197,'用户主页_用户未开通','N_2010100113401158404','bussinessUserHome_Non',6,0,2,60,'Text',180,'Place_Shop/default/Error_non.php','Place_Shop/default/Error_non.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (198,'用户主页_主页','N_2010100113404414508','bussinessUserHome_Default',6,0,2,60,'Text',180,'default.php','default.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (199,'举报地址','N_2010100313391249472','ComplaintsAddress',6,0,2,77,'Text',180,'Plus/m_default/cms/feedback.php','Plus/m_default/cms/feedback.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (200,'用户暂时信息COOKIE名','N_2010101319102570901','userTempCookieEntityName',19,0,2,112,'Text',180,'MainUserinfo_Cookie','MainUserinfo_Cookie',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (201,'用户暂时COOKIE头识别码','N_2010101321512484246','userTempCookieConfirmNumcode',19,0,2,112,'Text',180,'512561817','512561817',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (202,'淘宝客APIKEY','N_2010101700322813128','TaobaokeAPIKEY',11,0,2,0,'Text',0,'12142924','12142924',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (203,'淘宝客APISECRET','N_2010101701393421823','TaobaokeAPISECRET',11,0,2,0,'Text',0,'97a7844d5415180db1c5a3a1b2fb0431','97a7844d5415180db1c5a3a1b2fb0431',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (204,'图标根路径','N_20101026010836222','sysIconRoot',9,0,2,78,'Text',180,'Ui/m_nets/Img/Icon/','Ui/m_nets/Img/Icon/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (205,'一般编号(NUMCODE)头','N_2010102606312823580','NumCodeHead_Normal',5,0,2,0,'Text',0,'N','N',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (206,'参与选择的地区','N_2010110210320447671','Zone_Opened',7,0,2,0,'TextArea',0,'重庆,昌吉,昌都,成都,长治,澳门,宝鸡,滨州,包头,恩施,鄂州,抚州,佛山,福州,贵阳,贵港,桂林,广州,甘南,合肥,呼和浩特,葫芦岛,黄石,黄冈,哈尔滨,海口,亳州,黄山,温州,乌鲁木齐,淮安,无锡,武汉,芜湖,香港,西宁,徐州,孝感,襄樊,咸宁,仙桃,厦门,郑州,张家口,绍兴,上海,沈阳,汕头,深圳,保山,宝鸡,包头,保定,北京,','重庆,昌吉,昌都,成都,长治,澳门,宝鸡,滨州,包头,恩施,鄂州,抚州,佛山,福州,贵阳,贵港,桂林,广州,甘南,合肥,呼和浩特,葫芦岛,黄石,黄冈,哈尔滨,海口,亳州,黄山,温州,乌鲁木齐,淮安,无锡,武汉,芜湖,香港,西宁,徐州,孝感,襄樊,咸宁,仙桃,厦门,郑州,张家口,绍兴,上海,沈阳,汕头,深圳,保山,宝鸡,包头,保定,北京,',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (207,'系统默认地区','N_2010110211205290374','Zone_ID_Default',11,0,2,0,'Text',0,'180','180',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (208,'地图服务供应商脚本路径_A','N_2010111018453920700','MapServiceJscriptPath_A',21,0,2,18,'Text',180,'http://maps.google.com/maps/api/js?sensor=true&key=','http://maps.google.com/maps/api/js?sensor=true&key=',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (209,'地图服务供应商脚本路径_B','N_2010111018460115798','MapServiceJscriptPath_B',21,0,2,18,'Text',180,'http://code.google.com/apis/gears/gears_init.js','http://code.google.com/apis/gears/gears_init.js',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (210,'快捷平台根目录','N_2010111617464814871','sysQPlatformRoot',4,0,2,9,'Text',180,'QPlatform/','QPlatform/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (211,'用户快捷平台登出地址','N_201011161748027073','QPlatformLogoutAddress',6,0,2,78,'Text',180,'QPlatform/m_nets/Other/Logout.php','QPlatform/m_nets/Other/Logout.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (212,'用户快捷平台主页地址','N_2010111617481161862','QPlatformMainAddress',6,0,2,79,'Text',180,'QPlatform/m_nets/user/main.php','QPlatform/m_nets/user/main.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (213,'用户快捷平台登陆地址','N_2010111617481944714','QPlatformLoginAddress',6,0,2,80,'Text',180,'QPlatform/m_nets/user/default.php','QPlatform/m_nets/user/default.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (214,'快捷平台框架消息地址','N_2010111617495167788','PathQPlatformFrameMessage',6,0,2,0,'Text',0,'QPlatform/m_nets/Other/Message_Frame.php','QPlatform/m_nets/Other/Message_Frame.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (215,'快捷平台普通消息地址','N_2010111617500031329','PathQPlatformNormalMessage',6,0,2,5,'Text',0,'QPlatform/m_nets/Other/Message_Normal.php','QPlatform/m_nets/Other/Message_Normal.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (216,'用户团购订单编号头','N_2010111919195110671','NumCodeHead_GroupsaleOrder',5,0,2,0,'Text',0,'GSO','GSO',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (217,'电子邮件订阅确认模板','N_2010112404413644601','EmailSubscribeConfirmTemplate',22,0,2,0,'TextArea',180,'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户订阅确认邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>电邮用户（{Nets.Name}）的用户订阅确认邮件</b><br />\r\n您好，您在{Nets.Title}申请了订阅：<br />\r\n请点击以下链接完成邮件订阅确认（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/m_default/Subscribe/subscribeDetail.php?ActionType=DSubscribeConfirm&DSubscribeConfirm={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/m_default/Subscribe/subscribeDetail.php?ActionType=DSubscribeConfirm&DSubscribeConfirm={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户订阅确认邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>电邮用户（{Nets.Name}）的用户订阅确认邮件</b><br />\r\n您好，您在{Nets.Title}申请了订阅：<br />\r\n请点击以下链接完成邮件订阅确认（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/m_default/Subscribe/subscribeDetail.php?ActionType=DSubscribeConfirm&DSubscribeConfirm={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/m_default/Subscribe/subscribeDetail.php?ActionType=DSubscribeConfirm&DSubscribeConfirm={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (218,'电子邮件退订确认模板','N_20101124044150793','EmailUnsubscribeConfirmTemplate',22,0,2,0,'TextArea',180,'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户退订确认邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>电邮用户（{Nets.Name}）的用户退订确认邮件</b><br />\r\n您好，您在{Nets.Title}申请了退订：<br />\r\n请点击以下链接完成邮件退订确认（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/m_default/Subscribe/subscribeDetail.php?ActionType=DUnsubscribeConfirm&DUnsubscribeConfirm={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/m_default/Subscribe/subscribeDetail.php?ActionType=DUnsubscribeConfirm&DUnsubscribeConfirm={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户退订确认邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>电邮用户（{Nets.Name}）的用户退订确认邮件</b><br />\r\n您好，您在{Nets.Title}申请了退订：<br />\r\n请点击以下链接完成邮件退订确认（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/m_default/Subscribe/subscribeDetail.php?ActionType=DUnsubscribeConfirm&DUnsubscribeConfirm={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/m_default/Subscribe/subscribeDetail.php?ActionType=DUnsubscribeConfirm&DUnsubscribeConfirm={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (219,'用户订阅订单编号头','N_2010112405030267910','NumCodeHead_SubscribeOrder',5,0,2,0,'Text',0,'SSO','SSO',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (220,'系统权限接口地址','N_2010121015100999014','sysCorePowerURL',5,0,2,0,'Text',0,'Data/Nets/user/UserPower_Child.php','Data/Nets/user/UserPower_Child.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (221,'系统权限文件路径','N_2010121016233570254','sysCorePowerFile',5,0,2,0,'Text',0,'Cache/DbCache/Power/File/sysCorePower.php','Cache/DbCache/Power/File/sysCorePower.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (222,'系统权限授权码','N_201012101700405993','sysCorePowerNumcode',16,0,2,28,'Text',0,'User2010101903190316268','N_201101150012133729',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (223,'系统广告接口地址','N_2010121307410626184','sysCoreADVURL',5,0,2,0,'Text',0,'Data/Cms/adv/Adv_Child.php','Data/Cms/adv/Adv_Child.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (224,'系统广告文件路径','N_2010121307420235488','sysCoreADVFile',5,0,2,0,'Text',0,'Cache/DbCache/Adv/sysCoreADV.xml','Cache/DbCache/Adv/sysCoreADV.xml',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (225,'系统广告默认值_A','N_2010121307433548150','sysCoreDefaultADV_A',5,0,2,0,'TextArea',0,'<br /><a href=\"http://product.unionnets.com/\" class=\"Link4 Adv_Text\" target=\"_blank\">网集软件系统内广告招商，联系电话：027-88860813</a><br /><br />','<br /><a href=\"http://product.unionnets.com/\" class=\"Link4 Adv_Text\" target=\"_blank\">网集软件系统内广告招商，联系电话：027-88860813</a><br /><br />',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (226,'系统广告默认值_B','N_2010121307434373205','sysCoreDefaultADV_B',5,0,2,0,'TextArea',0,'<br /><a href=\"http://product.unionnets.com/\" class=\"Link4 Adv_Text\" target=\"_blank\">网集软件系统内广告招商，联系电话：027-88860813</a><br /><br />','<br /><a href=\"http://product.unionnets.com/\" class=\"Link4 Adv_Text\" target=\"_blank\">网集软件系统内广告招商，联系电话：027-88860813</a><br /><br />',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (227,'系统广告默认值_C','N_2010121307435157968','sysCoreDefaultADV_C',5,0,2,0,'TextArea',0,'<br /><a href=\"http://product.unionnets.com/\" class=\"Link4 Adv_Text\" target=\"_blank\">网集软件系统内广告招商，联系电话：027-88860813</a><br /><br />','<br /><a href=\"http://product.unionnets.com/\" class=\"Link4 Adv_Text\" target=\"_blank\">网集软件系统内广告招商，联系电话：027-88860813</a><br /><br />',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (228,'核心系统无权限页面地址','N_2010121312491446859','ManaPageNopower',6,0,2,0,'Text',0,'Mana/m_nets/user/Nopower.php','Mana/m_nets/user/Nopower.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (229,'管理系统无权限页面地址','N_2010121312495340698','PlatformPageNopower',6,0,2,0,'Text',0,'Platform/m_nets/user/Nopower.php','Platform/m_nets/user/Nopower.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (230,'快捷管理系统无权限页面地址','N_2010121312501059576','QPlatformPageNopower',6,0,2,0,'Text',0,'QPlatform/m_nets/user/Nopower.php','QPlatform/m_nets/user/Nopower.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (231,'用户系统无权限页面地址','N_2010121312504336282','UserPageNopower',6,0,2,0,'Text',0,'../../../Plus/Common/User/Nopower.php','../../../Plus/Common/User/Nopower.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (232,'上传文件缩略图标','N_2010122111305982568','Uploadfiles_ThumbIcon',8,0,2,0,'TextArea',0,'AC3|||Ui/Common/Img/FileIcon/AC3.jpg\r\nACE|||Ui/Common/Img/FileIcon/ACE.jpg\r\nADE|||Ui/Common/Img/FileIcon/ADE.jpg\r\nADP|||Ui/Common/Img/FileIcon/ADP.jpg\r\nAI|||Ui/Common/Img/FileIcon/AI.jpg\r\nAIFF|||Ui/Common/Img/FileIcon/AIFF.jpg\r\nAU|||Ui/Common/Img/FileIcon/AU.jpg\r\nAVI|||Ui/Common/Img/FileIcon/AVI.jpg\r\nBAT|||Ui/Common/Img/FileIcon/BAT.jpg\r\nBIN|||Ui/Common/Img/FileIcon/BIN.jpg\r\nBMP|||Ui/Common/Img/FileIcon/BMP.jpg\r\nBUP|||Ui/Common/Img/FileIcon/BUP.jpg\r\nCAB|||Ui/Common/Img/FileIcon/CAB.jpg\r\nCAT|||Ui/Common/Img/FileIcon/CAT.jpg\r\nCHM|||Ui/Common/Img/FileIcon/CHM.jpg\r\nCSS|||Ui/Common/Img/FileIcon/CSS.jpg\r\nCUE|||Ui/Common/Img/FileIcon/CUE.jpg\r\nDAT|||Ui/Common/Img/FileIcon/DAT.jpg\r\nDCR|||Ui/Common/Img/FileIcon/DCR.jpg\r\nDER|||Ui/Common/Img/FileIcon/DER.jpg\r\nDIC|||Ui/Common/Img/FileIcon/DIC.jpg\r\nDIVX|||Ui/Common/Img/FileIcon/DIVX.jpg\r\nDIZ|||Ui/Common/Img/FileIcon/DIZ.jpg\r\nDLL|||Ui/Common/Img/FileIcon/DLL.jpg\r\nDOC|||Ui/Common/Img/FileIcon/DOC.jpg\r\nDOCX|||Ui/Common/Img/FileIcon/DOCX.jpg\r\nDOS|||Ui/Common/Img/FileIcon/DOS.jpg\r\nDVD|||Ui/Common/Img/FileIcon/DVD.jpg\r\nDWG|||Ui/Common/Img/FileIcon/DWG.jpg\r\nDWT|||Ui/Common/Img/FileIcon/DWT.jpg\r\nDefault|||Ui/Common/Img/FileIcon/Default.jpg\r\nEMF|||Ui/Common/Img/FileIcon/EMF.jpg\r\nEXC|||Ui/Common/Img/FileIcon/EXC.jpg\r\nFON|||Ui/Common/Img/FileIcon/FON.jpg\r\nGIF|||\r\nHLP|||Ui/Common/Img/FileIcon/HLP.jpg\r\nHTML|||Ui/Common/Img/FileIcon/HTML.jpg\r\nIFO|||Ui/Common/Img/FileIcon/IFO.jpg\r\nINF|||Ui/Common/Img/FileIcon/INF.jpg\r\nINI|||Ui/Common/Img/FileIcon/INI.jpg\r\nINS|||Ui/Common/Img/FileIcon/INS.jpg\r\nIP|||Ui/Common/Img/FileIcon/IP.jpg\r\nISO|||Ui/Common/Img/FileIcon/ISO.jpg\r\nISP|||Ui/Common/Img/FileIcon/ISP.jpg\r\nJAVA|||Ui/Common/Img/FileIcon/JAVA.jpg\r\nJFIF|||Ui/Common/Img/FileIcon/JFIF.jpg\r\nJPEG|||Ui/Common/Img/FileIcon/JPEG.jpg\r\nJPG|||\r\nLOG|||Ui/Common/Img/FileIcon/LOG.jpg\r\nM4A|||Ui/Common/Img/FileIcon/M4A.jpg\r\nMID|||Ui/Common/Img/FileIcon/MID.jpg\r\nMMF|||Ui/Common/Img/FileIcon/MMF.jpg\r\nMMM|||Ui/Common/Img/FileIcon/MMM.jpg\r\nMOV|||Ui/Common/Img/FileIcon/MOV.jpg\r\nMOVIE|||Ui/Common/Img/FileIcon/MOVIE.jpg\r\nMP2|||Ui/Common/Img/FileIcon/MP2.jpg\r\nMP2V|||Ui/Common/Img/FileIcon/MP2V.jpg\r\nMP3|||Ui/Common/Img/FileIcon/MP3.jpg\r\nMP4|||Ui/Common/Img/FileIcon/MP4.jpg\r\nMPE|||Ui/Common/Img/FileIcon/MPE.jpg\r\nMPEG|||Ui/Common/Img/FileIcon/MPEG.jpg\r\nMPG|||Ui/Common/Img/FileIcon/MPG.jpg\r\nMPV2|||Ui/Common/Img/FileIcon/MPV2.jpg\r\nNFO|||Ui/Common/Img/FileIcon/NFO.jpg\r\nPDD|||Ui/Common/Img/FileIcon/PDD.jpg\r\nPDF|||Ui/Common/Img/FileIcon/PDF.jpg\r\nPHP|||Ui/Common/Img/FileIcon/PHP.jpg\r\nPNG|||\r\nPPT|||Ui/Common/Img/FileIcon/PPT.jpg\r\nPPTX|||Ui/Common/Img/FileIcon/PPTX.jpg\r\nPSD|||Ui/Common/Img/FileIcon/PSD.jpg\r\nRAR|||Ui/Common/Img/FileIcon/RAR.jpg\r\nREG|||Ui/Common/Img/FileIcon/REG.jpg\r\nRTF|||Ui/Common/Img/FileIcon/RTF.jpg\r\nSCP|||Ui/Common/Img/FileIcon/SCP.jpg\r\nTHEME|||Ui/Common/Img/FileIcon/THEME.jpg\r\nTIF|||Ui/Common/Img/FileIcon/TIF.jpg\r\nTIFF|||Ui/Common/Img/FileIcon/TIFF.jpg\r\nTLB|||Ui/Common/Img/FileIcon/TLB.jpg\r\nTTF|||Ui/Common/Img/FileIcon/TTF.jpg\r\nTXT|||Ui/Common/Img/FileIcon/TXT.jpg\r\nUIS|||Ui/Common/Img/FileIcon/UIS.jpg\r\nURL|||Ui/Common/Img/FileIcon/URL.jpg\r\nVBS|||Ui/Common/Img/FileIcon/VBS.jpg\r\nVCR|||Ui/Common/Img/FileIcon/VCR.jpg\r\nVOB|||Ui/Common/Img/FileIcon/VOB.jpg\r\nWAV|||Ui/Common/Img/FileIcon/WAV.jpg\r\nWBA|||Ui/Common/Img/FileIcon/WBA.jpg\r\nWMA|||Ui/Common/Img/FileIcon/WMA.jpg\r\nWMV|||Ui/Common/Img/FileIcon/WMV.jpg\r\nWPL|||Ui/Common/Img/FileIcon/WPL.jpg\r\nWRI|||Ui/Common/Img/FileIcon/WRI.jpg\r\nWTX|||Ui/Common/Img/FileIcon/WTX.jpg\r\nXLSX|||Ui/Common/Img/FileIcon/XLSX.jpg\r\nXML|||Ui/Common/Img/FileIcon/XML.jpg\r\nXSL|||Ui/Common/Img/FileIcon/XSL.jpg\r\nZAP|||Ui/Common/Img/FileIcon/ZAP.jpg\r\nZIP|||Ui/Common/Img/FileIcon/ZIP.jpg\r\nXLS|||Ui/Common/Img/FileIcon/XLS.jpg','AC3|||Ui/Common/Img/FileIcon/AC3.jpg\r\nACE|||Ui/Common/Img/FileIcon/ACE.jpg\r\nADE|||Ui/Common/Img/FileIcon/ADE.jpg\r\nADP|||Ui/Common/Img/FileIcon/ADP.jpg\r\nAI|||Ui/Common/Img/FileIcon/AI.jpg\r\nAIFF|||Ui/Common/Img/FileIcon/AIFF.jpg\r\nAU|||Ui/Common/Img/FileIcon/AU.jpg\r\nAVI|||Ui/Common/Img/FileIcon/AVI.jpg\r\nBAT|||Ui/Common/Img/FileIcon/BAT.jpg\r\nBIN|||Ui/Common/Img/FileIcon/BIN.jpg\r\nBMP|||Ui/Common/Img/FileIcon/BMP.jpg\r\nBUP|||Ui/Common/Img/FileIcon/BUP.jpg\r\nCAB|||Ui/Common/Img/FileIcon/CAB.jpg\r\nCAT|||Ui/Common/Img/FileIcon/CAT.jpg\r\nCHM|||Ui/Common/Img/FileIcon/CHM.jpg\r\nCSS|||Ui/Common/Img/FileIcon/CSS.jpg\r\nCUE|||Ui/Common/Img/FileIcon/CUE.jpg\r\nDAT|||Ui/Common/Img/FileIcon/DAT.jpg\r\nDCR|||Ui/Common/Img/FileIcon/DCR.jpg\r\nDER|||Ui/Common/Img/FileIcon/DER.jpg\r\nDIC|||Ui/Common/Img/FileIcon/DIC.jpg\r\nDIVX|||Ui/Common/Img/FileIcon/DIVX.jpg\r\nDIZ|||Ui/Common/Img/FileIcon/DIZ.jpg\r\nDLL|||Ui/Common/Img/FileIcon/DLL.jpg\r\nDOC|||Ui/Common/Img/FileIcon/DOC.jpg\r\nDOCX|||Ui/Common/Img/FileIcon/DOCX.jpg\r\nDOS|||Ui/Common/Img/FileIcon/DOS.jpg\r\nDVD|||Ui/Common/Img/FileIcon/DVD.jpg\r\nDWG|||Ui/Common/Img/FileIcon/DWG.jpg\r\nDWT|||Ui/Common/Img/FileIcon/DWT.jpg\r\nDefault|||Ui/Common/Img/FileIcon/Default.jpg\r\nEMF|||Ui/Common/Img/FileIcon/EMF.jpg\r\nEXC|||Ui/Common/Img/FileIcon/EXC.jpg\r\nFON|||Ui/Common/Img/FileIcon/FON.jpg\r\nGIF|||\r\nHLP|||Ui/Common/Img/FileIcon/HLP.jpg\r\nHTML|||Ui/Common/Img/FileIcon/HTML.jpg\r\nIFO|||Ui/Common/Img/FileIcon/IFO.jpg\r\nINF|||Ui/Common/Img/FileIcon/INF.jpg\r\nINI|||Ui/Common/Img/FileIcon/INI.jpg\r\nINS|||Ui/Common/Img/FileIcon/INS.jpg\r\nIP|||Ui/Common/Img/FileIcon/IP.jpg\r\nISO|||Ui/Common/Img/FileIcon/ISO.jpg\r\nISP|||Ui/Common/Img/FileIcon/ISP.jpg\r\nJAVA|||Ui/Common/Img/FileIcon/JAVA.jpg\r\nJFIF|||Ui/Common/Img/FileIcon/JFIF.jpg\r\nJPEG|||Ui/Common/Img/FileIcon/JPEG.jpg\r\nJPG|||\r\nLOG|||Ui/Common/Img/FileIcon/LOG.jpg\r\nM4A|||Ui/Common/Img/FileIcon/M4A.jpg\r\nMID|||Ui/Common/Img/FileIcon/MID.jpg\r\nMMF|||Ui/Common/Img/FileIcon/MMF.jpg\r\nMMM|||Ui/Common/Img/FileIcon/MMM.jpg\r\nMOV|||Ui/Common/Img/FileIcon/MOV.jpg\r\nMOVIE|||Ui/Common/Img/FileIcon/MOVIE.jpg\r\nMP2|||Ui/Common/Img/FileIcon/MP2.jpg\r\nMP2V|||Ui/Common/Img/FileIcon/MP2V.jpg\r\nMP3|||Ui/Common/Img/FileIcon/MP3.jpg\r\nMP4|||Ui/Common/Img/FileIcon/MP4.jpg\r\nMPE|||Ui/Common/Img/FileIcon/MPE.jpg\r\nMPEG|||Ui/Common/Img/FileIcon/MPEG.jpg\r\nMPG|||Ui/Common/Img/FileIcon/MPG.jpg\r\nMPV2|||Ui/Common/Img/FileIcon/MPV2.jpg\r\nNFO|||Ui/Common/Img/FileIcon/NFO.jpg\r\nPDD|||Ui/Common/Img/FileIcon/PDD.jpg\r\nPDF|||Ui/Common/Img/FileIcon/PDF.jpg\r\nPHP|||Ui/Common/Img/FileIcon/PHP.jpg\r\nPNG|||\r\nPPT|||Ui/Common/Img/FileIcon/PPT.jpg\r\nPPTX|||Ui/Common/Img/FileIcon/PPTX.jpg\r\nPSD|||Ui/Common/Img/FileIcon/PSD.jpg\r\nRAR|||Ui/Common/Img/FileIcon/RAR.jpg\r\nREG|||Ui/Common/Img/FileIcon/REG.jpg\r\nRTF|||Ui/Common/Img/FileIcon/RTF.jpg\r\nSCP|||Ui/Common/Img/FileIcon/SCP.jpg\r\nTHEME|||Ui/Common/Img/FileIcon/THEME.jpg\r\nTIF|||Ui/Common/Img/FileIcon/TIF.jpg\r\nTIFF|||Ui/Common/Img/FileIcon/TIFF.jpg\r\nTLB|||Ui/Common/Img/FileIcon/TLB.jpg\r\nTTF|||Ui/Common/Img/FileIcon/TTF.jpg\r\nTXT|||Ui/Common/Img/FileIcon/TXT.jpg\r\nUIS|||Ui/Common/Img/FileIcon/UIS.jpg\r\nURL|||Ui/Common/Img/FileIcon/URL.jpg\r\nVBS|||Ui/Common/Img/FileIcon/VBS.jpg\r\nVCR|||Ui/Common/Img/FileIcon/VCR.jpg\r\nVOB|||Ui/Common/Img/FileIcon/VOB.jpg\r\nWAV|||Ui/Common/Img/FileIcon/WAV.jpg\r\nWBA|||Ui/Common/Img/FileIcon/WBA.jpg\r\nWMA|||Ui/Common/Img/FileIcon/WMA.jpg\r\nWMV|||Ui/Common/Img/FileIcon/WMV.jpg\r\nWPL|||Ui/Common/Img/FileIcon/WPL.jpg\r\nWRI|||Ui/Common/Img/FileIcon/WRI.jpg\r\nWTX|||Ui/Common/Img/FileIcon/WTX.jpg\r\nXLSX|||Ui/Common/Img/FileIcon/XLSX.jpg\r\nXML|||Ui/Common/Img/FileIcon/XML.jpg\r\nXSL|||Ui/Common/Img/FileIcon/XSL.jpg\r\nZAP|||Ui/Common/Img/FileIcon/ZAP.jpg\r\nZIP|||Ui/Common/Img/FileIcon/ZIP.jpg\r\nXLS|||Ui/Common/Img/FileIcon/XLS.jpg',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (233,'图片扩展名类型','N_2010122111324162625','UploadfilesImg_Type',8,0,2,0,'Text',0,'JPG,PNG,GIF','JPG,PNG,GIF',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (234,'系统语言包根目录','N_2010122818344748635','sysLanguagePathRoot',9,0,2,9,'Text',180,'Cache/Language/','Cache/Language/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (235,'系统语言','N_2010122818404199920','sysLanguage',5,0,2,9,'Text',180,'ch/','ch/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (236,'电邮认证模板（用户资料认证）','N_2011010213314569754','EmailAccountConfirmTemplate',22,0,2,9,'TextArea',180,'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户电子邮箱认证邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）用户电子邮箱认证邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n请点击以下链接进入密码修改页面（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/Common/User/s_user_confirm.php?ActionTypeF=DConfirmEmail_Callback&CODE={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/Common/User/s_user_confirm.php?ActionTypeF=DConfirmEmail_Callback&CODE={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset={Nets.Charset}\"; charset=\"{Nets.Charset}\">\r\n<title>{Nets.Title} - 用户电子邮箱认证邮件</title>\r\n</head><body>\r\n<div style=\"line-height:22px; padding:7px 0px 7px 0px; margin:6px 0px 6px 0px; font-size:12px; color:#333333; font-family:Arial;\">\r\n<b>用户（{Nets.Name}）用户电子邮箱认证邮件</b><br />\r\n您好，您在{Nets.Title}的用户名是：{Nets.Name}<br />\r\n请点击以下链接进入密码修改页面（或复制以下链接到浏览器中打开）。<br />\r\n<a href=\"{Nets.Page}Plus/Common/User/s_user_confirm.php?ActionTypeF=DConfirmEmail_Callback&CODE={Nets.Encryption}\" target=\"_blank\">{Nets.Page}Plus/Common/User/s_user_confirm.php?ActionTypeF=DConfirmEmail_Callback&CODE={Nets.Encryption}</a><br />\r\n平台网址：<a href=\"{Nets.Page}\" target=\"_blank\">{Nets.Page}</a><br />\r\n</div>\r\n</body></html>',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (237,'手机认证模板（用户资料认证）','N_2011010213363889300','MobileAccountConfirmTemplate',22,0,2,9,'TextArea',180,'{Nets.Title}用户{Nets.Name}手机认证短信，您的认证码为：{Nets.Encryption}','{Nets.Title}用户{Nets.Name}手机认证短信，您的认证码为：{Nets.Encryption}',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (238,'短信接口帐号','N_2011010213440950100','MobileUName',10,0,2,77,'Text',180,'9999','9999',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (239,'短信接口密码','N_2011010213442524557','MobilePxd',10,0,2,77,'Text',180,'9999','9999',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (240,'采集文件目录','N_2011010703322013659','CollectionFileRoot',9,0,2,0,'Text',0,'Cache/DbCache/Collection/','Cache/DbCache/Collection/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (241,'采集结果处理文件路径','N_2011010802371542098','CollectionClassPath',9,0,2,0,'Text',0,'RULE/collection_class.php','RULE/collection_class.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (242,'用户服务型产品订单编号头','N_2011011415555958483','NumCodeHead_ServicesaleOrder',5,0,2,0,'Text',0,'SESO','SESO',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (243,'支付默认地址','N_2011011416023176165','PaySubmit_Default',5,0,2,0,'Text',0,'Plus/Common/Shop/pay_alipay_submit.php','Plus/Common/Shop/pay_alipay_submit.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (244,'远程数据接口网址','N_2011012107155655142','sysCoreAPISITE',5,0,2,0,'Text',0,'http://127.0.0.1:8080/_PROGRAM/MYPROJECT/Unionnets_com/unionnets_0042/webSite/Site_0/Common/Core/version_0042/webSite/','http://127.0.0.1:8080/_PROGRAM/MYPROJECT/Unionnets_com/unionnets_0042/webSite/Site_0/Common/Core/version_0042/webSite/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (245,'官方新闻接口地址','N_2011012107164027862','sysCoreNewsURL',5,0,2,0,'Text',0,'Data/Cms/doc/doc_NewsData.php','Data/Cms/doc/doc_NewsData.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (246,'操作成功后是否提示','N_2011012217273484356','MessageFrameAble',13,0,2,0,'RadioAR',2,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (247,'数据库备份路径','N_2011012716012911520','DBBackupPath',9,0,2,0,'Text',180,'Cache/DbBackup/','Cache/DbBackup/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (248,'是否自动识别城市','N_2011013105361564437','Zone_AutoIdentification',11,0,2,0,'RadioAR',6,'1','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (249,'远程识别IP地址','N_2011013110094751403','sysCoreZoneIPURL',5,0,2,0,'Text',180,'Data/Enquiry/enquiry/enquiryip.php','Data/Enquiry/enquiry/enquiryip.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (250,'第三方IP数据库地址','N_2011013115302820477','ZoneIpDbUrl',5,0,2,0,'Text',180,'http://www.ip138.com/ips.asp?ip={Nets.IP}&action=2','http://www.ip138.com/ips.asp?ip={Nets.IP}&action=2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (251,'KindEditor控件基路径','N_2011020400585719067','KindEditorBasePath',11,0,2,1,'Text',180,'../../../Component/KindEditor/','../../../Component/KindEditor/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (252,'FusionCharts控件基路径','N_2011020413095931521','FusionChartsBasePath',11,0,2,1,'Text',180,'../../../Component/FusionCharts/','../../../Component/FusionCharts/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (253,'OpenFlashChart基路径','N_2011020413101048541','OpenFlashChartBasePath',11,0,2,1,'Text',180,'../../../Component/OpenFlashChart/','../../../Component/OpenFlashChart/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (254,'用户协议','N_2011022202325073992','businessUserProtocol',13,0,2,1,'TextArea',180,'欢迎您成为{Nets.BusinessName}会员！ \r\n1、服务条款的确认和接纳\r\n{Nets.BusinessName}的各项服务的所有权和运作权归苏宁电器股份有限公司拥有。{Nets.BusinessName}所提供的服务必须按照其发布的服务条款和操作规则严格执行。用户通过完成注册程序并点击\"我同意\"按钮，表示用户接受{Nets.BusinessName}的所有服务条款。 \r\n2、{Nets.BusinessName}服务简介\r\n{Nets.BusinessName}运用自己的操作系统通过国际互联网络为用户提供各项网络服务。同时，用户必须： (1) 自行配备上网的所需设备，包括个人电脑、调制解调器或其他必备的上网装置。 (2) 自行负担个人上网所支付的与此服务有关的电话费用、网络费用。用户同意： (1) 提供及时、详尽及准确的个人资料。 (2) 不断更新注册资料、符合及时、详尽、准确的要求，所有原始键入的资料将引用为注册资料。 {Nets.BusinessName}不公开用户的姓名、地址、电子邮箱、帐号和电话号码。除非： (1) 用户特别要求{Nets.BusinessName}或授权某人通过电子邮件服务透露这些信息。 (2) 相应的法律及程序要求{Nets.BusinessName}提供用户的个人资料。如果用户提供的资料不准确，{Nets.BusinessName}有保留结束用户{Nets.BusinessName}会员资格的权利。 \r\n3、商品价格\r\n(1) 所有网上商城实际成交价格以网站人员确认为准。 (2) 全站商品价格仅限网上销售，不适用于门店。 \r\n4、服务条款的修改\r\n{Nets.BusinessName}有权在必要时修改服务条款，{Nets.BusinessName}服务条款一旦发生变化，将会在重要页面上提示修改内容。如果不接受所改动的内容，用户可以主动取消自己的会员资格。如果您不取消自己的会员资格，则视为接受服务条款的变动。 \r\n5、服务修订\r\n{Nets.BusinessName}保留随时修改或中断服务而不知会用户的权利/{Nets.BusinessName}行使修改或中断服务的权利，不需对用户或第三方负责。 \r\n6、用户隐私制度\r\n尊重用户个人隐私是{Nets.BusinessName}的一项基本政策，所以，作为对以上个人注册资料分析的补充，{Nets.BusinessName}一定不会在未经合法用户授权时公开、编辑或透露其注册资料及保存在{Nets.BusinessName}中的非公开内容，除非法律许可要求或{Nets.BusinessName}在诚信的基础上认为透露这些内容在以下四种情况下是必要的： (1) 遵守有关法律规定，遵从合法服务程序。 (2) 保持维护{Nets.BusinessName}的商标所有权。 (3) 在紧急情况下竭力维护用户个人和社会大众的隐私安全。 (4) 符合其他相关的要求。 \r\n7、用户的帐号、密码和安全性\r\n一旦成功注册成为{Nets.BusinessName}会员，成为{Nets.BusinessName}合法用户，您将得到一个密码和用户名。用户将对用户名和密码的安全负全部责任。另外，每个用户都要对以其用户名进行的所有活动和事件负全责。您可以随时根据指示改变您的密码。用户若发现任何非法使用用户帐号或存在安全漏洞的情况，请立即通告{Nets.BusinessName}。用户在门店或网站可得到会员卡或会员授权号，为保护您的个人权益，请勿使用重复性或者连续数字的简单密码，请勿将密码告知他人，如因密码保管不善造成的经济损失由个人承担。 \r\n8、拒绝提供担保\r\n用户明确同意信息服务的使用由用户个人承担风险。{Nets.BusinessName}不担保服务一定满足会员的要求，也不担保服务不会受中断，对服务的及时性、安全性、出错发生都不作担保。会员理解并接受：任何通过{Nets.BusinessName}上商城服务取得的信息资料的可靠性取决于用户自己，用户自己承担所有风险和责任。。 \r\n9、有限责任\r\n{Nets.BusinessName}对任何直接、间接、偶然及继起的损害不负责任，这些损害来自：不正当使用{Nets.BusinessName}服务，或用户传送的信息不符合规定等。这些行为都有可能导致{Nets.BusinessName}的形象受损，所以{Nets.BusinessName}事先提出这种损害的可能性。 \r\n10、对用户信息的存储和限制\r\n{Nets.BusinessName}不对用户发布信息的删除或储存失败负责，{Nets.BusinessName}有判定用户的行为是否符合{Nets.BusinessName}服务条款的要求和精神的保留权利。如果用户违背了服务条款的规定，{Nets.BusinessName}有中断对其提供服务的权利。 \r\n11、用户管理\r\n用户必须遵循： (1) 从中国境内向外传输技术性资料时必须符合中国有关法规。 (2) 使用信息服务不作非法用途。 (3) 不干扰或混乱网络服务。 (4) 遵守所有使用服务的网络协议、规定、程序和惯例。用户的行为准则是以因特网法规，政策、程序和惯例为根据的。 \r\n12、保障\r\n用户同意保障和维护{Nets.BusinessName}全体成员的利益，负责支付由用户使用超出服务范围引起的律师费用，违反服务条款的损害补偿费用，其它人使用用户的电脑、帐号和其它知识产权的追索费。 \r\n13、结束服务\r\n用户或{Nets.BusinessName}可随时根据实际情况中断一项或多项服务。{Nets.BusinessName}不需对任何个人或第三方负责而随时中断服务。用户若反对任何服务条款的建议或对后来的条款修改有异议，或对{Nets.BusinessName}服务不满，用户可以行使如下权利： (1) 不再使用{Nets.BusinessName}信息服务。 (2) 通知{Nets.BusinessName}停止对该用户的服务。结束用户服务后，用户使用{Nets.BusinessName}服务的权利马上中止。从那时起，用户没有权利，{Nets.BusinessName}也没有义务传送任何未处理的信息或未完成的服务给用户或第三方。 \r\n14、通告\r\n所有发给用户的通告都可通过重要页面的公告或电子邮件或常规的信件传送。服务条款的修改、服务变更、或其它重要事件的通告都会以此形式进行。 \r\n15、信息内容的所有权\r\n{Nets.BusinessName}定义的信息内容包括：文字、软件、声音、相片、录象、图表；在广告中全部内容；{Nets.BusinessName}为用户提供的其它信息。所有这些内容受版权、商标、标签和其它财产所有权法律的保护。所以，用户只能在{Nets.BusinessName}和广告商授权下才能使用这些内容，而不能擅自复制、再造这些内容、或创造与内容有关的派生产品 \r\n16、法律\r\n{Nets.BusinessName}信息服务条款要与中华人民共和国的法律解释一致。用户和{Nets.BusinessName}一致同意服从苏宁电器股份有限公司所在地有管辖权的法院管辖。如发生{Nets.BusinessName}服务条款与中华人民共和国法律相抵触时，则这些条款将完全按法律规定重新解释，而其它条款则依旧保持对用户的约束力。 \r\n17、验证码条款\r\n用户在购物时，网站发送校验码到购物登记的手机号码、站内消息和订单中心，请妥善保管好校验码，校验码将作为交货、提货时的唯一凭证。每个校验码仅使用一次。因校验码泄密造成的后果，由下单人自己承担。','欢迎您成为{Nets.BusinessName}会员！ \r\n1、服务条款的确认和接纳\r\n{Nets.BusinessName}的各项服务的所有权和运作权归苏宁电器股份有限公司拥有。{Nets.BusinessName}所提供的服务必须按照其发布的服务条款和操作规则严格执行。用户通过完成注册程序并点击\"我同意\"按钮，表示用户接受{Nets.BusinessName}的所有服务条款。 \r\n2、{Nets.BusinessName}服务简介\r\n{Nets.BusinessName}运用自己的操作系统通过国际互联网络为用户提供各项网络服务。同时，用户必须： (1) 自行配备上网的所需设备，包括个人电脑、调制解调器或其他必备的上网装置。 (2) 自行负担个人上网所支付的与此服务有关的电话费用、网络费用。用户同意： (1) 提供及时、详尽及准确的个人资料。 (2) 不断更新注册资料、符合及时、详尽、准确的要求，所有原始键入的资料将引用为注册资料。 {Nets.BusinessName}不公开用户的姓名、地址、电子邮箱、帐号和电话号码。除非： (1) 用户特别要求{Nets.BusinessName}或授权某人通过电子邮件服务透露这些信息。 (2) 相应的法律及程序要求{Nets.BusinessName}提供用户的个人资料。如果用户提供的资料不准确，{Nets.BusinessName}有保留结束用户{Nets.BusinessName}会员资格的权利。 \r\n3、商品价格\r\n(1) 所有网上商城实际成交价格以网站人员确认为准。 (2) 全站商品价格仅限网上销售，不适用于门店。 \r\n4、服务条款的修改\r\n{Nets.BusinessName}有权在必要时修改服务条款，{Nets.BusinessName}服务条款一旦发生变化，将会在重要页面上提示修改内容。如果不接受所改动的内容，用户可以主动取消自己的会员资格。如果您不取消自己的会员资格，则视为接受服务条款的变动。 \r\n5、服务修订\r\n{Nets.BusinessName}保留随时修改或中断服务而不知会用户的权利/{Nets.BusinessName}行使修改或中断服务的权利，不需对用户或第三方负责。 \r\n6、用户隐私制度\r\n尊重用户个人隐私是{Nets.BusinessName}的一项基本政策，所以，作为对以上个人注册资料分析的补充，{Nets.BusinessName}一定不会在未经合法用户授权时公开、编辑或透露其注册资料及保存在{Nets.BusinessName}中的非公开内容，除非法律许可要求或{Nets.BusinessName}在诚信的基础上认为透露这些内容在以下四种情况下是必要的： (1) 遵守有关法律规定，遵从合法服务程序。 (2) 保持维护{Nets.BusinessName}的商标所有权。 (3) 在紧急情况下竭力维护用户个人和社会大众的隐私安全。 (4) 符合其他相关的要求。 \r\n7、用户的帐号、密码和安全性\r\n一旦成功注册成为{Nets.BusinessName}会员，成为{Nets.BusinessName}合法用户，您将得到一个密码和用户名。用户将对用户名和密码的安全负全部责任。另外，每个用户都要对以其用户名进行的所有活动和事件负全责。您可以随时根据指示改变您的密码。用户若发现任何非法使用用户帐号或存在安全漏洞的情况，请立即通告{Nets.BusinessName}。用户在门店或网站可得到会员卡或会员授权号，为保护您的个人权益，请勿使用重复性或者连续数字的简单密码，请勿将密码告知他人，如因密码保管不善造成的经济损失由个人承担。 \r\n8、拒绝提供担保\r\n用户明确同意信息服务的使用由用户个人承担风险。{Nets.BusinessName}不担保服务一定满足会员的要求，也不担保服务不会受中断，对服务的及时性、安全性、出错发生都不作担保。会员理解并接受：任何通过{Nets.BusinessName}上商城服务取得的信息资料的可靠性取决于用户自己，用户自己承担所有风险和责任。。 \r\n9、有限责任\r\n{Nets.BusinessName}对任何直接、间接、偶然及继起的损害不负责任，这些损害来自：不正当使用{Nets.BusinessName}服务，或用户传送的信息不符合规定等。这些行为都有可能导致{Nets.BusinessName}的形象受损，所以{Nets.BusinessName}事先提出这种损害的可能性。 \r\n10、对用户信息的存储和限制\r\n{Nets.BusinessName}不对用户发布信息的删除或储存失败负责，{Nets.BusinessName}有判定用户的行为是否符合{Nets.BusinessName}服务条款的要求和精神的保留权利。如果用户违背了服务条款的规定，{Nets.BusinessName}有中断对其提供服务的权利。 \r\n11、用户管理\r\n用户必须遵循： (1) 从中国境内向外传输技术性资料时必须符合中国有关法规。 (2) 使用信息服务不作非法用途。 (3) 不干扰或混乱网络服务。 (4) 遵守所有使用服务的网络协议、规定、程序和惯例。用户的行为准则是以因特网法规，政策、程序和惯例为根据的。 \r\n12、保障\r\n用户同意保障和维护{Nets.BusinessName}全体成员的利益，负责支付由用户使用超出服务范围引起的律师费用，违反服务条款的损害补偿费用，其它人使用用户的电脑、帐号和其它知识产权的追索费。 \r\n13、结束服务\r\n用户或{Nets.BusinessName}可随时根据实际情况中断一项或多项服务。{Nets.BusinessName}不需对任何个人或第三方负责而随时中断服务。用户若反对任何服务条款的建议或对后来的条款修改有异议，或对{Nets.BusinessName}服务不满，用户可以行使如下权利： (1) 不再使用{Nets.BusinessName}信息服务。 (2) 通知{Nets.BusinessName}停止对该用户的服务。结束用户服务后，用户使用{Nets.BusinessName}服务的权利马上中止。从那时起，用户没有权利，{Nets.BusinessName}也没有义务传送任何未处理的信息或未完成的服务给用户或第三方。 \r\n14、通告\r\n所有发给用户的通告都可通过重要页面的公告或电子邮件或常规的信件传送。服务条款的修改、服务变更、或其它重要事件的通告都会以此形式进行。 \r\n15、信息内容的所有权\r\n{Nets.BusinessName}定义的信息内容包括：文字、软件、声音、相片、录象、图表；在广告中全部内容；{Nets.BusinessName}为用户提供的其它信息。所有这些内容受版权、商标、标签和其它财产所有权法律的保护。所以，用户只能在{Nets.BusinessName}和广告商授权下才能使用这些内容，而不能擅自复制、再造这些内容、或创造与内容有关的派生产品 \r\n16、法律\r\n{Nets.BusinessName}信息服务条款要与中华人民共和国的法律解释一致。用户和{Nets.BusinessName}一致同意服从苏宁电器股份有限公司所在地有管辖权的法院管辖。如发生{Nets.BusinessName}服务条款与中华人民共和国法律相抵触时，则这些条款将完全按法律规定重新解释，而其它条款则依旧保持对用户的约束力。 \r\n17、验证码条款\r\n用户在购物时，网站发送校验码到购物登记的手机号码、站内消息和订单中心，请妥善保管好校验码，校验码将作为交货、提货时的唯一凭证。每个校验码仅使用一次。因校验码泄密造成的后果，由下单人自己承担。',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (255,'标志文件路径','N_2011030805532351937','sysDbFlagPath',9,0,2,20,'Text',180,'Cache/DbFlag/','Cache/DbFlag/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (256,'是否一定要选择地区','N_2011031617050235516','sysZoneMustbe',5,0,2,20,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (257,'选择地区主页路径','N_2011031617111640097','sysZoneMustbeURL',6,0,2,20,'Text',180,'Plus/m_default/Nets/zoneHome.php','Plus/m_default/Nets/zoneHome.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (258,'订购参数名_操作','N_2011031818301271670','orderParameterName_Operation',5,0,2,20,'Text',180,'DOrderOperation','DOrderOperation',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (259,'订购参数名_内容','N_2011031818303192495','orderParameterName_Content',5,0,2,20,'Text',180,'DOrderContent','DOrderContent',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (260,'订购参数名_COOKIE内容','N_2011031818311066949','orderParameterName_CookieContent',5,0,2,20,'Text',180,'DOrderContent','DOrderContent',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (261,'CKEditor控件基路径','N_2011032018075481311','CKEditorBasePath',11,0,2,1,'Text',180,'../../../Component/CKeditor/','../../../Component/CKeditor/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (262,'是否显示高级选项','N_2011032018151689239','sysShowAdvancedOptions',11,0,2,1,'RadioAR',180,'1','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (263,'默认全局审核','N_2011032211544899301','sysDefaultChecked',5,0,2,1,'RadioAR',180,'2','2',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (264,'注册需要手机短信认证','N_2011032215421920166','userUserMobileCheckAble',19,0,2,110,'RadioAR',180,'0','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (265,'可以选择的地区','N_2011032219273049346','Zone_Optional',7,0,2,0,'TextArea',0,'广州,深圳,上海,北京,武汉,','广州,深圳,上海,北京,武汉,',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (266,'发帖系统默认用户名','N_2011041706554140719','PostMachine_DefaultUsername',11,0,2,0,'Text',0,'pfactory111','pfactory111',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (267,'发帖系统默认密码','N_2011041706560282040','PostMachine_DefaultPxd',11,0,2,0,'Text',0,'F491JDF9','F491JDF9',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (268,'发帖时的广告','N_2011041707155362890','PostMachine_ADV',11,0,2,0,'Text',0,'迫丝工厂（unionnets.com）','迫丝工厂（unionnets.com）',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (269,'地区缓存路径','N_2011042210554572824','PathZoneCache',9,0,2,0,'Text',180,'Cache/DbCache/Zone/','Cache/DbCache/Zone/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (270,'常更改的系统设置标志','N_2011042913275198132','RegularSysconfigFlag',5,0,2,0,'TextArea',180,'sysCorePowerNumcode,bussinessLogo,bussinessName,bussinessMetaVersion,bussinessMetaDescription,bussinessMetaKeyword,bussinessMetaTitle,NoImgFileThumbPath,ThumbWaterPosition,ThumbWaterPath,ThumbWater,ThumbPath,ThumbEnable,UploadFileSize,UploadFileType,AttachUrlPath,UploadFileRename,userUploadOtherFileThumb,ThumbWaterQuality,ThumbWaterDiaphaneity,ThumbWaterCondition,userUploadThumbSize,userWordFilterContent,userWordFilterAble,userWordLimitContent,userWordLimitAble,EmailHostPost,EmailPxd,EmailName,EmailHost,EmailAble,businessUserProtocol,MessageFrameAble,UserEditorType,SubmitLimitFreeze,SubmitLimitTime,SubmitLimitViews,QuestionsInitialCode,Pay_DefaultUserorderAmount,HtmlEditorType,CheckSortCouponDiscuss,CheckSortCoupon,CheckSortActiveDiscuss,CheckSortActive,CheckStoryArticleDiscuss,CheckStoryArticle,CheckStoryNodeDiscuss,CheckStoryNode,CheckStoryVolumeDiscuss,CheckStoryVolume,CheckCommPostsReply,CheckCommPosts,CheckCommCircleDiscuss,CheckCommCircle,CheckSortUnitProductDiscuss,CheckSortUnitProduct,CheckSortUnitDiscuss,CheckSortUnit,CheckRequireRequireDiscuss,CheckRequireRequire,CheckRequireSupplyDiscuss,CheckRequireSupply,CheckShopFavourable,CheckShopPresent,CheckShopSaleDiscuss,CheckShopSale,CheckCmsAskReply,CheckCmsAsk,CheckCmsDocDiscuss,CheckCmsDoc,Zone_Optional,Zone_Opened,','sysCorePowerNumcode,bussinessLogo,bussinessName,bussinessMetaVersion,bussinessMetaDescription,bussinessMetaKeyword,bussinessMetaTitle,NoImgFileThumbPath,ThumbWaterPosition,ThumbWaterPath,ThumbWater,ThumbPath,ThumbEnable,UploadFileSize,UploadFileType,AttachUrlPath,UploadFileRename,userUploadOtherFileThumb,ThumbWaterQuality,ThumbWaterDiaphaneity,ThumbWaterCondition,userUploadThumbSize,userWordFilterContent,userWordFilterAble,userWordLimitContent,userWordLimitAble,EmailHostPost,EmailPxd,EmailName,EmailHost,EmailAble,businessUserProtocol,MessageFrameAble,UserEditorType,SubmitLimitFreeze,SubmitLimitTime,SubmitLimitViews,QuestionsInitialCode,Pay_DefaultUserorderAmount,HtmlEditorType,CheckSortCouponDiscuss,CheckSortCoupon,CheckSortActiveDiscuss,CheckSortActive,CheckStoryArticleDiscuss,CheckStoryArticle,CheckStoryNodeDiscuss,CheckStoryNode,CheckStoryVolumeDiscuss,CheckStoryVolume,CheckCommPostsReply,CheckCommPosts,CheckCommCircleDiscuss,CheckCommCircle,CheckSortUnitProductDiscuss,CheckSortUnitProduct,CheckSortUnitDiscuss,CheckSortUnit,CheckRequireRequireDiscuss,CheckRequireRequire,CheckRequireSupplyDiscuss,CheckRequireSupply,CheckShopFavourable,CheckShopPresent,CheckShopSaleDiscuss,CheckShopSale,CheckCmsAskReply,CheckCmsAsk,CheckCmsDocDiscuss,CheckCmsDoc,Zone_Optional,Zone_Opened,',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (271,'用户推荐标志','N_2011050317581389260','UserRecommendFlag',5,0,2,0,'Text',180,'UserRecommendFlag','UserRecommendFlag',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (272,'推荐链接文字内容','N_2011050501071622265','RecommendLinkText',13,0,2,0,'Text',180,'这个网站还不错，欢迎访问','这个网站还不错，欢迎访问',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (273,'推荐表单内容','N_2011050502055433972','RecommendForm',13,0,2,0,'TextArea',180,'','',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (274,'是否启用默认地区','N_201105141715123588','Zone_Default_Able',11,0,2,0,'RadioAR',0,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (275,'开放平台用户登陆接口地址','N_2011051716340880792','OpenShare_LoginURL',6,0,2,0,'Text',0,'Plus/Common/User/Register_OpenShare.php','Plus/Common/User/Register_OpenShare.php',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (276,'开放平台用户SESSION名','N_2011051718175128619','OpenShare_Session',19,0,2,0,'Text',0,'OpenShare_Session','OpenShare_Session',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (277,'使用数据菜单(User)','N_2011052122361638217','DbMenu_User',5,0,2,0,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (278,'使用数据菜单(Platform)','N_2011052122363245764','DbMenu_Platform',5,0,2,0,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (279,'使用数据菜单(QPlatform)','N_2011052122364323657','DbMenu_QPlatform',5,0,2,0,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (280,'使用数据菜单(Mana)','N_2011052122365244717','DbMenu_Mana',5,0,2,0,'RadioAR',180,'0','1',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (281,'菜单配置文件路径','N_2011052123182210937','MenuConfigPath',9,0,2,0,'Text',180,'Cache/DbCache/Menu_File/','Cache/DbCache/Menu_File/',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (282,'快捷数据菜单(User)','N_201106011530436170','DbMenu_Q_User',5,0,2,0,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (283,'快捷数据菜单(Platform)','N_2011060115304925900','DbMenu_Q_Platform',5,0,2,0,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (284,'快捷数据菜单(QPlatform)','N_2011060115305437365','DbMenu_Q_QPlatform',5,0,2,0,'RadioAR',180,'0','0',0,0,'');
insert  into `gsnavigation_netssysconfiginfo`(`scitID`,`scitName`,`scitNumCode`,`scitSign`,`scitParid`,`scitRecycle`,`scitChecked`,`scitOrderBy`,`scitUiType`,`scitUiLen`,`scitDefaultValue`,`scitUserValue`,`scitEnable`,`scitOptionAR`,`scitIntroduct`) values (285,'快捷数据菜单(Mana)','N_2011060115305829287','DbMenu_Q_Mana',5,0,2,0,'RadioAR',180,'0','0',0,0,'');

/*Table structure for table `gsnavigation_netssysdbinfo` */

DROP TABLE IF EXISTS `gsnavigation_netssysdbinfo`;

CREATE TABLE `gsnavigation_netssysdbinfo` (
  `sditID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sditName` varchar(180) default '-' COMMENT '名称',
  `sditNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `sditRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `sditChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `sditOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `sditCreateBy` int(11) default '0' COMMENT '发布人',
  `sditCreateTime` datetime default NULL COMMENT '发布时间',
  `sditPath` varchar(180) default '..' COMMENT '保存路径',
  PRIMARY KEY  (`sditID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysdbinfo` */

/*Table structure for table `gsnavigation_netssysdbinfocont` */

DROP TABLE IF EXISTS `gsnavigation_netssysdbinfocont`;

CREATE TABLE `gsnavigation_netssysdbinfocont` (
  `sdictID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sdictIndexID` int(11) default '0' COMMENT '主表ID号',
  `sdictIntroduct` text COMMENT '介绍',
  `sdictContent` text COMMENT '内容',
  `sdictRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`sdictID`),
  KEY `sdictIndexID` (`sdictIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysdbinfocont` */

/*Table structure for table `gsnavigation_netssysfunction` */

DROP TABLE IF EXISTS `gsnavigation_netssysfunction`;

CREATE TABLE `gsnavigation_netssysfunction` (
  `sftID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sftName` varchar(180) default '-' COMMENT '名称',
  `sftNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `sftModuleid` int(11) default '0' COMMENT '模块ID',
  `sftRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `sftChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `sftOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `sftCreateBy` int(11) default '0' COMMENT '发布人',
  `sftCreateTime` datetime default NULL COMMENT '发布时间',
  `sftPower_Flag` text COMMENT '不可操作权限标签，格式：名称;标签|||操作名称;标签|||（一般用表名命名），如：不可管理文档;un_cmsdoc|||不要新增文档;un_cmsdoc_add|||',
  PRIMARY KEY  (`sftID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysfunction` */

insert  into `gsnavigation_netssysfunction`(`sftID`,`sftName`,`sftNumCode`,`sftModuleid`,`sftRecycle`,`sftChecked`,`sftOrderBy`,`sftCreateBy`,`sftCreateTime`,`sftPower_Flag`) values (1,'项目管理','-',26,0,2,0,1,'2011-01-27 11:46:51','任务项目;projproject\r\n不能查看;projproject_view\r\n不能新增;projproject_add\r\n不能修改;projproject_modify\r\n不能删除;projproject_delete');
insert  into `gsnavigation_netssysfunction`(`sftID`,`sftName`,`sftNumCode`,`sftModuleid`,`sftRecycle`,`sftChecked`,`sftOrderBy`,`sftCreateBy`,`sftCreateTime`,`sftPower_Flag`) values (2,'任务管理','N_2010121312142965737',26,0,2,0,1,'2011-01-27 11:46:25','任务权限;projprogress\r\n不能查看;projprogress_view\r\n不能新增;projprogress_add\r\n不能修改;projprogress_modify\r\n不能删除;projprogress_delete');
insert  into `gsnavigation_netssysfunction`(`sftID`,`sftName`,`sftNumCode`,`sftModuleid`,`sftRecycle`,`sftChecked`,`sftOrderBy`,`sftCreateBy`,`sftCreateTime`,`sftPower_Flag`) values (3,'问题管理','N_2010121312144385830',26,0,2,0,1,'2011-01-27 11:45:43','问题权限;projbug\r\n不能查看;projbug_view\r\n不能新增;projbug_add\r\n不能修改;projbug_modify\r\n不能删除;projbug_delete');
insert  into `gsnavigation_netssysfunction`(`sftID`,`sftName`,`sftNumCode`,`sftModuleid`,`sftRecycle`,`sftChecked`,`sftOrderBy`,`sftCreateBy`,`sftCreateTime`,`sftPower_Flag`) values (4,'文档管理','N_201101271118525987',6,0,2,0,1,'2011-01-27 11:46:05','文档权限;cmsdoc\r\n不能查看;cmsdoc_view\r\n不能新增;cmsdoc_add\r\n不能修改;cmsdoc_modify\r\n不能删除;cmsdoc_delete');

/*Table structure for table `gsnavigation_netssysfunctioncont` */

DROP TABLE IF EXISTS `gsnavigation_netssysfunctioncont`;

CREATE TABLE `gsnavigation_netssysfunctioncont` (
  `sfctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sfctIndexID` int(11) default '0' COMMENT '主表ID号',
  `sfctIntroduct` text COMMENT '功能介绍',
  PRIMARY KEY  (`sfctID`),
  KEY `sfctIndexID` (`sfctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysfunctioncont` */

insert  into `gsnavigation_netssysfunctioncont`(`sfctID`,`sfctIndexID`,`sfctIntroduct`) values (1,1,'');
insert  into `gsnavigation_netssysfunctioncont`(`sfctID`,`sfctIndexID`,`sfctIntroduct`) values (2,2,'');
insert  into `gsnavigation_netssysfunctioncont`(`sfctID`,`sfctIndexID`,`sfctIntroduct`) values (3,3,'');
insert  into `gsnavigation_netssysfunctioncont`(`sfctID`,`sfctIndexID`,`sfctIntroduct`) values (4,4,'');

/*Table structure for table `gsnavigation_netssyshelpgroup` */

DROP TABLE IF EXISTS `gsnavigation_netssyshelpgroup`;

CREATE TABLE `gsnavigation_netssyshelpgroup` (
  `shgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `shgtName` varchar(180) default '-' COMMENT '名称',
  `shgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `shgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `shgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `shgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `shgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `shgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `shgtCreateBy` int(11) default '0' COMMENT '发布人',
  `shgtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`shgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyshelpgroup` */

insert  into `gsnavigation_netssyshelpgroup`(`shgtID`,`shgtName`,`shgtNameStyle`,`shgtNumCode`,`shgtParid`,`shgtRecycle`,`shgtChecked`,`shgtOrderBy`,`shgtCreateBy`,`shgtCreateTime`) values (1,'ROOT','','N_2010032319013936700',0,0,2,0,1,'2010-03-23 19:01:39');
insert  into `gsnavigation_netssyshelpgroup`(`shgtID`,`shgtName`,`shgtNameStyle`,`shgtNumCode`,`shgtParid`,`shgtRecycle`,`shgtChecked`,`shgtOrderBy`,`shgtCreateBy`,`shgtCreateTime`) values (2,'网集帮助文档','','N_2010032319014811871',1,0,2,0,1,'2010-03-23 19:01:48');

/*Table structure for table `gsnavigation_netssyshelpgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_netssyshelpgroupcont`;

CREATE TABLE `gsnavigation_netssyshelpgroupcont` (
  `shgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `shgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `shgctCount_Views` int(11) default '0' COMMENT '查看数',
  `shgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `shgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `shgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `shgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `shgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `shgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `shgctChannelid` text COMMENT '所属频道',
  `shgctModelid_List` int(11) default '0' COMMENT '列表模型',
  `shgctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `shgctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `shgctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `shgctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `shgctPower_View` text COMMENT '用户查看权限',
  `shgctPower_Public` text COMMENT '用户发布权限',
  `shgctSpicalPosition` text COMMENT '特殊位置',
  `shgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `shgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `shgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `shgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `shgctMetaDescription` text COMMENT 'MetaDescription',
  `shgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `shgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `shgctSources` text COMMENT '图集',
  `shgctIntroduct` text COMMENT '详细介绍',
  `shgctContent` text COMMENT '内容',
  `shgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`shgctID`),
  KEY `shgctIndexID` (`shgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyshelpgroupcont` */

/*Table structure for table `gsnavigation_netssyshelpinfo` */

DROP TABLE IF EXISTS `gsnavigation_netssyshelpinfo`;

CREATE TABLE `gsnavigation_netssyshelpinfo` (
  `shitID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `shitName` varchar(180) default '-' COMMENT '名称',
  `shitNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `shitNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `shitParid` int(11) default '0' COMMENT '上级或分类ID',
  `shitRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `shitChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `shitOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `shitCreateBy` int(11) default '0' COMMENT '发布人',
  `shitCreateTime` datetime default NULL COMMENT '发布时间',
  `shitTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`shitID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyshelpinfo` */

/*Table structure for table `gsnavigation_netssyshelpinfocont` */

DROP TABLE IF EXISTS `gsnavigation_netssyshelpinfocont`;

CREATE TABLE `gsnavigation_netssyshelpinfocont` (
  `shictID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `shictIndexID` int(11) default '0' COMMENT '主表ID号',
  `shictCount_Views` int(11) default '0' COMMENT '查看数',
  `shictCount_Discuss` int(11) default '0' COMMENT '回复数',
  `shictCode_Positive` int(11) default '0' COMMENT '正面打分',
  `shictCode_Negative` int(11) default '0' COMMENT '负面打分',
  `shictChannelid` text COMMENT '所属频道',
  `shictRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `shictRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `shictModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `shictTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `shictDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `shictKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `shictKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `shictPageAble` int(2) default '0' COMMENT '是否分页',
  `shictPower_View` text COMMENT '用户查看权限',
  `shictPower_Public` text COMMENT '用户发布权限',
  `shictSpicalPosition` text COMMENT '特殊位置',
  `shictSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `shictSmallContent` varchar(180) default '-' COMMENT '简介',
  `shictMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `shictMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `shictMetaDescription` text COMMENT 'MetaDescription',
  `shictSourceR00` varchar(180) default '-' COMMENT '小图片',
  `shictSourceR01` varchar(180) default '-' COMMENT '大图片',
  `shictSources` text COMMENT '图集',
  `shictIntroduct` text COMMENT '详细介绍',
  `shictContent` text COMMENT '内容',
  `shictPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `shictPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `shictPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `shictRemark` text COMMENT '备注',
  PRIMARY KEY  (`shictID`),
  KEY `shictIndexID` (`shictIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyshelpinfocont` */

/*Table structure for table `gsnavigation_netssyslanguage` */

DROP TABLE IF EXISTS `gsnavigation_netssyslanguage`;

CREATE TABLE `gsnavigation_netssyslanguage` (
  `sltID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sltName` varchar(180) default '-' COMMENT '名称',
  `sltNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `sltNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `sltParid` int(11) default '0' COMMENT '上级或分类ID',
  `sltRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `sltChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `sltOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `sltCreateBy` int(11) default '0' COMMENT '发布人',
  `sltCreateTime` datetime default NULL COMMENT '发布时间',
  `sltFlag` varchar(180) default '-' COMMENT '标志名称，请注意多级别的命名空间，如：Mana_Nets_System_Title',
  `sltValue` text COMMENT '语言内容值',
  PRIMARY KEY  (`sltID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyslanguage` */

/*Table structure for table `gsnavigation_netssyslanguagecont` */

DROP TABLE IF EXISTS `gsnavigation_netssyslanguagecont`;

CREATE TABLE `gsnavigation_netssyslanguagecont` (
  `slctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `slctIndexID` int(11) default '0' COMMENT '主表ID号',
  `slctCount_Views` int(11) default '0' COMMENT '查看数',
  `slctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `slctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `slctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `slctChannelid` text COMMENT '所属频道',
  `slctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `slctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `slctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `slctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `slctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `slctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `slctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `slctPageAble` int(2) default '0' COMMENT '是否分页',
  `slctPower_View` text COMMENT '用户查看权限',
  `slctPower_Public` text COMMENT '用户发布权限',
  `slctSpicalPosition` text COMMENT '特殊位置',
  `slctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `slctSmallContent` varchar(180) default '-' COMMENT '简介',
  `slctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `slctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `slctMetaDescription` text COMMENT 'MetaDescription',
  `slctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `slctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `slctSources` text COMMENT '图集',
  `slctIntroduct` text COMMENT '详细介绍',
  `slctContent` text COMMENT '内容',
  `slctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `slctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `slctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `slctRemark` text COMMENT '备注',
  PRIMARY KEY  (`slctID`),
  KEY `slctIndexID` (`slctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyslanguagecont` */

/*Table structure for table `gsnavigation_netssyslanguagegroup` */

DROP TABLE IF EXISTS `gsnavigation_netssyslanguagegroup`;

CREATE TABLE `gsnavigation_netssyslanguagegroup` (
  `slgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `slgtName` varchar(180) default '-' COMMENT '名称',
  `slgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `slgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `slgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `slgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `slgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `slgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `slgtCreateBy` int(11) default '0' COMMENT '发布人',
  `slgtCreateTime` datetime default NULL COMMENT '发布时间',
  `slgtPath` varchar(180) default '.' COMMENT '路径',
  PRIMARY KEY  (`slgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyslanguagegroup` */

/*Table structure for table `gsnavigation_netssyslanguagegroupcont` */

DROP TABLE IF EXISTS `gsnavigation_netssyslanguagegroupcont`;

CREATE TABLE `gsnavigation_netssyslanguagegroupcont` (
  `slgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `slgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `slgctCount_Views` int(11) default '0' COMMENT '查看数',
  `slgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `slgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `slgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `slgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `slgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `slgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `slgctChannelid` text COMMENT '所属频道',
  `slgctModelid_List` int(11) default '0' COMMENT '列表模型',
  `slgctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `slgctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `slgctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `slgctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `slgctPower_View` text COMMENT '用户查看权限',
  `slgctPower_Public` text COMMENT '用户发布权限',
  `slgctSpicalPosition` text COMMENT '特殊位置',
  `slgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `slgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `slgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `slgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `slgctMetaDescription` text COMMENT 'MetaDescription',
  `slgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `slgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `slgctSources` text COMMENT '图集',
  `slgctIntroduct` text COMMENT '详细介绍',
  `slgctContent` text COMMENT '内容',
  `slgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`slgctID`),
  KEY `slgctIndexID` (`slgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyslanguagegroupcont` */

/*Table structure for table `gsnavigation_netssysmenu` */

DROP TABLE IF EXISTS `gsnavigation_netssysmenu`;

CREATE TABLE `gsnavigation_netssysmenu` (
  `smetID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `smetName` varchar(180) default '-' COMMENT '名称',
  `smetNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `smetNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `smetParid` int(11) default '0' COMMENT '上级或分类ID',
  `smetType` int(2) default '0' COMMENT '类型：1.管理菜单2.平台菜单3.网站用户界面菜单',
  `smetType_Sys` int(2) default '0' COMMENT '平台类型，可以理解为TYPE的子TYPE',
  `smetRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `smetChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `smetOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `smetLink` varchar(180) default '-' COMMENT '链接',
  `smetTarget` varchar(42) default '_self' COMMENT '目标',
  `smetIntroduct` varchar(180) default '-' COMMENT '简单介绍',
  `smetPower_Flag` varchar(180) default '' COMMENT '权限标签，如：un_cmsdoc',
  `smetPower_UserType` varchar(180) default '-' COMMENT 'uitTypeid的减权限，如此参数为4，则uitTypeid为4的用户就不能显示此菜单',
  PRIMARY KEY  (`smetID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysmenu` */

/*Table structure for table `gsnavigation_netssysmenucont` */

DROP TABLE IF EXISTS `gsnavigation_netssysmenucont`;

CREATE TABLE `gsnavigation_netssysmenucont` (
  `smectID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `smectIndexID` int(11) default '0' COMMENT '主表ID号',
  `smectSourceR00` varchar(180) default '-' COMMENT '图标',
  `smectIntroduct` text COMMENT '介绍',
  PRIMARY KEY  (`smectID`),
  KEY `smectIndexID` (`smectIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysmenucont` */

/*Table structure for table `gsnavigation_netssysoption` */

DROP TABLE IF EXISTS `gsnavigation_netssysoption`;

CREATE TABLE `gsnavigation_netssysoption` (
  `sotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sotName` varchar(180) default '-' COMMENT '名称',
  `sotNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `sotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `sotParid` int(11) default '0' COMMENT '上级或分类ID',
  `sotRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `sotChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `sotOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `sotValue` varchar(180) default '-' COMMENT '值',
  `sotIntroduct` varchar(180) default '-' COMMENT '简单介绍',
  `sotSourceR00` varchar(180) default '-' COMMENT '图片',
  PRIMARY KEY  (`sotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysoption` */

/*Table structure for table `gsnavigation_netssysoptiongroup` */

DROP TABLE IF EXISTS `gsnavigation_netssysoptiongroup`;

CREATE TABLE `gsnavigation_netssysoptiongroup` (
  `sogtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sogtName` varchar(180) default '-' COMMENT '名称',
  `sogtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `sogtModuleid` int(11) default '0' COMMENT '所属模块ID',
  `sogtParid` int(11) default '0' COMMENT '上级或分类ID',
  `sogtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `sogtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `sogtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `sogtIntroduct` varchar(180) default '0' COMMENT '介绍',
  PRIMARY KEY  (`sogtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysoptiongroup` */

/*Table structure for table `gsnavigation_netssyssheme` */

DROP TABLE IF EXISTS `gsnavigation_netssyssheme`;

CREATE TABLE `gsnavigation_netssyssheme` (
  `sstID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sstName` varchar(180) default '-' COMMENT '名称',
  `sstNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `sstParid` int(11) default '0' COMMENT '上级/分类ID',
  `sstRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `sstChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `sstOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `sstCreateBy` int(11) default '0' COMMENT '发布人',
  `sstCreateTime` datetime default NULL COMMENT '发布时间',
  `sstPath` varchar(180) default '..' COMMENT '主题路径',
  PRIMARY KEY  (`sstID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyssheme` */

insert  into `gsnavigation_netssyssheme`(`sstID`,`sstName`,`sstNumCode`,`sstParid`,`sstRecycle`,`sstChecked`,`sstOrderBy`,`sstCreateBy`,`sstCreateTime`,`sstPath`) values (1,'网集默认主题','N_2010012022044814382',0,0,2,0,1,'2010-01-21 04:09:16','#');

/*Table structure for table `gsnavigation_netssysshemecont` */

DROP TABLE IF EXISTS `gsnavigation_netssysshemecont`;

CREATE TABLE `gsnavigation_netssysshemecont` (
  `ssctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ssctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ssctHtmlDescription` text COMMENT '静态生成描述表',
  `ssctIntrodcut` text COMMENT '介绍',
  `ssctSourceR00` varchar(180) default NULL COMMENT '截图',
  `ssctSources` text COMMENT '图集',
  PRIMARY KEY  (`ssctID`),
  KEY `ssctIndexID` (`ssctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysshemecont` */

insert  into `gsnavigation_netssysshemecont`(`ssctID`,`ssctIndexID`,`ssctHtmlDescription`,`ssctIntrodcut`,`ssctSourceR00`,`ssctSources`) values (1,1,'//首页\r\nPlus/m_default/Cms/solutionHome0.php<!---RTB.SPLIT1--->Html/doclist/docs/solutionHome0.htm\r\nPlus/m_default/Gsnavigation/gsnavigationHome.php<!---RTB.SPLIT1--->default.htm\r\n\r\n//说明文件\r\nPlus/m_default/Cms/introduct0.php?ID={Nets_0.1-12}<!---RTB.SPLIT1--->Html/doc/n1_300/introduct_{Nets_0}.htm\r\n\r\n//文档列表\r\nPlus/m_default/Cms/docList0.php?ID={Nets_0.1-30}&page={Nets_1.1,2,3,4,5,},12,32,12<!---RTB.SPLIT1--->Html/doclist/n1_300/docList0_{Nets_0}_{Nets_1}.htm','网集默认主题','','');

/*Table structure for table `gsnavigation_netssysshemeuser` */

DROP TABLE IF EXISTS `gsnavigation_netssysshemeuser`;

CREATE TABLE `gsnavigation_netssysshemeuser` (
  `ssutID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ssutName` varchar(180) default '-' COMMENT '名称',
  `ssutNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ssutParid` int(11) default '0' COMMENT '上级或分类ID',
  `ssutRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `ssutChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `ssutType` varchar(180) default 'Unit/default/' COMMENT '主题类型：0.博客,1.企业网站',
  `ssutOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `ssutCreateBy` int(11) default '0' COMMENT '发布人',
  `ssutCreateTime` datetime default NULL COMMENT '发布时间',
  `ssutPath` varchar(180) default '..' COMMENT '主题路径',
  PRIMARY KEY  (`ssutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysshemeuser` */

/*Table structure for table `gsnavigation_netssysshemeusercont` */

DROP TABLE IF EXISTS `gsnavigation_netssysshemeusercont`;

CREATE TABLE `gsnavigation_netssysshemeusercont` (
  `stemctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `stemctIndexID` int(11) default '0' COMMENT '主表ID号',
  `stemctHtmlDescription` text COMMENT '静态生成描述表',
  `stemctIntroduct` text COMMENT '介绍',
  `stemctSourceR00` varchar(180) default NULL COMMENT '截图',
  `stemctSources` text COMMENT '图集',
  PRIMARY KEY  (`stemctID`),
  KEY `stemctIndexID` (`stemctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssysshemeusercont` */

/*Table structure for table `gsnavigation_netssystable` */

DROP TABLE IF EXISTS `gsnavigation_netssystable`;

CREATE TABLE `gsnavigation_netssystable` (
  `sttID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sttName` varchar(180) default '-' COMMENT '名称',
  `sttNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `sttFunctionid` int(11) default '0' COMMENT '所属功能ID',
  `sttType` int(2) default '0' COMMENT '表类型:1.主表,2.附表,3.用户定义扩展表',
  `sttRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `sttChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `sttOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `sttCreateBy` int(11) default '0' COMMENT '发布人',
  `sttCreateTime` datetime default NULL COMMENT '发布时间',
  `sttTableName` varchar(180) default '-' COMMENT '数据库中的表名',
  `sttColumnHead` varchar(180) default '-' COMMENT '项名头',
  PRIMARY KEY  (`sttID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssystable` */

/*Table structure for table `gsnavigation_netssystablecolumn` */

DROP TABLE IF EXISTS `gsnavigation_netssystablecolumn`;

CREATE TABLE `gsnavigation_netssystablecolumn` (
  `stcotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `stcotName` varchar(180) default '-' COMMENT '名称',
  `stcotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `stcotParid` int(11) default '0' COMMENT '上级或分类ID',
  `stcotRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `stcotType` int(2) default '1' COMMENT '项类型：1.记录，指：在本表和数据库里分别创建此记录和字段；2.虚记录，指：在本表里创建此记录，但不在数据库里创建本字段，创建时4、5类型功能与此也相同；3；4.标签；5.定标签[指的是不可切换的标签]；',
  `stcotChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `stcotOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  PRIMARY KEY  (`stcotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssystablecolumn` */

/*Table structure for table `gsnavigation_netssystablecolumncont` */

DROP TABLE IF EXISTS `gsnavigation_netssystablecolumncont`;

CREATE TABLE `gsnavigation_netssystablecolumncont` (
  `stcoctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `stcoctIndexID` int(11) default '0' COMMENT '主表ID号',
  `stcoctUiName` varchar(180) default '-' COMMENT 'UI名称',
  `stcoctUiType` varchar(42) default 'Text' COMMENT 'UI类型',
  `stcoctUiLen` int(9) default '180' COMMENT 'UI长度',
  `stcoctUiEnable` int(2) default '0' COMMENT 'UI是否可以修改',
  `stcoctUiRecognise` varchar(42) default 'Normal' COMMENT 'UI分类标识',
  `stcoctUiOptionAR` int(11) default '0' COMMENT 'UI绑定值',
  `stcoctUiLabelid` int(11) default '0' COMMENT 'UI，LABEL的ID',
  `stcoctSingleLine` int(2) default '0' COMMENT '是否单独成一行',
  `stcoctColspan` int(5) default '1' COMMENT '一列等于多列值',
  `stcoctUiIntroduct` varchar(180) default '&nbsp;' COMMENT 'UI里的介绍',
  `stcoctUiImgIntroduct` varchar(180) default '&nbsp;' COMMENT '问号的图片说明',
  `stcoctDefaultValue` varchar(180) default '0' COMMENT '默认值',
  `stcoctDbType` varchar(42) default 'Text' COMMENT '数据类型',
  `stcoctDbLen` int(9) default '180' COMMENT '数据长度',
  `stcoctDbIsKey` int(2) default '0' COMMENT '是否为主键',
  `stcoctModifyAble` int(2) default '0' COMMENT '是否可以修改和删除',
  `stcoctRemark` varchar(180) default '-' COMMENT '管理备注',
  PRIMARY KEY  (`stcoctID`),
  KEY `stcoctIndexID` (`stcoctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssystablecolumncont` */

/*Table structure for table `gsnavigation_netssystablecont` */

DROP TABLE IF EXISTS `gsnavigation_netssystablecont`;

CREATE TABLE `gsnavigation_netssystablecont` (
  `stctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `stctIndexID` int(11) default '0' COMMENT '主表ID号',
  `stctUiName` text COMMENT '界面配置名或路径',
  `stctIntroduct` text COMMENT '介绍',
  `stctContent` text COMMENT '内容',
  `stctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`stctID`),
  KEY `stctIndexID` (`stctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssystablecont` */

/*Table structure for table `gsnavigation_netssystemplate` */

DROP TABLE IF EXISTS `gsnavigation_netssystemplate`;

CREATE TABLE `gsnavigation_netssystemplate` (
  `stemtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `stemtName` varchar(180) default '-' COMMENT '名称',
  `stemtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `stemtSign` varchar(180) default '-' COMMENT '模板标签',
  `stemtShemeid` int(11) default '0' COMMENT '所属主题',
  `stemtFunctionid` int(11) default '0' COMMENT '功能ID',
  `stemtType` int(2) default '0' COMMENT '模板类型',
  `stemtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `stemtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `stemtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `stemtCreateBy` int(11) default '0' COMMENT '发布人',
  `stemtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`stemtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssystemplate` */

insert  into `gsnavigation_netssystemplate`(`stemtID`,`stemtName`,`stemtNumCode`,`stemtSign`,`stemtShemeid`,`stemtFunctionid`,`stemtType`,`stemtRecycle`,`stemtChecked`,`stemtOrderBy`,`stemtCreateBy`,`stemtCreateTime`) values (1,'一般文档模板','N_2010022707420335406','',0,2,0,0,2,100,1,'2010-09-15 22:25:36');
insert  into `gsnavigation_netssystemplate`(`stemtID`,`stemtName`,`stemtNumCode`,`stemtSign`,`stemtShemeid`,`stemtFunctionid`,`stemtType`,`stemtRecycle`,`stemtChecked`,`stemtOrderBy`,`stemtCreateBy`,`stemtCreateTime`) values (2,'文字文档列表模板','N_2010030519144618954','',0,3,0,0,2,100,1,'2010-09-15 22:25:24');
insert  into `gsnavigation_netssystemplate`(`stemtID`,`stemtName`,`stemtNumCode`,`stemtSign`,`stemtShemeid`,`stemtFunctionid`,`stemtType`,`stemtRecycle`,`stemtChecked`,`stemtOrderBy`,`stemtCreateBy`,`stemtCreateTime`) values (3,'图片文档列表模板','N_2010030519150430261','',0,3,0,0,2,100,1,'2010-09-15 22:25:00');
insert  into `gsnavigation_netssystemplate`(`stemtID`,`stemtName`,`stemtNumCode`,`stemtSign`,`stemtShemeid`,`stemtFunctionid`,`stemtType`,`stemtRecycle`,`stemtChecked`,`stemtOrderBy`,`stemtCreateBy`,`stemtCreateTime`) values (4,'说明文档','N_2010091522400970199','',0,3,0,0,2,100,1,'2010-11-15 21:28:55');

/*Table structure for table `gsnavigation_netssystemplatecont` */

DROP TABLE IF EXISTS `gsnavigation_netssystemplatecont`;

CREATE TABLE `gsnavigation_netssystemplatecont` (
  `stemctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `stemctIndexID` int(11) default '0' COMMENT '主表ID号',
  `stemctPath` text COMMENT '模板路径',
  `stemctIntroduct` text COMMENT '介绍',
  `stemctContent` text COMMENT '内容',
  `stemctRemark` text COMMENT '备注',
  PRIMARY KEY  (`stemctID`),
  KEY `stemctIndexID` (`stemctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssystemplatecont` */

insert  into `gsnavigation_netssystemplatecont`(`stemctID`,`stemctIndexID`,`stemctPath`,`stemctIntroduct`,`stemctContent`,`stemctRemark`) values (1,1,'Cms/docDetail_Normal.php','','','');
insert  into `gsnavigation_netssystemplatecont`(`stemctID`,`stemctIndexID`,`stemctPath`,`stemctIntroduct`,`stemctContent`,`stemctRemark`) values (2,2,'Cms/docDetail_Normal.php','','','');
insert  into `gsnavigation_netssystemplatecont`(`stemctID`,`stemctIndexID`,`stemctPath`,`stemctIntroduct`,`stemctContent`,`stemctRemark`) values (3,3,'Cms/docDetail_Img.php','','','');
insert  into `gsnavigation_netssystemplatecont`(`stemctID`,`stemctIndexID`,`stemctPath`,`stemctIntroduct`,`stemctContent`,`stemctRemark`) values (4,4,'Cms/docDetail_Introduct.php','','','');

/*Table structure for table `gsnavigation_netssyszone` */

DROP TABLE IF EXISTS `gsnavigation_netssyszone`;

CREATE TABLE `gsnavigation_netssyszone` (
  `sztID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `sztName` varchar(180) default '-' COMMENT '名称',
  `sztNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `sztNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `sztParid` int(11) default '0' COMMENT '上级或分类ID',
  `sztType` int(2) default '0' COMMENT '地区类型：1.国家，2.省，3.城市，4.区，5.街，等',
  `sztRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `sztChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `sztOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `sztSign` varchar(42) default '-' COMMENT '地区编码',
  `sztAlphabet` varchar(12) default '-' COMMENT '首字母',
  PRIMARY KEY  (`sztID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyszone` */

/*Table structure for table `gsnavigation_netssyszonecont` */

DROP TABLE IF EXISTS `gsnavigation_netssyszonecont`;

CREATE TABLE `gsnavigation_netssyszonecont` (
  `szctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `szctIndexID` int(11) default '0' COMMENT '主表ID号',
  `szctMapX` varchar(42) default '0' COMMENT '地图X',
  `szctMapY` varchar(42) default '0' COMMENT '地图Y',
  `szctTagIntroduct` varchar(180) default '-' COMMENT '地图标签上的介绍',
  `szctSendPrice` decimal(9,2) default '0.00' COMMENT '配送加价',
  `szctCount_Views` int(11) default '0' COMMENT '查看数',
  `szctCount_Child` int(11) default '0' COMMENT '子地区个数',
  `szctCode_Main` int(11) default '8' COMMENT '总评分',
  `szctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `szctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `szctPower_View` text COMMENT '用户查看权限',
  `szctSpicalPosition` text COMMENT '特殊位置',
  `szctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `szctSmallContent` varchar(180) default '-' COMMENT '简介',
  `szctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `szctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `szctMetaDescription` text COMMENT 'MetaDescription',
  `szctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `szctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `szctSources` text COMMENT '图集',
  `szctIntroduct` text COMMENT '详细介绍',
  `szctContent` text COMMENT '内容',
  `szctRemark` text COMMENT '备注',
  PRIMARY KEY  (`szctID`),
  KEY `szctIndexID` (`szctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netssyszonecont` */

/*Table structure for table `gsnavigation_netsuserdaily` */

DROP TABLE IF EXISTS `gsnavigation_netsuserdaily`;

CREATE TABLE `gsnavigation_netsuserdaily` (
  `udtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udtName` varchar(180) default '-' COMMENT '名称',
  `udtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `udtType` int(11) default '0' COMMENT '操作类型:0.登陆,1.登出,2.找回密码,3.注销,4.验证邮箱',
  `udtState` int(2) default '0' COMMENT '找回密码状态:0.已发送,1.已过期,2.已完成',
  `udtCreateBy` int(11) default '0' COMMENT '发布人',
  `udtCreateTime` datetime default NULL COMMENT '发布时间',
  `udtIntroduct` varchar(250) default NULL COMMENT '简单说明',
  `udtValue_STR` varchar(180) default '-' COMMENT '值',
  `udtValue_INT` int(11) default '0' COMMENT '值',
  `udtValue_DECIMAL` decimal(9,2) default '0.00' COMMENT '值',
  PRIMARY KEY  (`udtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserdaily` */

/*Table structure for table `gsnavigation_netsuserdailycont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserdailycont`;

CREATE TABLE `gsnavigation_netsuserdailycont` (
  `udctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udctIndexID` int(11) default '0' COMMENT '主表ID号',
  `udctIpAddress` varchar(180) default '127.0.0.1' COMMENT '操作IP地址',
  `udctIntroduct` text COMMENT '介绍',
  PRIMARY KEY  (`udctID`),
  KEY `umdctIndexID` (`udctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserdailycont` */

/*Table structure for table `gsnavigation_netsuserdepartment` */

DROP TABLE IF EXISTS `gsnavigation_netsuserdepartment`;

CREATE TABLE `gsnavigation_netsuserdepartment` (
  `udeptID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udeptName` varchar(180) default '-' COMMENT '名称',
  `udeptNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `udeptNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `udeptUnitid` int(11) default '0' COMMENT '部门所在单位',
  `udeptParid` int(11) default '0' COMMENT '上级部门ID',
  `udeptRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `udeptChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `udeptOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `udeptCreateBy` int(11) default '0' COMMENT '发布人',
  `udeptCreateTime` datetime default NULL COMMENT '发布时间',
  `udeptPassTime` datetime default NULL COMMENT '部门过期时间',
  `udeptTag` varchar(180) default '-' COMMENT '部门标签',
  `udeptParentid` int(11) default '0',
  PRIMARY KEY  (`udeptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserdepartment` */

/*Table structure for table `gsnavigation_netsuserdepartmentconfig` */

DROP TABLE IF EXISTS `gsnavigation_netsuserdepartmentconfig`;

CREATE TABLE `gsnavigation_netsuserdepartmentconfig` (
  `udepcotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udepcotName` varchar(180) default '-' COMMENT '名称',
  `udepcotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `udepcotSign` varchar(180) default '-' COMMENT '标志',
  `udepcotOrderBy` int(9) default '0' COMMENT '排序',
  `udepcotValue` varchar(180) default '-' COMMENT '值',
  `udepcotCreateBy` int(11) default '0' COMMENT '发布人',
  PRIMARY KEY  (`udepcotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserdepartmentconfig` */

/*Table structure for table `gsnavigation_netsuserdepartmentcont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserdepartmentcont`;

CREATE TABLE `gsnavigation_netsuserdepartmentcont` (
  `udepctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udepctIndexID` int(11) default '0' COMMENT '主表ID号',
  `udepctComName` varchar(180) default '-' COMMENT '部门名称',
  `udepctComIdCode` varchar(180) default '-' COMMENT '部门营业证号',
  `udepctComIdCodeSource` varchar(180) default '' COMMENT '部门营业证截图',
  `udepctComIdCodeChecked` int(2) default '0' COMMENT '营业执照认证',
  `udepctComType` varchar(180) default '-' COMMENT '部门类型',
  `udepctComContact` varchar(180) default '-' COMMENT '部门联系人',
  `udepctComContactTele` varchar(180) default '-' COMMENT '部门联系电话',
  `udepctComContactTeleChecked` int(2) default '0' COMMENT '联系电话认证',
  `udepctComZoneChoose` varchar(180) default '-' COMMENT '所在国家',
  `udepctComZoneDetail` varchar(180) default '-' COMMENT '所在省份',
  `udepctComContactAddress` varchar(180) default '-' COMMENT '部门联系地址',
  `udepctComNumCode` varchar(42) default '-' COMMENT '部门联系邮编',
  `udepctComContactWebsite` varchar(180) default '-' COMMENT '部门主页',
  `udepctComContactEmail` varchar(180) default '-' COMMENT '部门电邮',
  `udepctComContactFax` varchar(180) default '-' COMMENT '部门传真',
  `udepctComPersonCount` varchar(42) default '-' COMMENT '员工人数',
  `udepctComYearMoney` varchar(42) default '-' COMMENT '年营业额',
  `udepctComCustomTypes` varchar(180) default '-' COMMENT '主要客户群',
  `udepctComRegisterFund` varchar(180) default '-' COMMENT '注册资金',
  `udepctComManageSystem` varchar(180) default '-' COMMENT '管理体系认证',
  `udepctComBrand` varchar(180) default '-' COMMENT '品牌名称',
  `udepctComRegisterPeople` varchar(180) default '-' COMMENT '法人代表',
  `udepctComCreateTime` varchar(180) default '-' COMMENT '部门成立时间',
  `udepctComProduct` varchar(180) default '-' COMMENT '部门主要产品',
  `udepctComBusinessModel` varchar(180) default '-' COMMENT '经营模式',
  `udepctComLogo` varchar(180) default '-' COMMENT '部门LOGO',
  `udepctComContactIntroduct` text COMMENT '部门说明',
  `udepctWhAble` int(2) default '0' COMMENT '是否开通网店功能',
  `udepctWhName` varchar(180) default '-' COMMENT '网店名称',
  `udepctWhSmallIntroduct` varchar(180) default '-' COMMENT '网店简介',
  `udepctWhSourceR00` varchar(180) default '-' COMMENT '网店图片',
  `udepctWhSourceR01` varchar(180) default '-' COMMENT '网店大图',
  `udepctWhIntroduct` text COMMENT '网店详细介绍',
  `udepctPayAlipay` varchar(180) default '' COMMENT '支付宝帐号',
  `udepctPayChinabank` varchar(180) default '' COMMENT '网银在线帐号',
  `udepctPayTenpay` varchar(180) default '' COMMENT '财务通帐号',
  `udepctPay99Bill` varchar(180) default '' COMMENT '快钱帐号',
  `udepctPayPayChecked` int(2) default '0' COMMENT '支付方式认证',
  `udepctPayBankCode` varchar(180) default '' COMMENT '银行帐号',
  `udepctPayBankName` varchar(180) default '' COMMENT '开户行',
  `udepctPayBankUName` varchar(180) default '' COMMENT '开户人名',
  `udepctPayBankAddress` varchar(180) default '' COMMENT '开户行所在地',
  `udepctPayBankCountry` varchar(180) default '' COMMENT '开户行所在国家',
  `udepctPayBankCountryCode` varchar(180) default '' COMMENT '开户行所在国家编号',
  `udepctPayBankChecked` int(2) default '0' COMMENT '银行认证',
  `udepctEmailSmtpIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Smtp邮件服务器地址',
  `udepctEmailSmtpName` varchar(180) default 'vir@unionNets.com' COMMENT 'Smtp邮件服务器登陆用户名',
  `udepctEmailSmtpPxd` varchar(180) default '123456' COMMENT 'Smtp邮件服务器登陆密码',
  `udepctEmailPop3Able` int(2) default '0' COMMENT '是否开通Pop3功能',
  `udepctEmailPop3Ip` varchar(180) default 'mail.unionNets.com' COMMENT 'Pop3邮件服务器地址',
  `udepctEmailPop3Name` varchar(180) default 'vir@unionNets.com' COMMENT 'Pop3邮件服务器登陆用户名',
  `udepctEmailPop3Pxd` varchar(180) default '123456' COMMENT 'Pop3邮件服务器登陆密码',
  `udepctEmailImapAble` int(2) default '0' COMMENT '是否开通Imap功能',
  `udepctEmailImapIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Imap邮件服务器地址',
  `udepctEmailImapName` varchar(180) default 'vir@unionNets.com' COMMENT 'Imap邮件服务器登陆用户名',
  `udepctEmailImapPxd` varchar(180) default '123456' COMMENT 'Imap邮件服务器登陆密码',
  `udepctEmailChecked` int(2) default '0' COMMENT '电子邮件认证',
  `udepctMapX` varchar(42) default '-' COMMENT '地图X',
  `udepctMapY` varchar(42) default '-' COMMENT '地图Y',
  `udepctMapTagIntroduct` varchar(180) default '-' COMMENT '地图标签上的介绍',
  `udepctCount_Views` int(11) default '0' COMMENT '查看数',
  `udepctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `udepctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `udepctCode_Main` int(11) default '8' COMMENT '总评分',
  `udepctCount_Reply` int(11) default '0' COMMENT '回复数',
  `udepctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `udepctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `udepctChannelid` text COMMENT '所属频道',
  `udepctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `udepctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `udepctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `udepctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `udepctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `udepctPageAble` int(2) default '0' COMMENT '是否分页',
  `udepctPower_View` text COMMENT '用户查看权限',
  `udepctSpicalPosition` text COMMENT '特殊位置',
  `udepctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `udepctSmallContent` varchar(180) default '-' COMMENT '简介',
  `udepctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `udepctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `udepctMetaDescription` text COMMENT 'MetaDescription',
  `udepctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `udepctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `udepctSources` text COMMENT '图集',
  `udepctIntroduct` text COMMENT '详细介绍',
  `udepctContent` text COMMENT '内容',
  `udepctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `udepctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `udepctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `udepctRemark` text COMMENT '备注',
  PRIMARY KEY  (`udepctID`),
  KEY `udepctIndexID` (`udepctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserdepartmentcont` */

/*Table structure for table `gsnavigation_netsusergrade` */

DROP TABLE IF EXISTS `gsnavigation_netsusergrade`;

CREATE TABLE `gsnavigation_netsusergrade` (
  `ugratID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ugratName` varchar(180) default '-' COMMENT '名称',
  `ugratNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `ugratNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ugratParid` int(11) default '0' COMMENT '上级或分类ID',
  `ugratType` int(5) default '0' COMMENT '类型',
  `ugratRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `ugratChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `ugratOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `ugratCreateBy` int(11) default '0' COMMENT '发布人',
  `ugratCreateTime` datetime default NULL COMMENT '发布时间',
  `ugratTag` varchar(180) default '-' COMMENT '标签',
  `ugratCodeLimit_High` decimal(9,2) default '0.00' COMMENT '上限',
  `ugratCodeLimit_Low` decimal(9,2) default '0.00' COMMENT '下限',
  PRIMARY KEY  (`ugratID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsusergrade` */

insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (1,'ROOT','-','-',0,0,0,2,0,0,'1900-01-01 00:00:00','-','0.00','0.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (2,'网集用户等级','-','-',1,0,0,2,0,0,'1900-01-01 00:00:00','-','0.00','0.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (3,'一般用户','-','-',2,0,0,2,0,0,'1900-01-01 00:00:00','-','0.00','0.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (4,'初级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','100.00','0.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (5,'二级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','500.00','100.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (6,'三级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','1000.00','500.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (7,'中级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','3000.00','1000.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (8,'五级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','5000.00','3000.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (9,'六级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','10000.00','5000.00');
insert  into `gsnavigation_netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (10,'高级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','30000.00','10000.00');

/*Table structure for table `gsnavigation_netsusergradecont` */

DROP TABLE IF EXISTS `gsnavigation_netsusergradecont`;

CREATE TABLE `gsnavigation_netsusergradecont` (
  `ugractID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ugractIndexID` int(11) default '0' COMMENT '主表ID号',
  `ugractShopCodeAdd` decimal(9,2) default '0.00' COMMENT '商城加积分比例',
  `ugractShopCodeSub` decimal(9,2) default '0.00' COMMENT '商城减积分比例',
  `ugractShopMoneyAdd` decimal(9,2) default '0.00' COMMENT '商城加价格比例',
  `ugractShopMoneySub` decimal(9,2) default '0.00' COMMENT '商城减价格比例',
  `ugractCommCodeAdd` decimal(9,2) default '0.00' COMMENT '社区加积分比例',
  `ugractCommCodeSub` decimal(9,2) default '0.00' COMMENT '社区减积分比例',
  `ugractCommMoneyAdd` decimal(9,2) default '0.00' COMMENT '社区加价格比例',
  `ugractCommMoneySub` decimal(9,2) default '0.00' COMMENT '社区减价格比例',
  `ugractSortCodeAdd` decimal(9,2) default '0.00' COMMENT '分类信息加积分比例',
  `ugractSortCodeSub` decimal(9,2) default '0.00' COMMENT '分类信息减积分比例',
  `ugractSortMoneyAdd` decimal(9,2) default '0.00' COMMENT '分类信息加价格比例',
  `ugractSortMoneySub` decimal(9,2) default '0.00' COMMENT '分类信息减价格比例',
  `ugractJobCodeAdd` decimal(9,2) default '0.00' COMMENT '招聘加积分比例',
  `ugractJobCodeSub` decimal(9,2) default '0.00' COMMENT '招聘减积分比例',
  `ugractJobMoneyAdd` decimal(9,2) default '0.00' COMMENT '招聘加价格比例',
  `ugractJobMoneySub` decimal(9,2) default '0.00' COMMENT '招聘减价格比例',
  `ugractStoryCodeAdd` decimal(9,2) default '0.00' COMMENT '小说加积分比例',
  `ugractStoryCodeSub` decimal(9,2) default '0.00' COMMENT '小说减积分比例',
  `ugractStoryMoneyAdd` decimal(9,2) default '0.00' COMMENT '小说加价格比例',
  `ugractStoryMoneySub` decimal(9,2) default '0.00' COMMENT '小说减价格比例',
  `ugractCount_Views` int(11) default '0' COMMENT '查看数',
  `ugractCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `ugractCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `ugractCode_Main` int(11) default '8' COMMENT '总评分',
  `ugractCode_Positive` int(11) default '0' COMMENT '正面打分',
  `ugractCode_Negative` int(11) default '0' COMMENT '负面打分',
  `ugractChannelid` text COMMENT '所属频道',
  `ugractPower_View` int(11) default '0' COMMENT '用户查看权限',
  `ugractPower_Public` int(11) default '0' COMMENT '用户发布权限',
  `ugractSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `ugractSmallContent` varchar(180) default '-' COMMENT '简介',
  `ugractMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `ugractMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `ugractMetaDescription` text COMMENT 'MetaDescription',
  `ugractSourceR00` varchar(180) default '-' COMMENT '小图片',
  `ugractSourceR01` varchar(180) default '-' COMMENT '大图片',
  `ugractSources` text COMMENT '图集',
  `ugractIntroduct` text COMMENT '详细介绍',
  `ugractContent` text COMMENT '内容',
  `ugractPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `ugractPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `ugractPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `ugractRemark` text COMMENT '备注',
  PRIMARY KEY  (`ugractID`),
  KEY `ugractIndexID` (`ugractIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsusergradecont` */

insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (1,1,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (2,2,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (3,3,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (4,4,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (5,5,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (6,6,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (7,7,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (8,8,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (9,9,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `gsnavigation_netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (10,10,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);

/*Table structure for table `gsnavigation_netsusergroup` */

DROP TABLE IF EXISTS `gsnavigation_netsusergroup`;

CREATE TABLE `gsnavigation_netsusergroup` (
  `ugtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ugtName` varchar(180) default '-' COMMENT '名称',
  `ugtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `ugtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ugtParid` int(11) default '0' COMMENT '上级/分组ID',
  `ugtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `ugtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `ugtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `ugtCreateBy` int(11) default '0' COMMENT '发布人',
  `ugtCreateTime` datetime default NULL COMMENT '发布时间',
  `ugtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`ugtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsusergroup` */

/*Table structure for table `gsnavigation_netsusergroupcont` */

DROP TABLE IF EXISTS `gsnavigation_netsusergroupcont`;

CREATE TABLE `gsnavigation_netsusergroupcont` (
  `ugctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ugctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ugctSysService` text COMMENT '系统服务内容，格式：',
  `ugctPublicCount` text COMMENT '发布数量，格式：',
  `ugctCount_Views` int(11) default '0' COMMENT '查看数',
  `ugctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `ugctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `ugctCode_Main` int(11) default '8' COMMENT '总评分',
  `ugctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `ugctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `ugctChannelid` text COMMENT '所属频道',
  `ugctModelid_List` int(11) default '0' COMMENT '列表模型',
  `ugctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `ugctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `ugctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `ugctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `ugctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `ugctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `ugctSmallContent` varchar(180) default '-' COMMENT '简介',
  `ugctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `ugctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `ugctMetaDescription` text COMMENT 'MetaDescription',
  `ugctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `ugctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `ugctSources` text COMMENT '图集',
  `ugctIntroduct` text COMMENT '详细介绍',
  `ugctContent` text COMMENT '内容',
  `ugctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `ugctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `ugctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `ugctRemark` text COMMENT '备注',
  PRIMARY KEY  (`ugctID`),
  KEY `ugctIndexID` (`ugctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsusergroupcont` */

/*Table structure for table `gsnavigation_netsuserinfo` */

DROP TABLE IF EXISTS `gsnavigation_netsuserinfo`;

CREATE TABLE `gsnavigation_netsuserinfo` (
  `uitID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uitName` varchar(180) default '-' COMMENT '名称',
  `uitNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `uitNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uitUnitid` int(11) default '0' COMMENT '单位/公司ID',
  `uitDepartmentid` int(11) default '0' COMMENT '用户所在部门ID',
  `uitPositionid` int(11) default '0' COMMENT '职位类型',
  `uitTypeid` int(11) default '0' COMMENT '用户类型ID',
  `uitGradeid` int(11) default '0' COMMENT '用户等级',
  `uitGroupid` int(11) default '0' COMMENT '用户分组',
  `uitRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uitChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uitState` int(5) default '0' COMMENT '用户状态：0一般用户,1临时用户',
  `uitOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uitCreateBy` int(11) default '0' COMMENT '发布人',
  `uitCreateTime` datetime default NULL COMMENT '发布时间',
  `uitPassTime` datetime default NULL COMMENT '到期时间',
  `uitEmail` varchar(180) default '-' COMMENT '电邮',
  `uitPxd` varchar(180) default NULL COMMENT '密码',
  `uitMoney` decimal(9,2) default '0.00' COMMENT '资金数额',
  `uitCode` decimal(9,2) default '0.00' COMMENT '积分',
  `uitExperience` decimal(18,2) default '0.00' COMMENT '经验值',
  `uitTag` varchar(180) default '-' COMMENT '用户的标签',
  `uitNickname` varchar(180) default '-' COMMENT '昵称',
  `uitOnlineState` int(2) default '0' COMMENT '用户在线状态：0不在线,1在线,2离开,3忙碌,4静音,5隐身',
  `uitLoginNumcode` varchar(24) default '0' COMMENT '登陆时加密码：如果用户登陆则为7位随机数',
  `uitInterfaceNumcode` varchar(24) default '0' COMMENT '接口加密码：当次调用接口的加密码，必须与当前用户数据库里的加密码不一致',
  `uitMobile` varchar(180) default '-' COMMENT '手机号码',
  `uitParentid` int(11) default '0' COMMENT '上级用户',
  `uitRecommendid` int(11) default '0' COMMENT '推荐用户ID',
  `uitLoginAPI_Type` int(5) default '0' COMMENT '外部接口类型：0未设置1新浪2腾讯',
  `uitLoginAPI_ID` varchar(180) default '-' COMMENT '外部接口用户名',
  PRIMARY KEY  (`uitID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserinfo` */

insert  into `gsnavigation_netsuserinfo`(`uitID`,`uitName`,`uitNameStyle`,`uitNumCode`,`uitUnitid`,`uitDepartmentid`,`uitPositionid`,`uitTypeid`,`uitGradeid`,`uitGroupid`,`uitRecycle`,`uitChecked`,`uitState`,`uitOrderBy`,`uitCreateBy`,`uitCreateTime`,`uitPassTime`,`uitEmail`,`uitPxd`,`uitMoney`,`uitCode`,`uitExperience`,`uitTag`,`uitNickname`,`uitOnlineState`,`uitLoginNumcode`,`uitInterfaceNumcode`,`uitMobile`,`uitParentid`,`uitRecommendid`,`uitLoginAPI_Type`,`uitLoginAPI_ID`) values (1,'core@unionnets.com','-','User_2010041616344060350',1,0,0,2,7,0,0,2,0,0,0,'2010-10-02 03:33:32','2900-01-01 00:00:00','vir@unionnets.com','e10adc3949ba59abbe56e057f20f883e','0.00','1185.00','0.00','-','core@unionnets.com',1,'1292087404','1280525510','15800000000',0,0,0,'-');

/*Table structure for table `gsnavigation_netsuserinfoconfig` */

DROP TABLE IF EXISTS `gsnavigation_netsuserinfoconfig`;

CREATE TABLE `gsnavigation_netsuserinfoconfig` (
  `uicotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uicotIndexID` int(11) default '0' COMMENT '主表ID号',
  `uicotAppPower_WebsiteName` varchar(180) default '-' COMMENT '应用权限-应该站点名称',
  `uicotAppPower_WebsiteEndtime` varchar(180) default '-' COMMENT '应用权限-应该站点到期时间',
  PRIMARY KEY  (`uicotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserinfoconfig` */

/*Table structure for table `gsnavigation_netsuserinfocont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserinfocont`;

CREATE TABLE `gsnavigation_netsuserinfocont` (
  `uictID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uictIndexID` int(11) default '0' COMMENT '主表ID号',
  `uictCircles` text COMMENT '用户加入的圈子',
  `uictPxd_Question` varchar(180) default '-' COMMENT '密码提示问题',
  `uictPxd_Answer` varchar(180) default '-' COMMENT '密码提示答案',
  `uictCo_Name` varchar(180) default '-' COMMENT '联系人',
  `uictCo_Sex` int(2) default '0' COMMENT '联系人性别',
  `uictCo_Tele` varchar(180) default '-' COMMENT '联系电话',
  `uictCo_Mobile` varchar(180) default '-' COMMENT '联系手机',
  `uictCo_Fax` varchar(180) default '-' COMMENT '传真',
  `uictCo_Software` varchar(180) default '-' COMMENT '网络通信工具',
  `uictCo_Website` varchar(180) default '-' COMMENT '主页',
  `uictCo_NumCode` varchar(42) default '-' COMMENT '联系邮编',
  `uictCo_ZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `uictCo_ZoneDetail` varchar(180) default '-' COMMENT '填写形式地区信息',
  `uictCo_Address` varchar(180) default '-' COMMENT '联系地址',
  `uictCo_Company` varchar(180) default '-' COMMENT '所在公司名',
  `uictCo_PersPosition` varchar(180) default '-' COMMENT '职位',
  `uictCo_PersSpical` varchar(180) default '-' COMMENT '专长',
  `uictInfo_Hometown` varchar(180) default '-' COMMENT '家乡',
  `uictInfo_Birthday` varchar(180) default '-' COMMENT '生日',
  `uictInfo_Age` int(5) default '0' COMMENT '年龄',
  `uictInfo_BloodType` int(2) default '0' COMMENT '血型',
  `uictInfo_Constellation` int(2) default '0' COMMENT '星座',
  `uictInfo_Marriage` int(2) default '0' COMMENT '婚恋',
  `uictInfo_School` text COMMENT '学校',
  `uictInfo_Hobby` text COMMENT '兴趣爱好',
  `uictInfo_LikeMusic` text COMMENT '喜欢的音乐',
  `uictInfo_LikeMovie` text COMMENT '喜欢的电影',
  `uictInfo_LikeGame` text COMMENT '喜欢的游戏',
  `uictInfo_LikeCartoon` text COMMENT '喜欢的动漫',
  `uictInfo_LikeSport` text COMMENT '喜欢的运动',
  `uictInfo_LikeBook` text COMMENT '喜欢的书籍',
  `uictPostcode` varchar(180) default '-' COMMENT '身份证号',
  `uictPostcodeSource` varchar(180) default '-' COMMENT '身份证截图',
  `uictCoSignature` text COMMENT '个人签名',
  `uictCoIntroduct` text COMMENT '个人说明',
  `uictWhAble` int(2) default '0' COMMENT '是否开通网店功能',
  `uictWhName` varchar(180) default '-' COMMENT '网店名称',
  `uictWhSmallIntroduct` varchar(180) default '-' COMMENT '网店简介',
  `uictWhSourceR00` varchar(180) default '-' COMMENT '图片1',
  `uictWhSourceR01` varchar(180) default '-' COMMENT '图片2',
  `uictWhSources` text COMMENT '网店图集',
  `uictWhIntroduct` text COMMENT '网店介绍',
  `uictTemplatepath_Unit` varchar(180) default 'Place_Unit/default/' COMMENT '企业用户模板路径',
  `uictTemplatepath_Shop` varchar(180) default 'Place_Shop/default/' COMMENT '店铺模板路径',
  `uictTemplatepath_Blog` varchar(180) default 'Place_Blog/default/' COMMENT '个人博客模板路径',
  `uictPayPayChecked` int(2) default '0' COMMENT '支付方式认证',
  `uictPayBankCode` varchar(180) default '' COMMENT '银行帐号',
  `uictPayBankName` varchar(180) default '' COMMENT '开户行',
  `uictPayBankUName` varchar(180) default '' COMMENT '开户人名',
  `uictPayBankAddress` varchar(180) default '' COMMENT '开户行所在地',
  `uictPayBankCountry` varchar(180) default '' COMMENT '开户行所在国家',
  `uictPayBankCountryCode` varchar(180) default '' COMMENT '开户行所在国家编号',
  `uictPayBankCheckedNum` decimal(9,2) default '0.00' COMMENT '银行认证打款金款',
  `uictPayBankCheckedTime` datetime default NULL COMMENT '银行认证款，打款时间',
  `uictEmailSmtpIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Smtp邮件服务器地址',
  `uictEmailSmtpPort` varchar(42) default '25' COMMENT 'Smtp邮件服务器端口号',
  `uictEmailSmtpName` varchar(180) default 'vir@unionNets.com' COMMENT 'Smtp邮件服务器登陆用户名',
  `uictEmailSmtpPxd` varchar(180) default '123456' COMMENT 'Smtp邮件服务器登陆密码',
  `uictEmailPop3Able` int(2) default '0' COMMENT '是否开通Pop3功能',
  `uictEmailPop3Ip` varchar(180) default 'mail.unionNets.com' COMMENT 'Pop3邮件服务器地址',
  `uictEmailPop3Port` varchar(42) default '110' COMMENT 'Pop3邮件服务器端口号',
  `uictEmailPop3Name` varchar(180) default 'vir@unionNets.com' COMMENT 'Pop3邮件服务器登陆用户名',
  `uictEmailPop3Pxd` varchar(180) default '123456' COMMENT 'Pop3邮件服务器登陆密码',
  `uictEmailImapAble` int(2) default '0' COMMENT '是否开通Imap功能',
  `uictEmailImapIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Imap邮件服务器地址',
  `uictEmailImapName` varchar(180) default 'vir@unionNets.com' COMMENT 'Imap邮件服务器登陆用户名',
  `uictEmailImapPxd` varchar(180) default '123456' COMMENT 'Imap邮件服务器登陆密码',
  `uictMapX` varchar(42) default '-' COMMENT '地图X',
  `uictMapY` varchar(42) default '-' COMMENT '地图Y',
  `uictMapTagIntroduct` varchar(42) default '-' COMMENT '地图标签上的介绍',
  `uictInterface_Pxd` varchar(180) default '-' COMMENT '接口用户加密码',
  `uictCount_Views` int(11) default '0' COMMENT '查看数',
  `uictCount_Reply` int(11) default '0' COMMENT '回复数',
  `uictCode_Main` int(11) default '8' COMMENT '总评分',
  `uictCode_Positive` int(11) default '0' COMMENT '正面打分',
  `uictCode_Negative` int(11) default '0' COMMENT '负面打分',
  `uictChannelid` text COMMENT '所属频道',
  `uictModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `uictTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `uictDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `uictKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `uictKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `uictPower_View` text COMMENT '用户查看权限',
  `uictPower_ColumnsView` text COMMENT '用户信息设置选项',
  `uictSpicalPosition` text COMMENT '特殊位置',
  `uictSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `uictSmallContent` varchar(180) default '-' COMMENT '简介',
  `uictMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `uictMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `uictMetaDescription` text COMMENT 'MetaDescription',
  `uictSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uictSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uictSources` text COMMENT '图集',
  `uictIntroduct` text COMMENT '详细介绍',
  `uictContent` text COMMENT '内容',
  `uictPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `uictPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `uictPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `uictRemark` text COMMENT '备注',
  `uictInfo_Zodiac` int(2) default '0' COMMENT '过期后的链接地址',
  `uictTemplatepath_Microblogging` varchar(180) default 'Place_Microblogging/default/' COMMENT '个人微博模板路径',
  `uictChecked_Mobile` int(2) default '0' COMMENT '手机认证',
  `uictChecked_Postcode` int(2) default '0' COMMENT '身份证认证',
  `uictChecked_Bank` int(2) default '0' COMMENT '银行认证',
  `uictChecked_Email` int(2) default '0' COMMENT '电子邮件认证',
  `uictChecked_Pay` int(2) default '0' COMMENT '支付方式认证',
  `uictPayAlipay` varchar(180) default '' COMMENT '支付宝帐号',
  `uictPayChinabank` varchar(180) default '' COMMENT '网银在线帐号',
  `uictPayTenpay` varchar(180) default '' COMMENT '财务通帐号',
  `uictPay99Bill` varchar(180) default '' COMMENT '快钱帐号',
  `uictPayYeepay` varchar(180) default '' COMMENT '易宝帐号',
  `uictPayPaypal` varchar(180) default '' COMMENT 'PayPal贝宝帐号',
  `uictPayType` int(9) default '0' COMMENT '支付方式类型',
  `uictPayCode` varchar(180) default NULL COMMENT '支付帐号',
  `uictInfo_Credit` int(11) default '0' COMMENT '信用等级',
  `uuctInfo_Credit` int(11) default '0' COMMENT '信用等级',
  PRIMARY KEY  (`uictID`),
  KEY `uictIndexID` (`uictIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserinfocont` */

insert  into `gsnavigation_netsuserinfocont`(`uictID`,`uictIndexID`,`uictCircles`,`uictPxd_Question`,`uictPxd_Answer`,`uictCo_Name`,`uictCo_Sex`,`uictCo_Tele`,`uictCo_Mobile`,`uictCo_Fax`,`uictCo_Software`,`uictCo_Website`,`uictCo_NumCode`,`uictCo_ZoneChoose`,`uictCo_ZoneDetail`,`uictCo_Address`,`uictCo_Company`,`uictCo_PersPosition`,`uictCo_PersSpical`,`uictInfo_Hometown`,`uictInfo_Birthday`,`uictInfo_Age`,`uictInfo_BloodType`,`uictInfo_Constellation`,`uictInfo_Marriage`,`uictInfo_School`,`uictInfo_Hobby`,`uictInfo_LikeMusic`,`uictInfo_LikeMovie`,`uictInfo_LikeGame`,`uictInfo_LikeCartoon`,`uictInfo_LikeSport`,`uictInfo_LikeBook`,`uictPostcode`,`uictPostcodeSource`,`uictCoSignature`,`uictCoIntroduct`,`uictWhAble`,`uictWhName`,`uictWhSmallIntroduct`,`uictWhSourceR00`,`uictWhSourceR01`,`uictWhSources`,`uictWhIntroduct`,`uictTemplatepath_Unit`,`uictTemplatepath_Shop`,`uictTemplatepath_Blog`,`uictPayPayChecked`,`uictPayBankCode`,`uictPayBankName`,`uictPayBankUName`,`uictPayBankAddress`,`uictPayBankCountry`,`uictPayBankCountryCode`,`uictPayBankCheckedNum`,`uictPayBankCheckedTime`,`uictEmailSmtpIp`,`uictEmailSmtpPort`,`uictEmailSmtpName`,`uictEmailSmtpPxd`,`uictEmailPop3Able`,`uictEmailPop3Ip`,`uictEmailPop3Port`,`uictEmailPop3Name`,`uictEmailPop3Pxd`,`uictEmailImapAble`,`uictEmailImapIp`,`uictEmailImapName`,`uictEmailImapPxd`,`uictMapX`,`uictMapY`,`uictMapTagIntroduct`,`uictInterface_Pxd`,`uictCount_Views`,`uictCount_Reply`,`uictCode_Main`,`uictCode_Positive`,`uictCode_Negative`,`uictChannelid`,`uictModelid_Detail`,`uictTemplateid_Detail`,`uictDiscussAble`,`uictKeywordAble`,`uictKeywordContent`,`uictPower_View`,`uictPower_ColumnsView`,`uictSpicalPosition`,`uictSmallTitle`,`uictSmallContent`,`uictMetaTitle`,`uictMetaKeyword`,`uictMetaDescription`,`uictSourceR00`,`uictSourceR01`,`uictSources`,`uictIntroduct`,`uictContent`,`uictPublisher_Name`,`uictPublisher_Email`,`uictPublisher_Source`,`uictRemark`,`uictInfo_Zodiac`,`uictTemplatepath_Microblogging`,`uictChecked_Mobile`,`uictChecked_Postcode`,`uictChecked_Bank`,`uictChecked_Email`,`uictChecked_Pay`,`uictPayAlipay`,`uictPayChinabank`,`uictPayTenpay`,`uictPay99Bill`,`uictPayYeepay`,`uictPayPaypal`,`uictPayType`,`uictPayCode`,`uictInfo_Credit`,`uuctInfo_Credit`) values (1,1,'-','-','-','-',0,'-','158000000000','-','-','-','-','-','-','-','-','-','-','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-',0,'-','-','-','-','-','-','Place_Unit/default/','Place_Shop/default/','Place_Blog/microblogging_default/',0,'1111111111111111111111','111111111111111111111','111111111111111111111','1111111111111111111112','','','0.00','2011-01-01 16:03:33','mail.unionNets.com','25','vir@unionNets.com','123456',0,'mail.unionNets.com','110','vir@unionNets.com','123456',0,'mail.unionNets.com','vir@unionNets.com','123456','-','-','-','-',0,0,8,0,0,'-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,'Place_Microblogging/default/',1,1,1,2,1,'','','','','','',0,NULL,0,0);

/*Table structure for table `gsnavigation_netsuserinfohabits` */

DROP TABLE IF EXISTS `gsnavigation_netsuserinfohabits`;

CREATE TABLE `gsnavigation_netsuserinfohabits` (
  `uihtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uihtName` varchar(180) default '-' COMMENT '名称',
  `uihtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `uihtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uihtParid` int(11) default '0' COMMENT '上级或分类ID',
  `uihtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uihtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uihtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uihtCreateBy` int(11) default '0' COMMENT '发布人',
  `uihtCreateTime` datetime default NULL COMMENT '发布时间',
  `uihtFlag` varchar(180) default '-' COMMENT '标志名称，如：Order_Userreceiveaddress',
  `uihtValue` text COMMENT '习惯值',
  `uihtType` int(5) default '0' COMMENT '类型',
  PRIMARY KEY  (`uihtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserinfohabits` */

/*Table structure for table `gsnavigation_netsuserinfohabitscont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserinfohabitscont`;

CREATE TABLE `gsnavigation_netsuserinfohabitscont` (
  `uihctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uihctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uihctCount_Views` int(11) default '0' COMMENT '查看数',
  `uihctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `uihctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `uihctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `uihctChannelid` text COMMENT '所属频道',
  `uihctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `uihctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `uihctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `uihctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `uihctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `uihctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `uihctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `uihctPageAble` int(2) default '0' COMMENT '是否分页',
  `uihctPower_View` text COMMENT '用户查看权限',
  `uihctPower_Public` text COMMENT '用户发布权限',
  `uihctSpicalPosition` text COMMENT '特殊位置',
  `uihctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `uihctSmallContent` varchar(180) default '-' COMMENT '简介',
  `uihctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `uihctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `uihctMetaDescription` text COMMENT 'MetaDescription',
  `uihctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uihctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uihctSources` text COMMENT '图集',
  `uihctIntroduct` text COMMENT '详细介绍',
  `uihctContent` text COMMENT '内容',
  `uihctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `uihctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `uihctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `uihctRemark` text COMMENT '备注',
  PRIMARY KEY  (`uihctID`),
  KEY `uihctIndexID` (`uihctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserinfohabitscont` */

/*Table structure for table `gsnavigation_netsuseroperatingdaily` */

DROP TABLE IF EXISTS `gsnavigation_netsuseroperatingdaily`;

CREATE TABLE `gsnavigation_netsuseroperatingdaily` (
  `uodtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uodtName` varchar(180) default '-' COMMENT '名称',
  `uodtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uodtType` int(2) default '0' COMMENT '操作类型',
  `uodtState` int(2) default '0' COMMENT '操作状态',
  `uodtCreateBy` int(11) default '0' COMMENT '发布人',
  `uodtCreateTime` datetime default NULL COMMENT '发布时间',
  `uodtIntroduct` varchar(250) default '-' COMMENT '简单说明',
  `uodtValue` varchar(180) default NULL COMMENT '值',
  PRIMARY KEY  (`uodtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuseroperatingdaily` */

/*Table structure for table `gsnavigation_netsuseroperatingdailycont` */

DROP TABLE IF EXISTS `gsnavigation_netsuseroperatingdailycont`;

CREATE TABLE `gsnavigation_netsuseroperatingdailycont` (
  `uoodctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uodctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uodctIpAddress` varchar(180) default '127.0.0.1' COMMENT '操作IP地址',
  `uodctIntroduct` text COMMENT '介绍',
  PRIMARY KEY  (`uoodctID`),
  KEY `uodctIndexID` (`uodctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuseroperatingdailycont` */

/*Table structure for table `gsnavigation_netsuseroperation` */

DROP TABLE IF EXISTS `gsnavigation_netsuseroperation`;

CREATE TABLE `gsnavigation_netsuseroperation` (
  `uotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uotName` varchar(180) default '-' COMMENT '名称',
  `uotNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `uotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uotParid` int(11) default '0' COMMENT '上级或分类ID',
  `uotRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uotChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uotOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uotCreateBy` int(11) default '0' COMMENT '发布人',
  `uotCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`uotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuseroperation` */

insert  into `gsnavigation_netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (1,'登陆','-','N_2010101400043349139',3,0,2,0,1,'2010-10-14 00:04:33');
insert  into `gsnavigation_netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (2,'注册','-','N_201010140004339494',3,0,2,0,1,'2010-10-14 00:04:33');
insert  into `gsnavigation_netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (3,'找加密码','-','N_2010101400043349084',3,0,2,0,1,'2010-10-14 00:04:33');
insert  into `gsnavigation_netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (4,'完善用户资料','-','N_201010140004336631',3,0,2,0,1,'2010-10-14 00:04:33');
insert  into `gsnavigation_netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (5,'发布文档','-','N_2010101400043377691',4,0,2,0,1,'2010-10-14 00:04:33');
insert  into `gsnavigation_netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (6,'评论文档','-','N_2010101400043352938',4,0,2,0,1,'2010-10-14 00:04:33');

/*Table structure for table `gsnavigation_netsuseroperationcont` */

DROP TABLE IF EXISTS `gsnavigation_netsuseroperationcont`;

CREATE TABLE `gsnavigation_netsuseroperationcont` (
  `uoctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uoctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uoctType` int(5) default '0' COMMENT '类型',
  `uoctSign` varchar(180) default '-' COMMENT '标志',
  `uoctTypeNum` varchar(42) default '10000' COMMENT '类型号：5位以上',
  `uoctTimeLong` int(11) default '0' COMMENT '周期长度',
  `uoctRepeate` int(9) default '0' COMMENT '可重复次数',
  `uoctCode_Code` decimal(9,2) default '0.00' COMMENT '分数',
  `uoctCode_Max` decimal(9,2) default '0.00' COMMENT '分数上限',
  `uoctCode_Min` decimal(9,2) default '0.00' COMMENT '分数下限',
  `uoctCode_Rare` decimal(9,2) default '0.00' COMMENT '分类递增或递减，最大100，最小0',
  `uoctPower_View` text COMMENT '用户查看权限',
  `uoctSpicalPosition` text COMMENT '特殊位置',
  `uoctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uoctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uoctIntroduct` text COMMENT '介绍',
  `uoctContent` text COMMENT '内容',
  `uoctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`uoctID`),
  KEY `uoctIndexID` (`uoctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuseroperationcont` */

insert  into `gsnavigation_netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (1,1,0,'Nets_User_Login','-',0,0,'5.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `gsnavigation_netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (2,2,0,'Nets_User_Register','-',0,0,'30.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `gsnavigation_netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (3,3,0,'Nets_User_FindPxd','-',0,0,'2.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `gsnavigation_netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (4,4,0,'Nets_User_Info_Complete','-',0,0,'50.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `gsnavigation_netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (5,5,0,'Cms_Doc_Public','-',0,0,'10.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `gsnavigation_netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (6,6,0,'Cms_DocDiscuss_Public','-',0,0,'2.00','0.00','0.00','0.00','-','-','-','-','-','-','-');

/*Table structure for table `gsnavigation_netsuseroperationgroup` */

DROP TABLE IF EXISTS `gsnavigation_netsuseroperationgroup`;

CREATE TABLE `gsnavigation_netsuseroperationgroup` (
  `uogtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uogtName` varchar(180) default '-' COMMENT '名称',
  `uogtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `uogtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uogtParid` int(11) default '0' COMMENT '上级或分类ID',
  `uogtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uogtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uogtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uogtCreateBy` int(11) default '0' COMMENT '发布人',
  `uogtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`uogtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuseroperationgroup` */

insert  into `gsnavigation_netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (1,'ROOT','-','N_2010101323560279507',0,0,2,0,1,'2010-10-13 23:56:02');
insert  into `gsnavigation_netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (2,'网集积分操作','-','N_201010132356028673',1,0,2,0,1,'2010-10-13 23:56:14');
insert  into `gsnavigation_netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (3,'用户操作','-','N_2010101323560267416',2,0,2,0,1,'2010-10-13 23:56:02');
insert  into `gsnavigation_netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (4,'文档','-','N_2010101323560256372',2,0,2,0,1,'2010-10-13 23:56:02');
insert  into `gsnavigation_netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (5,'社区','-','N_2010101323560219729',2,0,2,0,1,'2010-10-13 23:57:54');
insert  into `gsnavigation_netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (6,'商城','0','N_2010101323584949642',2,0,0,0,0,'2010-10-13 23:59:03');

/*Table structure for table `gsnavigation_netsuseroperationgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_netsuseroperationgroupcont`;

CREATE TABLE `gsnavigation_netsuseroperationgroupcont` (
  `uogctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uogctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uogctPower_View` text COMMENT '用户查看权限',
  `uogctSpicalPosition` text COMMENT '特殊位置',
  `uogctIntroduct` text COMMENT '介绍',
  `uogctContent` text COMMENT '内容',
  `uogctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`uogctID`),
  KEY `uogctIndexID` (`uogctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuseroperationgroupcont` */

insert  into `gsnavigation_netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (1,1,'-','-','-','-','-');
insert  into `gsnavigation_netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (2,2,'0','0','-','-','-');
insert  into `gsnavigation_netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (3,3,'-','-','-','-','-');
insert  into `gsnavigation_netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (4,4,'-','-','-','-','-');
insert  into `gsnavigation_netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (5,5,'0','0','-','-','-');
insert  into `gsnavigation_netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (6,6,'0','0','0','0','0');

/*Table structure for table `gsnavigation_netsuseroperationrecord` */

DROP TABLE IF EXISTS `gsnavigation_netsuseroperationrecord`;

CREATE TABLE `gsnavigation_netsuseroperationrecord` (
  `uortID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uortName` varchar(180) default '-' COMMENT '名称',
  `uortNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uortParid` int(11) default '0' COMMENT '操作ID',
  `uortType` int(11) default '0' COMMENT '操作类型:0.登陆,1.登出,2.找回密码,3.注销',
  `uortState` int(2) default '0' COMMENT '找回密码状态:0.已发送，未找回,1.已过期,2.已找回',
  `uortCreateBy` int(11) default '0' COMMENT '发布人',
  `uortCreateTime` datetime default NULL COMMENT '发布时间',
  `uortIntroduct` varchar(250) default NULL COMMENT '简单说明',
  `uortValue_STR` varchar(180) default '-' COMMENT '值',
  `uortValue_INT` int(11) default '0' COMMENT '值',
  `uortValue_DECIMAL` decimal(9,2) default '0.00' COMMENT '值',
  PRIMARY KEY  (`uortID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuseroperationrecord` */

/*Table structure for table `gsnavigation_netsuseroperationrecordcont` */

DROP TABLE IF EXISTS `gsnavigation_netsuseroperationrecordcont`;

CREATE TABLE `gsnavigation_netsuseroperationrecordcont` (
  `uorctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uorctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uorctIpAddress` varchar(180) default '127.0.0.1' COMMENT '操作IP地址',
  `uorctIntroduct` text COMMENT '介绍',
  PRIMARY KEY  (`uorctID`),
  KEY `uorctIndexID` (`uorctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuseroperationrecordcont` */

/*Table structure for table `gsnavigation_netsuserservice` */

DROP TABLE IF EXISTS `gsnavigation_netsuserservice`;

CREATE TABLE `gsnavigation_netsuserservice` (
  `ustID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ustName` varchar(180) default '-' COMMENT '名称',
  `ustNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ustServiceid` int(11) default '0' COMMENT '服务名ID',
  `ustUserid` int(11) default '0' COMMENT '服务所属人ID',
  `ustCreateBy` int(11) default '0' COMMENT '发布人',
  `ustCreateTime` datetime default NULL COMMENT '发布时间',
  `ustPassTime` int(9) default '0' COMMENT '有效天数',
  PRIMARY KEY  (`ustID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserservice` */

/*Table structure for table `gsnavigation_netsuserservicecont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserservicecont`;

CREATE TABLE `gsnavigation_netsuserservicecont` (
  `usctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `usctIndexID` int(11) default '0' COMMENT '主表ID号',
  `SourceR00` varchar(180) default '-' COMMENT '小图片',
  `Introduct` text COMMENT '详细介绍',
  `Content` text COMMENT '内容',
  `Remark` text COMMENT '备注',
  PRIMARY KEY  (`usctID`),
  KEY `usctIndexID` (`usctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserservicecont` */

/*Table structure for table `gsnavigation_netsuserteam` */

DROP TABLE IF EXISTS `gsnavigation_netsuserteam`;

CREATE TABLE `gsnavigation_netsuserteam` (
  `utetID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utetName` varchar(180) default '-' COMMENT '名称',
  `utetNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `utetNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `utetParid` int(11) default '0' COMMENT '上级或分类ID',
  `utetRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `utetChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `utetOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `utetCreateBy` int(11) default '0' COMMENT '发布人',
  `utetCreateTime` datetime default NULL COMMENT '发布时间',
  `utetTag` varchar(180) default '-' COMMENT '标签',
  `utetUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  `utetUserPublicGroupid` int(11) default '0' COMMENT '用户分类：0.管理员发布的,1.用户发布的，发布到个人博客,2.用户发布的，发布到企业网站,3.用户发布的，发布到企业网站和个人博客',
  PRIMARY KEY  (`utetID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserteam` */

/*Table structure for table `gsnavigation_netsuserteamcont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserteamcont`;

CREATE TABLE `gsnavigation_netsuserteamcont` (
  `utectID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utectIndexID` int(11) default '0' COMMENT '主表ID号',
  `utectCount_Views` int(11) default '0' COMMENT '查看数',
  `utectCount_Discuss` int(11) default '0' COMMENT '回复数',
  `utectCode_Positive` int(11) default '0' COMMENT '正面打分',
  `utectCode_Negative` int(11) default '0' COMMENT '负面打分',
  `utectChannelid` text COMMENT '所属频道',
  `utectRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `utectRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `utectModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `utectTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `utectDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `utectKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `utectKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `utectPageAble` int(2) default '0' COMMENT '是否分页',
  `utectPower_View` text COMMENT '用户查看权限',
  `utectPower_Public` text COMMENT '用户发布权限',
  `utectSpicalPosition` text COMMENT '特殊位置',
  `utectSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `utectSmallContent` varchar(180) default '-' COMMENT '简介',
  `utectMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `utectMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `utectMetaDescription` text COMMENT 'MetaDescription',
  `utectSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utectSourceR01` varchar(180) default '-' COMMENT '大图片',
  `utectSources` text COMMENT '图集',
  `utectIntroduct` text COMMENT '详细介绍',
  `utectContent` text COMMENT '内容',
  `utectPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `utectPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `utectPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `utectRemark` text COMMENT '备注',
  PRIMARY KEY  (`utectID`),
  KEY `utectIndexID` (`utectIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserteamcont` */

/*Table structure for table `gsnavigation_netsuserteamdiscuss` */

DROP TABLE IF EXISTS `gsnavigation_netsuserteamdiscuss`;

CREATE TABLE `gsnavigation_netsuserteamdiscuss` (
  `utedtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utedtName` varchar(180) default '-' COMMENT '名称',
  `utedtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `utedtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `utedtParid` int(11) default '0' COMMENT '上级或分类ID',
  `utedtType` int(5) default '0' COMMENT '类型',
  `utedtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `utedtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `utedtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `utedtCreateBy` int(11) default '0' COMMENT '发布人',
  `utedtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`utedtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserteamdiscuss` */

/*Table structure for table `gsnavigation_netsuserteamdiscusscont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserteamdiscusscont`;

CREATE TABLE `gsnavigation_netsuserteamdiscusscont` (
  `utedctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utedctIndexID` int(11) default '0' COMMENT '主表ID号',
  `utedctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `utedctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `utedctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `utedctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `utedctPower_View` text COMMENT '用户查看权限',
  `utedctSpicalPosition` text COMMENT '特殊位置',
  `utedctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utedctContent` text COMMENT '内容',
  `utedctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `utedctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `utedctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `utedctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `utedctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `utedctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `utedctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `utedctRemark` text COMMENT '备注',
  PRIMARY KEY  (`utedctID`),
  KEY `utedctIndexID` (`utedctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserteamdiscusscont` */

/*Table structure for table `gsnavigation_netsuserteamgroup` */

DROP TABLE IF EXISTS `gsnavigation_netsuserteamgroup`;

CREATE TABLE `gsnavigation_netsuserteamgroup` (
  `utegtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utegtName` varchar(180) default '-' COMMENT '名称',
  `utegtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `utegtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `utegtParid` int(11) default '0' COMMENT '上级或分类ID',
  `utegtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `utegtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `utegtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `utegtCreateBy` int(11) default '0' COMMENT '发布人',
  `utegtCreateTime` datetime default NULL COMMENT '发布时间',
  `utegtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`utegtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserteamgroup` */

/*Table structure for table `gsnavigation_netsuserteamgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserteamgroupcont`;

CREATE TABLE `gsnavigation_netsuserteamgroupcont` (
  `utegctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utegctIndexID` int(11) default '0' COMMENT '主表ID号',
  `utegctCount_Views` int(11) default '0' COMMENT '查看数',
  `utegctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `utegctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `utegctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `utegctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `utegctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `utegctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `utegctChannelid` text COMMENT '所属频道',
  `utegctModelid_List` int(11) default '0' COMMENT '列表模型',
  `utegctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `utegctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `utegctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `utegctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `utegctPower_View` text COMMENT '用户查看权限',
  `utegctPower_Public` text COMMENT '用户发布权限',
  `utegctSpicalPosition` text COMMENT '特殊位置',
  `utegctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `utegctSmallContent` varchar(180) default '-' COMMENT '简介',
  `utegctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `utegctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `utegctMetaDescription` text COMMENT 'MetaDescription',
  `utegctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utegctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `utegctSources` text COMMENT '图集',
  `utegctIntroduct` text COMMENT '详细介绍',
  `utegctContent` text COMMENT '内容',
  `utegctRemark` text COMMENT '备注',
  PRIMARY KEY  (`utegctID`),
  KEY `utegctIndexID` (`utegctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserteamgroupcont` */

/*Table structure for table `gsnavigation_netsuserteamposition` */

DROP TABLE IF EXISTS `gsnavigation_netsuserteamposition`;

CREATE TABLE `gsnavigation_netsuserteamposition` (
  `uteptID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uteptName` varchar(180) default '-' COMMENT '名称',
  `uteptNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `uteptNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uteptParid` int(11) default '0' COMMENT '上级或分类ID',
  `uteptRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uteptChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uteptOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uteptCreateBy` int(11) default '0' COMMENT '发布人',
  `uteptCreateTime` datetime default NULL COMMENT '发布时间',
  `uteptUserids` varchar(180) default '' COMMENT '用户ID',
  PRIMARY KEY  (`uteptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserteamposition` */

/*Table structure for table `gsnavigation_netsuserteampositioncont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserteampositioncont`;

CREATE TABLE `gsnavigation_netsuserteampositioncont` (
  `utepctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utepctIndexID` int(11) default '0' COMMENT '主表ID号',
  `utepctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `utepctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `utepctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `utepctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `utepctPower_View` text COMMENT '用户查看权限',
  `utepctSpicalPosition` text COMMENT '特殊位置',
  `utepctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utepctContent` text COMMENT '内容',
  `utepctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `utepctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `utepctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `utepctRemark` text COMMENT '备注',
  PRIMARY KEY  (`utepctID`),
  KEY `utepctIndexID` (`utepctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserteampositioncont` */

/*Table structure for table `gsnavigation_netsusertype` */

DROP TABLE IF EXISTS `gsnavigation_netsusertype`;

CREATE TABLE `gsnavigation_netsusertype` (
  `uttID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uttName` varchar(180) default '-' COMMENT '名称',
  `uttNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `uttNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uttParid` int(11) default '0' COMMENT '上级或分类ID',
  `uttRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uttChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uttOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uttCreateBy` int(11) default '0' COMMENT '发布人',
  `uttCreateTime` datetime default NULL COMMENT '发布时间',
  `uttType` int(5) default '0' COMMENT '类型:1.格管理员,2.系统管理员,3.管理员,4.用户,5.游客',
  `uttSign` varchar(180) default NULL COMMENT '标志',
  PRIMARY KEY  (`uttID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsusertype` */

insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (1,'ROOT','-','-',0,0,2,0,0,'2010-04-26 21:08:35',0,'-');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (2,'格管理员','-','-',1,0,2,0,0,'2011-01-27 11:58:47',1,'-');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (3,'系统管理员','-','-',1,0,2,0,0,'2010-04-26 21:10:12',2,'-');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (4,'管理员','-','-',1,0,2,0,0,'2011-04-16 19:03:49',3,'-');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (5,'会员','-','-',1,0,2,0,0,'2010-10-01 12:31:53',4,'-');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (6,'游客','-','-',1,0,2,0,0,'2010-04-26 21:10:12',5,'-');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (7,'项目管理用户','','N_2010082104190893353',5,0,2,0,1,'2010-12-02 11:41:56',4,'');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (8,'理财用户','','N_2010082104194791305',5,0,2,0,1,'2010-12-02 11:42:12',4,'');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (9,'项目经理','','N_2010120211424059646',7,0,2,0,1,'2010-12-02 11:44:12',4,'');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (10,'项目员工','','N_2010120211442762591',7,0,2,0,1,'2010-12-02 11:44:27',4,'');
insert  into `gsnavigation_netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (11,'项目客户','','N_2010120211443514242',7,0,2,0,1,'2010-12-02 11:44:35',4,'');

/*Table structure for table `gsnavigation_netsusertypecont` */

DROP TABLE IF EXISTS `gsnavigation_netsusertypecont`;

CREATE TABLE `gsnavigation_netsusertypecont` (
  `utctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utctIndexID` int(11) default '0' COMMENT '主表ID号',
  `utctCount_Views` int(11) default '0' COMMENT '查看数',
  `utctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `utctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `utctZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `utctPower_Menu` text COMMENT '用户菜单权限',
  `utctPower_View` text COMMENT '用户查看权限',
  `utctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `utctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `utctMetaDescription` text COMMENT 'MetaDescription',
  `utctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `utctSources` text COMMENT '图集',
  `utctIntroduct` text COMMENT '详细介绍',
  `utctContent` text COMMENT '内容',
  `utctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `utctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `utctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `utctRemark` text COMMENT '备注',
  `utctPower_Menu_Mana` text COMMENT '核心管理系统权限',
  `utctPower_Menu_Platform` text COMMENT '管理用户系统权限',
  `utctPower_Menu_QPlatform` text COMMENT '快捷管理用户系统权限',
  `utctPower_Menu_User` text COMMENT '用户菜单权限',
  PRIMARY KEY  (`utctID`),
  KEY `uuctIndexID` (`utctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsusertypecont` */

insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (1,1,0,0,0,'0','0','0','-','-','','-','-','','','','-','-','-','',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (2,2,0,0,0,'0','','0','-','-','-','-','-','-','-','-','-','-','-','-','','0','0','0');
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (3,3,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (4,4,0,0,0,'0','-','0','-','-','-','-','-','-','-','-','-','-','-','-','26,projbug,projbug_view,projbug_add,projbug_modify,projbug_delete,;26,projproject,projproject_view,projproject_add,projproject_modify,projproject_delete,;6,cmsdoc,cmsdoc_add,cmsdoc_modify,cmsdoc_delete,;','','','');
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (5,5,0,0,0,'0','','0','-','-','-','-','-','-','-','-','-','-','-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (6,6,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (7,7,0,0,0,'0','0','0','','','','','','','','','-','-','-','',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (8,8,0,0,0,'0','','0','','','','','','','','','-','-','-','',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (9,9,0,0,0,'0','0','0','','','','','','','','','0','0','0','',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (10,10,0,0,0,'0','0','0','','','','','','','','','0','0','0','',NULL,NULL,NULL,NULL);
insert  into `gsnavigation_netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (11,11,0,0,0,'0','0','0','','','','','','','','','0','0','0','',NULL,NULL,NULL,NULL);

/*Table structure for table `gsnavigation_netsuserunit` */

DROP TABLE IF EXISTS `gsnavigation_netsuserunit`;

CREATE TABLE `gsnavigation_netsuserunit` (
  `uutID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uutName` varchar(180) default '-' COMMENT '名称',
  `uutNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `uutNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uutParid` int(11) default '0' COMMENT '上级公司ID',
  `uutParentid` int(11) default '0' COMMENT '单位分组',
  `uutRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uutChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uutOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uutCreateBy` int(11) default '0' COMMENT '发布人',
  `uutCreateTime` datetime default NULL COMMENT '发布时间',
  `uutPassTime` datetime default NULL COMMENT '单位过期时间',
  `uutTag` varchar(180) default '-' COMMENT '单位/公司标签',
  PRIMARY KEY  (`uutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserunit` */

insert  into `gsnavigation_netsuserunit`(`uutID`,`uutName`,`uutNameStyle`,`uutNumCode`,`uutParid`,`uutParentid`,`uutRecycle`,`uutChecked`,`uutOrderBy`,`uutCreateBy`,`uutCreateTime`,`uutPassTime`,`uutTag`) values (1,'网集平台(unionnets.com)','-','Unit_934823954',0,0,0,2,0,0,'2010-01-01 00:00:00','2100-01-01 00:00:00','-');

/*Table structure for table `gsnavigation_netsuserunitconfig` */

DROP TABLE IF EXISTS `gsnavigation_netsuserunitconfig`;

CREATE TABLE `gsnavigation_netsuserunitconfig` (
  `uucotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uucotName` varchar(180) default '-' COMMENT '名称',
  `uucotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uucotSign` varchar(180) default '-' COMMENT '标志',
  `uucotOrderBy` int(9) default '0' COMMENT '排序',
  `uucotValue` varchar(180) default '-' COMMENT '值',
  `uucotCreateBy` int(11) default '0' COMMENT '发布人',
  PRIMARY KEY  (`uucotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserunitconfig` */

/*Table structure for table `gsnavigation_netsuserunitcont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserunitcont`;

CREATE TABLE `gsnavigation_netsuserunitcont` (
  `uuctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uuctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uuctComName` varchar(180) default '-' COMMENT '企业名称',
  `uuctComIdCode` varchar(180) default '-' COMMENT '企业营业证号',
  `uuctComIdCodeSource` varchar(180) default '-' COMMENT '企业营业证截图',
  `uuctComIdCodeChecked` int(2) default '0' COMMENT '营业执照认证',
  `uuctComType` varchar(180) default '-' COMMENT '企业类型',
  `uuctComContact` varchar(180) default '-' COMMENT '企业联系人',
  `uuctComContactTele` varchar(180) default '-' COMMENT '企业联系电话',
  `uuctComContactTeleChecked` int(2) default '0' COMMENT '联系方式认证',
  `uuctComContactQQ` varchar(180) default '-' COMMENT '联系人QQ号',
  `uuctComZoneChoose` varchar(180) default '-' COMMENT '选择形式地址',
  `uuctComZoneDetail` varchar(180) default '-' COMMENT '填写形式地址',
  `uuctComContactAddress` varchar(180) default '-' COMMENT '企业联系地址',
  `uuctComNumCode` varchar(42) default '-' COMMENT '企业联系邮编',
  `uuctComContactWebsite` varchar(180) default '-' COMMENT '企业主页',
  `uuctComContactEmail` varchar(180) default '-' COMMENT '企业电邮',
  `uuctComContactFax` varchar(180) default '-' COMMENT '企业传真',
  `uuctComPersonCount` varchar(42) default '-' COMMENT '员工人数',
  `uuctComYearMoney` varchar(42) default '-' COMMENT '年营业额',
  `uuctComCustomTypes` varchar(180) default '-' COMMENT '主要客户群',
  `uuctComRegisterFund` varchar(180) default '-' COMMENT '注册资金',
  `uuctComManageSystem` varchar(180) default '-' COMMENT '管理体系认证',
  `uuctComBrand` varchar(180) default '-' COMMENT '品牌名称',
  `uuctComRegisterPeople` varchar(180) default '-' COMMENT '法人代表',
  `uuctComCreateTime` varchar(180) default '-' COMMENT '公司成立时间',
  `uuctComProduct` varchar(180) default '-' COMMENT '公司主要产品',
  `uuctComBusinessModel` varchar(180) default '-' COMMENT '经营模式',
  `uuctComLogo` varchar(180) default '-' COMMENT '公司LOGO',
  `uuctComContactIntroduct` text COMMENT '企业说明',
  `uuctWhAble` int(2) default '0' COMMENT '是否开通网店功能',
  `uuctWhName` varchar(180) default '-' COMMENT '网店名称',
  `uuctWhSmallIntroduct` varchar(180) default '-' COMMENT '网店简介',
  `uuctWhSourceR00` varchar(180) default '-' COMMENT '网店图片',
  `uuctWhSourceR01` varchar(180) default '-' COMMENT '网店大图',
  `uuctWhSources` text COMMENT '网店图集',
  `uuctWhIntroduct` text COMMENT '网店详细介绍',
  `uuctWhTemplatepath` varchar(180) default 'Unit/default/' COMMENT '企业网站模板路径',
  `uuctPayAlipay` varchar(180) default '' COMMENT '支付宝帐号',
  `uuctPayChinabank` varchar(180) default '' COMMENT '网银在线帐号',
  `uuctPayTenpay` varchar(180) default '' COMMENT '财务通帐号',
  `uuctPay99Bill` varchar(180) default '' COMMENT '快钱帐号',
  `uuctPayPayChecked` int(2) default '0' COMMENT '支付方式认证',
  `uuctPayBankCode` varchar(180) default '' COMMENT '银行帐号',
  `uuctPayBankName` varchar(180) default '' COMMENT '开户行',
  `uuctPayBankUName` varchar(180) default '' COMMENT '开户人名',
  `uuctPayBankAddress` varchar(180) default '' COMMENT '开户行所在地',
  `uuctPayBankCountry` varchar(180) default '' COMMENT '开户行所在国家',
  `uuctPayBankCountryCode` varchar(180) default '' COMMENT '开户行所在国家编号',
  `uuctPayBankChecked` int(2) default '0' COMMENT '银行认证',
  `uuctPayBankCheckedNum` decimal(9,2) default '0.00' COMMENT '银行认证打款金款',
  `uuctPayBankCheckedTime` datetime default NULL COMMENT '银行认证款，打款时间',
  `uuctEmailSmtpIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Smtp邮件服务器地址',
  `uuctEmailSmtpName` varchar(180) default 'vir@unionNets.com' COMMENT 'Smtp邮件服务器登陆用户名',
  `uuctEmailSmtpPxd` varchar(180) default '123456' COMMENT 'Smtp邮件服务器登陆密码',
  `uuctEmailPop3Able` int(2) default '0' COMMENT '是否开通Pop3功能',
  `uuctEmailPop3Ip` varchar(180) default 'mail.unionNets.com' COMMENT 'Pop3邮件服务器地址',
  `uuctEmailPop3Name` varchar(180) default 'vir@unionNets.com' COMMENT 'Pop3邮件服务器登陆用户名',
  `uuctEmailPop3Pxd` varchar(180) default '123456' COMMENT 'Pop3邮件服务器登陆密码',
  `uuctEmailImapAble` int(2) default '0' COMMENT '是否开通Imap功能',
  `uuctEmailImapIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Imap邮件服务器地址',
  `uuctEmailImapName` varchar(180) default 'vir@unionNets.com' COMMENT 'Imap邮件服务器登陆用户名',
  `uuctEmailImapPxd` varchar(180) default '123456' COMMENT 'Imap邮件服务器登陆密码',
  `uuctEmailChecked` int(2) default '0' COMMENT '电子邮件认证',
  `uuctMapX` varchar(42) default '-' COMMENT '地图X',
  `uuctMapY` varchar(42) default '-' COMMENT '地图Y',
  `uuctMapTagIntroduct` varchar(180) default '-' COMMENT '地图标签上的介绍',
  `uuctSysConfig` varchar(180) default NULL COMMENT '单位配置文件符号\n                        这里是用户登陆后，读取所在单位的配置文件，再从配置文件里，读取数据库等重要配置信息\n                        \n                        Access配置\n                        Path,PxdWord\n                        \n                        MySql配置\n                        DbNa',
  `uuctCount_Views` int(11) default '0' COMMENT '查看数',
  `uuctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `uuctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `uuctCode_Main` int(11) default '8' COMMENT '总评分',
  `uuctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `uuctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `uuctChannelid` text COMMENT '所属频道',
  `uuctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `uuctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `uuctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `uuctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `uuctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `uuctPower_View` text COMMENT '用户查看权限',
  `uuctSpicalPosition` text COMMENT '特殊位置',
  `uuctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `uuctSmallContent` varchar(180) default '-' COMMENT '简介',
  `uuctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `uuctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `uuctMetaDescription` text COMMENT 'MetaDescription',
  `uuctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uuctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uuctSources` text COMMENT '图集',
  `uuctIntroduct` text COMMENT '详细介绍',
  `uuctContent` text COMMENT '内容',
  `uuctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `uuctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `uuctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `uuctRemark` text COMMENT '备注',
  PRIMARY KEY  (`uuctID`),
  KEY `uuctIndexID` (`uuctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserunitcont` */

insert  into `gsnavigation_netsuserunitcont`(`uuctID`,`uuctIndexID`,`uuctComName`,`uuctComIdCode`,`uuctComIdCodeSource`,`uuctComIdCodeChecked`,`uuctComType`,`uuctComContact`,`uuctComContactTele`,`uuctComContactTeleChecked`,`uuctComContactQQ`,`uuctComZoneChoose`,`uuctComZoneDetail`,`uuctComContactAddress`,`uuctComNumCode`,`uuctComContactWebsite`,`uuctComContactEmail`,`uuctComContactFax`,`uuctComPersonCount`,`uuctComYearMoney`,`uuctComCustomTypes`,`uuctComRegisterFund`,`uuctComManageSystem`,`uuctComBrand`,`uuctComRegisterPeople`,`uuctComCreateTime`,`uuctComProduct`,`uuctComBusinessModel`,`uuctComLogo`,`uuctComContactIntroduct`,`uuctWhAble`,`uuctWhName`,`uuctWhSmallIntroduct`,`uuctWhSourceR00`,`uuctWhSourceR01`,`uuctWhSources`,`uuctWhIntroduct`,`uuctWhTemplatepath`,`uuctPayAlipay`,`uuctPayChinabank`,`uuctPayTenpay`,`uuctPay99Bill`,`uuctPayPayChecked`,`uuctPayBankCode`,`uuctPayBankName`,`uuctPayBankUName`,`uuctPayBankAddress`,`uuctPayBankCountry`,`uuctPayBankCountryCode`,`uuctPayBankChecked`,`uuctPayBankCheckedNum`,`uuctPayBankCheckedTime`,`uuctEmailSmtpIp`,`uuctEmailSmtpName`,`uuctEmailSmtpPxd`,`uuctEmailPop3Able`,`uuctEmailPop3Ip`,`uuctEmailPop3Name`,`uuctEmailPop3Pxd`,`uuctEmailImapAble`,`uuctEmailImapIp`,`uuctEmailImapName`,`uuctEmailImapPxd`,`uuctEmailChecked`,`uuctMapX`,`uuctMapY`,`uuctMapTagIntroduct`,`uuctSysConfig`,`uuctCount_Views`,`uuctCount_Info`,`uuctCount_InfoAll`,`uuctCode_Main`,`uuctCode_Positive`,`uuctCode_Negative`,`uuctChannelid`,`uuctModelid_Detail`,`uuctTemplateid_Detail`,`uuctDiscussAble`,`uuctKeywordAble`,`uuctKeywordContent`,`uuctPower_View`,`uuctSpicalPosition`,`uuctSmallTitle`,`uuctSmallContent`,`uuctMetaTitle`,`uuctMetaKeyword`,`uuctMetaDescription`,`uuctSourceR00`,`uuctSourceR01`,`uuctSources`,`uuctIntroduct`,`uuctContent`,`uuctPublisher_Name`,`uuctPublisher_Email`,`uuctPublisher_Source`,`uuctRemark`) values (1,1,'-','-','-',0,'-','-','-',0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',NULL,0,'-','-','-','-',NULL,NULL,'Unit/default/','','','','',0,'','','','','','',0,'0.00',NULL,'mail.unionNets.com','vir@unionNets.com','123456',0,'mail.unionNets.com','vir@unionNets.com','123456',0,'mail.unionNets.com','vir@unionNets.com','123456',0,'-','-','-',NULL,0,0,0,8,0,0,NULL,0,0,0,0,'-',NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);

/*Table structure for table `gsnavigation_netsuserunitgroup` */

DROP TABLE IF EXISTS `gsnavigation_netsuserunitgroup`;

CREATE TABLE `gsnavigation_netsuserunitgroup` (
  `uugtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uugtName` varchar(180) default '-' COMMENT '名称',
  `uugtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `uugtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uugtParid` int(11) default '0' COMMENT '上级或分类ID',
  `uugtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uugtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uugtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uugtCreateBy` int(11) default '0' COMMENT '发布人',
  `uugtCreateTime` datetime default NULL COMMENT '发布时间',
  `uugtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`uugtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserunitgroup` */

insert  into `gsnavigation_netsuserunitgroup`(`uugtID`,`uugtName`,`uugtNameStyle`,`uugtNumCode`,`uugtParid`,`uugtRecycle`,`uugtChecked`,`uugtOrderBy`,`uugtCreateBy`,`uugtCreateTime`,`uugtTag`) values (1,'ROOT','','N_2011031815244710870',0,0,2,0,1,'2011-03-18 15:24:47','0');

/*Table structure for table `gsnavigation_netsuserunitgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_netsuserunitgroupcont`;

CREATE TABLE `gsnavigation_netsuserunitgroupcont` (
  `uugctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uugctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uugctCount_Views` int(11) default '0' COMMENT '查看数',
  `uugctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `uugctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `uugctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `uugctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `uugctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `uugctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `uugctChannelid` text COMMENT '所属频道',
  `uugctModelid_List` int(11) default '0' COMMENT '列表模型',
  `uugctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `uugctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `uugctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `uugctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `uugctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `uugctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `uugctSmallContent` varchar(180) default '-' COMMENT '简介',
  `uugctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `uugctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `uugctMetaDescription` text COMMENT 'MetaDescription',
  `uugctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uugctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uugctSources` text COMMENT '图集',
  `uugctIntroduct` text COMMENT '详细介绍',
  `uugctContent` text COMMENT '内容',
  `uugctRemark` text COMMENT '备注',
  PRIMARY KEY  (`uugctID`),
  KEY `uugctIndexID` (`uugctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_netsuserunitgroupcont` */

insert  into `gsnavigation_netsuserunitgroupcont`(`uugctID`,`uugctIndexID`,`uugctCount_Views`,`uugctCount_Info`,`uugctCount_InfoAll`,`uugctCount_Discuss`,`uugctCount_DiscussAll`,`uugctCode_Positive`,`uugctCode_Negative`,`uugctChannelid`,`uugctModelid_List`,`uugctModelid_Detail`,`uugctTemplateid_Home`,`uugctTemplateid_List`,`uugctTemplateid_Detail`,`uugctPower_View`,`uugctSmallTitle`,`uugctSmallContent`,`uugctMetaTitle`,`uugctMetaKeyword`,`uugctMetaDescription`,`uugctSourceR00`,`uugctSourceR01`,`uugctSources`,`uugctIntroduct`,`uugctContent`,`uugctRemark`) values (1,1,0,0,0,0,0,0,0,'0',0,0,0,0,0,0,'0','0','0','0','0','0','0','0','','','');

/*Table structure for table `gsnavigation_oafavorite` */

DROP TABLE IF EXISTS `gsnavigation_oafavorite`;

CREATE TABLE `gsnavigation_oafavorite` (
  `oftID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `oftName` varchar(180) default '-' COMMENT '名称',
  `oftNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `oftNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `oftParid` int(11) default '0' COMMENT '上级/分类ID',
  `oftType` int(5) default '0' COMMENT '收藏类型，如：外部地址、知识库地址、职位信息',
  `oftOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `oftCreateBy` int(11) default '0' COMMENT '发布人',
  `oftCreateTime` datetime default NULL COMMENT '发布时间',
  `oftURL` varchar(180) default '-' COMMENT '收葳地址',
  `oftFavid` int(11) default '0' COMMENT '被收藏信息在系统里的编号',
  `oftFavType` int(11) default '0' COMMENT '被收藏信息在系统里的类型，如：文档：1，商品：2',
  `oftRecycle` int(2) default '0' COMMENT '是否放入回收站',
  PRIMARY KEY  (`oftID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_oafavorite` */

/*Table structure for table `gsnavigation_oafavoritecont` */

DROP TABLE IF EXISTS `gsnavigation_oafavoritecont`;

CREATE TABLE `gsnavigation_oafavoritecont` (
  `ofctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ofctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ofctIsUsually` int(2) default '0' COMMENT '是否设置为常用收藏',
  `ofctCount_Views` int(11) default '0' COMMENT '查看数',
  `ofctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `ofctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `ofctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `ofctChannelid` text COMMENT '所属频道',
  `ofctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `ofctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `ofctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `ofctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `ofctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `ofctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `ofctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `ofctPageAble` int(2) default '0' COMMENT '是否分页',
  `ofctPower_View` text COMMENT '用户查看权限',
  `ofctPower_Public` text COMMENT '用户发布权限',
  `ofctSpicalPosition` text COMMENT '特殊位置',
  `ofctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `ofctSmallContent` varchar(180) default '-' COMMENT '简介',
  `ofctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `ofctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `ofctMetaDescription` text COMMENT 'MetaDescription',
  `ofctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `ofctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `ofctSources` text COMMENT '图集',
  `ofctIntroduct` text COMMENT '详细介绍',
  `ofctContent` text COMMENT '内容',
  `ofctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `ofctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `ofctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `ofctRemark` text COMMENT '备注',
  PRIMARY KEY  (`ofctID`),
  KEY `ofctIndexID` (`ofctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_oafavoritecont` */

/*Table structure for table `gsnavigation_oafavoritegroup` */

DROP TABLE IF EXISTS `gsnavigation_oafavoritegroup`;

CREATE TABLE `gsnavigation_oafavoritegroup` (
  `ofgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ofgtName` varchar(180) default '-' COMMENT '名称',
  `ofgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `ofgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ofgtParid` int(11) default '0' COMMENT '上级/分类ID',
  `ofgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `ofgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `ofgtCreateBy` int(11) default '0' COMMENT '发布人',
  `ofgtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`ofgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_oafavoritegroup` */

insert  into `gsnavigation_oafavoritegroup`(`ofgtID`,`ofgtName`,`ofgtNameStyle`,`ofgtNumCode`,`ofgtParid`,`ofgtChecked`,`ofgtOrderBy`,`ofgtCreateBy`,`ofgtCreateTime`) values (1,'ROOT','','N_2011012316583618038',0,2,0,1,'2011-01-23 16:58:36');

/*Table structure for table `gsnavigation_oafavoritegroupcont` */

DROP TABLE IF EXISTS `gsnavigation_oafavoritegroupcont`;

CREATE TABLE `gsnavigation_oafavoritegroupcont` (
  `ofgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ofgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ofgctCount_Views` int(11) default '0' COMMENT '查看数',
  `ofgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `ofgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `ofgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `ofgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `ofgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `ofgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `ofgctChannelid` text COMMENT '所属频道',
  `ofgctModelid_List` int(11) default '0' COMMENT '列表模型',
  `ofgctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `ofgctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `ofgctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `ofgctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `ofgctPower_View` text COMMENT '用户查看权限',
  `ofgctPower_Public` text COMMENT '用户发布权限',
  `ofgctSpicalPosition` text COMMENT '特殊位置',
  `ofgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `ofgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `ofgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `ofgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `ofgctMetaDescription` text COMMENT 'MetaDescription',
  `ofgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `ofgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `ofgctSources` text COMMENT '图集',
  `ofgctIntroduct` text COMMENT '详细介绍',
  `ofgctContent` text COMMENT '内容',
  `ofgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`ofgctID`),
  KEY `ofgctIndexID` (`ofgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_oafavoritegroupcont` */

insert  into `gsnavigation_oafavoritegroupcont`(`ofgctID`,`ofgctIndexID`,`ofgctCount_Views`,`ofgctCount_Info`,`ofgctCount_InfoAll`,`ofgctCount_Discuss`,`ofgctCount_DiscussAll`,`ofgctCode_Positive`,`ofgctCode_Negative`,`ofgctChannelid`,`ofgctModelid_List`,`ofgctModelid_Detail`,`ofgctTemplateid_Home`,`ofgctTemplateid_List`,`ofgctTemplateid_Detail`,`ofgctPower_View`,`ofgctPower_Public`,`ofgctSpicalPosition`,`ofgctSmallTitle`,`ofgctSmallContent`,`ofgctMetaTitle`,`ofgctMetaKeyword`,`ofgctMetaDescription`,`ofgctSourceR00`,`ofgctSourceR01`,`ofgctSources`,`ofgctIntroduct`,`ofgctContent`,`ofgctRemark`) values (1,1,0,0,0,0,0,0,0,'0',0,0,0,0,0,'0','0','0','0','0','0','0','0','0','0','0','','','');

/*Table structure for table `gsnavigation_oanotebook` */

DROP TABLE IF EXISTS `gsnavigation_oanotebook`;

CREATE TABLE `gsnavigation_oanotebook` (
  `onbtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `onbtName` varchar(180) default '-' COMMENT '名称',
  `onbtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `onbtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `onbtParid` int(11) default '0' COMMENT '上级/分类ID',
  `onbtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `onbtCreateBy` int(11) default '0' COMMENT '发布人',
  `onbtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`onbtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_oanotebook` */

/*Table structure for table `gsnavigation_oanotebookcont` */

DROP TABLE IF EXISTS `gsnavigation_oanotebookcont`;

CREATE TABLE `gsnavigation_oanotebookcont` (
  `onbctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `onbctIndexID` int(11) default '0' COMMENT '主表ID号',
  `onbctCount_Views` int(11) default '0' COMMENT '查看数',
  `onbctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `onbctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `onbctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `onbctChannelid` text COMMENT '所属频道',
  `onbctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `onbctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `onbctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `onbctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `onbctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `onbctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `onbctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `onbctPageAble` int(2) default '0' COMMENT '是否分页',
  `onbctPower_View` text COMMENT '用户查看权限',
  `onbctPower_Public` text COMMENT '用户发布权限',
  `onbctSpicalPosition` text COMMENT '特殊位置',
  `onbctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `onbctSmallContent` varchar(180) default '-' COMMENT '简介',
  `onbctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `onbctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `onbctMetaDescription` text COMMENT 'MetaDescription',
  `onbctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `onbctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `onbctSources` text COMMENT '图集',
  `onbctIntroduct` text COMMENT '详细介绍',
  `onbctContent` text COMMENT '内容',
  `onbctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `onbctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `onbctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `onbctRemark` text COMMENT '备注',
  PRIMARY KEY  (`onbctID`),
  KEY `onbctIndexID` (`onbctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_oanotebookcont` */

/*Table structure for table `gsnavigation_oanotebookgroup` */

DROP TABLE IF EXISTS `gsnavigation_oanotebookgroup`;

CREATE TABLE `gsnavigation_oanotebookgroup` (
  `onbgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `onbgtName` varchar(180) default '-' COMMENT '名称',
  `onbgtNameStyle` varchar(42) default '-' COMMENT '名称样式',
  `onbgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `onbgtParid` int(11) default '0' COMMENT '上级/分类ID',
  `onbgtChecked` int(5) default '0' COMMENT '审核',
  `onbgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `onbgtCreateBy` int(11) default '0' COMMENT '发布人',
  `onbgtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`onbgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_oanotebookgroup` */

insert  into `gsnavigation_oanotebookgroup`(`onbgtID`,`onbgtName`,`onbgtNameStyle`,`onbgtNumCode`,`onbgtParid`,`onbgtChecked`,`onbgtOrderBy`,`onbgtCreateBy`,`onbgtCreateTime`) values (1,'ROOT','','N_2011012316575374676',0,2,0,1,'2011-01-23 16:57:53');

/*Table structure for table `gsnavigation_oanotebookgroupcont` */

DROP TABLE IF EXISTS `gsnavigation_oanotebookgroupcont`;

CREATE TABLE `gsnavigation_oanotebookgroupcont` (
  `onbgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `onbgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `onbgctCount_Views` int(11) default '0' COMMENT '查看数',
  `onbgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `onbgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `onbgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `onbgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `onbgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `onbgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `onbgctChannelid` text COMMENT '所属频道',
  `onbgctModelid_List` int(11) default '0' COMMENT '列表模型',
  `onbgctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `onbgctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `onbgctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `onbgctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `onbgctPower_View` text COMMENT '用户查看权限',
  `onbgctPower_Public` text COMMENT '用户发布权限',
  `onbgctSpicalPosition` text COMMENT '特殊位置',
  `onbgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `onbgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `onbgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `onbgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `onbgctMetaDescription` text COMMENT 'MetaDescription',
  `onbgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `onbgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `onbgctSources` text COMMENT '图集',
  `onbgctIntroduct` text COMMENT '详细介绍',
  `onbgctContent` text COMMENT '内容',
  `onbgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`onbgctID`),
  KEY `onbgctIndexID` (`onbgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `gsnavigation_oanotebookgroupcont` */

insert  into `gsnavigation_oanotebookgroupcont`(`onbgctID`,`onbgctIndexID`,`onbgctCount_Views`,`onbgctCount_Info`,`onbgctCount_InfoAll`,`onbgctCount_Discuss`,`onbgctCount_DiscussAll`,`onbgctCode_Positive`,`onbgctCode_Negative`,`onbgctChannelid`,`onbgctModelid_List`,`onbgctModelid_Detail`,`onbgctTemplateid_Home`,`onbgctTemplateid_List`,`onbgctTemplateid_Detail`,`onbgctPower_View`,`onbgctPower_Public`,`onbgctSpicalPosition`,`onbgctSmallTitle`,`onbgctSmallContent`,`onbgctMetaTitle`,`onbgctMetaKeyword`,`onbgctMetaDescription`,`onbgctSourceR00`,`onbgctSourceR01`,`onbgctSources`,`onbgctIntroduct`,`onbgctContent`,`onbgctRemark`) values (1,1,0,0,0,0,0,0,0,'0',0,0,0,0,0,'0','0','0','0','0','0','0','0','0','0','0','','','');

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
