﻿/*
 * Attach Plugin for FCKeditor 2.6.3
 * Copyright (C) 2008 Shenjk (shjk813@126.com)
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *http://www.shenjk.com
 *
 * == END LICENSE ==
 *
 * Scripts related to the Attach dialog window (see fck_attach.html).
 */
var cFckAttachElementName='a';
var cAttachTypeAttrName = 'attachtype';

var oEditor		= window.parent.InnerDialogLoaded() ;
var FCK			= oEditor.FCK ;
var FCKLang		= oEditor.FCKLang ;
var FCKConfig	= oEditor.FCKConfig ;

var oLink = FCK.Selection.MoveToAncestorNode( 'A' ) ;
if ( oLink )
	FCK.Selection.SelectNode( oLink ) ;

//#### Dialog Tabs

// Set the dialog tabs.
window.parent.AddTab( 'Info', oEditor.FCKLang.DlgInfoTab ) ;

if ( FCKConfig.FlashUpload )
	window.parent.AddTab( 'Upload', FCKLang.DlgLnkUpload ) ;

if ( !FCKConfig.FlashDlgHideAdvanced )
	window.parent.AddTab( 'Advanced', oEditor.FCKLang.DlgAdvancedTag ) ;

// Function called when a dialog tag is selected.
function OnDialogTabChange( tabCode )
{
	ShowE('divInfo'		, ( tabCode == 'Info' ) ) ;
	ShowE('divUpload'	, ( tabCode == 'Upload' ) ) ;
	ShowE('divAdvanced'	, ( tabCode == 'Advanced' ) ) ;
}

// Get the selected Attach embed (if available).
var oFakeImage = FCK.Selection.GetSelectedElement() ;
var oEmbed ;

if ( oFakeImage )
{
	if ( oFakeImage.tagName == 'IMG' && oFakeImage.getAttribute('_fckAttach') )
		oEmbed = FCK.GetRealElement( oFakeImage ) ;
	else
		oFakeImage = null ;
}

window.onload = function()
{
	// Translate the dialog box texts.
	oEditor.FCKLanguageManager.TranslatePage(document) ;

	// Load the selected element information (if any).
	LoadSelection() ;

	// Show/Hide the "Browse Server" button.
	GetE('tdBrowse').style.display = FCKConfig.AttachBrowser	? '' : 'none' ;

	// Set the actual uploader URL.
	if ( FCKConfig.AttachUpload )
		GetE('frmUpload').action = FCKConfig.AttachUploadURL ;
	if(GetE('spanExtMsg')){
	   GetE('spanExtMsg').innerHTML= FCKLang.AttachAllowExt+FCKConfig.AttachUploadAllowedExtensions.substring(2,FCKConfig.AttachUploadAllowedExtensions.length-2);
	}

	window.parent.SetAutoSize( true ) ;

	// Activate the "OK" button.
	window.parent.SetOkButton( true ) ;
}

function LoadSelection()
{
	if ( ! oEmbed ) return ;
    if ( !oLink ) {}

	GetE('txtUrl').value    = GetAttribute( oEmbed, 'href', '' ) ;


	// Get Advances Attributes
	GetE('txtAttId').value		= oEmbed.id ;

	GetE('txtAttTitle').value		= oEmbed.title ;

	if ( oEditor.FCKBrowserInfo.IsIE )
	{
		GetE('txtAttClasses').value = oEmbed.getAttribute('className') || '' ;
		GetE('txtAttStyle').value = oEmbed.style.cssText ;
	}
	else
	{
		GetE('txtAttClasses').value = oEmbed.getAttribute('class',2) || '' ;
		GetE('txtAttStyle').value = oEmbed.getAttribute('style',2) || '' ;
	}

	UpdatePreview() ;
}

//#### The OK button was hit.
function Ok()
{
    var sUri, sInnerHtml ;
	if ( GetE('txtUrl').value.length == 0 )
	{
		window.parent.SetSelectedTab( 'Info' ) ;
		GetE('txtUrl').focus() ;

		alert( oEditor.FCKLang.DlgAlertUrl ) ;

		return false ;
	}

    var sUri=GetE('txtUrl').value;
//    if(!oLink){
//        oLink=oEditor.FCK.CreateLink(sUri) ;
//    }
    if (oLink){
        sInnerHtml = oLink.innerHTML ;
    }else{
        sInnerHtml = sUri;       
    
        
        var oLinkPathRegEx = new RegExp("(^.*\\/|^)([^\\/]*?)(\\?.*$|$)");
		var asLinkPath = oLinkPathRegEx.exec( sUri );
		if (asLinkPath != null){sInnerHtml = asLinkPath[2];}
		oLink = oEditor.FCK.CreateElement('a');
    }  

	oEditor.FCKUndo.SaveUndoStep() ;
	
	oLink.href = sUri ;
	SetAttribute( oLink, '_fcksavedurl', sUri ) ;
    var ext=sInnerHtml.substr(sInnerHtml.lastIndexOf('.')+1);
    var asImage=  '<img src="'+oEditor.PlusPath+'images/'+ext+'.gif" style="border:0" alt="下载"/>'; //添加文件图片
	oLink.innerHTML = asImage+sInnerHtml ;		// Set (or restore) the innerHTML
	// Target
	SetAttribute( oLink, 'target', '_blank' ) ;
	// Advances Attributes
	SetAttribute( oLink, 'title'	, GetE('txtAttTitle').value ) ;
	// Select the link.
	oEditor.FCKSelection.SelectNode(oLink);
	return true;
	

}


var ePreview ;

function SetPreviewElement( previewEl )
{
	ePreview = previewEl ;

	if ( GetE('txtUrl').value.length > 0 )
		UpdatePreview() ;
}

function UpdatePreview()
{
	if ( !ePreview )
		return ;

	while ( ePreview.firstChild )
		ePreview.removeChild( ePreview.firstChild ) ;

	if ( GetE('txtUrl').value.length == 0 )
		ePreview.innerHTML = '&nbsp;' ;
	else
	{
		var oDoc	= ePreview.ownerDocument || ePreview.document ;
		var e		= oDoc.createElement( 'a' ) ;
		SetAttribute( e, 'href', GetE('txtUrl').value ) ;
		ePreview.appendChild( e ) ;
		ePreview.innerHTML = WrapObjectToAttach(ePreview.innerHTML, 'a'); 

	}
}

function BrowseServer()
{
	OpenFileBrowser( FCKConfig.AttachBrowserURL, FCKConfig.AttachBrowserWindowWidth, FCKConfig.AttachBrowserWindowHeight ) ;
}

function SetUrl( url, width, height )
{
	GetE('txtUrl').value = url ;

	UpdatePreview() ;

	window.parent.SetSelectedTab( 'Info' ) ;
}

function OnUploadCompleted( errorNumber, fileUrl, fileName, customMsg )
{
	switch ( errorNumber )
	{
		case 0 :	// No errors
			alert( 'Your file has been successfully uploaded' ) ;
			break ;
		case 1 :	// Custom error
			alert( customMsg ) ;
			return ;
		case 101 :	// Custom warning
			alert( customMsg ) ;
			break ;
		case 201 :
			alert( 'A file with the same name is already available. The uploaded file has been renamed to "' + fileName + '"' ) ;
			break ;
		case 202 :
			alert( 'Invalid file type' ) ;
			return ;
		case 203 :
			alert( "Security error. You probably don't have enough permissions to upload. Please check your server." ) ;
			return ;
		default :
			alert( 'Error on file upload. Error number: ' + errorNumber ) ;
			return ;
	}

	SetUrl( fileUrl ) ;
	GetE('frmUpload').reset() ;
}

var oUploadAllowedExtRegex	= new RegExp( FCKConfig.AttachUploadAllowedExtensions, 'i' ) ;
var oUploadDeniedExtRegex	= new RegExp( FCKConfig.AttachUploadDeniedExtensions, 'i' ) ;

function CheckUpload()
{
	var sFile = GetE('txtUploadFile').value ;

	if ( sFile.length == 0 )
	{
		alert( 'Please select a file to upload' ) ;
		return false ;
	}

	if ( ( FCKConfig.AttachUploadAllowedExtensions.length > 0 && !oUploadAllowedExtRegex.test( sFile ) ) ||
		( FCKConfig.AttachUploadDeniedExtensions.length > 0 && oUploadDeniedExtRegex.test( sFile ) ) )
	{
		OnUploadCompleted( 202 ) ;
		return false ;
	}

	return true ;
}
