/*
-- ------ netsChecker version 0.2 ------ --
unionNets.com
2008
*/
function netsChecker(){}
//-- ------ #Parameters ------ --
netsChecker.prototype.sName="tmpChecker";
//-- #Rule --
netsChecker.prototype.sysRule=new Array();
//Is number
netsChecker.prototype.sysRule[0]=/^\d{0,}$/;
//Is word
netsChecker.prototype.sysRule[1]=/^\w{1,}$/;
//Is float
netsChecker.prototype.sysRule[2]=/^(\d{0,9})\.(\d{0,2})$/;
//中国电话
netsChecker.prototype.sysRule[3]=/^\d{2,}-{0,1}\d{6,}$/;
//中国手机
netsChecker.prototype.sysRule[4]=/^(\d{11})$/;
//电子邮件
netsChecker.prototype.sysRule[5]=/^([a-zA-Z0-9]+[_|\-|\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\-|\.]?)*[a-zA-Z0-9]+\.[a-zA-Z]{1,7}$/;
//旧/新身份证
netsChecker.prototype.sysRule[6]=/^\s*\d{15}\s*$/;
netsChecker.prototype.sysRule[7]=/^\s*\d{18}\s*$/;
//日期
netsChecker.prototype.sysRule[8]=/^(\d{4})\-(\d{1}?)\-(\d{1}?)$/;
//中文姓名
netsChecker.prototype.sysRule[9]=/^[\u4e00-\u9fa5]{2,}$/;

//-- ------ #Methods ------ --
netsChecker.prototype.Filter=function(pSTR,pFilterType){
	var Coun0=0;
	var tmpSTR=pSTR;
	
	if(pFilterType==0){
		tmpSTR=tmpSTR.replace("'","");
	}else if(pFilterType==1){
		tmpSTR=tmpSTR.replace("'","");
		tmpSTR=tmpSTR.replace("script","");
		tmpSTR=tmpSTR.replace("select","");
		tmpSTR=tmpSTR.replace("insert","");
	}
	
	return tmpSTR;
}
netsChecker.prototype.Rule=function(pSTR,pIndex){
	if(this.sysRule.length>pIndex){
		var tmpReg=this.sysRule[pIndex];
		tmpReg.lastIndex=0;
		if(tmpReg.test(pSTR)){
			return true;
		}else{
			return false;
		}
	}
	return true;
}
netsChecker.prototype.CheckLen=function(pSTR,pMinLen,pMaxLen){
	if(parseInt(pSTR.getBytes())>=pMinLen && parseInt(pSTR.getBytes())<=pMaxLen){
		return true;
	}else{
		return false;
	}
}
netsChecker.prototype.PxdSecurity=function(pSTR){
	var tmpIndex=0;
	tmpIndex=pSTR.replace(/^(?:([a-z])|([A-Z])|([0-9])|(.)){5,}|(.)+$/g, "$1$2$3$4$5").length;
	
	return tmpIndex;
}

//------ #Demo ------ ------
function JsDCheck(pPara){
	var tmpControl="";
	var tmpError="";
	var tmpChecker=new netsChecker();
	var tmpActionWithOut=document.getElementById(tmpCommon.sysActionWithOut);
	document.getElementById(tmpCommon.sysActionTypeF).value=0;
	var Coun0=0;
	//-- ------ #ActionWithOut ------ --
	if(tmpActionWithOut==undefined){
		return true;
	}
	if(tmpActionWithOut.value=="1"){
		return true;
	}else if(tmpActionWithOut.value=="2"){
		return false;
	}
	//-- ------ #Check ------ --
	/*
	//#uitName
	tmpCheckCont=document.getElementById("uitNameTxt");
	tmpCheckCont.value=tmpChecker.Filter(tmpCheckCont.value,0);
	if(!tmpChecker.CheckLen(tmpCheckCont.value,5,32)){
		Coun0++;
		tmpSTR="地址不能为空";
		document.getElementById(tmpControl+"Txt_Messagebox").className="EMessage_0";
		document.getElementById(tmpControl+"Txt_Messagebox").innerHTML=tmpSTR;
		tmpError+=Coun0+"."+tmpSTR+tmpCommon.sysSPLIT8;
	}else{
		document.getElementById(tmpControl+"Txt_Messagebox").className=tmpCommon.sysHidden;
	}
	*/
	//-- ------ #Result ------ --
	if(Coun0>0){
		tmpSTR="对不起，您提交的内容存在以下错误:"+tmpCommon.sysSPLIT8+tmpError;
		showMessage("系统消息 - unionNets.com",tmpSTR,"","0");
		return false;
	}else{
		document.getElementById(tmpCommon.sysActionTypeF).value=0;
		return true;
	}
}
