
/*Table structure for table `{NetsInstall.Db_Tablehead}commposts` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}commposts`;

CREATE TABLE `{NetsInstall.Db_Tablehead}commposts` (
  `coptID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `coptName` varchar(180) default '-' COMMENT '名称',
  `coptNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `coptNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `coptParid` int(11) default '0' COMMENT '上级或分类ID',
  `coptCircleid` int(11) default '0' COMMENT '所属圈子',
  `coptRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `coptChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `coptOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `coptCreateBy` int(11) default '0' COMMENT '发布人',
  `coptCreateTime` datetime default NULL COMMENT '发布时间',
  `coptTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`coptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}commposts` */

insert  into `{NetsInstall.Db_Tablehead}commposts`(`coptID`,`coptName`,`coptNameStyle`,`coptNumCode`,`coptParid`,`coptCircleid`,`coptRecycle`,`coptChecked`,`coptOrderBy`,`coptCreateBy`,`coptCreateTime`,`coptTag`) values (1,'第一个话题','-','-',6,0,0,2,0,1,'2011-01-01 00:00:00','-');
insert  into `{NetsInstall.Db_Tablehead}commposts`(`coptID`,`coptName`,`coptNameStyle`,`coptNumCode`,`coptParid`,`coptCircleid`,`coptRecycle`,`coptChecked`,`coptOrderBy`,`coptCreateBy`,`coptCreateTime`,`coptTag`) values (2,'第二个话题','-','-',6,0,0,2,0,1,'2010-12-21 17:11:14','-');
insert  into `{NetsInstall.Db_Tablehead}commposts`(`coptID`,`coptName`,`coptNameStyle`,`coptNumCode`,`coptParid`,`coptCircleid`,`coptRecycle`,`coptChecked`,`coptOrderBy`,`coptCreateBy`,`coptCreateTime`,`coptTag`) values (3,'网络营销论坛 网络营销人的交流社区','0','N_2010100615394324319',5,1,0,2,0,1,'2010-12-20 20:07:27','0');
insert  into `{NetsInstall.Db_Tablehead}commposts`(`coptID`,`coptName`,`coptNameStyle`,`coptNumCode`,`coptParid`,`coptCircleid`,`coptRecycle`,`coptChecked`,`coptOrderBy`,`coptCreateBy`,`coptCreateTime`,`coptTag`) values (5,'网络营销论坛 网络营销人的交流社区','0','N_2010100615415657672',5,2,0,2,0,1,'2010-12-20 20:02:07','0');
insert  into `{NetsInstall.Db_Tablehead}commposts`(`coptID`,`coptName`,`coptNameStyle`,`coptNumCode`,`coptParid`,`coptCircleid`,`coptRecycle`,`coptChecked`,`coptOrderBy`,`coptCreateBy`,`coptCreateTime`,`coptTag`) values (6,'自动控制（automatic control）是指在没有人直接参与的情况下，利用外加的设备或装置，使机器、设备或生产过程的某个工作状态或参数自动地按照预定的规律运行','0','N_2010122111112727493',5,0,0,2,0,2,'2010-12-21 11:12:33','0');
insert  into `{NetsInstall.Db_Tablehead}commposts`(`coptID`,`coptName`,`coptNameStyle`,`coptNumCode`,`coptParid`,`coptCircleid`,`coptRecycle`,`coptChecked`,`coptOrderBy`,`coptCreateBy`,`coptCreateTime`,`coptTag`) values (7,'1998年，Infineon公司推出冷mos管，它采用\"超级结\"（Super-Junction）结构，故又称超结功率MOSFET。工作电压600V～800V，通态电阻几乎降低了一个数量级，仍保持开关速度快的特点，是一种有发展前途的高频功率半导体器件。','0','N_2010122117252426663',6,0,0,2,0,2,'2010-12-21 17:25:24','0');

/*Table structure for table `{NetsInstall.Db_Tablehead}commpostscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}commpostscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}commpostscont` (
  `copctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copctIndexID` int(11) default '0' COMMENT '主表ID号',
  `copctType` int(5) default '0' COMMENT '类型',
  `copctIcon` int(5) default '0' COMMENT '小图标类型',
  `copctTop` int(2) default '0' COMMENT '是否置顶',
  `copctHot` int(2) default '0' COMMENT '是否热门',
  `copctEssence` int(2) default '0' COMMENT '是否精华:0,精1-现定5级',
  `copctZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `copctCount_Views` int(11) default '0' COMMENT '查看数',
  `copctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `copctCode_Main` int(11) default '8' COMMENT '总评分',
  `copctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `copctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `copctChannelid` text COMMENT '所属频道',
  `copctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `copctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `copctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `copctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `copctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `copctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `copctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `copctPageAble` int(2) default '0' COMMENT '是否分页',
  `copctPower_View` text COMMENT '用户查看权限',
  `copctSpicalPosition` text COMMENT '特殊位置',
  `copctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `copctSmallContent` varchar(180) default '-' COMMENT '简介',
  `copctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `copctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `copctMetaDescription` text COMMENT 'MetaDescription',
  `copctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `copctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `copctSources` text COMMENT '图集',
  `copctIntroduct` text COMMENT '详细介绍',
  `copctContent` text COMMENT '内容',
  `copctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `copctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `copctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `copctRemark` text COMMENT '备注',
  `copctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `copctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `copctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `copctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  PRIMARY KEY  (`copctID`),
  KEY `copctIndexID` (`copctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}commpostscont` */

insert  into `{NetsInstall.Db_Tablehead}commpostscont`(`copctID`,`copctIndexID`,`copctType`,`copctIcon`,`copctTop`,`copctHot`,`copctEssence`,`copctZoneChoose`,`copctCount_Views`,`copctCount_Discuss`,`copctCode_Main`,`copctCode_Positive`,`copctCode_Negative`,`copctChannelid`,`copctRequireType`,`copctRequireid`,`copctModelid_Detail`,`copctTemplateid_Detail`,`copctDiscussAble`,`copctKeywordAble`,`copctKeywordContent`,`copctPageAble`,`copctPower_View`,`copctSpicalPosition`,`copctSmallTitle`,`copctSmallContent`,`copctMetaTitle`,`copctMetaKeyword`,`copctMetaDescription`,`copctSourceR00`,`copctSourceR01`,`copctSources`,`copctIntroduct`,`copctContent`,`copctPublisher_Name`,`copctPublisher_Email`,`copctPublisher_Source`,`copctRemark`,`copctPublisher_Mobile`,`copctPublisher_Tele`,`copctPublisher_Software`,`copctPublisher_Homepage`) values (1,1,0,0,0,0,0,'-',2,0,8,1,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL,'-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostscont`(`copctID`,`copctIndexID`,`copctType`,`copctIcon`,`copctTop`,`copctHot`,`copctEssence`,`copctZoneChoose`,`copctCount_Views`,`copctCount_Discuss`,`copctCode_Main`,`copctCode_Positive`,`copctCode_Negative`,`copctChannelid`,`copctRequireType`,`copctRequireid`,`copctModelid_Detail`,`copctTemplateid_Detail`,`copctDiscussAble`,`copctKeywordAble`,`copctKeywordContent`,`copctPageAble`,`copctPower_View`,`copctSpicalPosition`,`copctSmallTitle`,`copctSmallContent`,`copctMetaTitle`,`copctMetaKeyword`,`copctMetaDescription`,`copctSourceR00`,`copctSourceR01`,`copctSources`,`copctIntroduct`,`copctContent`,`copctPublisher_Name`,`copctPublisher_Email`,`copctPublisher_Source`,`copctRemark`,`copctPublisher_Mobile`,`copctPublisher_Tele`,`copctPublisher_Software`,`copctPublisher_Homepage`) values (2,2,0,7,1,1,2,'-',2,0,8,0,0,'',0,0,0,0,0,0,'-',0,'0','0','-','-','-','-','','-','-','','','','-','-','-','','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostscont`(`copctID`,`copctIndexID`,`copctType`,`copctIcon`,`copctTop`,`copctHot`,`copctEssence`,`copctZoneChoose`,`copctCount_Views`,`copctCount_Discuss`,`copctCode_Main`,`copctCode_Positive`,`copctCode_Negative`,`copctChannelid`,`copctRequireType`,`copctRequireid`,`copctModelid_Detail`,`copctTemplateid_Detail`,`copctDiscussAble`,`copctKeywordAble`,`copctKeywordContent`,`copctPageAble`,`copctPower_View`,`copctSpicalPosition`,`copctSmallTitle`,`copctSmallContent`,`copctMetaTitle`,`copctMetaKeyword`,`copctMetaDescription`,`copctSourceR00`,`copctSourceR01`,`copctSources`,`copctIntroduct`,`copctContent`,`copctPublisher_Name`,`copctPublisher_Email`,`copctPublisher_Source`,`copctRemark`,`copctPublisher_Mobile`,`copctPublisher_Tele`,`copctPublisher_Software`,`copctPublisher_Homepage`) values (3,3,0,0,0,0,0,'0',2,0,0,2,0,'0',0,0,0,0,0,0,'0',0,'0','0','0','0','0','0','0','0','0','0','0','<P>业务员网提供销售业务职位信息，销售技巧文章，销售小说，销售视频。火爆的业务员论坛为销售精英搭建一个互通，交流，共享的平台。</P>\r\n<P>?</P>','网集客服','core@unionnets.com','../../../Uploadfiles/ParameterDWHJ_041002.jpg','0','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostscont`(`copctID`,`copctIndexID`,`copctType`,`copctIcon`,`copctTop`,`copctHot`,`copctEssence`,`copctZoneChoose`,`copctCount_Views`,`copctCount_Discuss`,`copctCode_Main`,`copctCode_Positive`,`copctCode_Negative`,`copctChannelid`,`copctRequireType`,`copctRequireid`,`copctModelid_Detail`,`copctTemplateid_Detail`,`copctDiscussAble`,`copctKeywordAble`,`copctKeywordContent`,`copctPageAble`,`copctPower_View`,`copctSpicalPosition`,`copctSmallTitle`,`copctSmallContent`,`copctMetaTitle`,`copctMetaKeyword`,`copctMetaDescription`,`copctSourceR00`,`copctSourceR01`,`copctSources`,`copctIntroduct`,`copctContent`,`copctPublisher_Name`,`copctPublisher_Email`,`copctPublisher_Source`,`copctRemark`,`copctPublisher_Mobile`,`copctPublisher_Tele`,`copctPublisher_Software`,`copctPublisher_Homepage`) values (5,5,0,0,0,0,0,'0',2,1,0,0,1,'0',0,0,0,0,0,0,'0',0,'0','0','0','0','0','0','0','0','0','0','0','<P>业务员网提供销售业务职位信息，销售技巧文章，销售小说，销售视频。火爆的业务员论坛为销售精英搭建一个互通，交流，共享的平台。</P>\r\n<P>?</P>','网集客服','core@unionnets.com','../../../Uploadfiles/ParameterDWHJ_041002.jpg','0','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostscont`(`copctID`,`copctIndexID`,`copctType`,`copctIcon`,`copctTop`,`copctHot`,`copctEssence`,`copctZoneChoose`,`copctCount_Views`,`copctCount_Discuss`,`copctCode_Main`,`copctCode_Positive`,`copctCode_Negative`,`copctChannelid`,`copctRequireType`,`copctRequireid`,`copctModelid_Detail`,`copctTemplateid_Detail`,`copctDiscussAble`,`copctKeywordAble`,`copctKeywordContent`,`copctPageAble`,`copctPower_View`,`copctSpicalPosition`,`copctSmallTitle`,`copctSmallContent`,`copctMetaTitle`,`copctMetaKeyword`,`copctMetaDescription`,`copctSourceR00`,`copctSourceR01`,`copctSources`,`copctIntroduct`,`copctContent`,`copctPublisher_Name`,`copctPublisher_Email`,`copctPublisher_Source`,`copctRemark`,`copctPublisher_Mobile`,`copctPublisher_Tele`,`copctPublisher_Software`,`copctPublisher_Homepage`) values (6,6,0,0,0,0,0,'0',4,0,0,3,0,'0',0,0,0,0,0,0,'0',0,'0','0','0','0','0','0','0','0','0','0','0','自动控制（automatic control）是指在没有人直接参与的情况下，利用外加的设备或装置，使机器、设备或生产过程的某个工作状态或参数自动地按照预定的规律运行','匿名用户','vir@unionnets.com','../../../','0','13900000000','86-027-80000000','10000000','unionnets.com');
insert  into `{NetsInstall.Db_Tablehead}commpostscont`(`copctID`,`copctIndexID`,`copctType`,`copctIcon`,`copctTop`,`copctHot`,`copctEssence`,`copctZoneChoose`,`copctCount_Views`,`copctCount_Discuss`,`copctCode_Main`,`copctCode_Positive`,`copctCode_Negative`,`copctChannelid`,`copctRequireType`,`copctRequireid`,`copctModelid_Detail`,`copctTemplateid_Detail`,`copctDiscussAble`,`copctKeywordAble`,`copctKeywordContent`,`copctPageAble`,`copctPower_View`,`copctSpicalPosition`,`copctSmallTitle`,`copctSmallContent`,`copctMetaTitle`,`copctMetaKeyword`,`copctMetaDescription`,`copctSourceR00`,`copctSourceR01`,`copctSources`,`copctIntroduct`,`copctContent`,`copctPublisher_Name`,`copctPublisher_Email`,`copctPublisher_Source`,`copctRemark`,`copctPublisher_Mobile`,`copctPublisher_Tele`,`copctPublisher_Software`,`copctPublisher_Homepage`) values (7,7,0,0,0,0,0,'0',2,1,0,1,0,'0',0,0,0,0,0,0,'0',0,'0','0','0','0','0','0','0','0','0','0','0','1998年，Infineon公司推出冷mos管，它采用\"超级结\"（Super-Junction）结构，故又称超结功率MOSFET。工作电压600V～800V，通态电阻几乎降低了一个数量级，仍保持开关速度快的特点，是一种有发展前途的高频功率半导体器件。','网集客服','core@unionnets.com','-','0','-','-','-','-');

/*Table structure for table `{NetsInstall.Db_Tablehead}commpostsdiscuss` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}commpostsdiscuss`;

CREATE TABLE `{NetsInstall.Db_Tablehead}commpostsdiscuss` (
  `copdtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copdtName` varchar(180) default '-' COMMENT '名称',
  `copdtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `copdtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `copdtParid` int(11) default '0' COMMENT '上级或分类ID',
  `copdtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `copdtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `copdtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `copdtCreateBy` int(11) default '0' COMMENT '发布人',
  `copdtCreateTime` datetime default NULL COMMENT '发布时间',
  `copdtTag` varchar(180) default '-' COMMENT '标签',
  `copdtBest` int(2) default '0' COMMENT '最佳回复',
  PRIMARY KEY  (`copdtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}commpostsdiscuss` */

insert  into `{NetsInstall.Db_Tablehead}commpostsdiscuss`(`copdtID`,`copdtName`,`copdtNameStyle`,`copdtNumCode`,`copdtParid`,`copdtRecycle`,`copdtChecked`,`copdtOrderBy`,`copdtCreateBy`,`copdtCreateTime`,`copdtTag`,`copdtBest`) values (1,'项目是一件事情、一项独一无二的任务，也可以理解为是在一定的时间和一定的预算内所要达到的预期目的。','0','N_2010100612154555734',5,0,2,0,1,'2010-12-20 20:10:18','0',0);
insert  into `{NetsInstall.Db_Tablehead}commpostsdiscuss`(`copdtID`,`copdtName`,`copdtNameStyle`,`copdtNumCode`,`copdtParid`,`copdtRecycle`,`copdtChecked`,`copdtOrderBy`,`copdtCreateBy`,`copdtCreateTime`,`copdtTag`,`copdtBest`) values (2,'IGBT刚出现时，电压、电流额定值只有600V、25A。很长一段时间内，耐压水平限于1200V～1700V，经过长时间的探索研究和改进','0','N_2010122117273833950',7,0,2,0,1,'2011-01-19 08:21:24','0',0);

/*Table structure for table `{NetsInstall.Db_Tablehead}commpostsdiscusscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}commpostsdiscusscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}commpostsdiscusscont` (
  `copdctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copdctIndexID` int(11) default '0' COMMENT '主表ID号',
  `copdctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `copdctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `copdctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `copdctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `copdctPower_View` text COMMENT '用户查看权限',
  `copdctSpicalPosition` text COMMENT '特殊位置',
  `copdctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `copdctContent` text COMMENT '内容',
  `copdctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `copdctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `copdctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `copdctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `copdctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `copdctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `copdctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `copdctRemark` text COMMENT '备注',
  PRIMARY KEY  (`copdctID`),
  KEY `copdctIndexID` (`copdctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}commpostsdiscusscont` */

insert  into `{NetsInstall.Db_Tablehead}commpostsdiscusscont`(`copdctID`,`copdctIndexID`,`copdctCode_Positive`,`copdctCode_Negative`,`copdctCode_BePositive`,`copdctCode_BeNegative`,`copdctPower_View`,`copdctSpicalPosition`,`copdctSourceR00`,`copdctContent`,`copdctPublisher_Name`,`copdctPublisher_Email`,`copdctPublisher_Source`,`copdctPublisher_Mobile`,`copdctPublisher_Tele`,`copdctPublisher_Software`,`copdctPublisher_Homepage`,`copdctRemark`) values (1,1,0,0,0,0,'0','0','0','//#Set value<BR>??$tmpDbDescription0=$tmpDbDescriptions;<BR>??$Coun0=0;<BR>??foreach ($tmpDbDescription0 as $tableCell){<BR>???foreach ($tableCell[Columns] as $Column){<BR>????if($Column[stcotName]!=$this->sTable[$Coun0][sttColumnHead].ID &&<BR>?????$Column[stcotName]!=$this->sTable[$Coun0][sttColumnHead].NumCode &&<BR>?????$Column[stcotName]!=$this->sTable[$Coun0][sttColumnHead].CreateBy &&<BR>?????$Column[stcotName]!=$this->sTable[$Coun0][sttColumnHead].CreateTime &&<BR>?????$Column[stcotName]!=$this->sTable[$Coun0][sttColumnHead].IndexID){<BR>?????$tmpAR0=$this->AnalyerRequest($Column[stcotName].Txt,$Column[stcoctDefaultValue],1);<BR>?????$tmpDbDescriptions[$Coun0][Columns][$Column[stcotName]][Value]=$tmpAR0[0];<BR>????}<BR>???}<BR>???$Coun0++;<BR>??}','网集客服','core@unionnets.com','../../../Uploadfiles/ParameterDWHJ_041002.jpg','13900000000','86-027-88860813','103762295','unionnets.com','0');
insert  into `{NetsInstall.Db_Tablehead}commpostsdiscusscont`(`copdctID`,`copdctIndexID`,`copdctCode_Positive`,`copdctCode_Negative`,`copdctCode_BePositive`,`copdctCode_BeNegative`,`copdctPower_View`,`copdctSpicalPosition`,`copdctSourceR00`,`copdctContent`,`copdctPublisher_Name`,`copdctPublisher_Email`,`copdctPublisher_Source`,`copdctPublisher_Mobile`,`copdctPublisher_Tele`,`copdctPublisher_Software`,`copdctPublisher_Homepage`,`copdctRemark`) values (2,2,0,0,0,0,'0','0','0','IGBT刚出现时，电压、电流额定值只有600V、25A。很长一段时间内，耐压水平限于1200V～1700V，经过长时间的探索研究和改进，现在 IGBT的电压、电流额定值已分别达到3300V/1200A和4500V/1800A，高压IGBT单片耐压已达到6500V，一般IGBT的工作频率上限为20kHz～40kHz，基于穿通（PT）型结构应用新技术制造的IGBT，可工作于150kHz（硬开关）和300kHz（软开关）。\r\n\r\n　　IGBT的技术进展实际上是通态压降，快速开关和高耐压能力三者的折中。随着工艺和结构形式的不同，IGBT在20年历史发展进程中，有以下几种类型：穿通（PT）型、非穿通（NPT）型、软穿通（SPT）型、沟漕型和电场截止（FS）型。\r\n\r\n　　碳化硅SiC是功率半导体器件晶片的理想材料，其优点是：禁带宽、工作温度高（可达600℃）、热稳定性好、通态电阻小、导热性能好、漏电流极小、PN结耐压高等，有利于制造出耐高温的高频大功率半导体器件。\r\n\r\n　　可以预见，碳化硅将是21世纪最可能成功应用的新型功率半导体器件材料。\r\n\r\n　　关注点二：开关电源功率密度\r\n\r\n　　提高开关电源的功率密度，使之小型化、轻量化，是人们不断努力追求的目标。电源的高频化是国际电力电子界研究的热点之一。电源的小型化、减轻重量对便携式电子设备（如移动电话，数字相机等）尤为重要。使开关电源小型化的具体办法有：\r\n\r\n　　一是高频化。为了实现电源高功率密度，必须提高PWM变换器的工作频率、从而减小电路中储能元件的体积重量。\r\n\r\n　　二是应用压电变压器。应用压电变压器可使高频功率变换器实现轻、小、薄和高功率密度。压电变压器利用压电陶瓷材料特有的\"电压-振动\"变换和\"振动-电压\"变换的性质传送能量，其等效电路如同一个串并联谐振电路，是功率变换领域的研究热点之一。\r\n\r\n　　三是采用新型电容器。为了减小电力电子设备的体积和重量，必须设法改进电容器的性能，提高能量密度，并研究开发适合于电力电子及电源系统用的新型电容器，要求电容量大、等效串联电阻ESR小、体积小等。\r\n\r\n　　关注点三：高频磁与同步整流技术\r\n\r\n　　电源系统中应用大量磁元件，高频磁元件的材料、结构和性能都不同于工频磁元件，有许多问题需要研究。对高频磁元件所用磁性材料有如下要求：损耗小，散热性能好，磁性能优越。适用于兆赫级频率的磁性材料为人们所关注，纳米结晶软磁材料也已开发应用。\r\n\r\n　　高频化以后，为了提高开关电源的效率，必须开发和应用软开关技术。它是过去几十年国际电源界的一个研究热点。\r\n\r\n　　对于低电压、大电流输出的软开关变换器，进一步提高其效率的措施是设法降低开关的通态损耗。例如同步整流SR技术，即以功率MOS管反接作为整流用开关二极管，代替萧特基二极管（SBD），可降低管压降，从而提高电路效率。\r\n\r\n　　关注点四：分布电源结构\r\n\r\n　　分布电源系统适合于用作超高速集成电路组成的大型工作站（如图像处理站）、大型数字电子交换系统等的电源，其优点是：可实现DC/DC变换器组件模块化；容易实现N+1功率冗余，易于扩增负载容量；可降低48V母线上的电流和电压降；容易做到热分布均匀、便于散热设计；瞬态响应好；可在线更换失效模块等。\r\n\r\n　　现在分布电源系统有两种结构类型，一是两级结构，另一种是三级结构。\r\n\r\n　　关注点五：PFC变换器\r\n\r\n　　由于AC/DC变换电路的输入端有整流元件和滤波电容，在正弦电压输入时，单相整流电源供电的电子设备，电网侧（交流输入端）功率因数仅为 0.6～0.65。采用PFC（功率因数校正）变换器，网侧功率因数可提高到0.95～0.99，输入电流THD小于10%。既治理了电网的谐波污染，又提高了电源的整体效率。这一技术称为有源功率因数校正APFC单相APFC国内外开发较早，技术已较成熟；三相APFC的拓扑类型和控制策略虽然已经有很多种，但还有待继续研究发展。','网集客服','core@unionnets.com','-','-','-','-','-','0');

/*Table structure for table `{NetsInstall.Db_Tablehead}commpostsgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}commpostsgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}commpostsgroup` (
  `copgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copgtName` varchar(180) default '-' COMMENT '名称',
  `copgtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `copgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `copgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `copgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `copgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `copgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `copgtCreateBy` int(11) default '0' COMMENT '发布人',
  `copgtCreateTime` datetime default NULL COMMENT '发布时间',
  `copgtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`copgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}commpostsgroup` */

insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (1,'ROOT','-','-',0,0,2,31,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (2,'网集分类','-','-',1,0,2,30,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (3,'营销综合专区','-','-',2,0,2,29,0,'2010-10-05 15:26:22','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (4,'网站建设','-','-',2,0,2,28,0,'2010-10-05 14:22:28','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (5,'讨论区一','-','-',3,0,2,27,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (6,'讨论区二','-','-',3,0,2,26,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (7,'网商人才','-','N_2010100514224016931',2,0,2,25,1,'2010-10-05 14:22:40','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (8,'休闲广场','-','N_2010100514261622485',2,0,2,24,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (9,'论坛管理','-','N_2010100514261676077',2,0,2,23,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (10,'论坛事务','-','N_2010100514261641033',9,0,2,22,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (11,'版主专区','-','N_2010100514261675997',9,0,2,21,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (12,'回收站','-','N_2010100514261648010',9,0,2,20,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (13,'灌水专区','-','N_2010100514261639541',8,0,2,19,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (14,'职场生活','-','N_2010100514261614898',8,0,2,18,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (15,'情感生活','-','N_2010100514261658505',8,0,2,17,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (16,'影音娱乐','-','N_2010100514261647558',8,0,2,16,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (17,'贴图专区','-','N_2010100514261671560',8,0,2,15,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (18,'网商充电','-','N_2010100514261761224',7,0,2,14,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (19,'求职招聘','-','N_2010100514261739254',7,0,2,13,1,'2010-10-05 14:28:42','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (20,'资料下载','-','N_2010100514261755505',7,0,2,12,1,'2010-10-05 14:30:59','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (21,'网站建设技术','-','N_2010100514261719009',4,0,2,11,1,'2010-10-05 14:30:59','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (22,'网站优化技术','-','N_2010100514261789385',4,0,2,10,1,'2010-10-05 14:30:59','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (23,'WAP建站技术','-','N_2010100514261740121',4,0,2,9,1,'2010-10-05 14:30:59','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (24,'网络营销','-','N_2010100514261756225',3,0,2,8,1,'2010-10-05 14:30:59','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (25,'网营天下联盟','-','N_2010100514261778762',3,0,2,7,1,'2010-10-05 14:30:59','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (26,'外贸网络营销','-','N_2010100514261758758',3,0,2,6,1,'2010-10-05 14:30:59','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (27,'行业网络营销','-','N_2010100514261732980',3,0,2,5,1,'2010-10-05 14:30:58','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (28,'网络购物','-','N_2010100514261784094',3,0,2,4,1,'2010-10-05 14:30:58','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (29,'传统营销','-','N_2010100514261797695',3,0,2,3,1,'2010-10-05 14:30:58','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (30,'无线营销','-','N_2010100514261778717',3,0,2,2,1,'2010-10-05 14:30:58','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroup`(`copgtID`,`copgtName`,`copgtNameStyle`,`copgtNumCode`,`copgtParid`,`copgtRecycle`,`copgtChecked`,`copgtOrderBy`,`copgtCreateBy`,`copgtCreateTime`,`copgtTag`) values (31,'网店推广','-','N_2010100514261739706',3,0,2,1,1,'2010-10-05 14:30:58','-');

/*Table structure for table `{NetsInstall.Db_Tablehead}commpostsgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}commpostsgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}commpostsgroupcont` (
  `copgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `copgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `copgctCount_Views` int(11) default '0' COMMENT '查看数',
  `copgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `copgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `copgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `copgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `copgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `copgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `copgctChannelid` text COMMENT '所属频道',
  `copgctModelid_List` int(11) default '0' COMMENT '列表模型',
  `copgctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `copgctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `copgctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `copgctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `copgctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `copgctPower_Public` int(11) default '0' COMMENT '用户发布权限',
  `copgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `copgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `copgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `copgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `copgctMetaDescription` text COMMENT 'MetaDescription',
  `copgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `copgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `copgctSources` text COMMENT '图集',
  `copgctIntroduct` text COMMENT '详细介绍',
  `copgctContent` text COMMENT '内容',
  `copgctRemark` text COMMENT '备注',
  `copgctMasterModerator` text COMMENT '超级版主',
  `copgctModerator` text COMMENT '版主',
  `copgctInfo_MasterModerator` varchar(180) default '-' COMMENT '超级版主文本',
  `copgctInfo_Moderator` varchar(180) default '-' COMMENT '版主文本',
  PRIMARY KEY  (`copgctID`),
  KEY `copgctIndexID` (`copgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}commpostsgroupcont` */

insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (1,1,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'../../../Uploadfiles/m_nimg/twitter-48px.png','-',NULL,NULL,NULL,NULL,NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (2,2,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'../../../Uploadfiles/m_nimg/twitter-48px.png','-',NULL,NULL,NULL,NULL,NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (3,3,0,0,0,0,0,0,0,'0',0,0,0,0,0,0,0,'-','-','-','-','','../../../Uploadfiles/m_nimg/twitter-48px.png','-','','','网络营销版块主要有网络营销论文、网络营销策略、网络营销策划、网络营销方案、网络营销案例等网络营销人学习的资料。','','','','-','营销论文、网络营销策略');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (4,4,0,0,0,0,0,0,0,'0',0,0,0,0,0,0,0,'-','-','-','-','','../../../Uploadfiles/m_nimg/post-it-48px.png','-','','','','',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (5,5,0,3,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'../../../Uploadfiles/m_nimg/twitter-48px.png','-',NULL,NULL,NULL,NULL,NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (6,6,0,3,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'../../../Uploadfiles/m_nimg/post-it-48px.png','-',NULL,NULL,NULL,NULL,NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (7,7,0,0,0,0,0,0,0,'0',0,0,0,0,0,0,0,'-','-','-','-','','../../../Uploadfiles/m_nimg/twitter-48px.png','-','','','','',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (8,8,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/post-it-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (9,9,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/heart-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (10,10,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/post-it-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (11,11,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (12,12,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (13,13,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (14,14,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (15,15,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (16,16,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/heart-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (17,17,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/post-it-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (18,18,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (19,19,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (20,20,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/post-it-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (21,21,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (22,22,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (23,23,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (24,24,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (25,25,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (26,26,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/post-it-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (27,27,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (28,28,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/twitter-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (29,29,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/heart-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (30,30,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/heart-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
insert  into `{NetsInstall.Db_Tablehead}commpostsgroupcont`(`copgctID`,`copgctIndexID`,`copgctCount_Views`,`copgctCount_Info`,`copgctCount_InfoAll`,`copgctCount_Discuss`,`copgctCount_DiscussAll`,`copgctCode_Positive`,`copgctCode_Negative`,`copgctChannelid`,`copgctModelid_List`,`copgctModelid_Detail`,`copgctTemplateid_Home`,`copgctTemplateid_List`,`copgctTemplateid_Detail`,`copgctPower_View`,`copgctPower_Public`,`copgctSmallTitle`,`copgctSmallContent`,`copgctMetaTitle`,`copgctMetaKeyword`,`copgctMetaDescription`,`copgctSourceR00`,`copgctSourceR01`,`copgctSources`,`copgctIntroduct`,`copgctContent`,`copgctRemark`,`copgctMasterModerator`,`copgctModerator`,`copgctInfo_MasterModerator`,`copgctInfo_Moderator`) values (31,31,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,'-','-','-','-','-','../../../Uploadfiles/m_nimg/heart-48px.png','-','-','-','-','-',NULL,NULL,'-','-');
