
/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserdaily` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserdaily`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserdaily` (
  `udtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udtName` varchar(180) default '-' COMMENT '名称',
  `udtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `udtType` int(11) default '0' COMMENT '操作类型:0.登陆,1.登出,2.找回密码,3.注销,4.验证邮箱',
  `udtState` int(2) default '0' COMMENT '找回密码状态:0.已发送,1.已过期,2.已完成',
  `udtCreateBy` int(11) default '0' COMMENT '发布人',
  `udtCreateTime` datetime default NULL COMMENT '发布时间',
  `udtIntroduct` varchar(250) default NULL COMMENT '简单说明',
  `udtValue_STR` varchar(180) default '-' COMMENT '值',
  `udtValue_INT` int(11) default '0' COMMENT '值',
  `udtValue_DECIMAL` decimal(9,2) default '0.00' COMMENT '值',
  PRIMARY KEY  (`udtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserdaily` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserdailycont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserdailycont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserdailycont` (
  `udctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udctIndexID` int(11) default '0' COMMENT '主表ID号',
  `udctIpAddress` varchar(180) default '127.0.0.1' COMMENT '操作IP地址',
  `udctIntroduct` text COMMENT '介绍',
  PRIMARY KEY  (`udctID`),
  KEY `umdctIndexID` (`udctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserdailycont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserdepartment` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserdepartment`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserdepartment` (
  `udeptID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udeptName` varchar(180) default '-' COMMENT '名称',
  `udeptNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `udeptNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `udeptUnitid` int(11) default '0' COMMENT '部门所在单位',
  `udeptParid` int(11) default '0' COMMENT '上级部门ID',
  `udeptRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `udeptChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `udeptOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `udeptCreateBy` int(11) default '0' COMMENT '发布人',
  `udeptCreateTime` datetime default NULL COMMENT '发布时间',
  `udeptPassTime` datetime default NULL COMMENT '部门过期时间',
  `udeptTag` varchar(180) default '-' COMMENT '部门标签',
  `udeptParentid` int(11) default '0',
  PRIMARY KEY  (`udeptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserdepartment` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserdepartmentconfig` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserdepartmentconfig`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserdepartmentconfig` (
  `udepcotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udepcotName` varchar(180) default '-' COMMENT '名称',
  `udepcotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `udepcotSign` varchar(180) default '-' COMMENT '标志',
  `udepcotOrderBy` int(9) default '0' COMMENT '排序',
  `udepcotValue` varchar(180) default '-' COMMENT '值',
  `udepcotCreateBy` int(11) default '0' COMMENT '发布人',
  PRIMARY KEY  (`udepcotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserdepartmentconfig` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserdepartmentcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserdepartmentcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserdepartmentcont` (
  `udepctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `udepctIndexID` int(11) default '0' COMMENT '主表ID号',
  `udepctComName` varchar(180) default '-' COMMENT '部门名称',
  `udepctComIdCode` varchar(180) default '-' COMMENT '部门营业证号',
  `udepctComIdCodeSource` varchar(180) default '' COMMENT '部门营业证截图',
  `udepctComIdCodeChecked` int(2) default '0' COMMENT '营业执照认证',
  `udepctComType` varchar(180) default '-' COMMENT '部门类型',
  `udepctComContact` varchar(180) default '-' COMMENT '部门联系人',
  `udepctComContactTele` varchar(180) default '-' COMMENT '部门联系电话',
  `udepctComContactTeleChecked` int(2) default '0' COMMENT '联系电话认证',
  `udepctComZoneChoose` varchar(180) default '-' COMMENT '所在国家',
  `udepctComZoneDetail` varchar(180) default '-' COMMENT '所在省份',
  `udepctComContactAddress` varchar(180) default '-' COMMENT '部门联系地址',
  `udepctComNumCode` varchar(42) default '-' COMMENT '部门联系邮编',
  `udepctComContactWebsite` varchar(180) default '-' COMMENT '部门主页',
  `udepctComContactEmail` varchar(180) default '-' COMMENT '部门电邮',
  `udepctComContactFax` varchar(180) default '-' COMMENT '部门传真',
  `udepctComPersonCount` varchar(42) default '-' COMMENT '员工人数',
  `udepctComYearMoney` varchar(42) default '-' COMMENT '年营业额',
  `udepctComCustomTypes` varchar(180) default '-' COMMENT '主要客户群',
  `udepctComRegisterFund` varchar(180) default '-' COMMENT '注册资金',
  `udepctComManageSystem` varchar(180) default '-' COMMENT '管理体系认证',
  `udepctComBrand` varchar(180) default '-' COMMENT '品牌名称',
  `udepctComRegisterPeople` varchar(180) default '-' COMMENT '法人代表',
  `udepctComCreateTime` varchar(180) default '-' COMMENT '部门成立时间',
  `udepctComProduct` varchar(180) default '-' COMMENT '部门主要产品',
  `udepctComBusinessModel` varchar(180) default '-' COMMENT '经营模式',
  `udepctComLogo` varchar(180) default '-' COMMENT '部门LOGO',
  `udepctComContactIntroduct` text COMMENT '部门说明',
  `udepctWhAble` int(2) default '0' COMMENT '是否开通网店功能',
  `udepctWhName` varchar(180) default '-' COMMENT '网店名称',
  `udepctWhSmallIntroduct` varchar(180) default '-' COMMENT '网店简介',
  `udepctWhSourceR00` varchar(180) default '-' COMMENT '网店图片',
  `udepctWhSourceR01` varchar(180) default '-' COMMENT '网店大图',
  `udepctWhIntroduct` text COMMENT '网店详细介绍',
  `udepctPayAlipay` varchar(180) default '' COMMENT '支付宝帐号',
  `udepctPayChinabank` varchar(180) default '' COMMENT '网银在线帐号',
  `udepctPayTenpay` varchar(180) default '' COMMENT '财务通帐号',
  `udepctPay99Bill` varchar(180) default '' COMMENT '快钱帐号',
  `udepctPayPayChecked` int(2) default '0' COMMENT '支付方式认证',
  `udepctPayBankCode` varchar(180) default '' COMMENT '银行帐号',
  `udepctPayBankName` varchar(180) default '' COMMENT '开户行',
  `udepctPayBankUName` varchar(180) default '' COMMENT '开户人名',
  `udepctPayBankAddress` varchar(180) default '' COMMENT '开户行所在地',
  `udepctPayBankCountry` varchar(180) default '' COMMENT '开户行所在国家',
  `udepctPayBankCountryCode` varchar(180) default '' COMMENT '开户行所在国家编号',
  `udepctPayBankChecked` int(2) default '0' COMMENT '银行认证',
  `udepctEmailSmtpIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Smtp邮件服务器地址',
  `udepctEmailSmtpName` varchar(180) default 'vir@unionNets.com' COMMENT 'Smtp邮件服务器登陆用户名',
  `udepctEmailSmtpPxd` varchar(180) default '123456' COMMENT 'Smtp邮件服务器登陆密码',
  `udepctEmailPop3Able` int(2) default '0' COMMENT '是否开通Pop3功能',
  `udepctEmailPop3Ip` varchar(180) default 'mail.unionNets.com' COMMENT 'Pop3邮件服务器地址',
  `udepctEmailPop3Name` varchar(180) default 'vir@unionNets.com' COMMENT 'Pop3邮件服务器登陆用户名',
  `udepctEmailPop3Pxd` varchar(180) default '123456' COMMENT 'Pop3邮件服务器登陆密码',
  `udepctEmailImapAble` int(2) default '0' COMMENT '是否开通Imap功能',
  `udepctEmailImapIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Imap邮件服务器地址',
  `udepctEmailImapName` varchar(180) default 'vir@unionNets.com' COMMENT 'Imap邮件服务器登陆用户名',
  `udepctEmailImapPxd` varchar(180) default '123456' COMMENT 'Imap邮件服务器登陆密码',
  `udepctEmailChecked` int(2) default '0' COMMENT '电子邮件认证',
  `udepctMapX` varchar(42) default '-' COMMENT '地图X',
  `udepctMapY` varchar(42) default '-' COMMENT '地图Y',
  `udepctMapTagIntroduct` varchar(180) default '-' COMMENT '地图标签上的介绍',
  `udepctCount_Views` int(11) default '0' COMMENT '查看数',
  `udepctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `udepctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `udepctCode_Main` int(11) default '8' COMMENT '总评分',
  `udepctCount_Reply` int(11) default '0' COMMENT '回复数',
  `udepctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `udepctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `udepctChannelid` text COMMENT '所属频道',
  `udepctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `udepctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `udepctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `udepctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `udepctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `udepctPageAble` int(2) default '0' COMMENT '是否分页',
  `udepctPower_View` text COMMENT '用户查看权限',
  `udepctSpicalPosition` text COMMENT '特殊位置',
  `udepctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `udepctSmallContent` varchar(180) default '-' COMMENT '简介',
  `udepctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `udepctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `udepctMetaDescription` text COMMENT 'MetaDescription',
  `udepctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `udepctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `udepctSources` text COMMENT '图集',
  `udepctIntroduct` text COMMENT '详细介绍',
  `udepctContent` text COMMENT '内容',
  `udepctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `udepctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `udepctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `udepctRemark` text COMMENT '备注',
  PRIMARY KEY  (`udepctID`),
  KEY `udepctIndexID` (`udepctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserdepartmentcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsusergrade` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsusergrade`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsusergrade` (
  `ugratID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ugratName` varchar(180) default '-' COMMENT '名称',
  `ugratNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `ugratNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ugratParid` int(11) default '0' COMMENT '上级或分类ID',
  `ugratType` int(5) default '0' COMMENT '类型',
  `ugratRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `ugratChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `ugratOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `ugratCreateBy` int(11) default '0' COMMENT '发布人',
  `ugratCreateTime` datetime default NULL COMMENT '发布时间',
  `ugratTag` varchar(180) default '-' COMMENT '标签',
  `ugratCodeLimit_High` decimal(9,2) default '0.00' COMMENT '上限',
  `ugratCodeLimit_Low` decimal(9,2) default '0.00' COMMENT '下限',
  PRIMARY KEY  (`ugratID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsusergrade` */

insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (1,'ROOT','-','-',0,0,0,2,0,0,'1900-01-01 00:00:00','-','0.00','0.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (2,'网集用户等级','-','-',1,0,0,2,0,0,'1900-01-01 00:00:00','-','0.00','0.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (3,'一般用户','-','-',2,0,0,2,0,0,'1900-01-01 00:00:00','-','0.00','0.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (4,'初级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','100.00','0.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (5,'二级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','500.00','100.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (6,'三级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','1000.00','500.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (7,'中级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','3000.00','1000.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (8,'五级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','5000.00','3000.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (9,'六级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','10000.00','5000.00');
insert  into `{NetsInstall.Db_Tablehead}netsusergrade`(`ugratID`,`ugratName`,`ugratNameStyle`,`ugratNumCode`,`ugratParid`,`ugratType`,`ugratRecycle`,`ugratChecked`,`ugratOrderBy`,`ugratCreateBy`,`ugratCreateTime`,`ugratTag`,`ugratCodeLimit_High`,`ugratCodeLimit_Low`) values (10,'高级用户','-','-',3,0,0,2,0,0,'1900-01-01 00:00:00','-','30000.00','10000.00');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsusergradecont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsusergradecont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsusergradecont` (
  `ugractID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ugractIndexID` int(11) default '0' COMMENT '主表ID号',
  `ugractShopCodeAdd` decimal(9,2) default '0.00' COMMENT '商城加积分比例',
  `ugractShopCodeSub` decimal(9,2) default '0.00' COMMENT '商城减积分比例',
  `ugractShopMoneyAdd` decimal(9,2) default '0.00' COMMENT '商城加价格比例',
  `ugractShopMoneySub` decimal(9,2) default '0.00' COMMENT '商城减价格比例',
  `ugractCommCodeAdd` decimal(9,2) default '0.00' COMMENT '社区加积分比例',
  `ugractCommCodeSub` decimal(9,2) default '0.00' COMMENT '社区减积分比例',
  `ugractCommMoneyAdd` decimal(9,2) default '0.00' COMMENT '社区加价格比例',
  `ugractCommMoneySub` decimal(9,2) default '0.00' COMMENT '社区减价格比例',
  `ugractSortCodeAdd` decimal(9,2) default '0.00' COMMENT '分类信息加积分比例',
  `ugractSortCodeSub` decimal(9,2) default '0.00' COMMENT '分类信息减积分比例',
  `ugractSortMoneyAdd` decimal(9,2) default '0.00' COMMENT '分类信息加价格比例',
  `ugractSortMoneySub` decimal(9,2) default '0.00' COMMENT '分类信息减价格比例',
  `ugractJobCodeAdd` decimal(9,2) default '0.00' COMMENT '招聘加积分比例',
  `ugractJobCodeSub` decimal(9,2) default '0.00' COMMENT '招聘减积分比例',
  `ugractJobMoneyAdd` decimal(9,2) default '0.00' COMMENT '招聘加价格比例',
  `ugractJobMoneySub` decimal(9,2) default '0.00' COMMENT '招聘减价格比例',
  `ugractStoryCodeAdd` decimal(9,2) default '0.00' COMMENT '小说加积分比例',
  `ugractStoryCodeSub` decimal(9,2) default '0.00' COMMENT '小说减积分比例',
  `ugractStoryMoneyAdd` decimal(9,2) default '0.00' COMMENT '小说加价格比例',
  `ugractStoryMoneySub` decimal(9,2) default '0.00' COMMENT '小说减价格比例',
  `ugractCount_Views` int(11) default '0' COMMENT '查看数',
  `ugractCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `ugractCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `ugractCode_Main` int(11) default '8' COMMENT '总评分',
  `ugractCode_Positive` int(11) default '0' COMMENT '正面打分',
  `ugractCode_Negative` int(11) default '0' COMMENT '负面打分',
  `ugractChannelid` text COMMENT '所属频道',
  `ugractPower_View` int(11) default '0' COMMENT '用户查看权限',
  `ugractPower_Public` int(11) default '0' COMMENT '用户发布权限',
  `ugractSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `ugractSmallContent` varchar(180) default '-' COMMENT '简介',
  `ugractMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `ugractMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `ugractMetaDescription` text COMMENT 'MetaDescription',
  `ugractSourceR00` varchar(180) default '-' COMMENT '小图片',
  `ugractSourceR01` varchar(180) default '-' COMMENT '大图片',
  `ugractSources` text COMMENT '图集',
  `ugractIntroduct` text COMMENT '详细介绍',
  `ugractContent` text COMMENT '内容',
  `ugractPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `ugractPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `ugractPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `ugractRemark` text COMMENT '备注',
  PRIMARY KEY  (`ugractID`),
  KEY `ugractIndexID` (`ugractIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsusergradecont` */

insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (1,1,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (2,2,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (3,3,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (4,4,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (5,5,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (6,6,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (7,7,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (8,8,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (9,9,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusergradecont`(`ugractID`,`ugractIndexID`,`ugractShopCodeAdd`,`ugractShopCodeSub`,`ugractShopMoneyAdd`,`ugractShopMoneySub`,`ugractCommCodeAdd`,`ugractCommCodeSub`,`ugractCommMoneyAdd`,`ugractCommMoneySub`,`ugractSortCodeAdd`,`ugractSortCodeSub`,`ugractSortMoneyAdd`,`ugractSortMoneySub`,`ugractJobCodeAdd`,`ugractJobCodeSub`,`ugractJobMoneyAdd`,`ugractJobMoneySub`,`ugractStoryCodeAdd`,`ugractStoryCodeSub`,`ugractStoryMoneyAdd`,`ugractStoryMoneySub`,`ugractCount_Views`,`ugractCount_Info`,`ugractCount_InfoAll`,`ugractCode_Main`,`ugractCode_Positive`,`ugractCode_Negative`,`ugractChannelid`,`ugractPower_View`,`ugractPower_Public`,`ugractSmallTitle`,`ugractSmallContent`,`ugractMetaTitle`,`ugractMetaKeyword`,`ugractMetaDescription`,`ugractSourceR00`,`ugractSourceR01`,`ugractSources`,`ugractIntroduct`,`ugractContent`,`ugractPublisher_Name`,`ugractPublisher_Email`,`ugractPublisher_Source`,`ugractRemark`) values (10,10,'0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00',0,0,0,8,0,0,NULL,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);

/*Table structure for table `{NetsInstall.Db_Tablehead}netsusergroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsusergroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsusergroup` (
  `ugtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ugtName` varchar(180) default '-' COMMENT '名称',
  `ugtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `ugtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ugtParid` int(11) default '0' COMMENT '上级/分组ID',
  `ugtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `ugtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `ugtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `ugtCreateBy` int(11) default '0' COMMENT '发布人',
  `ugtCreateTime` datetime default NULL COMMENT '发布时间',
  `ugtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`ugtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsusergroup` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsusergroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsusergroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsusergroupcont` (
  `ugctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ugctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ugctSysService` text COMMENT '系统服务内容，格式：',
  `ugctPublicCount` text COMMENT '发布数量，格式：',
  `ugctCount_Views` int(11) default '0' COMMENT '查看数',
  `ugctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `ugctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `ugctCode_Main` int(11) default '8' COMMENT '总评分',
  `ugctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `ugctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `ugctChannelid` text COMMENT '所属频道',
  `ugctModelid_List` int(11) default '0' COMMENT '列表模型',
  `ugctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `ugctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `ugctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `ugctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `ugctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `ugctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `ugctSmallContent` varchar(180) default '-' COMMENT '简介',
  `ugctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `ugctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `ugctMetaDescription` text COMMENT 'MetaDescription',
  `ugctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `ugctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `ugctSources` text COMMENT '图集',
  `ugctIntroduct` text COMMENT '详细介绍',
  `ugctContent` text COMMENT '内容',
  `ugctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `ugctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `ugctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `ugctRemark` text COMMENT '备注',
  PRIMARY KEY  (`ugctID`),
  KEY `ugctIndexID` (`ugctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsusergroupcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserinfo` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserinfo`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserinfo` (
  `uitID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uitName` varchar(180) default '-' COMMENT '名称',
  `uitNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `uitNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uitUnitid` int(11) default '0' COMMENT '单位/公司ID',
  `uitDepartmentid` int(11) default '0' COMMENT '用户所在部门ID',
  `uitPositionid` int(11) default '0' COMMENT '职位类型',
  `uitTypeid` int(11) default '0' COMMENT '用户类型ID',
  `uitGradeid` int(11) default '0' COMMENT '用户等级',
  `uitGroupid` int(11) default '0' COMMENT '用户分组',
  `uitRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uitChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uitState` int(5) default '0' COMMENT '用户状态：0一般用户,1临时用户',
  `uitOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uitCreateBy` int(11) default '0' COMMENT '发布人',
  `uitCreateTime` datetime default NULL COMMENT '发布时间',
  `uitPassTime` datetime default NULL COMMENT '到期时间',
  `uitEmail` varchar(180) default '-' COMMENT '电邮',
  `uitPxd` varchar(180) default NULL COMMENT '密码',
  `uitMoney` decimal(9,2) default '0.00' COMMENT '资金数额',
  `uitCode` decimal(9,2) default '0.00' COMMENT '积分',
  `uitExperience` decimal(18,2) default '0.00' COMMENT '经验值',
  `uitTag` varchar(180) default '-' COMMENT '用户的标签',
  `uitNickname` varchar(180) default '-' COMMENT '昵称',
  `uitOnlineState` int(2) default '0' COMMENT '用户在线状态：0不在线,1在线,2离开,3忙碌,4静音,5隐身',
  `uitLoginNumcode` varchar(24) default '0' COMMENT '登陆时加密码：如果用户登陆则为7位随机数',
  `uitInterfaceNumcode` varchar(24) default '0' COMMENT '接口加密码：当次调用接口的加密码，必须与当前用户数据库里的加密码不一致',
  `uitMobile` varchar(180) default '-' COMMENT '手机号码',
  `uitParentid` int(11) default '0' COMMENT '上级用户',
  `uitRecommendid` int(11) default '0' COMMENT '推荐用户ID',
  `uitLoginAPI_Type` int(5) default '0' COMMENT '外部接口类型：0未设置1新浪2腾讯',
  `uitLoginAPI_ID` varchar(180) default '-' COMMENT '外部接口用户名',
  PRIMARY KEY  (`uitID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserinfo` */

insert  into `{NetsInstall.Db_Tablehead}netsuserinfo`(`uitID`,`uitName`,`uitNameStyle`,`uitNumCode`,`uitUnitid`,`uitDepartmentid`,`uitPositionid`,`uitTypeid`,`uitGradeid`,`uitGroupid`,`uitRecycle`,`uitChecked`,`uitState`,`uitOrderBy`,`uitCreateBy`,`uitCreateTime`,`uitPassTime`,`uitEmail`,`uitPxd`,`uitMoney`,`uitCode`,`uitExperience`,`uitTag`,`uitNickname`,`uitOnlineState`,`uitLoginNumcode`,`uitInterfaceNumcode`,`uitMobile`,`uitParentid`,`uitRecommendid`,`uitLoginAPI_Type`,`uitLoginAPI_ID`) values (1,'core@unionnets.com','-','User_2010041616344060350',1,0,0,2,7,0,0,2,0,0,0,'2010-10-02 03:33:32','2900-01-01 00:00:00','core@unionnets.com','e10adc3949ba59abbe56e057f20f883e','0.00','1185.00','0.00','-','网集客服',1,'1292087404','1280525510','15800000000',0,0,0,'-');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserinfoconfig` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserinfoconfig`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserinfoconfig` (
  `uicotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uicotIndexID` int(11) default '0' COMMENT '主表ID号',
  `uicotAppPower_WebsiteName` varchar(180) default '-' COMMENT '应用权限-应该站点名称',
  `uicotAppPower_WebsiteEndtime` varchar(180) default '-' COMMENT '应用权限-应该站点到期时间',
  PRIMARY KEY  (`uicotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserinfoconfig` */


/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserinfocont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserinfocont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserinfocont` (
  `uictID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uictIndexID` int(11) default '0' COMMENT '主表ID号',
  `uictCircles` text COMMENT '用户加入的圈子',
  `uictPxd_Question` varchar(180) default '-' COMMENT '密码提示问题',
  `uictPxd_Answer` varchar(180) default '-' COMMENT '密码提示答案',
  `uictCo_Name` varchar(180) default '-' COMMENT '联系人',
  `uictCo_Sex` int(2) default '0' COMMENT '联系人性别',
  `uictCo_Tele` varchar(180) default '-' COMMENT '联系电话',
  `uictCo_Mobile` varchar(180) default '-' COMMENT '联系手机',
  `uictCo_Fax` varchar(180) default '-' COMMENT '传真',
  `uictCo_Software` varchar(180) default '-' COMMENT '网络通信工具',
  `uictCo_Website` varchar(180) default '-' COMMENT '主页',
  `uictCo_NumCode` varchar(42) default '-' COMMENT '联系邮编',
  `uictCo_ZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `uictCo_ZoneDetail` varchar(180) default '-' COMMENT '填写形式地区信息',
  `uictCo_Address` varchar(180) default '-' COMMENT '联系地址',
  `uictCo_Company` varchar(180) default '-' COMMENT '所在公司名',
  `uictCo_PersPosition` varchar(180) default '-' COMMENT '职位',
  `uictCo_PersSpical` varchar(180) default '-' COMMENT '专长',
  `uictInfo_Hometown` varchar(180) default '-' COMMENT '家乡',
  `uictInfo_Birthday` varchar(180) default '-' COMMENT '生日',
  `uictInfo_Age` int(5) default '0' COMMENT '年龄',
  `uictInfo_BloodType` int(2) default '0' COMMENT '血型',
  `uictInfo_Constellation` int(2) default '0' COMMENT '星座',
  `uictInfo_Marriage` int(2) default '0' COMMENT '婚恋',
  `uictInfo_School` text COMMENT '学校',
  `uictInfo_Hobby` text COMMENT '兴趣爱好',
  `uictInfo_LikeMusic` text COMMENT '喜欢的音乐',
  `uictInfo_LikeMovie` text COMMENT '喜欢的电影',
  `uictInfo_LikeGame` text COMMENT '喜欢的游戏',
  `uictInfo_LikeCartoon` text COMMENT '喜欢的动漫',
  `uictInfo_LikeSport` text COMMENT '喜欢的运动',
  `uictInfo_LikeBook` text COMMENT '喜欢的书籍',
  `uictPostcode` varchar(180) default '-' COMMENT '身份证号',
  `uictPostcodeSource` varchar(180) default '-' COMMENT '身份证截图',
  `uictCoSignature` text COMMENT '个人签名',
  `uictCoIntroduct` text COMMENT '个人说明',
  `uictWhAble` int(2) default '0' COMMENT '是否开通网店功能',
  `uictWhName` varchar(180) default '-' COMMENT '网店名称',
  `uictWhSmallIntroduct` varchar(180) default '-' COMMENT '网店简介',
  `uictWhSourceR00` varchar(180) default '-' COMMENT '图片1',
  `uictWhSourceR01` varchar(180) default '-' COMMENT '图片2',
  `uictWhSources` text COMMENT '网店图集',
  `uictWhIntroduct` text COMMENT '网店介绍',
  `uictTemplatepath_Unit` varchar(180) default 'Place_Unit/default/' COMMENT '企业用户模板路径',
  `uictTemplatepath_Shop` varchar(180) default 'Place_Shop/default/' COMMENT '店铺模板路径',
  `uictTemplatepath_Blog` varchar(180) default 'Place_Blog/default/' COMMENT '个人博客模板路径',
  `uictPayPayChecked` int(2) default '0' COMMENT '支付方式认证',
  `uictPayBankCode` varchar(180) default '' COMMENT '银行帐号',
  `uictPayBankName` varchar(180) default '' COMMENT '开户行',
  `uictPayBankUName` varchar(180) default '' COMMENT '开户人名',
  `uictPayBankAddress` varchar(180) default '' COMMENT '开户行所在地',
  `uictPayBankCountry` varchar(180) default '' COMMENT '开户行所在国家',
  `uictPayBankCountryCode` varchar(180) default '' COMMENT '开户行所在国家编号',
  `uictPayBankCheckedNum` decimal(9,2) default '0.00' COMMENT '银行认证打款金款',
  `uictPayBankCheckedTime` datetime default NULL COMMENT '银行认证款，打款时间',
  `uictEmailSmtpIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Smtp邮件服务器地址',
  `uictEmailSmtpPort` varchar(42) default '25' COMMENT 'Smtp邮件服务器端口号',
  `uictEmailSmtpName` varchar(180) default 'vir@unionNets.com' COMMENT 'Smtp邮件服务器登陆用户名',
  `uictEmailSmtpPxd` varchar(180) default '123456' COMMENT 'Smtp邮件服务器登陆密码',
  `uictEmailPop3Able` int(2) default '0' COMMENT '是否开通Pop3功能',
  `uictEmailPop3Ip` varchar(180) default 'mail.unionNets.com' COMMENT 'Pop3邮件服务器地址',
  `uictEmailPop3Port` varchar(42) default '110' COMMENT 'Pop3邮件服务器端口号',
  `uictEmailPop3Name` varchar(180) default 'vir@unionNets.com' COMMENT 'Pop3邮件服务器登陆用户名',
  `uictEmailPop3Pxd` varchar(180) default '123456' COMMENT 'Pop3邮件服务器登陆密码',
  `uictEmailImapAble` int(2) default '0' COMMENT '是否开通Imap功能',
  `uictEmailImapIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Imap邮件服务器地址',
  `uictEmailImapName` varchar(180) default 'vir@unionNets.com' COMMENT 'Imap邮件服务器登陆用户名',
  `uictEmailImapPxd` varchar(180) default '123456' COMMENT 'Imap邮件服务器登陆密码',
  `uictMapX` varchar(42) default '-' COMMENT '地图X',
  `uictMapY` varchar(42) default '-' COMMENT '地图Y',
  `uictMapTagIntroduct` varchar(42) default '-' COMMENT '地图标签上的介绍',
  `uictInterface_Pxd` varchar(180) default '-' COMMENT '接口用户加密码',
  `uictCount_Views` int(11) default '0' COMMENT '查看数',
  `uictCount_Reply` int(11) default '0' COMMENT '回复数',
  `uictCode_Main` int(11) default '8' COMMENT '总评分',
  `uictCode_Positive` int(11) default '0' COMMENT '正面打分',
  `uictCode_Negative` int(11) default '0' COMMENT '负面打分',
  `uictChannelid` text COMMENT '所属频道',
  `uictModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `uictTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `uictDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `uictKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `uictKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `uictPower_View` text COMMENT '用户查看权限',
  `uictPower_ColumnsView` text COMMENT '用户信息设置选项',
  `uictSpicalPosition` text COMMENT '特殊位置',
  `uictSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `uictSmallContent` varchar(180) default '-' COMMENT '简介',
  `uictMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `uictMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `uictMetaDescription` text COMMENT 'MetaDescription',
  `uictSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uictSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uictSources` text COMMENT '图集',
  `uictIntroduct` text COMMENT '详细介绍',
  `uictContent` text COMMENT '内容',
  `uictPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `uictPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `uictPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `uictRemark` text COMMENT '备注',
  `uictInfo_Zodiac` int(2) default '0' COMMENT '过期后的链接地址',
  `uictTemplatepath_Microblogging` varchar(180) default 'Place_Microblogging/default/' COMMENT '个人微博模板路径',
  `uictChecked_Mobile` int(2) default '0' COMMENT '手机认证',
  `uictChecked_Postcode` int(2) default '0' COMMENT '身份证认证',
  `uictChecked_Bank` int(2) default '0' COMMENT '银行认证',
  `uictChecked_Email` int(2) default '0' COMMENT '电子邮件认证',
  `uictChecked_Pay` int(2) default '0' COMMENT '支付方式认证',
  `uictPayAlipay` varchar(180) default '' COMMENT '支付宝帐号',
  `uictPayChinabank` varchar(180) default '' COMMENT '网银在线帐号',
  `uictPayTenpay` varchar(180) default '' COMMENT '财务通帐号',
  `uictPay99Bill` varchar(180) default '' COMMENT '快钱帐号',
  `uictPayYeepay` varchar(180) default '' COMMENT '易宝帐号',
  `uictPayPaypal` varchar(180) default '' COMMENT 'PayPal贝宝帐号',
  `uictPayType` int(9) default '0' COMMENT '支付方式类型',
  `uictPayCode` varchar(180) default NULL COMMENT '支付帐号',
  `uictInfo_Credit` int(11) default '0' COMMENT '信用等级',
  `uuctInfo_Credit` int(11) default '0' COMMENT '信用等级',
  PRIMARY KEY  (`uictID`),
  KEY `uictIndexID` (`uictIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserinfocont` */

insert  into `{NetsInstall.Db_Tablehead}netsuserinfocont`(`uictID`,`uictIndexID`,`uictCircles`,`uictPxd_Question`,`uictPxd_Answer`,`uictCo_Name`,`uictCo_Sex`,`uictCo_Tele`,`uictCo_Mobile`,`uictCo_Fax`,`uictCo_Software`,`uictCo_Website`,`uictCo_NumCode`,`uictCo_ZoneChoose`,`uictCo_ZoneDetail`,`uictCo_Address`,`uictCo_Company`,`uictCo_PersPosition`,`uictCo_PersSpical`,`uictInfo_Hometown`,`uictInfo_Birthday`,`uictInfo_Age`,`uictInfo_BloodType`,`uictInfo_Constellation`,`uictInfo_Marriage`,`uictInfo_School`,`uictInfo_Hobby`,`uictInfo_LikeMusic`,`uictInfo_LikeMovie`,`uictInfo_LikeGame`,`uictInfo_LikeCartoon`,`uictInfo_LikeSport`,`uictInfo_LikeBook`,`uictPostcode`,`uictPostcodeSource`,`uictCoSignature`,`uictCoIntroduct`,`uictWhAble`,`uictWhName`,`uictWhSmallIntroduct`,`uictWhSourceR00`,`uictWhSourceR01`,`uictWhSources`,`uictWhIntroduct`,`uictTemplatepath_Unit`,`uictTemplatepath_Shop`,`uictTemplatepath_Blog`,`uictPayPayChecked`,`uictPayBankCode`,`uictPayBankName`,`uictPayBankUName`,`uictPayBankAddress`,`uictPayBankCountry`,`uictPayBankCountryCode`,`uictPayBankCheckedNum`,`uictPayBankCheckedTime`,`uictEmailSmtpIp`,`uictEmailSmtpPort`,`uictEmailSmtpName`,`uictEmailSmtpPxd`,`uictEmailPop3Able`,`uictEmailPop3Ip`,`uictEmailPop3Port`,`uictEmailPop3Name`,`uictEmailPop3Pxd`,`uictEmailImapAble`,`uictEmailImapIp`,`uictEmailImapName`,`uictEmailImapPxd`,`uictMapX`,`uictMapY`,`uictMapTagIntroduct`,`uictInterface_Pxd`,`uictCount_Views`,`uictCount_Reply`,`uictCode_Main`,`uictCode_Positive`,`uictCode_Negative`,`uictChannelid`,`uictModelid_Detail`,`uictTemplateid_Detail`,`uictDiscussAble`,`uictKeywordAble`,`uictKeywordContent`,`uictPower_View`,`uictPower_ColumnsView`,`uictSpicalPosition`,`uictSmallTitle`,`uictSmallContent`,`uictMetaTitle`,`uictMetaKeyword`,`uictMetaDescription`,`uictSourceR00`,`uictSourceR01`,`uictSources`,`uictIntroduct`,`uictContent`,`uictPublisher_Name`,`uictPublisher_Email`,`uictPublisher_Source`,`uictRemark`,`uictInfo_Zodiac`,`uictTemplatepath_Microblogging`,`uictChecked_Mobile`,`uictChecked_Postcode`,`uictChecked_Bank`,`uictChecked_Email`,`uictChecked_Pay`,`uictPayAlipay`,`uictPayChinabank`,`uictPayTenpay`,`uictPay99Bill`,`uictPayYeepay`,`uictPayPaypal`,`uictPayType`,`uictPayCode`,`uictInfo_Credit`,`uuctInfo_Credit`) values (1,1,'-','-','-','-',0,'-','158000000000','-','-','-','-','-','-','-','-','-','-','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-',0,'-','-','-','-','-','-','Place_Unit/default/','Place_Shop/default/','Place_Blog/microblogging_default/',0,'1111111111111111111111','111111111111111111111','111111111111111111111','1111111111111111111112','','','0.00','2011-01-01 16:03:33','mail.unionNets.com','25','vir@unionNets.com','123456',0,'mail.unionNets.com','110','vir@unionNets.com','123456',0,'mail.unionNets.com','vir@unionNets.com','123456','-','-','-','-',0,0,8,0,0,'-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,'Place_Microblogging/default/',1,1,1,2,1,'','','','','','',0,NULL,0,0);

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserinfohabits` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserinfohabits`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserinfohabits` (
  `uihtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uihtName` varchar(180) default '-' COMMENT '名称',
  `uihtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `uihtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uihtParid` int(11) default '0' COMMENT '上级或分类ID',
  `uihtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uihtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uihtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uihtCreateBy` int(11) default '0' COMMENT '发布人',
  `uihtCreateTime` datetime default NULL COMMENT '发布时间',
  `uihtFlag` varchar(180) default '-' COMMENT '标志名称，如：Order_Userreceiveaddress',
  `uihtValue` text COMMENT '习惯值',
  `uihtType` int(5) default '0' COMMENT '类型',
  PRIMARY KEY  (`uihtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserinfohabits` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserinfohabitscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserinfohabitscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserinfohabitscont` (
  `uihctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uihctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uihctCount_Views` int(11) default '0' COMMENT '查看数',
  `uihctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `uihctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `uihctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `uihctChannelid` text COMMENT '所属频道',
  `uihctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `uihctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `uihctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `uihctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `uihctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `uihctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `uihctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `uihctPageAble` int(2) default '0' COMMENT '是否分页',
  `uihctPower_View` text COMMENT '用户查看权限',
  `uihctPower_Public` text COMMENT '用户发布权限',
  `uihctSpicalPosition` text COMMENT '特殊位置',
  `uihctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `uihctSmallContent` varchar(180) default '-' COMMENT '简介',
  `uihctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `uihctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `uihctMetaDescription` text COMMENT 'MetaDescription',
  `uihctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uihctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uihctSources` text COMMENT '图集',
  `uihctIntroduct` text COMMENT '详细介绍',
  `uihctContent` text COMMENT '内容',
  `uihctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `uihctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `uihctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `uihctRemark` text COMMENT '备注',
  PRIMARY KEY  (`uihctID`),
  KEY `uihctIndexID` (`uihctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserinfohabitscont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuseroperatingdaily` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuseroperatingdaily`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuseroperatingdaily` (
  `uodtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uodtName` varchar(180) default '-' COMMENT '名称',
  `uodtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uodtType` int(2) default '0' COMMENT '操作类型',
  `uodtState` int(2) default '0' COMMENT '操作状态',
  `uodtCreateBy` int(11) default '0' COMMENT '发布人',
  `uodtCreateTime` datetime default NULL COMMENT '发布时间',
  `uodtIntroduct` varchar(250) default '-' COMMENT '简单说明',
  `uodtValue` varchar(180) default NULL COMMENT '值',
  PRIMARY KEY  (`uodtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuseroperatingdaily` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuseroperatingdailycont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuseroperatingdailycont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuseroperatingdailycont` (
  `uoodctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uodctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uodctIpAddress` varchar(180) default '127.0.0.1' COMMENT '操作IP地址',
  `uodctIntroduct` text COMMENT '介绍',
  PRIMARY KEY  (`uoodctID`),
  KEY `uodctIndexID` (`uodctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuseroperatingdailycont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuseroperation` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuseroperation`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuseroperation` (
  `uotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uotName` varchar(180) default '-' COMMENT '名称',
  `uotNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `uotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uotParid` int(11) default '0' COMMENT '上级或分类ID',
  `uotRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uotChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uotOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uotCreateBy` int(11) default '0' COMMENT '发布人',
  `uotCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`uotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuseroperation` */

insert  into `{NetsInstall.Db_Tablehead}netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (1,'登陆','-','N_2010101400043349139',3,0,2,0,1,'2010-10-14 00:04:33');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (2,'注册','-','N_201010140004339494',3,0,2,0,1,'2010-10-14 00:04:33');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (3,'找加密码','-','N_2010101400043349084',3,0,2,0,1,'2010-10-14 00:04:33');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (4,'完善用户资料','-','N_201010140004336631',3,0,2,0,1,'2010-10-14 00:04:33');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (5,'发布文档','-','N_2010101400043377691',4,0,2,0,1,'2010-10-14 00:04:33');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperation`(`uotID`,`uotName`,`uotNameStyle`,`uotNumCode`,`uotParid`,`uotRecycle`,`uotChecked`,`uotOrderBy`,`uotCreateBy`,`uotCreateTime`) values (6,'评论文档','-','N_2010101400043352938',4,0,2,0,1,'2010-10-14 00:04:33');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuseroperationcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuseroperationcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuseroperationcont` (
  `uoctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uoctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uoctType` int(5) default '0' COMMENT '类型',
  `uoctSign` varchar(180) default '-' COMMENT '标志',
  `uoctTypeNum` varchar(42) default '10000' COMMENT '类型号：5位以上',
  `uoctTimeLong` int(11) default '0' COMMENT '周期长度',
  `uoctRepeate` int(9) default '0' COMMENT '可重复次数',
  `uoctCode_Code` decimal(9,2) default '0.00' COMMENT '分数',
  `uoctCode_Max` decimal(9,2) default '0.00' COMMENT '分数上限',
  `uoctCode_Min` decimal(9,2) default '0.00' COMMENT '分数下限',
  `uoctCode_Rare` decimal(9,2) default '0.00' COMMENT '分类递增或递减，最大100，最小0',
  `uoctPower_View` text COMMENT '用户查看权限',
  `uoctSpicalPosition` text COMMENT '特殊位置',
  `uoctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uoctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uoctIntroduct` text COMMENT '介绍',
  `uoctContent` text COMMENT '内容',
  `uoctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`uoctID`),
  KEY `uoctIndexID` (`uoctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuseroperationcont` */

insert  into `{NetsInstall.Db_Tablehead}netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (1,1,0,'Nets_User_Login','-',0,0,'5.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (2,2,0,'Nets_User_Register','-',0,0,'30.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (3,3,0,'Nets_User_FindPxd','-',0,0,'2.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (4,4,0,'Nets_User_Info_Complete','-',0,0,'50.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (5,5,0,'Cms_Doc_Public','-',0,0,'10.00','0.00','0.00','0.00','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationcont`(`uoctID`,`uoctIndexID`,`uoctType`,`uoctSign`,`uoctTypeNum`,`uoctTimeLong`,`uoctRepeate`,`uoctCode_Code`,`uoctCode_Max`,`uoctCode_Min`,`uoctCode_Rare`,`uoctPower_View`,`uoctSpicalPosition`,`uoctSourceR00`,`uoctSourceR01`,`uoctIntroduct`,`uoctContent`,`uoctRemark`) values (6,6,0,'Cms_DocDiscuss_Public','-',0,0,'2.00','0.00','0.00','0.00','-','-','-','-','-','-','-');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuseroperationgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuseroperationgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuseroperationgroup` (
  `uogtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uogtName` varchar(180) default '-' COMMENT '名称',
  `uogtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `uogtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uogtParid` int(11) default '0' COMMENT '上级或分类ID',
  `uogtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uogtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uogtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uogtCreateBy` int(11) default '0' COMMENT '发布人',
  `uogtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`uogtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuseroperationgroup` */

insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (1,'ROOT','-','N_2010101323560279507',0,0,2,0,1,'2010-10-13 23:56:02');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (2,'网集积分操作','-','N_201010132356028673',1,0,2,0,1,'2010-10-13 23:56:14');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (3,'用户操作','-','N_2010101323560267416',2,0,2,0,1,'2010-10-13 23:56:02');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (4,'文档','-','N_2010101323560256372',2,0,2,0,1,'2010-10-13 23:56:02');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (5,'社区','-','N_2010101323560219729',2,0,2,0,1,'2010-10-13 23:57:54');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroup`(`uogtID`,`uogtName`,`uogtNameStyle`,`uogtNumCode`,`uogtParid`,`uogtRecycle`,`uogtChecked`,`uogtOrderBy`,`uogtCreateBy`,`uogtCreateTime`) values (6,'商城','0','N_2010101323584949642',2,0,0,0,0,'2010-10-13 23:59:03');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont` (
  `uogctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uogctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uogctPower_View` text COMMENT '用户查看权限',
  `uogctSpicalPosition` text COMMENT '特殊位置',
  `uogctIntroduct` text COMMENT '介绍',
  `uogctContent` text COMMENT '内容',
  `uogctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`uogctID`),
  KEY `uogctIndexID` (`uogctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont` */

insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (1,1,'-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (2,2,'0','0','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (3,3,'-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (4,4,'-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (5,5,'0','0','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}netsuseroperationgroupcont`(`uogctID`,`uogctIndexID`,`uogctPower_View`,`uogctSpicalPosition`,`uogctIntroduct`,`uogctContent`,`uogctRemark`) values (6,6,'0','0','0','0','0');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuseroperationrecord` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuseroperationrecord`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuseroperationrecord` (
  `uortID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uortName` varchar(180) default '-' COMMENT '名称',
  `uortNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uortParid` int(11) default '0' COMMENT '操作ID',
  `uortType` int(11) default '0' COMMENT '操作类型:0.登陆,1.登出,2.找回密码,3.注销',
  `uortState` int(2) default '0' COMMENT '找回密码状态:0.已发送，未找回,1.已过期,2.已找回',
  `uortCreateBy` int(11) default '0' COMMENT '发布人',
  `uortCreateTime` datetime default NULL COMMENT '发布时间',
  `uortIntroduct` varchar(250) default NULL COMMENT '简单说明',
  `uortValue_STR` varchar(180) default '-' COMMENT '值',
  `uortValue_INT` int(11) default '0' COMMENT '值',
  `uortValue_DECIMAL` decimal(9,2) default '0.00' COMMENT '值',
  PRIMARY KEY  (`uortID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuseroperationrecord` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuseroperationrecordcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuseroperationrecordcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuseroperationrecordcont` (
  `uorctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uorctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uorctIpAddress` varchar(180) default '127.0.0.1' COMMENT '操作IP地址',
  `uorctIntroduct` text COMMENT '介绍',
  PRIMARY KEY  (`uorctID`),
  KEY `uorctIndexID` (`uorctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuseroperationrecordcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserservice` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserservice`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserservice` (
  `ustID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ustName` varchar(180) default '-' COMMENT '名称',
  `ustNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ustServiceid` int(11) default '0' COMMENT '服务名ID',
  `ustUserid` int(11) default '0' COMMENT '服务所属人ID',
  `ustCreateBy` int(11) default '0' COMMENT '发布人',
  `ustCreateTime` datetime default NULL COMMENT '发布时间',
  `ustPassTime` int(9) default '0' COMMENT '有效天数',
  PRIMARY KEY  (`ustID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserservice` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserservicecont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserservicecont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserservicecont` (
  `usctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `usctIndexID` int(11) default '0' COMMENT '主表ID号',
  `SourceR00` varchar(180) default '-' COMMENT '小图片',
  `Introduct` text COMMENT '详细介绍',
  `Content` text COMMENT '内容',
  `Remark` text COMMENT '备注',
  PRIMARY KEY  (`usctID`),
  KEY `usctIndexID` (`usctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserservicecont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserteam` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserteam`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserteam` (
  `utetID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utetName` varchar(180) default '-' COMMENT '名称',
  `utetNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `utetNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `utetParid` int(11) default '0' COMMENT '上级或分类ID',
  `utetRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `utetChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `utetOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `utetCreateBy` int(11) default '0' COMMENT '发布人',
  `utetCreateTime` datetime default NULL COMMENT '发布时间',
  `utetTag` varchar(180) default '-' COMMENT '标签',
  `utetUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  `utetUserPublicGroupid` int(11) default '0' COMMENT '用户分类：0.管理员发布的,1.用户发布的，发布到个人博客,2.用户发布的，发布到企业网站,3.用户发布的，发布到企业网站和个人博客',
  PRIMARY KEY  (`utetID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserteam` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserteamcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserteamcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserteamcont` (
  `utectID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utectIndexID` int(11) default '0' COMMENT '主表ID号',
  `utectCount_Views` int(11) default '0' COMMENT '查看数',
  `utectCount_Discuss` int(11) default '0' COMMENT '回复数',
  `utectCode_Positive` int(11) default '0' COMMENT '正面打分',
  `utectCode_Negative` int(11) default '0' COMMENT '负面打分',
  `utectChannelid` text COMMENT '所属频道',
  `utectRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `utectRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `utectModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `utectTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `utectDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `utectKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `utectKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `utectPageAble` int(2) default '0' COMMENT '是否分页',
  `utectPower_View` text COMMENT '用户查看权限',
  `utectPower_Public` text COMMENT '用户发布权限',
  `utectSpicalPosition` text COMMENT '特殊位置',
  `utectSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `utectSmallContent` varchar(180) default '-' COMMENT '简介',
  `utectMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `utectMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `utectMetaDescription` text COMMENT 'MetaDescription',
  `utectSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utectSourceR01` varchar(180) default '-' COMMENT '大图片',
  `utectSources` text COMMENT '图集',
  `utectIntroduct` text COMMENT '详细介绍',
  `utectContent` text COMMENT '内容',
  `utectPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `utectPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `utectPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `utectRemark` text COMMENT '备注',
  PRIMARY KEY  (`utectID`),
  KEY `utectIndexID` (`utectIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserteamcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserteamdiscuss` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserteamdiscuss`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserteamdiscuss` (
  `utedtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utedtName` varchar(180) default '-' COMMENT '名称',
  `utedtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `utedtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `utedtParid` int(11) default '0' COMMENT '上级或分类ID',
  `utedtType` int(5) default '0' COMMENT '类型',
  `utedtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `utedtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `utedtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `utedtCreateBy` int(11) default '0' COMMENT '发布人',
  `utedtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`utedtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserteamdiscuss` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserteamdiscusscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserteamdiscusscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserteamdiscusscont` (
  `utedctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utedctIndexID` int(11) default '0' COMMENT '主表ID号',
  `utedctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `utedctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `utedctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `utedctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `utedctPower_View` text COMMENT '用户查看权限',
  `utedctSpicalPosition` text COMMENT '特殊位置',
  `utedctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utedctContent` text COMMENT '内容',
  `utedctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `utedctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `utedctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `utedctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `utedctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `utedctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `utedctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `utedctRemark` text COMMENT '备注',
  PRIMARY KEY  (`utedctID`),
  KEY `utedctIndexID` (`utedctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserteamdiscusscont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserteamgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserteamgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserteamgroup` (
  `utegtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utegtName` varchar(180) default '-' COMMENT '名称',
  `utegtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `utegtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `utegtParid` int(11) default '0' COMMENT '上级或分类ID',
  `utegtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `utegtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `utegtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `utegtCreateBy` int(11) default '0' COMMENT '发布人',
  `utegtCreateTime` datetime default NULL COMMENT '发布时间',
  `utegtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`utegtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserteamgroup` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserteamgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserteamgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserteamgroupcont` (
  `utegctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utegctIndexID` int(11) default '0' COMMENT '主表ID号',
  `utegctCount_Views` int(11) default '0' COMMENT '查看数',
  `utegctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `utegctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `utegctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `utegctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `utegctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `utegctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `utegctChannelid` text COMMENT '所属频道',
  `utegctModelid_List` int(11) default '0' COMMENT '列表模型',
  `utegctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `utegctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `utegctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `utegctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `utegctPower_View` text COMMENT '用户查看权限',
  `utegctPower_Public` text COMMENT '用户发布权限',
  `utegctSpicalPosition` text COMMENT '特殊位置',
  `utegctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `utegctSmallContent` varchar(180) default '-' COMMENT '简介',
  `utegctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `utegctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `utegctMetaDescription` text COMMENT 'MetaDescription',
  `utegctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utegctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `utegctSources` text COMMENT '图集',
  `utegctIntroduct` text COMMENT '详细介绍',
  `utegctContent` text COMMENT '内容',
  `utegctRemark` text COMMENT '备注',
  PRIMARY KEY  (`utegctID`),
  KEY `utegctIndexID` (`utegctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserteamgroupcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserteamposition` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserteamposition`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserteamposition` (
  `uteptID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uteptName` varchar(180) default '-' COMMENT '名称',
  `uteptNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `uteptNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uteptParid` int(11) default '0' COMMENT '上级或分类ID',
  `uteptRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uteptChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uteptOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uteptCreateBy` int(11) default '0' COMMENT '发布人',
  `uteptCreateTime` datetime default NULL COMMENT '发布时间',
  `uteptUserids` varchar(180) default '' COMMENT '用户ID',
  PRIMARY KEY  (`uteptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserteamposition` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserteampositioncont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserteampositioncont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserteampositioncont` (
  `utepctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utepctIndexID` int(11) default '0' COMMENT '主表ID号',
  `utepctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `utepctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `utepctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `utepctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `utepctPower_View` text COMMENT '用户查看权限',
  `utepctSpicalPosition` text COMMENT '特殊位置',
  `utepctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utepctContent` text COMMENT '内容',
  `utepctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `utepctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `utepctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `utepctRemark` text COMMENT '备注',
  PRIMARY KEY  (`utepctID`),
  KEY `utepctIndexID` (`utepctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserteampositioncont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsusertype` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsusertype`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsusertype` (
  `uttID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uttName` varchar(180) default '-' COMMENT '名称',
  `uttNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `uttNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uttParid` int(11) default '0' COMMENT '上级或分类ID',
  `uttRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uttChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uttOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uttCreateBy` int(11) default '0' COMMENT '发布人',
  `uttCreateTime` datetime default NULL COMMENT '发布时间',
  `uttType` int(5) default '0' COMMENT '类型:1.格管理员,2.系统管理员,3.管理员,4.用户,5.游客',
  `uttSign` varchar(180) default NULL COMMENT '标志',
  PRIMARY KEY  (`uttID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsusertype` */

insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (1,'ROOT','-','-',0,0,2,0,0,'2010-04-26 21:08:35',0,'-');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (2,'格管理员','-','-',1,0,2,0,0,'2011-01-27 11:58:47',1,'-');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (3,'系统管理员','-','-',1,0,2,0,0,'2010-04-26 21:10:12',2,'-');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (4,'管理员','-','-',1,0,2,0,0,'2011-04-16 19:03:49',3,'-');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (5,'会员','-','-',1,0,2,0,0,'2010-10-01 12:31:53',4,'-');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (6,'游客','-','-',1,0,2,0,0,'2010-04-26 21:10:12',5,'-');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (7,'项目管理用户','','N_2010082104190893353',5,0,2,0,1,'2010-12-02 11:41:56',4,'');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (8,'理财用户','','N_2010082104194791305',5,0,2,0,1,'2010-12-02 11:42:12',4,'');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (9,'项目经理','','N_2010120211424059646',7,0,2,0,1,'2010-12-02 11:44:12',4,'');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (10,'项目员工','','N_2010120211442762591',7,0,2,0,1,'2010-12-02 11:44:27',4,'');
insert  into `{NetsInstall.Db_Tablehead}netsusertype`(`uttID`,`uttName`,`uttNameStyle`,`uttNumCode`,`uttParid`,`uttRecycle`,`uttChecked`,`uttOrderBy`,`uttCreateBy`,`uttCreateTime`,`uttType`,`uttSign`) values (11,'项目客户','','N_2010120211443514242',7,0,2,0,1,'2010-12-02 11:44:35',4,'');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsusertypecont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsusertypecont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsusertypecont` (
  `utctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `utctIndexID` int(11) default '0' COMMENT '主表ID号',
  `utctCount_Views` int(11) default '0' COMMENT '查看数',
  `utctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `utctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `utctZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `utctPower_Menu` text COMMENT '用户菜单权限',
  `utctPower_View` text COMMENT '用户查看权限',
  `utctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `utctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `utctMetaDescription` text COMMENT 'MetaDescription',
  `utctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `utctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `utctSources` text COMMENT '图集',
  `utctIntroduct` text COMMENT '详细介绍',
  `utctContent` text COMMENT '内容',
  `utctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `utctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `utctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `utctRemark` text COMMENT '备注',
  `utctPower_Menu_Mana` text COMMENT '核心管理系统权限',
  `utctPower_Menu_Platform` text COMMENT '管理用户系统权限',
  `utctPower_Menu_QPlatform` text COMMENT '快捷管理用户系统权限',
  `utctPower_Menu_User` text COMMENT '用户菜单权限',
  PRIMARY KEY  (`utctID`),
  KEY `uuctIndexID` (`utctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsusertypecont` */

insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (1,1,0,0,0,'0','0','0','-','-','','-','-','','','','-','-','-','',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (2,2,0,0,0,'0','','0','-','-','-','-','-','-','-','-','-','-','-','-','','0','0','0');
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (3,3,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (4,4,0,0,0,'0','-','0','-','-','-','-','-','-','-','-','-','-','-','-','26,projbug,projbug_view,projbug_add,projbug_modify,projbug_delete,;26,projproject,projproject_view,projproject_add,projproject_modify,projproject_delete,;6,cmsdoc,cmsdoc_add,cmsdoc_modify,cmsdoc_delete,;','','','');
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (5,5,0,0,0,'0','','0','-','-','-','-','-','-','-','-','-','-','-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (6,6,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (7,7,0,0,0,'0','0','0','','','','','','','','','-','-','-','',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (8,8,0,0,0,'0','','0','','','','','','','','','-','-','-','',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (9,9,0,0,0,'0','0','0','','','','','','','','','0','0','0','',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (10,10,0,0,0,'0','0','0','','','','','','','','','0','0','0','',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}netsusertypecont`(`utctID`,`utctIndexID`,`utctCount_Views`,`utctCount_Info`,`utctCount_InfoAll`,`utctZoneChoose`,`utctPower_Menu`,`utctPower_View`,`utctMetaTitle`,`utctMetaKeyword`,`utctMetaDescription`,`utctSourceR00`,`utctSourceR01`,`utctSources`,`utctIntroduct`,`utctContent`,`utctPublisher_Name`,`utctPublisher_Email`,`utctPublisher_Source`,`utctRemark`,`utctPower_Menu_Mana`,`utctPower_Menu_Platform`,`utctPower_Menu_QPlatform`,`utctPower_Menu_User`) values (11,11,0,0,0,'0','0','0','','','','','','','','','0','0','0','',NULL,NULL,NULL,NULL);

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserunit` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserunit`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserunit` (
  `uutID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uutName` varchar(180) default '-' COMMENT '名称',
  `uutNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `uutNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uutParid` int(11) default '0' COMMENT '上级公司ID',
  `uutParentid` int(11) default '0' COMMENT '单位分组',
  `uutRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uutChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uutOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uutCreateBy` int(11) default '0' COMMENT '发布人',
  `uutCreateTime` datetime default NULL COMMENT '发布时间',
  `uutPassTime` datetime default NULL COMMENT '单位过期时间',
  `uutTag` varchar(180) default '-' COMMENT '单位/公司标签',
  PRIMARY KEY  (`uutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserunit` */

insert  into `{NetsInstall.Db_Tablehead}netsuserunit`(`uutID`,`uutName`,`uutNameStyle`,`uutNumCode`,`uutParid`,`uutParentid`,`uutRecycle`,`uutChecked`,`uutOrderBy`,`uutCreateBy`,`uutCreateTime`,`uutPassTime`,`uutTag`) values (1,'网集平台(unionnets.com)','-','Unit_934823954',0,0,0,2,0,0,'2010-01-01 00:00:00','2100-01-01 00:00:00','-');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserunitconfig` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserunitconfig`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserunitconfig` (
  `uucotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uucotName` varchar(180) default '-' COMMENT '名称',
  `uucotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uucotSign` varchar(180) default '-' COMMENT '标志',
  `uucotOrderBy` int(9) default '0' COMMENT '排序',
  `uucotValue` varchar(180) default '-' COMMENT '值',
  `uucotCreateBy` int(11) default '0' COMMENT '发布人',
  PRIMARY KEY  (`uucotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserunitconfig` */

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserunitcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserunitcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserunitcont` (
  `uuctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uuctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uuctComName` varchar(180) default '-' COMMENT '企业名称',
  `uuctComIdCode` varchar(180) default '-' COMMENT '企业营业证号',
  `uuctComIdCodeSource` varchar(180) default '-' COMMENT '企业营业证截图',
  `uuctComIdCodeChecked` int(2) default '0' COMMENT '营业执照认证',
  `uuctComType` varchar(180) default '-' COMMENT '企业类型',
  `uuctComContact` varchar(180) default '-' COMMENT '企业联系人',
  `uuctComContactTele` varchar(180) default '-' COMMENT '企业联系电话',
  `uuctComContactTeleChecked` int(2) default '0' COMMENT '联系方式认证',
  `uuctComContactQQ` varchar(180) default '-' COMMENT '联系人QQ号',
  `uuctComZoneChoose` varchar(180) default '-' COMMENT '选择形式地址',
  `uuctComZoneDetail` varchar(180) default '-' COMMENT '填写形式地址',
  `uuctComContactAddress` varchar(180) default '-' COMMENT '企业联系地址',
  `uuctComNumCode` varchar(42) default '-' COMMENT '企业联系邮编',
  `uuctComContactWebsite` varchar(180) default '-' COMMENT '企业主页',
  `uuctComContactEmail` varchar(180) default '-' COMMENT '企业电邮',
  `uuctComContactFax` varchar(180) default '-' COMMENT '企业传真',
  `uuctComPersonCount` varchar(42) default '-' COMMENT '员工人数',
  `uuctComYearMoney` varchar(42) default '-' COMMENT '年营业额',
  `uuctComCustomTypes` varchar(180) default '-' COMMENT '主要客户群',
  `uuctComRegisterFund` varchar(180) default '-' COMMENT '注册资金',
  `uuctComManageSystem` varchar(180) default '-' COMMENT '管理体系认证',
  `uuctComBrand` varchar(180) default '-' COMMENT '品牌名称',
  `uuctComRegisterPeople` varchar(180) default '-' COMMENT '法人代表',
  `uuctComCreateTime` varchar(180) default '-' COMMENT '公司成立时间',
  `uuctComProduct` varchar(180) default '-' COMMENT '公司主要产品',
  `uuctComBusinessModel` varchar(180) default '-' COMMENT '经营模式',
  `uuctComLogo` varchar(180) default '-' COMMENT '公司LOGO',
  `uuctComContactIntroduct` text COMMENT '企业说明',
  `uuctWhAble` int(2) default '0' COMMENT '是否开通网店功能',
  `uuctWhName` varchar(180) default '-' COMMENT '网店名称',
  `uuctWhSmallIntroduct` varchar(180) default '-' COMMENT '网店简介',
  `uuctWhSourceR00` varchar(180) default '-' COMMENT '网店图片',
  `uuctWhSourceR01` varchar(180) default '-' COMMENT '网店大图',
  `uuctWhSources` text COMMENT '网店图集',
  `uuctWhIntroduct` text COMMENT '网店详细介绍',
  `uuctWhTemplatepath` varchar(180) default 'Unit/default/' COMMENT '企业网站模板路径',
  `uuctPayAlipay` varchar(180) default '' COMMENT '支付宝帐号',
  `uuctPayChinabank` varchar(180) default '' COMMENT '网银在线帐号',
  `uuctPayTenpay` varchar(180) default '' COMMENT '财务通帐号',
  `uuctPay99Bill` varchar(180) default '' COMMENT '快钱帐号',
  `uuctPayPayChecked` int(2) default '0' COMMENT '支付方式认证',
  `uuctPayBankCode` varchar(180) default '' COMMENT '银行帐号',
  `uuctPayBankName` varchar(180) default '' COMMENT '开户行',
  `uuctPayBankUName` varchar(180) default '' COMMENT '开户人名',
  `uuctPayBankAddress` varchar(180) default '' COMMENT '开户行所在地',
  `uuctPayBankCountry` varchar(180) default '' COMMENT '开户行所在国家',
  `uuctPayBankCountryCode` varchar(180) default '' COMMENT '开户行所在国家编号',
  `uuctPayBankChecked` int(2) default '0' COMMENT '银行认证',
  `uuctPayBankCheckedNum` decimal(9,2) default '0.00' COMMENT '银行认证打款金款',
  `uuctPayBankCheckedTime` datetime default NULL COMMENT '银行认证款，打款时间',
  `uuctEmailSmtpIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Smtp邮件服务器地址',
  `uuctEmailSmtpName` varchar(180) default 'vir@unionNets.com' COMMENT 'Smtp邮件服务器登陆用户名',
  `uuctEmailSmtpPxd` varchar(180) default '123456' COMMENT 'Smtp邮件服务器登陆密码',
  `uuctEmailPop3Able` int(2) default '0' COMMENT '是否开通Pop3功能',
  `uuctEmailPop3Ip` varchar(180) default 'mail.unionNets.com' COMMENT 'Pop3邮件服务器地址',
  `uuctEmailPop3Name` varchar(180) default 'vir@unionNets.com' COMMENT 'Pop3邮件服务器登陆用户名',
  `uuctEmailPop3Pxd` varchar(180) default '123456' COMMENT 'Pop3邮件服务器登陆密码',
  `uuctEmailImapAble` int(2) default '0' COMMENT '是否开通Imap功能',
  `uuctEmailImapIp` varchar(180) default 'mail.unionNets.com' COMMENT 'Imap邮件服务器地址',
  `uuctEmailImapName` varchar(180) default 'vir@unionNets.com' COMMENT 'Imap邮件服务器登陆用户名',
  `uuctEmailImapPxd` varchar(180) default '123456' COMMENT 'Imap邮件服务器登陆密码',
  `uuctEmailChecked` int(2) default '0' COMMENT '电子邮件认证',
  `uuctMapX` varchar(42) default '-' COMMENT '地图X',
  `uuctMapY` varchar(42) default '-' COMMENT '地图Y',
  `uuctMapTagIntroduct` varchar(180) default '-' COMMENT '地图标签上的介绍',
  `uuctSysConfig` varchar(180) default NULL COMMENT '单位配置文件符号\n                        这里是用户登陆后，读取所在单位的配置文件，再从配置文件里，读取数据库等重要配置信息\n                        \n                        Access配置\n                        Path,PxdWord\n                        \n                        MySql配置\n                        DbNa',
  `uuctCount_Views` int(11) default '0' COMMENT '查看数',
  `uuctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `uuctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `uuctCode_Main` int(11) default '8' COMMENT '总评分',
  `uuctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `uuctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `uuctChannelid` text COMMENT '所属频道',
  `uuctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `uuctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `uuctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `uuctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `uuctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `uuctPower_View` text COMMENT '用户查看权限',
  `uuctSpicalPosition` text COMMENT '特殊位置',
  `uuctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `uuctSmallContent` varchar(180) default '-' COMMENT '简介',
  `uuctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `uuctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `uuctMetaDescription` text COMMENT 'MetaDescription',
  `uuctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uuctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uuctSources` text COMMENT '图集',
  `uuctIntroduct` text COMMENT '详细介绍',
  `uuctContent` text COMMENT '内容',
  `uuctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `uuctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `uuctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `uuctRemark` text COMMENT '备注',
  PRIMARY KEY  (`uuctID`),
  KEY `uuctIndexID` (`uuctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserunitcont` */

insert  into `{NetsInstall.Db_Tablehead}netsuserunitcont`(`uuctID`,`uuctIndexID`,`uuctComName`,`uuctComIdCode`,`uuctComIdCodeSource`,`uuctComIdCodeChecked`,`uuctComType`,`uuctComContact`,`uuctComContactTele`,`uuctComContactTeleChecked`,`uuctComContactQQ`,`uuctComZoneChoose`,`uuctComZoneDetail`,`uuctComContactAddress`,`uuctComNumCode`,`uuctComContactWebsite`,`uuctComContactEmail`,`uuctComContactFax`,`uuctComPersonCount`,`uuctComYearMoney`,`uuctComCustomTypes`,`uuctComRegisterFund`,`uuctComManageSystem`,`uuctComBrand`,`uuctComRegisterPeople`,`uuctComCreateTime`,`uuctComProduct`,`uuctComBusinessModel`,`uuctComLogo`,`uuctComContactIntroduct`,`uuctWhAble`,`uuctWhName`,`uuctWhSmallIntroduct`,`uuctWhSourceR00`,`uuctWhSourceR01`,`uuctWhSources`,`uuctWhIntroduct`,`uuctWhTemplatepath`,`uuctPayAlipay`,`uuctPayChinabank`,`uuctPayTenpay`,`uuctPay99Bill`,`uuctPayPayChecked`,`uuctPayBankCode`,`uuctPayBankName`,`uuctPayBankUName`,`uuctPayBankAddress`,`uuctPayBankCountry`,`uuctPayBankCountryCode`,`uuctPayBankChecked`,`uuctPayBankCheckedNum`,`uuctPayBankCheckedTime`,`uuctEmailSmtpIp`,`uuctEmailSmtpName`,`uuctEmailSmtpPxd`,`uuctEmailPop3Able`,`uuctEmailPop3Ip`,`uuctEmailPop3Name`,`uuctEmailPop3Pxd`,`uuctEmailImapAble`,`uuctEmailImapIp`,`uuctEmailImapName`,`uuctEmailImapPxd`,`uuctEmailChecked`,`uuctMapX`,`uuctMapY`,`uuctMapTagIntroduct`,`uuctSysConfig`,`uuctCount_Views`,`uuctCount_Info`,`uuctCount_InfoAll`,`uuctCode_Main`,`uuctCode_Positive`,`uuctCode_Negative`,`uuctChannelid`,`uuctModelid_Detail`,`uuctTemplateid_Detail`,`uuctDiscussAble`,`uuctKeywordAble`,`uuctKeywordContent`,`uuctPower_View`,`uuctSpicalPosition`,`uuctSmallTitle`,`uuctSmallContent`,`uuctMetaTitle`,`uuctMetaKeyword`,`uuctMetaDescription`,`uuctSourceR00`,`uuctSourceR01`,`uuctSources`,`uuctIntroduct`,`uuctContent`,`uuctPublisher_Name`,`uuctPublisher_Email`,`uuctPublisher_Source`,`uuctRemark`) values (1,1,'-','-','-',0,'-','-','-',0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',NULL,0,'-','-','-','-',NULL,NULL,'Unit/default/','','','','',0,'','','','','','',0,'0.00',NULL,'mail.unionNets.com','vir@unionNets.com','123456',0,'mail.unionNets.com','vir@unionNets.com','123456',0,'mail.unionNets.com','vir@unionNets.com','123456',0,'-','-','-',NULL,0,0,0,8,0,0,NULL,0,0,0,0,'-',NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,'-','-','-',NULL);

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserunitgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserunitgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserunitgroup` (
  `uugtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uugtName` varchar(180) default '-' COMMENT '名称',
  `uugtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `uugtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `uugtParid` int(11) default '0' COMMENT '上级或分类ID',
  `uugtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `uugtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `uugtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `uugtCreateBy` int(11) default '0' COMMENT '发布人',
  `uugtCreateTime` datetime default NULL COMMENT '发布时间',
  `uugtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`uugtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserunitgroup` */

insert  into `{NetsInstall.Db_Tablehead}netsuserunitgroup`(`uugtID`,`uugtName`,`uugtNameStyle`,`uugtNumCode`,`uugtParid`,`uugtRecycle`,`uugtChecked`,`uugtOrderBy`,`uugtCreateBy`,`uugtCreateTime`,`uugtTag`) values (1,'ROOT','','N_2011031815244710870',0,0,2,0,1,'2011-03-18 15:24:47','0');

/*Table structure for table `{NetsInstall.Db_Tablehead}netsuserunitgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}netsuserunitgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}netsuserunitgroupcont` (
  `uugctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `uugctIndexID` int(11) default '0' COMMENT '主表ID号',
  `uugctCount_Views` int(11) default '0' COMMENT '查看数',
  `uugctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `uugctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `uugctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `uugctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `uugctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `uugctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `uugctChannelid` text COMMENT '所属频道',
  `uugctModelid_List` int(11) default '0' COMMENT '列表模型',
  `uugctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `uugctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `uugctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `uugctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `uugctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `uugctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `uugctSmallContent` varchar(180) default '-' COMMENT '简介',
  `uugctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `uugctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `uugctMetaDescription` text COMMENT 'MetaDescription',
  `uugctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `uugctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `uugctSources` text COMMENT '图集',
  `uugctIntroduct` text COMMENT '详细介绍',
  `uugctContent` text COMMENT '内容',
  `uugctRemark` text COMMENT '备注',
  PRIMARY KEY  (`uugctID`),
  KEY `uugctIndexID` (`uugctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}netsuserunitgroupcont` */

insert  into `{NetsInstall.Db_Tablehead}netsuserunitgroupcont`(`uugctID`,`uugctIndexID`,`uugctCount_Views`,`uugctCount_Info`,`uugctCount_InfoAll`,`uugctCount_Discuss`,`uugctCount_DiscussAll`,`uugctCode_Positive`,`uugctCode_Negative`,`uugctChannelid`,`uugctModelid_List`,`uugctModelid_Detail`,`uugctTemplateid_Home`,`uugctTemplateid_List`,`uugctTemplateid_Detail`,`uugctPower_View`,`uugctSmallTitle`,`uugctSmallContent`,`uugctMetaTitle`,`uugctMetaKeyword`,`uugctMetaDescription`,`uugctSourceR00`,`uugctSourceR01`,`uugctSources`,`uugctIntroduct`,`uugctContent`,`uugctRemark`) values (1,1,0,0,0,0,0,0,0,'0',0,0,0,0,0,0,'0','0','0','0','0','0','0','0','','','');
