
/*Table structure for table `{NetsInstall.Db_Tablehead}cmsadv` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsadv`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsadv` (
  `catID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `catName` varchar(180) default '-' COMMENT '名称',
  `catNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `catParid` int(11) default '0' COMMENT '类型',
  `catRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `catChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `catOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `catCreateBy` int(11) default '0' COMMENT '发布人',
  `catCreateTime` datetime default NULL COMMENT '发布时间',
  `catSign` varchar(42) default '-' COMMENT '表内唯一标识符',
  `catType` int(2) default '0' COMMENT '广告类型',
  `catTimeType` int(2) default '0' COMMENT '广告过期时间类型',
  `catEndTime` datetime default NULL COMMENT '广告过期时间',
  PRIMARY KEY  (`catID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsadv` */

insert  into `{NetsInstall.Db_Tablehead}cmsadv`(`catID`,`catName`,`catNumCode`,`catParid`,`catRecycle`,`catChecked`,`catOrderBy`,`catCreateBy`,`catCreateTime`,`catSign`,`catType`,`catTimeType`,`catEndTime`) values (9,'团购上部_A','N_2010110916141815423',4,0,2,0,1,'2010-11-09 16:15:36','Gsnavigation_Top_A',0,1,'2010-08-18 10:38:47');
insert  into `{NetsInstall.Db_Tablehead}cmsadv`(`catID`,`catName`,`catNumCode`,`catParid`,`catRecycle`,`catChecked`,`catOrderBy`,`catCreateBy`,`catCreateTime`,`catSign`,`catType`,`catTimeType`,`catEndTime`) values (10,'团购首页右铡公告_A','N_2010110916161385946',4,0,2,0,1,'2010-11-09 16:16:13','Gsnavigation_Homeright_A',0,1,'2010-08-18 10:38:47');
insert  into `{NetsInstall.Db_Tablehead}cmsadv`(`catID`,`catName`,`catNumCode`,`catParid`,`catRecycle`,`catChecked`,`catOrderBy`,`catCreateBy`,`catCreateTime`,`catSign`,`catType`,`catTimeType`,`catEndTime`) values (11,'团购首页右铡公告_B','N_2010110916162296969',4,0,2,0,1,'2010-11-09 16:16:22','Gsnavigation_Homeright_B',0,1,'2010-08-18 10:38:47');
insert  into `{NetsInstall.Db_Tablehead}cmsadv`(`catID`,`catName`,`catNumCode`,`catParid`,`catRecycle`,`catChecked`,`catOrderBy`,`catCreateBy`,`catCreateTime`,`catSign`,`catType`,`catTimeType`,`catEndTime`) values (12,'团购首页右铡公告_C','N_2010110916162988671',4,0,2,0,1,'2010-11-09 16:16:29','Gsnavigation_Homeright_C',0,1,'2010-08-18 10:38:47');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsadvcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsadvcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsadvcont` (
  `cactID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cactIndexID` int(11) default '0' COMMENT '主表ID号',
  `cactLink` varchar(180) default '-' COMMENT '广告链接地址',
  `cactWidth` varchar(180) default '0' COMMENT '资源宽度',
  `cactHeight` varchar(180) default '0' COMMENT '资源高度',
  `cactStyle` varchar(180) default '-' COMMENT '文字样式',
  `cactEndLink` varchar(180) default '-' COMMENT '过期后的链接地址',
  `cactEndContent` text COMMENT '广告过期后的内容',
  `cactZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `cactCount_Views` int(11) default '0' COMMENT '查看数',
  `cactSpicalPosition` text COMMENT '特殊位置',
  `cactIntroduct` text COMMENT '详细介绍',
  `cactContent` text COMMENT '内容',
  `cactRemark` text COMMENT '备注',
  `cdtLink` varchar(180) default '-' COMMENT '如果链接不为空，则点标题链到链接所在地址',
  PRIMARY KEY  (`cactID`),
  KEY `cactIndexID` (`cactIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsadvcont` */


insert  into `{NetsInstall.Db_Tablehead}cmsadvcont`(`cactID`,`cactIndexID`,`cactLink`,`cactWidth`,`cactHeight`,`cactStyle`,`cactEndLink`,`cactEndContent`,`cactZoneChoose`,`cactCount_Views`,`cactSpicalPosition`,`cactIntroduct`,`cactContent`,`cactRemark`,`cdtLink`) values (9,9,'#Here','','','','','','1,-1,-1,-1,-1,',0,'0','','../../../Uploadfiles/ADV/Groupsalenavigation_0/Img_2.jpg','','-');
insert  into `{NetsInstall.Db_Tablehead}cmsadvcont`(`cactID`,`cactIndexID`,`cactLink`,`cactWidth`,`cactHeight`,`cactStyle`,`cactEndLink`,`cactEndContent`,`cactZoneChoose`,`cactCount_Views`,`cactSpicalPosition`,`cactIntroduct`,`cactContent`,`cactRemark`,`cdtLink`) values (10,10,'#Here','','','','','','1,-1,-1,-1,-1,',0,'0','','../../../Uploadfiles/ADV/Groupsalenavigation_0/Img_0.jpg','','-');
insert  into `{NetsInstall.Db_Tablehead}cmsadvcont`(`cactID`,`cactIndexID`,`cactLink`,`cactWidth`,`cactHeight`,`cactStyle`,`cactEndLink`,`cactEndContent`,`cactZoneChoose`,`cactCount_Views`,`cactSpicalPosition`,`cactIntroduct`,`cactContent`,`cactRemark`,`cdtLink`) values (11,11,'#Here','','','','','','1,-1,-1,-1,-1,',0,'0','','../../../Uploadfiles/ADV/Groupsalenavigation_0/Img_0.jpg','','-');
insert  into `{NetsInstall.Db_Tablehead}cmsadvcont`(`cactID`,`cactIndexID`,`cactLink`,`cactWidth`,`cactHeight`,`cactStyle`,`cactEndLink`,`cactEndContent`,`cactZoneChoose`,`cactCount_Views`,`cactSpicalPosition`,`cactIntroduct`,`cactContent`,`cactRemark`,`cdtLink`) values (12,12,'#Here','','','','','','1,-1,-1,-1,-1,',0,'0','','../../../Uploadfiles/ADV/Groupsalenavigation_0/Img_0.jpg','','-');


/*Table structure for table `{NetsInstall.Db_Tablehead}cmsadvgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsadvgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsadvgroup` (
  `cagtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cagtName` varchar(180) default '-' COMMENT '名称',
  `cagtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cagtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cagtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cagtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cagtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cagtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cagtCreateBy` int(11) default '0' COMMENT '发布人',
  `cagtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cagtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsadvgroup` */

insert  into `{NetsInstall.Db_Tablehead}cmsadvgroup`(`cagtID`,`cagtName`,`cagtNameStyle`,`cagtNumCode`,`cagtParid`,`cagtRecycle`,`cagtChecked`,`cagtOrderBy`,`cagtCreateBy`,`cagtCreateTime`) values (1,'ROOT','','N_2010110916082154553',0,0,2,0,1,'2010-11-09 16:08:21');
insert  into `{NetsInstall.Db_Tablehead}cmsadvgroup`(`cagtID`,`cagtName`,`cagtNameStyle`,`cagtNumCode`,`cagtParid`,`cagtRecycle`,`cagtChecked`,`cagtOrderBy`,`cagtCreateBy`,`cagtCreateTime`) values (2,'网集广告','','N_2010110916083479983',1,0,2,0,1,'2010-11-09 16:08:34');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsadvgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsadvgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsadvgroupcont` (
  `cagctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cagctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cagctIntroduct` text COMMENT '介绍',
  `cagctContent` text COMMENT '内容',
  `cagctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`cagctID`),
  KEY `cagctIndexID` (`cagctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsadvgroupcont` */

insert  into `{NetsInstall.Db_Tablehead}cmsadvgroupcont`(`cagctID`,`cagctIndexID`,`cagctIntroduct`,`cagctContent`,`cagctRemark`) values (1,1,'','','');
insert  into `{NetsInstall.Db_Tablehead}cmsadvgroupcont`(`cagctID`,`cagctIndexID`,`cagctIntroduct`,`cagctContent`,`cagctRemark`) values (2,2,'','','');





/*Table structure for table `{NetsInstall.Db_Tablehead}cmsdoc` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsdoc`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsdoc` (
  `cdtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdtName` varchar(180) default '-' COMMENT '名称',
  `cdtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cdtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cdtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cdtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cdtType` int(5) default NULL COMMENT '类型',
  `cdtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cdtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cdtCreateBy` int(11) default '0' COMMENT '发布人',
  `cdtCreateTime` datetime default NULL COMMENT '发布时间',
  `cdtTag` varchar(180) default '-' COMMENT '标签',
  `cdtUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  `cdtUserPublicGroupid` int(11) default '0' COMMENT '用户分类：0.管理员发布的,1.用户发布的，发布到个人博客,2.用户发布的，发布到企业网站,3.用户发布的，发布到企业网站和个人博客',
  PRIMARY KEY  (`cdtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsdoc` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsdoccont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsdoccont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsdoccont` (
  `cdctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cdctFrom` varchar(42) default '0' COMMENT '来源',
  `cdctAuthor` varchar(42) default '0' COMMENT '作者',
  `cdctZoneChoose` varchar(180) default '-' COMMENT '选择形式地区信息',
  `cdctEvaluation` text COMMENT '评价或打分',
  `cdctCount_Views` int(11) default '0' COMMENT '查看数',
  `cdctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `cdctCode_Main` int(11) default '8' COMMENT '总评分',
  `cdctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cdctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cdctChannelid` text COMMENT '所属频道',
  `cdctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `cdctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `cdctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `cdctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `cdctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `cdctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `cdctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `cdctPageAble` int(2) default '0' COMMENT '是否分页',
  `cdctPower_View` text COMMENT '用户查看权限',
  `cdctSpicalPosition` text COMMENT '特殊位置',
  `cdctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cdctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cdctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cdctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cdctMetaDescription` text COMMENT 'MetaDescription',
  `cdctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cdctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cdctSources` text COMMENT '图集',
  `cdctIntroduct` text COMMENT '详细介绍',
  `cdctContent` text COMMENT '内容',
  `cdctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cdctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cdctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cdctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cdctID`),
  KEY `cdctIndexID` (`cdctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsdoccont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsdocdiscuss` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsdocdiscuss`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsdocdiscuss` (
  `cddtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cddtName` varchar(180) default '-' COMMENT '名称',
  `cddtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cddtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cddtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cddtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cddtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cddtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cddtCreateBy` int(11) default '0' COMMENT '发布人',
  `cddtCreateTime` datetime default NULL COMMENT '发布时间',
  `cddtType` int(5) default '0' COMMENT '类型',
  PRIMARY KEY  (`cddtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsdocdiscuss` */


/*Table structure for table `{NetsInstall.Db_Tablehead}cmsdocdiscusscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsdocdiscusscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsdocdiscusscont` (
  `cddctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cddctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cddctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cddctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cddctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `cddctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `cddctPower_View` text COMMENT '用户查看权限',
  `cddctSpicalPosition` text COMMENT '特殊位置',
  `cddctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cddctContent` text COMMENT '内容',
  `cddctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cddctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cddctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cddctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `cddctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `cddctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `cddctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `cddctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cddctID`),
  KEY `cddctIndexID` (`cddctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsdocdiscusscont` */








/*Table structure for table `{NetsInstall.Db_Tablehead}cmschannel` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmschannel`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmschannel` (
  `cctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cctName` varchar(180) default '-' COMMENT '名称',
  `cctNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cctNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cctParid` int(11) default '0' COMMENT '上级或分类ID',
  `cctRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cctChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cctOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cctCreateBy` int(11) default '0' COMMENT '发布人',
  `cctCreateTime` datetime default NULL COMMENT '发布时间',
  `cctTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`cctID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmschannel` */

insert  into `{NetsInstall.Db_Tablehead}cmschannel`(`cctID`,`cctName`,`cctNameStyle`,`cctNumCode`,`cctParid`,`cctRecycle`,`cctChecked`,`cctOrderBy`,`cctCreateBy`,`cctCreateTime`,`cctTag`) values (1,'ROOT','-','-',0,0,2,0,0,NULL,'-');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmschannelcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmschannelcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmschannelcont` (
  `ccctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ccctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ccctCount_Views` int(11) default '0' COMMENT '查看数',
  `ccctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `ccctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `ccctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `ccctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `ccctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `ccctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `ccctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `ccctSmallContent` varchar(180) default '-' COMMENT '简介',
  `ccctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `ccctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `ccctMetaDescription` text COMMENT 'MetaDescription',
  `ccctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `ccctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `ccctSources` text COMMENT '图集',
  `ccctIntroduct` text COMMENT '详细介绍',
  `ccctContent` text COMMENT '内容',
  `ccctRemark` text COMMENT '备注',
  PRIMARY KEY  (`ccctID`),
  KEY `ccctIndexID` (`ccctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmschannelcont` */

insert  into `{NetsInstall.Db_Tablehead}cmschannelcont`(`ccctID`,`ccctIndexID`,`ccctCount_Views`,`ccctCount_Info`,`ccctCount_InfoAll`,`ccctCount_Discuss`,`ccctCount_DiscussAll`,`ccctCode_Positive`,`ccctCode_Negative`,`ccctSmallTitle`,`ccctSmallContent`,`ccctMetaTitle`,`ccctMetaKeyword`,`ccctMetaDescription`,`ccctSourceR00`,`ccctSourceR01`,`ccctSources`,`ccctIntroduct`,`ccctContent`,`ccctRemark`) values (1,1,0,0,0,0,0,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);






/*Table structure for table `{NetsInstall.Db_Tablehead}cmsdocgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsdocgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsdocgroup` (
  `cdgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdgtName` varchar(180) default '-' COMMENT '名称',
  `cdgtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cdgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cdgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cdgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cdgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cdgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cdgtCreateBy` int(11) default '0' COMMENT '发布人',
  `cdgtCreateTime` datetime default NULL COMMENT '发布时间',
  `cdgtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`cdgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsdocgroup` */

insert  into `{NetsInstall.Db_Tablehead}cmsdocgroup`(`cdgtID`,`cdgtName`,`cdgtNameStyle`,`cdgtNumCode`,`cdgtParid`,`cdgtRecycle`,`cdgtChecked`,`cdgtOrderBy`,`cdgtCreateBy`,`cdgtCreateTime`,`cdgtTag`) values (1,'ROOT','','N_2010040215433963296',0,0,2,0,1,'2010-04-02 15:43:39','');
insert  into `{NetsInstall.Db_Tablehead}cmsdocgroup`(`cdgtID`,`cdgtName`,`cdgtNameStyle`,`cdgtNumCode`,`cdgtParid`,`cdgtRecycle`,`cdgtChecked`,`cdgtOrderBy`,`cdgtCreateBy`,`cdgtCreateTime`,`cdgtTag`) values (2,'网集文档','','N_2010040215434741680',1,0,2,0,1,'2010-04-02 15:47:51','');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsdocgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsdocgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsdocgroupcont` (
  `cdgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cdgctCount_Views` int(11) default '0' COMMENT '查看数',
  `cdgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cdgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cdgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `cdgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `cdgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cdgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cdgctChannelid` text COMMENT '所属频道',
  `cdgctModelid_List` int(11) default '0' COMMENT '列表模型',
  `cdgctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `cdgctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `cdgctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `cdgctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `cdgctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `cdgctPower_Public` int(11) default '0' COMMENT '用户发布权限',
  `cdgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cdgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cdgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cdgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cdgctMetaDescription` text COMMENT 'MetaDescription',
  `cdgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cdgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cdgctSources` text COMMENT '图集',
  `cdgctIntroduct` text COMMENT '详细介绍',
  `cdgctContent` text COMMENT '内容',
  `cdgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cdgctID`),
  KEY `cdgctIndexID` (`cdgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsdocgroupcont` */

insert  into `{NetsInstall.Db_Tablehead}cmsdocgroupcont`(`cdgctID`,`cdgctIndexID`,`cdgctCount_Views`,`cdgctCount_Info`,`cdgctCount_InfoAll`,`cdgctCount_Discuss`,`cdgctCount_DiscussAll`,`cdgctCode_Positive`,`cdgctCode_Negative`,`cdgctChannelid`,`cdgctModelid_List`,`cdgctModelid_Detail`,`cdgctTemplateid_Home`,`cdgctTemplateid_List`,`cdgctTemplateid_Detail`,`cdgctPower_View`,`cdgctPower_Public`,`cdgctSmallTitle`,`cdgctSmallContent`,`cdgctMetaTitle`,`cdgctMetaKeyword`,`cdgctMetaDescription`,`cdgctSourceR00`,`cdgctSourceR01`,`cdgctSources`,`cdgctIntroduct`,`cdgctContent`,`cdgctRemark`) values (1,1,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}cmsdocgroupcont`(`cdgctID`,`cdgctIndexID`,`cdgctCount_Views`,`cdgctCount_Info`,`cdgctCount_InfoAll`,`cdgctCount_Discuss`,`cdgctCount_DiscussAll`,`cdgctCode_Positive`,`cdgctCode_Negative`,`cdgctChannelid`,`cdgctModelid_List`,`cdgctModelid_Detail`,`cdgctTemplateid_Home`,`cdgctTemplateid_List`,`cdgctTemplateid_Detail`,`cdgctPower_View`,`cdgctPower_Public`,`cdgctSmallTitle`,`cdgctSmallContent`,`cdgctMetaTitle`,`cdgctMetaKeyword`,`cdgctMetaDescription`,`cdgctSourceR00`,`cdgctSourceR01`,`cdgctSources`,`cdgctIntroduct`,`cdgctContent`,`cdgctRemark`) values (2,2,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsdocusergroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsdocusergroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsdocusergroup` (
  `cdugtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdugtName` varchar(180) default '-' COMMENT '名称',
  `cdugtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cdugtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cdugtSign` varchar(180) default '-' COMMENT '标志',
  `cdugtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cdugtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cdugtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cdugtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cdugtCreateBy` int(11) default '0' COMMENT '发布人',
  `cdugtCreateTime` datetime default NULL COMMENT '发布时间',
  `cdugtTag` varchar(180) default '-' COMMENT '文档分类的标签',
  `cdugtPublicType` int(2) default '0' COMMENT '分类类型：0.个人博客分类,1.企业网站分类',
  PRIMARY KEY  (`cdugtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsdocusergroup` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsdocusergroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsdocusergroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsdocusergroupcont` (
  `cdugctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cdugctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cdugctCount_Views` int(11) default '0' COMMENT '查看数',
  `cdugctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cdugctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cdugctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `cdugctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `cdugctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cdugctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cdugctChannelid` text COMMENT '所属频道',
  `cdugctPower_View` int(11) default '0' COMMENT '用户查看权限',
  `cdugctPower_Public` int(11) default '0' COMMENT '用户发布权限',
  `cdugctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cdugctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cdugctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cdugctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cdugctMetaDescription` text COMMENT 'MetaDescription',
  `cdugctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cdugctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cdugctSources` text COMMENT '图集',
  `cdugctIntroduct` text COMMENT '详细介绍',
  `cdugctContent` text COMMENT '内容',
  `cdugctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cdugctID`),
  KEY `cdguctIndexID` (`cdugctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsdocusergroupcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsfeedback` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsfeedback`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsfeedback` (
  `cfbtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfbtName` varchar(180) default '-' COMMENT '名称，留言标题',
  `cfbtNameStyle` varchar(42) default '-' COMMENT '标题样式',
  `cfbtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cfbtType` int(2) default '0' COMMENT '留言类型',
  `cfbtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cfbtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cfbtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cfbtCreateBy` int(11) default '0' COMMENT '发布人',
  `cfbtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cfbtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsfeedback` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsfeedbackcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsfeedbackcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsfeedbackcont` (
  `cfbctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfbctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cfbctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cfbctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cfbctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `cfbctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `cfbctPower_View` text COMMENT '用户查看权限',
  `cfbctSpicalPosition` text COMMENT '特殊位置',
  `cfbctBackContent` text COMMENT '留言回复内容',
  `cfbctBackTime` datetime default NULL COMMENT '回复时间',
  `cfbctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cfbctContent` text COMMENT '内容',
  `cfbctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cfbctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cfbctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cfbctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `cfbctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `cfbctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `cfbctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `cfbctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cfbctID`),
  KEY `cfbctIndexID` (`cfbctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsfeedbackcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsfriend` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsfriend`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsfriend` (
  `cftID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cftName` varchar(180) default '-' COMMENT '名称',
  `cftNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cftParid` int(11) default '0' COMMENT '类型',
  `cftRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cftChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cftOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cftCreateBy` int(11) default '0' COMMENT '发布人',
  `cftCreateTime` datetime default NULL COMMENT '发布时间',
  `cftType` int(2) default '0' COMMENT '友情链接类型',
  `cftLink` varchar(180) default '-' COMMENT '链接地址',
  `cftText` varchar(180) default '-' COMMENT '链接文本',
  `cftTextStyle` varchar(42) default '-' COMMENT '文字或图片的样式',
  `cftSourceR00` varchar(180) default '-' COMMENT '链接图片',
  `cftUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  PRIMARY KEY  (`cftID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsfriend` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsfriendcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsfriendcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsfriendcont` (
  `cfctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cfctCount_Views` int(11) default '0' COMMENT '查看数',
  `cfctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `cfctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cfctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cfctChannelid` text COMMENT '所属频道',
  `cfctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `cfctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `cfctPower_View` text COMMENT '用户查看权限',
  `cfctPower_Public` text COMMENT '用户发布权限',
  `cfctSpicalPosition` text COMMENT '特殊位置',
  `cfctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cfctContent` text COMMENT '内容',
  `cfctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cfctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cfctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cfctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cfctID`),
  KEY `cfctIndexID` (`cfctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsfriendcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsfriendgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsfriendgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsfriendgroup` (
  `cfgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfgtName` varchar(180) default '-' COMMENT '名称',
  `cfgtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cfgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cfgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cfgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cfgtChecked` int(5) default '0' COMMENT '审核',
  `cfgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cfgtCreateBy` int(11) default '0' COMMENT '发布人',
  `cfgtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cfgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsfriendgroup` */

insert  into `{NetsInstall.Db_Tablehead}cmsfriendgroup`(`cfgtID`,`cfgtName`,`cfgtNameStyle`,`cfgtNumCode`,`cfgtParid`,`cfgtRecycle`,`cfgtChecked`,`cfgtOrderBy`,`cfgtCreateBy`,`cfgtCreateTime`) values (1,'ROOT','','N_2010111314385453945',0,0,2,0,1,'2010-11-13 14:38:54');
insert  into `{NetsInstall.Db_Tablehead}cmsfriendgroup`(`cfgtID`,`cfgtName`,`cfgtNameStyle`,`cfgtNumCode`,`cfgtParid`,`cfgtRecycle`,`cfgtChecked`,`cfgtOrderBy`,`cfgtCreateBy`,`cfgtCreateTime`) values (2,'网集友情链接','','N_2010111314390433676',1,0,2,0,1,'2010-11-13 14:39:04');
insert  into `{NetsInstall.Db_Tablehead}cmsfriendgroup`(`cfgtID`,`cfgtName`,`cfgtNameStyle`,`cfgtNumCode`,`cfgtParid`,`cfgtRecycle`,`cfgtChecked`,`cfgtOrderBy`,`cfgtCreateBy`,`cfgtCreateTime`) values (3,'友情链接','','N_201011131439139967',2,0,2,0,1,'2010-11-13 14:39:13');
insert  into `{NetsInstall.Db_Tablehead}cmsfriendgroup`(`cfgtID`,`cfgtName`,`cfgtNameStyle`,`cfgtNumCode`,`cfgtParid`,`cfgtRecycle`,`cfgtChecked`,`cfgtOrderBy`,`cfgtCreateBy`,`cfgtCreateTime`) values (4,'合作伙伴','','N_2010111314392353686',2,0,2,0,1,'2010-11-13 14:39:23');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsfriendgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsfriendgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsfriendgroupcont` (
  `cfgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cfgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cfgctCount_Views` int(11) default '0' COMMENT '查看数',
  `cfgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cfgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cfgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cfgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cfgctPower_View` text COMMENT '用户查看权限',
  `cfgctSpicalPosition` text COMMENT '特殊位置',
  `cfgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cfgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cfgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cfgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cfgctMetaDescription` text COMMENT 'MetaDescription',
  `cfgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cfgctIntroduct` text COMMENT '详细介绍',
  `cfgctContent` text COMMENT '内容',
  `cfgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cfgctID`),
  KEY `cfgctIndexID` (`cfgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsfriendgroupcont` */

insert  into `{NetsInstall.Db_Tablehead}cmsfriendgroupcont`(`cfgctID`,`cfgctIndexID`,`cfgctCount_Views`,`cfgctCount_Info`,`cfgctCount_InfoAll`,`cfgctCode_Positive`,`cfgctCode_Negative`,`cfgctPower_View`,`cfgctSpicalPosition`,`cfgctSmallTitle`,`cfgctSmallContent`,`cfgctMetaTitle`,`cfgctMetaKeyword`,`cfgctMetaDescription`,`cfgctSourceR00`,`cfgctIntroduct`,`cfgctContent`,`cfgctRemark`) values (1,1,0,0,0,0,0,'0','0','','','','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmsfriendgroupcont`(`cfgctID`,`cfgctIndexID`,`cfgctCount_Views`,`cfgctCount_Info`,`cfgctCount_InfoAll`,`cfgctCode_Positive`,`cfgctCode_Negative`,`cfgctPower_View`,`cfgctSpicalPosition`,`cfgctSmallTitle`,`cfgctSmallContent`,`cfgctMetaTitle`,`cfgctMetaKeyword`,`cfgctMetaDescription`,`cfgctSourceR00`,`cfgctIntroduct`,`cfgctContent`,`cfgctRemark`) values (2,2,0,0,0,0,0,'0','0','','','','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmsfriendgroupcont`(`cfgctID`,`cfgctIndexID`,`cfgctCount_Views`,`cfgctCount_Info`,`cfgctCount_InfoAll`,`cfgctCode_Positive`,`cfgctCode_Negative`,`cfgctPower_View`,`cfgctSpicalPosition`,`cfgctSmallTitle`,`cfgctSmallContent`,`cfgctMetaTitle`,`cfgctMetaKeyword`,`cfgctMetaDescription`,`cfgctSourceR00`,`cfgctIntroduct`,`cfgctContent`,`cfgctRemark`) values (3,3,0,0,0,0,0,'0','0','','','','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmsfriendgroupcont`(`cfgctID`,`cfgctIndexID`,`cfgctCount_Views`,`cfgctCount_Info`,`cfgctCount_InfoAll`,`cfgctCode_Positive`,`cfgctCode_Negative`,`cfgctPower_View`,`cfgctSpicalPosition`,`cfgctSmallTitle`,`cfgctSmallContent`,`cfgctMetaTitle`,`cfgctMetaKeyword`,`cfgctMetaDescription`,`cfgctSourceR00`,`cfgctIntroduct`,`cfgctContent`,`cfgctRemark`) values (4,4,0,0,0,0,0,'0','0','','','','','','','','','');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsipaddress` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsipaddress`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsipaddress` (
  `ciadtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ciadtName` varchar(180) default '-' COMMENT '名称',
  `ciadtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `ciadtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `ciadtCreateTime` datetime default NULL COMMENT '发布时间',
  `ciadtFrom` varchar(180) default '-' COMMENT '来路',
  `ciadtFromIp` varchar(42) default '-' COMMENT '访问者IP',
  `ciadtFromZone` varchar(42) default '-' COMMENT '访问者地区',
  `ciadtViewPage` varchar(180) default '-' COMMENT '访问页面',
  `ciadtViewTime` varchar(42) default '-' COMMENT '访问停留时间',
  PRIMARY KEY  (`ciadtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsipaddress` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsipaddresscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsipaddresscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsipaddresscont` (
  `ciadctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `ciadctIndexID` int(11) default '0' COMMENT '主表ID号',
  `ciadctOS` varchar(42) default '-' COMMENT '操作系统',
  `ciadctLanguage` varchar(42) default '-' COMMENT '语言',
  `ciadctISP` varchar(42) default '-' COMMENT '网络接入商',
  `ciadctResolution` varchar(42) default '-' COMMENT '分辨率',
  `ciadctBrower` varchar(42) default '-' COMMENT '浏览器',
  `ciadctIntroduct` text COMMENT '详细介绍',
  `ciadctContent` text COMMENT '内容',
  `ciadctRemark` text COMMENT '备注',
  PRIMARY KEY  (`ciadctID`),
  KEY `ciadctIndexID` (`ciadctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsipaddresscont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmslink` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmslink`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmslink` (
  `cltID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cltName` varchar(180) default '-' COMMENT '名称',
  `cltNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cltNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cltParid` int(11) default '0' COMMENT '上级或分类ID',
  `cltRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cltChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cltOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cltCreateBy` int(11) default '0' COMMENT '发布人',
  `cltCreateTime` datetime default NULL COMMENT '发布时间',
  `cltURL` varchar(180) default '-' COMMENT '链接地址',
  `cltType` int(2) default '0' COMMENT '类型',
  `cltTarget` varchar(42) default '_blank' COMMENT '对象',
  PRIMARY KEY  (`cltID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmslink` */

insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (1,'ROOT','','N_2010101517465027447',0,0,2,0,1,'2010-10-15 17:46:50','',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (2,'网集链接','','N_2010101517465939337',1,0,2,0,1,'2010-10-15 17:46:59','#',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (3,'商务系统','','N_2010101517471279605',2,0,2,0,1,'2010-10-15 17:47:12','#',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (4,'微博','','N_201010151747251327',3,0,2,0,1,'2010-10-15 17:47:25','#',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (5,'导航','','N_201010151747419799',4,0,2,0,1,'2010-10-15 17:47:41','#',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (6,'微博首页','','N_2010101517483369317',5,0,2,6,1,'2010-10-15 17:48:33','../../../Plus/m_default/comm/microbloggingHome.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (7,'我的主页','','N_2010101517484590185',5,0,2,5,1,'2010-10-15 17:48:45','../../../Plus/Common/Place_Microblogging/default.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (8,'广播大厅','','N_2010101517490376098',5,0,2,4,1,'2010-10-15 17:49:03','../../../Plus/m_default/comm/microbloggingList.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (9,'找人','','N_2010101517491569924',5,0,2,3,1,'2010-10-15 17:49:15','../../../Plus/m_default/comm/userList.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (10,'群组','','N_2010101517492220428',5,0,2,2,1,'2010-10-15 17:49:22','../../../Plus/m_default/comm/circleList.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (11,'话题','','N_2010101517492980001',5,0,2,1,1,'2010-10-15 17:51:49','../../../Plus/m_default/comm/microbloggingspeakHome.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (12,'团购','','N_2010102322184654583',3,0,2,0,1,'2010-10-23 22:18:46','#',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (13,'导航','-','N_2010102322201215426',12,0,2,0,1,'2010-10-23 22:20:12','#',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (14,'网站首页','-','N_2010102322201258239',13,0,2,5,1,'2010-10-23 22:20:12','../../../Plus/m_default/groupsale/groupsaleHome.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (15,'今日团购','-','N_2010102322201217056',13,0,2,4,1,'2010-10-23 22:20:12','../../../Plus/m_default/groupsale/groupsaleHome.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (16,'往期团购','-','N_2010102322201276495',13,0,2,3,1,'2010-10-23 22:20:12','../../../Plus/m_default/groupsale/groupsaleList.php',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (17,'如何团购','-','N_2010102322201235043',13,0,2,2,1,'2010-10-23 22:20:12','../../../Plus/m_default/cms/docDetail.php?ID=0',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (18,'常见问题','-','N_201010232220122709',13,0,2,1,1,'2010-10-23 22:20:12','../../../Plus/m_default/cms/docDetail.php?ID=0',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (19,'链接模板','-','N_2010110311155046029',2,0,2,1,1,'2010-11-03 11:15:50','#',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (20,'外部分享','-','N_2010110311160575219',19,0,2,1,1,'2010-11-03 11:16:05','#',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (21,'开心','-','N_2010110311181159100',20,0,2,1,1,'2010-11-03 11:40:29','http://www.kaixin001.com/repaste/share.php?rurl={Nets.URL}&rcontent={Nets.URL}&rtitle={Nets.CONTENT}',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (22,'人人','-','N_2010110311182224124',20,0,2,1,1,'2010-11-03 11:40:45','http://share.renren.com/share/buttonshare.do?link={Nets.URL}&title={Nets.CONTENT}',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (23,'豆瓣','-','N_2010110311183078143',20,0,2,1,1,'2010-11-03 11:40:59','http://www.douban.com/recommend/?url={Nets.URL}&title={Nets.CONTENT}',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (24,'新浪微博','-','N_2010110311183595236',20,0,2,1,1,'2010-11-03 11:41:32','http://v.t.sina.com.cn/share/share.php?appkey={Nets.KEY}&url={Nets.URL}&title={Nets.CONTENT}&pic={Nets.IMG}',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (25,'白社会','-','N_2010110311184240802',20,0,2,1,1,'2010-11-03 11:41:51','http://bai.sohu.com/share/blank/addbutton.do?from={Nets.UNAME}&link={Nets.URL}',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (26,'邮件','-','N_2010110311184994982',20,0,2,1,1,'2010-11-03 11:42:06','mailto:?body={Nets.CONTENT}',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (27,'手机','-','N_2010110311185619467',20,0,2,1,1,'2010-11-03 11:42:24','http://go.139.com/ishare.do?shareUrl={Nets.URL}&title={Nets.CONTENT}&sid={Nets.KEY}',0,'_blank');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (28,'团购导航','','N_2010110912253512902',3,0,2,0,1,'2010-11-09 12:25:35','#',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (29,'导航','','N_2010110912254562265',28,0,2,0,1,'2010-11-09 12:25:45','#',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (30,'底部链接','','N_2010110912260072824',28,0,2,0,1,'2010-11-09 12:26:00','#',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (31,'今日团购','','N_2010110912262827062',29,0,2,7,1,'2010-11-09 12:27:07','../../../Plus/m_default/Gsnavigation/gsnavigationactiveList.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (32,'团购导航','','N_2010110912271332373',29,0,2,6,1,'2010-11-09 12:33:57','../../../Plus/m_default/Gsnavigation/gsnavigationunitList.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (33,'团购排名','','N_2010110912271881289',29,0,2,5,1,'2010-11-09 12:33:50','../../../Plus/m_default/Gsnavigation/gsnavigationRangHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (34,'个人中心','','N_2010110912272391336',29,0,2,3,1,'2010-11-09 12:34:15','../../../Plus/Common/User/main.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (35,'团购地图','','N_2010110912273991741',29,0,2,4,1,'2010-11-09 12:34:43','../../../Plus/m_default/Gsnavigation/gsnavigationMap.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (36,'团购论坛','','N_2010110912274559228',29,0,2,2,1,'2010-11-09 12:34:59','../../../Plus/m_default/Comm/postsHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (37,'积分兑换','','N_2010110912275090435',29,0,1,1,1,'2011-01-25 06:30:46','../../../Plus/m_default/Shop/codeHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (38,'团购导航','','N_2010110912291317050',30,0,2,9,1,'2010-11-09 12:29:13','../../../Plus/m_default/Gsnavigation/gsnavigationactiveList.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (39,'关于我们','','N_2010110912292140670',30,0,2,8,1,'2010-11-09 12:29:21','../../../Plus/m_default/cms/docDetail.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (40,'使用指南','','N_2010110912292568582',30,0,2,7,1,'2010-11-09 12:29:25','../../../Plus/m_default/cms/docDetail.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (41,'诚聘英才','','N_2010110912293184851',30,0,2,6,1,'2010-11-09 12:29:31','../../../Plus/m_default/cms/docDetail.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (42,'意见反馈','','N_2010110912293761566',30,0,2,5,1,'2010-11-09 12:29:37','../../../Plus/m_default/Cms/feedback.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (43,'团购网站收录','','N_2010110912294392691',30,0,2,4,1,'2010-11-09 12:29:43','../../../Plus/Common/Gsnavigation/gsnavigationunit_Publish.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (44,'开放API','','N_201011091229481510',30,0,2,3,1,'2010-11-09 12:29:48','../../../Html/Xml/Gsnavigation/Gsnavigation_Data.xml',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (45,'官方微博','','N_2010110912295395684',30,0,2,2,1,'2010-11-09 12:29:53','../../../Plus/m_default/cms/docDetail.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (46,'友情链接','','N_2010110912295966394',30,0,2,1,1,'2010-11-09 12:29:59','../../../Plus/m_default/Cms/friendshipHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (47,'公共链接','','N_2010111316402045956',3,0,2,0,1,'2010-11-13 16:40:20','#',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (48,'关于我们导航','','N_2010111316403543551',47,0,2,0,1,'2010-11-13 16:40:35','#',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (49,'关于我们','','N_2010111316410697262',48,0,2,6,1,'2010-11-13 16:41:06','../../../Plus/m_default/Cms/docDetail.php?ID=0',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (50,'联系方式','','N_2010111316411878356',48,0,2,5,1,'2010-11-13 16:41:18','../../../Plus/m_default/Cms/docDetail.php?ID=0',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (51,'友情链接','','N_2010111316413817712',48,0,2,4,1,'2010-11-13 16:41:38','../../../Plus/m_default/Cms/friendshipHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (52,'在线留言','','N_201011131642054736',48,0,2,3,1,'2010-11-13 16:42:05','../../../Plus/m_default/Cms/feedback.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (53,'商城','','N_201011300553512685',3,0,2,0,1,'2010-11-30 05:53:51','#',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (54,'导航链接','-','N_2010113005550794793',53,0,2,0,1,'2010-11-30 05:55:07','#',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (55,'论坛','-','N_2010113005550710812',54,0,2,6,1,'2011-03-05 15:57:18','../../../Plus/m_default/Comm/postsHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (56,'优惠券','-','N_2010113005550717785',54,0,2,5,1,'2011-01-30 14:52:21','../../../Plus/m_default/shop/favourableHome.php',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (57,'团购','-','N_2010113005550720059',54,0,2,4,1,'2011-03-05 15:57:25','../../../Plus/m_default/Groupsale/groupsaleHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (58,'品牌','-','N_2010113005550766314',54,0,2,3,1,'2011-03-05 15:57:09','../../../Plus/m_default/shop/brandHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (59,'热门商品','-','N_2010113005550737850',54,0,2,2,1,'2011-01-30 14:52:21','../../../Plus/m_default/shop/saleList.php?ID=-1&DKeyword=&DSearch=0,1,-1,-1',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (60,'下底帮助链接','-','N_2010113007340632449',53,0,2,0,1,'2010-11-30 07:34:06','#',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (61,'新手帮助','-','N_2010113007342823089',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (62,'正品保证','-','N_201011300734287565',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (63,'品牌授权','-','N_2010113007342826354',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (64,'购鞋常识','-','N_2010113007342866616',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (65,'防伪标签','-','N_201011300734283594',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (66,'常见问题','-','N_2010113007342813900',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (67,'促销说明','-','N_2010113007342823168',61,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (68,'购物指南','-','N_20101130073428588',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (69,'量脚方法','-','N_2010113007342862811',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (70,'尺码测量纸','-','N_2010113007342899728',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (71,'尺码选择','-','N_2010113007342884631',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (72,'我的订单','-','N_2010113007342881240',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (73,'购物保障','-','N_2010113007342810113',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (74,'差额支付','-','N_2010113007342886923',68,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (75,'付款方式','-','N_2010113007342895117',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (76,'货到付款','-','N_201011300734285447',75,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (77,'支付宝','-','N_201011300734284876',75,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (78,'网上银行','-','N_2010113007342847360',75,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (79,'财付通','-','N_2010113007342889001',75,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (80,'配送方式','-','N_2010113007342820083',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (81,'运费说明','-','N_2010113007342856475',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (82,'宅急送','-','N_201011300734282914',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (83,'EMS快递','-','N_2010113007342850659',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (84,'中通快递','-','N_2010113007342822024',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (85,'圆通快递','-','N_2010113007342824285',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (86,'配送查询','-','N_2010113007342825460',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (87,'收货说明','-','N_2010113007342814465',80,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (88,'售后服务','-','N_2010113007342858145',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (89,'退换货政策','-','N_2010113007342817681',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (90,'退换货流程','-','N_2010113007342836874',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (91,'价格保护','-','N_2010113007342864794',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (92,'商品售后须知','-','N_2010113007342825320',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (93,'退款流程','-','N_2010113007342896038',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (94,'三包规定','-','N_201011300734289030',88,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (95,'会员服务','-','N_2010113007342836022',60,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (96,'优惠券使用','-','N_2010113007342870425',95,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (97,'如何咨询','-','N_2010113007342868731',95,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (98,'CEO邮箱','-','N_2010113007342863803',95,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (99,'服务协议','-','N_2010113007342812524',95,0,2,0,1,'2010-11-30 07:34:28','-',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (100,'底部导航','','N_2011012317410391488',12,0,2,0,1,'2011-01-23 17:41:03','#Here',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (101,'用户帮助','-','N_2011012317414353274',100,0,2,4,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (102,'玩转团购','-','N_2011012317414330535',101,0,2,4,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (103,'常见问题','-','N_201101231741436710',101,0,2,3,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (104,'邮箱白名单设置','-','N_2011012317414370715',101,0,2,2,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (105,'开放API','-','N_2011012317414389395',101,0,2,1,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (106,'获取更新','-','N_2011012317414323931',100,0,2,3,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (107,'邮件订阅','-','N_2011012317414318124',106,0,2,3,1,'2011-01-23 17:41:43','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (108,'团购微博','-','N_2011012317414421044',106,0,2,2,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (109,'网站首页','-','N_2011012317414456570',106,0,2,1,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (110,'商务合作','-','N_201101231741442288',100,0,2,2,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (111,'提供团购信息','-','N_2011012317414490280',110,0,2,3,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (112,'市场合作','-','N_2011012317414492272',110,0,2,2,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (113,'加盟我们','-','N_201101231741441675',110,0,2,1,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (114,'公司信息','-','N_2011012317414474981',100,0,2,1,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (115,'关于我们','-','N_2011012317414445053',114,0,2,4,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (116,'媒体报道','-','N_2011012317414468774',114,0,2,3,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (117,'加入我们','-','N_2011012317414421585',114,0,2,2,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (118,'隐私声明','-','N_201101231741441385',114,0,2,1,1,'2011-01-23 17:41:44','#Here',0,'-');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (119,'最新上市','-','N_2011013014464336911',54,0,2,1,1,'2011-01-30 14:52:21','../../../Plus/m_default/shop/saleList.php?ID=-1&DKeyword=&DSearch=0,2,-1,-1',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (120,'最上导航','-','N_2011013015291092028',53,0,2,0,1,'2011-01-30 15:29:10','#',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (121,'积分商城','-','N_2011020114092096276',54,0,2,5,1,'2011-02-01 14:09:20','../../../Plus/m_default/shop/codeHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (122,'商家','-','N_2011022309024846734',54,0,2,3,1,'2011-03-05 15:57:35','../../../Plus/m_default/shop/unitHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (123,'拍卖','-','N_2011030515561339450',54,0,2,3,1,'2011-03-05 15:56:13','../../../Plus/m_default/shop/auctionHome.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (124,'近期订单','-','N_2011030515565176794',54,0,2,3,1,'2011-03-14 19:48:53','../../../Plus/m_default/shop/orderHome.php',0,'_self');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (125,'推广链接','','N_2011050500584295065',48,0,2,2,1,'2011-05-05 00:58:42','../../../Plus/m_default/Cms/promotion_Link.php',0,'0');
insert  into `{NetsInstall.Db_Tablehead}cmslink`(`cltID`,`cltName`,`cltNameStyle`,`cltNumCode`,`cltParid`,`cltRecycle`,`cltChecked`,`cltOrderBy`,`cltCreateBy`,`cltCreateTime`,`cltURL`,`cltType`,`cltTarget`) values (126,'推广表单','','N_2011050500590278915',48,0,2,1,1,'2011-05-05 00:59:02','../../../Plus/m_default/Cms/promotion_Form.php',0,'0');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmslinkcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmslinkcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmslinkcont` (
  `clctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `clctIndexID` int(11) default '0' COMMENT '主表ID号',
  `clctCount_Views` int(11) default '0' COMMENT '查看数',
  `clctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `clctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `clctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `clctChannelid` text COMMENT '所属频道',
  `clctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `clctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `clctPower_View` text COMMENT '用户查看权限',
  `clctPower_Public` text COMMENT '用户发布权限',
  `clctSpicalPosition` text COMMENT '特殊位置',
  `clctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `clctSmallContent` varchar(180) default '-' COMMENT '简介',
  `clctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `clctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `clctMetaDescription` text COMMENT 'MetaDescription',
  `clctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `clctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `clctSources` text COMMENT '图集',
  `clctIntroduct` text COMMENT '详细介绍',
  `clctContent` text COMMENT '内容',
  `clctRemark` text COMMENT '备注',
  PRIMARY KEY  (`clctID`),
  KEY `clctIndexID` (`clctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmslinkcont` */

insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (1,1,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (2,2,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (3,3,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (4,4,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (5,5,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (6,6,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (7,7,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (8,8,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (9,9,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (10,10,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (11,11,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (12,12,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (13,13,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (14,14,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (15,15,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (16,16,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (17,17,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (18,18,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (19,19,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (20,20,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (21,21,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_1.jpg','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (22,22,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_2.jpg','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (23,23,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_3.jpg','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (24,24,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_4.jpg','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (25,25,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_6.jpg','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (26,26,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_5.jpg','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (27,27,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','Ui/m_nets/Img/User/Community/Icon_7.jpg','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (28,28,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (29,29,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (30,30,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (31,31,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (32,32,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (33,33,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (34,34,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (35,35,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (36,36,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (37,37,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (38,38,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (39,39,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (40,40,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (41,41,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (42,42,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (43,43,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (44,44,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (45,45,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (46,46,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (47,47,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (48,48,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (49,49,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (50,50,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (51,51,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (52,52,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (53,53,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (54,54,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (55,55,0,0,0,0,'-',0,0,'0','-','0','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (56,56,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (57,57,0,0,0,0,'-',0,0,'0','-','0','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (58,58,0,0,0,0,'-',0,0,'0','-','0','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (59,59,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (60,60,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (61,61,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (62,62,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (63,63,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (64,64,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (65,65,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (66,66,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (67,67,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (68,68,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (69,69,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (70,70,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (71,71,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (72,72,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (73,73,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (74,74,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (75,75,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (76,76,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (77,77,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (78,78,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (79,79,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (80,80,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (81,81,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (82,82,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (83,83,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (84,84,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (85,85,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (86,86,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (87,87,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (88,88,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (89,89,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (90,90,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (91,91,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (92,92,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (93,93,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (94,94,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (95,95,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (96,96,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (97,97,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (98,98,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (99,99,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (100,100,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (101,101,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (102,102,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (103,103,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (104,104,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (105,105,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (106,106,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (107,107,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (108,108,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (109,109,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (110,110,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (111,111,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (112,112,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (113,113,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (114,114,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (115,115,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (116,116,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (117,117,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (118,118,0,0,0,0,'-',0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (119,119,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (120,120,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (121,121,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (122,122,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (123,123,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (124,124,0,0,0,0,'0',0,0,'0','0','0','-','-','0','0','0','-','-','-','-','-','-');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (125,125,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmslinkcont`(`clctID`,`clctIndexID`,`clctCount_Views`,`clctCount_Discuss`,`clctCode_Positive`,`clctCode_Negative`,`clctChannelid`,`clctRequireType`,`clctRequireid`,`clctPower_View`,`clctPower_Public`,`clctSpicalPosition`,`clctSmallTitle`,`clctSmallContent`,`clctMetaTitle`,`clctMetaKeyword`,`clctMetaDescription`,`clctSourceR00`,`clctSourceR01`,`clctSources`,`clctIntroduct`,`clctContent`,`clctRemark`) values (126,126,0,0,0,0,'0',0,0,'0','0','0','','','0','0','0','','','','','','');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmssearchkeyword` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmssearchkeyword`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmssearchkeyword` (
  `csktID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `csktName` varchar(180) default '-' COMMENT '名称',
  `csktNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `csktNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `csktParid` int(11) default '0' COMMENT '上级或分类ID',
  `csktRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `csktChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `csktOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `csktCreateBy` int(11) default '0' COMMENT '发布人',
  `csktCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`csktID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmssearchkeyword` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmssearchkeywordcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmssearchkeywordcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmssearchkeywordcont` (
  `cskctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cskctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cskctLink` varchar(180) default '-' COMMENT '链接地址',
  `cskctCount_Views` int(11) default '0' COMMENT '查看数',
  `cskctPower_View` text COMMENT '用户查看权限',
  `cskctSpicalPosition` text COMMENT '特殊位置',
  `cskctIntroduct` text COMMENT '介绍',
  `cskctContent` text COMMENT '内容',
  `cskctRemark` text COMMENT '管理员备注',
  PRIMARY KEY  (`cskctID`),
  KEY `cskctIndexID` (`cskctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmssearchkeywordcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmssearchkeywordgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmssearchkeywordgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmssearchkeywordgroup` (
  `cskgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cskgtName` varchar(180) default '-' COMMENT '名称',
  `cskgtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cskgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cskgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cskgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cskgtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cskgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cskgtCreateBy` int(11) default '0' COMMENT '发布人',
  `cskgtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cskgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmssearchkeywordgroup` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmssearchkeywordgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmssearchkeywordgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmssearchkeywordgroupcont` (
  `cskgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cskgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cskgctCount_Views` int(11) default '0' COMMENT '查看数',
  `cskgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cskgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cskgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cskgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cskgctPower_View` text COMMENT '用户查看权限',
  `cskgctSpicalPosition` text COMMENT '特殊位置',
  `cskgctIntroduct` text COMMENT '详细介绍',
  `cskgctContent` text COMMENT '内容',
  `cskgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cskgctID`),
  KEY `cskgctIndexID` (`cskgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmssearchkeywordgroupcont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvote` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvote`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvote` (
  `cvtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvtName` varchar(180) default '-' COMMENT '名称',
  `cvtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cvtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cvtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cvtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvtCreateBy` int(11) default '0' COMMENT '发布人',
  `cvtCreateTime` datetime default NULL COMMENT '发布时间',
  `cvtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`cvtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvote` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvotecont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvotecont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvotecont` (
  `cvctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvctSet_Page` int(5) default '0' COMMENT '所在页',
  `cvctTime_End` varchar(42) default NULL COMMENT '结束时间',
  `cvctControl_Type` varchar(42) default 'RadioAR' COMMENT '控件类型',
  `cvctControl_Len` int(5) default '8' COMMENT '控件长度',
  `cvctControl_Default` varchar(180) default NULL COMMENT '默认值',
  `cvctControl_Need` int(2) default '0' COMMENT '是否为必填',
  `cvctControl_Input` int(2) default '0' COMMENT '是否有附加输入框',
  `cvctCount_Views` int(11) default '0' COMMENT '查看数',
  `cvctCount_Discuss` int(11) default '0' COMMENT '回复数_投票数',
  `cvctChannelid` text COMMENT '所属频道',
  `cvctPower_View` text COMMENT '用户查看权限',
  `cvctPower_Public` text COMMENT '用户发布权限',
  `cvctSpicalPosition` text COMMENT '特殊位置',
  `cvctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cvctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cvctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cvctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cvctMetaDescription` text COMMENT 'MetaDescription',
  `cvctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cvctSources` text COMMENT '图集',
  `cvctIntroduct` text COMMENT '详细介绍',
  `cvctContent` text COMMENT '内容',
  `cvctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cvctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cvctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cvctRemark` text COMMENT '备注',
  `cvctSet_Result` text COMMENT '上页值包含此内容时显示本投票，为空为不限制',
  PRIMARY KEY  (`cvctID`),
  KEY `cvctIndexID` (`cvctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvotecont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvotediscuss` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvotediscuss`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvotediscuss` (
  `cvdtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvdtName` varchar(180) default '-' COMMENT '名称',
  `cvdtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cvdtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvdtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cvdtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvdtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cvdtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvdtCreateBy` int(11) default '0' COMMENT '发布人',
  `cvdtCreateTime` datetime default NULL COMMENT '发布时间',
  `cvdtType` int(5) default '0' COMMENT '类型',
  PRIMARY KEY  (`cvdtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvotediscuss` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvotediscusscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvotediscusscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvotediscusscont` (
  `cvdctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvdctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvdctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cvdctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cvdctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `cvdctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `cvdctPower_View` text COMMENT '用户查看权限',
  `cvdctSpicalPosition` text COMMENT '特殊位置',
  `cvdctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvdctContent` text COMMENT '内容',
  `cvdctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cvdctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cvdctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cvdctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `cvdctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `cvdctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `cvdctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `cvdctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cvdctID`),
  KEY `cvdctIndexID` (`cvdctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvotediscusscont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvotegroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvotegroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvotegroup` (
  `cvgtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvgtName` varchar(180) default '-' COMMENT '名称',
  `cvgtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cvgtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvgtParid` int(11) default '0' COMMENT '上级或分类ID',
  `cvgtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvgtChecked` int(5) default '0' COMMENT '审核',
  `cvgtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvgtCreateBy` int(11) default '0' COMMENT '发布人',
  `cvgtCreateTime` datetime default NULL COMMENT '发布时间',
  `cvgtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`cvgtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvotegroup` */

insert  into `{NetsInstall.Db_Tablehead}cmsvotegroup`(`cvgtID`,`cvgtName`,`cvgtNameStyle`,`cvgtNumCode`,`cvgtParid`,`cvgtRecycle`,`cvgtChecked`,`cvgtOrderBy`,`cvgtCreateBy`,`cvgtCreateTime`,`cvgtTag`) values (1,'ROOT','','N_2010112501433173086',0,0,2,0,1,'2010-11-25 01:43:31','');
insert  into `{NetsInstall.Db_Tablehead}cmsvotegroup`(`cvgtID`,`cvgtName`,`cvgtNameStyle`,`cvgtNumCode`,`cvgtParid`,`cvgtRecycle`,`cvgtChecked`,`cvgtOrderBy`,`cvgtCreateBy`,`cvgtCreateTime`,`cvgtTag`) values (2,'网集投票与问卷调查','','N_2010112501433648648',1,0,2,0,1,'2010-11-25 01:43:36','');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvotegroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvotegroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvotegroupcont` (
  `cvgctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvgctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvgctCount_Views` int(11) default '0' COMMENT '查看数',
  `cvgctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `cvgctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `cvgctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `cvgctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `cvgctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cvgctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cvgctChannelid` text COMMENT '所属频道',
  `cvgctPower_View` text COMMENT '用户查看权限',
  `cvgctSpicalPosition` text COMMENT '特殊位置',
  `cvgctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `cvgctSmallContent` varchar(180) default '-' COMMENT '简介',
  `cvgctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `cvgctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `cvgctMetaDescription` text COMMENT 'MetaDescription',
  `cvgctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvgctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `cvgctSources` text COMMENT '图集',
  `cvgctIntroduct` text COMMENT '详细介绍',
  `cvgctContent` text COMMENT '内容',
  `cvgctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cvgctID`),
  KEY `cvgctIndexID` (`cvgctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvotegroupcont` */

insert  into `{NetsInstall.Db_Tablehead}cmsvotegroupcont`(`cvgctID`,`cvgctIndexID`,`cvgctCount_Views`,`cvgctCount_Info`,`cvgctCount_InfoAll`,`cvgctCount_Discuss`,`cvgctCount_DiscussAll`,`cvgctCode_Positive`,`cvgctCode_Negative`,`cvgctChannelid`,`cvgctPower_View`,`cvgctSpicalPosition`,`cvgctSmallTitle`,`cvgctSmallContent`,`cvgctMetaTitle`,`cvgctMetaKeyword`,`cvgctMetaDescription`,`cvgctSourceR00`,`cvgctSourceR01`,`cvgctSources`,`cvgctIntroduct`,`cvgctContent`,`cvgctRemark`) values (1,1,0,0,0,0,0,0,0,'','0','0','','','','','','','','','','','');
insert  into `{NetsInstall.Db_Tablehead}cmsvotegroupcont`(`cvgctID`,`cvgctIndexID`,`cvgctCount_Views`,`cvgctCount_Info`,`cvgctCount_InfoAll`,`cvgctCount_Discuss`,`cvgctCount_DiscussAll`,`cvgctCode_Positive`,`cvgctCode_Negative`,`cvgctChannelid`,`cvgctPower_View`,`cvgctSpicalPosition`,`cvgctSmallTitle`,`cvgctSmallContent`,`cvgctMetaTitle`,`cvgctMetaKeyword`,`cvgctMetaDescription`,`cvgctSourceR00`,`cvgctSourceR01`,`cvgctSources`,`cvgctIntroduct`,`cvgctContent`,`cvgctRemark`) values (2,2,0,0,0,0,0,0,0,'','0','0','','','','','','','','','','','');

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvoteoption` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvoteoption`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvoteoption` (
  `cvotID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvotName` varchar(250) default '-' COMMENT '名称',
  `cvotNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cvotNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvotParid` int(11) default '0' COMMENT '上级或分类ID',
  `cvotRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvotChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cvotOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvotCreateBy` int(11) default '0' COMMENT '发布人',
  `cvotCreateTime` datetime default NULL COMMENT '发布时间',
  `cvotValue` varchar(250) default '0' COMMENT '值',
  `cvotCount` int(11) default '0' COMMENT '已投票数',
  PRIMARY KEY  (`cvotID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvoteoption` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvoteoptioncont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvoteoptioncont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvoteoptioncont` (
  `cvoctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvoctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvoctScript` text COMMENT '选中后，响应的脚本，只支持JS脚本',
  `cvoctPower_View` text COMMENT '用户查看权限',
  `cvoctSpicalPosition` text COMMENT '特殊位置',
  `cvoctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvoctIntroduct` text COMMENT '详细介绍',
  `cvoctContent` text COMMENT '内容',
  `cvoctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cvoctID`),
  KEY `cvoctIndexID` (`cvoctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvoteoptioncont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvoteresult` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvoteresult`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvoteresult` (
  `cvrtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvrtName` varchar(180) default '-' COMMENT '名称',
  `cvrtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `cvrtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `cvrtParid` int(11) default '0' COMMENT '所投票分组、所调查问卷',
  `cvrtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `cvrtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `cvrtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `cvrtCreateBy` int(11) default '0' COMMENT '发布人',
  `cvrtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`cvrtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvoteresult` */

/*Table structure for table `{NetsInstall.Db_Tablehead}cmsvoteresultcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}cmsvoteresultcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}cmsvoteresultcont` (
  `cvrctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `cvrctIndexID` int(11) default '0' COMMENT '主表ID号',
  `cvrctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `cvrctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `cvrctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `cvrctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `cvrctPower_View` text COMMENT '用户查看权限',
  `cvrctSpicalPosition` text COMMENT '特殊位置',
  `cvrctConContent` text COMMENT '填表-留言内容',
  `cvrctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `cvrctContent` text COMMENT '内容',
  `cvrctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `cvrctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `cvrctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `cvrctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `cvrctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `cvrctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `cvrctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `cvrctRemark` text COMMENT '备注',
  PRIMARY KEY  (`cvrctID`),
  KEY `cvrctIndexID` (`cvrctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}cmsvoteresultcont` */
