
/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationactive` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationactive`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationactive` (
  `gsnatID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnatName` varchar(250) default '-' COMMENT '名称',
  `gsnatNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `gsnatNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnatParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnatUnitid` int(11) default '0' COMMENT '团购导航供应商ID',
  `gsnatRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnatState` int(5) default '0' COMMENT '团购状态',
  `gsnatChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnatOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnatCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnatCreateTime` datetime default NULL COMMENT '发布时间',
  `gsnatTag` varchar(180) default '-' COMMENT '标签',
  `gsnatUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  `gsnatUserPublicGroupid` int(11) default '0' COMMENT '用户分类：0.管理员发布的,1.用户发布的，发布到个人博客,2.用户发布的，发布到企业网站,3.用户发布的，发布到企业网站和个人博客',
  `gsnatAlphabet` varchar(42) default 'A' COMMENT '首字母',
  `gsnatURL` varchar(180) default NULL COMMENT '网址',
  `gsnatZoneid` int(11) default '0' COMMENT '所属地区',
  `gsnatShoppingid` int(11) default '0' COMMENT '所属商圈',
  `gsnatBrandid` int(11) default '0' COMMENT '品牌ID',
  `gsnatRealshopid` int(11) default '0' COMMENT '所属实体店',
  `gsnatClassid` int(11) default '0' COMMENT '商品所属类别ID',
  PRIMARY KEY  (`gsnatID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationactive` */

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationactivecont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationactivecont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationactivecont` (
  `gsnactID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnactIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnactInfo_Numcode` varchar(180) default '-' COMMENT '团购站内，团购标识号',
  `gsnactPrice_StartTime` datetime default NULL COMMENT '团购开始时间',
  `gsnactPrice_EndTime` datetime default NULL COMMENT '团购结束时间',
  `gsnactPrice_Origin` decimal(9,2) default '0.00' COMMENT '原价',
  `gsnactPrice_Now` decimal(9,2) default '0.00' COMMENT '现价',
  `gsnactPrice_Sale` decimal(9,2) default '0.00' COMMENT '折扣',
  `gsnactPrice_Save` decimal(9,2) default '0.00' COMMENT '节省',
  `gsnactPrice_LimitPeople` int(11) default '12' COMMENT '最低团购人数',
  `gsnactPrice_LimitOnes` int(11) default '1' COMMENT '单人可购数量',
  `gsnactPrice_TotalCount` int(11) default '100' COMMENT '可订总数',
  `gsnactSpeak` text COMMENT '用户感言',
  `gsnactCom_Logo` varchar(180) default '..' COMMENT '公司LOGO',
  `gsnactCom_Introduct` text COMMENT '公司介绍',
  `gsnactMapIntroduct` text COMMENT '地图标签名称',
  `gsnactMapX` varchar(42) default '0' COMMENT '地图X座标',
  `gsnactMapY` varchar(42) default '0' COMMENT '地图Y座标',
  `gsnactCount_Order` int(11) default '0' COMMENT '订购人数',
  `gsnactCount_Views` int(11) default '0' COMMENT '查看数',
  `gsnactCount_Discuss` int(11) default '0' COMMENT '回复数',
  `gsnactCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnactCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnactChannelid` text COMMENT '所属频道',
  `gsnactRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `gsnactRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `gsnactModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `gsnactTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `gsnactDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `gsnactKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `gsnactKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `gsnactPageAble` int(2) default '0' COMMENT '是否分页',
  `gsnactPower_View` text COMMENT '用户查看权限',
  `gsnactPower_Public` text COMMENT '用户发布权限',
  `gsnactSpicalPosition` text COMMENT '特殊位置',
  `gsnactSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `gsnactSmallContent` varchar(180) default '-' COMMENT '简介',
  `gsnactMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `gsnactMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `gsnactMetaDescription` text COMMENT 'MetaDescription',
  `gsnactSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnactSourceR01` varchar(180) default '-' COMMENT '大图片',
  `gsnactSources` text COMMENT '图集',
  `gsnactIntroduct` text COMMENT '详细介绍',
  `gsnactContent` text COMMENT '内容',
  `gsnactPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `gsnactPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `gsnactPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `gsnactPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `gsnactPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `gsnactPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `gsnactPublisher_Address` varchar(180) default '-' COMMENT '联系地址',
  `gsnactPublisher_Numcode` varchar(180) default '-' COMMENT '邮编',
  `gsnactPublisher_Fax` varchar(180) default '-' COMMENT '传真',
  `gsnactPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `gsnactRemark` text COMMENT '备注',
  `gsnactZones` text COMMENT '开通地区',
  `gsnactShoppings` text COMMENT '开通商圈',
  `gsnactBrands` text COMMENT '所属品牌',
  `gsnactRealshops` text COMMENT '所属实体店',
  `gsnactUnits` text COMMENT '所属商家',
  PRIMARY KEY  (`gsnactID`),
  KEY `gsnactIndexID` (`gsnactIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationactivecont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss` (
  `gsnadtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnadtName` varchar(180) default '-' COMMENT '名称',
  `gsnadtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `gsnadtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnadtParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnadtType` int(5) default '0' COMMENT '类型',
  `gsnadtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnadtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnadtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnadtCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnadtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`gsnadtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss` */

insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (1,'0','0','N_2011010921490153353',4,0,0,2,0,1,'2011-01-09 21:49:01');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (2,'0','0','N_2011011116550258483',0,0,0,0,0,1,'2011-01-11 16:55:02');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (3,'0','0','N_2011011116591893255',1,0,0,2,0,1,'2011-01-11 16:59:18');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (4,'0','0','N_2011011116595785644',7,0,0,2,0,1,'2011-01-11 16:59:57');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscuss`(`gsnadtID`,`gsnadtName`,`gsnadtNameStyle`,`gsnadtNumCode`,`gsnadtParid`,`gsnadtType`,`gsnadtRecycle`,`gsnadtChecked`,`gsnadtOrderBy`,`gsnadtCreateBy`,`gsnadtCreateTime`) values (5,'0','0','N_2011011117232768722',7,0,0,2,0,1,'2011-01-11 17:23:27');

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont` (
  `gsnadctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnadctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnadctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnadctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnadctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `gsnadctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `gsnadctPower_View` text COMMENT '用户查看权限',
  `gsnadctSpicalPosition` text COMMENT '特殊位置',
  `gsnadctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnadctContent` text COMMENT '内容',
  `gsnadctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `gsnadctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `gsnadctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `gsnadctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `gsnadctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `gsnadctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `gsnadctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `gsnadctRemark` text COMMENT '备注',
  PRIMARY KEY  (`gsnadctID`),
  KEY `gsnadctIndexID` (`gsnadctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont` */

insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (1,1,0,0,0,0,'0','0','0','有效期截止至2011年3月31日\r\n全国皆可购买，只限北京使用\r\n只接受电话预定，网上预定无效\r\n请提前预备200元/日押金\r\n请至少提前48小时电话预约 \r\n美团券之外续住按酒店门市价\r\n不可同时享受店内其他优惠','0','0','0','0','0','0','0','0');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (2,2,0,0,0,0,'0','0','0','123123123','0','0','0','0','0','0','0','0');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (3,3,0,0,0,0,'0','0','0','平时非常活泼的一个女孩被拍摄得唯美宁静，顿时让我对青禾很有信心，于是义无反顾','0','0','0','0','0','0','0','0');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (4,4,0,0,0,0,'0','0','0','全国范围均可购买，每人可购买多套\r\n仅限市区配送，购买前请致电快递公司确认是否配送\r\n团购结束后的第1个工作日开始配送','0','0','0','0','0','0','0','0');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivediscusscont`(`gsnadctID`,`gsnadctIndexID`,`gsnadctCode_Positive`,`gsnadctCode_Negative`,`gsnadctCode_BePositive`,`gsnadctCode_BeNegative`,`gsnadctPower_View`,`gsnadctSpicalPosition`,`gsnadctSourceR00`,`gsnadctContent`,`gsnadctPublisher_Name`,`gsnadctPublisher_Email`,`gsnadctPublisher_Source`,`gsnadctPublisher_Mobile`,`gsnadctPublisher_Tele`,`gsnadctPublisher_Software`,`gsnadctPublisher_Homepage`,`gsnadctRemark`) values (5,5,0,0,0,0,'0','0','0','24240','0','0','0','0','0','0','0','0');

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationactivegroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationactivegroup` (
  `gsnagtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnagtName` varchar(180) default '-' COMMENT '名称',
  `gsnagtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `gsnagtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnagtParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnagtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnagtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnagtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnagtCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnagtCreateTime` datetime default NULL COMMENT '发布时间',
  `gsnagtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`gsnagtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationactivegroup` */

insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (1,'ROOT','-','-',0,0,2,10,1,'2010-11-07 20:13:58','-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (2,'网集团购网站分类','-','-',1,0,2,9,1,'2010-11-07 20:13:58','-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (3,'餐饮美食','-','-',2,0,2,8,1,'2010-11-07 20:13:58','-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (4,'休闲娱乐','-','-',2,0,2,7,1,'2010-11-07 20:13:58','-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (5,'美容健身','-','-',2,0,2,6,1,'2010-11-07 20:13:58','-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (8,'精品购物','-','-',2,0,2,3,1,'2010-11-07 20:13:59','-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (9,'摄影写真','-','-',2,0,2,2,1,'2010-11-07 20:13:59','-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroup`(`gsnagtID`,`gsnagtName`,`gsnagtNameStyle`,`gsnagtNumCode`,`gsnagtParid`,`gsnagtRecycle`,`gsnagtChecked`,`gsnagtOrderBy`,`gsnagtCreateBy`,`gsnagtCreateTime`,`gsnagtTag`) values (10,'其它','-','-',2,0,2,1,1,'2010-11-07 20:13:59','-');

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont` (
  `gsnagctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnagctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnagctCount_Views` int(11) default '0' COMMENT '查看数',
  `gsnagctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `gsnagctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `gsnagctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `gsnagctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `gsnagctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnagctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnagctChannelid` text COMMENT '所属频道',
  `gsnagctModelid_List` int(11) default '0' COMMENT '列表模型',
  `gsnagctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `gsnagctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `gsnagctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `gsnagctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `gsnagctPower_View` text COMMENT '用户查看权限',
  `gsnagctPower_Public` text COMMENT '用户发布权限',
  `gsnagctSpicalPosition` text COMMENT '特殊位置',
  `gsnagctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `gsnagctSmallContent` varchar(180) default '-' COMMENT '简介',
  `gsnagctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `gsnagctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `gsnagctMetaDescription` text COMMENT 'MetaDescription',
  `gsnagctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnagctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `gsnagctSources` text COMMENT '图集',
  `gsnagctIntroduct` text COMMENT '详细介绍',
  `gsnagctContent` text COMMENT '内容',
  `gsnagctRemark` text COMMENT '备注',
  PRIMARY KEY  (`gsnagctID`),
  KEY `gsnagctIndexID` (`gsnagctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont` */

insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (1,1,0,558,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (2,2,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (3,3,0,21,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (4,4,0,10,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (5,5,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (8,8,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (9,9,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationactivegroupcont`(`gsnagctID`,`gsnagctIndexID`,`gsnagctCount_Views`,`gsnagctCount_Info`,`gsnagctCount_InfoAll`,`gsnagctCount_Discuss`,`gsnagctCount_DiscussAll`,`gsnagctCode_Positive`,`gsnagctCode_Negative`,`gsnagctChannelid`,`gsnagctModelid_List`,`gsnagctModelid_Detail`,`gsnagctTemplateid_Home`,`gsnagctTemplateid_List`,`gsnagctTemplateid_Detail`,`gsnagctPower_View`,`gsnagctPower_Public`,`gsnagctSpicalPosition`,`gsnagctSmallTitle`,`gsnagctSmallContent`,`gsnagctMetaTitle`,`gsnagctMetaKeyword`,`gsnagctMetaDescription`,`gsnagctSourceR00`,`gsnagctSourceR01`,`gsnagctSources`,`gsnagctIntroduct`,`gsnagctContent`,`gsnagctRemark`) values (10,10,0,17,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationunit` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationunit`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationunit` (
  `gsnutID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnutName` varchar(180) default '-' COMMENT '名称',
  `gsnutNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `gsnutNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnutParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnutRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnutChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnutOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnutCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnutCreateTime` datetime default NULL COMMENT '发布时间',
  `gsnutTag` varchar(180) default '-' COMMENT '标签',
  `gsnutUserPublic` int(2) default '0' COMMENT '是否是用户发布',
  `gsnutUserPublicGroupid` int(11) default '0' COMMENT '用户分类：0.管理员发布的,1.用户发布的，发布到个人博客,2.用户发布的，发布到企业网站,3.用户发布的，发布到企业网站和个人博客',
  `gsnutAlphabet` varchar(42) default 'A' COMMENT '首字母',
  `gsnutURL` varchar(180) default '-' COMMENT '网址',
  `gsnutZoneid` int(11) default '0' COMMENT '所属地区',
  `gsnutShoppingid` int(11) default '0' COMMENT '所属商圈',
  `gsnutType` int(2) default '0' COMMENT '类型',
  PRIMARY KEY  (`gsnutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationunit` */

insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (1,'美团','-','-',1,0,2,0,1,'2011-06-04 16:01:38','-',0,0,'A','http://www.meituan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (2,'拉手','-','GS_201001010101212',1,0,2,0,1,'2011-06-04 18:52:01','-',0,0,'A','http://www.lashou.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (3,'24券','-','-',1,0,2,0,1,'2011-06-04 18:58:27','-',0,0,'A','http://www.24quan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (4,'满座','-','-',1,0,2,0,1,'2011-06-04 19:09:14','-',0,0,'A','http://www.manzuo.com/i/68883.htm',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (5,'格鲁','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.gelu.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (6,'米奇网','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.miqi.cn/r.php?r=5859',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (7,'G团网','-','-',1,0,2,0,1,'2011-06-04 19:15:13','-',0,0,'A','http://www.gtuan.com/',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (8,'易购团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.egotuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (9,'饭统饭团','-','-',1,0,2,0,1,'2011-06-04 19:12:12','-',0,0,'A','http://tuan.fantong.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (10,'57团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.95171.cn/buy/invite/510998500',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (11,'葆生团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.baoshengtuan.com/index.php',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (12,'80社团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.80stuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (13,'姐妹团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.sistuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (14,'聚美优品','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.jumei.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (15,'唯伊团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.w1.cn/tuan.html',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (16,'窝窝团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.55tuan.com/?u=46308',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (17,'糯米','-','-',1,0,2,0,1,'2011-06-04 19:18:31','-',0,0,'A','http://www.nuomi.com/',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (18,'新浪团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://life.sina.com.cn/tuan/r/1JVfHrwrJP-HrDz7UrBvjMYSAM6',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (19,'爱帮团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.aibang.com/?area=tuan',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (20,'F团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.ftuan.com/r.php?r=56036',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (21,'团宝','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.groupon.cn',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (22,'YOKA优享团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.yoka.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (23,'搜狐爱家','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.sohu.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (24,'酷团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.kutuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (25,'快团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuan.pclady.com.cn/invite/i37608',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (26,'喜团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.xituan.com/r.php?r=NTQ1NTQ=',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (27,'阿丫团','-','-',1,0,2,0,1,'2011-06-04 19:11:12','-',0,0,'A','http://www.ayatuan.com/',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (28,'联合购买','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.cobuy.net',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (29,'58团购','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://t.58.com/invite/bj/garrclke',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (30,'点评团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://t.dianping.com/i/6476533/c/1',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (31,'如意团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.ruyituan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (32,'嘀嗒团','-','-',1,0,2,0,1,'2011-06-04 19:19:51','-',0,0,'A','http://www.didatuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (33,'品牌团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.pptg.cn/index.php?res=tuan138.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (34,'偶的团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://oudetuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (35,'聚乐淘','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://j.juletao.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (36,'粉皮儿','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://fenpier.com/r.php?r=54760',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (37,'美尚','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.makeups.cn/Index.html',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (38,'买美诚品','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.51maimei.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (39,'梧桐团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://t.wutoo.cn/r.php?r=18778',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (40,'5151团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.5151tuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (41,'中团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.029678.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (42,'购乐团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.goletuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (43,'婚嫁团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://tuangou.6899.cn',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (44,'婴团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.Ytuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (45,'赶团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.runtuan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (46,'团酷','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.tuanku.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (47,'红爪网','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.hongzhua.cn',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (48,'疯狂卖客','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://crazymike.cn/index.asp?utm_source=refer&utm_campaign=referer50&partner=user_refer&affcode=user_refer_27039',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (49,'现在团','-','-',0,0,2,0,1,'2010-11-07 21:43:48','-',0,0,'A','http://www.xianzaituan.com',0,0,0);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunit`(`gsnutID`,`gsnutName`,`gsnutNameStyle`,`gsnutNumCode`,`gsnutParid`,`gsnutRecycle`,`gsnutChecked`,`gsnutOrderBy`,`gsnutCreateBy`,`gsnutCreateTime`,`gsnutTag`,`gsnutUserPublic`,`gsnutUserPublicGroupid`,`gsnutAlphabet`,`gsnutURL`,`gsnutZoneid`,`gsnutShoppingid`,`gsnutType`) values (50,'小团团购','-','-',3,0,2,0,1,'2011-05-28 20:40:55','-',0,0,'X','http://groupsale.unionnets.com',0,0,0);

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationunitcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationunitcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationunitcont` (
  `gsnuctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnuctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnuctCount_Views` int(11) default '0' COMMENT '查看数',
  `gsnuctCount_Discuss` int(11) default '0' COMMENT '回复数',
  `gsnuctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnuctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnuctChannelid` text COMMENT '所属频道',
  `gsnuctRequireType` int(5) default '0' COMMENT '供求平台关联类型：供应，求购',
  `gsnuctRequireid` int(11) default '0' COMMENT '供求平台关联ID',
  `gsnuctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `gsnuctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `gsnuctDiscussAble` int(2) default '0' COMMENT '是否可以评论',
  `gsnuctKeywordAble` int(2) default '0' COMMENT '是否高亮关键字',
  `gsnuctKeywordContent` varchar(180) default '-' COMMENT '关键字内容',
  `gsnuctPageAble` int(2) default '0' COMMENT '是否分页',
  `gsnuctPower_View` text COMMENT '用户查看权限',
  `gsnuctPower_Public` text COMMENT '用户发布权限',
  `gsnuctSpicalPosition` text COMMENT '特殊位置',
  `gsnuctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `gsnuctSmallContent` varchar(180) default '-' COMMENT '简介',
  `gsnuctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `gsnuctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `gsnuctMetaDescription` text COMMENT 'MetaDescription',
  `gsnuctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnuctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `gsnuctSources` text COMMENT '图集',
  `gsnuctIntroduct` text COMMENT '详细介绍',
  `gsnuctContent` text COMMENT '内容',
  `gsnuctRemark` text COMMENT '备注',
  `gsnuctInfo_Zones` text COMMENT '开通地区',
  `gsnuctInfo_PublishTime` varchar(180) default '-' COMMENT '上线时间',
  `gsnuctInfo_SaleType` int(5) default '0' COMMENT '购买类型',
  `gsnuctInfo_SiteType` int(5) default '0' COMMENT '网站类型',
  `gsnuctInfo_ActiveFrequency` int(5) default '0' COMMENT '组织频率',
  `gsnuctInfo_OrderCount` int(5) default '0' COMMENT '购买人数',
  `gsnuctInfo_Contact` text COMMENT '联系方式',
  `gsnuctFlow_Alex` varchar(180) default '-' COMMENT '网站流量与排名情况(Alex)',
  `gsnuctURL_API` varchar(180) default '-' COMMENT '数据API地址',
  `gsnuctMapIntroduct` varchar(180) default '-' COMMENT '地图标签名称',
  `gsnuctMapX` varchar(42) default '-' COMMENT '地图X座标',
  `gsnuctMapY` varchar(42) default '-' COMMENT '地图Y座标',
  `gsnuctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `gsnuctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `gsnuctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `gsnuctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `gsnuctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `gsnuctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `gsnuctPublisher_Address` varchar(180) default '-' COMMENT '联系地址',
  `gsnuctPublisher_Numcode` varchar(180) default '-' COMMENT '邮编',
  `gsnuctPublisher_Fax` varchar(180) default '-' COMMENT '传真',
  `gsnudctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `gsnuctURL_XML` varchar(180) default '-' COMMENT 'XML方式采集地址，由供应商提供',
  `gsnuctURL_Type` int(5) default '0' COMMENT '采集方式',
  `gsnuctURL_Auto` int(2) default '0' COMMENT '是否自动采集，0否，1是',
  `gsnuctURL_Lasttime` varchar(42) default '' COMMENT '最后采集时间',
  `gsnuctURL_Charset` varchar(42) default 'UTF-8' COMMENT '字符设置',
  `gsnuctURL_Weburl` text COMMENT 'WEB采集方式地址集',
  `gsnuctZones` text COMMENT '开通地区',
  `gsnuctShoppings` text COMMENT '开通商圈',
  `gsnuctCount_Good` int(5) default '0' COMMENT '好评',
  `gsnuctCount_Active` int(5) default '0' COMMENT '活跃',
  `gsnuctCount_Groupsale` int(11) default '0' COMMENT '团购数',
  `gsnuctCount_Complaints` int(11) default '0' COMMENT '总投拆',
  `gsnuctCount_Resolution` decimal(9,2) default '0.00' COMMENT '解决率',
  PRIMARY KEY  (`gsnuctID`),
  KEY `gsnuctIndexID` (`gsnuctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationunitcont` */

insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (1,1,5,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','http://www.meituan.com/wuhan<!---RTB.SPLIT1--->http://www.meituan.com/wuhan\r\n\r\nRULE/meituan_com_groupsalelist.php<!---RTB.SPLIT1--->RULE/meituan_com_groupsaledetail.php<!---RTB.SPLIT1--->RULE/meituan_com_groupsaleclass.php','394,180,149,88,52,','-',0,0,0,0,'-','-','http://www.meituan.com/api/v1/','-','-','-','-','-','-','-','-','-','-','-','-','-','http://www.meituan.com/api/v1/',3,0,'2011-01-28 13:47:44','UTF-8','美团北京地区采集\r\nhttp://www.meituan.com/api/v1/beijing/deals\r\nhttp://www.meituan.com/api/v1/beijing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n北京\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团上海地区采集\r\nhttp://www.meituan.com/api/v1/shanghai/deals\r\nhttp://www.meituan.com/api/v1/shanghai/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n上海\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团广州地区采集\r\nhttp://www.meituan.com/api/v1/guangzhou/deals\r\nhttp://www.meituan.com/api/v1/guangzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n广州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团深圳地区采集\r\nhttp://www.meituan.com/api/v1/shenzhen/deals\r\nhttp://www.meituan.com/api/v1/shenzhen/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n深圳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团天津地区采集\r\nhttp://www.meituan.com/api/v1/tianjin/deals\r\nhttp://www.meituan.com/api/v1/tianjin/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n天津\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团西安地区采集\r\nhttp://www.meituan.com/api/v1/xian/deals\r\nhttp://www.meituan.com/api/v1/xian/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n西安\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团福州地区采集\r\nhttp://www.meituan.com/api/v1/fuzhou/deals\r\nhttp://www.meituan.com/api/v1/fuzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n福州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团重庆地区采集\r\nhttp://www.meituan.com/api/v1/chongqing/deals\r\nhttp://www.meituan.com/api/v1/chongqing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n重庆\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团杭州地区采集\r\nhttp://www.meituan.com/api/v1/hangzhou/deals\r\nhttp://www.meituan.com/api/v1/hangzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n杭州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团南京地区采集\r\nhttp://www.meituan.com/api/v1/nanjing/deals\r\nhttp://www.meituan.com/api/v1/nanjing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n南京\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团合肥地区采集\r\nhttp://www.meituan.com/api/v1/hefei/deals\r\nhttp://www.meituan.com/api/v1/hefei/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n合肥\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团武汉地区采集\r\nhttp://www.meituan.com/api/v1/wuhan/deals\r\nhttp://www.meituan.com/api/v1/wuhan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n武汉\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团郑州地区采集\r\nhttp://www.meituan.com/api/v1/zhengzhou/deals\r\nhttp://www.meituan.com/api/v1/zhengzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n郑州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团成都地区采集\r\nhttp://www.meituan.com/api/v1/chengdu/deals\r\nhttp://www.meituan.com/api/v1/chengdu/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n成都\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团青岛地区采集\r\nhttp://www.meituan.com/api/v1/qingdao/deals\r\nhttp://www.meituan.com/api/v1/qingdao/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n青岛\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团厦门地区采集\r\nhttp://www.meituan.com/api/v1/xiamen/deals\r\nhttp://www.meituan.com/api/v1/xiamen/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n厦门\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团大连地区采集\r\nhttp://www.meituan.com/api/v1/dalian/deals\r\nhttp://www.meituan.com/api/v1/dalian/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n大连\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团沈阳地区采集\r\nhttp://www.meituan.com/api/v1/shenyang/deals\r\nhttp://www.meituan.com/api/v1/shenyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n沈阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团长沙地区采集\r\nhttp://www.meituan.com/api/v1/changsha/deals\r\nhttp://www.meituan.com/api/v1/changsha/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n长沙\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团石家庄地区采集\r\nhttp://www.meituan.com/api/v1/shijiazhuang/deals\r\nhttp://www.meituan.com/api/v1/shijiazhuang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n石家庄\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团苏州地区采集\r\nhttp://www.meituan.com/api/v1/suzhou/deals\r\nhttp://www.meituan.com/api/v1/suzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n苏州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团宁波地区采集\r\nhttp://www.meituan.com/api/v1/ningbo/deals\r\nhttp://www.meituan.com/api/v1/ningbo/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n宁波\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团无锡地区采集\r\nhttp://www.meituan.com/api/v1/wuxi/deals\r\nhttp://www.meituan.com/api/v1/wuxi/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n无锡\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团昆明地区采集\r\nhttp://www.meituan.com/api/v1/kunming/deals\r\nhttp://www.meituan.com/api/v1/kunming/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n昆明\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团济南地区采集\r\nhttp://www.meituan.com/api/v1/jinan/deals\r\nhttp://www.meituan.com/api/v1/jinan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n济南\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团哈尔滨地区采集\r\nhttp://www.meituan.com/api/v1/haerbin/deals\r\nhttp://www.meituan.com/api/v1/haerbin/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n哈尔滨\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团南通地区采集\r\nhttp://www.meituan.com/api/v1/nantong/deals\r\nhttp://www.meituan.com/api/v1/nantong/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n南通\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团东莞地区采集\r\nhttp://www.meituan.com/api/v1/dongguan/deals\r\nhttp://www.meituan.com/api/v1/dongguan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n东莞\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团南宁地区采集\r\nhttp://www.meituan.com/api/v1/nanning/deals\r\nhttp://www.meituan.com/api/v1/nanning/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n南宁\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团长春地区采集\r\nhttp://www.meituan.com/api/v1/changchun/deals\r\nhttp://www.meituan.com/api/v1/changchun/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n长春\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团汕头地区采集\r\nhttp://www.meituan.com/api/v1/shantou/deals\r\nhttp://www.meituan.com/api/v1/shantou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n汕头\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团贵阳地区采集\r\nhttp://www.meituan.com/api/v1/guiyang/deals\r\nhttp://www.meituan.com/api/v1/guiyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n贵阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团温州地区采集\r\nhttp://www.meituan.com/api/v1/wenzhou/deals\r\nhttp://www.meituan.com/api/v1/wenzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n温州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团太原地区采集\r\nhttp://www.meituan.com/api/v1/taiyuan/deals\r\nhttp://www.meituan.com/api/v1/taiyuan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n太原\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团烟台地区采集\r\nhttp://www.meituan.com/api/v1/yantai/deals\r\nhttp://www.meituan.com/api/v1/yantai/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n烟台\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团常州地区采集\r\nhttp://www.meituan.com/api/v1/changzhou/deals\r\nhttp://www.meituan.com/api/v1/changzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n常州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团乌鲁木齐地区采集\r\nhttp://www.meituan.com/api/v1/wulumuqi/deals\r\nhttp://www.meituan.com/api/v1/wulumuqi/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n乌鲁木齐\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团佛山地区采集\r\nhttp://www.meituan.com/api/v1/foshan/deals\r\nhttp://www.meituan.com/api/v1/foshan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n佛山\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团保定地区采集\r\nhttp://www.meituan.com/api/v1/baoding/deals\r\nhttp://www.meituan.com/api/v1/baoding/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n保定\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团兰州地区采集\r\nhttp://www.meituan.com/api/v1/lanzhou/deals\r\nhttp://www.meituan.com/api/v1/lanzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n兰州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团包头地区采集\r\nhttp://www.meituan.com/api/v1/baotou/deals\r\nhttp://www.meituan.com/api/v1/baotou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n包头\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团南昌地区采集\r\nhttp://www.meituan.com/api/v1/nanchang/deals\r\nhttp://www.meituan.com/api/v1/nanchang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n南昌\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团呼和浩特地区采集\r\nhttp://www.meituan.com/api/v1/huhehaote/deals\r\nhttp://www.meituan.com/api/v1/huhehaote/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n呼和浩特\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团唐山地区采集\r\nhttp://www.meituan.com/api/v1/tangshan/deals\r\nhttp://www.meituan.com/api/v1/tangshan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n唐山\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团嘉兴地区采集\r\nhttp://www.meituan.com/api/v1/jiaxing/deals\r\nhttp://www.meituan.com/api/v1/jiaxing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n嘉兴\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团大庆地区采集\r\nhttp://www.meituan.com/api/v1/daqing/deals\r\nhttp://www.meituan.com/api/v1/daqing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n大庆\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团岳阳地区采集\r\nhttp://www.meituan.com/api/v1/yueyang/deals\r\nhttp://www.meituan.com/api/v1/yueyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n岳阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团徐州地区采集\r\nhttp://www.meituan.com/api/v1/xuzhou/deals\r\nhttp://www.meituan.com/api/v1/xuzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n徐州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团惠州地区采集\r\nhttp://www.meituan.com/api/v1/huizhou/deals\r\nhttp://www.meituan.com/api/v1/huizhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n惠州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团扬州地区采集\r\nhttp://www.meituan.com/api/v1/yangzhou/deals\r\nhttp://www.meituan.com/api/v1/yangzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n扬州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团拉萨地区采集\r\nhttp://www.meituan.com/api/v1/lasa/deals\r\nhttp://www.meituan.com/api/v1/lasa/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n拉萨\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团柳州地区采集\r\nhttp://www.meituan.com/api/v1/liuzhou/deals\r\nhttp://www.meituan.com/api/v1/liuzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n柳州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团泉州地区采集\r\nhttp://www.meituan.com/api/v1/quanzhou/deals\r\nhttp://www.meituan.com/api/v1/quanzhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n泉州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团泰州地区采集\r\nhttp://www.meituan.com/api/v1/taizhou/deals\r\nhttp://www.meituan.com/api/v1/taizhou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n泰州\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团洛阳地区采集\r\nhttp://www.meituan.com/api/v1/luoyang/deals\r\nhttp://www.meituan.com/api/v1/luoyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n洛阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团海口地区采集\r\nhttp://www.meituan.com/api/v1/haikou/deals\r\nhttp://www.meituan.com/api/v1/haikou/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n海口\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团湛江地区采集\r\nhttp://www.meituan.com/api/v1/zhanjiang/deals\r\nhttp://www.meituan.com/api/v1/zhanjiang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n湛江\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团潍坊地区采集\r\nhttp://www.meituan.com/api/v1/weifang/deals\r\nhttp://www.meituan.com/api/v1/weifang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n潍坊\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团珠海地区采集\r\nhttp://www.meituan.com/api/v1/zhuhai/deals\r\nhttp://www.meituan.com/api/v1/zhuhai/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n珠海\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团盐城地区采集\r\nhttp://www.meituan.com/api/v1/yancheng/deals\r\nhttp://www.meituan.com/api/v1/yancheng/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n盐城\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团秦皇岛地区采集\r\nhttp://www.meituan.com/api/v1/qinhuangdao/deals\r\nhttp://www.meituan.com/api/v1/qinhuangdao/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n秦皇岛\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团绍兴地区采集\r\nhttp://www.meituan.com/api/v1/shaoxing/deals\r\nhttp://www.meituan.com/api/v1/shaoxing/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n绍兴\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团芜湖地区采集\r\nhttp://www.meituan.com/api/v1/wuhu/deals\r\nhttp://www.meituan.com/api/v1/wuhu/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n芜湖\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团衡阳地区采集\r\nhttp://www.meituan.com/api/v1/hengyang/deals\r\nhttp://www.meituan.com/api/v1/hengyang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n衡阳\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团西宁地区采集\r\nhttp://www.meituan.com/api/v1/xining/deals\r\nhttp://www.meituan.com/api/v1/xining/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n西宁\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团银川地区采集\r\nhttp://www.meituan.com/api/v1/yinchuan/deals\r\nhttp://www.meituan.com/api/v1/yinchuan/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n银川\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团镇江地区采集\r\nhttp://www.meituan.com/api/v1/zhenjiang/deals\r\nhttp://www.meituan.com/api/v1/zhenjiang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n镇江\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团香港地区采集\r\nhttp://www.meituan.com/api/v1/xianggang/deals\r\nhttp://www.meituan.com/api/v1/xianggang/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n香港\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团澳门地区采集\r\nhttp://www.meituan.com/api/v1/aomen/deals\r\nhttp://www.meituan.com/api/v1/aomen/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n澳门\r\n1\r\n<!---RTB.SPLIT1--->\r\n美团台北地区采集\r\nhttp://www.meituan.com/api/v1/taibei/deals\r\nhttp://www.meituan.com/api/v1/taibei/deals\r\nRULE/meituan_api_gsactivelist.php\r\nRULE/meituan_api_gsactivedetail.php\r\nRULE/meituan_api_gsactiveclass.php\r\n台北\r\n1\r\n<!---RTB.SPLIT1--->','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (2,2,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','0','-',0,0,0,0,'-','-','http://127.0.0.1:8080/_PROGRAM/MYPROJECT/Project0/unionNets/Program/version_0.042/unionNets/User/project/_DemoCore/webSite/Html/Xml/Groupsale/Groupsale_Data.xml','-','-','-','-','-','-','-','-','-','-','-','-','-','http://open.client.lashou.com/v1/hao123',2,0,'2011-02-17 14:16:57','UTF-8','拉手当日采集\r\nhttp://open.client.lashou.com/list/api/\r\nhttp://open.client.lashou.com/list/api/\r\nRULE/lashou_api_gsactivelist.php\r\nRULE/lashou_api_gsactivedetail.php\r\nRULE/lashou_api_gsactiveclass.php\r\n1\r\n1\r\n<!---RTB.SPLIT1--->','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (3,3,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','0','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://www.24quan.com/api/alliance.php',4,0,'2011-01-28 13:47:44','UTF-8','24券当日采集\r\nhttp://www.24quan.com/api/alliance.php\r\nhttp://www.24quan.com/api/alliance.php\r\nRULE/24quan_api_gsactivelist.php\r\nRULE/24quan_api_gsactivedetail.php\r\nRULE/24quan_api_gsactiveclass.php\r\n1\r\n1\r\n<!---RTB.SPLIT1--->','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (4,4,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://api.manzuo.com/common.xml',5,0,'2011-01-08 02:38:31','UTF-8','','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (5,5,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'2011-01-08 02:38:31','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (6,6,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (7,7,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://all.gtuan.com/api/',2,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (8,8,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (9,9,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (10,10,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (11,11,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (12,12,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (13,13,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (14,14,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (15,15,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (16,16,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (17,17,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://www.nuomi.com/api/dailydeal?version=v1&city=wuhan&city=xian',2,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (18,18,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (19,19,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (20,20,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (21,21,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (22,22,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (23,23,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (24,24,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (25,25,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (26,26,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (27,27,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://api.ayatuan.com/api/hao123/apihao123.xml',2,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (28,28,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (29,29,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (30,30,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (31,31,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (32,32,1,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://didatuan.com/api/baidu.php',2,0,'','UTF-8','','','',0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (33,33,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (34,34,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (35,35,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (36,36,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (37,37,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (38,38,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (39,39,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (40,40,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (41,41,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (42,42,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (43,43,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (44,44,1,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (45,45,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (46,46,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (47,47,1,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (48,48,0,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (49,49,1,0,0,0,NULL,0,0,0,0,0,0,'-',0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL,NULL,'-',0,0,0,0,NULL,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',0,0,'','UTF-8',NULL,NULL,NULL,0,0,0,0,'0.00');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitcont`(`gsnuctID`,`gsnuctIndexID`,`gsnuctCount_Views`,`gsnuctCount_Discuss`,`gsnuctCode_Positive`,`gsnuctCode_Negative`,`gsnuctChannelid`,`gsnuctRequireType`,`gsnuctRequireid`,`gsnuctModelid_Detail`,`gsnuctTemplateid_Detail`,`gsnuctDiscussAble`,`gsnuctKeywordAble`,`gsnuctKeywordContent`,`gsnuctPageAble`,`gsnuctPower_View`,`gsnuctPower_Public`,`gsnuctSpicalPosition`,`gsnuctSmallTitle`,`gsnuctSmallContent`,`gsnuctMetaTitle`,`gsnuctMetaKeyword`,`gsnuctMetaDescription`,`gsnuctSourceR00`,`gsnuctSourceR01`,`gsnuctSources`,`gsnuctIntroduct`,`gsnuctContent`,`gsnuctRemark`,`gsnuctInfo_Zones`,`gsnuctInfo_PublishTime`,`gsnuctInfo_SaleType`,`gsnuctInfo_SiteType`,`gsnuctInfo_ActiveFrequency`,`gsnuctInfo_OrderCount`,`gsnuctInfo_Contact`,`gsnuctFlow_Alex`,`gsnuctURL_API`,`gsnuctMapIntroduct`,`gsnuctMapX`,`gsnuctMapY`,`gsnuctPublisher_Name`,`gsnuctPublisher_Email`,`gsnuctPublisher_Source`,`gsnuctPublisher_Mobile`,`gsnuctPublisher_Tele`,`gsnuctPublisher_Software`,`gsnuctPublisher_Address`,`gsnuctPublisher_Numcode`,`gsnuctPublisher_Fax`,`gsnudctPublisher_Homepage`,`gsnuctURL_XML`,`gsnuctURL_Type`,`gsnuctURL_Auto`,`gsnuctURL_Lasttime`,`gsnuctURL_Charset`,`gsnuctURL_Weburl`,`gsnuctZones`,`gsnuctShoppings`,`gsnuctCount_Good`,`gsnuctCount_Active`,`gsnuctCount_Groupsale`,`gsnuctCount_Complaints`,`gsnuctCount_Resolution`) values (50,50,0,0,0,0,'',0,0,0,0,0,0,'-',0,'0','0','0','-','-','-','-','','-','-','','','','','-','-',0,0,0,0,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','http://127.0.0.1:8080/_PROGRAM/MYPROJECT/unionnets_com/unionnets_0042/webSite/Site_0/User/Project/_DemoCore/webSite/Html/Xml/Groupsale/Groupsale_Data.xml',1,0,'','UTF-8','','','',0,0,0,0,'0.00');

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationunitdiscuss` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationunitdiscuss`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationunitdiscuss` (
  `gsnudtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnudtName` varchar(180) default '-' COMMENT '名称',
  `gsnudtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `gsnudtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnudtParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnudtType` int(5) default '0' COMMENT '类型',
  `gsnudtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnudtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnudtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnudtCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnudtCreateTime` datetime default NULL COMMENT '发布时间',
  PRIMARY KEY  (`gsnudtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationunitdiscuss` */

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationunitdiscusscont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationunitdiscusscont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationunitdiscusscont` (
  `gsnudctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnudctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnudctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnudctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnudctCode_BePositive` int(11) default '0' COMMENT '正面被打分',
  `gsnudctCode_BeNegative` int(11) default '0' COMMENT '负面被打分',
  `gsnudctPower_View` text COMMENT '用户查看权限',
  `gsnudctSpicalPosition` text COMMENT '特殊位置',
  `gsnudctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnudctContent` text COMMENT '内容',
  `gsnudctPublisher_Name` varchar(180) default '-' COMMENT '发布人名称',
  `gsnudctPublisher_Email` varchar(180) default '-' COMMENT '发布人电邮',
  `gsnudctPublisher_Source` varchar(180) default '-' COMMENT '发布人图片',
  `gsnudctPublisher_Mobile` varchar(180) default '-' COMMENT '手机号',
  `gsnudctPublisher_Tele` varchar(180) default '-' COMMENT '电话号码',
  `gsnudctPublisher_Software` varchar(180) default '-' COMMENT '软件',
  `gsnudctPublisher_Homepage` varchar(180) default '-' COMMENT '网址',
  `gsnudctRemark` text COMMENT '备注',
  PRIMARY KEY  (`gsnudctID`),
  KEY `gsnudctIndexID` (`gsnudctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationunitdiscusscont` */

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationunitgroup` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationunitgroup` (
  `gsnugtID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnugtName` varchar(180) default '-' COMMENT '名称',
  `gsnugtNameStyle` varchar(180) default '-' COMMENT '名称样式',
  `gsnugtNumCode` varchar(42) default '-' COMMENT '表内唯一编号',
  `gsnugtParid` int(11) default '0' COMMENT '上级或分类ID',
  `gsnugtRecycle` int(2) default '0' COMMENT '是否放入回收站',
  `gsnugtChecked` int(2) default '2' COMMENT '审核:0.未审核,1.不通过审核,2.通过审核',
  `gsnugtOrderBy` int(9) default '0' COMMENT '排序:越大的在越前面',
  `gsnugtCreateBy` int(11) default '0' COMMENT '发布人',
  `gsnugtCreateTime` datetime default NULL COMMENT '发布时间',
  `gsnugtTag` varchar(180) default '-' COMMENT '标签',
  PRIMARY KEY  (`gsnugtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationunitgroup` */

insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (1,'ROOT','-','-',0,0,2,10,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (2,'网集团购网站分类','-','-',1,0,2,9,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (3,'餐饮美食','-','-',2,0,2,8,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (4,'休闲娱乐','-','-',2,0,2,7,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (5,'美容健身','-','-',2,0,2,6,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (8,'精品购物','-','-',2,0,2,3,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (9,'摄影写真','-','-',2,0,2,2,0,NULL,'-');
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroup`(`gsnugtID`,`gsnugtName`,`gsnugtNameStyle`,`gsnugtNumCode`,`gsnugtParid`,`gsnugtRecycle`,`gsnugtChecked`,`gsnugtOrderBy`,`gsnugtCreateBy`,`gsnugtCreateTime`,`gsnugtTag`) values (10,'其它','-','-',2,0,2,1,0,NULL,'-');

/*Table structure for table `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont` */

DROP TABLE IF EXISTS `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`;

CREATE TABLE `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont` (
  `gsnugctID` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gsnugctIndexID` int(11) default '0' COMMENT '主表ID号',
  `gsnugctCount_Views` int(11) default '0' COMMENT '查看数',
  `gsnugctCount_Info` int(11) default '0' COMMENT '所属此分类的数据条数',
  `gsnugctCount_InfoAll` int(11) default '0' COMMENT '所属此分类的所有的数据条数，包括子分类',
  `gsnugctCount_Discuss` int(11) default '0' COMMENT '所属此分类数据的回复条数',
  `gsnugctCount_DiscussAll` int(11) default '0' COMMENT '所属此分类数据的回复条数，包括子分类',
  `gsnugctCode_Positive` int(11) default '0' COMMENT '正面打分',
  `gsnugctCode_Negative` int(11) default '0' COMMENT '负面打分',
  `gsnugctChannelid` text COMMENT '所属频道',
  `gsnugctModelid_List` int(11) default '0' COMMENT '列表模型',
  `gsnugctModelid_Detail` int(11) default '0' COMMENT '详细内容模型',
  `gsnugctTemplateid_Home` int(11) default '0' COMMENT '首页模板',
  `gsnugctTemplateid_List` int(11) default '0' COMMENT '列表模板',
  `gsnugctTemplateid_Detail` int(11) default '0' COMMENT '详细内容模板',
  `gsnugctPower_View` text COMMENT '用户查看权限',
  `gsnugctPower_Public` text COMMENT '用户发布权限',
  `gsnugctSpicalPosition` text COMMENT '特殊位置',
  `gsnugctSmallTitle` varchar(180) default '-' COMMENT '副标题',
  `gsnugctSmallContent` varchar(180) default '-' COMMENT '简介',
  `gsnugctMetaTitle` varchar(180) default '-' COMMENT 'MetaTitle',
  `gsnugctMetaKeyword` varchar(180) default '-' COMMENT 'MetaKeyword',
  `gsnugctMetaDescription` text COMMENT 'MetaDescription',
  `gsnugctSourceR00` varchar(180) default '-' COMMENT '小图片',
  `gsnugctSourceR01` varchar(180) default '-' COMMENT '大图片',
  `gsnugctSources` text COMMENT '图集',
  `gsnugctIntroduct` text COMMENT '详细介绍',
  `gsnugctContent` text COMMENT '内容',
  `gsnugctRemark` text COMMENT '备注',
  PRIMARY KEY  (`gsnugctID`),
  KEY `gsnugctIndexID` (`gsnugctIndexID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont` */

insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (1,1,0,9,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (2,2,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (3,3,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (4,4,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (5,5,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (8,8,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (9,9,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
insert  into `{NetsInstall.Db_Tablehead}gsnavigationunitgroupcont`(`gsnugctID`,`gsnugctIndexID`,`gsnugctCount_Views`,`gsnugctCount_Info`,`gsnugctCount_InfoAll`,`gsnugctCount_Discuss`,`gsnugctCount_DiscussAll`,`gsnugctCode_Positive`,`gsnugctCode_Negative`,`gsnugctChannelid`,`gsnugctModelid_List`,`gsnugctModelid_Detail`,`gsnugctTemplateid_Home`,`gsnugctTemplateid_List`,`gsnugctTemplateid_Detail`,`gsnugctPower_View`,`gsnugctPower_Public`,`gsnugctSpicalPosition`,`gsnugctSmallTitle`,`gsnugctSmallContent`,`gsnugctMetaTitle`,`gsnugctMetaKeyword`,`gsnugctMetaDescription`,`gsnugctSourceR00`,`gsnugctSourceR01`,`gsnugctSources`,`gsnugctIntroduct`,`gsnugctContent`,`gsnugctRemark`) values (10,10,0,0,0,0,0,0,0,NULL,0,0,0,0,0,NULL,NULL,NULL,'-','-','-','-',NULL,'-','-',NULL,NULL,NULL,NULL);
