<?php
require('Inc/netsConfig.php');
require('Inc/netsFile.php');
require('Inc/netsCode.php');
require('Inc/netsMySql.php');

class PaDefault extends netsConfig {
	//-- #Check --
	public $sSystem_OS_STR='';
	public $sSystem_PHP_STR='';
	public $sSystem_MYSQL_STR='';
	public $sSystem_DiskSize_STR='';
	public $sSystem_UploadSize_STR='';
	
	public $sSystem_OS_Boolean=false;
	public $sSystem_PHP_Boolean=false;
	public $sSystem_MYSQL_Boolean=false;
	public $sSystem_DiskSize_Boolean=false;
	public $sSystem_UploadSize_Boolean=false;
	
	public $sSystem_mysql_connect_Boolean=false;
	public $sSystem_fsockopen_Boolean=false;
	public $sSystem_gethostbyname_Boolean=false;
	public $sSystem_file_get_contents_Boolean=false;
	public $sSystem_xml_parser_create_Boolean=false;
	
	public $sSystem_Boolean=false;
	public $sInstallYet_Boolean=false;
	//-- ### --
	public $sPanelIndex=0;
	public $sCode=array();
	
	public function PaDefault(){
		$this->netsConfig();
		//-- ------ #Initial ------ --
		$this->sCode=new netsCode();
		
		$this->sInstall_Flag='';
		$this->sInstall_Index=0;
		$this->sInstall_Content='';
		//-- ------ #ActionType ------ --
		$tmpAR0=$this->sCode->AnalyerRequest('ActionType','',0);
		$this->sActionType=$tmpAR0[0];
		if ($this->sActionType=='DInstall'){
			$this->OnInstall();
		}else if ($this->sActionType=='DDbConnectionTest'){
			$this->OnDbConnectionTest();
		}else if ($this->sActionType=='DRInstall'){
			$this->OnRInstall();
			$this->OnList();
		}else {
			$this->OnList();
		}
		
		
	}
	public function OnInstall(){
		//-- ------ #Initial ------ --
		$tmpFile=new netsFile();
		//-- ------ #Request ------ --
		$tmpAR0=$this->sCode->AnalyerRequest('DInstall',',0',0);
		
		$tmpAR_Db_Host=$this->sCode->AnalyerRequest('Db_Host','',0);
		$tmpAR_Db_Dbname=$this->sCode->AnalyerRequest('Db_Dbname','',0);
		$tmpAR_Db_Port=$this->sCode->AnalyerRequest('Db_Port','',0);
		$tmpAR_Db_Tablehead=$this->sCode->AnalyerRequest('Db_Tablehead','',0);
		$tmpAR_Db_Username=$this->sCode->AnalyerRequest('Db_Username','',0);
		$tmpAR_Db_Pxd=$this->sCode->AnalyerRequest('Db_Pxd','',0);
		$tmpAR_Db_Models_Value=$this->sCode->AnalyerRequest('Db_Models_Value','',0);
		$tmpAR_Db_Models_Text=$this->sCode->AnalyerRequest('Db_Models_Text','',0);
		$tmpAR_SystemInfo_Name=$this->sCode->AnalyerRequest('SystemInfo_Name','',0);
		$tmpAR_SystemInfo_Meta=$this->sCode->AnalyerRequest('SystemInfo_Meta','',0);
		$tmpAR_SystemInfo_Keyword=$this->sCode->AnalyerRequest('SystemInfo_Keyword','',0);
		$tmpAR_SystemInfo_Descriptions=$this->sCode->AnalyerRequest('SystemInfo_Descriptions','',0);
		$tmpSTR=$this->sCode->getSiteURL();
		$tmpSTR=str_replace('INSTALL/index.php','',$tmpSTR);
		$tmpAR_SystemInfo_Root=array($tmpSTR);
		$tmpAR_SystemUser_Name=$this->sCode->AnalyerRequest('SystemUser_Name','',0);
		$tmpAR_SystemUser_Pxd=$this->sCode->AnalyerRequest('SystemUser_Pxd','',0);
		$tmpAR_SystemUser_PxdConfirm=$this->sCode->AnalyerRequest('SystemUser_PxdConfirm','',0);
		$tmpAR_SystemUser_Email=$this->sCode->AnalyerRequest('SystemUser_Email','',0);
		$tmpAR_SystemUser_InstallYet=$this->sCode->AnalyerRequest('SystemUser_InstallYet','',0);
		
		//-- ------ #Check LOCK Install ------ --
		$tmpSTR=$tmpFile->readFile($this->sysFileConfig['sInstallLock_Path']);
		if ($tmpSTR!=''){
			$this->sInstallYet_Boolean=true;
			$this->sMessage=$this->InstallMessage('ERROR',0,
				'您已安装过本系统，请清理安装锁文件后，再尝试再次安装',
				$this->sysFileConfig['sErrorSTR']);
			return 1;
		}
		//-- ------ #Progress ------ --
		if ($tmpAR0[0]=='INITIAL'){
			//-- #Initial --
			$this->sMessage=$this->InstallMessage('INIT_DONE',0,
				'初始化安装设置...',
				$this->sysFileConfig['sSuccessSTR']);
			//-- #Create db --
			$tmpMySql=new netsMySql($tmpAR_Db_Host[0].$this->sysSPLIT1.
				$tmpAR_Db_Port[0].$this->sysSPLIT1.
				$tmpAR_Db_Username[0].$this->sysSPLIT1.
				$tmpAR_Db_Pxd[0].$this->sysSPLIT1.
				$tmpAR_Db_Dbname[0].$this->sysSPLIT1.
				$this->sysCharset);
			$tmpINT=$tmpMySql->TestConnection();
			$tmpINT=$tmpMySql->TestDbExist();
			if ($tmpINT!=0) {
				$tmpINT=$tmpMySql->Create($tmpAR_Db_Dbname[0]);
				if ($tmpINT!=0){
					$this->sMessage=$this->InstallMessage('ERROR',0,
						'对不起，创建数据库失败...',
						$this->sysFileConfig['sErrorSTR']);
					return 1;
				}
			}
			
		}else if ($tmpAR0[0]=='READCONFIG'){
			//-- #Read system config file --
			//-- #Check index --
			if (count($this->sysConfigFilePath)<=$tmpAR0[1]){
				$this->sMessage=$this->InstallMessage('FILE_DONE',100,
					'设置并保存系统文件已完成...',
					$this->sysFileConfig['sSuccessSTR']);
			}
			//-- #Do --
			$tmpSTR=$tmpFile->readFile($this->sysConfigFilePath[$tmpAR0[1]][1]);
			if ($tmpSTR==''){
				$this->sMessage=$this->InstallMessage('ERROR',0,
					'对不起，安装失败，您的'.$this->sysConfigFilePath[$tmpAR0[1]][0].'文件未找到，请检查安装包的完整性，或从官方网站重新下载安装包(READCONFIG)...',
					$this->sysFileConfig['sErrorSTR']);
				return 1;
			}
			
			$tmpSTR=str_replace('{NetsInstall.Db_Host}',$tmpAR_Db_Host[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Dbname}',$tmpAR_Db_Dbname[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Port}',$tmpAR_Db_Port[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Tablehead}',$tmpAR_Db_Tablehead[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Username}',$tmpAR_Db_Username[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Pxd}',$tmpAR_Db_Pxd[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Name}',$tmpAR_SystemInfo_Name[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Meta}',$tmpAR_SystemInfo_Meta[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Keyword}',$tmpAR_SystemInfo_Keyword[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Descriptions}',$tmpAR_SystemInfo_Descriptions[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Root}',$tmpAR_SystemInfo_Root[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_Name}',$tmpAR_SystemUser_Name[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_Pxd}',$this->sCode->SamplePxd($tmpAR_SystemUser_Pxd[0]),$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_PxdConfirm}',$this->sCode->SamplePxd($tmpAR_SystemUser_PxdConfirm[0]),$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_Email}',$tmpAR_SystemUser_Email[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_InstallYet}',$tmpAR_SystemUser_InstallYet[0],$tmpSTR);
			
			$tmpINT=$tmpFile->writeFile($this->sysFilepath.$this->sysConfigFilePath[$tmpAR0[1]][2],$tmpSTR);
			if ($tmpINT!=0){
				$this->sMessage=$this->InstallMessage('ERROR',0,
					'对不起，安装失败，保存'.$this->sysConfigFilePath[$tmpAR0[1]][0].'文件失败，请检查目录权限(READCONFIG)...',
					$this->sysFileConfig['sErrorSTR']);
				return 1;
			}
			//-- #Next --
			$tmpIndex=$tmpAR0[1]+1;
			if ($tmpAR0[1]==(count($this->sysConfigFilePath)-1)){
				$tmpIndex=100;
			}
			$this->sMessage=$this->InstallMessage('FILE_DONE',$tmpIndex,
					'设置并保存'.$this->sysConfigFilePath[$tmpAR0[1]][0].'文件...',
					$this->sysFileConfig['sSuccessSTR']);
		}else if ($tmpAR0[0]=='READDB'){
			//-- #Read db file --
			$tmpAR_Models_Value=explode($this->sysSPLIT2,$tmpAR_Db_Models_Value[0]);
			$tmpAR_Models_Text=explode($this->sysSPLIT2,$tmpAR_Db_Models_Text[0]);
			//-- #Check index --
			array_pop($tmpAR_Models_Value);
			if (count($tmpAR_Models_Value)==0){
				$this->sMessage=$this->InstallMessage('DBFILE_DONE',100,
					'设置并保存数据文件已完成...',
					$this->sysFileConfig['sSuccessSTR']);
				return 0;
			}
			//-- #Do --
			$tmpPath=str_replace('{Nets.Filename}',$tmpAR_Models_Value[$tmpAR0[1]],$this->sysFileConfig['sDbFilepath_Origin']);
			$tmpSTR=$tmpFile->readFile($tmpPath);
			if ($tmpSTR==''){
				$this->sMessage=$this->InstallMessage('ERROR',0,
					'对不起，安装失败，您的'.$tmpAR_Models_Text[$tmpAR0[1]].'文件未找到，请检查安装包的完整性，或从官方网站重新下载安装包(READDB)...',
					$this->sysFileConfig['sErrorSTR']);
				return 1;
			}
			
			$tmpSTR=str_replace('{NetsInstall.Db_Host}',$tmpAR_Db_Host[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Dbname}',$tmpAR_Db_Dbname[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Port}',$tmpAR_Db_Port[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Tablehead}',$tmpAR_Db_Tablehead[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Username}',$tmpAR_Db_Username[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.Db_Pxd}',$tmpAR_Db_Pxd[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Name}',$tmpAR_SystemInfo_Name[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Meta}',$tmpAR_SystemInfo_Meta[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Keyword}',$tmpAR_SystemInfo_Keyword[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Descriptions}',$tmpAR_SystemInfo_Descriptions[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemInfo_Root}',$tmpAR_SystemInfo_Root[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_Name}',$tmpAR_SystemUser_Name[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_Pxd}',$this->sCode->SamplePxd($tmpAR_SystemUser_Pxd[0]),$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_PxdConfirm}',$this->sCode->SamplePxd($tmpAR_SystemUser_PxdConfirm[0]),$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_Email}',$tmpAR_SystemUser_Email[0],$tmpSTR);
			$tmpSTR=str_replace('{NetsInstall.SystemUser_InstallYet}',$tmpAR_SystemUser_InstallYet[0],$tmpSTR);
			
			$tmpPath=str_replace('{Nets.Filename}',$tmpAR_Models_Value[$tmpAR0[1]],$this->sysFileConfig['sDbFilepath_Copyto']);
			$tmpINT=$tmpFile->writeFile($tmpPath,$tmpSTR);
			if ($tmpINT!=0){
				$this->sMessage=$this->InstallMessage('ERROR',0,
					'对不起，安装失败，保存'.$tmpAR_Models_Text[$tmpAR0[1]].'文件失败，请检查目录权限(READDB)...',
					$this->sysFileConfig['sErrorSTR']);
				return 1;
			}
			//-- #Next --
			$tmpIndex=$tmpAR0[1]+1;
			if ($tmpAR0[1]==count($tmpAR_Models_Value)-1){
				$tmpIndex=100;
			}
			
			$this->sMessage=$this->InstallMessage('DBFILE_DONE',$tmpIndex,
				'设置并保存'.$tmpAR_Models_Text[$tmpAR0[1]].'文件...',
				$this->sysFileConfig['sSuccessSTR']);
		}else if ($tmpAR0[0]=='BUILDDB'){
			//-- #Building DB --
			$tmpAR_Models_Value=explode($this->sysSPLIT2,$tmpAR_Db_Models_Value[0]);
			$tmpAR_Models_Text=explode($this->sysSPLIT2,$tmpAR_Db_Models_Text[0]);
			//-- #Check index --
			array_pop($tmpAR_Models_Value);
			if (count($tmpAR_Models_Value)==0){
				$this->sMessage=$this->InstallMessage('DB_DONE',100,
					'生成数据库已完成...',
					$this->sysFileConfig['sSuccessSTR']);
				return 0;
			}
			//-- #Do --
			$tmpPath=str_replace('{Nets.Filename}',$tmpAR_Models_Value[$tmpAR0[1]],$this->sysFileConfig['sDbFilepath_Copyto']);
			$tmpSTR=$tmpFile->readFile($tmpPath);
			if ($tmpSTR==''){
				$this->sMessage=$this->InstallMessage('ERROR',0,
					'对不起，安装失败，您的'.$tmpAR_Models_Text[$tmpAR0[1]].'文件未找到，请检查安装包的完整性，或从官方网站重新下载安装包(BUILDDB)...',
					$this->sysFileConfig['sErrorSTR']);
				return 1;
			}
			
			$tmpMySql=new netsMySql($tmpAR_Db_Host[0].$this->sysSPLIT1.
				$tmpAR_Db_Port[0].$this->sysSPLIT1.
				$tmpAR_Db_Username[0].$this->sysSPLIT1.
				$tmpAR_Db_Pxd[0].$this->sysSPLIT1.
				$tmpAR_Db_Dbname[0].$this->sysSPLIT1.
				$this->sysCharset);
			$tmpINT=$tmpMySql->Executes($tmpSTR,0,0,0);
			if ($tmpINT!=0){
				$this->sMessage=$this->InstallMessage('ERROR',0,
					'对不起，安装失败，生成'.$tmpAR_Models_Text[$tmpAR0[1]].'失败，请从官方网站上更新您的数据包(BUILDDB)...',
					$this->sysFileConfig['sErrorSTR']);
				return 1;
			}
			
			//-- #Next --
			$tmpIndex=$tmpAR0[1]+1;
			if ($tmpAR0[1]==count($tmpAR_Models_Value)-1){
				$tmpIndex=100;
			}
			$this->sMessage=$this->InstallMessage('DB_DONE',$tmpIndex,
					'执行构建'.$tmpAR_Models_Text[$tmpAR0[1]].'...',
					$this->sysFileConfig['sSuccessSTR']);
		}else if ($tmpAR0[0]=='DBDESCRIPTIONS'){
			//-- #DbDescriptions --
			$tmpSectionSize=100;
			$tmpFileType=array('php',);
			//-- #Do --
			$tmpStartIndex=$tmpAR0[1]*$tmpSectionSize;
			$tmpEndIndex=($tmpAR0[1]+1)*$tmpSectionSize;
			$tmpFlag=0;
			$tmpHandle=opendir($this->sysFileConfig['sDbDescriptionPath_Origin']);
			if($tmpHandle){
				$Coun0=0;
				while (($tmpFilename=readdir($tmpHandle))!=false) {
					$tmpSTR=$tmpFile->getFileExname($tmpFilename);
					if(in_array($tmpSTR,$tmpFileType) && $tmpStartIndex<=$Coun0 && $Coun0<$tmpEndIndex){
						$tmpSTR=$tmpFile->readFile($this->sysFileConfig['sDbDescriptionPath_Origin'].$tmpFilename);
						
						$tmpSTR=str_replace('{NetsInstall.Db_Host}',$tmpAR_Db_Host[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.Db_Dbname}',$tmpAR_Db_Dbname[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.Db_Port}',$tmpAR_Db_Port[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.Db_Tablehead}',$tmpAR_Db_Tablehead[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.Db_Username}',$tmpAR_Db_Username[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.Db_Pxd}',$tmpAR_Db_Pxd[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemInfo_Name}',$tmpAR_SystemInfo_Name[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemInfo_Meta}',$tmpAR_SystemInfo_Meta[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemInfo_Keyword}',$tmpAR_SystemInfo_Keyword[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemInfo_Descriptions}',$tmpAR_SystemInfo_Descriptions[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemInfo_Root}',$tmpAR_SystemInfo_Root[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemUser_Name}',$tmpAR_SystemUser_Name[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemUser_Pxd}',$this->sCode->SamplePxd($tmpAR_SystemUser_Pxd[0]),$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemUser_PxdConfirm}',$this->sCode->SamplePxd($tmpAR_SystemUser_PxdConfirm[0]),$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemUser_Email}',$tmpAR_SystemUser_Email[0],$tmpSTR);
						$tmpSTR=str_replace('{NetsInstall.SystemUser_InstallYet}',$tmpAR_SystemUser_InstallYet[0],$tmpSTR);
						
						$tmpPath=$this->sysFilepath.$this->sysFileConfig['sDbDescriptionPath_Copyto'].$tmpFilename;
						$tmpINT=$tmpFile->writeFile($tmpPath,$tmpSTR);
						if ($tmpINT!=0){
							$this->sMessage=$this->InstallMessage('ERROR',0,
								'对不起，安装失败，保存数据结构映射文件失败，请检查目录权限(DBDESCRIPTIONS,SECTION:'.$tmpAR0[1].')...',
								$this->sysFileConfig['sErrorSTR']);
							return 1;
						}
						$tmpFlag=1;
					}
					
					$Coun0++;
				}
				closedir($tmpHandle);
			}

			//-- #Next --
			$tmpIndex=$tmpAR0[1]+1;
			if ($tmpAR0[1]==15 || $tmpFlag==0){
				$tmpIndex=100;
			}
			$this->sMessage=$this->InstallMessage('DBDESCRIPTIONS_DONE',$tmpIndex,
					'执行构建数据结构映射文件[SECTION:'.$tmpIndex.']...',
					$this->sysFileConfig['sSuccessSTR']);
		}else if ($tmpAR0[0]=='CLEAR'){
			//-- #Clear --
			if ($tmpAR_SystemUser_InstallYet[0]==0){
				$tmpINT=$tmpFile->writeFile($this->sysFileConfig['sInstallLock_Path'],$this->sysFileConfig['sInstallLock_Content']);
			}else if ($tmpAR_SystemUser_InstallYet[0]==1){
				//$tmpINT=$tmpFile->deleteFile($this->sysFileConfig['sInstallPath']);
			}
			if ($tmpINT!=0){
				$this->sMessage=$this->InstallMessage('SUCCESS',0,
					'安装成功，但生成安装锁定文件或清理安装目录时失败(CLEAR)',
					$this->sysFileConfig['sAlertSTR']);
			}else {
				$this->sMessage=$this->InstallMessage('SUCCESS',0,
					'安装成功，清理安装文件',
					$this->sysFileConfig['sSuccessSTR']);
			}
		}

		return 0;
	}
	public function OnDbConnectionTest(){
		//-- ------ #Initial ------ --
		//-- ------ #Request ------ --
		$tmpAR_Db_Host=$this->sCode->AnalyerRequest('Db_Host','',0);
		$tmpAR_Db_Dbname=$this->sCode->AnalyerRequest('Db_Dbname','',0);
		$tmpAR_Db_Port=$this->sCode->AnalyerRequest('Db_Port','',0);
		$tmpAR_Db_Tablehead=$this->sCode->AnalyerRequest('Db_Tablehead','',0);
		$tmpAR_Db_Username=$this->sCode->AnalyerRequest('Db_Username','',0);
		$tmpAR_Db_Pxd=$this->sCode->AnalyerRequest('Db_Pxd','',0);

		$tmpMySql=new netsMySql($tmpAR_Db_Host[0].$this->sysSPLIT1.
			$tmpAR_Db_Port[0].$this->sysSPLIT1.
			$tmpAR_Db_Username[0].$this->sysSPLIT1.
			$tmpAR_Db_Pxd[0].$this->sysSPLIT1.
			$tmpAR_Db_Dbname[0].$this->sysSPLIT1.
			$this->sysCharset);
		$tmpINT=$tmpMySql->TestConnection();
		$this->sMessage='Success';
		if ($tmpINT!=0){
			$this->sMessage='Error';
			return 1;
		}
		
		return 0;
	}
	public function OnRInstall(){
		//-- ------ #Initial ------ --
		$tmpFile=new netsFile();
		//-- ------ #Delete lock file ------ --
		$tmpINT=$tmpFile->deleteFile($this->sysFileConfig['sInstallLock_Path']);
		
		return 0;
	} 
	public function OnList(){
		$this->sSystem_OS_STR=PHP_OS;
		$this->sSystem_PHP_STR=PHP_VERSION;
		$this->sSystem_MYSQL_STR='5.+';
		$this->sSystem_DiskSize_STR=intval(diskfreespace('.') / (1024 * 1024)).' MB';
		$this->sSystem_UploadSize_STR=@ini_get(upload_max_filesize);
		
		$this->sSystem_OS_Boolean=true;
		$tmpAR0=explode('.',$this->sSystem_PHP_STR);
		if ($tmpAR0[0]>=$this->sysFileConfig['sPHPVersion']){
			$this->sSystem_PHP_Boolean=true;
		}else{
			$this->sSystem_PHP_Boolean=false;
		}
		$this->sSystem_MYSQL_Boolean=true;
		$tmpINT=diskfreespace('.');
		if($tmpINT>$this->sysFileConfig['sUploadFileSize']*1024*1024){
			$this->sSystem_DiskSize_Boolean=true;
		}else {
			$this->sSystem_DiskSize_Boolean=false;			
		}
		$this->sSystem_UploadSize_Boolean=true;
		
		$this->sSystem_mysql_connect_Boolean=function_exists('mysql_connect');
		$this->sSystem_fsockopen_Boolean=function_exists('fsockopen');
		$this->sSystem_gethostbyname_Boolean=function_exists('gethostbyname');
		$this->sSystem_curl_init_Boolean=function_exists('curl_init');
		$this->sSystem_xml_parser_create_Boolean=function_exists('xml_parser_create');
		
		$this->sSystem_Boolean=false;
		if ($this->sSystem_mysql_connect_Boolean==true &&
			$this->sSystem_fsockopen_Boolean==true &&
			$this->sSystem_gethostbyname_Boolean==true &&
			$this->sSystem_curl_init_Boolean==true &&
			$this->sSystem_xml_parser_create_Boolean==true
			) {
			$this->sSystem_Boolean=true;
		}
		
		
		//-- ------ #Check LOCK Install ------ --
		$tmpFile=new netsFile();
		$tmpSTR=$tmpFile->readFile($this->sysFileConfig['sInstallLock_Path']);
		if ($tmpSTR!=''){
			$this->sInstallYet_Boolean=true;
		}
	}
	
	public function FilterColumns($pUiDescriptions,$pIndex,$pType){
		$tmpUiDescriptions=array();
		//-- ------ ### ------ --
		foreach ($pUiDescriptions as $Row0){
			if ($Row0['stcotType']==$pType && $Row0['stcoctUiLabelid']==$pIndex){
				$tmpUiDescriptions[]=$Row0;
			}
			
		}
		
		return $tmpUiDescriptions;
	}
	public function InstallMessage($pFlag,$pIndex,$pMessage,$pStyle){
		//-- #SPELL --
		$tmpSTR=$pFlag.$this->sysSPLIT1.
			$pIndex.$this->sysSPLIT1.
			'<div class="'.$pStyle.'">'.$pMessage.'</div>';
		
		$this->sInstall_Flag=$pFlag;
		$this->sInstall_Index=$pIndex;
		$this->sInstall_Content='<div class='.$pStyle.'>'.$pMessage.'</div>';
		return $tmpSTR;
	}
	
}


?>