<?php
class netsCode extends netsConfig {
	private $sysErrorClassID='0000';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	public $sysSPLIT1=',';
	
	public function netsCode(){
		$this->netsConfig();
	}

	public function AnalyerRequest($pSTR,$pDefault,$pType){
		$tmpSPLIT0='------Nets,------';

		$tmpAR0=array();
		$tmpAR1=explode($this->sysSPLIT1,$pDefault);
		//Analyer request
		if($pType==0){
			//Querystring
			if(!isset($_GET[$pSTR])){
				return $tmpAR1;
			}
			$tmpAR0=explode($this->sysSPLIT1,$this->FilterINPUT($_GET[$pSTR],1));
		}else if($pType==1){
			//Form
			if(!isset($_POST[$pSTR])){
				return array($pDefault);
			}
			$tmpSTR='';
			$tmpAR0=$_POST[$pSTR];
			if(is_array($tmpAR0)){
				foreach ($tmpAR0 as $Cell0){
					$tmpSTR.=$Cell0.$this->sysSPLIT1;
				}
			}else {
				$tmpSTR=$tmpAR0;
			}
			$tmpSTR=$this->FilterINPUT($tmpSTR,1);
			$tmpAR0=array($tmpSTR);
			$tmpAR1=array($pDefault);
		}else if($pType==2){
			//Cookie
			if(!isset($_COOKIE[$pSTR])){
				return $tmpAR1;
			}
			$tmpAR0=explode($this->sysSPLIT1,$this->FilterINPUT($_COOKIE[$pSTR],1));
		}else if($pType==3){
			//Security Cookie
			if(!isset($_COOKIE[$pSTR])){
				return $tmpAR1;
			}
			$tmpAR0=array($_COOKIE[$pSTR]);
		}
		if(count($tmpAR0)!=count($tmpAR1)){
			return $tmpAR1;
		}

		return $tmpAR0;
	}
	public function FilterINPUT($pSTR,$pType){
		$tmpSTR=trim($pSTR);
		$tmpAR0=array();
		//Define spical STR array
		if($pType==0){
			$tmpAR0=array(
				'\'',
				'\\',
				'CHR(34)',
				'SELECT',
				'INSERT',
				'INTO',
				'UPDATE',
				'DELETE',
				'UNION',
				'SCRIPT',
				'JAVASCRIPT',
				'VBSCRIPT',
				);
			$tmpSTR=stripslashes($tmpSTR);
		}else if($pType==1){
			$tmpAR0=array(
				'\'',
				'\\',
				);
			$tmpSTR=stripslashes($tmpSTR);
		}else if($pType==2){
			$tmpAR0=array(
				'\'',
				);
		}else if($pType==3){
			$tmpAR0=array(
				'\'',
				);
			$tmpAR_0=array("'<script[^>]*?>.*?</script>'si",);
			$tmpAR_1=array("",);
			$tmpSTR=preg_replace($tmpAR_0,$tmpAR_1,$tmpSTR);
		}
		//Spical Filter
		foreach($tmpAR0 as $Cell){
			$tmpSTR=str_replace($Cell,'',$tmpSTR);
		}
		return $tmpSTR;
	}
	public function FilterHTML($pSTR,$pSearchKeyword,$pType){
		$this->sysErrorFuncID=$this->sysErrorClassID.'8';
		$pSTR=preg_replace("/<.+?>/i","",$pSTR);
		$pSTR=str_replace('&nbsp;','',$pSTR);
		$pSTR=str_replace('&middot;','',$pSTR);
		$pSTR=str_replace('&ldquo;','',$pSTR);
		$pSTR=str_replace('&rdquo;','',$pSTR);

		return $pSTR;
	}
	public function Int32($pValue,$pDefalut){
		$this->sysErrorFuncID=$this->sysErrorClassID.'10';
		$tmpSTR='';
		//Initial parameter
		if(preg_match('/^-?\d*$/',$pValue) &&
			trim($pValue)!=''){
			$tmpSTR=$pValue;
		}else {
			$tmpSTR=$pDefalut;
		}
		$tmpSTR=floatval($tmpSTR);
		return $tmpSTR;
	}
	public function Decimal($pValue,$pDefalut){
		$this->sysErrorFuncID=$this->sysErrorClassID.'11';
		$tmpSTR='';
		//Initial parameter
		if((preg_match('/^-?\d*.\d*$/',$pValue) || 
			preg_match('/^-?\d*$/',$pValue)) &&
			trim($pValue)!=''){
			$tmpSTR=$pValue;
		}else {
			$tmpSTR=$pDefalut;
		}
		$tmpSTR=floatval($tmpSTR);
		return $tmpSTR;
	}
	public function DateTime($pValue,$pDefault){
		$this->sysErrorFuncID=$this->sysErrorClassID.'12';
		$tmpSTR='';

		if((preg_match('/^\d{4}-\d{1,2}-\d{1,2} \d{1,2}:\d{1,2}:\d{1,2}$/',$pValue) ||
			preg_match('/^\d{4}-\d{1,2}-\d{1,2}$/',$pValue)) &&
			trim($pValue)!=''){
			$tmpSTR=$pValue;
		}else {
			$tmpSTR=$pDefault;
		}

		return $tmpSTR;
	}
	public function SubString($pSTR,$pStart,$pLen){
		$this->sysErrorFuncID=$this->sysErrorClassID.'14';
		$tmpSTR='';
		$i=0;
		$n=$pStart;
		$str_length=strlen($pSTR);
		while (($n<$pLen) and ($i<=$str_length)){
			$temp_str=substr($pSTR,$i,1);
			$ascnum=Ord($temp_str);
			if ($ascnum>=224){
				$tmpSTR=$tmpSTR.substr($pSTR,$i,3);
				$i=$i+3;
				$n++;
			}else if ($ascnum>=192){
				$tmpSTR=$tmpSTR.substr($pSTR,$i,2);
				$i=$i+2;
				$n++;
			}else if ($ascnum>=65 && $ascnum<=90){
				$tmpSTR=$tmpSTR.substr($pSTR,$i,1);
				$i=$i+1;
				$n++;
			}else{
				$tmpSTR=$tmpSTR.substr($pSTR,$i,1);
				$i=$i+1;
				$n=$n+0.5;
			}
		}
	
		return $tmpSTR;
	}
	public function SamplePxd($pSTR){
		$this->sysErrorFuncID=$this->sysErrorClassID.'13';
		
		$tmpSTR='';
		$tmpSTR=md5($pSTR);
		
		return $tmpSTR;
	}
	public function getSiteHome(){
		$tmpAR0=array('/Mana/','/Platform/','/QPlatform/','/User/','/Test/','/Plus/',
			'/Config/','/Component/','/Inc/','/Template/','/Html/','/Ui/','/Uploadfiles/',);
		
		$tmpHome='';
		$tmpPath='';
		if(isset($_SERVER['HTTP_X_FORWARDED_HOST'])){
			$tmpHome=$_SERVER['HTTP_X_FORWARDED_HOST'];
			$tmpPath=$_SERVER['HTTP_X_FORWARDED_HOST'].$_SERVER['PHP_SELF'];
		}else if(isset($_SERVER['HTTP_HOST'])){
			$tmpHome=$_SERVER['HTTP_HOST'];
			$tmpPath=$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
		}
		
		foreach ($tmpAR0 as $Cell){
			$tmpAR1=explode($Cell,$tmpPath);
			if(count($tmpAR1)==2){
				$tmpHome=$tmpAR1[0].$this->sysSPLIT9;
			}
		}
		$tmpSTR='http://'.$tmpHome;
		
		return $tmpSTR;
	}
	public function getSiteURL(){
		$hostPath='';
		if(isset($_SERVER['HTTP_X_FORWARDED_HOST'])){
			$hostPath=$_SERVER['HTTP_X_FORWARDED_HOST'].$_SERVER['PHP_SELF'];
		}else if(isset($_SERVER['HTTP_HOST'])){
			$hostPath=$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
		}
		$tmpSTR='http://'.$hostPath;
		
		return $tmpSTR;
	}
	public function getURL(){
		$hostPath='';
		if(isset($_SERVER['HTTP_X_FORWARDED_HOST'])){
			$hostPath=$_SERVER['HTTP_X_FORWARDED_HOST'].$_SERVER['PHP_SELF'];
		}else if(isset($_SERVER['HTTP_HOST'])){
			$hostPath=$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
		}
		$tmpSTR='http://'.$hostPath.'?'.$_SERVER["QUERY_STRING"];
		
		return $tmpSTR;
	}
	public function getSitePath($pPath){
		$tmpSTR='';
		$tmpSPLIT='/';
		if(isset($_SERVER['HTTP_X_FORWARDED_HOST'])){
			$tmpSTR=$_SERVER['HTTP_X_FORWARDED_HOST'].$_SERVER['PHP_SELF'];
		}else if(isset($_SERVER['HTTP_HOST'])){
			$tmpSTR=$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
		}
		$tmpAR0=explode($tmpSPLIT,$tmpSTR);
		$tmpSTR='';
		array_pop($tmpAR0);
		foreach ($tmpAR0 as $Cell){
			$tmpSTR.=$Cell.$tmpSPLIT;
		}
		
		return 'http://'.$tmpSTR.$pPath;
	}
	public function getIP() {
		$tmpSTR='';
		if(array_key_exists('HTTP_CLIENT_IP', $_SERVER)){
			$tmpSTR=$_SERVER['HTTP_CLIENT_IP'];
		}else if(array_key_exists('HTTP_X_FORWARDED_FOR', $_SERVER)){
			$tmpSTR=$_SERVER['HTTP_X_FORWARDED_FOR'];
		}else {
			$tmpSTR=$_SERVER['REMOTE_ADDR'];
		}
		
		return $tmpSTR;
	}
	
}
?>