<?php
class netsFile extends netsConfig {
	private $sysErrorClassID='1202';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	public function netsFile(){
		$this->netsConfig();
	}
	
	public function readCookie($pName){
		$tmpSTR='';
		if(!isset($_COOKIE[$pName])){
			return $tmpSTR;
		}
		$tmpSTR=$_COOKIE[$pName];
		return $tmpSTR;
	}
	public function writeCookie($pURLs,$pName,$pValue){
		foreach ($pURLs as $Cell){
			$tmpBOOL=setcookie($pName,$pValue,time()+31536000,$Cell);
		}
		return 0;
	}
	public function createDir($pPath){
		$this->sysErrorFuncID=$this->sysErrorClassID.'07';
		
		$tmpSTR='';
		$tmpAR0=explode($this->sysSPLIT9,$pPath);
		foreach ($tmpAR0 as $Dir){
			$tmpSTR.=$Dir.$this->sysSPLIT9;
			if(!file_exists($tmpSTR)){
				if(!mkdir($tmpSTR,0777)){
					return 1;
				}
			}
		}
		
		return 0;
	}
	public function readFile($pFilePath){
		$this->sysErrorFuncID=$this->sysErrorClassID.'08';
		$tmpSTR='';
		//
		if(is_file($pFilePath)){
			$tmpfileHandle=fopen($pFilePath, 'r');
			$tmpSTR=fread($tmpfileHandle, filesize ($pFilePath));
			fclose($tmpfileHandle);
		}else {}
		return $tmpSTR;
	}
	public function readURL($pURL){
		$this->sysErrorFuncID=$this->sysErrorClassID.'08';
		$tmpSTR='';
		
		$tmpPattern="/http:\/\/(\w\*.)\*/i";
		if(preg_match($tmpPattern,$pURL)){
			return $tmpSTR;
		}
		if(function_exists('curl_init')){
			$tmpCurl=curl_init();
			curl_setopt($tmpCurl,CURLOPT_URL,$pURL);
			curl_setopt($tmpCurl,CURLOPT_RETURNTRANSFER,1);
			curl_setopt($tmpCurl,CURLOPT_CONNECTTIMEOUT,$this->sysFileConfig['ScriptOutTime']*3);
			//curl_setopt($tmpCurl,CURLOPT_HTTPAUTH,CURLAUTH_ANY); 
			//curl_setopt($tmpCurl,CURLOPT_USERPWD,US_NAME.":".US_PWD); 
			$tmpSTR=curl_exec($tmpCurl);
			curl_close($tmpCurl);
		}else{
			$tmpAR0=get_headers($pURL,1);
			if ($tmpAR0[0]=='HTTP/1.1 200 OK') {
				$tmpSTR=file_get_contents($pURL);
			}
		}
		
		return $tmpSTR;
	}
	public function writeFile($pFileName,$pContent){
		$this->sysErrorFuncID=$this->sysErrorClassID.'09';
		//Initial parameter
		$tmpSPLIT1='/';
		$tmpSPLIT2='\\';
		//Check path
		$tmpFilename=$this->getRealname($pFileName,0);
		//Analyse path
		$tmpAR0=explode($tmpSPLIT2,$tmpFilename);
		array_pop($tmpAR0);
		$tmpSTR='';
		foreach ($tmpAR0 as $Cell){
			$tmpSTR.=$Cell.$tmpSPLIT2;
			if($Cell!='..' && $Cell!='.'){
				if(!file_exists($tmpSTR)){
					mkdir($tmpSTR);
				}
			}
		}
		//Open
		if(!file_exists($tmpFilename)){
			$tmpfileHandle=fopen($tmpFilename,'x');
		}else {
			$tmpfileHandle=fopen($tmpFilename,'w');
		}
		flock($tmpfileHandle,3);
		if(!$tmpfileHandle){
			return $this->sysErrorClassID.$this->sysErrorFuncID.'001';
		}
		fwrite($tmpfileHandle,$pContent);
		fclose($tmpfileHandle);
		
		return 0;
	}
	public function appendFile($pFileName,$pContent){
		$this->sysErrorFuncID=$this->sysErrorClassID.'10';
		//Initial parameter
		$tmpSPLIT1='/';
		$tmpSPLIT2='\\';
		//Check path
		$tmpFilename=$this->getRealname($pFileName,0);
		//Analyse path
		$tmpAR0=explode($tmpSPLIT2,$tmpFilename);
		array_pop($tmpAR0);
		$tmpSTR='';
		foreach ($tmpAR0 as $Cell){
			$tmpSTR.=$Cell.$tmpSPLIT2;
			if($Cell!='..' && $Cell!='.'){
				if(!file_exists($tmpSTR)){
					mkdir($tmpSTR);
				}
			}
		}
		//
		$tmpSTR='';
		if(file_exists($tmpFilename)){
			$tmpINT=filesize ($tmpFilename);
			if($tmpINT>0){
				$tmpfileHandle=fopen($tmpFilename, 'r');
				$tmpSTR=fread($tmpfileHandle, $tmpINT);
				fclose($tmpfileHandle);
			}
		}
		//
		if(!file_exists($tmpFilename)){
			$tmpfileHandle=fopen($tmpFilename,'x');
		}else {
			$tmpfileHandle=fopen($tmpFilename,'w');
		}
		flock($tmpfileHandle,3);
		if(!$tmpfileHandle){
			return $this->sysErrorClassID.$this->sysErrorFuncID.'001';
		}
		$tmpSTR.=$pContent;
		fwrite($tmpfileHandle,$tmpSTR);
		fclose($tmpfileHandle);
		
		return 0;
	}
	public function deleteFile($pFileName){
		if(is_file($pFileName)){
			unlink($pFileName);
		}else{
			return 1;
		}
		return 0;
	}
	public function deleteAllFile($pPathName){
		$tmpHandle=opendir($pPathName);
		while($tmpFile=readdir($tmpHandle)){
			$tmpFilename=$pPathName.$tmpFile;
			if(is_file($tmpFilename)){
				unlink($tmpFilename);
			}
		}
		closedir($tmpHandle);

		return 0;
	}
	public function deleteDirectory($pPathName){
		//-- ------ #Initial ------ --
		$tmpSPLIT1='/';
		$tmpROOT_0='.';
		$tmpROOT_1='..';
		$tmpRootPath=$pPathName;
		$tmpPathName='';
		//-- ------ #Read dir ------ --
		if (!is_dir($tmpRootPath)){
			return 1;
		}
		$tmpHandle=opendir($tmpRootPath);
		$tmpFile=readdir($tmpHandle);
		while ($tmpFile==$tmpROOT_0 || $tmpFile==$tmpROOT_1){
			$tmpFile=readdir($tmpHandle);
		}
		$Coun0=0;
		while($tmpRootPath.$tmpPathName.$tmpFile!=false && $Coun0<50){
			//-- #Reset dir --
			if (is_dir($tmpRootPath.$tmpPathName.$tmpFile)){
				//-- #Reset dir --
				$tmpPathName.=$tmpFile.$tmpSPLIT1;
			}else{
				//-- #Delete file --
				$tmpFilename=$tmpRootPath.$tmpPathName.$tmpFile;
				if(is_file($tmpFilename)){
					unlink($tmpFilename);
				}
			}
			//-- #Reset --
			$tmpHandle=opendir($tmpRootPath.$tmpPathName);
			$tmpFile=readdir($tmpHandle);
			while ($tmpFile==$tmpROOT_0 || $tmpFile==$tmpROOT_1){
				$tmpFile=readdir($tmpHandle);
			}
			if ($tmpFile==false){
				$tmpAR0=explode($tmpSPLIT1,$tmpPathName);
				array_pop($tmpAR0);
				$tmpSTR='';
				foreach ($tmpAR0 as $Row0){
					$tmpSTR.=$Row0.$tmpSPLIT1;
				}
				array_pop($tmpAR0);
				array_pop($tmpAR0);
				$tmpPathName='';
				foreach ($tmpAR0 as $Row0){
					$tmpPathName.=$Row0.$tmpSPLIT1;
				}
				//-- #Delete empty dir --
				if ($tmpSTR!=$tmpSPLIT1){
					closedir($tmpHandle);
					rmdir($tmpRootPath.$tmpSTR);
					$tmpHandle=opendir($tmpRootPath.$tmpPathName);
					$tmpFile=readdir($tmpHandle);
					while ($tmpFile==$tmpROOT_0 || $tmpFile==$tmpROOT_1){
						$tmpFile=readdir($tmpHandle);
					}
				}else {
					$tmpFile=false;
				}
			}
			
			$Coun0++;
		}
		closedir($tmpHandle);
		return 0;
	}
	
	protected function createDirEx($pAR){
		$this->sysErrorFuncID=$this->sysErrorClassID.'24';
		//Check
		if($pAR['Name']==''){
			$tmpINT=$this->sysErrorFuncID.'001'.':目录名不能为空';
			return $tmpINT;
		}
		if(!is_dir($pAR['Root'])){
			$tmpINT=$this->sysErrorFuncID.'002'.':上级目录不存在';
			return $tmpINT;
		}
		if(is_dir($pAR['Root'].$pAR['Name'])){
			$tmpINT=$this->sysErrorFuncID.'003'.':目录已存在';
			return $tmpINT;
		}
		//Create
		if(!mkdir($pAR['Root'].$pAR['Name'],0777)){
			$tmpINT=$this->sysErrorFuncID.'004'.':创建目录错误，请与管理员联系';
			return $tmpINT;
		}
		return 0;
	}
	public function getFileExname($pFileName){
		$this->sysErrorFuncID=$this->sysErrorClassID.'25';
		$pFileName=str_replace('\\','/',$pFileName);
		$tmpAR0=explode('/',$pFileName);
		$tmpAR0=explode('.',$tmpAR0[count($tmpAR0)-1]);
		$tmpSTR=$tmpAR0[count($tmpAR0)-1];
		if(count($tmpAR0)<2){
			$tmpSTR='.';
		}
		return $tmpSTR;
	}
	public function getFileName($pFileName){
		$tmpAR0=array('','');
		if(is_file($pFileName)){
			$pFileName=str_replace('\\','/',$pFileName);
			$tmpAR0=explode('/',$pFileName);
			$tmpSTR='';
			$Coun0=0;
			while (count($tmpAR0)-1>$Coun0){
				$tmpSTR.=$tmpAR0[$Coun0].'/';
				$Coun0++;
			}
			$pFileName=$tmpAR0[count($tmpAR0)-1];
			$tmpAR0=array();
			$tmpAR0[0]=$tmpSTR;
			$tmpAR0[1]=$pFileName;
		}else if (is_dir($pFileName)) {
			$tmpAR0[0]=$pFileName;
			$tmpAR0[1]='';
		}
		
		return $tmpAR0;
	}
	public function copyAllFileTo($pSourcePath,$pDestinationPath){
		$this->sysErrorFuncID=$this->sysErrorClassID.'25';
		$tmpDirAR0=array($pSourcePath);
		
		$Coun0=0;
		while (count($tmpDirAR0)>$Coun0){
			if(file_exists($tmpDirAR0[$Coun0])){
				if($tmpDirHandle=opendir($tmpDirAR0[$Coun0])){
					while($path=readdir($tmpDirHandle)){
						$pathComplete=$tmpDirAR0[$Coun0].$path;
						if($path!='.' && $path!='..' && is_dir($pathComplete)){
							array_push($tmpDirAR0,$pathComplete.'/');
							$tmpSTR=str_replace($pSourcePath,$pDestinationPath,$pathComplete);
							if(!file_exists($tmpSTR)){
								mkdir($tmpSTR,0777);
							}
						}else if ($path!='.' && $path!='..' && is_file($pathComplete)) {
							$tmpSTR=str_replace($pSourcePath,$pDestinationPath,$pathComplete);
							if(!file_exists($tmpSTR)){
								copy($pathComplete,$tmpSTR);
							}
						}
					}
					closedir($tmpDirHandle);
				}
			}
			$Coun0++;
		}
		
		return 0;
	}
	
	public function getRealname($pFileName,$pType){
		$tmpSPLIT1='/';
		$tmpSPLIT2='\\';
		//$pType : 0.file , 1.path
		$tmpRoot=realpath('.');
		$tmpAR0=explode($tmpSPLIT2,$tmpRoot);
		$tmpAR1=explode($tmpSPLIT1,$pFileName);
		foreach ($tmpAR1 as $Cell){
			if ($Cell=='..') {
				array_pop($tmpAR0);
			}
		}
		$tmpRoot='';
		foreach ($tmpAR0 as $Cell){
			$tmpRoot.=$Cell.$tmpSPLIT2;
		}
		$tmpFilename=$tmpRoot;
		$Coun0=0;
		foreach ($tmpAR1 as $Cell){
			if ($Cell!='.' && $Cell!='..') {
				$tmpFilename.=$Cell;
				if((count($tmpAR1)-1)>$Coun0){
					$tmpFilename.=$tmpSPLIT2;
				}
			}
			$Coun0++;
		}
		
		return $tmpFilename;
	}
}
?>