<?php
class shopsaleorder extends netsDb {
	/*
Define:
商品ID,数量,价格,积分,活动ID,所属商品ID,类型,参数(8)
ID,Count,Price,Code,Activeid,Parentid,Type,Parameters(8)

Type:
一般订单,0
拍卖,1
套件,2
收费配件,3
免费配件,4
赠品,5

Example:
1;1;10.50;5.50;0;0;0;9-A-;|||2;1;8.50;4.50;1;1;2;9-A-;|||

	*/
	private $sysErrorClassID='0000';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	protected  $sOrderRecordType=0;
	public $sCellCount=9;
	
	
	
	public function shopsaleorder($pConnection){
		$this->netsDb($pConnection);
	}
	public function Check(&$pTableDescriptAR,$pExceptionAR1,$pExceptionAR2){
		$this->sysErrorFuncID=$this->sysErrorClassID.'02';
		
		if(count($pExceptionAR1)==0){
			$pExceptionAR1=array();
		}
		parent::Check($pTableDescriptAR,$pExceptionAR1,$pExceptionAR2);
		//
		$tmpSTR='shsotName';
		if(strlen($pTableDescriptAR[0]['Columns'][$tmpSTR]['Value'])<1 && !in_array($tmpSTR,$pExceptionAR2)){
			$this->sysLastError='提交内容错误:1.名称不能为空';
			return $this->sysErrorFuncID.'001';
		}
		return 0;
	}
	
	public function order_Generate(&$pDescriptions,$pUserinfo){
		/*
		Generate orders
		
		#.Record user HABITS
		#.ORDER
		#.Calculation of MONEY and CODE
		#.Update sales count
		#.Generate orders
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Record user HABITS ------ --
		$tmpAR0=array('Order_Userreceiveaddress',
			'Order_Userpaytype',
			'Order_PayBeforehand',
			'Order_Sendmodel',
			'Order_Invoice',);
		foreach ($tmpAR0 as $Row0){
			//-- #VALUE --
			$tmpValue='';
			if ($Row0=='Order_Userreceiveaddress') {
				$tmpValue=$pDescriptions[1]['Columns']['shsoctReceiveaddressid']['Value'];
			}else if ($Row0=='Order_Userpaytype') {
				$tmpValue=$pDescriptions[1]['Columns']['shsoctPayTypeid']['Value'];
			}else if ($Row0=='Order_PayBeforehand') {
				$tmpValue=$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value'];
			}else if ($Row0=='Order_Sendmodel') {
				$tmpValue=$pDescriptions[1]['Columns']['shsoctSendmodelid']['Value'];
			}else if ($Row0=='Order_Invoice') {
				$tmpValue=$pDescriptions[1]['Columns']['shsoctInvoice']['Value'].$this->sysSPLIT5.
					$pDescriptions[1]['Columns']['shsoctInvoiceContent']['Value'].$this->sysSPLIT5.
					str_replace($this->sysSPLIT1,$this->sysSPLIT2,$pDescriptions[1]['Columns']['shsoctFavourableids']['Value']).$this->sysSPLIT5;
				
			}
			//-- #SEARCH --
			$tmpSQL=' SELECT A.uihtID,A.uihtFlag,A.uihtValue
				FROM {Nets.TableHead}netsuserinfohabits AS A
				WHERE 1=1 AND A.uihtRecycle=0 AND A.uihtChecked>1 AND 
				A.uihtCreateBy={Nets.CreateBy} AND A.uihtFlag LIKE \'{Nets.Flag}\' ';
			$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
			$tmpSTR=str_replace('{Nets.CreateBy}',$pUserinfo[0]['Columns']['uitID']['Value'],$tmpSTR);
			$tmpSTR=str_replace('{Nets.Flag}',$Row0,$tmpSTR);
			$tmpData0=$this->Search($tmpSTR);
			if (count($tmpData0)==0) {
				//-- #ADD --
				$tmpDbDescriptions=array(
					$this->sDbDescriptions_Other[2],
					$this->sDbDescriptions_Other[3],);
				//#Get numCode
				$tmpSTR='uihtNumCode';
				$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
				$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N'.$this->sysSPLIT11.date('YmdHis');
				$this->numCode($tmpDbDescriptions[0]);
				
				//-- #Setting --
				$tmpDbDescriptions[0]['Columns']['uihtName']['Value']=$Row0;
				$tmpDbDescriptions[0]['Columns']['uihtChecked']['Value']=2;
				$tmpDbDescriptions[0]['Columns']['uihtFlag']['Value']=$Row0;
				$tmpDbDescriptions[0]['Columns']['uihtValue']['Value']=$tmpValue;
				
				$tmpDbDescriptions[0]['Columns']['uihtCreateBy']['Value']=$pUserinfo[0]['Columns']['uitID']['Value'];
				$tmpDbDescriptions[0]['Columns']['uihtCreateTime']['Value']=date($this->sysTimeFormat);
				//-- #Add --
				$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='uihtNumCode,uihtID';
				$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='uihctIndexID';
				$tmpINT=$this->add($tmpDbDescriptions);
				if($tmpINT!=0){
					$this->TransRollback();
					$this->sysLastError='保存用户习惯信息出错，请客服人员联系。';
					return $tmpINT;
				}
				
			}else if ($tmpData0[0]['uihtValue']!=$tmpValue) {
				//-- #MODIFY --
				$tmpDbDescriptions=array(
					$this->sDbDescriptions_Other[2],
					$this->sDbDescriptions_Other[3],);
				//#Get one
				$tmpDbDescriptions[0]['Columns']['uihtID']['Value']=$tmpData0[0]['uihtID'];
				$tmpDbDescriptions[1]['Columns']['uihctIndexID']['Value']=$tmpData0[0]['uihtID'];
				$this->getOne($tmpDbDescriptions);
				//-- #Setting --
				$tmpDbDescriptions[0]['Columns']['uihtName']['Value']=$Row0;
				$tmpDbDescriptions[0]['Columns']['uihtChecked']['Value']=2;
				$tmpDbDescriptions[0]['Columns']['uihtFlag']['Value']=$Row0;
				$tmpDbDescriptions[0]['Columns']['uihtValue']['Value']=$tmpValue;
				
				$tmpDbDescriptions[0]['Columns']['uihtCreateBy']['Value']=$pUserinfo[0]['Columns']['uitID']['Value'];
				$tmpDbDescriptions[0]['Columns']['uihtCreateTime']['Value']=date($this->sysTimeFormat);
				
				//#Modify
				$tmpINT=$this->modify($tmpDbDescriptions);
				if($tmpINT!=0){
					$this->TransRollback();
					$this->sysLastError='保存用户习惯信息出错，请客服人员联系。';
					return $tmpINT;
				}
				
				
			}
		}
		//-- ------ #ORDER ------ --
		//-- ------ #Calculation of MONEY and CODE ------ --
		$tmpAR0=explode($this->sysSPLIT5,$pDescriptions[1]['Columns']['shsoctSales']['Value']);
		$tmpCar_List=array();//ID,Count,Price,Code,Activeid,Parentid,Type,Parameters(8)
		$tmpSTR_0='';
		foreach ($tmpAR0 as $Row0) {
			$tmpAR1=explode($this->sysSPLIT2,$Row0);
			if (count($tmpAR1)==$this->sCellCount) {
				$tmpCar_List[]=array(
					'ID'=>$tmpAR1[0],
					'Count'=>$tmpAR1[1],
					'Price'=>$tmpAR1[2],
					'Code'=>$tmpAR1[3],
					'Activeid'=>$tmpAR1[4],
					'Parentid'=>$tmpAR1[5],
					'Type'=>$tmpAR1[6],
					'Parameters'=>$tmpAR1[7],
					);
			}
			
		}
		$tmpINT=$this->order_CheckContent($tmpCar_List);
		$tmpPay_Price=0.00;
		$tmpPay_Code=0.00;
		foreach ($tmpCar_List as $Row0){
			$tmpPay_Price+=$Row0['Price']*$Row0['Count'];
			$tmpPay_Code+=$Row0['Code']*$Row0['Count'];
		}
		//$tmpPay_Price=$tmpPay_Price*$pDescriptions[0]['Columns']['shsotTotalPrice_Sale']['Value'];
		//$tmpPay_Code=$tmpPay_Code*$pDescriptions[0]['Columns']['shsotTotalCode_Sale']['Value'];
		//-- ------ #Update sales count ------ --
		//-- #Check count --
		$tmpSQL=' SELECT A.shsctIndexID
				FROM {Nets.TableHead}shopsalecont AS A
				WHERE 1=1 AND (1=2 {Nets.Condition}) ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR_0='';
		foreach ($tmpCar_List as $Row0){
			$tmpSTR_0.=' OR (A.shsctIndexID='.$Row0['ID'].' AND A.shsctCount_Total<'.$Row0['Count'].') ';
		}
		$tmpSTR=str_replace('{Nets.Condition}',$tmpSTR_0,$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if (count($tmpData0)>0) {
			$this->TransRollback();
			$this->sysLastError='您所订购的商品数量不足。';
			return $this->sysErrorFuncID.'001';
		}
		
		//-- #Update count --
		foreach ($tmpCar_List as $Row0){
			$tmpSQL=' UPDATE {Nets.TableHead}shopsalecont AS A SET
				A.shsctCount_Total=A.shsctCount_Total-{Nets.Count},
				A.shsctCount_Order=A.shsctCount_Order+{Nets.Count}
				WHERE 1=1 AND A.shsctIndexID={Nets.ID} ';
			$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
			$tmpSTR=str_replace('{Nets.Count}',$Row0['Count'],$tmpSTR);
			$tmpSTR=str_replace('{Nets.ID}',$Row0['ID'],$tmpSTR);
			$tmpINT=$this->Execute($tmpSTR);
			if($tmpINT!=0){
				$this->TransRollback();
				$this->sysLastError='更新商品数量时出错，请与客服人员联系。';
				return $tmpINT;
			}
			
		}
		
		//-- ------ #Generate orders ------ --
		//-- ------ #Add ------ --
		//#Get numCode
		$tmpSTR='shsotNumCode';
		$pDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$pDescriptions[0]['Columns'][$tmpSTR]['Value']=$this->sysFileConfig['NumCodeHead_Order'].$this->sysSPLIT11.date('YmdHis');
		$this->numCode($pDescriptions[0]);
		
		//-- #Setting --
		//#shsotPayyet,shsotTotalPrice,shsotTotalCode
		$pDescriptions[0]['Columns']['shsotPayyet']['Value']=0.00;
		$pDescriptions[0]['Columns']['shsotTotalPrice']['Value']=$tmpPay_Price+
			$pDescriptions[1]['Columns']['shsoctInvoicePrice']['Value']+
			$pDescriptions[1]['Columns']['shsoctSendmodelPrice']['Value'];
		$pDescriptions[0]['Columns']['shsotTotalCode']['Value']=$tmpPay_Code;
		//#shsoctSales
		$tmpContent='';
		foreach ($tmpCar_List as $Row0){
			$tmpContent.=$Row0['ID'].$this->sysSPLIT2.
				$Row0['Count'].$this->sysSPLIT2.
				$Row0['Price'].$this->sysSPLIT2.
				$Row0['Code'].$this->sysSPLIT2.
				$Row0['Activeid'].$this->sysSPLIT2.
				$Row0['Parentid'].$this->sysSPLIT2.
				$Row0['Type'].$this->sysSPLIT2.
				$Row0['Parameters'].$this->sysSPLIT2.
				$this->sysSPLIT5;
		}
		$pDescriptions[1]['Columns']['shsoctSales']['Value']=$tmpContent;
		//#Other
		$pDescriptions[0]['Columns']['shsotState']['Value']=0;
		$pDescriptions[0]['Columns']['shsotName']['Value']=$pDescriptions[0]['Columns']['shsotNumCode']['Value'];
		$pDescriptions[0]['Columns']['shsotCreateBy']['Value']=$pUserinfo[0]['Columns']['uitID']['Value'];
		$pDescriptions[0]['Columns']['shsotCreateTime']['Value']=date($this->sysTimeFormat);
		//-- #Add --
		$tmpINT=$this->Check($pDescriptions,array(),array());
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $tmpINT;
		}
		$pDescriptions[0]['TableDescription']['SearchColumn']='shsotNumCode,shsotID';
		$pDescriptions[1]['TableDescription']['SearchColumn']='shsoctIndexID';
		$tmpINT=$this->add($pDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $tmpINT;
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：生成订单；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_Pay(&$pDescriptions,$pUserinfo,&$pURL){
		/*
		Pay order
		
		#.Get order
		#.根据不同支付方式支付
		#.如果资金不足则用已选支付方式支付
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Pay ------ --
		//1.先从帐号的资金里扣除，再使用以下方式支付 
		//2.直接从帐号的资金里扣除，不足的提示我充值 
		//3.先从帐号的资金里扣除，不足部分使用货到付款 
		//4.直接使用已选择的方式支付 
		//5.货到付款 
		
		//Check pay type
		if($pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']!=1 &&
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']!=2 &&
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']!=3 &&
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']!=4 &&
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']!=5){
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']=1;
		}
		//Beforehand pay
		//1.先从帐号的资金里扣除，再使用以下方式支付
		//2.直接从帐号的资金里扣除，不足的提示我充值
		//3.先从帐号的资金里扣除，不足部分使用货到付款
		if($pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==1 ||
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==2 ||
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==3){
			$tmpPayyet=0.00;
			$tmpPaymust=$pDescriptions[0]['Columns']['shsotTotalPrice']['Value']-$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
			if($pUserinfo[0]['Columns']['uitMoney']['Value']<$tmpPaymust){
				$tmpPayyet=$pUserinfo[0]['Columns']['uitMoney']['Value'];
			}else {
				$tmpPayyet=$tmpPaymust;
			}
			$tmpSQL=' UPDATE {Nets.TableHead}netsuserinfo AS A 
				SET A.uitMoney=A.uitMoney-{Nets.Money} 
				WHERE 1=1 AND A.uitID={Nets.ID}; ';
			$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
			$tmpSTR=str_replace('{Nets.Money}',$tmpPayyet,$tmpSTR);
			$tmpSTR=str_replace('{Nets.ID}',$pUserinfo[0]['Columns']['uitID']['Value'],$tmpSTR);
			$tmpINT=$this->Execute($tmpSTR);
			if($tmpINT!=0){
				$this->TransRollback();
				$this->sysLastError='用户帐户支付错误，请客服人员联系。';
				return $this->sysErrorFuncID.'002';
			}
			$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
				SET A.shsotPayyet=A.shsotPayyet+{Nets.Money} 
				WHERE 1=1 AND shsotID={Nets.ID}; ';
			$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
			$tmpSTR=str_replace('{Nets.Money}',$tmpPayyet,$tmpSTR);
			$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
			$tmpINT=$this->Execute($tmpSTR);
			if($tmpINT!=0){
				$this->TransRollback();
				$this->sysLastError='用户帐户支付错误，请客服人员联系。';
				return $this->sysErrorFuncID.'002';
			}
			$pDescriptions[0]['Columns']['shsotPayyet']['Value']=$pDescriptions[0]['Columns']['shsotPayyet']['Value']+$tmpPayyet;
		}
		//Set pay set
		$tmpState=0;
		if($pDescriptions[0]['Columns']['shsotTotalPrice']['Value']>$pDescriptions[0]['Columns']['shsotPayyet']['Value']){
			//用户帐户里资金不足，或不用用户帐户扣除
			if($pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==3 ||
				$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==5){
				$tmpState=3;
			}else {
				$tmpState=1;
			}
		}else {
			//用户帐户里资金足以支付本订单
			$tmpState=2;
		}
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A 
			SET A.shsotState={Nets.State} 
			WHERE 1=1 AND A.shsotID={Nets.ID}; ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.State}',$tmpState,$tmpSTR);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='用户帐户支付错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$pDescriptions[0]['Columns']['shsotState']['Value']=$tmpState;
		//Clear my sale car
		/*
		$tmpSQL=' SELECT A.shsctID
			FROM {Nets.TableHead}groupsalecar AS A
			WHERE 1=1 AND A.shsctCreateBy={Nets.CreateBy} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.CreateBy}',$pUserinfo[0]['Columns']['uitID']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		$tmpSQL=' DELETE FROM {Nets.TableHead}groupsalecar AS A
			WHERE 1=1 AND (1=2 {Nets.IDS}) ';
		$tmpSTR_0='';
		foreach ($tmpData0 as $Row0) {
			$tmpSTR_0.=' AND A.shsctID='.$Row0['shsctID'];
		}
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.IDS}',$tmpSTR_0,$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='清理用户购物车错误，请联系管理员。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpSQL=' DELETE FROM {Nets.TableHead}groupsalecarcont 
			WHERE 1=1 AND (1=2 {Nets.IDS}) ';
		$tmpSTR_0='';
		foreach ($tmpData0 as $Row0) {
			$tmpSTR_0.=' AND gscctIndexID='.$Row0['shsctID'];
		}
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.IDS}',$tmpSTR_0,$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='清理用户购物车错误，请联系管理员。';
			return $this->sysErrorFuncID.'002';
		}
		*/
		//Redirect
		if($pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==1 ||
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==4){
			//1.先从帐号的资金里扣除，再使用以下方式支付
			//4.直接使用以下方式支付
			if($pDescriptions[0]['Columns']['shsotTotalPrice']['Value']>$pDescriptions[0]['Columns']['shsotPayyet']['Value']){
				$tmpSQL=' SELECT B.shuptctWebpaySiteURL
					FROM {Nets.TableHead}shopuserpaytype AS A
					INNER JOIN {Nets.TableHead}shopuserpaytypecont AS B ON B.shuptctIndexID=A.shupttID
					WHERE 1=1 AND A.shupttID={Nets.ID} ';
				$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
				$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[1]['Columns']['shsoctPayTypeid']['Value'],$tmpSTR);
				$tmpData0=$this->Search($tmpSTR);
				if (count($tmpData0)==0) {
					$pURL=$this->sysFileConfig['PaySubmit_Default'];
				}else {
					$pURL=$tmpData0[0]['shuptctWebpaySiteURL'];
				}
				$pURL.='?NumCode='.$pDescriptions[0]['Columns']['shsotNumCode']['Value'];
				$tmpPayyet=$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
				$tmpPaywill=$pDescriptions[0]['Columns']['shsotTotalPrice']['Value']-$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
				$this->sysLastMessage='订单已提交成功！为支付本订单，系统已从您平台帐户里扣除了￥'.$tmpPayyet.'(人民币)，由于您的帐户里的资金不足已支付本订单，您还必须为本订单支付￥'.$tmpPaywill.'(人民币)。';
			}else {
				$pURL='Plus/Common/Shop/saleorder.php';
				$tmpPayyet=$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
				$this->sysLastMessage='订单已提交成功，平台已通知商家发货！为支付本订单，系统已从您平台帐户里扣除了￥'.$tmpPayyet.'(人民币)。';
			}
		}else if($pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==2){
			//2.直接从帐号的资金里扣除，不足的提示我充值
			if($pDescriptions[0]['Columns']['shsotTotalPrice']['Value']>$pDescriptions[0]['Columns']['shsotPayyet']['Value']){
				$pURL='Plus/Common/Shop/userpay0.php';
				$tmpPayyet=$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
				$tmpPaywill=$pDescriptions[0]['Columns']['shsotTotalPrice']['Value']-$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
				$this->sysLastMessage='订单已提交成功！为支付本订单，系统已从您平台帐户里扣除了￥'.$tmpPayyet.'(人民币)，由于您的帐户里的资金不足已支付本订单，您还必须为您的帐户充值￥'.$tmpPaywill.'(人民币)才足已支付本订单。';
			}else {
				$pURL='Plus/Common/Shop/saleorder.php';
				$tmpPayyet=$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
				$this->sysLastMessage='订单已提交成功，平台已通知商家发货！为支付本订单，系统已从您平台帐户里扣除了￥'.$tmpPayyet.'(人民币)。';
			}
		}else if($pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==3 ||
			$pDescriptions[1]['Columns']['shsoctPayBeforehand']['Value']==5){
			//3.先从帐号的资金里扣除，不足部分使用货到付款
			//5.货到付款
			if($pDescriptions[0]['Columns']['shsotTotalPrice']['Value']>$pDescriptions[0]['Columns']['shsotPayyet']['Value']){
				$pURL='Plus/Common/Shop/saleorder.php';
				$tmpPayyet=$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
				$tmpPaywill=$pDescriptions[0]['Columns']['shsotTotalPrice']['Value']-$pDescriptions[0]['Columns']['shsotPayyet']['Value'];
				$this->sysLastMessage='订单已提交成功，平台已通知商家发货！为支付本订单，系统已从您平台帐户里扣除了￥'.$tmpPayyet.'(人民币)，由于您的帐户里的资金不足已支付本订单，当收款时，您还必须为本订单支付￥'.$tmpPaywill.'(人民币)。';
			}else {
				$pURL='Plus/Common/Shop/saleorder.php';
				$this->sysLastMessage='订单已提交成功，平台已通知商家发货！(货到付款方式)';
			}
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：正在支付本订单；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_PaySuccess(&$pDescriptions){
		/*
		支付返回，确认订单支付完成
		
		#.Get order
		#.Make up the user order the amount paid
		#.Modify Order Status
		#.Add user CODE
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='更新订单时错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Make up the user order the amount paid ------ --
		//-- ------ #Modify Order Status ------ --
		//-- #Check --
		if ($pDescriptions[0]['Columns']['shsotState']['Value']!=0 &&
			$pDescriptions[0]['Columns']['shsotState']['Value']!=1) {
			$this->TransRollback();
			$this->sysLastError='您的订单已完成支付，不能再次支付。';
			return $this->sysErrorFuncID.'002';
		}
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=2,A.shsotPayyet=A.shsotTotalPrice
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		
		//-- ------ #Add user CODE ------ --
		$tmpSQL=' UDPATE {Nets.TableHead}netsuserinfo AS A
			SET A.uitCode=A.uitCode+{Nets.Code}
			WHERE 1=1 AND A.uitID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotTotalCode']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新用户积分时错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：支付成功；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_RecieveConfirm(&$pDescriptions){
		/*
		申请退货
		
		#.Get order
		#.Update order status
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Check --
		if ($pDescriptions[0]['Columns']['shsotState']['Value']!=2 &&
			$pDescriptions[0]['Columns']['shsotState']['Value']!=3) {
			$this->TransRollback();
			$this->sysLastError='未发起送货的商品不能确认收货。';
			return $this->sysErrorFuncID.'002';
		}
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=4,A.shsotPayyet=A.shsotTotalPrice
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：成功收货；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_Complete(&$pDescriptions){
		/*
		订单完成
		
		#.Get order
		#.Update order status
		#.Add CODE to user
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Check --
		if ($pDescriptions[0]['Columns']['shsotState']['Value']!=3 &&
			$pDescriptions[0]['Columns']['shsotState']['Value']!=4 &&
			$pDescriptions[0]['Columns']['shsotState']['Value']!=5) {
			$this->TransRollback();
			$this->sysLastError='商品未发货或未确认收货，不能结单。';
			return $this->sysErrorFuncID.'002';
		}
		if ($pDescriptions[0]['Columns']['shsotPayyet']['Value']!=$pDescriptions[0]['Columns']['shsotTotalPrice']['Value']) {
			$this->TransRollback();
			$this->sysLastError='订单未完成支付，不能结单。';
			return $this->sysErrorFuncID.'002';
		}
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=5
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Add CODE to user ------ --
		$tmpSQL=' UPDATE {Nets.TableHead}netsuserinfo AS A
			SET A.uitCode=A.uitCode+{Nets.Code}
			WHERE 1=1 AND A.uitID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.Code}',$pDescriptions[0]['Columns']['shsotTotalCode']['Value'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotCreateBy']['Value'],$tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新用户资金时错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：成功完成订单；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_Cancel(&$pDescriptions){
		/*
		取消订单
		
		#.Get order
		#.Modify Order Status
		#.Return of money paid to the user
		#.Return sales
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='更新订单时错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Modify Order Status ------ --
		//-- #Check --
		if ($pDescriptions[0]['Columns']['shsotState']['Value']!=0 &&
			$pDescriptions[0]['Columns']['shsotState']['Value']!=1) {
			$this->TransRollback();
			$this->sysLastError='您的订单已支付成功，不能取消。';
			return $this->sysErrorFuncID.'002';
		}
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=7,A.shsotPayyet=0
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Return of money paid to the user ------ --
		$tmpSQL=' UPDATE {Nets.TableHead}netsuserinfo AS A
			SET A.uitMoney=A.uitMoney+{Nets.Money}
			WHERE 1=1 AND A.uitID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.Money}',$pDescriptions[0]['Columns']['shsotPayyet']['Value'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotCreateBy']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新用户资金时错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		
		//-- ------ #Return sales ------ --
		$tmpCar_List=array();
		$tmpAR0=explode($this->sysSPLIT3,$pDescriptions[1]['Columns']['shsoctSales']['Value']);
		$Coun0=0;
		foreach ($tmpAR0 as $Row0){
			$tmpAR1=explode($this->sysSPLIT2,$Row0);
			if (count($tmpAR1)==$this->sCellCount) {
				$tmpCar_List[$Coun0]['ID']=$tmpAR1[0];
				$tmpCar_List[$Coun0]['Count']=$tmpAR1[1];
				$tmpCar_List[$Coun0]['Price']=$tmpAR1[2];
				$tmpCar_List[$Coun0]['Code']=$tmpAR1[3];
				$tmpCar_List[$Coun0]['Activeid']=$tmpAR1[4];
				$tmpCar_List[$Coun0]['Parentid']=$tmpAR1[5];
				$tmpCar_List[$Coun0]['Type']=$tmpAR1[6];
				$tmpCar_List[$Coun0]['Parameters']=$tmpAR1[7];
				$Coun0++;
			}
		}
		$Coun0=0;
		foreach ($tmpCar_List as $Row0){		
			$tmpSQL=' UPDATE {Nets.TableHead}shopsalecont AS A
				SET A.shsctCount_Total=A.shsctCount_Total-{Nets.Count_Order},
				A.shsctCount_Order=A.shsctCount_Order-{Nets.Count_Order}
				WHERE 1=1 AND A.shsctIndexID={Nets.ID} ';
			$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
			$tmpSTR=str_replace('{Nets.Count_Order}',$Row0['Count'],$tmpSTR);
			$tmpSTR=str_replace('{Nets.ID}',$Row0['ID'],$tmpSTR);
			$tmpINT=$this->Execute($tmpSTR);
			if($tmpINT!=0){
				$this->TransRollback();
				$this->sysLastError='返还商品数量时错误，请客服人员联系。';
				return $this->sysErrorFuncID.'002';
			}
			
			$Coun0++;
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：确定取消订单；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_Returns(&$pDescriptions){
		/*
		申请退货
		
		#.Get order
		#.Update order status
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Check --
		if ($pDescriptions[0]['Columns']['shsotState']['Value']!=3 &&
			$pDescriptions[0]['Columns']['shsotState']['Value']!=4 &&
			$pDescriptions[0]['Columns']['shsotState']['Value']!=5) {
			$this->TransRollback();
			$this->sysLastError='您的订单已支付成功，不能取消。';
			return $this->sysErrorFuncID.'002';
		}
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=6
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：申请返还货物；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_ReturnsSuccess(&$pDescriptions){
		/*
		退货成功确认
		
		#.Get order
		#.Update order status
		#.返还资金给用户
		#.返还订单积分
		#.返还商品数量
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Check --
		if ($pDescriptions[0]['Columns']['shsotState']['Value']!=6) {
			$this->TransRollback();
			$this->sysLastError='未申请退货，不能确认退货。';
			return $this->sysErrorFuncID.'002';
		}
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=7
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		
		//-- ------ #Return of money paid to the user ------ --
		$tmpSQL=' UPDATE {Nets.TableHead}netsuserinfo AS A
			SET A.uitMoney=A.uitMoney+{Nets.Money}
			WHERE 1=1 AND A.uitID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.Money}',$pDescriptions[0]['Columns']['shsotPayyet']['Value'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotCreateBy']['Value'],$tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新用户资金时错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Return of money paid to the user ------ --
		if ($pDescriptions[0]['Columns']['shsotPayyet']['Value']==$pDescriptions[0]['Columns']['shsotTotalPrice']['Value']) {
			$tmpSQL=' UPDATE {Nets.TableHead}netsuserinfo AS A
				SET A.uitCode=A.uitCode-{Nets.Code}
				WHERE 1=1 AND A.uitID={Nets.ID} ';
			$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
			$tmpSTR=str_replace('{Nets.Code}',$pDescriptions[0]['Columns']['shsotTotalCode']['Value'],$tmpSTR);
			$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotCreateBy']['Value'],$tmpSTR);
			if($tmpINT!=0){
				$this->TransRollback();
				$this->sysLastError='更新用户积分时错误，请客服人员联系。';
				return $this->sysErrorFuncID.'002';
			}
		}
		
		//-- ------ #Return sales ------ --
		$tmpCar_List=array();
		$tmpAR0=explode($this->sysSPLIT3,$pDescriptions[1]['Columns']['shsoctSales']['Value']);
		$Coun0=0;
		foreach ($tmpAR0 as $Row0){
			$tmpAR1=explode($this->sysSPLIT2,$Row0);
			if (count($tmpAR1)==4) {
				$tmpCar_List[$Coun0]['ID']=$tmpAR1[0];
				$tmpCar_List[$Coun0]['Count']=$tmpAR1[1];
				$tmpCar_List[$Coun0]['Price']=$tmpAR1[2];
				$tmpCar_List[$Coun0]['Code']=$tmpAR1[3];
				$tmpCar_List[$Coun0]['Activeid']=$tmpAR1[4];
				$tmpCar_List[$Coun0]['Parentid']=$tmpAR1[5];
				$tmpCar_List[$Coun0]['Type']=$tmpAR1[6];
				$tmpCar_List[$Coun0]['Parameters']=$tmpAR1[7];
				$Coun0++;
			}
		}
		$Coun0=0;
		foreach ($tmpCar_List as $Row0){
			$tmpSQL=' UPDATE {Nets.TableHead}shopsalecont AS A
				SET A.shsctCount_Order=A.shsctCount_Order-{Nets.Count_Order}
				WHERE 1=1 AND A.shsctIndexID={Nets.ID} ';
			$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
			$tmpSTR=str_replace('{Nets.Count_Order}',$Row0['Count'],$tmpSTR);
			$tmpSTR=str_replace('{Nets.ID}',$Row0['ID'],$tmpSTR);
			if($tmpINT!=0){
				$this->TransRollback();
				$this->sysLastError='返还商品数量时错误，请客服人员联系。';
				return $this->sysErrorFuncID.'002';
			}
			
			$Coun0++;
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：成功收货；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}

	public function order_Sent_F(&$pDescriptions){
		/*
		管理员强行发货
		
		#.Get order
		#.Update order status
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=2
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：客服强行发货；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_SentM_F(&$pDescriptions){
		/*
		管理员强行发货
		
		#.Get order
			#.Update order status
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=3
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：客服强行发货（货到付款）；';
			
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_Received_F(&$pDescriptions){
		/*
		管理员强行发货
		
		#.Get order
		#.Update order status
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=4
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：客服强行确认收货；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_Return_F(&$pDescriptions){
		/*
		管理员强行发货
		
		#.Get order
		#.Update order status
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=6
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：客服强行设置退货；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_Cancel_F(&$pDescriptions){
		/*
		管理员强行发货
		
		#.Get order
		#.Update order status
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=7,A.shsotPayyet=0
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Return of money paid to the user ------ --
		$tmpSQL=' UPDATE {Nets.TableHead}netsuserinfo AS A
			SET A.uitMoney=A.uitMoney+{Nets.Money}
			WHERE 1=1 AND A.uitID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.Money}',$pDescriptions[0]['Columns']['shsotPayyet']['Value'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotCreateBy']['Value'],$tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新用户资金时错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		
		//-- ------ #Return sales ------ --
		$tmpCar_List=array();
		$tmpAR0=explode($this->sysSPLIT3,$pDescriptions[1]['Columns']['shsoctSales']['Value']);
		$Coun0=0;
		foreach ($tmpAR0 as $Row0){
			$tmpAR1=explode($this->sysSPLIT2,$Row0);
			if (count($tmpAR1)==$this->sCellCount) {
				$tmpCar_List[$Coun0]['ID']=$tmpAR1[0];
				$tmpCar_List[$Coun0]['Count']=$tmpAR1[1];
				$tmpCar_List[$Coun0]['Price']=$tmpAR1[2];
				$tmpCar_List[$Coun0]['Code']=$tmpAR1[3];
				$tmpCar_List[$Coun0]['Activeid']=$tmpAR1[4];
				$tmpCar_List[$Coun0]['Parentid']=$tmpAR1[5];
				$tmpCar_List[$Coun0]['Type']=$tmpAR1[6];
				$tmpCar_List[$Coun0]['Parameters']=$tmpAR1[7];
				$Coun0++;
			}
		}
		$Coun0=0;
		foreach ($tmpCar_List as $Row0){		
			$tmpSQL=' UPDATE {Nets.TableHead}shopsalecont AS A
				SET A.shsctCount_Total=A.shsctCount_Total-{Nets.Count_Order},
				A.shsctCount_Order=A.shsctCount_Order-{Nets.Count_Order}
				WHERE 1=1 AND A.shsctIndexID={Nets.ID} ';
			$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
			$tmpSTR=str_replace('{Nets.Count_Order}',$Row0['Count'],$tmpSTR);
			$tmpSTR=str_replace('{Nets.ID}',$Row0['ID'],$tmpSTR);
			if($tmpINT!=0){
				$this->TransRollback();
				$this->sysLastError='返还商品数量时错误，请客服人员联系。';
				return $this->sysErrorFuncID.'002';
			}
			
			$Coun0++;
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：客服强行取消订单；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	public function order_Complete_F(&$pDescriptions){
		/*
		管理员强行发货
		
		#.Get order
		#.Update order status
		*/
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		$this->TransStart();
		$tmpApp_Code=new netsCode();
		//-- ------ #Get order ------ --
		$tmpSQL=' SELECT * 
			FROM {Nets.TableHead}shopsaleorder AS A
			INNER JOIN {Nets.TableHead}shopsaleordercont AS B ON B.shsoctIndexID=A.shsotID
			WHERE 1=1 AND A.shsotNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$pDescriptions[0]['Columns']['shsotNumCode']['Value'],$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		if(count($tmpData0)==0){
			$this->TransRollback();
			$this->sysLastError='订单生成错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		$tmpINT=$this->getDescriptionFromData($pDescriptions,$tmpData0);
		
		//-- ------ #Update order status ------ --
		//-- #Update --
		$tmpSQL=' UPDATE {Nets.TableHead}shopsaleorder AS A
			SET A.shsotState=5,A.shsotPayyet=A.shsotTotalPrice
			WHERE 1=1 AND A.shsotID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotID']['Value'],$tmpSTR);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新订单状态错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Add CODE to user ------ --
		$tmpSQL=' UPDATE {Nets.TableHead}netsuserinfo AS A
			SET A.uitCode=A.uitCode+{Nets.Code}
			WHERE 1=1 AND A.uitID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.Code}',$pDescriptions[0]['Columns']['shsotTotalCode']['Value'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.ID}',$pDescriptions[0]['Columns']['shsotCreateBy']['Value'],$tmpSTR);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='更新用户资金时错误，请客服人员联系。';
			return $this->sysErrorFuncID.'002';
		}
		//-- ------ #Record ------ --
		$tmpDbDescriptions=array(
			$this->sDbDescriptions_Other[0],
			$this->sDbDescriptions_Other[1],
			);
		//#Get numCode
		$tmpSTR='shsortNumCode';
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']=$tmpSTR;
		$tmpDbDescriptions[0]['Columns'][$tmpSTR]['Value']='N_'.date('YmdHis');
		$this->numCode($tmpDbDescriptions[0]);
		//-- #Set --
		$tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'].='：客服强行完成订单；';
		
		$tmpDbDescriptions[0]['Columns']['shsortName']['Value']=$tmpApp_Code->SubString($tmpDbDescriptions[1]['Columns']['shsorctContent']['Value'],0,60);
		$tmpDbDescriptions[0]['Columns']['shsortParid']['Value']=$pDescriptions[0]['Columns']['shsotID']['Value'];
		$tmpDbDescriptions[0]['Columns']['shsortChecked']['Value']=2;
		$tmpDbDescriptions[0]['Columns']['shsortSaleType']['Value']=$this->sOrderRecordType;
		$tmpDbDescriptions[0]['Columns']['shsortCreateTime']['Value']=date($this->sysTimeFormat);
		
		//#Add
		$tmpDbDescriptions[0]['TableDescription']['SearchColumn']='shsortNumCode,shsortID';
		$tmpDbDescriptions[1]['TableDescription']['SearchColumn']='shsorctIndexID';
		$tmpINT=$this->add($tmpDbDescriptions);
		if($tmpINT!=0){
			$this->TransRollback();
			$this->sysLastError='生成操作记录错误，请客服人员联系。';
			return $tmpINT;
		}
		
		$this->TransCommit();
		return 0;
	}
	
	public function order_MakeContent($pOperation,$pContent,&$pContent_Cookie,&$pAR_Content){
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		//-- ------ ### ------ --
		$tmpAR_Content=array();
		$tmpAR_Operation=array();
		//-- ------ #$pContent_Cookie ------ --
		$tmpAR0=explode($this->sysSPLIT5,$pContent_Cookie);
		$Coun0=0;
		foreach ($tmpAR0 as $Row0){
			$tmpAR1=explode($this->sysSPLIT2,$Row0);
			if (count($tmpAR1)==$this->sCellCount) {
				$tmpAR_Content[]=$tmpAR1;
			}
			$Coun0++;
		}
		//-- ------ #$pContent ------ --
		if ($pContent!='') {
			$tmpAR_Content=array();
			$tmpAR0=explode($this->sysSPLIT5,$pContent);
			$Coun0=0;
			foreach ($tmpAR0 as $Row0){
				$tmpAR1=explode($this->sysSPLIT2,$Row0);
				if (count($tmpAR1)==$this->sCellCount) {
					$tmpAR_Content[]=$tmpAR1;
				}
				$Coun0++;
			}
		}
		//-- ------ #$pOperation ------ --
		$tmpAR0=explode($this->sysSPLIT5,$pOperation);
		$Coun0=0;
		foreach ($tmpAR0 as $Row0){
			$tmpAR1=explode($this->sysSPLIT2,$Row0);
			if (count($tmpAR1)==$this->sCellCount) {
				$tmpAR_Operation[]=$tmpAR1;
			}
			$Coun0++;
		}
		//-- ------ ### ------ --
		//-- #Replace --
		$Coun0=0;
		while (count($tmpAR_Operation)>$Coun0) {
			$Coun1=0;
			while (count($tmpAR_Content)>$Coun1){
				if ($tmpAR_Operation[$Coun0][0]==$tmpAR_Content[$Coun1][0] &&
					$tmpAR_Operation[$Coun0][4]==$tmpAR_Content[$Coun1][4] &&
					$tmpAR_Operation[$Coun0][5]==$tmpAR_Content[$Coun1][5] &&
					$tmpAR_Operation[$Coun0][6]==$tmpAR_Content[$Coun1][6] &&
					$tmpAR_Operation[$Coun0][7]==$tmpAR_Content[$Coun1][7]) {
					$tmpAR_Content[$Coun1]=$tmpAR_Operation[$Coun0];
					$tmpAR_Operation[$Coun0]=array();
					$Coun1=count($tmpAR_Content)+1;
				}
				
				$Coun1++;
			}
			$Coun0++;
		}
		//-- #Add --
		$Coun0=0;
		while (count($tmpAR_Operation)>$Coun0) {
			if (count($tmpAR_Operation[$Coun0])==$this->sCellCount) {
				$tmpAR_Content[]=$tmpAR_Operation[$Coun0];
			}
			$Coun0++;
		}
		//-- #Sub zore --
		$tmpAR0=$tmpAR_Content;
		$tmpAR_Content=array();
		$Coun0=0;
		while (count($tmpAR0)>$Coun0) {
			if (count($tmpAR0[$Coun0])==$this->sCellCount && $tmpAR0[$Coun0][1]>0) {
				$tmpAR_Content[]=$tmpAR0[$Coun0];
			}
			$Coun0++;
		}
		//-- #STR --
		$tmpSTR='';
		$Coun0=0;
		foreach ($tmpAR_Content as $Row0){
			$tmpSTR.=$Row0[0].$this->sysSPLIT2.
				$Row0[1].$this->sysSPLIT2.
				$Row0[2].$this->sysSPLIT2.
				$Row0[3].$this->sysSPLIT2.
				$Row0[4].$this->sysSPLIT2.
				$Row0[5].$this->sysSPLIT2.
				$Row0[6].$this->sysSPLIT2.
				$Row0[7].$this->sysSPLIT2.$this->sysSPLIT5;
			$Coun0++;
		}
		//-- ------ ### ------ --
		$pContent_Cookie=$tmpSTR;
		$pAR_Content=$tmpAR_Content;
		
		return 0;
	}
	public function order_CheckContent(&$pAR){
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		//-- ------ ### ------ --
		$tmpCar_List=$pAR;
		//-- ------ ### ------ --
		//-- #Normal --
		$tmpSQL=' SELECT A.shstID,A.shstName,A.shstPrice,A.shstCode
		
			FROM {Nets.TableHead}shopsale AS A
			INNER JOIN {Nets.TableHead}shopsalecont AS B ON B.shsctIndexID=A.shstID
			WHERE 1=1 AND A.shstRecycle=0 AND A.shstChecked>1 AND (1=2 {Nets.IDS}) ';
		
		$Coun0=0;
		$tmpSTR_0='';
		foreach ($tmpCar_List as $Row0){
			if ($Row0['Type']==0) {
				$tmpSTR_0.=' OR A.shstID='.$Row0['ID'];
			}
		}
		
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.IDS}',$tmpSTR_0,$tmpSTR);
		$tmpData0=$this->Search($tmpSTR);
		$Coun0=0;
		foreach ($tmpData0 as $Row0){
			$Coun1=0;
			while (count($tmpCar_List)>$Coun1) {
				if ($tmpCar_List[$Coun1]['ID']==$Row0['shstID']) {
					$tmpCar_List[$Coun1]['Price']=$Row0['shstPrice'];
					$tmpCar_List[$Coun1]['Code']=$Row0['shstCode'];
				}
				$Coun1++;
			}
			$Coun0++;
		}
		
		//-- ------ ### ------ --
		$pAR=$tmpCar_List;
		return 0;
	}


}
?>