<?php
class netsDb extends netsMySql {
	private $sysErrorClassID='0000';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	public $sDbDescriptions_Other=array();
	public $sCountUpdateConfig_Template=array(
		'Type'=>0, //0.info,1.group
		'Parent_TableName'=>'corenets_cmsdoccont',
		'Parent_CountColumnName'=>'cdctCount_Discuss',
		'Parent_Condition'=>'',
		'Child_A_TableName'=>'corenets_cmsdocdiscuss',
		'Child_A_CountColumnName'=>'cddtID',
		'Child_A_Condition'=>'',
		'Child_B_TableName'=>'corenets_cmsdocdiscuss',
		'Child_B_CountColumnName'=>'cddtID',
		'Child_B_Condition'=>'',
		);

	public function netsDb($pConnection){
		$this->netsMySql($pConnection);
	}
	
	public function getChild($pStartid,$pTableName,$pColumnHead){
		$tmpSQL=' SELECT
			A.'.$pColumnHead.'ID,A.'.$pColumnHead.'Name,A.'.$pColumnHead.'Parid
			FROM '.$pTableName.' AS A
			WHERE 1=1 AND A.'.$pColumnHead.'Recycle=0 AND A.'.$pColumnHead.'Checked>1
			AND A.'.$pColumnHead.'Parid={Nets.Parid}
			ORDER BY A.'.$pColumnHead.'OrderBy DESC,A.'.$pColumnHead.'ID DESC ';
		$tmpAR0=array($pStartid);
		$Coun0=0;
		while (count($tmpAR0)>$Coun0) {
			$tmpSTR=str_replace('{Nets.Parid}',$tmpAR0[$Coun0],$tmpSQL);
			$tmpDataCollection0=$this->Search($tmpSTR);
			foreach ($tmpDataCollection0 as $Row0){
				$tmpAR0[]=$Row0[$pColumnHead.'ID'];
			}
			$Coun0++;
		}
		return $tmpAR0;
	}
	public function getParent($pStartid,$pTableName,$pColumnHead){
		$tmpSQL=' SELECT
			A.'.$pColumnHead.'ID,A.'.$pColumnHead.'Name,A.'.$pColumnHead.'Parid
			FROM '.$pTableName.' AS A
			WHERE 1=1 AND A.'.$pColumnHead.'Recycle=0 AND A.'.$pColumnHead.'Checked>1
			AND A.'.$pColumnHead.'ID={Nets.Parid}
			ORDER BY A.'.$pColumnHead.'OrderBy DESC,A.'.$pColumnHead.'ID DESC ';
		$tmpSTR=str_replace('{Nets.Parid}',$pStartid,$tmpSQL);
		$tmpDataCollection0=$this->Search($tmpSTR);
		if(count($tmpDataCollection0)==0){
			return array();
		}
		$tmpAR0=array($tmpDataCollection0[0]);
		$Coun0=0;
		while (count($tmpAR0)>$Coun0) {
			$tmpSTR=str_replace('{Nets.Parid}',$tmpAR0[$Coun0][$pColumnHead.'Parid'],$tmpSQL);
			$tmpDataCollection0=$this->Search($tmpSTR);
			foreach ($tmpDataCollection0 as $Row0){
				$tmpAR0[]=$Row0;
			}
			$Coun0++;
		}
		return $tmpAR0;
	}
	public function getOne(&$pDescriptions){
		$this->sysErrorFuncID=$this->sysErrorClassID.'02';
		//#Get data
		$tmpSQL=' SELECT * 
			FROM '.$pDescriptions[0]['TableDescription']['sttTableName'].' AS A0 ';
		$Coun0=0;
		foreach ($pDescriptions as $TableCell){
			if($Coun0>0){
				$tmpSQL.=' LEFT OUTER JOIN '.$TableCell['TableDescription']['sttTableName'].
					' AS A'.$Coun0.' ON A'.$Coun0.'.'.$TableCell['TableDescription']['sttColumnHead'].
					'IndexID=A0.'.$pDescriptions[0]['TableDescription']['sttColumnHead'].'ID ';
			}
			$Coun0++;
		}
		$tmpSQL.=' WHERE 1=1 AND '.$pDescriptions[0]['TableDescription']['sttColumnHead'].'ID='.$pDescriptions[0]['Columns'][$pDescriptions[0]['TableDescription']['sttColumnHead'].'ID']['Value'].' ';
		$tmpSQL.=' LIMIT 0,1 ';
		$tmpDataCollection0=$this->Search($tmpSQL);
		//#Get column value
		$tmpDescriptions=$pDescriptions;
		$Coun0=0;
		foreach ($tmpDescriptions as $TableCell){
			$Coun1=0;
			foreach ($TableCell['Columns'] as $Column){
				if(isset($tmpDataCollection0[0][$Column['stcotName']])){
					$pDescriptions[$Coun0]['Columns'][$Column['stcotName']]['Value']=$tmpDataCollection0[0][$Column['stcotName']];
				}
				$Coun1++;
			}
			$Coun0++;
		}
		
		return 0;
	}
	public function getMulti(){}
	public function getDescriptionFromData(&$pDescriptions,$pData){
		$tmpDescriptions=$pDescriptions;
		$Coun0=0;
		foreach ($tmpDescriptions as $TableCell){
			$Coun1=0;
			foreach ($TableCell['Columns'] as $Column){
				if(isset($pData[0][$Column['stcotName']])){
					$pDescriptions[$Coun0]['Columns'][$Column['stcotName']]['Value']=$pData[0][$Column['stcotName']];
				}
				$Coun1++;
			}
			$Coun0++;
		}
		return 0;
	}
	public function updateCount($pCountConfigs){
		$this->sysErrorFuncID=$this->sysErrorClassID.'02';
		//-- ------ ### ------ --
		foreach ($pCountConfigs as $Row_Config){
			//-- #Spell SQL --
			if ($Row_Config['Type']==1) {
				
			}else {
				$tmpSQL=' UPDATE {Nets.Parent_TableName} AS A SET {Nets.Parent_CountColumnName}=
					(SELECT COUNT({Nets.Child_A_CountColumnName}) FROM {Nets.Child_A_TableName} AS B WHERE 1=1 {Nets.Child_A_Condition})
					WHERE 1=1 {Nets.Parent_Condition} ';
				$tmpSTR=str_replace('{Nets.Parent_TableName}',$Row_Config['Parent_TableName'],$tmpSQL);
				$tmpSTR=str_replace('{Nets.Parent_CountColumnName}',$Row_Config['Parent_CountColumnName'],$tmpSTR);
				$tmpSTR=str_replace('{Nets.Parent_Condition}',$Row_Config['Parent_Condition'],$tmpSTR);
				$tmpSTR=str_replace('{Nets.Child_A_TableName}',$Row_Config['Child_A_TableName'],$tmpSTR);
				$tmpSTR=str_replace('{Nets.Child_A_CountColumnName}',$Row_Config['Child_A_CountColumnName'],$tmpSTR);
				$tmpSTR=str_replace('{Nets.Child_A_Condition}',$Row_Config['Child_A_Condition'],$tmpSTR);

			}
			//-- #Execute --
			$tmpINT=$this->Execute($tmpSTR);
		}
		
		return 0;
	}
	public function numCode(&$pDescription){
		$this->sysErrorFuncID=$this->sysErrorClassID.'02';
		
		$Coun0=0;
		$tmpColumnName=$pDescription['TableDescription']['SearchColumn'];
		$tmpColumnValue=$pDescription['Columns'][$tmpColumnName]['Value'];
		while($Coun0>=0){
			$tmpRandSTR=$tmpColumnValue.rand(0,99999);
			$tmpSTR=' {0} LIKE \'{1}\' ';
			$tmpSTR=str_replace('{0}',$tmpColumnName,$tmpSTR);
			$tmpSTR=str_replace('{1}',$tmpRandSTR,$tmpSTR);
			$tmpDataCollection0=$this->SearchDB($pDescription,$tmpSTR,$tmpColumnName);
			if(count($tmpDataCollection0)==0){
				$Coun0=-1;
				$pDescription['Columns'][$tmpColumnName]['Value']=$tmpRandSTR;
			}else if($Coun0>$this->sysFileConfig['NumcodeMakeCount']){
				return $this->sysErrorFuncID.'001';
			}
			//$Coun0++;
		}
		
		return 0;
	}
	public function add(&$pDescriptions){
		$this->sysErrorFuncID=$this->sysErrorClassID.'03';
		//#Add main table
		$tmpINT=$this->InsertDB($pDescriptions[0]);
		if($tmpINT!=0){
			$this->TransRollback();
			return $this->sysErrorFuncID.'001';
		}
		//#Set extend table
		$tmpAR0=explode($this->sysSPLIT1,$pDescriptions[0]['TableDescription']['SearchColumn']);
		$tmpColumnName0=$tmpAR0[0];
		$tmpColumnName1=$tmpAR0[1];
		$tmpColumnValue=$pDescriptions[0]['Columns'][$tmpColumnName0]['Value'];
		$tmpSTR=' 1=1 AND {0} LIKE \'{1}\' ';
		$tmpSTR=str_replace('{0}',$tmpColumnName0,$tmpSTR);
		$tmpSTR=str_replace('{1}',$tmpColumnValue,$tmpSTR);
		$tmpList0=$this->SearchDB($pDescriptions[0],$tmpSTR,$tmpColumnName1);
		$tmpMainID=$tmpList0[0][$tmpColumnName1];
		//#Add extend table
		$Coun0=1;
		while(count($pDescriptions)>$Coun0){
			$pDescriptions[$Coun0]['Columns'][$pDescriptions[$Coun0]['TableDescription']['SearchColumn']]['Value']=$tmpMainID;
			$tmpINT=$this->InsertDB($pDescriptions[$Coun0]);
			if($tmpINT!=0){
				$this->TransRollback();
				return $this->sysErrorFuncID.'002';
			}
			$Coun0++;
		}
		
		return 0;
	}
	public function modify($pDescriptions){
		$this->sysErrorFuncID=$this->sysErrorClassID.'03';
		$tmpCode=new netsCode();
		
		$Coun0=0;
		foreach ($pDescriptions as $tableCell){
			if($Coun0==0){
				$tmpINT=$this->UpdateDB($tableCell,$tableCell['TableDescription']['sttColumnHead'].'ID='.$tableCell['Columns'][$tableCell['TableDescription']['sttColumnHead'].'ID']['Value'].' ');
				if($tmpINT!=0){
					$this->TransRollback();
					return $this->sysErrorFuncID.'001';
				}
			}else {
				$tmpSQL=' SELECT '.$tableCell['TableDescription']['sttColumnHead'].'IndexID FROM '.$tableCell['TableDescription']['sttTableName'].' WHERE '.$tableCell['TableDescription']['sttColumnHead'].'IndexID='.$tmpCode->Int32($tableCell['Columns'][$tableCell['TableDescription']['sttColumnHead'].'IndexID']['Value'],0).'; ';
				$tmpDataCollection=$this->Search($tmpSQL);
				if(count($tmpDataCollection)>=1){
					$tmpINT=$this->UpdateDB($tableCell,$tableCell['TableDescription']['sttColumnHead'].'IndexID='.$tableCell['Columns'][$tableCell['TableDescription']['sttColumnHead'].'IndexID']['Value'].' ');
					if($tmpINT!=0){
						$this->TransRollback();
						return $this->sysErrorFuncID.'002';
					}
				}else if(count($tmpDataCollection)<1){
					$tableCell['Columns'][$tableCell['TableDescription']['sttColumnHead'].'IndexID']['Value']=$pDescriptions[0]['Columns'][$pDescriptions[0]['TableDescription']['sttColumnHead'].'ID']['Value'];
					$tmpINT=$this->InsertDB($tableCell);
					if($tmpINT!=0){
						$this->TransRollback();
						return $this->sysErrorFuncID.'003';
					}
				}
			}
			$Coun0++;
		}
		
		return 0;
	}
	public function delete($pDescriptions,$pIds,$pSPLIT){
		$this->sysErrorFuncID=$this->sysErrorClassID.'03';
		
		$tmpAR0=explode($pSPLIT,$pIds);
		$Coun0=0;
		foreach ($pDescriptions as $Cell){
			$tmpSTR='';
			foreach ($tmpAR0 as $Cell_0){
				if($Coun0==0){
					if($Cell_0!='')
						$tmpSTR.=' OR '.$Cell['TableDescription']['sttColumnHead'].'ID='.$Cell_0.' ';
				}else {
					if($Cell_0!='')
						$tmpSTR.=' OR '.$Cell['TableDescription']['sttColumnHead'].'IndexID='.$Cell_0.' ';
				}
			}
			$tmpSQL=' DELETE FROM '.$Cell['TableDescription']['sttTableName'].' WHERE 1=1 AND (1=2 {Nets.IDS}); ';
			$tmpSTR=str_replace('{Nets.IDS}',$tmpSTR,$tmpSQL);
			$tmpINT=$this->Execute($tmpSTR);
			if($tmpINT!=0){
				$this->sysLastError='删除错误，请与管理员联系。';
				$this->TransRollback();
				return $this->sysErrorFuncID.'002';
			}
			$Coun0++;
		}
		
		return 0;
	}
	public function deleteChild($pDescriptions,$pAR0,$pIds,&$oIds,$pExtend=''){
		$tmpCode=new netsCode();
		//-- ------ #Delete user ------ --
		//Select
		$tmpAR0=explode($this->sysSPLIT1,$pIds);
		$tmpSTR='';
		foreach ($tmpAR0 as $Cell){
			$tmpSTR.=' OR '.$pAR0[0].'='.$Cell.' ';
		}
		$tmpSQL=' SELECT '.$pAR0[2].'ID FROM '.$pAR0[1].' WHERE 1=1 AND (1=2 {Nets.IDS}) '.$pExtend.'; ';
		$tmpSTR=str_replace('{Nets.IDS}',$tmpSTR,$tmpSQL);
		$tmpData0=$this->Search($tmpSTR);
		$tmpIDS_0='';
		$tmpIDS_1='';
		$tmpSTR='';
		foreach ($tmpData0 as $Row0){
			$tmpINT=$tmpCode->Int32($Row0[$pAR0[2].'ID'],0);
			$tmpIDS_0.=' OR '.$pAR0[2].'ID='.$tmpINT.' ';
			$tmpIDS_1.=' OR '.$pAR0[3].'IndexID='.$tmpINT.' ';
			$tmpSTR.=$tmpINT.$this->sysSPLIT1;
		}
		$oIds=$tmpSTR;
		//Delete
		$tmpSQL=' DELETE FROM '.$pAR0[1].' WHERE 1=1 AND (1=2 {Nets.IDS}); ';
		$tmpSTR=str_replace('{Nets.IDS}',$tmpIDS_0,$tmpSQL);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			return $this->sysErrorFuncID.'001';
		}
		$tmpSQL=' DELETE FROM '.$pAR0[1].'cont WHERE 1=1 AND (1=2 {Nets.IDS}); ';
		$tmpSTR=str_replace('{Nets.IDS}',$tmpIDS_1,$tmpSQL);
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			return $this->sysErrorFuncID.'002';
		}

		return 0;
	}
	public function check(&$pTableDescriptAR,$pExceptionAR1,$pExceptionAR2){
		$tmpCode=new netsCode();
		
		$Coun0=0;
		foreach ($pTableDescriptAR as $Table){
			$Coun1=0;
			foreach ($Table['Columns'] as $Column){
				$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value']=$tmpCode->FilterINPUT($pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value'],2);
				if($pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['stcoctDbType']=='Int'){
					$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value']=$tmpCode->Int32($pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value'],$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['stcoctDefaultValue']);
				}else if($pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['stcoctDbType']=='Datetime'){
					$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value']=$tmpCode->DateTime($pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value'],date($this->sysTimeFormat));
				}else if($pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['stcoctDbType']=='Decimal'){
					$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value']=$tmpCode->Decimal($pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value'],$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['stcoctDefaultValue']);
				}else {
					$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value']=$tmpCode->FilterINPUT($pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value'],0);
				}

				//$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value']=iconv('GB2312',$this->sysCharset.'//IGNORE',$pTableDescriptAR[$Coun0]['Columns'][$Column['stcotName']]['Value']);
				$Coun1++;
			}
			$Coun0++;
		}
	}
	public function SearchDB($pDescription,$pCondition,$pColumn){
		$this->sysErrorFuncID=$this->sysErrorClassID.'03';
		
		$templateSQL=' SELECT {Nets.Columns} FROM {Nets.TableName} WHERE {Nets.Condition}; ';
		//Spelling Sql
		if($pColumn==''){
			$tmpSTR=str_replace('{Nets.Columns}','*',$templateSQL);
		}else {
			$tmpSTR=str_replace('{Nets.Columns}',$pColumn,$templateSQL);
		}
		$tmpSTR=str_replace('{Nets.TableName}',$pDescription['TableDescription']['sttTableName'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.Condition}',$pCondition,$tmpSTR);
		$tmpDataCollection0=$this->Search($tmpSTR);
		
		return $tmpDataCollection0;
	}
	public function InsertDB($pDescription){
		$this->sysErrorFuncID=$this->sysErrorClassID.'04';
		
		$tmpColumnName='';
		$tmpColumnValue='';
		$templateSQL=' INSERT INTO {Nets.TableName}({Nets.Columns})VALUES({Nets.Values}); ';
		//#Set column and value string
		$tmpINT=$this->checkColumn($pDescription);
		$Coun0=0;
		foreach ($pDescription['Columns'] as $Column){
			if (isset($Column['stcoctDbType']) && $Column['stcoctDbIsKey']!="1"){
				$tmpColumnName.=$Column['stcotName'];
				$tmpColumnValue.=$this->getColumnValue($Column);
				if((count($pDescription['Columns'])-1-$tmpINT)>$Coun0){
					$tmpColumnName.=',';
					$tmpColumnValue.=',';
				}
			}
			$Coun0++;
		}
		//#Spelling sql
		$tmpSTR=str_replace('{Nets.TableName}',$pDescription['TableDescription']['sttTableName'],$templateSQL);
		$tmpSTR=str_replace('{Nets.Columns}',$tmpColumnName,$tmpSTR);
		$tmpSTR=str_replace('{Nets.Values}',$tmpColumnValue,$tmpSTR);
		//#Execute
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			return $this->sysErrorFuncID.'001';
		}
		
		return 0;
	}
	public function UpdateDB($pDescription,$pCondition){
		$this->sysErrorFuncID=$this->sysErrorClassID.'05';
		
		$tmpColumnValue='';
		$templatelSQL=' UPDATE {Nets.TableName} SET {Nets.Columns} WHERE {Nets.Condition}; ';
		$tmpINT=$this->checkColumn($pDescription);
		//#Set column and value string
		$Coun0=0;
		foreach ($pDescription['Columns'] as $Column){
			if ($Column['stcoctDbIsKey']!='1' && isset($Column['stcoctDbType'])){
				$tmpColumnValue.=
					$Column['stcotName'].'='.
					$this->getColumnValue($Column);
				if((count($pDescription['Columns'])-1-$tmpINT)>$Coun0){$tmpColumnValue.=',';}
			}
			$Coun0++;
		}
		//#Spelling sql
		$tmpSTR=str_replace('{Nets.TableName}',$pDescription['TableDescription']['sttTableName'],$templatelSQL);
		$tmpSTR=str_replace('{Nets.Columns}',$tmpColumnValue,$tmpSTR);
		$tmpSTR=str_replace('{Nets.Condition}',$pCondition,$tmpSTR);
		//#Execute
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			return $this->sysErrorFuncID.'001';
		}
		
		return 0;
	}
	public function DeleteDB($pDescription,$pCondition){
		$this->sysErrorFuncID=$this->sysErrorClassID.'05';
		
		$tmpColumnValue='';
		$templatelSQL=' DELETE FROM {Nets.TableName} WHERE {Nets.Condition}; ';
		//#Spelling sql
		$tmpSTR=str_replace('{Nets.TableName}',$pDescription['TableDescription']['sttTableName'],$templatelSQL);
		$tmpSTR=str_replace('{Nets.Condition}',$pCondition,$tmpSTR);
		//#Execute
		$tmpINT=$this->Execute($tmpSTR);
		if($tmpINT!=0){
			return $this->sysErrorFuncID.'001';
		}
		
		return 0;
	}
	public function TransStart(){
		return parent::TransStart();
	}
	public function TransCommit(){
		return parent::TransCommit();
	}
	public function TransRollback(){
		return parent::TransRollback();
	}
	
	private function getColumnValue($pColumn) {
		$this->sysErrorFuncID=$this->sysErrorClassID.'12';
		
		$tmpSTR='';
		if($pColumn['stcoctDbType']=='Int' ||
			$pColumn['stcoctDbType']=='Double' ||
			$pColumn['stcoctDbType']=='Decimal'){
			$tmpSTR=$pColumn['Value'];
		}else if($pColumn['stcoctDbType']=='Varchar' ||
			$pColumn['stcoctDbType']=='Longtext' ||
			$pColumn['stcoctDbType']=='Text'){
			$tmpSTR=" '".$pColumn["Value"]."' ";
		}else if($pColumn['stcoctDbType']=='Datetime'){
			//$tmpSTR='#'.$pColumn['Value'].'#';
			$tmpSTR='\''.$pColumn['Value'].'\'';
		}
		return $tmpSTR;
	}
	public function getTableIndex($pTable,$pTableName){
		$this->sysErrorFuncID=$this->sysErrorClassID.'13';
		
		$Coun0=0;
		foreach ($pTable as $TableDescription){
			if(strtolower($TableDescription['TableDescription']['sttTableName'])==strtolower($pTableName)){
				return $Coun0;
			}
			$Coun0++;
		}
		
		return 0;
	}
	public function getColumnIndex($pTable,$pColumnName){
		$this->sysErrorFuncID=$this->sysErrorClassID.'13';
		
		$Coun0=0;
		foreach ($pTable as $TableDescription){
			if(isset($TableDescription['Columns'][$pColumnName])){
				return $Coun0;
			}
			$Coun0++;
		}
		
		return 0;
	}
	public function checkColumn($pDescription){
		$this->sysErrorFuncID=$this->sysErrorClassID.'14';
		
		$tmpINT=0;
		foreach ($pDescription['Columns'] as $Column){
			if(!isset($Column['stcoctDbType'])){
				$tmpINT++;
			}
		}
		
		return $tmpINT;
	}
}
?>