<?php
class netsCode extends netsError {
	private $sysErrorClassID='0000';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	public function netsCode(){
		$this->netsError();
	}
	
	public function FilterINPUT($pSTR,$pType){
		$tmpSTR=trim($pSTR);
		$tmpAR0=array();
		//Define spical STR array
		if($pType==0){
			$tmpAR0=array(
				'\'',
				'\\',
				'CHR(34)',
				'SELECT',
				'INSERT',
				'INTO',
				'UPDATE',
				'DELETE',
				'UNION',
				'SCRIPT',
				'JAVASCRIPT',
				'VBSCRIPT',
				);
			$tmpSTR=stripslashes($tmpSTR);
		}else if($pType==1){
			$tmpAR0=array(
				'\'',
				'\\',
				);
			$tmpSTR=stripslashes($tmpSTR);
		}else if($pType==2){
			$tmpAR0=array(
				'\'',
				);
		}else if($pType==3){
			$tmpAR0=array(
				'\'',
				);
			$tmpAR_0=array("'<script[^>]*?>.*?</script>'si",);
			$tmpAR_1=array("",);
			$tmpSTR=preg_replace($tmpAR_0,$tmpAR_1,$tmpSTR);
		}
		//Spical Filter
		foreach($tmpAR0 as $Cell){
			$tmpSTR=str_replace($Cell,'',$tmpSTR);
		}
		return $tmpSTR;
	}
	public function FilterHTML($pSTR,$pSearchKeyword,$pType){
		$this->sysErrorFuncID=$this->sysErrorClassID.'8';
		$pSTR=preg_replace("/<.+?>/i","",$pSTR);
		$pSTR=str_replace('&nbsp;','',$pSTR);
		$pSTR=str_replace('&middot;','',$pSTR);
		$pSTR=str_replace('&ldquo;','',$pSTR);
		$pSTR=str_replace('&rdquo;','',$pSTR);

		return $pSTR;
	}
	public function Int32($pValue,$pDefalut){
		$this->sysErrorFuncID=$this->sysErrorClassID.'10';
		$tmpSTR='';
		//Initial parameter
		if(preg_match('/^-?\d*$/',$pValue) &&
			trim($pValue)!=''){
			$tmpSTR=$pValue;
		}else {
			$tmpSTR=$pDefalut;
		}
		$tmpSTR=floatval($tmpSTR);
		return $tmpSTR;
	}
	public function Decimal($pValue,$pDefalut){
		$this->sysErrorFuncID=$this->sysErrorClassID.'11';
		$tmpSTR='';
		//Initial parameter
		if((preg_match('/^-?\d*.\d*$/',$pValue) || 
			preg_match('/^-?\d*$/',$pValue)) &&
			trim($pValue)!=''){
			$tmpSTR=$pValue;
		}else {
			$tmpSTR=$pDefalut;
		}
		$tmpSTR=floatval($tmpSTR);
		return $tmpSTR;
	}
	public function DateTime($pValue,$pDefault){
		$this->sysErrorFuncID=$this->sysErrorClassID.'12';
		$tmpSTR='';

		if((preg_match('/^\d{4}-\d{1,2}-\d{1,2} \d{1,2}:\d{1,2}:\d{1,2}$/',$pValue) ||
			preg_match('/^\d{4}-\d{1,2}-\d{1,2}$/',$pValue)) &&
			trim($pValue)!=''){
			$tmpSTR=$pValue;
		}else {
			$tmpSTR=$pDefault;
		}

		return $tmpSTR;
	}
	public function DatetimeLong($pValue,$pType){
		$tmpSTR='';
		
		$tmpAR0=explode($this->sysSPLIT2,$pValue);
		if (count($tmpAR0)==6) {
			if ($tmpAR0[0]==0) {
			}else {
				$tmpSTR.=$tmpAR0[0].'年';
			}
			if ($tmpAR0[1]==0) {
			}else {
				$tmpSTR.=$tmpAR0[1].'月';
			}
			if ($tmpAR0[2]==0) {
			}else {
				$tmpSTR.=$tmpAR0[2].'天';
			}
			if ($tmpAR0[3]==0) {
			}else {
				$tmpSTR.=$tmpAR0[3].'小时';
			}
			if ($tmpAR0[4]==0) {
			}else {
				$tmpSTR.=$tmpAR0[4].'分钟';
			}
			if ($tmpAR0[5]==0) {
			}else {
				$tmpSTR.=$tmpAR0[5].'秒';
			}
			
		}
		
		
		return $tmpSTR;
	}
	public function SubString($pSTR,$pStart,$pLen){
		$this->sysErrorFuncID=$this->sysErrorClassID.'14';
		$tmpSTR='';
		$i=0;
		$n=$pStart;
		$str_length=strlen($pSTR);
		while (($n<$pLen) and ($i<=$str_length)){
			$temp_str=substr($pSTR,$i,1);
			$ascnum=Ord($temp_str);
			if ($ascnum>=224){
				$tmpSTR=$tmpSTR.substr($pSTR,$i,3);
				$i=$i+3;
				$n++;
			}else if ($ascnum>=192){
				$tmpSTR=$tmpSTR.substr($pSTR,$i,2);
				$i=$i+2;
				$n++;
			}else if ($ascnum>=65 && $ascnum<=90){
				$tmpSTR=$tmpSTR.substr($pSTR,$i,1);
				$i=$i+1;
				$n++;
			}else{
				$tmpSTR=$tmpSTR.substr($pSTR,$i,1);
				$i=$i+1;
				$n=$n+0.5;
			}
		}
	
		return $tmpSTR;
	}
	public $sImgWidth=0;
	public $sImgHeight=0;
	public function ImgExist($pImgPATH,$pDefaultIMG,$pWidth,$pHeight){
		$this->sysErrorFuncID=$this->sysErrorClassID.'14';
		$tmpSTR=$this->sysFileConfig['sysUiCoreRoot'].$this->sysFileConfig['defaultImgPath'];
		if ($pDefaultIMG!='') {
			$tmpSTR=$pDefaultIMG;
		}
		//#IsExist
		if(file_exists($pImgPATH) && strlen($pImgPATH)>4){
			$tmpExtendname=$this->getFileExname($pImgPATH);
			$tmpAR0=explode($this->sysSPLIT1,$this->sysFileConfig['UploadfilesImg_Type']);
			if (in_array(strtoupper($tmpExtendname),$tmpAR0)) {
				$tmpSTR=$pImgPATH;
			}
		}
		//Reset img
		$tmpAR0=getimagesize($tmpSTR);
		if ($tmpAR0[1]==0) {
			$tmpAR0[0]=$tmpAR0[1]=1;
		}
		$tmpRare=$tmpAR0[0]/$tmpAR0[1];
		$this->sImgWidth=$tmpAR0[0];
		if ($pWidth!=0 && $tmpAR0[0]>$pWidth) {
			$this->sImgWidth=$pWidth;
		}
		$this->sImgHeight=$tmpAR0[1];
		if ($pHeight!=0 && $tmpAR0[1]>$pHeight) {
			$this->sImgHeight=$pWidth;
		}

		return $tmpSTR;
	}
	public function TimeFormat($pDateTime,$pType){
		$this->sysErrorFuncID=$this->sysErrorClassID.'17';
		$tmpSTR=$pDateTime;
		$tmpSplit0=' ';
		$tmpSplit1='-';
		$tmpSplit2=':';
		//-- ------ #Analyse input datetime ------ --
		$tmpAR0=explode($tmpSplit0,$tmpSTR);
		if(count($tmpAR0)<1){
			$tmpSTR=date($this->sysTimeFormat);
			$tmpAR0=explode($tmpSplit0,$tmpSTR);
		}else if(count($tmpAR0)<2){
			$tmpAR0[1]=date('H:i:s');
		}
		$tmpAR1=explode($tmpSplit1,$tmpAR0[0]);
		if(count($tmpAR1)!=3){
			$tmpSTR=date('Y-m-d');
			$tmpAR1=explode($tmpSplit1,$tmpSTR);
		}
		$tmpAR2=explode($tmpSplit2,$tmpAR0[1]);
		if(count($tmpAR2)!=3){
			$tmpSTR=date('H:i:s');
			$tmpAR2=explode($tmpSplit2,$tmpSTR);
		}
		$tmpYear=$tmpAR1[0];
		$tmpMonth=$tmpAR1[1];
		$tmpDay=$tmpAR1[2];
		$tmpHour=$tmpAR2[0];
		$tmpMinute=$tmpAR2[1];
		$tmpSecond=$tmpAR2[2];
		//-- ------ #Check ------ --
		$tmpINT=$this->TimeCheck($tmpYear,$tmpMonth,$tmpDay,$tmpHour,$tmpMinute,$tmpSecond);

		//-- ------ #Spell datetime ------ --
		if($pType==0){
			$tmpSTR=$tmpYear.$tmpSplit1.$tmpMonth.$tmpSplit1.$tmpDay;
		}else if($pType==1){
			$tmpSTR=$tmpHour.$tmpSplit2.$tmpMinute.$tmpSplit2.$tmpSecond;
		}else if($pType==2){
			$tmpSTR=$tmpMonth.$tmpSplit1.$tmpDay;
		}else if($pType==3){
			$tmpSTR=$tmpYear;
		}else if($pType==4){
			$tmpSTR=$tmpYear.$tmpSplit1.$tmpMonth;
		}else if ($pType==5) {
			$tmpSTR=$tmpYear.$tmpSplit1.$tmpMonth.$tmpSplit1.$tmpDay.$tmpSplit0.$tmpHour;
		}else {
			$tmpSTR=$tmpYear.$tmpSplit1.$tmpMonth.$tmpSplit1.$tmpDay.$tmpSplit0.$tmpHour.$tmpSplit2.$tmpMinute.$tmpSplit2.$tmpSecond;
		}
		
		return $tmpSTR;
	}
	public function TimeToArray($pDateTime){
		$this->sysErrorFuncID=$this->sysErrorClassID.'17';
		$tmpSTR=$pDateTime;
		$tmpSplit0=' ';
		$tmpSplit1='-';
		$tmpSplit2=':';
		//-- ------ #Analyse input datetime ------ --
		$tmpAR0=explode($tmpSplit0,$tmpSTR);
		if(count($tmpAR0)<1){
			$tmpSTR=date($this->sysTimeFormat);
			$tmpAR0=explode($tmpSplit0,$tmpSTR);
		}else if(count($tmpAR0)<2){
			$tmpAR0[1]=date('H:i:s');
		}
		$tmpAR1=explode($tmpSplit1,$tmpAR0[0]);
		if(count($tmpAR1)!=3){
			$tmpSTR=date('Y-m-d');
			$tmpAR1=explode($tmpSplit1,$tmpSTR);
		}
		$tmpAR2=explode($tmpSplit2,$tmpAR0[1]);
		if(count($tmpAR2)!=3){
			$tmpSTR=date('H:i:s');
			$tmpAR2=explode($tmpSplit2,$tmpSTR);
		}
		$tmpYear=$tmpAR1[0];
		$tmpMonth=$tmpAR1[1];
		$tmpDay=$tmpAR1[2];
		$tmpHour=$tmpAR2[0];
		$tmpMinute=$tmpAR2[1];
		$tmpSecond=$tmpAR2[2];
		
		//-- ------ #Spell ------ --
		$tmpAR0=array((int)$tmpYear,(int)$tmpMonth,(int)$tmpDay,(int)$tmpHour,(int)$tmpMinute,(int)$tmpSecond);
		return $tmpAR0;
	}
	public function TimeToInt($pDatetime){
		//365*12*30*24*60*60
		$tmpSplit0=' ';
		$tmpSplit1='-';
		$tmpSplit2=':';
		
		$tmpSecondDivisor=60;
		$tmpMinuteDivisor=60;
		$tmpHourDivisor=24;
		$tmpOneDayDivisor=$tmpHourDivisor*$tmpMinuteDivisor*$tmpSecondDivisor;
		$tmpDayDivisor=28;
		$tmpDayDivisorAR=array(0,3,0,3,2,3,2,3,3,2,3,2,3,);
		$tmpMonthDivisor=12;
		$tmpYearDivisor=365;
		$tmpDayRare=48;
		//-- #Start time --
		$tmpAR0=$this->TimeToArray($pDatetime);
		
		return mktime($tmpAR0[3],$tmpAR0[4],$tmpAR0[5],$tmpAR0[1],$tmpAR0[2],$tmpAR0[0]);
	}
	public function IntToTime($pInt){
		$tmpSplit0=' ';
		$tmpSplit1='-';
		$tmpSplit2=':';
		//-- #Format time --
		$tmpSTR=date($this->sysTimeFormat,$pInt);
		
		return $tmpSTR;
	}
	public function TimeToInt_T($pDatetime){
		//365*12*28*24*60*60
		$tmpSplit0=' ';
		$tmpSplit1='-';
		$tmpSplit2=':';
		
		$tmpNumber=0;

		$tmpYear=0;
		$tmpMonth=0;
		$tmpDay=0;
		$tmpHour=0;
		$tmpMinute=0;
		$tmpSecond=0;

		$tmpEYear=0;
		$tmpEMonth=0;
		$tmpEDay=0;
		$tmpEHour=0;
		$tmpEMinute=0;
		$tmpESecond=0;
		
		$tmpSecondDivisor=60;
		$tmpMinuteDivisor=60;
		$tmpHourDivisor=24;
		$tmpOneHour=$tmpMinuteDivisor*$tmpSecondDivisor;
		$tmpOneDay=$tmpHourDivisor*$tmpMinuteDivisor*$tmpSecondDivisor;
		$tmpDayDivisor=28;
		$tmpDayDivisorAR=array(0,3,0,3,2,3,2,3,3,2,3,2,3,);
		$tmpMonthDivisor=12;
		$tmpYearDivisor=365;
		//-- #Format time --
		$tmpAR0=$this->TimeToArray($pDatetime);
		$tmpYear=$tmpAR0[0];
		$tmpMonth=$tmpAR0[1];
		$tmpDay=$tmpAR0[2];
		$tmpHour=$tmpAR0[3];
		$tmpMinute=$tmpAR0[4];
		$tmpSecond=$tmpAR0[5];
		//-- ------ ### ------ --
		//-- #Year --
		$tmpEYear=$tmpYear*($tmpYearDivisor*$tmpOneDay);
		$tmpEYear+=floor($tmpYear/4)*$tmpOneDay;
		//-- #Month --
		$tmpINT=0;
		$Coun0=0;
		while ($tmpMonth>$Coun0) {
			$tmpINT+=$tmpDayDivisor+$tmpDayDivisorAR[$Coun0+1];
			$Coun0++;
		}
		$tmpINT-=$tmpDayDivisor+$tmpDayDivisorAR[$tmpMonth];
		$tmpEMonth=$tmpINT*$tmpOneDay;
		//-- #Day --
		$tmpEDay=$tmpDay*$tmpOneDay;
		$tmpEHour=$tmpHour*$tmpOneHour;
		$tmpEMinute=$tmpMinute*$tmpSecondDivisor;
		$tmpESecond=$tmpSecond;
		//-- #SPELL --
		$tmpNumber=$tmpEYear+$tmpEMonth+$tmpEDay+$tmpEHour+$tmpEMinute+$tmpESecond;
		return $tmpNumber;
	}
	public function IntToTime_T($pInt){
		//-- #Format time --
		$tmpSplit0=' ';
		$tmpSplit1='-';
		$tmpSplit2=':';
		$tmpSplit3='.';
		
		$tmpYear=0;
		$tmpMonth=1;
		$tmpDay=1;
		$tmpHour=0;
		$tmpMinute=0;
		$tmpSecond=0;
		
		//365*12*28*24*60*60
		$tmpSecondDivisor=60;
		$tmpMinuteDivisor=60;
		$tmpHourDivisor=24;
		$tmpOneHour=$tmpMinuteDivisor*$tmpSecondDivisor;
		$tmpOneDay=$tmpHourDivisor*$tmpMinuteDivisor*$tmpSecondDivisor;
		$tmpDayDivisor=28;
		$tmpDayDivisorAR=array(0,3,0,3,2,3,2,3,3,2,3,2,3,);
		$tmpMonthDivisor=12;
		$tmpYearDivisor=365;
		//-- #Start time --
		$tmpNumber=$pInt;
		//-- #Year --
		$tmpYear=floor($tmpNumber/($tmpYearDivisor*$tmpOneDay));
		$tmpINT=floor($tmpYear/4);
		$tmpYear=floor(($tmpNumber-$tmpINT*$tmpOneDay)/($tmpYearDivisor*$tmpOneDay));
		$tmpNumber=$tmpNumber-$tmpYear*$tmpYearDivisor*$tmpOneDay-$tmpINT*$tmpOneDay;
		//-- #Month --
		$tmpMonth=floor($tmpNumber/($tmpDayDivisor*$tmpOneDay));
		$tmpINT=0;
		$Coun0=0;
		while ($tmpMonth>$Coun0) {
			$tmpINT+=$tmpDayDivisorAR[$Coun0+1];
			$Coun0++;
		}
		$tmpMonth=floor(($tmpNumber-$tmpINT*$tmpOneDay)/($tmpDayDivisor*$tmpOneDay));
		$tmpNumber=$tmpNumber-$tmpMonth*$tmpDayDivisor*$tmpOneDay-$tmpINT*$tmpOneDay;
		$tmpMonth++;
		//-- #Day --
		$tmpDay=floor($tmpNumber/$tmpOneDay);
		$tmpNumber=$tmpNumber-$tmpDay*$tmpOneDay;
		//-- #Hour --
		$tmpHour=floor($tmpNumber/$tmpOneHour);
		$tmpNumber=$tmpNumber-$tmpHour*$tmpOneHour;
		//-- #Day --
		$tmpMinute=floor($tmpNumber/$tmpMinuteDivisor);
		$tmpNumber=$tmpNumber-$tmpMinute*$tmpMinuteDivisor;
		//-- #Day --
		$tmpSecond=$tmpNumber;
		//-- #Format time --
		$tmpSTR=$tmpYear.$tmpSplit1.$tmpMonth.$tmpSplit1.$tmpDay.$tmpSplit0.$tmpHour.$tmpSplit2.$tmpMinute.$tmpSplit2.$tmpSecond;
		return $tmpSTR;
	}
	public function TimeCheck(&$pYear,&$pMonth,&$pDay,&$pHour,&$pMinute,&$pSecond){
		
		//-- ------ #Check ------ --
		$tmpSecondDivisor=60;
		$tmpMinuteDivisor=60;
		$tmpHourDivisor=24;
		$tmpOneHour=$tmpMinuteDivisor*$tmpSecondDivisor;
		$tmpOneDay=$tmpHourDivisor*$tmpMinuteDivisor*$tmpSecondDivisor;
		$tmpDayDivisor=28;
		$tmpDayDivisorAR=array(0,3,0,3,2,3,2,3,3,2,3,2,3,);
		$tmpMonthDivisor=12;
		$tmpYearDivisor=365;
		//-- #Check time range --
		//#Second
		if($pSecond<0){
			$tmpINT=$pSecond/$tmpSecondDivisor;
			$tmpINT=explode('.',$tmpINT);
			$pMinute=$pMinute+$tmpINT[0];
			$tmpINT=$pSecond%$tmpSecondDivisor;
			if ($tmpINT<0) {
				$pMinute=$pMinute-1;
				$pSecond=$tmpSecondDivisor+$tmpINT;
			}else {
				$pSecond=$tmpINT;
			}
		}
		if ($pSecond>=$tmpSecondDivisor){
			$tmpINT=$pSecond/$tmpSecondDivisor;
			$tmpINT=explode('.',$tmpINT);
			$pMinute=$pMinute+$tmpINT[0];
			$tmpINT=$pSecond%$tmpSecondDivisor;
			$pSecond=$tmpINT;
		}
		//#Minute
		if($pMinute<0){
			$tmpINT=$pMinute/$tmpMinuteDivisor;
			$tmpINT=explode('.',$tmpINT);
			$pHour=$pHour+$tmpINT[0];
			$tmpINT=$pMinute%$tmpMinuteDivisor;
			if ($tmpINT<0) {
				$pHour=$pHour-1;
				$pMinute=$tmpMinuteDivisor+$tmpINT;
			}else {
				$pMinute=$tmpINT;
			}
		}
		if ($pMinute>=$tmpMinuteDivisor) {
			$tmpINT=$pMinute/$tmpMinuteDivisor;
			$tmpINT=explode('.',$tmpINT);
			$pHour=$pHour+$tmpINT[0];
			$tmpINT=$pMinute%$tmpMinuteDivisor;
			$pMinute=$tmpINT;
		}
		//#Hour
		if($pHour<0){
			$tmpINT=$pHour/$tmpHourDivisor;
			$tmpINT=explode('.',$tmpINT);
			$pDay=$pDay+$tmpINT[0];
			$tmpINT=$pHour%$tmpHourDivisor;
			if ($tmpINT<0) {
				$pDay=$pDay-1;
				$pHour=$tmpHourDivisor+$tmpINT;
			}else {
				$pHour=$tmpINT;
			}
		}
		if ($pHour>=$tmpHourDivisor) {
			$tmpINT=$pHour/$tmpHourDivisor;
			$tmpINT=explode('.',$tmpINT);
			$pDay=$pDay+$tmpINT[0];
			$tmpINT=$pHour%$tmpHourDivisor;
			$pHour=$tmpINT;
		}
		//#SetMonth
		$tmpMonth=$pMonth;
		if($tmpMonth<0){
			$tmpINT=$pMonth%$tmpMonthDivisor;
			$pMonth=$tmpMonthDivisor+$tmpINT;
		}
		if ($tmpMonth>$tmpMonthDivisor) {
			$tmpMonth=$tmpMonth%$tmpMonthDivisor;
		}
		//#Day
		if($pDay<0){
			$tmpINT=$pDay/($tmpDayDivisor+$tmpDayDivisorAR[$this->Int32($tmpMonth,0)]);
			$tmpINT=explode('.',$tmpINT);
			$pMonth=$pMonth+$tmpINT[0];
			$tmpINT=$pDay%($tmpDayDivisor+$tmpDayDivisorAR[$this->Int32($tmpMonth,0)]);
			if ($tmpINT<0) {
				$pMonth=$pMonth-1;
				$pDay=($tmpDayDivisor+$tmpDayDivisorAR[$this->Int32($tmpMonth,0)])+$tmpINT;
			}else {
				$pDay=$tmpINT;
			}
		}
		if ($pDay>($tmpDayDivisor+$tmpDayDivisorAR[$this->Int32($tmpMonth,0)])) {
			$tmpINT=$pDay/($tmpDayDivisor+$tmpDayDivisorAR[$this->Int32($tmpMonth,0)]);
			$tmpINT=explode('.',$tmpINT);
			$pMonth=$pMonth+$tmpINT[0];
			$tmpINT=$pDay%($tmpDayDivisor+$tmpDayDivisorAR[$this->Int32($tmpMonth,0)]);
			$pDay=$tmpINT;
		}
		//#Month
		if($pMonth<0){
			$tmpINT=$pMonth/$tmpMonthDivisor;
			$tmpINT=explode('.',$tmpINT);
			$pYear=$pYear+$tmpINT[0];
			$tmpINT=$pMonth%$tmpMonthDivisor;
			if ($tmpINT<0) {
				$pYear=$pYear-1;
				$pMonth=$tmpMonthDivisor+$tmpINT;
			}else {
				$pMonth=$tmpINT;
			}
		}
		if ($pMonth>$tmpMonthDivisor) {
			$tmpINT=$pMonth/$tmpMonthDivisor;
			$tmpINT=explode('.',$tmpINT);
			$pYear=$pYear+$tmpINT[0];
			$tmpINT=$pMonth%$tmpMonthDivisor;
			$pMonth=$tmpINT;
		}
		//#Year
		if($pYear<0){
		}
		
		/*
		if($tmpAR1[0]<0){
			return 0;
		}
		if($tmpAR1[1]<0 || $tmpAR1[1]>$tmpMonthDivisor){
			return 0;
		}
		if($tmpAR1[2]<0 || $tmpAR1[2]>($tmpDayDivisor+$tmpDayDivisorAR[$this->Int32($tmpAR1[1],0)])){
			return 0;
		}
		if($tmpAR2[0]<0 || $tmpAR2[0]>=$tmpHourDivisor){
			return 0;
		}
		if($tmpAR2[1]<0 || $tmpAR2[1]>=$tmpMinuteDivisor){
			return 0;
		}
		if($tmpAR2[2]<0 || $tmpAR2[2]>=$tmpSecondDivisor){
			return 0;
		}
		*/
		return 0;
	}
	public function SamplePxd($pSTR){
		$this->sysErrorFuncID=$this->sysErrorClassID.'13';
		
		$tmpSTR='';
		$tmpSTR=md5($pSTR);
		
		return $tmpSTR;
	}
	public function URL_MakeParameter($pSTR,$pType){
		$this->sysErrorFuncID=$this->sysErrorClassID.'3';
		$tmpSTR=$pSTR;
		if($pType==1){
			$tmpSTR=str_replace($this->sysSPLIT1,'%NETSSPLIT1',$pSTR);
			$tmpSTR=str_replace('?','%NETSSPLIT2',$tmpSTR);
			$tmpSTR=str_replace('&','%NETSSPLIT3',$tmpSTR);
			
		}
		$tmpSTR=urlencode($tmpSTR);
		return $tmpSTR;
	}
	public function URL_DecodeParameter($pSTR,$pType){
		$this->sysErrorFuncID=$this->sysErrorClassID.'3';
		$tmpSTR=urldecode($pSTR);
		if($pType==1){
			$tmpSTR=str_replace('%NETSSPLIT1',$this->sysSPLIT1,$pSTR);
			$tmpSTR=str_replace('%NETSSPLIT2','?',$tmpSTR);
			$tmpSTR=str_replace('%NETSSPLIT3','&',$tmpSTR);
			
		}
		return $tmpSTR;
	}
	public function URL_Analyer($pSTR){
		//-- ------ #Initial ------ --
		//http://www.unionnets.com/docList.php?ID=100
		//Host,Port,Path,NoParameterPath,All
		$tmpSPLIT1='/';
		$tmpSPLIT2=':';
		$tmpSPLIT3='?';
		$tmpURL=array('127.0.0.1','80',$tmpSPLIT1,$tmpSPLIT1,$pSTR);
		//-- ------ #Analyer ------ --
		$tmpAR0=explode($tmpSPLIT1,$pSTR);
		//First
		if(count($tmpURL)<=2){
			return $tmpURL;
		}
		//Host and Port
		$tmpAR1=explode($tmpSPLIT2,$tmpAR0[2]);
		if (count($tmpAR1)>1) {
			$tmpURL[0]=$tmpAR1[0];
			$tmpURL[1]=$tmpAR1[1];
		}else {
			$tmpURL[0]=$tmpAR1[0];
		}
		//Path
		//NoParameterPath
		$Coun0=3;
		$tmpSTR_Path='';
		$tmpSTR_NoParameter='';
		while (count($tmpAR0)>$Coun0) {
			if ((count($tmpAR0)-1)>$Coun0) {
				$tmpSTR_Path.=$tmpAR0[$Coun0].$tmpSPLIT1;
				$tmpSTR_NoParameter.=$tmpAR0[$Coun0].$tmpSPLIT1;
			}else {
				$tmpAR1=explode($tmpSPLIT3,$tmpAR0[$Coun0]);
				$tmpSTR_Path.=$tmpAR1[0];
				$tmpSTR_NoParameter.=$tmpAR1[0];
				if (count($tmpAR1)>1) {
					$tmpSTR_Path.=$tmpSPLIT3.$tmpAR1[1];
				}
			}
			$Coun0++;
		}
		$tmpURL[2]=$tmpSTR_Path;
		$tmpURL[3]=$tmpSTR_NoParameter;

		return $tmpURL;
	}
	public function ArrayInsertRow($pArray,$pRow,$pIndex){
		$this->sysErrorFuncID=$this->sysErrorClassID.'20';
		$retArray=array();
		//
		$Coun0=0;
		foreach ($pArray as $Row){
			if($Coun0==$pIndex){
				array_push($retArray,$Row);
				array_push($retArray,$pRow);
			}else{
				array_push($retArray,$Row);
			}
			$Coun0++;
		}
		
		return $retArray;
	}
	public function AccountSectionName($pIndex,$pSectionSize){
		$tmpINT0=intval(($pIndex/$pSectionSize))*$pSectionSize+1;
		$tmpINT1=intval(($pIndex/$pSectionSize)+1)*$pSectionSize;
		$tmpSTR=$tmpINT0.'_'.$tmpINT1;
		return $tmpSTR;
	}
	public function GetFirstchar($pSTR){
		$pSTR=iconv($this->sysCharset,'GB2312//IGNORE',$pSTR);
		$tmpFirstchar='A';
		$tmpFlag=0;
		//-- ### --
		if (strlen($pSTR)<2) {
			$pSTR='AA';
		}
		//-- ### --
		$tmpFirstchar_Ord=ord(strtoupper($pSTR[0]));
		if (($tmpFirstchar_Ord>=65 && $tmpFirstchar_Ord<=91) || ($tmpFirstchar_Ord>=48 && $tmpFirstchar_Ord<=57)) {
			$tmpFlag=1;
			$tmpFirstchar=$tmpFirstchar_Ord;
		}
		//-- ### --
		$tmpASC=ord($pSTR[0])*256+ord($pSTR[1])-65536; 
		if ($tmpFlag==1) {
			$tmpASC=0;
		}
		if($tmpASC>=-20319 and $tmpASC<=-20284){
			$tmpFirstchar='A';
		}
		if($tmpASC>=-20283 and $tmpASC<=-19776){
			$tmpFirstchar='B';
		}
		if($tmpASC>=-19775 and $tmpASC<=-19219){
			$tmpFirstchar='C';
		}
		if($tmpASC>=-19218 and $tmpASC<=-18711){
			$tmpFirstchar='D';
		}
		if($tmpASC>=-18710 and $tmpASC<=-18527){
			$tmpFirstchar='E';
		}
		if($tmpASC>=-18526 and $tmpASC<=-18240){
			$tmpFirstchar='F';
		}
		if($tmpASC>=-18239 and $tmpASC<=-17923){
			$tmpFirstchar='G';
		}
		if($tmpASC>=-17922 and $tmpASC<=-17418){
			$tmpFirstchar='H';
		}
		if($tmpASC>=-17417 and $tmpASC<=-16475){
			$tmpFirstchar='J';
		}
		if($tmpASC>=-16474 and $tmpASC<=-16213){
			$tmpFirstchar='K';
		}
		if($tmpASC>=-16212 and $tmpASC<=-15641){
			$tmpFirstchar='L';
		}
		if($tmpASC>=-15640 and $tmpASC<=-15166){
			$tmpFirstchar='M';
		}
		if($tmpASC>=-15165 and $tmpASC<=-14923){
			$tmpFirstchar='N';
		}
		if($tmpASC>=-14922 and $tmpASC<=-14915){
			$tmpFirstchar='O';
		}
		if($tmpASC>=-14914 and $tmpASC<=-14631){
			$tmpFirstchar='P';
		}
		if($tmpASC>=-14630 and $tmpASC<=-14150){
			$tmpFirstchar='Q';
		}
		if($tmpASC>=-14149 and $tmpASC<=-14091){
			$tmpFirstchar='R';
		}
		if($tmpASC>=-14090 and $tmpASC<=-13319){
			$tmpFirstchar='S';
		}
		if($tmpASC>=-13318 and $tmpASC<=-12839){
			$tmpFirstchar='T';
		}
		if($tmpASC>=-12838 and $tmpASC<=-12557){
			$tmpFirstchar='W';
		}
		if($tmpASC>=-12556 and $tmpASC<=-11848){
			$tmpFirstchar='X';
		}
		if($tmpASC>=-11847 and $tmpASC<=-11056){
			$tmpFirstchar='Y';
		}
		if($tmpASC>=-11055 and $tmpASC<=-10247){
			$tmpFirstchar='Z';
		}
		
		
		return $tmpFirstchar;
	}
	public function getKeyword($pSTR,$pKeyword,$pType){
		$tmpSTR=$pSTR;
		
		if ($pType=='1') {
			
		}else {
			$tmpSTR=str_replace($pKeyword,'<span class="FRed1">'.$pKeyword.'</span>',$pSTR);
			
		}
		
		return $tmpSTR;
	}
	
	/**
	 * des
	 * this takes the key, the message, and whether to encrypt or decrypt 
	 * Example:
	 * des ($key, $message, 1, 0, null);
	 */
	public function des ($key, $message, $encrypt, $mode, $iv) {
	    //declaring this locally speeds things up a bit
	    $spfunction1 = array (0x1010400,0,0x10000,0x1010404,0x1010004,0x10404,0x4,0x10000,0x400,0x1010400,0x1010404,0x400,0x1000404,0x1010004,0x1000000,0x4,0x404,0x1000400,0x1000400,0x10400,0x10400,0x1010000,0x1010000,0x1000404,0x10004,0x1000004,0x1000004,0x10004,0,0x404,0x10404,0x1000000,0x10000,0x1010404,0x4,0x1010000,0x1010400,0x1000000,0x1000000,0x400,0x1010004,0x10000,0x10400,0x1000004,0x400,0x4,0x1000404,0x10404,0x1010404,0x10004,0x1010000,0x1000404,0x1000004,0x404,0x10404,0x1010400,0x404,0x1000400,0x1000400,0,0x10004,0x10400,0,0x1010004);
	    $spfunction2 = array (-0x7fef7fe0,-0x7fff8000,0x8000,0x108020,0x100000,0x20,-0x7fefffe0,-0x7fff7fe0,-0x7fffffe0,-0x7fef7fe0,-0x7fef8000,-0x80000000,-0x7fff8000,0x100000,0x20,-0x7fefffe0,0x108000,0x100020,-0x7fff7fe0,0,-0x80000000,0x8000,0x108020,-0x7ff00000,0x100020,-0x7fffffe0,0,0x108000,0x8020,-0x7fef8000,-0x7ff00000,0x8020,0,0x108020,-0x7fefffe0,0x100000,-0x7fff7fe0,-0x7ff00000,-0x7fef8000,0x8000,-0x7ff00000,-0x7fff8000,0x20,-0x7fef7fe0,0x108020,0x20,0x8000,-0x80000000,0x8020,-0x7fef8000,0x100000,-0x7fffffe0,0x100020,-0x7fff7fe0,-0x7fffffe0,0x100020,0x108000,0,-0x7fff8000,0x8020,-0x80000000,-0x7fefffe0,-0x7fef7fe0,0x108000);
	    $spfunction3 = array (0x208,0x8020200,0,0x8020008,0x8000200,0,0x20208,0x8000200,0x20008,0x8000008,0x8000008,0x20000,0x8020208,0x20008,0x8020000,0x208,0x8000000,0x8,0x8020200,0x200,0x20200,0x8020000,0x8020008,0x20208,0x8000208,0x20200,0x20000,0x8000208,0x8,0x8020208,0x200,0x8000000,0x8020200,0x8000000,0x20008,0x208,0x20000,0x8020200,0x8000200,0,0x200,0x20008,0x8020208,0x8000200,0x8000008,0x200,0,0x8020008,0x8000208,0x20000,0x8000000,0x8020208,0x8,0x20208,0x20200,0x8000008,0x8020000,0x8000208,0x208,0x8020000,0x20208,0x8,0x8020008,0x20200);
	    $spfunction4 = array (0x802001,0x2081,0x2081,0x80,0x802080,0x800081,0x800001,0x2001,0,0x802000,0x802000,0x802081,0x81,0,0x800080,0x800001,0x1,0x2000,0x800000,0x802001,0x80,0x800000,0x2001,0x2080,0x800081,0x1,0x2080,0x800080,0x2000,0x802080,0x802081,0x81,0x800080,0x800001,0x802000,0x802081,0x81,0,0,0x802000,0x2080,0x800080,0x800081,0x1,0x802001,0x2081,0x2081,0x80,0x802081,0x81,0x1,0x2000,0x800001,0x2001,0x802080,0x800081,0x2001,0x2080,0x800000,0x802001,0x80,0x800000,0x2000,0x802080);
	    $spfunction5 = array (0x100,0x2080100,0x2080000,0x42000100,0x80000,0x100,0x40000000,0x2080000,0x40080100,0x80000,0x2000100,0x40080100,0x42000100,0x42080000,0x80100,0x40000000,0x2000000,0x40080000,0x40080000,0,0x40000100,0x42080100,0x42080100,0x2000100,0x42080000,0x40000100,0,0x42000000,0x2080100,0x2000000,0x42000000,0x80100,0x80000,0x42000100,0x100,0x2000000,0x40000000,0x2080000,0x42000100,0x40080100,0x2000100,0x40000000,0x42080000,0x2080100,0x40080100,0x100,0x2000000,0x42080000,0x42080100,0x80100,0x42000000,0x42080100,0x2080000,0,0x40080000,0x42000000,0x80100,0x2000100,0x40000100,0x80000,0,0x40080000,0x2080100,0x40000100);
	    $spfunction6 = array (0x20000010,0x20400000,0x4000,0x20404010,0x20400000,0x10,0x20404010,0x400000,0x20004000,0x404010,0x400000,0x20000010,0x400010,0x20004000,0x20000000,0x4010,0,0x400010,0x20004010,0x4000,0x404000,0x20004010,0x10,0x20400010,0x20400010,0,0x404010,0x20404000,0x4010,0x404000,0x20404000,0x20000000,0x20004000,0x10,0x20400010,0x404000,0x20404010,0x400000,0x4010,0x20000010,0x400000,0x20004000,0x20000000,0x4010,0x20000010,0x20404010,0x404000,0x20400000,0x404010,0x20404000,0,0x20400010,0x10,0x4000,0x20400000,0x404010,0x4000,0x400010,0x20004010,0,0x20404000,0x20000000,0x400010,0x20004010);
	    $spfunction7 = array (0x200000,0x4200002,0x4000802,0,0x800,0x4000802,0x200802,0x4200800,0x4200802,0x200000,0,0x4000002,0x2,0x4000000,0x4200002,0x802,0x4000800,0x200802,0x200002,0x4000800,0x4000002,0x4200000,0x4200800,0x200002,0x4200000,0x800,0x802,0x4200802,0x200800,0x2,0x4000000,0x200800,0x4000000,0x200800,0x200000,0x4000802,0x4000802,0x4200002,0x4200002,0x2,0x200002,0x4000000,0x4000800,0x200000,0x4200800,0x802,0x200802,0x4200800,0x802,0x4000002,0x4200802,0x4200000,0x200800,0,0x2,0x4200802,0,0x200802,0x4200000,0x800,0x4000002,0x4000800,0x800,0x200002);
	    $spfunction8 = array (0x10001040,0x1000,0x40000,0x10041040,0x10000000,0x10001040,0x40,0x10000000,0x40040,0x10040000,0x10041040,0x41000,0x10041000,0x41040,0x1000,0x40,0x10040000,0x10000040,0x10001000,0x1040,0x41000,0x40040,0x10040040,0x10041000,0x1040,0,0,0x10040040,0x10000040,0x10001000,0x41040,0x40000,0x41040,0x40000,0x10041000,0x1000,0x40,0x10040040,0x1000,0x41040,0x10001000,0x40,0x10000040,0x10040000,0x10040040,0x10000000,0x40000,0x10001040,0,0x10041040,0x40040,0x10000040,0x10040000,0x10001000,0x10001040,0,0x10041040,0x41000,0x41000,0x1040,0x1040,0x40040,0x10000000,0x10041000);
	    $masks = array (4294967295,2147483647,1073741823,536870911,268435455,134217727,67108863,33554431,16777215,8388607,4194303,2097151,1048575,524287,262143,131071,65535,32767,16383,8191,4095,2047,1023,511,255,127,63,31,15,7,3,1,0);
	
	    //create the 16 or 48 subkeys we will need
	    $keys = des_createKeys ($key);
	    $m=0;
	    $len = strlen($message);
	    $chunk = 0;
	    //set up the loops for single and triple des
	    $iterations = ((count($keys) == 32) ? 3 : 9); //single or triple des
	    if ($iterations == 3) {$looping = (($encrypt) ? array (0, 32, 2) : array (30, -2, -2));}
	    else {$looping = (($encrypt) ? array (0, 32, 2, 62, 30, -2, 64, 96, 2) : array (94, 62, -2, 32, 64, 2, 30, -2, -2));}
	
	    $message .= (chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0)); //pad the message out with null bytes
	    //store the result here
	    $result = "";
	    $tempresult = "";
	
	    if ($mode == 1) { //CBC mode
	        $cbcleft = (ord($iv{$m++}) << 24) | (ord($iv{$m++}) << 16) | (ord($iv{$m++}) << 8) | ord($iv{$m++});
	        $cbcright = (ord($iv{$m++}) << 24) | (ord($iv{$m++}) << 16) | (ord($iv{$m++}) << 8) | ord($iv{$m++});
	        $m=0;
	    }
	
	    //loop through each 64 bit chunk of the message
	    while ($m < $len) {
	        $left = (ord($message{$m++}) << 24) | (ord($message{$m++}) << 16) | (ord($message{$m++}) << 8) | ord($message{$m++});
	        $right = (ord($message{$m++}) << 24) | (ord($message{$m++}) << 16) | (ord($message{$m++}) << 8) | ord($message{$m++});
	
	        //for Cipher Block Chaining mode, xor the message with the previous result
	        if ($mode == 1) {if ($encrypt) {$left ^= $cbcleft; $right ^= $cbcright;} else {$cbcleft2 = $cbcleft; $cbcright2 = $cbcright; $cbcleft = $left; $cbcright = $right;}}
	
	        //first each 64 but chunk of the message must be permuted according to IP
	        $temp = (($left >> 4 & $masks[4]) ^ $right) & 0x0f0f0f0f; $right ^= $temp; $left ^= ($temp << 4);
	        $temp = (($left >> 16 & $masks[16]) ^ $right) & 0x0000ffff; $right ^= $temp; $left ^= ($temp << 16);
	        $temp = (($right >> 2 & $masks[2]) ^ $left) & 0x33333333; $left ^= $temp; $right ^= ($temp << 2);
	        $temp = (($right >> 8 & $masks[8]) ^ $left) & 0x00ff00ff; $left ^= $temp; $right ^= ($temp << 8);
	        $temp = (($left >> 1 & $masks[1]) ^ $right) & 0x55555555; $right ^= $temp; $left ^= ($temp << 1);
	
	        $left = (($left << 1) | ($left >> 31 & $masks[31])); 
	        $right = (($right << 1) | ($right >> 31 & $masks[31])); 
	
	        //do this either 1 or 3 times for each chunk of the message
	        for ($j=0; $j<$iterations; $j+=3) {
	            $endloop = $looping[$j+1];
	            $loopinc = $looping[$j+2];
	            //now go through and perform the encryption or decryption    
	            for ($i=$looping[$j]; $i!=$endloop; $i+=$loopinc) { //for efficiency
	                $right1 = $right ^ $keys[$i]; 
	                $right2 = (($right >> 4 & $masks[4]) | ($right << 28)) ^ $keys[$i+1];
	                //the result is attained by passing these bytes through the S selection functions
	                $temp = $left;
	                $left = $right;
	                $right = $temp ^ ($spfunction2[($right1 >> 24 & $masks[24]) & 0x3f] | $spfunction4[($right1 >> 16 & $masks[16]) & 0x3f]
	                            | $spfunction6[($right1 >>    8 & $masks[8]) & 0x3f] | $spfunction8[$right1 & 0x3f]
	                            | $spfunction1[($right2 >> 24 & $masks[24]) & 0x3f] | $spfunction3[($right2 >> 16 & $masks[16]) & 0x3f]
	                            | $spfunction5[($right2 >>    8 & $masks[8]) & 0x3f] | $spfunction7[$right2 & 0x3f]);
	            }
	            $temp = $left; $left = $right; $right = $temp; //unreverse left and right
	        } //for either 1 or 3 iterations
	
	        //move then each one bit to the right
	        $left = (($left >> 1 & $masks[1]) | ($left << 31)); 
	        $right = (($right >> 1 & $masks[1]) | ($right << 31)); 
	
	        //now perform IP-1, which is IP in the opposite direction
	        $temp = (($left >> 1 & $masks[1]) ^ $right) & 0x55555555; $right ^= $temp; $left ^= ($temp << 1);
	        $temp = (($right >> 8 & $masks[8]) ^ $left) & 0x00ff00ff; $left ^= $temp; $right ^= ($temp << 8);
	        $temp = (($right >> 2 & $masks[2]) ^ $left) & 0x33333333; $left ^= $temp; $right ^= ($temp << 2);
	        $temp = (($left >> 16 & $masks[16]) ^ $right) & 0x0000ffff; $right ^= $temp; $left ^= ($temp << 16);
	        $temp = (($left >> 4 & $masks[4]) ^ $right) & 0x0f0f0f0f; $right ^= $temp; $left ^= ($temp << 4);
	
	        //for Cipher Block Chaining mode, xor the message with the previous result
	        if ($mode == 1) {if ($encrypt) {$cbcleft = $left; $cbcright = $right;} else {$left ^= $cbcleft2; $right ^= $cbcright2;}}
	        $tempresult .= (chr($left>>24 & $masks[24]) . chr(($left>>16 & $masks[16]) & 0xff) . chr(($left>>8 & $masks[8]) & 0xff) . chr($left & 0xff) . chr($right>>24 & $masks[24]) . chr(($right>>16 & $masks[16]) & 0xff) . chr(($right>>8 & $masks[8]) & 0xff) . chr($right & 0xff));
	
	        $chunk += 8;
	        if ($chunk == 512) {$result .= $tempresult; $tempresult = ""; $chunk = 0;}
	    } //for every 8 characters, or 64 bits in the message
	
	    //return the result as an array
	    return ($result . $tempresult);
	}
	/**
	 * des_createKeys
	 * this takes as input a 64 bit key (even though only 56 bits are used)
	 * as an array of 2 integers, and returns 16 48 bit keys
	 */
	public function des_createKeys ($key) {
	    //declaring this locally speeds things up a bit
	    $pc2bytes0    = array (0,0x4,0x20000000,0x20000004,0x10000,0x10004,0x20010000,0x20010004,0x200,0x204,0x20000200,0x20000204,0x10200,0x10204,0x20010200,0x20010204);
	    $pc2bytes1    = array (0,0x1,0x100000,0x100001,0x4000000,0x4000001,0x4100000,0x4100001,0x100,0x101,0x100100,0x100101,0x4000100,0x4000101,0x4100100,0x4100101);
	    $pc2bytes2    = array (0,0x8,0x800,0x808,0x1000000,0x1000008,0x1000800,0x1000808,0,0x8,0x800,0x808,0x1000000,0x1000008,0x1000800,0x1000808);
	    $pc2bytes3    = array (0,0x200000,0x8000000,0x8200000,0x2000,0x202000,0x8002000,0x8202000,0x20000,0x220000,0x8020000,0x8220000,0x22000,0x222000,0x8022000,0x8222000);
	    $pc2bytes4    = array (0,0x40000,0x10,0x40010,0,0x40000,0x10,0x40010,0x1000,0x41000,0x1010,0x41010,0x1000,0x41000,0x1010,0x41010);
	    $pc2bytes5    = array (0,0x400,0x20,0x420,0,0x400,0x20,0x420,0x2000000,0x2000400,0x2000020,0x2000420,0x2000000,0x2000400,0x2000020,0x2000420);
	    $pc2bytes6    = array (0,0x10000000,0x80000,0x10080000,0x2,0x10000002,0x80002,0x10080002,0,0x10000000,0x80000,0x10080000,0x2,0x10000002,0x80002,0x10080002);
	    $pc2bytes7    = array (0,0x10000,0x800,0x10800,0x20000000,0x20010000,0x20000800,0x20010800,0x20000,0x30000,0x20800,0x30800,0x20020000,0x20030000,0x20020800,0x20030800);
	    $pc2bytes8    = array (0,0x40000,0,0x40000,0x2,0x40002,0x2,0x40002,0x2000000,0x2040000,0x2000000,0x2040000,0x2000002,0x2040002,0x2000002,0x2040002);
	    $pc2bytes9    = array (0,0x10000000,0x8,0x10000008,0,0x10000000,0x8,0x10000008,0x400,0x10000400,0x408,0x10000408,0x400,0x10000400,0x408,0x10000408);
	    $pc2bytes10 = array (0,0x20,0,0x20,0x100000,0x100020,0x100000,0x100020,0x2000,0x2020,0x2000,0x2020,0x102000,0x102020,0x102000,0x102020);
	    $pc2bytes11 = array (0,0x1000000,0x200,0x1000200,0x200000,0x1200000,0x200200,0x1200200,0x4000000,0x5000000,0x4000200,0x5000200,0x4200000,0x5200000,0x4200200,0x5200200);
	    $pc2bytes12 = array (0,0x1000,0x8000000,0x8001000,0x80000,0x81000,0x8080000,0x8081000,0x10,0x1010,0x8000010,0x8001010,0x80010,0x81010,0x8080010,0x8081010);
	    $pc2bytes13 = array (0,0x4,0x100,0x104,0,0x4,0x100,0x104,0x1,0x5,0x101,0x105,0x1,0x5,0x101,0x105);
	    $masks = array (4294967295,2147483647,1073741823,536870911,268435455,134217727,67108863,33554431,16777215,8388607,4194303,2097151,1048575,524287,262143,131071,65535,32767,16383,8191,4095,2047,1023,511,255,127,63,31,15,7,3,1,0);
	
	    //how many iterations (1 for des, 3 for triple des)
	    $iterations = ((strlen($key) >= 24) ? 3 : 1);
	    //stores the return keys
	    $keys = array (); // size = 32 * iterations but you don't specify this in php
	    //now define the left shifts which need to be done
	    $shifts = array (0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0);
	    //other variables
	    $m=0;
	    $n=0;
	
	    for ($j=0; $j<$iterations; $j++) { //either 1 or 3 iterations
	        $left = (ord($key{$m++}) << 24) | (ord($key{$m++}) << 16) | (ord($key{$m++}) << 8) | ord($key{$m++});
	        $right = (ord($key{$m++}) << 24) | (ord($key{$m++}) << 16) | (ord($key{$m++}) << 8) | ord($key{$m++});
	
	        $temp = (($left >> 4 & $masks[4]) ^ $right) & 0x0f0f0f0f; $right ^= $temp; $left ^= ($temp << 4);
	        $temp = (($right >> 16 & $masks[16]) ^ $left) & 0x0000ffff; $left ^= $temp; $right ^= ($temp << -16);
	        $temp = (($left >> 2 & $masks[2]) ^ $right) & 0x33333333; $right ^= $temp; $left ^= ($temp << 2);
	        $temp = (($right >> 16 & $masks[16]) ^ $left) & 0x0000ffff; $left ^= $temp; $right ^= ($temp << -16);
	        $temp = (($left >> 1 & $masks[1]) ^ $right) & 0x55555555; $right ^= $temp; $left ^= ($temp << 1);
	        $temp = (($right >> 8 & $masks[8]) ^ $left) & 0x00ff00ff; $left ^= $temp; $right ^= ($temp << 8);
	        $temp = (($left >> 1 & $masks[1]) ^ $right) & 0x55555555; $right ^= $temp; $left ^= ($temp << 1);
	
	        //the right side needs to be shifted and to get the last four bits of the left side
	        $temp = ($left << 8) | (($right >> 20 & $masks[20]) & 0x000000f0);
	        //left needs to be put upside down
	        $left = ($right << 24) | (($right << 8) & 0xff0000) | (($right >> 8 & $masks[8]) & 0xff00) | (($right >> 24 & $masks[24]) & 0xf0);
	        $right = $temp;
	
	        //now go through and perform these shifts on the left and right keys
	        for ($i=0; $i < count($shifts); $i++) {
	            //shift the keys either one or two bits to the left
	            if ($shifts[$i] > 0) {
	                  $left = (($left << 2) | ($left >> 26 & $masks[26]));
	                  $right = (($right << 2) | ($right >> 26 & $masks[26]));
	            } else {
	                  $left = (($left << 1) | ($left >> 27 & $masks[27]));
	                  $right = (($right << 1) | ($right >> 27 & $masks[27]));
	            }
	            $left = $left & -0xf;
	            $right = $right & -0xf;
	
	            //now apply PC-2, in such a way that E is easier when encrypting or decrypting
	            //this conversion will look like PC-2 except only the last 6 bits of each byte are used
	            //rather than 48 consecutive bits and the order of lines will be according to 
	            //how the S selection functions will be applied: S2, S4, S6, S8, S1, S3, S5, S7
	            $lefttemp = $pc2bytes0[$left >> 28 & $masks[28]] | $pc2bytes1[($left >> 24 & $masks[24]) & 0xf]
	                            | $pc2bytes2[($left >> 20 & $masks[20]) & 0xf] | $pc2bytes3[($left >> 16 & $masks[16]) & 0xf]
	                            | $pc2bytes4[($left >> 12 & $masks[12]) & 0xf] | $pc2bytes5[($left >> 8 & $masks[8]) & 0xf]
	                            | $pc2bytes6[($left >> 4 & $masks[4]) & 0xf];
	            $righttemp = $pc2bytes7[$right >> 28 & $masks[28]] | $pc2bytes8[($right >> 24 & $masks[24]) & 0xf]
	                                | $pc2bytes9[($right >> 20 & $masks[20]) & 0xf] | $pc2bytes10[($right >> 16 & $masks[16]) & 0xf]
	                                | $pc2bytes11[($right >> 12 & $masks[12]) & 0xf] | $pc2bytes12[($right >> 8 & $masks[8]) & 0xf]
	                                | $pc2bytes13[($right >> 4 & $masks[4]) & 0xf];
	            $temp = (($righttemp >> 16 & $masks[16]) ^ $lefttemp) & 0x0000ffff; 
	            $keys[$n++] = $lefttemp ^ $temp; $keys[$n++] = $righttemp ^ ($temp << 16);
	        }
	    } //for each iterations
	    //return the keys we've created
	    return $keys;
	}
	public function stringToHex ($s) {
	    $r = "0x";
	    $hexes = array ("0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f");
	    for ($i=0; $i<strlen($s); $i++) {$r .= ($hexes [(ord($s{$i}) >> 4)] . $hexes [(ord($s{$i}) & 0xf)]);}
	    return $r;
	}
	
}


?>