<?php
class netsEmail extends netsSocket {
	private $sysErrorClassID='1202';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	public $sEmailInfo=array();
	public $sEmailContent=array();
	
	public $sChar_UTF8='UTF-8';
	public $sChar_GB2312='GB2312';
	public $sChar_GBK='GBK';
	
	public function netsEmail($pConfig){
		$this->netsSocket($pConfig);
	}
	public function sendSmtp($pAR){
		$tmpErrorFuncID=$this->sysErrorClassID.'01';
		$tmpTo=$pAR[0];
		$tmpSender=$pAR[1];
		$tmpSubject=$pAR[2];
		$tmpContent=$pAR[3];
		//-- ------ #Encode ------ --
		$tmpContentCharset=$this->sysCharset;
		if(strpos($tmpTo,'@163.com') || strpos($tmpTo,'@126.com') || strpos($tmpTo,'@yeah.net') || strpos($tmpTo,'@sina.com')){
			$tmpContentCharset=$this->sChar_GB2312;
		}
		if(strtoupper($tmpContentCharset)!=strtoupper($this->sysCharset)){
			if(strpos($tmpTo,'@163.com') || strpos($tmpTo,'@126.com') || strpos($tmpTo,'@yeah.net') || strpos($tmpTo,'@sina.com')){
				$tmpSubject=iconv($this->sysCharset,$tmpContentCharset.'//IGNORE',$tmpSubject);
			}
			if(strpos($tmpTo,'@sina.com')){
				$tmpContent=iconv($this->sysCharset,$tmpContentCharset.'//IGNORE',$tmpContent);
			}
		}else {
		}
		//-- ------ #Connection server ------ --
		$tmpINT=$this->connectionSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='连接服务器失败';
			return $tmpINT;
		}
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='220'){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpErrorFuncID.'001';
		}
		//-- ------ #Login server ------ --
		//#Command:HELO
		$tmpSTR='HELO '.$this->serverUser.$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='250'){
			$this->closeSock();
			$this->sysLastError='您输入的用户名不存在';
			return $tmpErrorFuncID.'002';
		}
		//#Command:AUTH LOGIN
		$tmpSTR='AUTH LOGIN'.$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='334'){
			$this->closeSock();
			$this->sysLastError='密码错误';
			return $tmpErrorFuncID.'003';
		}
		$tmpSTR=base64_encode($this->serverUser).$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='334'){
			$this->closeSock();
			$this->sysLastError='您输入的用户名不存在';
			return $tmpErrorFuncID.'004';
		}
		$tmpSTR=base64_encode($this->serverPxd).$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='235'){
			$this->closeSock();
			$this->sysLastError='用户错误';
			return $tmpErrorFuncID.'005';
		}
		//#Command:MAIL FROM
		$tmpSTR='MAIL FROM:<'.$tmpSender.'>'.$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='250'){
			$this->closeSock();
			$this->sysLastError='发送邮件错误';
			return $tmpErrorFuncID.'006';
		}
		//#Command:RCPT TO
		$tmpSTR='RCPT TO:<'.$tmpTo.'>'.$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='250'){
			$this->closeSock();
			$this->sysLastError='发送邮件错误';
			return $tmpErrorFuncID.'007';
		}
		//#Command:DATA
		$tmpSTR='DATA'.$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='354'){
			$this->closeSock();
			$this->sysLastError='上传数据错误';
			return $tmpErrorFuncID.'008';
		}
		//#Mail body
		$tmpSTR="MIME-Version:1.0".$this->sysSPLIT4;
		$tmpSTR.="Content-Type:text/html".$this->sysSPLIT4;
		$tmpSTR.="To: ".$tmpTo.$this->sysSPLIT4;
		$tmpSTR.="From: ".$tmpSender.$this->sysSPLIT4;
		$tmpSTR.="Subject: ".$tmpSubject.$this->sysSPLIT4;
		$tmpSTR.="Date: ".date("r").$this->sysSPLIT4;
		$tmpSTR.="X-Mailer: 72e.net (PHP/".phpversion().")".$this->sysSPLIT4;
		list($msec, $sec)= explode(" ", microtime());
		$tmpSTR.="Message-ID: <".date("YmdHis", $sec).".".($msec*1000000).".".$tmpSender.">".$this->sysSPLIT4.$this->sysSPLIT4; 
		$tmpSTR.=$tmpContent.$this->sysSPLIT4.'.'.$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='邮件发送失败';
			return $tmpINT;
		}
		//#Command:QUIT
		$tmpSTR='QUIT'.$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		
		return 0;
	}
	public function getmailPop($pAR){
		$tmpErrorFuncID=$this->sysErrorClassID.'01';
		$tmpChar_UTF8='UTF-8';
		$tmpChar_GB2312='GB2312';
		$tmpChar_GBK='GBK';
		//-- ------ #Connection server ------ --
		$tmpINT=$this->connectionSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='连接服务器失败';
			return $tmpINT;
		}
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='连接服务器应错误';
			return $tmpErrorFuncID.'001';
		}
		//-- ------ #Login server ------ --
		//#Command:USER
		$tmpSTR="USER {Nets.0}".$this->sysSPLIT4;
		$tmpSTR=str_replace('{Nets.0}',$this->serverUser,$tmpSTR);
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='您输入的用户名不存在';
			return $tmpErrorFuncID.'006';
		}
		//#Command:PASS
		$tmpSTR="PASS {Nets.0}".$this->sysSPLIT4;
		$tmpSTR=str_replace('{Nets.0}',strtolower($this->serverPxd),$tmpSTR);
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='密码错误';
			return $tmpErrorFuncID.'006';
		}
		//#Command:LIST
		$tmpSTR="LIST".$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSockContent();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='取得邮件大小与数目失败';
			return $tmpErrorFuncID.'006';
		}
		$tmpAR0=explode($this->sysSPLIT4,$this->message);
		$this->sEmailInfo=array();
		foreach ($tmpAR0 as $Cell0){
			$tmpAR1=explode(' ',$Cell0);
			if(count($tmpAR1)==2){
				$this->sEmailInfo[]=$tmpAR1;
			}
		}
		//#Command:RETR
		foreach ($this->sEmailInfo as $Cell0){
			$tmpSTR="RETR {Nets.0} \r\n";
			$tmpSTR=str_replace('{Nets.0}',$Cell0[0],$tmpSTR);
			$tmpINT=$this->putSock($tmpSTR);
			$tmpINT=$this->getSockContent();
			if($tmpINT!=0){
				$this->closeSock();
				$this->sysLastError='服务器响应错误';
				return $tmpINT;
			}
			if($this->messageAR0[0]!='+OK'){
				$this->closeSock();
				$this->sysLastError='导出邮件错误';
				return $tmpErrorFuncID.'006';
			}
			$tmpAR0=array();
			$tmpAR1=array();

			$tmpTo='';
			$tmpFrom='';
			$tmpSubject='';
			$tmpDate='';
			$tmpBoundary='';
			$tmpContent='';
			//-- #To --
			$tmpAR0=explode($this->sysSPLIT4.'To:',$this->message);
			if(count($tmpAR0)>1){
				$tmpAR1=explode($this->sysSPLIT4,$tmpAR0[1]);
				$tmpTo=$tmpAR1[0];
				$tmpTo=str_replace(' ','',$tmpTo);
				$tmpTo=str_replace('<','',$tmpTo);
				$tmpTo=str_replace('>','',$tmpTo);
				$tmpTo=preg_replace("/\=(.*)\=/","",$tmpTo);
				$tmpTo=str_replace('"','',$tmpTo);
			}
			//-- #From --
			$tmpAR0=explode($this->sysSPLIT4.'From:',$this->message);
			if(count($tmpAR0)>1){
				$tmpAR1=explode($this->sysSPLIT4,$tmpAR0[1]);
				$tmpFrom=$tmpAR1[0];
				$tmpFrom=str_replace(' ','',$tmpFrom);
				$tmpFrom=str_replace('<','',$tmpFrom);
				$tmpFrom=str_replace('>','',$tmpFrom);
				$tmpFrom=preg_replace("/\=(.*)\=/","",$tmpFrom);
				$tmpFrom=str_replace('"','',$tmpFrom);
			}
			//-- #Subject --
			$tmpAR0=explode($this->sysSPLIT4.'Subject:',$this->message);
			if(count($tmpAR0)>1){
				$tmpAR1=explode($this->sysSPLIT4,$tmpAR0[1]);
				$tmpAR0=explode('?',$tmpAR1[0]);
				if(count($tmpAR0)>3){
					if($tmpAR0[2]=='B'){
						$tmpSubject=base64_decode($tmpAR0[3]);
					}else if($tmpAR0[2]=='Q'){
						$tmpSubject=quoted_printable_decode($tmpAR0[3]);
					}else{
						$tmpSubject=$tmpAR0[3];
					}
					if(strtoupper($tmpAR0[1])==$tmpChar_UTF8 && strtoupper($this->sysCharset)==$tmpChar_GB2312){
						$tmpSubject=iconv($tmpChar_UTF8,$tmpChar_GB2312.'//IGNORE',$tmpSubject);
					}else if(strtoupper($tmpAR0[1])==$tmpChar_GB2312 && strtoupper($this->sysCharset)==$tmpChar_UTF8){
						$tmpSubject=iconv($tmpChar_GB2312,$tmpChar_UTF8.'//IGNORE',$tmpSubject);

					}
				}
			}
			//-- #Date --
			$tmpAR0=explode($this->sysSPLIT4.'Date:',$this->message);
			if(count($tmpAR0)>1){
				$tmpAR1=explode($this->sysSPLIT4,$tmpAR0[1]);
				$tmpDate=$tmpAR1[0];
			}
			//-- #Boundary --
			$tmpAR0=explode($this->sysSPLIT4.'	boundary="',$this->message);
			if(count($tmpAR0)>1){
				$tmpAR1=explode('"'.$this->sysSPLIT4,$tmpAR0[1]);
				$tmpBoundary=$tmpAR1[0];
			}
			//-- #Content --
			$tmpParameter=2;
			$tmpAR0=array();
			$tmpAR1=array();
			if($tmpBoundary==''){
				$tmpAR0=explode('X-Priority:',$this->message);
				$tmpParameter=8;
			}else{
				$tmpAR0=explode($tmpBoundary.$this->sysSPLIT4,$this->message);
				$tmpParameter=2;
			}
			if(count($tmpAR0)==3){
				$tmpAR1=explode($this->sysSPLIT4,$tmpAR0[2]);
			}else if(count($tmpAR0)==2){
				$tmpAR1=explode($this->sysSPLIT4,$tmpAR0[1]);
			}

			if(count($tmpAR1)>$tmpParameter){
				$tmpSTR='';
				$Coun0=0;
				foreach ($tmpAR1 as $Cell1){
					if($Coun0>$tmpParameter){
						$tmpSTR.=$Cell1;
					}
					$Coun0++;
				}
				$tmpSTR=str_replace($this->sysSPLIT4,'',$tmpSTR);
				$tmpSTR=str_replace($tmpBoundary,'',$tmpSTR);
				$tmpContent=str_replace('--','',$tmpSTR);
				//Decode
				$tmpContentCodeType='';
				$Coun0=0;
				while(count($tmpAR1)>$Coun0 && $Coun0<=$tmpParameter){
					$tmpSTR=strtolower($tmpAR1[$Coun0]);
					$tmpSTR=str_replace('"','',$tmpSTR);
					if(strpos($tmpSTR,'base64')){
						$tmpContentCodeType='base64';
					}else if(strpos($tmpSTR,'quoted-printable')){
						$tmpContentCodeType='quoted_printable';
					}
					$Coun0++;
				}
				if($tmpContentCodeType=='base64'){
					$tmpContent=base64_decode($tmpContent);
				}else if($tmpContentCodeType=='quoted_printable'){
					$tmpContent=quoted_printable_decode($tmpContent);
				}
				//Charset
				$tmpContentCharset='';
				$Coun0=0;
				while(count($tmpAR1)>$Coun0 && $Coun0<=$tmpParameter){
					$tmpSTR=strtolower($tmpAR1[$Coun0]);
					$tmpSTR=str_replace('"','',$tmpSTR);
					if(strpos($tmpSTR,'charset=utf-8')){
						$tmpContentCharset=$tmpChar_UTF8;
					}else if(strpos($tmpSTR,'charset=gb2312')){
						$tmpContentCharset=$tmpChar_GB2312;
					}
					$Coun0++;
				}
				if(strtoupper($tmpContentCharset)==$tmpChar_UTF8 && strtoupper($this->sysCharset)==$tmpChar_GB2312){
					$tmpContent=iconv($tmpChar_UTF8,$tmpChar_GB2312.'//IGNORE',$tmpContent);
				}else if(strtoupper($tmpContentCharset)==$tmpChar_GB2312 && strtoupper($this->sysCharset)==$tmpChar_UTF8){
					$tmpContent=iconv($tmpChar_GB2312,$tmpChar_UTF8.'//IGNORE',$tmpContent);

				}
			}
			
			$tmpAR0=array($tmpTo,$tmpFrom,$tmpSubject,$tmpDate,$tmpContent,);
			$this->sEmailContent[]=$tmpAR0;
		}
		//#Command:QUIT
		$tmpSTR="QUIT".$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='服务器登出失败';
			return $tmpErrorFuncID.'006';
		}
		return 0;
	}
	public function getmailInfoPop($pAR){
		$tmpErrorFuncID=$this->sysErrorClassID.'01';
		//-- ------ #Connection server ------ --
		$tmpINT=$this->connectionSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='连接服务器失败';
			return $tmpINT;
		}
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='连接服务器应错误';
			return $tmpErrorFuncID.'001';
		}
		//-- ------ #Login server ------ --
		//#Command:USER
		$tmpSTR="USER {Nets.0}".$this->sysSPLIT4;
		$tmpSTR=str_replace('{Nets.0}',$this->serverUser,$tmpSTR);
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='您输入的用户名不存在';
			return $tmpErrorFuncID.'006';
		}
		//#Command:PASS
		$tmpSTR="PASS {Nets.0}".$this->sysSPLIT4;
		$tmpSTR=str_replace('{Nets.0}',strtolower($this->serverPxd),$tmpSTR);
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='密码错误';
			return $tmpErrorFuncID.'006';
		}
		//#Command:LIST
		$tmpSTR="LIST".$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSockContent();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='取得邮件大小与数目失败';
			return $tmpErrorFuncID.'006';
		}
		$tmpAR0=explode($this->sysSPLIT4,$this->message);
		$this->sEmailInfo=array();
		foreach ($tmpAR0 as $Cell0){
			$tmpAR1=explode(' ',$Cell0);
			$this->sEmailInfo[0]=$tmpAR1;
		}
		//#Command:QUIT
		$tmpSTR="QUIT".$this->sysSPLIT4;
		$tmpINT=$this->putSock($tmpSTR);
		$tmpINT=$this->getSock();
		if($tmpINT!=0){
			$this->closeSock();
			$this->sysLastError='服务器响应错误';
			return $tmpINT;
		}
		if($this->messageAR0[0]!='+OK'){
			$this->closeSock();
			$this->sysLastError='服务器登出失败';
			return $tmpErrorFuncID.'006';
		}
		return 0;
	}
	public function getcontentPop($pAR){}
}
?>