<?php
class netsImage extends netsError {
	private $sysErrorClassID='1205';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	public $sysImgConfigTemplate=array(
		//-- #普通设置节 --
		//-- #是否重命名 --
		'Rename'=>0,
		//-- #上传图片质量 --
		'Quality'=>10,
		//-- #根路径 --
		'BasePath'=>'../../../',
		//-- #文件保存地址 --
		'SavePath'=>'../../../Uploadfiles/m_tmp/',
		//-- #已上传的文件的地址 --
		'ResultFile'=>'',
		//-- #缩略图节 --
		//-- #是否开启缩略图 --
		'Thumb'=>0,
		//-- #缩略图大小 --
		'ThumbSize'=>'100,100',
		//-- #缩略图保存地址 --
		'ThumbPath'=>'Thumb/',
		//-- #水印节 --
		//-- #是否开启水印 --
		'Water'=>0,
		//-- #水印透明度 --
		'WaterDiaphaneity'=>10,
		//-- #加水印的条件，即图片必须大于本尺寸 --
		'WaterCondition'=>'100,100',
		//-- #水印位置 --
		'WaterPosition'=>0,
		//-- #水印图片的地址 --
		'WaterPath'=>'',
		//-- #上传的图片数据 --
		'File'=>array('name'=>'','type'=>'','tmp_name'=>'','error'=>'','size'=>''));
	
	protected $sysRootDir='../../../Uploadfiles/m_nets/';
	protected $sysNowDir='../../../Uploadfiles/m_nets/';
	
	public function netsImage(){
		$this->netsError();
	}
	public function MakeRandomNum($pSessionName){
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		//[]播下一个生成随机数字的种子，以方便下面随机数生成的使用
		srand((double)microtime()*1000000);

		//将随机数存入session中
		session_start();
		$_SESSION[$pSessionName]='';
		$im = imagecreate(62,20);

		$black = ImageColorAllocate($im, 0,0,0);
		$white = ImageColorAllocate($im, 255,255,255);
		$gray = ImageColorAllocate($im, 200,200,200);

		imagefill($im,0,0,$gray);

		while(($authnum=rand()%100000)<10000);
		//将四位整数验证码绘入图片
		$_SESSION[$pSessionName]=$authnum;
		imagestring($im, 5, 10, 3, $authnum, $black);
		// 用 col 颜色将字符串 s 画到 image 所代表的图像的 x，y 座标处（图像的左上角为 0, 0）。
		//如果 font 是 1，2，3，4 或 5，则使用内置字体

		//加入干扰象素
		for($i=0;$i<200;$i++)
		{
			$randcolor = ImageColorallocate($im,rand(0,255),rand(0,255),rand(0,255));
			imagesetpixel($im, rand()%70 , rand()%30 , $randcolor);
		}
		ImagePNG($im);
		ImageDestroy($im);
	}
	public function CreateFile(&$pAR){
		//-- ------ #Check ------ --
		$tmpINT=$this->CheckAll($pAR);
		if($tmpINT!=0){
			return $tmpINT;
		}
		//-- ------ #Copyto ------ --
		//Rename
		$tmpSavePath=$pAR['SavePath'];
		$tmpRealFileName=basename($pAR['File']['name']);
		if($pAR['Rename']==1){
			$tmpRealFileName='pic'.date('YmdHis').rand(0,99999).'.'.$this->getFileExName($pAR['File']['name']);
		}
		//#Encode
		$tmpSTR=$tmpSavePath.$tmpRealFileName;
		if ($this->sysCharset=='UTF-8') {
			$tmpSTR=iconv($this->sysCharset,'GB2312//IGNORE',$tmpSTR);
			//Reset filename
			if ($tmpSTR!=$tmpSavePath.$tmpRealFileName) {
				$tmpRealFileName='pic'.date('YmdHis').rand(0,99999).'.'.$this->getFileExName($pAR['File']['name']);
				$tmpSTR=$tmpSavePath.$tmpRealFileName;
			}
		}
		//Save
		if (!move_uploaded_file($pAR['File']['tmp_name'],$tmpSTR)){
			$tmpINT=$this->sysErrorFuncID.'002'.'文件上传失败，请与管理员联系.';
			return $tmpINT;
		}
		$pAR['ResultFile']=$tmpSTR;
		//Virus
		$tmpINT=$this->CheckVirus($pAR['ResultFile']);
		if($tmpINT!=0){
			return $tmpINT;
		}
		//Thumb
		$tmpINT=$this->CreateThumb($pAR,$tmpRealFileName);
		if($tmpINT!=0){
			return $tmpINT;
		}
		//Water
		$tmpINT=$this->CreateWater($pAR,$tmpRealFileName);
		if($tmpINT!=0){
			return $tmpINT;
		}
		//Rewrite IMG path
		$pAR['ResultFile']=$tmpSavePath.$tmpRealFileName;
		$pAR['ResultFile']=str_replace($pAR['BasePath'],'../../../Uploadfiles/',$pAR['ResultFile']);
		return 0;
	}
	public function CreateThumb($pAR,$pFilename){
		$tmpExName=$this->getFileExname($pAR['File']['name']);
		//Check in
		if(($tmpExName!='jpg' && $tmpExName!='bmp' && $tmpExName!='gif' && $tmpExName!='png') ||
			$pAR['Thumb']==0){
			return 0;
		}
		//Thumb
		$tmpThumbPath=$pAR['SavePath'].$pAR['ThumbPath'];
		if(!is_dir($tmpThumbPath)){
			$tmpINT=$this->sysErrorFuncID.'002'.'文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但缩略图保存路径错误 - '.$tmpThumbPath;
			return $tmpINT;
		}
		
		$tmpImage=$this->CreateImg($pAR['ResultFile']);
		$imgWidth=imagesx($tmpImage);
		$imgHeight=imagesy($tmpImage);
		$imgX=$imgWidth;
		$imgY=$imgHeight;
		$tmpRare=$imgWidth/$imgHeight;
		$imgWidth=$pAR['ThumbSize'];
		$imgHeight=round($imgWidth/$tmpRare,0);
		if($tmpExName!='gif'){
			$tmpImageDis=imagecreatetruecolor($imgWidth,$imgHeight);
		}else {
			$tmpImageDis=imagecreate($imgWidth,$imgHeight);
		}
		imagecopyresampled($tmpImageDis,$tmpImage,0,0,0,0,$imgWidth,$imgHeight,$imgX,$imgY);
		$tmpBool=$this->MakeImg($tmpImageDis,$tmpThumbPath.$pFilename);
		if(!$tmpBool){
			$tmpINT=$this->sysErrorFuncID.'002'.'文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但生成略缩图错误，请与管理员联系';
			return $tmpINT;
		}
		$this->DestoryImg($tmpImageDis);
	}
	public function CreateWater($pAR,$pFilename){
		$tmpExName=$this->getFileExname($pAR['File']['name']);
		//Check in
		if(($tmpExName!='jpg' && $tmpExName!='bmp' && $tmpExName!='gif' && $tmpExName!='png') ||
			$pAR['Water']==0){
			return 0;
		}
		//Water
		$tmpWaterPath=$pAR['WaterPath'];
		if(!is_file($tmpWaterPath)){
			$tmpINT=$this->sysErrorFuncID.'002'.':文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但水印图片路径错误 - '.$tmpWaterPath;
			return $tmpINT;
		}
		
		$tmpImageWater=$this->CreateImg($tmpWaterPath);
		$imgWidthWater=imagesx($tmpImageWater);
		$imgHeightWater=imagesy($tmpImageWater);
		if(!$tmpImageWater){
			$tmpINT=$this->sysErrorFuncID.'002'.':文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但创建水印图片对像错误，请与管理员联系.';
			return $tmpINT;
		}
		$tmpImage=$this->CreateImg($pAR['ResultFile']);
		if(!$tmpImage){
			$tmpINT=$this->sysErrorFuncID.'002'.':文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但创建图片对像错误，请与管理员联系.';
			return $tmpINT;
		}
		$imgWidth=imagesx($tmpImage);
		$imgHeight=imagesy($tmpImage);
		
		$tmpAR0=explode($this->sysSPLIT1,$pAR['WaterCondition']);
		if(count($tmpAR0)==2){
			if(is_numeric($tmpAR0[0]) && is_numeric($tmpAR0[1]) && $tmpAR0[0]<=$imgWidthWater && $tmpAR0[1]<=$imgHeightWater){
				$tmpINT=$this->sysErrorFuncID.'002'.':文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但不能附加水印[水印太大或者可附加尺寸太小]，请与管理员联系 - '.$tmpWaterPath;
				return $tmpINT;
			}
		}else {
			$tmpINT=$this->sysErrorFuncID.'002'.':文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但不能附加水印，请与管理员联系 - '.$tmpWaterPath;
			return $tmpINT;
		}
			
		$tmpX[0]=0;
		$tmpY[0]=0;
		$tmpX[1]=$imgWidth/3;
		$tmpY[1]=0;
		$tmpX[2]=$imgWidth*2/3;
		$tmpY[2]=0;
		$tmpX[3]=0;
		$tmpY[3]=$imgHeight/3;
		$tmpX[4]=$imgWidth/3;
		$tmpY[4]=$imgHeight/3;
		$tmpX[5]=$imgWidth*2/3;
		$tmpY[5]=$imgHeight/3;
		$tmpX[6]=0;
		$tmpY[6]=$imgHeight*2/3;
		$tmpX[7]=$imgWidth/3;
		$tmpY[7]=$imgHeight*2/3;
		$tmpX[8]=$imgWidth*2/3;
		$tmpY[8]=$imgHeight*2/3;
		$tmpX[9]=0;
		$tmpY[9]=0;

		$posiX=($imgWidth/3-$imgWidthWater)/2+$tmpX[$pAR['WaterPosition']];
		$posiY=($imgHeight/3-$imgHeightWater)/2+$tmpY[$pAR['WaterPosition']];
		imagealphablending($tmpImage,true);
		
		if($pAR['WaterPosition']==9){
			$tmpAR0=explode('/',$pAR['WaterPath']);
			$tmpSTR='';
			$Coun0=0;
			foreach ($tmpAR0 as $Cell){
				if(count($tmpAR0)-1>$Coun0){
					$tmpSTR.=$tmpAR0[$Coun0].'/';
				}
				$Coun0++;
			}
			$tmpSTR.='slant'.$tmpAR0[count($tmpAR0)-1];
			if(is_file($tmpSTR)){
				$tmpImageWater=$this->CreateImg($tmpSTR);
			}
			
			$SizeX=0;
			while(imagesx($tmpImage)>$SizeX){
				$SizeY=0;
				while (imagesy($tmpImage)>$SizeY) {
					$tmpBool=imagecopymerge ($tmpImage,$tmpImageWater,$SizeX,$SizeY,0,0,imagesx($tmpImageWater),imagesx($tmpImageWater),10);
					$SizeY+=imagesy($tmpImageWater);
				}
				$SizeX+=imagesx($tmpImageWater);
			}
			if(!$tmpBool){
				$tmpINT=$this->sysErrorFuncID.'002'.':文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但附加水印失败，请与管理员联系';
				return $tmpINT;
			}
			
			imagejpeg($tmpImage);
		}else {
			$tmpBool=imagecopymerge ($tmpImage,$tmpImageWater,$posiX,$posiY,0,0,$imgWidthWater,$imgHeightWater,$pAR['WaterDiaphaneity']);
			if(!$tmpBool){
				$tmpINT=$this->sysErrorFuncID.'002'.':文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但附加水印失败，请与管理员联系';
				return $tmpINT;
			}
		}
		unlink($pAR['ResultFile']);
		$tmpBool=$this->MakeImg($tmpImage,$pAR['ResultFile']);
		if(!$tmpBool){
			$tmpINT=$this->sysErrorFuncID.'002'.':文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传成功，但附加水印失败，请与管理员联系';
			return $tmpINT;
		}
		
		$this->DestoryImg($tmpImage);
		$this->DestoryImg($tmpImageWater);
	}
	public function CheckAll(&$pAR){
		$this->sysErrorFuncID=$this->sysErrorClassID.'01';
		//File name is null
		if(strlen(trim($pAR['File']['name']))<1){
			$tmpINT=$this->sysErrorFuncID.'001'.':文件上传错误，文件名为空';
			return $tmpINT;
		}
		//File name format
		$tmpAR0=array('#',',');
		if(in_array($pAR['File']['name'],$tmpAR0)){
			$tmpINT=$this->sysErrorFuncID.'001'.'文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传失败：文件名中不允许有以下字符:'.implode($this->sysSPLIT1,$tmpAR0);
			return $tmpINT;
		}
		//File extend name
		$tmpAR0=explode($this->sysSPLIT1,$this->sysFileConfig['UploadFileType']);
		$Coun0=0;
		while (count($tmpAR0)>$Coun0) {
			$tmpAR0[$Coun0]=strtoupper($tmpAR0[$Coun0]);
			$Coun0++;
		}
		$tmpSTR=strtoupper($this->getFileExName($pAR['File']['name']));
		if(!in_array($tmpSTR,$tmpAR0)){
			$tmpINT=$this->sysErrorFuncID.'002'.'文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传失败：不允许上传'.$tmpSTR.'类型的文件.可上传文件类型有'.$this->sysFileConfig['UploadFileType'];
			return $tmpINT;
		}
		//File size
		$tmpFileSizeLimit=$this->sysFileConfig['UploadFileSize'];
		$tmpFileSize=round($pAR['File']['size']/1024,2);
		if($tmpFileSize>$tmpFileSizeLimit){
			$tmpINT=$this->sysErrorFuncID.'002'.'文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传失败：文件大小不能超过'.$tmpFileSizeLimit.'KB. - 文件大小'.$tmpFileSize.'KB';
			return $tmpINT;
		}
		
		return 0;
	}
	protected function CheckVirus($pPATH){
		$tmpINT=0;
		$tmpSTR=$this->readFile($pPATH);
		if(strpos('<%',$tmpSTR)!=false && strpos('<?',$tmpSTR)!=false &&
			strpos('<script',$tmpSTR)!=false){
			$tmpINT=1;
		}
		
		if($tmpINT!=0){
			$tmpINT=$this->sysErrorFuncID.'002'.'文件<span class="FRed2">['.$pAR['File']['name'].']</span>上传失败：您所上传的文件可能包含恶意代码，请杀毒后再试。';
			return $tmpINT;
		}
		return 0;
	}
	protected function CreateImg($pFilename){
		$tmpImage='';
		$tmpExName=$this->getFileExname($pFilename);
		
		if(strtoupper($tmpExName)=='GD'){
			$tmpImage=imagecreatefromgd($pFilename);
		}else if(strtoupper($tmpExName)=='GD2'){
			$tmpImage=imagecreatefromgd2($pFilename);
		}else if(strtoupper($tmpExName)=='GIF'){
			$tmpImage=imagecreatefromgif($pFilename);
		}else if(strtoupper($tmpExName)=='JPEG' || strtoupper($tmpExName)=='JPG'){
			$tmpImage=imagecreatefromjpeg($pFilename);
		}else if(strtoupper($tmpExName)=='PNG'){
			$tmpImage=imagecreatefrompng($pFilename);
		}else if(strtoupper($tmpExName)=='WBMP'){
			$tmpImage=imagecreatefromwbmp($pFilename);
		}else if(strtoupper($tmpExName)=='XBM'){
			$tmpImage=imagecreatefromxbm($pFilename);
		}else if(strtoupper($tmpExName)=='XPM'){
			$tmpImage=imagecreatefromxpm($pFilename);
		}
		return $tmpImage;
	}
	protected function MakeImg($pImage,$pFilename){
		$tmpBool=false;
		$tmpExName=$this->getFileExname($pFilename);
		
		if(strtoupper($tmpExName)=='GD'){
			$tmpBool=imagegd($pImage,$pFilename);
		}else if(strtoupper($tmpExName)=='GD2'){
			$tmpBool=imagegd2($pImage,$pFilename);
		}else if(strtoupper($tmpExName)=='GIF'){
			$tmpBool=imagegif($pImage,$pFilename);
		}else if(strtoupper($tmpExName)=='JPEG' || strtoupper($tmpExName)=='JPG'){
			$tmpBool=imagejpeg($pImage,$pFilename,100);//$this->sysFileConfig['ThumbWaterJpgQuality']);
		}else if(strtoupper($tmpExName)=='PNG'){
			$tmpBool=imagepng($pImage,$pFilename);
		}else if(strtoupper($tmpExName)=='WBMP'){
			$tmpBool=imagewbmp($pImage,$pFilename);
		}else if(strtoupper($tmpExName)=='XBM'){
			$tmpBool=imagexbm($pImage,$pFilename);
		}else if(strtoupper($tmpExName)=='XPM'){
			$tmpBool=imagexpm($pImage,$pFilename);
		}
		return $tmpBool;
	}
	protected function DestoryImg($pImage){
		imagedestroy($pImage);
	}
}
?>