<?php
require('../../../Interface/Common/Component/ComInitialHead.php');
require($netsFileConfig['sysCoreRoot'].'Inc/netsFunc/Func/netsXml.php');

class PaDefault extends CustomPage {
	public $ssetParid=1;
	
	public function PaDefault(){
		$this->CustomPage();
	}
	public function OnPInitial(){
		$this->sTable=array(
			array('sttTableName'=>$this->sysTableHead.'netsuserinfo','sttColumnHead'=>'uit'),
			array('sttTableName'=>$this->sysTableHead.'netsuserinfocont','sttColumnHead'=>'uict'),);
		
		$this->sUserDescriptions[0]=$this->sysDbDescriptions[$this->sysTableHead.'netsuserinfo'];
		$this->sUserDescriptions[1]=$this->sysDbDescriptions[$this->sysTableHead.'netsuserinfocont'];
		$this->sUserDescriptions[2]=$this->sysDbDescriptions[$this->sysTableHead.'netsuserunit'];
		$this->sUserDescriptions[3]=$this->sysDbDescriptions[$this->sysTableHead.'netsuserunitcont'];
		$this->sUserDescriptions[4]=$this->sysDbDescriptions[$this->sysTableHead.'netsusertype'];
		$this->sUserDescriptions[5]=$this->sysDbDescriptions[$this->sysTableHead.'netsusertypecont'];
		$this->sUserDescriptions[6]=$this->sysDbDescriptions[$this->sysTableHead.'netsuserdepartment'];
		$this->sUserDescriptions[7]=$this->sysDbDescriptions[$this->sysTableHead.'netsuserdepartmentcont'];
		$this->sUserDescriptions[8]=$this->sysDbDescriptions[$this->sysTableHead.'netsusergroup'];
		$this->sUserDescriptions[9]=$this->sysDbDescriptions[$this->sysTableHead.'netsusergrade'];
		$this->sUserDescriptions[4]['Columns']['uttType']['Value']='1,2,3,4,5,';
		
		$this->sUiName='Frame/Oa/contact';
		
	}
	public function OnBInitial(){
		$this->sApp=new netsuserinfo($this->sConnString);
		//-- ------ #ActionType ------ --
		if($this->sActionType!='DLogin' || $this->sActionType!='DCheckUser' || $this->sActionType!='DCheckUser_Test'){
			$tmpINT=$this->checkURL('1,2,3,4,5,');
			if($tmpINT!=0){
				$this->sActionType='Error';
				return 1;
			}
		}
		
		if($this->sActionType=='DLogin'){
			$this->OnLogin();
		}else if($this->sActionType=='DCheckUser'){
			$this->OnCheckUser();
		}else if($this->sActionType=='DCheckUser_Test'){
			$this->OnCheckUser_Test();
			
		}else if($this->sActionType=='DUserinfo'){
			$this->OnUserinfo();
			
		}
		
		
		
	}
	public function OnModify(){
		$tmpDbDescription=array();
		foreach ($this->sTable as $tableCell){
			$tmpDbDescription[]=$this->sDbDescriptions[$tableCell['sttTableName']];
		}
		$tmpAR0=$this->AnalyerRequest('mainID','0',1);
		$this->sMainID=$tmpAR0[0];
		//-- ------ #Is add ------ --
		if($this->sMainID==0){
			$this->OnAdd();
			return 1;
		}
		//-- ------ #Modify ------ --
		$this->sApp->TransStart();
		//#Get one
		$Coun0=0;
		while(count($tmpDbDescription)>$Coun0){
			if($Coun0==0){
				$tmpDbDescription[$Coun0]['Columns'][$this->sTable[$Coun0]['sttColumnHead'].'ID']['Value']=$this->sMainID;
			}else {
				$tmpDbDescription[$Coun0]['Columns'][$this->sTable[$Coun0]['sttColumnHead'].'IndexID']['Value']=$this->sMainID;
			}
			$Coun0++;
		}
		$this->sApp->getOne($tmpDbDescription);
		//#Set value
		$tmpDbDescription0=$tmpDbDescription;
		$Coun0=0;

		foreach ($tmpDbDescription0 as $tableCell){
			foreach ($tableCell['Columns'] as $Column){
				if($Column['stcotName']!=$this->sTable[$Coun0]['sttColumnHead'].'ID' &&
					$Column['stcotName']!=$this->sTable[$Coun0]['sttColumnHead'].'NumCode' &&
					$Column['stcotName']!=$this->sTable[$Coun0]['sttColumnHead'].'IndexID'){
					$tmpAR0=$this->AnalyerRequest($Column['stcotName'].'Txt',$Column['stcoctDefaultValue'],1);
					foreach ($this->sUiDescription_Normal as $tmpColumns){
						if($tmpColumns['stcotName']==$Column['stcotName']){
							$tmpDbDescription[$Coun0]['Columns'][$Column['stcotName']]['Value']=$tmpAR0[0];
						}
					}
				}
			}
			$Coun0++;
		}
		//#Set spical value
		if(isset($tmpDbDescription[0]['Columns'][$this->sTable[0]['sttColumnHead'].'CreateTime'])){
			$tmpDbDescription[0]['Columns'][$this->sTable[0]['sttColumnHead'].'CreateTime']['Value']=date($this->sysTimeFormat);
		}
		foreach ($this->sSpicalValue as $Cell){
			if(isset($tmpDbDescription[$Cell[0]]['Columns'][$Cell[1]]['Value'])){
				$tmpDbDescription[$Cell[0]]['Columns'][$Cell[1]]['Value']=$Cell[2];
			}
		}
		//#Modify
		$tmpINT=$this->sApp->Check($tmpDbDescription,array(),array());
		if($tmpINT!=0){
			$this->makeError('ERROR',$this->sApp->sysLastError);
			$tmpINT=$this->writeFile($this->sErrorPath.$this->sysFileConfig['sysInterfaceError_LastOption'],$this->sMainData);
			return 1;
		}
		
		$tmpINT=$this->sApp->modify($tmpDbDescription);
		if($tmpINT!=0){
			$this->makeError('ERROR',$this->sApp->sysLastError);
			$tmpINT=$this->writeFile($this->sErrorPath.$this->sysFileConfig['sysInterfaceError_LastOption'],$this->sMainData);
			return 1;
		}
		
		foreach ($this->sDb->sysDbCacheClear as $Cell){
			$this->clearCache($Cell);
		}
		foreach ($this->sysPageCacheClear as $Cell){
			$this->clearCache($Cell);
		}
		$this->sApp->TransCommit();
		
		$this->makeError('SUCCESS','修改成功');
		$tmpINT=$this->writeFile($this->sErrorPath.$this->sysFileConfig['sysInterfaceError_LastOption'],$this->sMainData);
		return 0;
	}
	public function OnList(){

		return 0;
	}
	public function OnLogin(){
		$tmpApp=new netsuserinfo($this->sConnString);
		
		$tmpAR0=$this->AnalyerRequest('DLogin',',0,0,',0);
		$tmpURL=$tmpAR0[0].$this->sysSPLIT1.$tmpAR0[1].$this->sysSPLIT1.$tmpAR0[2].$this->sysSPLIT1.$tmpAR0[3];
		$tmpAR1=$this->AnalyerRequest('uitName','',1);
		$tmpName=$tmpAR1[0];
		$tmpAR1=$this->AnalyerRequest('uitPxd','',1);
		$tmpPxd=$tmpAR1[0];
		$tmpAR1=$this->AnalyerRequest('PID','',1);
		$tmpPID=$tmpAR1[0];
		$tmpAR1=$this->AnalyerRequest('PPXD','',1);
		$tmpPPXD=$tmpAR1[0];
		$tmpPOST=$tmpApp->MakeURL_Login($tmpName,$tmpPxd,$tmpPID,$tmpPPXD);
		
		$tmpINT=$tmpApp->ReadUserinfo_Interface_Login($this->sUserDescriptions,$tmpURL,$tmpPOST);
		if($tmpINT!=0){
			//daily setting
			$tmpApp->sDbDescriptions_Other=array(
				array($this->sysDbDescriptions[$this->sysTableHead.'netsuserdaily'],
					$this->sysDbDescriptions[$this->sysTableHead.'netsuserdailycont'],),
				);
			$tmpSTR=$this->sysFileConfig['UserLogTemplate'];
			$tmpSTR=str_replace('{Nets.Time}',date($this->sysTimeFormat),$tmpSTR);
			$tmpSTR=str_replace('{Nets.ActionType}','登陆',$tmpSTR);
			$tmpSTR=str_replace('{Nets.Platform}','用户自助平台',$tmpSTR);
			$tmpApp->sDbDescriptions_Other[0][1]['Columns']['udctIntroduct']['Value']=$tmpSTR;
			$tmpApp->sDbDescriptions_Other[0][0]['Columns']['udtType']['Value']=0;
			$tmpApp->sDbDescriptions_Other[0][1]['Columns']['udctIpAddress']['Value']=$this->getIP();
			
			$tmpINT=$tmpApp->AutoRegister($this->sUserDescriptions);
			if($tmpINT!=0){
				$this->makeError('NoPower_User',$tmpApp->sysLastError);
				return 1;
			}
		}
		$tmpSQL=' SELECT A.uitID,A.uitName,A.uitNumCode,A.uitNickname,
			C.uutNumCode
			FROM {Nets.TableHead}netsuserinfo AS A
			INNER JOIN {Nets.TableHead}netsuserinfocont AS B ON B.uictIndexID=A.uitID
			INNER JOIN {Nets.TableHead}netsuserunit AS C ON C.uutID=A.uitUnitid
			WHERE 1=1 AND A.uitID={Nets.ID} ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.ID}',$this->sUserDescriptions[0]['Columns']['uitID']['Value'],$tmpSTR);
		$tmpData0=$this->sDb->Search($tmpSTR);
		if(count($tmpData0)<=0){
			$this->makeError('NoPower_User','没有权限');
			return 1;
		}
		$tmpData0[0]['APIKEY']=$tmpApp->MakeApikey($this->sUserDescriptions);
		
		$this->makeData($tmpData0,array());
		return 0;
	}
	public function OnCheckUser(){
		$tmpAR0=$this->AnalyerRequest('DCheckUser',',',0);
		
		$tmpSQL=' SELECT A.uitID,A.uitName,A.uitNumCode,A.uitNickname
			FROM {Nets.TableHead}netsuserinfo AS A
			WHERE 1=1 AND A.uitNumCode LIKE \'{Nets.NumCode}\' ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpSTR=str_replace('{Nets.NumCode}',$tmpAR0[0],$tmpSTR);
		$tmpData0=$this->sDb->Search($tmpSTR);
		if(count($tmpData0)<=0){
			$this->makeError('NoPower_User','没有权限');
			return 1;
		}
		
		$this->makeError('SUCCESS','验证成功');
		return 0;
	}
	public function OnCheckUser_Test(){
		//uitName,uitNumCode,time,md5(uitName,uitPxd,uitNumCode,time,ApiKey)
		$tmpAR0=$this->AnalyerRequest('DCheckUser_Test',',,,',0);
		$tmpINT=$this->sApp->Check_Interface($tmpAR0);
		if($tmpINT!=0){
			$this->makeError('NoPower_User',$this->sApp->sysLastError);
			return 1;
		}
		
		
		$this->makeError('SUCCESS','验证成功');
		return 0;
	}
	public function OnUserinfo(){
		$tmpAR0=$this->AnalyerRequest('DUserinfo',0,0);
		
		$tmpSQL=' SELECT A.uitID,A.uitName,A.uitNumCode,A.uitUnitid,A.uitDepartmentid,A.uitPositionid,A.uitTypeid,A.uitGradeid,A.uitGroupid,A.uitState,
			A.uitCreateBy,A.uitCreateTime,A.uitPassTime,A.uitEmail,A.uitMoney,A.uitCode,A.uitExperience,A.uitTag,A.uitNickname,
			A.uitOnlineState,
			B.uictCircles,B.uictCo_Name,B.uictCo_Sex,B.uictCo_Tele,B.uictCo_Mobile,B.uictCo_Fax,B.uictCo_QQ,B.uictCo_Website,
			B.uictCo_NumCode,B.uictCo_ZoneChoose,B.uictCo_ZoneDetail,B.uictCo_Address,B.uictCo_Hometown,B.uictCo_Birthday,
			B.uictCo_Company,B.uictCo_PersPosition,B.uictCo_PersSpical,B.uictInfo_School,B.uictInfo_Company,B.uictInfo_Hobby,
			B.uictInfo_LikeMusic,B.uictInfo_LikeMovie,B.uictInfo_LikeGame,B.uictInfo_LikeCartoon,B.uictInfo_LikeSport,B.uictInfo_LikeBook,
			B.uictPostcode,B.uictPostcodeSource,B.uictCoSignature,B.uictCoIntroduct,B.uictWhAble,B.uictWhName,B.uictWhSmallIntroduct,
			B.uictWhSourceR00,B.uictWhSourceR01,B.uictWhSources,B.uictWhIntroduct,B.uictPayAlipay,B.uictPayChinabank,
			B.uictPayTenpay,B.uictPay99Bill,B.uictPayPayChecked,B.uictMapX,B.uictMapY,B.uictMapTagIntroduct,B.uictCount_Views,
			B.uictCount_Reply,B.uictCode_Main,B.uictCode_Positive,B.uictCode_Negative,B.uictChecked_Mobile,B.uictChecked_Postcode,
			B.uictChecked_PayBank,B.uictChecked_Email,B.uictChannelid,B.uictSourceR00,B.uictSourceR01,B.uictSources,B.uictIntroduct,
			B.uictContent,
			C.uutID,C.uutName,C.uutNumCode
			FROM {Nets.TableHead}netsuserinfo AS A
			INNER JOIN {Nets.TableHead}netsuserinfocont AS B ON B.uictIndexID=A.uitID
			INNER JOIN {Nets.TableHead}netsuserunit AS C ON C.uutID=A.uitUnitid
			WHERE 1=1 AND (1=2 {Nets.IDS}) ';
		$tmpSTR=str_replace('{Nets.TableHead}',$this->sysTableHead,$tmpSQL);
		$tmpAR0=explode($this->sysSPLIT2,$tmpAR0[0]);
		$tmpSTR_0='';
		foreach ($tmpAR0 as $Row0){
			$tmpSTR_0.=' OR A.uitID='.$this->sCode->Int32($Row0,0).' ';
		}
		$tmpSTR=str_replace('{Nets.IDS}',$tmpSTR_0,$tmpSTR);
		$tmpData0=$this->sDb->Search($tmpSTR);
		
		$this->makeData($tmpData0,array());
		return 0;
	}
}
//-- ------ #Instanct ------ --
$tmpDefault=new PaDefault();
$tmpDefault->OnPage();
$tmpDefault->sysMetaTitle=$tmpDefault->sMetaTitle.' - '.$tmpDefault->sysFileConfig['sysTitle'];
//-- ------ #Template ------ --
require($tmpDefault->sysFileConfig['sysCoreRoot_Real'].$tmpDefault->sysInterfaceTemplatePath.'Component/Group_Xml_0.php'); ?>