<?php
require($netsFileConfig['sysCoreRoot'].'Inc/netsFunc/Func/netsSocket.php');
require($netsFileConfig['sysCoreRoot'].'Inc/netsFunc/Func/netsEmail.php');
require($netsFileConfig['sysCoreRoot'].'Inc/m_Nets/User/netsuserunit.php');
require($netsFileConfig['sysCoreRoot_Real'].'Inc/netsFunc/Func/netsMobile.php');


class PaDefault extends CustomPage {
	private $sysErrorClassID='3001';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	public $sError='';
	public $sUserDescriptions=array();
	
	public function PaDefault(){
		$this->CustomPage();
	}
	public function OnBInitial(){
		$this->sMetaTitle='用户手机认证';
		$this->getUser('1,2,3,4,5,');
		$this->sTable=array(
			array('sttTableName'=>$this->sysTableHead.'netsuserinfo','sttColumnHead'=>'uit'),
			array('sttTableName'=>$this->sysTableHead.'netsuserinfocont','sttColumnHead'=>'uict'),);
		$this->sUserDescriptions=array(
			$this->sysDbDescriptions[$this->sysTableHead.'netsuserinfo'],
			$this->sysDbDescriptions[$this->sysTableHead.'netsuserinfocont'],
			);
		//-- ------ # ------ --
		$this->sTemplatePath='User/RegisterMobile_Submit.php';
		$this->sApp=new netsuserinfo($this->sConnString);
		//-- ------ #ActionType ------ --
		if ($this->sActionTypeF=='DChecked') {
			$this->OnChecked();
		}else if ($this->sActionTypeF=='DResend') {
			$this->OnResend();
			
			
		}
		
	}
	public function OnChecked(){
		$tmpSTR='uitMobile';
		$tmpAR0=$this->AnalyerRequest($tmpSTR.'Txt','',1);
		$this->sUserDescriptions[0]['Columns'][$tmpSTR]['Value']=$tmpAR0[0];
		$tmpSTR='uitPxd';
		$tmpAR0=$this->AnalyerRequest($tmpSTR.'Txt','',1);
		$this->sUserDescriptions[0]['Columns'][$tmpSTR]['Value']=$tmpAR0[0];
		
		//-- ------ #CCode ------ --
		$tmpSTR='CCode';
		$tmpAR0=$this->AnalyerRequest($tmpSTR.'Txt','',1);
		$tmpCCode=$tmpAR0[0];
		$tmpSTR=$tmpSTR.'Txt_IFrame';
		if(!array_key_exists($tmpSTR,$_SESSION)){
			$this->sJscript=$this->Message('ERROR','提交失败','验证码错误','');
			return 1;
		}
		if($_SESSION[$tmpSTR]=='' || $_SESSION[$tmpSTR]!=$tmpCCode){
			$this->sJscript=$this->Message('ERROR','提交失败','验证码错误','');
			return 1;
		}
		//-- ------ #Check ------ --
		$tmpINT=$this->sApp->regConfirmMobile_callback($this->sUserDescriptions,$this->sysFileConfig['userUserMobileCheckAble']);
		if($tmpINT!=0){
			$this->sJscript=$this->Message('ERROR','',$this->sApp->sysLastError,'');
			return $tmpINT;
		}
		
		$this->sysLastMessage='用户注册成功，请登陆。';
		$this->sJscript=$this->Message('SUCCESS','注册成功',$this->sysLastMessage,'');
		return 0;
	}
	public function OnResend(){
		$tmpSTR='uitMobile';
		$tmpAR0=$this->AnalyerRequest($tmpSTR.'Txt','',1);
		$this->sUserDescriptions[0]['Columns'][$tmpSTR]['Value']=$tmpAR0[0];
		
		//-- ------ #CCode ------ --
		$tmpSTR='CCode';
		$tmpAR0=$this->AnalyerRequest($tmpSTR.'Txt','',1);
		$tmpCCode=$tmpAR0[0];
		$tmpSTR=$tmpSTR.'Txt_IFrame';
		if(!array_key_exists($tmpSTR,$_SESSION)){
			$this->sJscript=$this->Message('ERROR','提交失败','验证码错误','');
			return 1;
		}
		if($_SESSION[$tmpSTR]=='' || $_SESSION[$tmpSTR]!=$tmpCCode){
			$this->sJscript=$this->Message('ERROR','提交失败','验证码错误','');
			return 1;
		}
		//-- ------ #Send mail ------ --
		//#Send check mail
		$this->sysLastMessage='欢迎注册'.$this->sysFileConfig['bussinessMetaTitle'].'通用帐号，请登陆。';
		$tmpMobile=new netsMobile(array($this->sysFileConfig['MobileUName'],
			$this->sysFileConfig['MobilePxd'],
			$this->sysFileConfig['MobileSendURL'],
			$this->sysFileConfig['MobileReceiveURL'],
			$this->sysFileConfig['MobileCountURL'],));
			
		//#Get userinfo
		$tmpINT=$this->sApp->GetUserinfo($this->sUserDescriptions,'uitMobile');
		if($tmpINT!=0){
			$this->sJscript=$this->Message('ERROR','重新发送注册认证短信错误',$this->sApp->sysLastError,'');
			return 1;
		}
		//#Daily setting
		$this->sApp->sDbDescriptions_Other=array(
			array($this->sysDbDescriptions[$this->sysTableHead.'netsuserdaily'],
				$this->sysDbDescriptions[$this->sysTableHead.'netsuserdailycont'],),
			);
		$this->sApp->sDbDescriptions_Other[0][1]['Columns']['udctIpAddress']['Value']=$this->getIP();
		$tmpINT=$this->sApp->regConfirmMakeMobile($this->sUserDescriptions,$this->sysFileConfig['userUserMobileCheckAble']);
		
		$tmpSTR=$this->sysFileConfig['MobileAccountConfirmTemplate'];
		$tmpSTR=str_replace('{Nets.Title}',$this->sysFileConfig['bussinessMetaTitle'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.Name}',$this->sUserDescriptions[0]['Columns']['uitName']['Value'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.Encryption}',$this->sUserDescriptions[0]['Columns']['uitPxd']['Value'],$tmpSTR);
		$tmpINT=$tmpMobile->sendCSMS($this->sUserDescriptions[0]['Columns']['uitMobile']['Value'],$tmpSTR);
		
		$this->sysLastMessage='用户注册成功，请到您的手机['.$this->sUserDescriptions[0]['Columns']['uitMobile']['Value'].']里查收注册认证短信，以完成您的注册。';
		$this->sJscript=$this->Message('SUCCESS','',$this->sysLastMessage,'');
		return 0;
	}
	public function OnList(){
		//-- ------ ### ------ --
		$this->sError='请在这里输入您的手机号和收到的验证码';
		//-- ------ #Control ------ --
		$this->sUiDescription_Custom0=array();
		$tmpSTR=$this->sUiDescriptionPath.'User/nets/user_registermobile.php';
		if(file_exists($tmpSTR)){
			require($tmpSTR);
			$this->sUiDescription_Custom0=$sysUiDescriptions['user_registermobile'];
		}
		
		
	}
	public function DefUiPanel(&$pColumn,$pFlag){
		parent::DefUiPanel($pColumn,$pFlag);
		if($pColumn['stcotName']=='uitName'){
			$pColumn['Value']=$this->sUserDescriptions[0]['Columns']['uitName']['Value'];
		}else if($pColumn['stcotName']=='uitEmail'){
			$pColumn['Value']=$this->sUserDescriptions[0]['Columns']['uitEmail']['Value'];
		}else if($pColumn['stcotName']=='uitMobile'){
			$pColumn['Value']=$this->sUserDescriptions[0]['Columns']['uitMobile']['Value'];
			
		}
		return $pColumn;
	}
	public function DefUiJscript($pFlag){
?>
function jsDCheck(pPara){
	var tmpControl="";
	var tmpError="";
	var tmpChecker=new netsChecker();
	var tmpActionWithOut=document.getElementById("ActionWithOut");
	var Coun0=0;
	//-- ------ #ActionWithOut ------ --
	if(tmpActionWithOut==undefined){
		return true;
	}
	if(tmpActionWithOut.value=="1"){
		return true;
	}else if(tmpActionWithOut.value=="2"){
		return false;
	}
	//-- ------ #Check ------ --
	//#uitName
	tmpCheckCont=document.getElementById("uitNameTxt");
	tmpCheckCont.value=tmpChecker.Filter(tmpCheckCont.value,0);
	if(!tmpChecker.CheckLen(tmpCheckCont.value,5,32)){
		Coun0++;
		tmpError+=Coun0+".登陆用户名必须大于5位"+sysSPLIT8;
	}
	//#uitEmail
	tmpCheckCont=document.getElementById("uitEmailTxt");
	tmpCheckCont.value=tmpChecker.Filter(tmpCheckCont.value,0);
	if(!tmpChecker.CheckLen(tmpCheckCont.value,5,32)){
		Coun0++;
		tmpError+=Coun0+".电子邮箱地址格式不正确"+sysSPLIT8;
	}
	//#CCode
	tmpCheckCont=document.getElementById("CCodeTxt");
	tmpCheckCont.value=tmpChecker.Filter(tmpCheckCont.value,0);
	if(tmpCheckCont.value.length!=5){
		Coun0++;
		tmpError+=Coun0+".验证码必须为5位"+sysSPLIT8;
	}
	//-- ------ #Result ------ --
	if(tmpError!=""){
		tmpSTR="<span class=\"FStrong\">对不起，您提交的内容存在以下错误:</span>"+sysSPLIT8+tmpError;
		showMessage("系统消息 - <?php echo ($this->sysFileConfig['bussinessMetaTitle']); ?>",tmpSTR,"","0");
		return false;
	}else{
		return true;
	}
}
<?php
	}
}
?>