<?php
require($netsFileConfig['sysCoreRoot'].'Inc/netsFunc/Func/netsSocket.php');
require($netsFileConfig['sysCoreRoot'].'Inc/netsFunc/Func/netsEmail.php');
require($netsFileConfig['sysCoreRoot'].'Inc/m_Nets/User/netsuserunit.php');


class PaDefault extends CustomPage {
	private $sysErrorClassID='3001';
	private $sysErrorFuncID=0;
	private $sysErrorID=0;
	
	public $sError='';
	public $sUserDescriptions=array();
	
	public function PaDefault(){
		$this->CustomPage();
	}
	public function OnBInitial(){
		$this->sMetaTitle='重发注册认证邮件';
		$this->getUser('1,2,3,4,5,');
		$this->sTable=array(
			array('sttTableName'=>$this->sysTableHead.'netsuserinfo','sttColumnHead'=>'uit'),
			array('sttTableName'=>$this->sysTableHead.'netsuserinfocont','sttColumnHead'=>'uict'),);
			
		$this->sUserDescriptions=array();
		foreach ($this->sTable as $tableCell){
			$this->sUserDescriptions[]=$this->sDbDescriptions[$tableCell['sttTableName']];
		}
		$this->sUserDescriptions[0]['Columns']['uitName']['Value']='';
		$this->sUserDescriptions[0]['Columns']['uitEmail']['Value']='';
		//-- ------ # ------ --
		$this->sTemplatePath='User/ResendRegisterEmail_Submit.php';
		$this->sApp=new netsuserinfo($this->sConnString);
	}
	public function OnBEvent(){
		if($this->sActionTypeF=='DResend'){
			$this->OnResend();
		}
	}
	public function OnBLoad(){
		if ($this->sActionType=='DChecked'){
			$this->OnChecked();
			$this->OnList();
		}
	}
	public function OnResend(){
		$tmpSTR='uitEmail';
		$tmpAR0=$this->AnalyerRequest($tmpSTR.'Txt','',1);
		$this->sUserDescriptions[0]['Columns'][$tmpSTR]['Value']=$tmpAR0[0];
		//-- ------ #UserRegAble ------ --
		if($this->sysFileConfig['userUserRegAble']==0){
			$this->sJscript=$this->Message('ERROR','用户重发注册邮件失败','对不起，本系统暂停用户注册，请与管理员联系。','');
			return 1;
		}
		//-- ------ #CCode ------ --
		$tmpSTR='CCode';
		$tmpAR0=$this->AnalyerRequest($tmpSTR.'Txt','',1);
		$tmpCCode=$tmpAR0[0];
		$tmpSTR=$tmpSTR.'Txt_IFrame';
		if(!array_key_exists($tmpSTR,$_SESSION)){
			$this->sJscript=$this->Message('ERROR','提交失败','验证码错误','');
			return 1;
		}
		if($_SESSION[$tmpSTR]=='' || $_SESSION[$tmpSTR]!=$tmpCCode){
			$this->sJscript=$this->Message('ERROR','提交失败','验证码错误','');
			return 1;
		}
		//-- ------ #Submit limit check ------ --
		$tmpINT=$this->submitLimitRead($this->sysPage,-1,-1,-1);
		if($tmpINT!=0){
			$this->sJscript=$this->Message('SUCCESS','','对不起，您尝试得发注册邮件的次数过多，请'.$this->sysFileConfig['SubmitLimitFreeze'].'秒后再尝试登陆。','');
			return 1;
		}
		//-- ------ #Send mail ------ --
		//#Send check mail
		$this->sysLastMessage='欢迎注册'.$this->sysFileConfig['bussinessMetaTitle'].'通用帐号，请登陆。';
		$tmpEmail=new netsEmail(array($this->sysFileConfig['EmailHost'],
			$this->sysFileConfig['EmailHostPost'],
			$this->sysFileConfig['EmailName'],
			$this->sysFileConfig['EmailPxd'],
			$this->sysCharset,));
		//#Get userinfo
		$tmpINT=$this->sApp->GetUserinfo($this->sUserDescriptions,'uitEmail');
		if($tmpINT!=0){
			$this->sJscript=$this->Message('ERROR','重新发送注册认证邮件错误',$this->sApp->sysLastError,'');
			return 1;
		}
		//#Daily setting
		$this->sApp->sDbDescriptions_Other=array(
			array($this->sysDbDescriptions[$this->sysTableHead.'netsuserdaily'],
				$this->sysDbDescriptions[$this->sysTableHead.'netsuserdailycont'],),
			);
		$this->sApp->sDbDescriptions_Other[0][1]['Columns']['udctIpAddress']['Value']=$this->getIP();
		$tmpINT=$this->sApp->regConfirmMakeMail($this->sUserDescriptions,$this->sysFileConfig['userUserMailCheckAble']);
		
		$tmpSTR=$this->sysFileConfig['EmailConfirmTemplate'];
		if($this->sysFileConfig['userUserMailCheckAble']==2){
			$tmpSTR=$this->sysFileConfig['EmailPowerTemplate'];
		}
		$tmpSTR=str_replace('{Nets.Title}',$this->sysFileConfig['bussinessMetaTitle'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.Charset}',$this->sysCharset,$tmpSTR);
		$tmpSTR=str_replace('{Nets.Name}',$this->sUserDescriptions[0]['Columns']['uitName']['Value'],$tmpSTR);
		$tmpSTR=str_replace('{Nets.Page}',$this->sysSiteHome,$tmpSTR);
		$tmpSTR=str_replace('{Nets.Encryption}',$this->sUserDescriptions[0]['Columns']['uitPxd']['Value'],$tmpSTR);
		$tmpAR0=array(
			$this->sUserDescriptions[0]['Columns']['uitEmail']['Value'],
			$this->sysFileConfig['EmailName'],
			$this->sysFileConfig['bussinessMetaTitle'].' - 用户帐号认证邮件',
			$tmpSTR,
			);
		$tmpINT=$tmpEmail->sendSmtp($tmpAR0);
		$this->sysLastMessage='用户注册成功，请到您的电子邮箱['.$this->sUserDescriptions[0]['Columns']['uitEmail']['Value'].']里查收注册认证邮件，以完成您的注册。';
		$this->sJscript=$this->Message('SUCCESS','注册成功',$this->sysLastMessage,'');
		return 0;
	}
	public function OnChecked(){
		$this->sMetaTitle='用户注册认证';
		$tmpAR0=$this->AnalyerRequest('DChecked',',0,0',0);
		$this->sUserDescriptions=array($this->sysDbDescriptions[$this->sysTableHead.'netsuserinfo']);
		//-- ------ #Checked ------ --
		//#Count
		if(count($tmpAR0)!=3){
			$this->sTemplatePath='User/Check_Error.php';
			$this->sError='对不起，认证错误，请重新申请发送注册认证邮件或与客服人员联系。';
			return 1;
		}
		//#Callback
		$this->sUserDescriptions[0]['Columns']['uitID']['Value']=$tmpAR0[1];
		$this->sUserDescriptions[0]['Columns']['uitPxd']['Value']=$tmpAR0[0];
		$tmpINT=$this->sApp->regConfirmEmail_callback($this->sUserDescriptions,$this->sysFileConfig['userUserMailCheckAble']);
		if($tmpINT!=0){
			$this->sTemplatePath='User/Check_Error.php';
			$this->sError=$this->sApp->sysLastError;
			return 1;
		}
		//-- ------ #Search user ------ --
		$tmpINT=$this->sApp->GetUserinfo($this->sUserDescriptions,'uitID');
		if($tmpINT!=0){
			$this->sJscript=$this->Message('ERROR','重新发送注册认证邮件错误','对不起，您提交的用户名或邮箱不正确。','');
			return 1;
		}
		//-- ------ #Search ------ --
		if($this->sysFileConfig['userUserMailCheckAble']==0){
			$tmpEmail=new netsEmail(array($this->sysFileConfig['EmailHost'],
				$this->sysFileConfig['EmailHostPost'],
				$this->sysFileConfig['EmailName'],
				$this->sysFileConfig['EmailPxd'],
				$this->sysCharset,));
			$tmpSTR=$this->sysFileConfig['EmailRegTemplate'];
			$tmpSTR=str_replace('{Nets.Title}',$this->sysFileConfig['bussinessMetaTitle'],$tmpSTR);
			$tmpSTR=str_replace('{Nets.Charset}',$this->sysCharset,$tmpSTR);
			$tmpSTR=str_replace('{Nets.Name}',$this->sUserDescriptions[0]['Columns']['uitName']['Value'],$tmpSTR);
			$tmpSTR=str_replace('{Nets.Page}',$this->sysSiteHome,$tmpSTR);
			$tmpAR0=array(
			$this->sUserDescriptions[0]['Columns']['uitEmail']['Value'],
				$this->sysFileConfig['EmailName'],
				$this->sysFileConfig['bussinessMetaTitle'].' - 欢迎加入',
				$tmpSTR,
				);
			$tmpINT=$tmpEmail->sendSmtp($tmpAR0);
		}
		
		$this->sError='';
		$this->sTemplatePath='User/Check_Succuss.php';
		return 0;
	}
	public function OnList(){
		//-- ------ #Control ------ --
		$this->sUiDescription_Custom0=array();
		$tmpSTR=$this->sUiDescriptionPath.'User/nets/user_resendregisteremail.php';
		if(file_exists($tmpSTR)){
			require($tmpSTR);
			$this->sUiDescription_Custom0=$sysUiDescriptions['user_resendregisteremail'];
		}
		#-- #1 --
		$this->sUiDescription_Custom1=array();
		$tmpSTR=$this->sUiDescriptionPath.'User/nets/checked_sendcheckemail.php';
		if(file_exists($tmpSTR)){
			require($tmpSTR);
			$this->sUiDescription_Custom1=$sysUiDescriptions['checked_sendcheckemail'];
		}
		
	}
	public function DefUiPanel(&$pColumn,$pFlag){
		parent::DefUiPanel($pColumn,$pFlag);
		if($pColumn['stcotName']=='uitName'){
			$pColumn['Value']=$this->sUserDescriptions[0]['Columns']['uitName']['Value'];
		}else if($pColumn['stcotName']=='uitEmail'){
			$pColumn['Value']=$this->sUserDescriptions[0]['Columns']['uitEmail']['Value'];
		}
		return $pColumn;
	}
	public function DefUiJscript($pFlag){
?>
function jsDCheck(pPara){
	var tmpControl="";
	var tmpError="";
	var tmpChecker=new netsChecker();
	var tmpActionWithOut=document.getElementById("ActionWithOut");
	var Coun0=0;
	//-- ------ #ActionWithOut ------ --
	if(tmpActionWithOut==undefined){
		return true;
	}
	if(tmpActionWithOut.value=="1"){
		return true;
	}else if(tmpActionWithOut.value=="2"){
		return false;
	}
	//-- ------ #Check ------ --
	//#uitName
	tmpCheckCont=document.getElementById("uitNameTxt");
	tmpCheckCont.value=tmpChecker.Filter(tmpCheckCont.value,0);
	if(!tmpChecker.CheckLen(tmpCheckCont.value,5,32)){
		Coun0++;
		tmpError+=Coun0+".登陆用户名必须大于5位"+sysSPLIT8;
	}
	//#uitEmail
	tmpCheckCont=document.getElementById("uitEmailTxt");
	tmpCheckCont.value=tmpChecker.Filter(tmpCheckCont.value,0);
	if(!tmpChecker.CheckLen(tmpCheckCont.value,5,32)){
		Coun0++;
		tmpError+=Coun0+".电子邮箱地址格式不正确"+sysSPLIT8;
	}
	//#CCode
	tmpCheckCont=document.getElementById("CCodeTxt");
	tmpCheckCont.value=tmpChecker.Filter(tmpCheckCont.value,0);
	if(tmpCheckCont.value.length!=5){
		Coun0++;
		tmpError+=Coun0+".验证码必须为5位"+sysSPLIT8;
	}
	//-- ------ #Result ------ --
	if(tmpError!=""){
		tmpSTR="<span class=\"FStrong\">对不起，您提交的内容存在以下错误:</span>"+sysSPLIT8+tmpError;
		showMessage("系统消息 - <?php echo ($this->sysFileConfig['bussinessMetaTitle']); ?>",tmpSTR,"","0");
		return false;
	}else{
		return true;
	}
}
<?php
	}
}
?>