<?php
/**
 * @copyright (c) 2011 jooyea.net
 * @file Order_Class.php
 * @brief 订单中相关的
 * @author zhouyong
 * @date 2011-02-24
 * @version 0.6
 */
class Order_Class
{
	/**
	 * @param $order_id string 订单的id
	 * @return array()
	 * @brief 配送方式计算管理模块
	 */
	static function get_order_show($order_id)
	{
		$data = array();
		$data['order_id'] = $order_id;
		//获得对象
		$tb_order = new IModel('order');
 		$order_info = $tb_order->query('id='.$order_id);
 		if(count($order_info)>0)
 		{
 			$data = $order_info[0];
 		}
 		$data['order_id'] = $order_id;
 		//配送方式
 		$tb_delivery = new IModel('delivery');
 		$delivery_info = $tb_delivery->query('id='.$data['distribution']);
 		if(count($delivery_info)>0)
 		{
 			$data['delivery'] = $delivery_info[0]['name'];
 		}
 		//支付方式
 		$tb_payment = new IModel('payment');
 		$payment_info = $tb_payment->query('id='.$data['pay_type']);
 		if(count($payment_info)>0)
 		{
 			$data['payment'] = $payment_info[0]['name'];
 		}
 		//总重量
 		$tb_order_goods = new IModel('order_goods');
 		$order_goods_info = $tb_order_goods->query('order_id='.$order_id);
 		$data['amount'] = 0;
 		if(count($order_goods_info)>0)
 		{
 			$data['goods_weight'] = 0;
 			foreach ($order_goods_info as $value) {
 				$data['goods_weight'] = $data['goods_weight']+$value['goods_weight'];
 				$data['amount'] = $data['amount'] + $value['real_price']*$value['goods_nums'];
 			}
 		}
 		//用户名
 		$query = new IQuery('user as u ');
 		$query->join = ' left join member as m on u.id=m.user_id ';
 		$query->fields = 'u.username,u.email,m.mobile,m.contact_addr,m.true_name ';
 		$query->where = 'u.id='.$data['user_id'];
 		$user_info = $query->find();
 		if(count($user_info)>0)
 		{
 			$data['username'] = $user_info[0]['username'];
 			$data['email'] = $user_info[0]['email'];
 			$data['u_mobile'] = $user_info[0]['mobile'];
 			$data['contact_addr'] = $user_info[0]['contact_addr'];
 			$data['true_name'] = $user_info[0]['true_name'];
 		}
 		//地区
 		$areas_id = $data['province'].','.$data['city'].','.$data['area'];
 		$tb_area = new IModel('areas');
 		$area_info = $tb_area->query('area_id in ('.$areas_id.')');
 		if(count($area_info)>0)
 		{
 			$data['area_addr'] = $area_info[0]['area_name'].$area_info[1]['area_name'].$area_info[2]['area_name'];
 		}
 		return $data;
	}
	/**
	 * @param $user_id int 用户的id
	 * @param $goods_id int 商品的id
	 * @param $products_id int 规格的id
	 * @param $goods_price int 商品的原始价格
	 * @return int $price
	 * @brief 根据会员组计算出每件商品的实际价格
	 */
	static function get_real_price($user_id,$goods_id,$products_id,$goods_price)
	{
		$price =$goods_price;
		//判断在group_price中有相关的值
		$query = new IQuery('group_price as g ');
		$query->join = 'left join member as m on m.group_id=g.group_id ';
		$query->where = 'g.goods_id='.$goods_id.' and m.user_id='.$user_id.' and g.products_id='.$products_id;
		$price_info = $query->find();
		if(count($price_info)>0)
		{
			$price=$price_info[0]['price'];
		}
		else
		{
			$u_query = new IQuery('user_group as u');
			$u_query->join = 'left join member as m on m.group_id=u.id ';
			$u_query->where= 'm.user_id='.$user_id;
			$user_info = $u_query->find();
			if(count($user_info)>0)
			{
				$price = $price*($user_info[0]['discount']/100);
			}
		}
		
		return $price;
	}
	/*
	 * @param $pay_type int 支付类型id
	 * @param $real_amount int 商品的实际价格
	 * @return int $pay_fee
	 * @brief 计算出支付费用
	 * */
	static function get_payment($pay_type,$real_amount)
	{
		$pay_fee = 0;
		$tb_payment = new IModel('payment');
		$payment_info = $tb_payment->query('id='.$pay_type);
		if(count($payment_info)>0)
		{
			if($payment_info[0]['poundage_type']==1)
			{
				$pay_fee = $real_amount*($payment_info[0]['poundage']/100);
			}
			else 
			{
				$pay_fee = $payment_info[0]['poundage'];
			}
		}
		return $pay_fee;
	}
}
?>