<?php
/**
 * @class Brand
 * @brief 品牌类控制器，包括品牌及品牌分类的添加、修改
 */
class Brand extends IController
{
	protected $checkRight  = 'all';
    public $layout='admin';
	private $data = array();

	function init()
	{
		$admin = array();
		$admin['admin_id']        = ISafe::get('admin_id');
		$admin['admin_name']      = ISafe::get('admin_name');
		$admin['admin_right']     = ISafe::get('admin_right');
		$admin['admin_role_name'] = ISafe::get('admin_role_name');
		if(!$admin['admin_id'] || !$admin['admin_right'])
		{
			$this->redirect('/systemadmin/index');
		}
		$this->admin = $admin;
	}

	/**
	 * @brief 构造函数，调用父类构造函数、声明语言包对象
	 */
	function __construct()
	{
		parent::__construct(IWeb::$app,strtolower(__CLASS__));
		$this->lang = new ILanguage();
	}

	/**
	 * @brief 品牌分类添加、修改
	 */
	function category_edit()
	{
		$category_id = (int)IReq::get('cid');
		//编辑品牌分类 读取品牌分类信息
		if($category_id)
		{
			$obj_brand_category = new IModel('brand_category');
			$category_info = $obj_brand_category->query('id='.$category_id);
			if(is_array($category_info) && $info=$category_info[0])
			{
				$this->data['category'] = array(
					'id'		=>	$info['id'],
					'name'		=>	$info['name']
				);
			}
			else
			{
				$this->category_list();
				Util::showMessage("没有找到相关品牌分类！");
				return;
			}
		}
		$this->setRenderData($this->data);
		$this->redirect('category_edit',false);
	}

	/**
	 * @brief 保存品牌分类
	 */
	function category_save()
	{
		$category_id = IFilter::act(IReq::get('category_id'),'int');
		$name = IFilter::act(IReq::get('name'));
		
		$category_info = array();
		$tb_brand_category = new IModel('brand_category');
		$category_info['name'] = $name;
		$tb_brand_category->setData($category_info);
		if($category_id)									//保存修改分类信息
		{
			$where = "id=".$category_id;
			$tb_brand_category->update($where);
		}
		else												//添加新品牌分类
		{
			$tb_cate = new IQuery('brand_category');		//查询数据库，判断该分类是否存在，如存在则不存储
			$tb_cate->fields = 'name';
			$tb_info = $tb_cate->find();
			if(count($tb_info)>0)
			{
				foreach ($tb_info as $value)
				{
					if($category_info['name']==$value['name'])
					{
						$this->redirect('category_edit',false);
						Util::showMessage("添加的品牌分类已存在！");
					}
				}
			}
			$tb_brand_category->add();
		}
		$this->category_list();
	}

	/**
	 * @brief 删除品牌分类
	 */
	function category_del()
	{
		$category_id = (int)IReq::get('cid');
		if($category_id)
		{
			$brand_category = new IModel('brand_category');
			$where = "id=".$category_id;
			if($brand_category->del($where))
			{
				$this->category_list();
			}
			else
			{
				$this->category_list();
				$msg = "没有找到相关分类记录！";
				Util::showMessage($msg);
			}
		}
		else
		{
			$this->category_list();
			$msg = "没有找到相关分类记录！";
			Util::showMessage($msg);
		}
	}

	/**
	 * @brief 品牌分类列表
	 */
	function category_list()
	{
		$this->redirect('category_list');
	}

	/**
	 * @brief 修改品牌
	 */
	function brand_edit()
	{
		$brand_id = (int)IReq::get('bid');
		//编辑品牌 读取品牌信息
		if($brand_id)
		{
			$obj_brand = new IModel('brand');
			$brand_info = $obj_brand->query('id='.$brand_id);
			if(is_array($brand_info) && $info=$brand_info[0])
			{
				$this->data['brand'] = array(
					'id'		=>	$info['id'],
					'name'		=>	$info['name'],
					'logo'		=>	$info['logo'],
					'url'		=>	$info['url'],
					'sort'		=>	$info['sort'],
					'description'=>	$info['description'],
					'category_ids'=>explode(',',$info['category_ids'])
				);
			}
			else
			{
				$this->category_list();
				Util::showMessage("没有找到相关品牌分类！");
				return;
			}
		}
		//获取品牌分类
		$tb_brand_category = new IModel("brand_category");
		$this->data['brand_category'] = $tb_brand_category->query();
		$this->setRenderData($this->data);
		$this->redirect('brand_edit',false);
	}

	/**
	 * @brief 保存品牌
	 */
	function brand_save()
	{
		$brand_id = IFilter::act(IReq::get('brand_id'),'int');
		$name = IFilter::act(IReq::get('name'));
		$sort = IFilter::act(IReq::get('sort'),'int');
		$url = IFilter::act(IReq::get('url'));
		$category = IFilter::act(IReq::get('category'),'int');
		
		$tb_brand = new IModel('brand');
		$brand = array(
			'name'=>$name,
			'sort'=>$sort,
			'url'=>$url
		);
		
		if($category && is_array($category))
		{
			$categorys = implode(',',$category);
			$brand['category_ids'] = $categorys;
		}
		else
		{
			$brand['category_ids'] = '';
		}
		if(isset($_FILES['logo']['name']) && $_FILES['logo']['name']!='')
		{
			$uploadObj = new PhotoUpload();
			$uploadObj->setIterance(false);
			$photoInfo = $uploadObj->run();
			if(!isset($photoInfo['logo']['img']) || !file_exists($photoInfo['logo']['img']))
			{
				$message = 'logo图片上传失败';
			}
			else
			{
				$brand['logo'] = $photoInfo['logo']['img'];
			}
		}
		$tb_brand->setData($brand);
		if($brand_id)										//保存修改分类信息
		{
			$where = "id=".$brand_id;
			$tb_brand->update($where);
		}
		else												//添加新品牌
		{
			$tb_brand->add();
		}
		$this->brand_list();
		
	}

	/**
	 * @brief 删除品牌
	 */
	function brand_del()
	{
		$brand_id = (int)IReq::get('bid');
		if($brand_id)
		{
			$tb_brand = new IModel('brand');
			$where = "id=".$brand_id;
			if($tb_brand->del($where))
			{
				$this->brand_list();
			}
			else
			{
				$this->brand_list();
				$msg = "没有找到相关分类记录！";
				Util::showMessage($msg);
			}
		}
		else
		{
			$this->brand_list();
			$msg = "没有找到相关品牌记录！";
			Util::showMessage($msg);
		}
	}

	/**
	 * @brief 品牌列表
	 */
	function brand_list()
	{
		$this->redirect('brand_list');
	}

	/**
	 * @brief 品牌排序
	 */
	function brand_sort()
	{
		$sort = IReq::get("sort");
		$tb_brand = new IModel("brand");
		foreach($sort as $key => $value)
		{
			if($id = (int)$key)
			{
				$tb_brand->setData(array("sort"=>(int)$value));
				$tb_brand->update("id=".$id);
			}
		}
		$this->brand_list();
	}
}