<?php
class Goods extends IController
{
	protected $checkRight  = array('model_list','model_del','category_del','goods_del','spec_del','spec_photo_del','model_edit','spec_list','spec_edit','spec_photo','goods_add','goods_list','category_edit','category_list');
    public $layout = 'admin';
    private $data = array();
	function init()
	{
		$admin = array();
		$admin['admin_id']        = ISafe::get('admin_id');
		$admin['admin_name']      = ISafe::get('admin_name');
		$admin['admin_right']     = ISafe::get('admin_right');
		$admin['admin_role_name'] = ISafe::get('admin_role_name');
		if(!$admin['admin_id'] || !$admin['admin_right'])
		{
			$this->redirect('/systemadmin/index');
		}
		$this->admin = $admin;
	}
    /**
	 * @brief 商品模型添加/修改
	 */
    public function model_update()
    {
    	//数据过滤在class/model.php里，不在控制器里过滤

    	// 获取POST数据
    	$attribute = IReq::get("attr");
    	$spec = IReq::get("spec");
    	$model_name = IReq::get("model_name");
    	$model_id = IReq::get("model_id");

    	//初始化Model类对象
		$modelObj = new Model();

    	//校验数据
    	if(!IValidate::required($model_name))
    	{
    		//处理post数据，渲染到前台
    		$result = $modelObj->postArrayChange($attribute,$spec);
			$this->data = array('id'=>$model_id,'name'=>$model_name,
								'model_attr'=>$result['model_attr'],
								'model_spec'=>$result['model_spec']);
    		$this->setRenderData($this->data);
			$this->redirect('model_edit',false);
			Util::showMessage('模型名称不能为空！');
			exit();
    	}

		//更新模型数据
		$result = $modelObj->model_update($model_id,$model_name,$attribute,$spec);
		if($result)
		{
			$this->redirect('model_list');
		}
		else
		{
			//处理post数据，渲染到前台
    		$result = $modelObj->postArrayChange($attribute,$spec);
			$this->data = array('id'=>$model_id,'name'=>$model_name,
								'model_attr'=>$result['model_attr'],
								'model_spec'=>$result['model_spec']);
    		$this->setRenderData($this->data);
			$this->redirect('model_edit',false);
		}
    }

	/**
	 * @brief 商品模型修改
	 */
    public function model_edit()
    {
    	// 获取POST数据
    	$id = intval(IReq::get("id"));
    	if($id)
    	{
    		//初始化Model类对象
    		$modelObj = new Model();
    		//获取模型详细信息
			$model_info = $modelObj->get_model_info($id);
			//向前台渲染数据
			$this->setRenderData($model_info);
    	}
		$this->redirect('model_edit');
    }

	/**
	 * @brief 商品模型删除
	 */
    public function model_del()
    {
    	// 获取POST数据
    	$model_id = IReq::get("id");
    	$ids = IReq::get("model_id");
    	$result = 0;
    	if($model_id)
    	{
    		$ids = array('0'=>$model_id);
    	}
    	if($ids)
    	{
	    	foreach($ids as $id)
	    	{
		    	if($id)
		    	{
		    		//初始化goods_attribute表类对象
		    		$goods_attrObj = new IModel("goods_attribute");
		    		//获取商品属性表中的该模型下的数量
		    		$num = $goods_attrObj->query(" model_id = ".$id," count(*) ");
		    		if($num[0][0] > 0)
		    		{
		    			$this->redirect('model_list');
		    			Util::showMessage("请把该模型下面的商品移除，在删除该模型！");
		    		}
		    		//初始化Model表类对象
		    		$modelObj = new IModel("model");
		    		//删除商品模型
					$result = $modelObj->del(" id = ".$id);
					//初始化Model表类对象
		    		$attributeObj = new IModel("attribute");
		    		//删除商品模型属性
					$attributeObj->del(" model_id = ".$id);
		    	}
	    	}
    	}

		$this->redirect('model_list');
		if($result == 0)
		{
			Util::showMessage("删除商品模型失败！");
		}
		else
		{
			Util::showMessage("删除商品模型成功！");
		}
    }

	/**
	 * @brief 构造函数，调用父类构造函数、声明语言包对象
	 */
	function __construct()
	{
		parent::__construct(IWeb::$app,strtolower(__CLASS__));
		$this->lang = new ILanguage();
	}
	/**
	 * @brief 商品添加
	 */
	function goods_add()
	{
		//加载模型
		$tb_model = new IModel('model');
		$this->data['models'] = $tb_model->query();
		//加载品牌
		$tb_brand = new IModel('brand');
		$this->data['brand'] = $tb_brand->query();
		//加载分类
		$tb_category = new IModel('category');
		$this->data['category'] = $this->sortdata($tb_category->query(false,'*','sort','asc'),0,' &nbsp;&nbsp; ');
		//加载会员级别
		$tb_user_group = new IModel('user_group');
		$info = $tb_user_group->query();
		$ids = '';
		if(count($info)>0){
			foreach ($info as $value)
			{
				$ids .= $value['id'].',';
			}
			$ids = substr($ids,0,-1);
		}
		$this->ids = $ids;
		$this->setRenderData($this->data);
		$this->redirect('goods_add');
	}
	/*
	 * @brief ajax添加商品初始化模型,产品分类表
	 * */
	function model_init()
	{
		$id = IFilter::act(IReq::get('cid'),'int');
		$model_id = '';
		//从产品分类表中，查询出对应的model_id
		if($id)
		{
			$tb_category = new IModel('category');
			$category_info = $tb_category->query('id='.$id);
			if(count($category_info)>0)
			{
				$model_id = $category_info[0]['model_id'];
			}
		}
		echo $model_id;
	}
	/*
	 * @breif ajax添加商品扩展属性
	 * */
	function attribute_init()
	{
		$id = IFilter::act(IReq::get('mid'),'int');
		$tb_attribute = new IModel('attribute');
		$attribute_info = $tb_attribute->query('model_id='.$id);
		echo JSON::encode($attribute_info);
	}
	/*
	 * @breif 后台添加给商品规格
	 * */
	function search_spec()
	{
		$data = array();
		//错误信息提示
		$data['iden'] = '0';
		$data['message'] = '当前商品类型没有绑定默认规格,请先添加规格!';

		$this->layout = '';
		//获得model_id的值
		$mid = IFilter::act(IReq::get('mid'),'int');
		if($mid!=0)
		{
			$tb_model = new IModel('model');
			$model_info = $tb_model->query('id='.$mid);
			$spec_ids = $model_info[0]['spec_ids'];
			if($spec_ids!='')
			{
				$mode_spec = array();
				$mode_spec = unserialize($spec_ids);
				$ids = '';
				if(count($mode_spec)>0)
				{
					for($i=0;$i<count($mode_spec);$i++)
					{
						$ids .= $mode_spec[$i]['id'].',';
					}
					$tb_spec = new IModel('spec');
					$spen_info = $tb_spec->query('id in('.substr($ids,0,-1).')');
					$data['con'] = $spen_info;
					$data['spec_id'] = $ids;
					$data['iden'] = '1';
				}
			}
		}
		$this->setRenderData($data);
		$this->redirect("search_spec");
	}
	/**
	 * @breif 后台添加为每一件商品添加会员价
	 * */
	function member_price()
	{
		$date = array();
		$this->layout = '';
		$num = IFilter::act(IReq::get('num'),'int');
		$sell_price = IFilter::act(IReq::get('sell_price'),'float');
		if(empty($sell_price))
		{
			$sell_price=0;
		}
		$date['num'] = $num;
		$date['sell_price'] = $sell_price;
		$this->setRenderData($date);
		$this->redirect('member_price');
	}
/**
	 * @breif 后台修改商品修改会员价
	 * */
	function member_price_edit()
	{
		$date = array();
		$this->layout = '';
		$product_id = IFilter::act(IReq::get('product_id'));
		$sell_price = IFilter::act(IReq::get('sell_price'),'float');
		if(empty($sell_price))
		{
			$sell_price=0;
		}
		$date['product_id'] = $product_id;
		$date['sell_price'] = $sell_price;
		$this->setRenderData($date);
		$this->redirect('member_price_edit');
	}
	/**
	 * @brief 修改商品
	 */
	function goods_edit()
	{
		$goods_id = IFilter::act(IReq::get('gid'),'int');
		//编辑商品 读取商品信息
		if($goods_id)
		{
			$obj_goods = new IModel('goods');
			$goods_info = $obj_goods->query('id='.$goods_id);
			if(!empty($goods_info) && $info=$goods_info[0])
			{
				$this->data['goods_id'] = $goods_id;
				$this->data['form'] = array(
					'goods_name'	=>	$info['name'],
					'goods_no'		=>	$info['goods_no'],
					'goods_model'	=>	$info['model_id'],
					'category_id'	=>	$info['category_id'],
					'brand_id'		=>	$info['brand_id'],
					'up_time'		=>	$info['up_time'],
					'down_time'		=>	$info['down_time'],
					'sell_price'	=>	$info['sell_price'],
					'market_price'	=>	$info['market_price'],
					'store_nums'	=>	$info['store_nums'],
					'weight'		=>	$info['weight'],
					'unit'			=>	$info['unit'],
					'is_sell'		=>	$info['is_sell'],
					'point'			=>	$info['point'],
					'focus_photo'	=>	$info['img'],
					'content'		=>	$info['content'],
					'seo_keywords'	=>	$info['keywords'],
					'seo_description'=> $info['description'],
					'sort'			=>  $info['sort'],
					'ext'			=>  $info['exp']
				);

			}
			else
			{
				//没有找到相关记录
				$this->goods_list();
				Util::showMessage("没有找到相关商品！");
				return;
			}
		}

		//加载模型
		$tb_model = new IModel('model');
		$this->data['models'] = $tb_model->query();
		//加载推荐类型
		$tb_commend_goods = new IModel('commend_goods');
		$commend_goods = $tb_commend_goods->query('goods_id='.$goods_id);
		$this->data['commend_goods'] = '';
		if(count($commend_goods)>0)
		{
			foreach ($commend_goods as $value)
			{
				$this->data['commend_goods'] .= $value['commend_id'];
			}
		}
		//加载品牌
		$tb_brand = new IModel('brand');
		$this->data['brand'] = $tb_brand->query();
		//加载分类
		$tb_category = new IModel('category');
		$this->data['category'] = $this->sortdata($tb_category->query(false,'*','sort','asc'),0,' &nbsp;&nbsp; ');
		//所有扩展属性
		$tb_attribute = new IModel('attribute');
		$attribute_info = $tb_attribute->query('model_id='.$this->data['form']['goods_model']);
		$this->data['attribute'] = $attribute_info;
		//goods_attribute
		$tb_goods_attribute = new IQuery('goods_attribute');
		$tb_goods_attribute->fields = 'attribute_id,attribute_value';
		$tb_goods_attribute->where = "goods_id=".$goods_id." and attribute_id!=''";
		$goods_attribute = $tb_goods_attribute->find();
		$this->data['goods_attribute'] = ',';
		$this->data['attribute_ids'] = '';
		if(count($goods_attribute)>0){
			foreach ($goods_attribute as $value)
			{
				$this->data['goods_attribute'] .= $value['attribute_id'].'|'.$value['attribute_value'].',';
				$this->data['attribute_ids'] .= $value['attribute_id'].',';
			}
			$this->data['attribute_ids'] = substr($this->data['attribute_ids'],0,-1);
		}
		//相册
		$tb_goods_photo = new IQuery('goods_photo_relation as ghr');
		$tb_goods_photo->join = 'left join goods_photo as gh on ghr.photo_id=gh.id';
		$tb_goods_photo->fields = 'gh.img';
		$tb_goods_photo->where = 'ghr.goods_id='.$goods_id;
		$tb_goods_photo->order = 'ghr.id asc';
		$goods_photo_info = $tb_goods_photo->find();
		$this->data['goods_photo'] = $goods_photo_info;
		if(count($goods_photo_info)>0)
		{
			$this->data['photo_name'] = '';
			foreach ($goods_photo_info as $value)
			{
				$this->data['photo_name'] .= $value['img'].',';
			}
		}
		//相册属性
		//获得配置文件中的数据
		$config = new Config("site_config");
		$show_thumb_width = $config->show_thumb_width;
		if(isset($config->$show_thumb_width))
	 	{
	 		$show_thumb_width = 85;
	 	}
	 	$show_thumb_height = $config->show_thumb_height;
		if(isset($config->$show_thumb_height))
	 	{
	 		$show_thumb_height = 85;
	 	}
	 	$this->show_attr = '_'.$show_thumb_width.'_'.$show_thumb_height;
		//规格属性
		$tb_spec_attr = new IQuery('goods_attribute as ga');
		$tb_spec_attr->fields = 'ga.spec_id';
		$tb_spec_attr->group = 'spec_id';
		$tb_spec_attr->where = "goods_id=".$goods_id." and ga.spec_id!=''";
		$spec_attr_info = $tb_spec_attr->find();
		$this->data['spec_attr'] = count($spec_attr_info);
		$this->setRenderData($this->data);
		//加载会员级别
		$tb_user_group = new IModel('user_group');
		$info = $tb_user_group->query();
		$ids = '';
		if(count($info)>0){
			foreach ($info as $value)
			{
				$ids .= $value['id'].',';
			}
			$ids = substr($ids,0,-1);
		}
		$this->ids = $ids;
		$this->redirect('goods_edit');
	}

	/**
	 * @brief 保存商品信息
	 */
	function goods_save()
	{
		//获得post的数据
		$goods_name = IFilter::act(IReq::get('goods_name'));
		$goods_category = IFilter::act(IReq::get('goods_category'),'int');
		$goods_model = IFilter::act(IReq::get('goods_model'),'int');
		$goods_brand = IFilter::act(IReq::get('goods_brand'),'int');
		$goods_status = IFilter::act(IReq::get('goods_status'),'int');
		$up_time = IReq::get('up_time');
		$down_time = IReq::get('down_time');
		$sell_price = IFilter::act(IReq::get('sell_price'),'float');
		$market_price = IFilter::act(IReq::get('market_price'),'float');
		$store_nums = IFilter::act(IReq::get('store_nums'),'int');
		$weight = IFilter::act(IReq::get('weight'),'float');
		$store_unit = IFilter::act(IReq::get('store_unit'));
		$content = IFilter::act(IReq::get('content'),'text');
		$seo_keywords = IFilter::act(IReq::get('seo_keywords'));
		$seo_description = IFilter::act(IReq::get('seo_description'));
		$point = IFilter::act(IReq::get('point'),'int');
		$exp = IFilter::act(IReq::get('exp'),'int');
		$sort = IFilter::act(IReq::get('sort'),'int');
		$focus_photo = IFilter::act(IReq::get('focus_photo'));
		$goods_no = IFilter::act(IReq::get('goods_no'));
		//大图片
		$show_img = $focus_photo;
		$list_img = $focus_photo;
		if($focus_photo)
		{
			$foot = substr($focus_photo,strpos($focus_photo,'.'));//图片扩展名
			$head = substr($focus_photo,0,strpos($focus_photo,'.'));
			//list
			//获得配置文件中的数据
			$config = new Config("site_config");
		 	$list_thumb_width = $config->list_thumb_width;
		 	if(isset($config->list_thumb_width))
		 	{
		 		$list_thumb_width = 175;
		 	}
		 	$list_thumb_height = $config->list_thumb_height;
			if(isset($config->list_thumb_heigh))
		 	{
		 		$list_thumb_height = 175;
		 	}
		 	$list_img = $head.'_'.$list_thumb_width.'_'.$list_thumb_height.$foot;
		 	//show
			$show_thumb_width = $config->show_thumb_width;
			if(isset($config->show_thumb_width))
		 	{
		 		$show_thumb_width = 85;
		 	}
		 	$show_thumb_height = $config->show_thumb_height;
			if(isset($config->show_thumb_height))
		 	{
		 		$show_thumb_height = 85;
		 	}
		 	$show_img = $head.'_'.$show_thumb_width.'_'.$show_thumb_height.$foot;
		}
		//规格
		$spec_va = IReq::get('spec_va');
		$spec = array();
		if($spec_va)
		{
			$arr = explode(';',$spec_va);
			$i = 0;
			foreach ($arr as $value)
			{
				$brr = explode('|',$value);
				$j=0;
				foreach ($brr as $va)
				{
					$crr = explode(',',$va);
					$spec[$i][$j]['id'] = $crr[0];
					$spec[$i][$j]['name'] = $crr[1];
					$spec[$i][$j]['type'] = $crr[2];
					$j++;
				}
				$i++;
			}
		}
		/*goods表操作*/
		$tb_goods = new IModel('goods');
		$tb_goods ->setData(array(
			'name' =>$goods_name,
			'goods_no'=>$goods_no,
			'category_id' =>$goods_category,
			'model_id' =>$goods_model,
			'sell_price' =>$sell_price,
			'market_price' => $market_price,
			'up_time' =>$up_time,
			'down_time' =>$down_time,
			'store_nums' =>$store_nums,
			'brand_id' =>$goods_brand,
			'is_sell' =>$goods_status,
			'content'=>$content,
			'is_del' =>0,
			'create_time' =>date('Y-m-d H:i:s'),
			'keywords'=>$seo_keywords,
			'description' =>$seo_description,
			'weight'=>$weight,
			'unit' =>$store_unit,
			'sort' => $sort,
			'spec_array'=>serialize($spec),
			'visit'=>0,
			'favorite'=>0,
			'point' =>$point,
			'exp' => $exp,
			'small_img'=>$show_img,
			'img'=>$focus_photo,
			'list_img'=>$list_img
		));
		$goods_id = $tb_goods->add();
		if(!$goods_no)
		{
			//如用户没有输入商品货号，则默认货号
			$goods_no = Block::goods_no($goods_id);
			$tb_goods->setData(array('goods_no'=>$goods_no));
			$tb_goods->update('id='.$goods_id);
		}
		/*goods_attribute表操作*/
		$tb_goods_attribute = new IModel('goods_attribute');
		if(count($spec)>0)
		{
			//循环保存规格的参数
			foreach ($spec as $value)
			{
				foreach ($value as $va)
				{
				$ids = array();
				$attribute_info = $tb_goods_attribute->query("goods_id = '".$goods_id."' and spec_id='".$va['id']."' and spec_value='".$va['type'].'|'.$va['name']."'");
				if(count($attribute_info)==0)
				{
					$ids['goods_id']=$goods_id;
					$ids['spec_id']=$va['id'];
					$ids['spec_value']=$va['type'].'|'.$va['name'];
					$ids['model_id']=$goods_model;
					//echo count(ids).'|';
					$tb_goods_attribute->setData($ids);
					$tb_goods_attribute->add();
				}
				}
			}
		}
		$attribute_ids = IReq::get('attribute_ids');
		if($attribute_ids)
		{
			$att_arr = explode(',',$attribute_ids);
			//循环保存扩展属性的参数
			foreach ($att_arr as $value)
			{
				$id = $value;
				$name = IReq::get('attri'.$value) ? IReq::get('attri'.$value) : '';
				if($name)
				{
					$attribute_info = $tb_goods_attribute->query("goods_id = '.$goods_id.' and attribute_id='.$id.' and attribute_value='.$name.'" );
					if(count($attribute_info)==0)
					{
						$tb_goods_attribute->setData(array(
							'goods_id'=>$goods_id,
							'attribute_id'=>$id,
							'attribute_value'=>$name,
							'model_id'=>$goods_model
						));
						$tb_goods_attribute->add();
					}
				}
			}
		}
		/*commend_goods表操作*/
		$goods_commend = IReq::get('goods_commend');
		$tb_commend = new IModel('commend_goods');
		if(!empty($goods_commend))
		{
			if(is_array($goods_commend))
			{
				for ($i=0;$i<count($goods_commend);$i++)
				{
					$tb_commend->setData(array(
						'commend_id'=>$goods_commend[$i],
						'goods_id'=>$goods_id
					));
					$tb_commend->add();
				}
			}
			else
			{
					$tb_commend->setData(array(
						'commend_id'=>$goods_commend,
						'goods_id'=>$goods_id
					));
					$tb_commend->add();
			}
		}
		/*goods_photo_relation表操作*/
		$photo_name = IReq::get('photo_name');
		if($photo_name)
		{
			$photo_name = substr($photo_name,0,-1);
			$arr = explode(',',$photo_name);
			if(count($arr)>0)
			{
				$tb_goods_relation = new IModel('goods_photo_relation');
				foreach ($arr as $value)
				{
					$tb_goods_relation->setData(array(
						'goods_id'=>$goods_id,
						'photo_id' =>md5_file($value)
					));
					$tb_goods_relation->add();
				}
			}
		}
		/*products表的操作*/
		$tb_goods_attr = new IQuery('goods_attribute');
		$tb_goods_attr->fields='count(*) as cou,spec_id ';
		$tb_goods_attr->where="goods_id=".$goods_id." and spec_id!=''";
		$tb_goods_attr->group='spec_id';
		$info = $tb_goods_attr->find();
		if(count($info)>0)
		{
			//统计所有的货品数量
			$store_nums = 0;
			$spec_ids = '';
			$num = 1;
			for ($i=0;$i<count($info);$i++)
			{
				$num = $num*$info[$i]['cou'];
				$spec_ids .= $info[$i]['spec_id'].',';
			}
			$spec_ids = substr($spec_ids,0,-1);
			$tb_products = new Imodel('products');
			$tb_group_price = new Imodel('group_price');
			$k = 1;
			for($i=0;$i<$num;$i++)
			{
				$arr = explode(',',$spec_ids);
				$ids = array();
				$j=0;
				$flag = 0;
				$spec_md5 = '';
				//sort($arr);
				foreach ($arr as $value)
				{
					$ids[$j]['id'] = $value;
					$ids[$j]['value'] = IReq::get('spec'.$i.$value);
					$spec_md5 .=md5($ids[$j]['value']).',';
					if(!empty($ids[$j]['value'])){
						$flag = 1;
					}
					$j++;
				}
				$specTemp = explode(',',trim($spec_md5,','));
				sort($specTemp);
				$spec_md5 = md5(serialize($specTemp));

				if($flag)
				{
					$store_nums += IReq::get('store_nums'.$i);
					$tb_products->setData(array(
						'goods_id'=>$goods_id,
						'products_no'=>IReq::get('goods_no'.$i)?IReq::get('goods_no'.$i):$goods_no.'-'.$k,
						'spec_array'=>serialize($ids),
						'store_nums'=>IReq::get('store_nums'.$i),
						'market_price'=>IReq::get('market_price'.$i)?IReq::get('market_price'.$i):$market_price,
						'sell_price'=>IReq::get('sell_price'.$i)?IReq::get('sell_price'.$i):$sell_price,
						'cost_price'=>IReq::get('cost_price'.$i),
						'weight'=>IReq::get('weight'.$i),
						'spec_md5' =>$spec_md5
					));
					$products_id = $tb_products->add();
					/*针对group_price表的操作*/
					$member_ids = IReq::get('member_ids');
					if(!empty($member_ids)){
						$brr = explode(',',$member_ids);
						foreach ($brr as $value)
						{
							$price = IReq::get('mem'.$i.$value);
							if(!empty($price)){
								$tb_group_price->setData(array(
									'goods_id'=>$goods_id,
									'products_id'=>$products_id,
									'group_id'=>$value,
									'price'=>$price
								));
								$tb_group_price->add();
							}
						}
					}
				}
				$k++;
			}
			$tb_goods->setData(array('store_nums'=>$store_nums));
			$tb_goods->update('id='.$goods_id);
		}
		$this->redirect("goods_list");
	}
	/**
	 * @brief 保存商品信息
	 */
	function goods_update()
	{
		//获得post的数据
		$goods_id = IFilter::act(IReq::get('goods_id'),'int');
		$goods_name = IFilter::act(IReq::get('goods_name'));
		$goods_category = IFilter::act(IReq::get('goods_category'),'int');
		$goods_model = IFilter::act(IReq::get('goods_model'),'int');
		$goods_brand = IFilter::act(IReq::get('goods_brand'),'int');
		$goods_status = IFilter::act(IReq::get('goods_status'),'int');
		$up_time = IReq::get('up_time');
		$down_time = IReq::get('down_time');
		$sell_price = IFilter::act(IReq::get('sell_price'),'float');
		$market_price = IFilter::act(IReq::get('market_price'),'float');
		$store_nums = IFilter::act(IReq::get('store_nums'),'int');
		$weight = IFilter::act(IReq::get('weight'),'float');
		$store_unit = IFilter::act(IReq::get('store_unit'));
		$content = IFilter::act(IReq::get('content'),'text');
		$seo_keywords = IReq::get('seo_keywords');
		$seo_description = IReq::get('seo_description');
		$point = IFilter::act(IReq::get('point'),'int');
		$exp = IFilter::act(IReq::get('exp'),'int');
		$sort = IFilter::act(IReq::get('sort'));
		$focus_photo = IFilter::act(IReq::get('focus_photo'));
		$goods_no = IFilter::act(IReq::get('goods_no'));
		if(!$goods_no)
		{
			//如用户没有输入商品货号，则默认货号
			$goods_no = Block::goods_no($goods_id);
		}
		//大图片
		$show_img = $focus_photo;
		$list_img = $focus_photo;
		if($focus_photo)
		{
			$foot = substr($focus_photo,strpos($focus_photo,'.'));//图片扩展名
			$head = substr($focus_photo,0,strpos($focus_photo,'.'));
			//list
			//获得配置文件中的数据
			$config = new Config("site_config");
		 	$list_thumb_width = $config->list_thumb_width;
		 	if(isset($config->list_thumb_width))
		 	{
		 		$list_thumb_width = 175;
		 	}
		 	$list_thumb_height = $config->list_thumb_height;
			if(isset($config->list_thumb_heigh))
		 	{
		 		$list_thumb_height = 175;
		 	}
		 	$list_img = $head.'_'.$list_thumb_width.'_'.$list_thumb_height.$foot;
		 	//show
			$show_thumb_width = $config->show_thumb_width;
			if(isset($config->show_thumb_width))
		 	{
		 		$show_thumb_width = 85;
		 	}
		 	$show_thumb_height = $config->show_thumb_height;
			if(isset($config->show_thumb_height))
		 	{
		 		$show_thumb_height = 85;
		 	}
		 	$show_img = $head.'_'.$show_thumb_width.'_'.$show_thumb_height.$foot;
		}
		//规格
		$spec_va = IReq::get('spec_va');
		$spec = array();
		if($spec_va)
		{
			$arr = explode(';',$spec_va);
			$i = 0;
			foreach ($arr as $value)
			{
				if($value)
				{
					$brr = explode('|',$value);
					$j=0;
					foreach ($brr as $va)
					{
						$crr = explode(',',$va);
						$spec[$i][$j]['id'] = $crr[1];
						$spec[$i][$j]['name'] = $crr[2];
						$spec[$i][$j]['type'] = $crr[3];
						$j++;
					}
					$i++;
				}
			}
		}
		/*goods表操作*/
		$tb_goods = new IModel('goods');
		$tb_goods ->setData(array(
			'name' =>$goods_name,
			'goods_no'=>$goods_no,
			'category_id' =>$goods_category,
			'model_id' =>$goods_model,
			'sell_price' =>$sell_price,
			'market_price' => $market_price,
			'up_time' =>$up_time,
			'down_time' =>$down_time,
			'store_nums' =>$store_nums,
			'brand_id' =>$goods_brand,
			'is_sell' =>$goods_status,
			'content'=>$content,
			'keywords'=>$seo_keywords,
			'description' =>$seo_description,
			'weight'=>$weight,
			'unit' =>$store_unit,
			'spec_array'=>serialize($spec),
			'point' =>$point,
			'exp' =>$exp,
			'sort' => $sort,
			'small_img'=>$show_img,
			'img'=>$focus_photo,
			'list_img'=>$list_img
		));
		$tb_goods->update('id='.$goods_id);
		/*goods_attribute表操作*/
		$tb_goods_attribute = new IModel('goods_attribute');
		$tb_goods_attribute->del('goods_id='.$goods_id);
		if(count($spec)>0)
		{
			//循环保存规格的参数
			foreach ($spec as $value)
			{
				foreach ($value as $va)
				{
					$ids = array();
					$attribute_info = $tb_goods_attribute->query("goods_id = '".$goods_id."' and spec_id='".$va['id']."' and spec_value='".$va['type'].'|'.$va['name']."'");
					if(count($attribute_info)==0)
					{
						$ids['goods_id']=$goods_id;
						$ids['spec_id']=$va['id'];
						$ids['spec_value']=$va['type'].'|'.$va['name'];
						$ids['model_id']=$goods_model;
						//echo count(ids).'|';
						$tb_goods_attribute->setData($ids);
						$tb_goods_attribute->add();
					}
				}
			}
		}
		$attribute_ids = IReq::get('attribute_ids');
		if($attribute_ids)
		{
			$att_arr = explode(',',$attribute_ids);
			//循环保存扩展属性的参数
			foreach ($att_arr as $value)
			{
				$id = $value;
				$name = IReq::get('attri'.$value) ? IReq::get('attri'.$value) : '';
				if($name)
				{
					$attribute_info = $tb_goods_attribute->query("goods_id = '.$goods_id.' and attribute_id='.$id.' and attribute_value='.$name.'" );
					if(count($attribute_info)==0)
					{
						$tb_goods_attribute->setData(array(
							'goods_id'=>$goods_id,
							'attribute_id'=>$id,
							'attribute_value'=>$name,
							'model_id'=>$goods_model
						));
						$tb_goods_attribute->add();
					}
				}
			}
		}
		/*commend_goods表操作*/
		$goods_commend = IReq::get('goods_commend');
		$tb_commend = new IModel('commend_goods');
		$tb_commend->del('goods_id='.$goods_id);
		if(!empty($goods_commend))
		{
			if(is_array($goods_commend))
			{
				for ($i=0;$i<count($goods_commend);$i++)
				{
					$tb_commend->setData(array(
						'commend_id'=>$goods_commend[$i],
						'goods_id'=>$goods_id
					));
					$tb_commend->add();
				}
			}
			else
			{
					$tb_commend->setData(array(
						'commend_id'=>$goods_commend,
						'goods_id'=>$goods_id
					));
					$tb_commend->add();
			}
		}
		/*goods_photo_relation表操作*/
		$photo_name = IReq::get('photo_name');
		$tb_goods_relation = new IModel('goods_photo_relation');
		$tb_goods_relation->del('goods_id='.$goods_id);
		if($photo_name)
		{
			$photo_name = substr($photo_name,0,-1);
			$arr = explode(',',$photo_name);
			if(count($arr)>0)
			{
				foreach ($arr as $value)
				{
					$tb_goods_relation->setData(array(
						'goods_id'=>$goods_id,
						'photo_id' =>md5_file($value)
					));
					$tb_goods_relation->add();
				}
			}
		}
		/*products表以及group_price的操作*/
		$member_ids = IFilter::act(IReq::get('member_ids'));
		$group_id = IFilter::act(IReq::get('group_id'));
		$products_id = IFilter::act(IReq::get('products_id'));
		$member_ids = IFilter::act(IReq::get('member_ids'));
		//先对products表操作,先修改，再删除没有了的pro
		$tb_products = new Imodel('products');
		$store_nums = 0;//商品数量
		if($spec_va)
		{
			$arr = explode(';',$spec_va);
			$i=1;
			foreach ($arr as $value)
			{
				if($value)
				{
					$brr = explode('|',$value);
					$j=0;
					$ids = array();
					$spec_md5 = '';
					$pro_id = '';
					foreach ($brr as $va)
					{
						$crr = explode(',',$va);
						$pro_id = $crr[0];
						$ids[$j]['id'] = $crr[1];
						$ids[$j]['value'] = $crr[2];

						$spec_md5 .=md5($ids[$j]['value']).',';
						$j++;
					}
					$specTemp = explode(',',trim($spec_md5,','));
					sort($specTemp);

					$spec_md5 = md5(serialize($specTemp));
					$store_nums += IReq::get('store_nums'.$pro_id);
					$tb_products->setData(array(
						'goods_id'=>$goods_id,
						'products_no'=>IReq::get('goods_no'.$pro_id)?IReq::get('goods_no'.$pro_id):$goods_no.'-'.$i,
						'spec_array'=>serialize($ids),
						'market_price'=>IReq::get('market_price'.$pro_id)?IReq::get('market_price'.$pro_id):$market_price,
						'sell_price'=>IReq::get('sell_price'.$pro_id)?IReq::get('sell_price'.$pro_id):$sell_price,
						'store_nums'=>IReq::get('store_nums'.$pro_id),
						'cost_price'=>IReq::get('cost_price'.$pro_id),
						'weight'=>IReq::get('weight'.$pro_id),
						'spec_md5' =>$spec_md5
					));
					if(strpos('|'.$pro_id,'a')>0)
					{
						$pr_id = $tb_products->add();
						$mem_array = explode(',',$member_ids);
						foreach ($mem_array as $cc)
						{
							$gro_price = IFilter::act(IReq::get('mem_0_'.$pro_id.'_'.$cc),'int');
							$tb_group_ob = new Imodel('group_price');
							if($gro_price>0 && $pr_id!=0)
							{
								$tb_group_ob->setData(array(
									'goods_id'=>$goods_id,
									'products_id'=>$pr_id,
									'group_id'=>$cc,
									'price'=>$gro_price
								));
								$tb_group_ob->add();
							}
						}
					}
					else
					{
						$tb_products->update('id='.$pro_id);
					}
				}
				$i++;
			}
			//如果有products数据，则将products中的货品数量全部相加并送入goods表
			$tb_goods->setData(array(
				'store_nums'=>$store_nums
			));
			$tb_goods->update('id='.$goods_id);
		}
		//获得删除的products_id
		$del_products_id = IFilter::act(IReq::get('del_products_id'));
		if($del_products_id)
		{
			$del_products_id = substr($del_products_id,0,-1);
			$info = explode(',',$del_products_id);
			//获得group_price表的对象
			$tb_group_ob = new Imodel('group_price');
			foreach ($info as $value) {
				if(strpos('|'.$value,'a')==false)
				{
					$tb_products->del('id='.$value);
					//删除group_price 表中对应的数据
					$tb_group_object = new IQuery('group_price');
					$tb_group_object->fields = 'id';
					$tb_group_object->where = 'goods_id='.$goods_id.' and products_id='.$value;
					$info = $tb_group_object->find();
					if(count($info)>0)
					{
						foreach ($info as $va) {
							$tb_group_ob->del('id='.$va['id']);
						}
					}
				}
			}
		}
		//修改group表中的数据
		if($group_id)
		{
			$group_id .= ',0';
		}
		else
		{
			$group_id = '0';
		}
		$group_arr = explode(',',$group_id);
		$member_arr = explode(',',$member_ids);
		$products_arr = explode(',',$products_id);
		$tb_group_price = new Imodel('group_price');
		foreach ($group_arr as $value)
		{
			foreach ($products_arr as $pro)
			{
				foreach ($member_arr as $mem)
				{
					$price = IFilter::act(IReq::get('mem_'.$value.'_'.$pro.'_'.$mem));
					$tb_group_price->setData(array(
						'goods_id'=>$goods_id,
						'products_id'=>$pro,
						'group_id'=>$mem,
						'price'=>$price
					));
					if($price)
					{
						if($value!=0)
						{
							$tb_group_price->update('id='.$value);
						}
					}
				}
			}
		}
		$this->redirect("goods_list");
	}
	/**
	 * @brief 删除商品
	 */
	function goods_del()
	{
		//post数据
	    $id = IFilter::act(IReq::get('id'));
	    //生成goods对象
	    $tb_goods = new IModel('goods');
	    $tb_goods->setData(array('is_del'=>1));
	    if(!empty($id))
		{
			if(is_array($id) && isset($id[0]) && $id[0]!='')
			{
				$id_str = join(',',$id);
				$where = ' id in ('.$id_str.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$tb_goods->update($where);
		}
		else
		{
			Util::showMessage('请选择要删除的数据');
		}
		$this->redirect("goods_list");
	}
	/**
	 * @brief 商品彻底删除
	 * */
	function goods_recycle_del()
	{
		//post数据
	    $id = IFilter::act(IReq::get('id'));
	    //生成goods对象
	    $goods = new goods_del();
	    if(!empty($id))
		{
			if(is_array($id) && isset($id[0]) && $id[0]!='')
			{
				for ($i=0;$i<count($id);$i++)
				{
					$goods->del($id[$i]);
				}
			}
			else
			{
				$goods->del($id);
			}
		}
		$this->redirect("goods_recycle_list");
	}
	/**
	 * @brief 商品还原
	 * */
	function goods_recycle_restore()
	{
		//post数据
	    $id = IFilter::act(IReq::get('id'));
	    //生成goods对象
	    $tb_goods = new IModel('goods');
	    $tb_goods->setData(array('is_del'=>0));
	    if(!empty($id))
		{
			if(is_array($id) && isset($id[0]) && $id[0]!='')
			{
				$id_str = join(',',$id);
				$where = ' id in ('.$id_str.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$tb_goods->update($where);
		}
		else
		{
			Util::showMessage('请选择要删除的数据');
		}
		$this->redirect("goods_recycle_list");
	}
	/**
	 * @brief 商品回收站
	 * */
	function goods_recycle_list()
	{
		$search = IReq::get('search');
		$keywords = IReq::get('keywords');
		$where = ' 1 ';
		if($search && $keywords)
		{
			$where .= " and $search like '%{$keywords}%' ";
		}
		$this->data['search'] = $search;
		$this->data['keywords'] = $keywords;
		//筛选
		$category_id = IReq::get('category_id');
		$added = IReq::get('added');
		$store_nums = IReq::get('store_nums');
		$commend = IReq::get('commend');
		$this->data['category_id'] = $category_id;
		$this->data['added'] = $added;
		$this->data['store_nums'] = $store_nums;
		$this->data['commend'] = $commend;
		if($category_id)
		{
			$where .= " and category_id = ".$category_id." ";
		}
		if($added)
		{
			if($added=='0')
			{
				$where .= "and (to_days(now())-to_days(down_time)) <0";
			}else{
				$where .= "and (to_days(now())-to_days(down_time)) >0";
			}
		}
		if($store_nums)
		{
			if($store_nums=='1')
			{
				$where .= " and store_nums<=0 ";
			}
			if($store_nums=='10')
			{
				$where .= " and store_nums>0 and store_nums<10 ";
			}
			if($store_nums=='100')
			{
				$where .= " and store_nums>=10 and store_nums<=100 ";
			}
			if($store_nums=='101')
			{
				$where .= " and store_nums>100 ";
			}
		}
		$left_join = '';
		if($commend)
		{
			$left_join = ' left join commend_goods as cg on cg.goods_id = goods.id ';
			$where .= ' and cg.commend_id='.$commend.'';
		}
		$this->data['where'] = $where;
		$this->data['left_join'] = $left_join;
		$this->setRenderData($this->data);
		$this->redirect("goods_recycle_list");
	}
	/**
	 * @brief 商品列表
	 */
	function goods_list()
	{
		//商品搜索
		$search = IReq::get('search');
		$keywords = IReq::get('keywords');
		$where = ' 1 ';
		if($search && $keywords)
		{
			$where .= " and $search like '%{$keywords}%' ";
		}
		$this->data['search'] = $search;
		$this->data['keywords'] = $keywords;
		//筛选
		$category_id = IReq::get('category_id');
		$added = IReq::get('added');
		$store_nums = IReq::get('store_nums');
		$commend = IReq::get('commend');
		$this->data['category_id'] = $category_id;
		$this->data['added'] = $added;
		$this->data['store_nums'] = $store_nums;
		$this->data['commend'] = $commend;
		if($category_id)
		{
			$where .= " and category_id = ".$category_id." ";
		}
		if($added!='')
		{
			if($added=='0')
			{
				$where .= "and (to_days(now())-to_days(down_time)) <0";
			}else{
				$where .= "and (to_days(now())-to_days(down_time)) >0";
			}
		}
		if($store_nums)
		{
			if($store_nums=='1')
			{
				$where .= " and store_nums<=0 ";
			}
			if($store_nums=='10')
			{
				$where .= " and store_nums>0 and store_nums<10 ";
			}
			if($store_nums=='100')
			{
				$where .= " and store_nums>=10 and store_nums<=100 ";
			}
			if($store_nums=='101')
			{
				$where .= " and store_nums>100 ";
			}
		}
		$left_join = '';
		if($commend)
		{
			$left_join = ' left join commend_goods as cg on cg.goods_id = goods.id ';
			$where .= ' and cg.commend_id='.$commend.'';
		}
		$this->data['where'] = $where;
		$this->data['left_join'] = $left_join;
		$this->setRenderData($this->data);
		$this->redirect("goods_list");
	}

	/**
	 * @brief 商品分类添加、修改
	 */
	function category_edit()
	{
		$category_id = (int)IReq::get('cid');
		$parent_id = (int)IReq::get('pid');
		$this->data['category']['parent_id'] = $parent_id;
		//编辑商品分类 读取商品分类信息
		if($category_id)
		{
			$obj_category = new IModel('category');
			$category_info = $obj_category->query('id='.$category_id);
			if(is_array($category_info) && $info=$category_info[0])
			{
				$this->data['category_id'] = $category_id;
				$this->data['category'] = array(
					'id'		=>	$info['id'],
					'name'		=>	$info['name'],
					'parent_id'	=>	$info['parent_id'],
					'sort'		=>	$info['sort'],
					'model_id'	=>	$info['model_id'],
					'visibility'=>	$info['visibility'],
					'keywords'	=>	$info['keywords'],
					'descript'	=>	$info['descript']
				);
			}
			else
			{
				$this->category_list();
				Util::showMessage("没有找到相关商品分类！");
				return;
			}
		}
		//加载模型
		$tb_model = new IModel('model');
		$this->data['models'] = $tb_model->query();
		//加载分类
		$tb_category = new IModel('category');
		$this->data['all_category'] = $this->sortdata($tb_category->query(false,'*','sort','asc'),0,' &nbsp;&nbsp; ');
		$this->setRenderData($this->data);
		$this->redirect('category_edit');
	}

	/**
	 * @brief 保存商品分类
	 */
	function category_save()
	{
		//获得post值
		$category_id = IFilter::act(IReq::get('category_id'),'int');
		$name = IFilter::act(IReq::get('name'));
		$parent_id = IFilter::act(IReq::get('parent_id'),'int');
		$visibility = IFilter::act(IReq::get('visibility'),'int');
		$model = IFilter::act(IReq::get('model'),'int');
		$sort = IFilter::act(IReq::get('sort'),'int');
		$title = IFilter::act(IReq::get('title'));
		$keywords = IFilter::act(IReq::get('keywords'));
		$descript = IFilter::act(IReq::get('descript'));

		$tb_category = new IModel('category');
		$category_info = array(
			'name'=>$name,
			'parent_id'=>$parent_id,
			'sort'=>$sort,
			'visibility'=>$visibility,
			'model_id'=>$model,
			'keywords'=>$keywords,
			'descript'=>$descript,
			'title'=>$title
		);
		$tb_category->setData($category_info);
		if($category_id)									//保存修改分类信息
		{
			$where = "id=".$category_id;
			$tb_category->update($where);
		}
		else												//添加新商品分类
		{
			$tb_category->add();
		}
		$this->category_list();

	}

	/**
	 * @brief 删除商品分类
	 */
	function category_del()
	{
		$category_id = (int)IReq::get('cid');
		if($category_id)
		{
			$tb_category = new IModel('category');
			$where = "id=".$category_id;
			if($tb_category->del($where))
			{
				$this->category_list();
			}
			else
			{
				$this->category_list();
				$msg = "没有找到相关分类记录！";
				Util::showMessage($msg);
			}
		}
		else
		{
			$this->category_list();
			$msg = "没有找到相关分类记录！";
			Util::showMessage($msg);
		}
	}

	/**
	 * @brief 商品分类列表
	 */
	function category_list()
	{
		//加载模型
		$tb_model = new IModel('model');
		$models = $tb_model->query();
		$model_info =array();
		foreach($models as $value)
		{
			$model_info[$value['id']] = $value['name'];
		}
		$this->data['models'] = $model_info;
		//加载分类
		$tb_category = new IModel('category');
		$this->data['category'] = $this->sortdata($tb_category->query(false,'*','sort','asc'));
		$this->setRenderData($this->data);
		$this->redirect('category_list');
	}

	//修改页面
	function spec_edit()
	{
		if($id = IReq::get('id'))
		{
			$where = 'id = '.$id;
			$obj = new IModel('spec');
			$dataRow = $obj->getObj($where);
		}
		else
		{
			$dataRow = array(
				'id'   => null,
				'name' => null,
				'type' => null,
				'value'=> null,
				'note' => null,
			);
		}
		$this->setRenderData($dataRow);
		$this->redirect('spec_edit');
	}

	//增加或者修改规格
    function spec_update()
    {
    	//获取是否为block模块
    	$isBlock = IReq::get('block','get');

    	//显示方式
    	$specType = IReq::get('type','post');

    	//规格数据
    	$valueArray = IReq::get('value','post');

		//要插入的数据
    	if( is_array($valueArray) && isset($valueArray[0]) && $valueArray[0]!='')
    	{
    		$valueArray = array_unique($valueArray);
    		foreach($valueArray as $key => $rs)
    		{
    			if($rs=='')
    			{
    				unset($valueArray[$key]);
    			}
    		}

			if(!$valueArray)
			{
				$isPass = false;
				$errorMessage = "请上传规格图片";
			}
			else
			{
				$value = serialize($valueArray);
			}
		}
    	else
    		$value = '';

    	$editData = array(
    		'id'    => IReq::get('id','post'),
    		'name'  => IReq::get('name','post'),
    		'value' => $value,
    		'type'  => IReq::get('type','post'),
    		'note'  => IReq::get('note','post'),
    	);

    	//校验
    	$isPass = true;
    	if($value=='')
    	{
    		$isPass = false;
    		$errorMessage = '规格值不能为空,请填写规格值或上传规格图片';
    	}

    	if($editData['name']=='')
    	{
    		$isPass = false;
    		$errorMessage = '规格名称不能为空';
    	}

    	if($isPass==false)
    	{
    		//block部分
			if($isBlock!==null)
			{
				$this->blockCtrl('spec_edit',$editData,false);
			}
			else
			{
				$this->setRenderData($editData);
				$this->redirect('spec_edit',false);
			}
			Util::showMessage($errorMessage);
    	}
    	else
    	{
    		$obj = new IModel('spec');

			//执行操作
	    	$obj->setData($editData);
	    	if($id = IReq::get('id'))
	    	{
	    		$where = 'id = '.$id;
	    		$result = $obj->update($where);
	    	}
	    	else
	    		$result = $obj->add();

			//执行状态
	    	if($result===false)
	    	{
	    		//block部分
	    		if($isBlock!==null)
	    		{
	    			$this->blockCtrl('spec_edit',$editData,false);
	    		}
	    		else
	    		{
		    		$this->setRenderData($editData);
		    		$this->redirect('spec_edit');
	    		}
	    	}
	    	else
	    	{
	    		//block部分
	    		if($isBlock!==null)
	    			echo '<script>parent.closeSpec();</script>';

	    		else
	    			$this->redirect('spec_list');
	    	}

    	}
    }

	//block控制器的切换
    function blockCtrl($nextAction,$data=array(),$location=true)
    {
		$blockObj = new Block(IWeb::$app,'block');
		$blockObj->setRenderData($data);
		$blockObj->redirect($nextAction,$location);
    }

	//批量删除规格
    function spec_del()
    {
    	$id = IReq::get('id');
		if(!empty($id))
		{
			$obj = new IModel('spec');
			$obj->setData(array('is_del'=>1));
			if(is_array($id) && isset($id[0]) && $id[0]!='')
			{
				$id_str = join(',',$id);
				$where = ' id in ('.$id_str.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$obj->update($where);
			$this->redirect('spec_list');
		}
		else
		{
			$this->redirect('spec_list',false);
			Util::showMessage('请选择要删除的规格');
		}
    }
	//彻底批量删除规格
    function spec_recycle_del()
    {
    	$id = IReq::get('id');
		if(!empty($id))
		{
			$obj = new IModel('spec');
			if(is_array($id) && isset($id[0]) && $id[0]!='')
			{
				$id_str = join(',',$id);
				$where = ' id in ('.$id_str.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$obj->del($where);
			$this->redirect('spec_recycle_list');
		}
		else
		{
			$this->redirect('spec_recycle_list',false);
			Util::showMessage('请选择要删除的广告位');
		}
    }
	//批量还原规格
    function spec_recycle_restore()
    {
    	$id = IReq::get('id');
		if(!empty($id))
		{
			$obj = new IModel('spec');
			$obj->setData(array('is_del'=>0));
			if(is_array($id) && isset($id[0]) && $id[0]!='')
			{
				$id_str = join(',',$id);
				$where = ' id in ('.$id_str.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$obj->update($where);
			$this->redirect('spec_recycle_list');
		}
		else
		{
			$this->redirect('spec_recycle_list',false);
			Util::showMessage('请选择要还原的广告位');
		}
    }
    //规格图片删除
    function spec_photo_del()
    {
    	$id = IReq::get('id','post');
    	if(isset($id[0]) && $id[0]!='')
    	{
    		$obj = new IModel('spec_photo');
    		$id_str = '';
    		foreach($id as $rs)
    		{
    			if($id_str!='')
    			{
    				$id_str.=',';
    			}
    				$id_str.=$rs;

    			$photoRow = $obj->getObj('id = '.$rs,'address');
    			if(file_exists($photoRow['address']))
    			{
    				unlink($photoRow['address']);
    			}
    		}

	    	$where = ' id in ('.$id_str.')';
	    	$obj->del($where);
	    	$this->redirect('spec_photo');
    	}
    	else
    	{
    		$this->redirect('spec_photo',false);
    		Util::showMessage('请选择要删除的id值');
    	}
    }

    //上传产品图片
    function upload()
    {
    	$obj = new PhotoUpload();
    	$photoList = $obj->run();
    	return $photoList;
    }

	/**
	 * @brief 分类排序
	 */
	function category_sort()
	{
		$sort = IReq::get("sort");
		$tb_category = new IModel("category");
		foreach($sort as $key => $value)
		{
			if($id = (int)$key)
			{
				$tb_category->setData(array("sort"=>(int)$value));
				$tb_category->update("id=".$id);
			}
		}
		$this->redirect('category_list');
	}
	/**
	 * @param
	 * @return array
	 * @brief 无限极分类递归函数
	 */
	static function sortdata($catArray, $id = 0 , $prefix = '')
	{
		static $formatCat = array();
		static $floor     = 0;

		foreach($catArray as $key => $val)
		{
			if($val['parent_id'] == $id)
			{
				$str         = self::nstr($prefix,$floor);
				$val['name'] = $str.$val['name'];

				$val['floor'] = $floor;
				$formatCat[]  = $val;

				unset($catArray[$key]);

				$floor++;
				self::sortdata($catArray, $val['id'] ,$prefix );
				$floor--;
			}
		}
		return $formatCat;
	}

	function nstr($str,$num=0)
	{
		$return = '';
		for($i=0;$i<$num;$i++)
		{
			$return .= $str;
		}
		return $return;
	}

}
