<?php
class Market extends IController
{
	protected $checkRight  = array('ticket_list','pro_rule_del','ticket_excel_del','ticket_del','ticket_more_del','pro_speed_del','ticket_excel_list','pro_rule_list','pro_rule_edit','pro_speed_list','regiment_list','regiment_del','pro_speed_del');
	public $layout = 'admin';
	private $ticketDir = 'backup/ticket';
	function init()
	{
		$admin = array();
		$admin['admin_id']        = ISafe::get('admin_id');
		$admin['admin_name']      = ISafe::get('admin_name');
		$admin['admin_right']     = ISafe::get('admin_right');
		$admin['admin_role_name'] = ISafe::get('admin_role_name');
		if(!$admin['admin_id'] || !$admin['admin_right'])
		{
			$this->redirect('/systemadmin/index');
		}
		$this->admin = $admin;
	}

    public function user_reg()
    {
		$this->init_count('member', 'count(user_id) as num,left(time,7) AS month');
        $this->redirect('user_reg');
    }
    public function amount()
    {
		$this->init_count('collection_doc', 'sum(amount) as num,left(time,7) AS month');
        $this->redirect('amount');
    }
	public function spanding_avg()
	{
		$this->init_count('collection_doc', 'SUM(amount)/COUNT(DISTINCT(user_id)) AS num, LEFT(TIME,7) AS  month');
        $this->redirect('spanding_avg');
	}
	public function goods()
	{

	}
	public function init_count($table, $fields)
	{
		$start = IReq::get('start');
        $end = IReq::get('end');
        if($start == '') $start = date('Y').'-01-01';
        if($end  == '') $end  = date('Y').'-12-31';
        if(strcasecmp($start,$end)>0)$end = $start;
        $users = new IQuery($table);
        $users->fields = $fields;
        $users->where = 'time >= \''.$start.' 00:00:00\' and time <=\''.$end.' 24:59:59\'';
        $users->group = 'left(time,7)';
        $rs = $users->find();
        $numbers ='';
        $dates = '';
        $max = 0;
        foreach($rs as $row)
        {

            $numbers .= $row['num'].',';
            $dates .='"'.$row['month'].'月",';
            if($max<$row['num']) $max = $row['num'];
        }
        $this->steps = ceil($max/10);
        $this->numbers = strlen($numbers)>1 ? substr($numbers,0,-1):null;
        $this->dates = strlen($dates)>1 ? substr($dates,0,-1) : null;
        $this->max = $max+$this->steps;
	}

	//修改代金券状态is_close和is_send
	function ticket_status()
	{
		$status    = IReq::get('status');
		$id        = IReq::get('id');
		$ticket_id = IReq::get('ticket_id');

		if(!empty($id) && $status != null && $ticket_id != null)
		{
			$ticketObj = new IModel('prop');
			if(is_array($id))
			{
				foreach($id as $val)
				{
					$where = 'id = '.$val;
					$ticketRow = $ticketObj->getObj($where,$status);
					if($ticketRow[$status]==1)
					{
						$ticketObj->setData(array($status => 0));
					}
					else
					{
						$ticketObj->setData(array($status => 1));
					}
					$ticketObj->update($where);
				}
			}
			else
			{
				$where = 'id = '.$id;
				$ticketRow = $ticketObj->getObj($where,$status);
				if($ticketRow[$status]==1)
				{
					$ticketObj->setData(array($status => 0));
				}
				else
				{
					$ticketObj->setData(array($status => 1));
				}
				$ticketObj->update($where);
			}
			$this->redirect('ticket_more_list/ticket_id/'.$ticket_id);
		}
		else
		{
			$this->ticket_id = $ticket_id;
			$this->redirect('ticket_more_list',false);
			Util::showMessage('请选择要修改的id值');
		}
	}

	//[代金券]获取代金券数量
	function getTicketCount($propObj,$id)
	{
		$where     = '`condition` = "'.$id.'"';
		$propCount = $propObj->getObj($where,'count(*) as count');
		return $propCount['count'];
	}

	//[代金券]添加,修改[单页]
	function ticket_edit()
	{
		$id = IReq::get('id');
		if($id)
		{
			$ticketObj       = new IModel('ticket');
			$where           = 'id = '.$id;
			$this->ticketRow = $ticketObj->getObj($where);
		}
		$this->redirect('ticket_edit');
	}

	//[代金券]添加,修改[动作]
	function ticket_edit_act()
	{
		$id        = IReq::get('id');
		$ticketObj = new IModel('ticket');

		$dataArray = array(
			'name'      => IReq::get('name','post'),
			'value'     => IReq::get('value','post'),
			'start_time'=> IReq::get('start_time','post'),
			'end_time'  => IReq::get('end_time','post'),
			'point'  => IReq::get('point','post'),
		);

		$ticketObj->setData($dataArray);
		if($id)
		{
			$where = 'id = '.$id;
			$ticketObj->update($where);
		}
		else
		{
			$ticketObj->add();
		}
		$this->redirect('ticket_list');
	}

	//[代金券]生成[动作]
	function ticket_create()
	{
		$propObj   = new IModel('prop');
		$prop_num  = intval(IReq::get('num'));
		$ticket_id = intval(IReq::get('ticket_id'));

		if($prop_num && $ticket_id)
		{
			$prop_num  = ($prop_num > 5000) ? 5000 : $prop_num;
			$ticketObj = new IModel('ticket');
			$where     = 'id = '.$ticket_id;
			$ticketRow = $ticketObj->getObj($where);

			for($item = 0; $item < intval($prop_num); $item++)
			{
				$dataArray = array(
					'condition' => $ticket_id,
					'name'      => $ticketRow['name'],
					'card_name' => 'T'.IHash::random(8),
					'card_pwd'  => IHash::random(8),
					'value'     => $ticketRow['value'],
					'start_time'=> $ticketRow['start_time'],
					'end_time'  => $ticketRow['end_time'],
				);

				//判断code码唯一性
				$where = 'card_name = \''.$dataArray['card_name'].'\'';
				$isSet = $propObj->getObj($where);
				if(!empty($isSet))
				{
					$item--;
					continue;
				}
				$propObj->setData($dataArray);
				$propObj->add();
			}
		}
		$this->redirect('ticket_list');
	}

	//[代金券]删除
	function ticket_del()
	{
		$id = IReq::get('id');
		if(!empty($id))
		{
			$id = $idStr = IFilter::act($id,'int');
			$propObj = new IModel('prop');
			if(is_array($id))
			{
				$idStr = implode('","',$id);
			}
			$where = " type = 0 and `condition` in ({$idStr})";
			$propObj->del($where);

			$where = "id IN({$idStr}) ";
			$ticketObj = new IModel('ticket');
			$ticketObj->del($where);

			$this->redirect('ticket_list');
		}
		else
		{
			$this->redirect('ticket_list',false);
			Util::showMessage('请选择要删除的id值');
		}
	}

	//[代金券详细]删除
	function ticket_more_del()
	{
		$id        = IReq::get('id');
		$ticket_id = IReq::get('ticket_id');
		if(!empty($id))
		{
			$propObj = new IModel('prop');
			if(is_array($id))
			{
				$idStr = join(',',$id);
				$where = ' id in ('.$idStr.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$propObj->del($where);
			$this->redirect('ticket_more_list/ticket_id/'.$ticket_id);
		}
		else
		{
			$this->ticket_id = $ticket_id;
			$this->redirect('ticket_more_list',false);
			Util::showMessage('请选择要删除的id值');
		}
	}

	//[代金券详细] 列表
	function ticket_more_list()
	{
		$this->ticket_id = IReq::get('ticket_id');
		$this->redirect('ticket_more_list');
	}

	//[代金券] 输出excel表格
	function ticket_excel()
	{
		//代金券excel表存放地址
		$fileName = $this->ticketDir.'/t'.date('YmdHis').'.xls';
		$ticket_id = IReq::get('id');
		if(!empty($ticket_id))
		{
			$excelStr = '<table><tr><th>名称</th><th>卡号</th><th>密码</th><th>面值</th>
			<th>已被使用</th><th>是否关闭</th><th>是否发送</th><th>开始时间</th><th>结束时间</th></tr>';

			$propObj = new IModel('prop');
			$where   = 'type = 0';
			if(is_array($ticket_id))
			{
				$id_num_str = join('","',$ticket_id);
				$where.= ' and `condition` in("'.$id_num_str.'")';
			}
			else
			{
				$where.= ' and `condition` = "'.$ticket_id.'"';
			}

			$propList = $propObj->query($where,'*','`condition`');
			foreach($propList as $key => $val)
			{
				$is_userd = ($val['is_userd']=='1') ? '是':'否';
				$is_close = ($val['is_close']=='1') ? '是':'否';
				$is_send  = ($val['is_send']=='1') ? '是':'否';

				$excelStr.='<tr>';
				$excelStr.='<td>'.$val['name'].'</td>';
				$excelStr.='<td>'.$val['card_name'].'</td>';
				$excelStr.='<td>'.$val['card_pwd'].'</td>';
				$excelStr.='<td>'.$val['value'].' 元</td>';
				$excelStr.='<td>'.$is_userd.'</td>';
				$excelStr.='<td>'.$is_close.'</td>';
				$excelStr.='<td>'.$is_send.'</td>';
				$excelStr.='<td>'.$val['start_time'].'</td>';
				$excelStr.='<td>'.$val['end_time'].'</td>';
				$excelStr.='</tr>';
			}
			$excelStr.='</table>';

			$fileObj = new IFile($fileName,'w+');
			$fileObj->write($excelStr);
			$this->ticket_excel_list();
		}
		else
		{
			$this->redirect('ticket_list',false);
			Util::showMessage('请选择要操作的文件');
		}
	}

	//[代金券] 展示excel文件
	function ticket_excel_list()
	{
		IFile::mkdir($this->ticketDir);

		$dirArray = array();
		$dirRes   = opendir($this->ticketDir);
		while($fileName = readdir($dirRes))
		{
			if(!in_array($fileName,IFile::$except))
			{
				$dirArray[$fileName]['name'] = $fileName;
				$dirArray[$fileName]['size'] = filesize($this->ticketDir.'/'.$fileName);
				$dirArray[$fileName]['time'] = date('Y-m-d H:i:s',fileatime($this->ticketDir.'/'.$fileName));
			}
		}
		$this->dirArray = $dirArray;
		$this->redirect('ticket_excel_list',false);
	}

	//[代金券] excel文件删除
	function ticket_excel_del()
	{
		$id = IReq::get('id');
		if(!empty($id))
		{
			if(is_array($id))
			{
				foreach($id as $val)
				{
					IFile::unlink($this->ticketDir.'/'.$val);
				}
			}
			else
			{
				IFile::unlink($this->ticketDir.'/'.$id);
			}
			$this->ticket_excel_list();
		}
		else
		{
			$this->ticket_excel_list();
			Util::showMessage('请选择要删除的文件');
		}
	}

	//[代金券] excel文件下载
	function ticket_excel_download($fileName = null)
	{
		if($fileName==null)
		{
			$file = IReq::get('file');
		}
		else
		{
			$file = $fileName;
		}

		if($file != null)
		{
			header('Content-Description: File Transfer');
			header('Content-Length: '.filesize($this->ticketDir.'/'.$file));
			header('Content-Disposition: attachment; filename='.basename($file));
			readfile($this->ticketDir.'/'.$file);
		}
	}

	//[代金券] excel打包
	function ticket_excel_pack()
	{
		if(class_exists('ZipArchive'))
		{
			//获取要打包的文件数组
			$fileArray = IReq::get('id');
			if(!empty($fileArray))
			{
				$fileName = 'T_'.date('YmdHis').'.zip';
				$zip = new ZipArchive();
				$zip->open($this->ticketDir.'/'.$fileName,ZIPARCHIVE::CREATE);
				foreach($fileArray as $file)
				{
					$attachfile = $this->ticketDir.'/'.$file;
					$zip->addFile($attachfile,basename($attachfile));
				}
				$zip->close();
				$this->ticket_excel_download($fileName);
			}
			else
			{
				$this->ticket_excel_list();
				Util::showMessage('请选择要打包的文件');
			}
		}
		else
		{
			$this->ticket_excel_list();
			Util::showMessage('您的php环境没有打包工具类库');
		}
	}

	//[代金券]获取代金券数据
	function getTicketList()
	{
		$ticketObj  = new IModel('ticket');
		$ticketList = $ticketObj->query();
		echo JSON::encode($ticketList);
	}

	//[促销活动] 添加修改 [单页]
	function pro_rule_edit()
	{
		$id = IReq::get('id');
		if($id)
		{
			$promotionObj = new IModel('promotion');
			$where = 'id = '.$id;
			$this->promotionRow = $promotionObj->getObj($where);
		}
		$this->redirect('pro_rule_edit');
	}

	//[促销活动] 添加修改 [动作]
	function pro_rule_edit_act()
	{
		$id = IReq::get('id');
		$promotionObj = new IModel('promotion');

		$group_all    = IReq::get('group_all','post');
		if($group_all == 'all')
		{
			$user_group_str = 'all';
		}
		else
		{
			$user_group = IReq::get('user_group','post');
			$user_group_str = '';
			if(!empty($user_group))
			{
				$user_group_str = join(',',$user_group);
				$user_group_str = ','.$user_group_str.',';
			}
		}

		$dataArray = array(
			'name'       => IReq::get('name','post'),
			'condition'  => IReq::get('condition','post'),
			'is_close'   => IReq::get('is_close','post'),
			'start_time' => IReq::get('start_time','post'),
			'end_time'   => IReq::get('end_time','post'),
			'intro'      => IReq::get('intro','post'),
			'award_type' => IReq::get('award_type','post'),
			'type'       => 0,
			'user_group' => $user_group_str,
			'award_value'=> IReq::get('award_value','post'),
		);

		$promotionObj->setData($dataArray);

		if($id)
		{
			$where = 'id = '.$id;
			$promotionObj->update($where);
		}
		else
		{
			$promotionObj->add();
		}
		$this->redirect('pro_rule_list');
	}

	//[促销活动] 删除
	function pro_rule_del()
	{
		$id = IReq::get('id');
		if(!empty($id))
		{
			$promotionObj = new IModel('promotion');
			if(is_array($id))
			{
				$idStr = join(',',$id);
				$where = ' id in ('.$idStr.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$promotionObj->del($where);
			$this->redirect('pro_rule_list');
		}
		else
		{
			$this->redirect('pro_rule_list',false);
			Util::showMessage('请选择要删除的促销活动');
		}
	}

	//[限时抢购]添加,修改[单页]
	function pro_speed_edit()
	{
		$id = IReq::get('id');
		if($id)
		{
			$promotionObj = new IModel('promotion');
			$where = 'id = '.$id;
			$promotionRow = $promotionObj->getObj($where);

			//促销商品
			$goodsObj = new IModel('goods');
			$goodsRow = $goodsObj->getObj('id = '.$promotionRow['condition'],'id,name,sell_price,list_img');
			$result = array(
				'isError' => false,
				'data'    => array($goodsRow),
			);
			$promotionRow['goodsRow'] = JSON::encode($result);
			$this->promotionRow = $promotionRow;
		}
		$this->redirect('pro_speed_edit');
	}

	//[限时抢购]添加,修改[动作]
	function pro_speed_edit_act()
	{
		$id = IReq::get('id');

		$condition    = IReq::get('condition','post');
		$award_value  = IReq::get('award_value','post');
		$group_all    = IReq::get('group_all','post');
		if($group_all == 'all')
		{
			$user_group_str = 'all';
		}
		else
		{
			$user_group = IReq::get('user_group','post');
			$user_group_str = '';
			if(!empty($user_group))
			{
				$user_group_str = join(',',$user_group);
				$user_group_str = ','.$user_group_str.',';
			}
		}

		$dataArray = array(
			'id'         => $id,
			'name'       => IReq::get('name','post'),
			'condition'  => $condition,
			'award_value'=> $award_value,
			'is_close'   => IReq::get('is_close','post'),
			'start_time' => IReq::get('start_time','post'),
			'end_time'   => IReq::get('end_time','post'),
			'intro'      => IReq::get('intro','post'),
			'type'       => 1,
			'award_type' => 0,
			'user_group' => $user_group_str,
		);

		if(!$condition || !$award_value)
		{
			$this->promotionRow = $dataArray;
			$this->redirect('pro_speed_edit',false);
			Util::showMessage('请添加促销的商品，并为商品填写价格');
		}

		$proObj = new IModel('promotion');
		$proObj->setData($dataArray);
		if($id)
		{
			$where = 'id = '.$id;
			$proObj->update($where);
		}
		else
		{
			$proObj->add();
		}
		$this->redirect('pro_speed_list');
	}

	//[限时抢购]删除
	function pro_speed_del()
	{
		$id = IReq::get('id');
		if(!empty($id))
		{
			$propObj = new IModel('promotion');
			if(is_array($id))
			{
				$idStr = join(',',$id);
				$where = ' id in ('.$idStr.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$propObj->del($where);
			$this->redirect('pro_speed_list');
		}
		else
		{
			$this->redirect('pro_speed_list',false);
			Util::showMessage('请选择要删除的id值');
		}
	}

	//[团购]添加修改[单页]
	function regiment_edit()
	{
		$id = IReq::get('id');
		if($id)
		{
			$regimentObj = new IModel('regiment');
			$where       = 'id = '.$id;
			$regimentRow = $regimentObj->getObj($where);

			//促销商品
			$goodsObj = new IModel('goods');
			$goodsRow = $goodsObj->getObj('id = '.$regimentRow['goods_id']);

			$result = array(
				'isError' => false,
				'data'    => array($goodsRow),
			);
			$regimentRow['goodsRow'] = JSON::encode($result);
			$this->regimentRow = $regimentRow;
		}
		$this->redirect('regiment_edit');
	}

	//[团购]添加修改[动作]
	function regiment_edit_act()
	{
		$id      = IReq::get('id');
		$goodsId = IReq::get('goods_id');

		$dataArray = array(
			'id'        	=> $id,
			'title'     	=> IReq::get('title','post'),
			'start_time'	=> IReq::get('start_time','post'),
			'end_time'  	=> IReq::get('end_time','post'),
			'is_close'      => IReq::get('is_close','post'),
			'intro'     	=> IReq::get('intro','post'),
			'goods_id'      => $goodsId,
			'store_nums'    => IReq::get('store_nums','post'),
			'least_count'   => IReq::get('least_count','post'),
			'regiment_price'=> IReq::get('regiment_price','post'),
		);

		if($goodsId)
		{
			$goodsObj = new IModel('goods');
			$where    = 'id = '.$goodsId;
			$goodsRow = $goodsObj->getObj($where);

			//处理上传图片
			if(isset($_FILES['img']['name']) && $_FILES['img']['name'] != '')
			{
				$uploadObj = new PhotoUpload();
				$photoInfo = $uploadObj->run();
				$dataArray['img'] = $photoInfo['img']['img'];
			}
			else
			{
				$dataArray['img'] = $goodsRow['img'];
			}

			$dataArray['sell_price'] = $goodsRow['sell_price'];
		}
		else
		{
			$this->regimentRow = $dataArray;
			$this->redirect('regiment_edit',false);
			Util::showMessage('请选择要关联的商品');
		}

		$regimentObj = new IModel('regiment');
		$regimentObj->setData($dataArray);

		if($id)
		{
			$where = 'id = '.$id;
			$regimentObj->update($where);
		}
		else
		{
			$regimentObj->add();
		}
		$this->redirect('regiment_list');
	}

	//[团购]删除
	function regiment_del()
	{
		$id = IReq::get('id');
		if(!empty($id))
		{
			$regObj = new IModel('regiment');
			if(is_array($id))
			{
				$idStr = join(',',$id);
				$where = ' id in ('.$idStr.')';
			}
			else
			{
				$where = 'id = '.$id;
			}
			$regObj->del($where);
			$this->redirect('regiment_list');
		}
		else
		{
			$this->redirect('regiment_list',false);
			Util::showMessage('请选择要删除的id值');
		}
	}
}
