<?php
/**
 * 扩展：Ext_JCAdvComponent
 * 
 * @access	public
 */
class Ext_JCAdvComponent extends W3B_Extension
{
	/**
	 * 取得扩展名称
	 * 
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetExtensionName()
	{
		return 'Ext_JCAdvComponent' ;
	}

	/**
	 * 取得扩展的标题名称
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static
	 * @return	string
	 */
	static public function GetExtensionTitle($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('高级组件包','Ext_JCAdvComponent',$sLanguage) ;
	}
	
	/**
	 * 取得扩展的描述
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static
	 * @return	string
	 */
	static public function GetExtensionDescription($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('为其他扩展 提供一些高级组件','Ext_JCAdvComponent',$sLanguage) ;
	}
	
	
	/**
	 * 取得扩展的当前版本号
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	static public function GetVersion()
	{
		return new JCAT_Version(1,0,0,0,'') ;
	}
	
	/**
	 * 取得扩展的兼容版本号
	 * 扩展自此版本以来，接口未发生任何变化，依赖此版本的其它扩展，可在当前版本上正常工作。
	 *
	 * @access	public
	 * @static 
	 * @return	void
	 */
	static public function GetCompatibleVersion()
	{
		return self::GetVersion() ;
	}

	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		JCAT_EventManager	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{}
	
	
	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		// 调用父类方法，完成初始化工作
		parent::Load($aService) ;
		
		// TODO
		// ... ...
	}
}

?>