<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 Ext_JCCMS_CreateNewClass 
 *
 * @access public
 */
class Ext_JCCMS_AdminCategory
	extends W3B_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_AdminCategory(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->W3B_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
		
		// create model, view
		$aService = $this->GetService() ;
		$aCategory = new Ext_JCCMS_ModelCategory($aService->GetServiceId()) ;
		$aView = new Ext_JCCMS_ViewCategoryForm($this) ;
		$aView->SetModel($aCategory) ;
		
		$this->AddModel($aCategory,'aModelCategory') ;
		$this->AddView($aView,'aViewForm') ;
		
		
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam('type',Ext_JCCMS::CATEGORY_TYPE_ARTICLE) ;
		
		$this->InitializeFrameMenuPath() ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('新建文章分类','Ext_JCCMS',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aView = $this->GetView('aViewForm') ;
		
	
		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aService->GetIdManager()) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		// 载入模型
		$this->LoadModelFromRequest() ;
		
		// 加载 分类菜单
		$this->LoadCategorySelete();

		// 提交表单视图 Ext_JCCMS_ClassView
		if( $aView->IsSubmitingForm() ) 
		{
			$aView->SetDataFromSubmited() ;

			// 用户输入校验
			if( $aView->VerifyData() )
			{
				$aView->ExchangeData() ;

				// 创建新分类
				if( $this->IsCreateNew() )
				{
					$this->ActiveCreate() ;
				}
				
				// 修改分类
				else 
				{
					$this->ActiveModify() ;
				}
			}
		}
		
		// display frame
		$aFrame->RenderFrame($aView) ;
	}

	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	Ext_JCCMS_ModelCategory
	 */
	private function LoadModelFromRequest()
	{
		$aRequest = $this->GetRequest() ;
		$aCategory = $this->GetModel('aModelCategory') ;
		$aView = $this->GetView('aViewForm') ;
		
		
		// 根据 参数nCategoryId 载入模型
		if( !$this->IsCreateNew() )
		{
			$aCategory->FindById($aRequest->GetParam('nCategoryId')) ;
			if( $aCategory->Load() )
			{
				$aView->ExchangeData(JCAT_IViewForm::DOC_TO_UICTRL) ;
			}
			
			else
			{
				new JCAT_Message(JCAT_Language::SentenceEx('载入分类失败, 分类ID：%s','Ext_JCCMS',null,$aRequest->GetParam('nCategoryId')),MSGMVC_BAD) ;
				$aView->ShowForm(false) ;
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function LoadCategorySelete()
	{
		$aService = $this->GetService() ;
		$sCategoryType = $this->GetRequest()->GetParam('type') ;
		$aCategory = $this->GetModel('aModelCategory') ;
		$aView = $this->GetView('aViewForm') ;
		
		if( !Ext_JCCMS_ModelCategory::CheckCategoryType($aService,$sCategoryType) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无效的参数 type(%s)','Ext_JCCMS',null,$sCategoryType),MSGMVC_BAD) ;
			$aView->ShowForm(false) ;
		}
		
		$aCategoryList = new Ext_JCCMS_ModelCategoryTree($aService->GetServiceId()) ;
		$aCategoryList->LoadByRoot($sCategoryType) ;
		
		$aView->LoadCategoriesMenu($aCategoryList) ;
		
		if($aCategory->HaveSerialized())
		{
			$aParentCategory = $aCategory->QueryParent() ;
			$aView->SetParentCategory($aParentCategory) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsCreateNew()
	{
		return ($this->GetRequest()->GetParam('nCategoryId')===null) ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$Parameter
	 * @return	void
	 */
	private function ActiveCreate()
	{
		$aCategory = $this->GetModel('aModelCategory') ;
		$aView = $this->GetView('aViewForm') ;
	
		try{
			if( $aCategory->InsertTo($aCategory->Get('nInsertPos')) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('分类:%s 已经保存','Ext_JCCMS',null,$aCategory->Get('sName')),MSGMVC_OK) ;
				$aView->ShowForm(false) ;
			}
			
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('分类保存失败','Ext_JCCMS',null),MSGMVC_BAD) ;
				$aView->ShowForm(true) ;
			}
		}
		catch(JCAT_DBException $e)
		{
			// throw $e ;
			new JCAT_Message(JCAT_Language::SentenceEx("分类保存失败：(%s)%s\r\n<br />%s",'Ext_JCCMS',null,$e->GetDBMsg(),$e->GetDBCode(),$e->GetDBSQL()),MSGMVC_BAD) ;
			$aView->ShowForm(true) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$Parameter
	 * @return	void
	 */
	private function ActiveModify()
	{
		$aCategory = $this->GetModel('aModelCategory') ;
		$aView = $this->GetView('aViewForm') ;

		// 移动分类
		$aParent = $aCategory->QueryParent() ;
		if($aParent->GetRightBorder()!=$aCategory->Get('nInsertPos'))
		{
			try
			{
				$aCategory->MoveTo($aCategory->Get('nInsertPos')) ;
				new JCAT_Message(JCAT_Language::SentenceEx('分类移动到其它分类之下','Ext_JCCMS',null),MSGMVC_OK) ;
			}catch(Exception $e){
				new JCAT_Message(JCAT_Language::SentenceEx('分类移动操作失败:%s','Ext_JCCMS',null,$e->getMessage()),MSGMVC_BAD) ;
			}
		}
		
		// 保存分类
		try{
			if( $aCategory->Save() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('分类已保存','Ext_JCCMS',null),MSGMVC_OK) ;
			}
			
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('分类保存失败','Ext_JCCMS',null),MSGMVC_BAD) ;
			}
		}
		catch(Exception $e)
		{
			// throw $e ;
			new JCAT_Message(JCAT_Language::SentenceEx('分类保存失败：%s','Ext_JCCMS',null,$e->getMessage()),MSGMVC_BAD) ;
		}
	}
}
?>