<?php 
/**
 * ... ...
 * ... ...
 *
 */

/**
 * 控制器类 Ext_JCCMS_CreateNewClass 
 *
 * @access public
 */
class Ext_JCCMS_AdminCategoryDelete
	extends W3B_Controller 
{
	const CTLRNAME_CATEGORYLIST = 'sControllerName_list' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_AdminCategoryDelete(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->W3B_Controller(get_class($this),$aParent) ;
		
		$aAuthenticator = Ext_JCHtmlFrameAdmin_Controller::CreateAuthenticator() ;
		$this->SetAuthenticator($aAuthenticator) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// create model, view
		$aService = $this->GetService() ;
		$aCategory = new Ext_JCCMS_ModelCategory($aService->GetServiceId()) ;
		$aView = new Ext_JCCMS_ViewCategoryDeleteConfirm($this) ;
		$aView->SetModel($aCategory) ;
		
		$this->AddModel($aCategory,'aModelCategory') ;
		$this->AddView($aView,'aViewDeleteConfirm') ;
		
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(self::CTLRNAME_CATEGORYLIST,'Ext_JCCMS_AdminCategoryList') ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function AdminAuthorize()
	{
		return $this->Authorize($this->GetService()->GetIdManager()) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		// 认证
		/*if( !$this->AdminAuthorize() )
		{
		   throw new JCAT_Exception(JCAT_Language::SentenceEx(
		   	'禁止访问', 'Ext_JCCMS', null
		   )) ;
		   return ;
		}*/
		$aCategory = $this->GetModel('aModelCategory') ;
		$aViewConfirm = $this->GetView('aViewDeleteConfirm') ;
	
		$aRequest = $this->GetRequest() ;
		$sAction = $aRequest->GetParam('action') ;
		if( !in_array($sAction,array('Delete.Confirm','Delete')) )
		{
			$aViewConfirm->EnableView(false) ;
			return ;
		}
		
		// 检查参数
		$nCategoryId = $aRequest->GetParam('nCategoryId') ;
		if( !is_numeric($nCategoryId) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数nCategoryId，或参数nCategoryId无效','Ext_JCCMS',null),MSGMVC_BAD) ;
			$aViewConfirm->EnableView(false) ;
			return ;
		}
		
		// 加载
		$aCategory->FindById($nCategoryId) ;
		if( !$aCategory->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('参数nCategoryId无效，无法找到ID为 %d 的分类','Ext_JCCMS',null,$nCategoryId),MSGMVC_BAD) ;
			$aViewConfirm->EnableView(false) ;
			return ;
		}
		
		// 删除操作
		if( $sAction=='Delete' )
		{
			$aViewConfirm->EnableView(false) ;
			
			$aViewConfirm->SetDataFromSubmited() ;
			
			try{
				$aViewConfirm->GetUICtrlExchangeData('CategoryRecursionDelete')?
					//'RecursionDelete': 'Delete' ;
					$aCategory->RecursionDelete(): $aCategory->Delete() ;
				
				new JCAT_Message(JCAT_Language::SentenceEx('分类：%s 已经删除。','Ext_JCCMS',null,$aCategory->Get('sName')),MSGMVC_OK) ;
			}
			
			// 遇到异常
			catch (Exception $e){
				new JCAT_Message(JCAT_Language::SentenceEx('删除分类：%s 时遇到错误：%s。','Ext_JCCMS',null,$aCategory->Get('sName'),$e->getMessage()),MSGMVC_BAD) ;
			}
		}
	}

}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFMlQ0JuJURCRiUxNCVERCUxNyVFOCUzRiUwNCVGQSUwMCU4QiU5NEQlRDclQTYlODMlMDAlMTJJJUIxJTlBaEhRJUU0JUQwJUI1NyUwNi1NJTI1JTlBJTIzJUM5JTEwJUU5JUVBYWglOUJVNyU1RCUxNyU1RCUwNCUyOCVEMGUlRDZFJUQxJTdFTSU1RCVGODN6JUVFJUQ4ciVFMkUlRTIlNDAlQTA4JUJDJUFG
cyVFRSVCOXcyJUJCYSVERiU5NnYlQ0IlQUUlQjlZJTk1JUQ1TjIlREIlQTJvJTEzJTA2ZzElQUYlOTYlMEIlQTUlRTRyJTkwVSVEMyVEQSUwOSVBQyVFNnd2JUFEJTNFJTVEJUNDZCUzRFNSJUQ2JTA3JUNCJUM1JTk1JTFDVXUlMjYlOUQlQUMlQUElOUY2JTNCJTAzJTk1VSUzRi4lOTYlQjMlQkElQjclQUUlRTQlQkMl
Q0MlMTdzJTNBJTVEMCVDNyVFMXElREQlM0MwJUU4V3dUViU5NiVCMiVBQyUwRiUxNmUlQTUlQ0YlRjUlMTElRkQlMUYlM0NFJTVFOEslOTlVMiU5MCUyQiVFRCUzRSVCOCU5RSU1RWslRjRnJTlDJTgybCUyNiVDOSVEQSU4MCVGNXMlOTklRTQlMDdjJTVFTiU5MiVDRCVCNSVBNCVFNiUwRSVFRCVEQiVEQzZwJUQwJTVE
JTFGJUQ5JUI1JUQxNFclRTMlQTUlOUMlOTMlRDMlQjBvdyVFNC0lMTFWJUUzJUIxJUNGUyVBN3YlMDIlOEIlRjliJUZDJUYxJTNFJUZFJTIyJTdDJUFCUyUxQSUyRiVBNiU5OCVDNlNOJUE3JUVEJUVBJUE0JUU2JUNCSSU4RCVBNyUyNCVENyVFQiUwOF8lQTclQjUlNUVMJTAzJTk0JThFJUI0JUJFMnIlRjclRDBROSUx
OSUyQyVGM0ouJTI5JUE0JUI5JTE3JUFFJUY1JTg1JUZDS0hFciVEMSVBNiVEOCVCNSVFRiUxMyVERSU3RnUlRkYlQzclQkIlQkJfJUZGJUE5JTlEJTkwJTI0JTE4ViVEMyVBRTElQTclOUQlNUNwWSU5NiVEOURSJTA4MCVFNiUxQSVFNFElRTklMkYlMDMlMTglN0IlMDBUJUYyJUFCJUUyJUQ1JUREJTg3JTNGJUVGJTNG
JUZDJUY2JURGJUZCd08lMTBHJUNGJTIxJTEwJUU0JUU2JTk5WkwlM0UlQzVpJTdDNSUwRXQlQjglRkIlRTUlRUYlN0YlRkYlRkElRkQlRkUlRkQlQ0YlN0IlODglQTYlRjElMUMlQzJZJUNDZiVEOSU3QyVBQyVGMiVCOSVGQyUwOCVCMiU3QiUxMEElOTQlMTIlM0FGNyVGMkZvJTJCJTJDJTI2JTlDJTFBJUQ4JUY5JTA0
JUQ4JURDJUNCJURCJTI0ViUxNlglRUQlRjclQjdhJTNEJTgwYSVFNiVFMSUyNSVERDYlQkElMDIlMTklQTAlOTYlRUViRCUwMSVEOCVGRiVGOSVFMyU1RCslNDAlQzQlN0QlMkMlQUMlQkRjJTdEJUIxJTAxeSU4OGYlNUUlQkYlQkUlQkRFJUUyJUNETCVDRSUxRi4lOUYlRkQlRDklRTIlQkIlREQlOUI3JURGJTdFJTIz
JTlEJUQ0JThCYmElMEQlMURhJUYxJUI0JURCZyU4Mm8lQjklMjMlRDYlODElMjNaQSU5QyVGQSVDMyVBMlQlODElMjFUJUUwJUI2JUQ1JUQwJUU1JTJBJURBJTlFJTk3JUUzJTNDdSUwMiVFM0glODVJJTBGJURGJTg1JTBBRCVEMGFJJUNGYiUwOSVCRCVDN24lRkYlQjRQUSUxMSVBOUhwJUM1JTEzdS02JUMyJTAyJUM2
aiU4OCUyNyVDQSVDNSU4Nm9QN08lM0QlNjAlQUUlODIlRUUlMDgxQiUwRCUzRCUwRSUxQyVBRSU4NlclQzAlMTElOTElMUElMjYlOTElRTJXZyVGOCUxRSVBOVAlOTAlOURqeSU4QSVCQiU4NSU3RSVDOCVDNiU4QiU2MCVGNSVCNlFacSUwRSVFRSUwNXhQLmIlQjQlQ0YlRUQlRTklRjglRDBDLSU5NyVGRCVDNCU5MiVG
NiUxNiVCQyVCQiUwMSVCOCU4NCVCMWhxJUUwJTg3JUU4MSVDMiUzQiUyQSU4RSVBNyVFMCVCRmYlQzklMDQlM0RMJUQ2TCUwOCUwMyVDRiVFNlIlOERvJTdFJUQ4JTQwJThCOHUlQzAlREQlRTIlQzYlQkFDdiUyNiVCQyUyNiUxMyU4MSU4MyU5QSUyNkslQkMlMTUlMTNDJUY0JTVEJUI0cG4lQzBnMSUxMSUxOSVBOCVE
M2IlQTIlODclQjclODd3JUUwJTIyJTE2dVMlRTQlMTRUJUJGJTAxJUJDJTE2JUUxJUM0JTlBJTAzJUI0biVCMDlLJUE2LiUxMyVERC4lQzUlRDMlM0NIJTIzJTFFJTkzdmklOTclOUJtJUU4JTAxJTFEJUQwT3R1JUJFQSVBQyUxRnQlQTclMUUlRTUlMjQlMUIlRDQwRiVEMCU4RiU3QyVEMCVEMyUzQiU5RiVCMSU4NCVB
MUYlREElODklRTAlRTM0YyVFMyVGOCUwQSVEOCVFOCVBRiVFMzBxJTA2JTBFZy0lOTFjJTFFJUIxJTgxOUUlRDAlOENyJTgzJTFCJTI2JUNFJUMxJUExJTg3JUJFJTk4JUFGJTdCSyVEMCU4MzglQzclQjklMDAlRTclMjlyJUJCJUYwJTlGbSVGQSVCMSVERSU5MU1EJUIzRCUwRiVBMSU5MyVGQSUyMXglMDYlQjElRDgl
ODJvJTI3JTAyJTE3JTlFJTgwSyU4MSU5RCVBMSUzRCUyOTAlRTNEMSVFQSUzRHolOUMlQzMlQjAlOTglODBzJUUwJTlGYiU3RSVCMCVGOSVDOCVGM0IlQkYlRDclQzQlMEV1JUNGUCUwMyVGQyU3RCVFOCVERSUwQSVGNCU3RSVGNCVCMGclRDglMTElQjclRDMlODclREYlODclQ0UlRDQlMDMlQjQlRTZNJUZEJTlEJTE0
JTVCJTlDTW4lQUFDaG8lM0VoTjNSJUUwJUNCJUQ3JUY0TiU4QyU4OSUwQSVERE4lQTklRTclQTIlRTclRTQlMTklODQlODUlNUMlRjRDJUY3KyVGNTklRjUlRjIlQjhDJUExJTA4JUI2JTJDJUU5JUEyNiVGNCVEMDglMEElRkQlRjdWdCVGRHclRkYlMDMlRTJfYUE!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>