<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_CreateNewClass 
 *
 * @access public
 */
class Ext_JCCMS_AdminCategoryList
	extends W3B_Controller 
{
	const CTLR_DELETE = 'aControllerDelete' ;
	
	const CTLRNAME_LIST = 'sControllerName_list' ;
	const CTLRNAME_MODIFY = 'sControllerName_modify' ;
	const CTLRNAME_BROWSE = 'sControllerName_browse' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_AdminCategoryList(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->W3B_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
		
		$aDelete = W3B_Controller::CreateController('Ext_JCCMS_AdminCategoryDelete',$this->GetService()) ;
		$aDelete->SetRequest($this->GetRequest()) ;
		$this->AddController($aDelete,self::CTLR_DELETE) ;
		
		// 类型
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam('type',Ext_JCCMS::CATEGORY_TYPE_ARTICLE) ;
		
		$aRequest->SetParam(Ext_JCCMS_AdminCategoryList::CTLRNAME_LIST,'Ext_JCCMS_AdminCategoryList') ;
		$aRequest->SetParam(Ext_JCCMS_AdminCategoryList::CTLRNAME_MODIFY,'Ext_JCCMS_AdminCategory') ;
		$aRequest->SetParam(Ext_JCCMS_AdminCategoryList::CTLRNAME_BROWSE,'Ext_JCCMS_DisplayItemList') ;
		
		// 框架菜单路径
		$this->InitializeFrameMenuPath() ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('文章分类管理','Ext_JCCMS',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
	
		// 认证
		if( !$aFrame->Authorize($aService->GetIdManager()) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		// execute actions
		$this->Actions() ;
		
		$sCategoryType = $this->GetRequest()->GetParam('type') ;
		
		// 模型,视图
		$aCategoryTree = new Ext_JCCMS_ModelCategoryTree($aService->GetServiceId(),false) ;
		$aView = new JCAT_ViewHtml('template.Ext_JCCMS_ViewAdminCategoryList.html',$this,'Ext_JCCMS_ViewAdminCategoryList') ;
		$aView->SetViewVar('TheService',$this->GetService()) ;
		$aView->SetViewVar('sCategoryType',$sCategoryType) ;
		$aView->SetModel($aCategoryTree) ;

		// 分类菜单
		if( !Ext_JCCMS_ModelCategory::CheckCategoryType($aService,$sCategoryType) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无效的参数 type(%s)','Ext_JCCMS',null,$sCategoryType),MSGMVC_BAD) ;
		}
		
		else
		{
			
		
			$aCategoryTree->LoadByRoot($sCategoryType) ;
			$aCategoryTree->Load() ;
		}
		
		// display frame
		$aFrame->RenderFrame($aView) ;
	}


	/**
	 * 取得 Post 类型
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetPostType()
	{
		return Ext_JCCMS::POST_TYPE ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	protected function Actions()
	{
		// delete
		// -------------------
		$aDelete = $this->GetController(self::CTLR_DELETE) ;
		$aDelete->MainRun() ;
		
		// move
		// -------------------
		$this->ActionMove();
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	protected function ActionMove()
	{
		$aRequest = $this->GetRequest() ;
		if( $aRequest->GetParam('action')!='Move' )
		{
			return ;
		}
	
		$nCategoryId = $aRequest->GetParam('nCategoryId') ;
		if( !is_numeric($nCategoryId) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数nCategoryId，或参数nCategoryId无效','Ext_JCCMS',null),MSGMVC_BAD) ;
			return ;
		}
		
		$nTo = $aRequest->GetParam('nTo') ;
		if( !is_numeric($nTo) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数nTo，或无效','Ext_JCCMS',null),MSGMVC_BAD) ;
			return ;
		}
		
		$aModel = new Ext_JCCMS_ModelCategory($this->GetService()->GetServiceId()) ;
		$aModel->FindById($nCategoryId) ;
		if( !$aModel->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('参数nCategoryId无效，无法找到ID为 %d 的分类','Ext_JCCMS',null,$nCategoryId),MSGMVC_BAD) ;
			return ;
		}
		
		try{
			$aModel->MoveTo($nTo) ;
			new JCAT_Message(JCAT_Language::SentenceEx('完成操作：移动分类','Ext_JCCMS',null),MSGMVC_OK) ;
		}
		
		catch(Exception $e) 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('移动分类操作失败：%s','Ext_JCCMS',null,$e->getMessage()),MSGMVC_BAD) ;
		}
	}
	
}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFMlQ0JuJURCRiUxNCVERCUxNyVFOCUzRiUwNCVGQSUwMCU4QiU5NEQlRDclQTYlODMlMDAlMTJJJUIxJTlBaEhRJUU0JUQwJUI1NyUwNi1NJTI1JTlBJTIzJUM5JTEwJUU5JUVBYWglOUJVNyU1RCUxNyU1RCUwNCUyOCVEMGUlRDZFJUQxJTdFTSU1RCVGODN6JUVFJUQ4ciVFMkUlRTIlNDAlQTA4JUJDJUFG
cyVFRSVCOXcyJUJCYSVERiU5NnYlQ0IlQUUlQjlZJTk1JUQ1TjIlREIlQTJvJTEzJTA2ZzElQUYlOTYlMEIlQTUlRTRyJTkwVSVEMyVEQSUwOSVBQyVFNnd2JUFEJTNFJTVEJUNDZCUzRFNSJUQ2JTA3JUNCJUM1JTk1JTFDVXUlMjYlOUQlQUMlQUElOUY2JTNCJTAzJTk1VSUzRi4lOTYlQjMlQkElQjclQUUlRTQlQkMl
Q0MlMTdzJTNBJTVEMCVDNyVFMXElREQlM0MwJUU4V3dUViU5NiVCMiVBQyUwRiUxNmUlQTUlQ0YlRjUlMTElRkQlMUYlM0NFJTVFOEslOTlVMiU5MCUyQiVFRCUzRSVCOCU5RSU1RWslRjRnJTlDJTgybCUyNiVDOSVEQSU4MCVGNXMlOTklRTQlMDdjJTVFTiU5MiVDRCVCNSVBNCVFNiUwRSVFRCVEQiVEQzZwJUQwJTVE
JTFGJUQ5JUI1JUQxNFclRTMlQTUlOUMlOTMlRDMlQjBvdyVFNC0lMTFWJUUzJUIxJUNGUyVBN3YlMDIlOEIlRjliJUZDJUYxJTNFJUZFJTIyJTdDJUFCUyUxQSUyRiVBNiU5OCVDNlNOJUE3JUVEJUVBJUE0JUU2JUNCSSU4RCVBNyUyNCVENyVFQiUwOF8lQTclQjUlNUVMJTAzJTk0JThFJUI0JUJFMnIlRjclRDBROSUx
OSUyQyVGM0ouJTI5JUE0JUI5JTE3JUFFJUY1JTg1JUZDS0hFciVEMSVBNiVEOCVCNSVFRiUxMyVERSU3RnUlRkYlQzclQkIlQkJfJUZGJUE5JTlEJTkwJTI0JTE4ViVEMyVBRTElQTclOUQlNUNwWSU5NiVEOURSJTA4MCVFNiUxQSVFNFElRTklMkYlMDMlMTglN0IlMDBUJUYyJUFCJUUyJUQ1JUREJTg3JTNGJUVGJTNG
JUZDJUY2JURGJUZCd08lMTBHJUNGJTIxJTEwJUU0JUU2JTk5WkwlM0UlQzVpJTdDNSUwRXQlQjglRkIlRTUlRUYlN0YlRkYlRkElRkQlRkUlRkQlQ0YlN0IlODglQTYlRjElMUMlQzJZJUNDZiVEOSU3QyVBQyVGMiVCOSVGQyUwOCVCMiU3QiUxMEElOTQlMTIlM0FGNyVGMkZvJTJCJTJDJTI2JTlDJTFBJUQ4JUY5JTA0
JUQ4JURDJUNCJURCJTI0ViUxNlglRUQlRjclQjdhJTNEJTgwYSVFNiVFMSUyNSVERDYlQkElMDIlMTklQTAlOTYlRUViRCUwMSVEOCVGRiVGOSVFMyU1RCslNDAlQzQlN0QlMkMlQUMlQkRjJTdEJUIxJTAxeSU4OGYlNUUlQkYlQkUlQkRFJUUyJUNETCVDRSUxRi4lOUYlRkQlRDklRTIlQkIlREQlOUI3JURGJTdFJTIz
JTlEJUQ0JThCYmElMEQlMURhJUYxJUI0JURCZyU4Mm8lQjklMjMlRDYlODElMjNaQSU5QyVGQSVDMyVBMlQlODElMjFUJUUwJUI2JUQ1JUQwJUU1JTJBJURBJTlFJTk3JUUzJTNDdSUwMiVFM0glODVJJTBGJURGJTg1JTBBRCVEMGFJJUNGYiUwOSVCRCVDN24lRkYlQjRQUSUxMSVBOUhwJUM1JTEzdS02JUMyJTAyJUM2
aiU4OCUyNyVDQSVDNSU4Nm9QN08lM0QlNjAlQUUlODIlRUUlMDgxQiUwRCUzRCUwRSUxQyVBRSU4NlclQzAlMTElOTElMUElMjYlOTElRTJXZyVGOCUxRSVBOVAlOTAlOURqeSU4QSVCQiU4NSU3RSVDOCVDNiU4QiU2MCVGNSVCNlFacSUwRSVFRSUwNXhQLmIlQjQlQ0YlRUQlRTklRjglRDBDLSU5NyVGRCVDNCU5MiVG
NiUxNiVCQyVCQiUwMSVCOCU4NCVCMWhxJUUwJTg3JUU4MSVDMiUzQiUyQSU4RSVBNyVFMCVCRmYlQzklMDQlM0RMJUQ2TCUwOCUwMyVDRiVFNlIlOERvJTdFJUQ4JTQwJThCOHUlQzAlREQlRTIlQzYlQkFDdiUyNiVCQyUyNiUxMyU4MSU4MyU5QSUyNkslQkMlMTUlMTNDJUY0JTVEJUI0cG4lQzBnMSUxMSUxOSVBOCVE
M2IlQTIlODclQjclODd3JUUwJTIyJTE2dVMlRTQlMTRUJUJGJTAxJUJDJTE2JUUxJUM0JTlBJTAzJUI0biVCMDlLJUE2LiUxMyVERC4lQzUlRDMlM0NIJTIzJTFFJTkzdmklOTclOUJtJUU4JTAxJTFEJUQwT3R1JUJFQSVBQyUxRnQlQTclMUUlRTUlMjQlMUIlRDQwRiVEMCU4RiU3QyVEMCVEMyUzQiU5RiVCMSU4NCVB
MUYlREElODklRTAlRTM0YyVFMyVGOCUwQSVEOCVFOCVBRiVFMzBxJTA2JTBFZy0lOTFjJTFFJUIxJTgxOUUlRDAlOENyJTgzJTFCJTI2JUNFJUMxJUExJTg3JUJFJTk4JUFGJTdCSyVEMCU4MzglQzclQjklMDAlRTclMjlyJUJCJUYwJTlGbSVGQSVCMSVERSU5MU1EJUIzRCUwRiVBMSU5MyVGQSUyMXglMDYlQjElRDgl
ODJvJTI3JTAyJTE3JTlFJTgwSyU4MSU5RCVBMSUzRCUyOTAlRTNEMSVFQSUzRHolOUMlQzMlQjAlOTglODBzJUUwJTlGYiU3RSVCMCVGOSVDOCVGM0IlQkYlRDclQzQlMEV1JUNGUCUwMyVGQyU3RCVFOCVERSUwQSVGNCU3RSVGNCVCMGclRDglMTElQjclRDMlODclREYlODclQ0UlRDQlMDMlQjQlRTZNJUZEJTlEJTE0
JTVCJTlDTW4lQUFDaG8lM0VoTjNSJUUwJUNCJUQ3JUY0TiU4QyU4OSUwQSVERE4lQTklRTclQTIlRTclRTQlMTklODQlODUlNUMlRjRDJUY3KyVGNTklRjUlRjIlQjhDJUExJTA4JUI2JTJDJUU5JUEyNiVGNCVEMDglMEElRkQlRjdWdCVGRHclRkYlMDMlRTJfYUE!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>