<?php 
/**
 * ... ...
 * ... ...
 *
 */ 



// 载入父类 

/**
 * Ext_JCCMS_CategoryLinkedMenu 类型UI控件 Ext_JCCMS_ClassParent 
 * 
 * @access	public
 */
class Ext_JCCMS_CategoryLinkedMenu extends JCAT_UICtrlFormHtmlBase 
{
	const VALUE_IS_ID = 1 ;
	const VALUE_IS_LEFT = 2 ;
	const VALUE_IS_RIGHT = 4 ;
	const VALUE_IS_BORDER = 6 ;
	const VALUE_IS_ALL = 7 ;
	
	const DISPLAY_STATUS = 16 ;
	const DISPLAY_HIDDEN = 32 ;
	const DISPLAY_ROOT = 64 ;
	const ALLOW_ROOT = 128 ;
	
	const FLAG_DEFAULT = 241 ; // VALUE_IS_ID|DISPLAY_STATUS|DISPLAY_HIDDEN|DISPLAY_ROOT
	
	/**
	 * Ext_JCCMS_ClassParent类 的 构造函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Ext_JCCMS_CategoryLinkedMenu($sUICtrlName=__CLASS__,$sUIName=null,$nFlg=self::FLAG_DEFAULT,JCAT_UIHtml $aUI=null)
	{
		if($sUIName===null)
		{
			$sUIName = JCAT_Language::SentenceEx('分类','Ext_JCCMS',null) ;
		} 
		$this->JCAT_UICtrlHtmlBase($sUICtrlName,$sUIName,$aUI) ;
		$this->sMainUITemplate = dirname(__FILE__).'/../../Skin/UITemplate/template.Ext_JCCMS_CategoryLinkedMenu.html' ;
		
		// 数据校验器
		if($nFlg&self::DISPLAY_ROOT)
		{
			$this->AddVerifier(new JCAT_UICtrlLengthVerifier(1,-1,false)) ; 
		}
		
		$this->nFlg = $nFlg ;
		
		// 将 此控件的js文件 作为资源加入到 uihtml 对象中
		$aUI = $this->GetUI() ; 
		$aUI->AddHtmlRC(new JCAT_JS(dirname(__FILE__).'/../../Skin/JS/Ext_JCCMS_CategoryLineMenu.js')) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDataLength()
	{
		return intval($this->GetExchangeData()) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetFlag()
	{
		return $this->nFlg ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aUserRequest		JCAT_Request	用户请求
	 * @return	void
	 */
	public function SetDataFromSubmited(JCAT_Request $aUserRequest)
	{
		$sValue = $aUserRequest->GetParam($this->GetName()) ;
		if( $sValue and $sValue!='-1' )
		{
			$this->SetDataByExchange($sValue) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetMenusSelectedIdx()
	{
		if( !$this->aModelCategoryTree )
		{
			return array() ;
		}
		
		$sValue = $this->GetExchangeData() ;
		if($sValue===null)
		{
			return array() ;
		}
		
		// 寻找最后一级菜单选中的 分类模型
		$theSelectedCategory = null ;
		$aIterator = $this->aModelCategoryTree->CreateModelIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aCategory = $aIterator->Current() ;
			$sCategoryValue = self::MakeValue($aCategory,$this->nFlg) ;
			
			if($sCategoryValue==$sValue)
			{
				$theSelectedCategory = $aCategory ;
				break ;
			}
		}
		
		if(!$theSelectedCategory)
		{
			return array() ;
		}
		
		$arrCategoryPath = $theSelectedCategory->GetCategoryPath() ;
		
		// 排除虚拟root category
		$aTopCategory = $this->GetTopCategory() ;
		foreach($arrCategoryPath as $nIdx=>$aCategory)
		{
			if($aCategory==$aTopCategory)
			{
				break ;
			}
			unset($arrCategoryPath[$nIdx]) ;
		}
		
		// 根据分类路径 计算 selected Index 路径
		$arrSelectedIdxPath = array() ;
		$aParentChild = null ;
		foreach($arrCategoryPath as $aCategory)
		{
			if(!$aParentChild)
			{
				$aParentChild = $aCategory ;
				continue ;
			}
			
			$nSelectedIdx = -1 ;
			$nIdx = ($this->GetFlag()&self::DISPLAY_ROOT)? 1: 0 ;
			$aIterator = $aParentChild->CreateModelIterator() ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$aItem = $aIterator->Current();
				if($aItem==$aCategory)
				{
					$nSelectedIdx = $nIdx ;
					break ;
				}
				$nIdx ++ ;
			}
			
			if($nSelectedIdx>-1)
			{
				$arrSelectedIdxPath[] = $nSelectedIdx ;
				$aParentChild = $aCategory ;
			}
			
			else
			{
				break ;
			}
		}
		
		return $arrSelectedIdxPath ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function InitializeMenuForHtml()
	{
		// 装载菜单
		$aTopCategoryModel = $this->GetTopCategory() ;
		if($aTopCategoryModel)
		{
			$sItemObVar = $this->InitMenuItem($aTopCategoryModel) ;
			echo $this->GetJSVariableName().".GetTopMenu().LinkToItem({$sItemObVar}) ;\r\n" ;
		}
		
		// 选择菜单
		$arrMenuSelectedIdxs = $this->GetMenusSelectedIdx() ;
		foreach ($arrMenuSelectedIdxs as $nMenuIdx=>$nSeledIdx)
		{
			echo $this->GetJSVariableName().".GetMenu({$nMenuIdx}).SetSelected({$nSeledIdx}) ;\r\n" ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$aCategoryModel		Ext_JCCMS_ModelCategory
	 * @return	string
	 */
	protected function InitMenuItem(Ext_JCCMS_ModelCategory $aCategoryModel)
	{
		$sJSObVar = "aMenuItem_".spl_object_hash($aCategoryModel) ;
		$sText = addslashes($aCategoryModel->GetText()) ;

		$sValue = addslashes( self::MakeValue($aCategoryModel,$this->nFlg) ) ;
		
		
		echo "\r\n" ;	// 格式化 空行
		echo "var {$sJSObVar} = new Ext_JCCMS_CategoryLinkedMenu.MenuItem(\"{$sText}\",\"{$sValue}\") ;\r\n" ;
		
		// 下级
		$aIterator = $aCategoryModel->CreateModelIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aChildItem = $aIterator->Current();
			$sChlidItemObVar = $this->InitMenuItem($aChildItem) ;
			echo "{$sJSObVar}.AddChild({$sChlidItemObVar}) ; \r\n" ;
		}
		
		return $sJSObVar ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function LoadCategories(JCAT_DBAdjacensyCategoryTree $aModelCategoryTree)
	{
		$this->aModelCategoryTree = $aModelCategoryTree ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	Ext_JCCMS_ModelCategory
	 */
	public function GetTopCategory()
	{
		return $this->aModelCategoryTree->GetRootCategory() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aCategory	JCAT_DBAdjacensyCategory
	 * @static
	 * @return	string
	 */
	static public function MakeValue(JCAT_DBAdjacensyCategory $aCategory,$nValueType)
	{
		$arrValue = array() ;
		if($nValueType&self::VALUE_IS_ID)
		{
			$arrValue[] = $aCategory->GetId() ;
		}
		if($nValueType&self::VALUE_IS_LEFT)
		{
			$arrValue[] = $aCategory->GetLeftBorder() ;
		}
		if($nValueType&self::VALUE_IS_RIGHT)
		{
			$arrValue[] = $aCategory->GetRightBorder() ;
		}
		return implode('-',$arrValue) ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nFlg ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		Ext_JCCMS_ModelCategoryTree
	 */
	private $aModelCategoryTree ; 
	
}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:UICtrlSelectDoc}}>>
eCVEQSU4NVIlQ0RuJUQzJTQwJTEwJUJFJTIzJUYxJTEwJUREJTA3JUM4JURBTiU4MCVCMiVBOSUyQSVBNSU5QkQlRDglRTAlOTAlOTAlRDglM0RGJThCMyUyNSU5QiVBQyVFRCVDOCVCQiU5MEYlOTYlMjVOVSVDNSU4QnAlRTYlODYlRTB1JTQwJTdEJTBEZiVFRCVCQSVDQSUyMSUxMiVCMkZaJUNGJTdDJURGJUZDJTdD
MyU4MnklQUMlRDQlQUMlQzclQzhQJTE4QSVGQSU4MiVCRCVCMiVGRiVFRWtGJTIyJTlGJTlCQiVGOSVFOU5BJTBBJTk5WSUxQ3YlNDAlRkElOTIlQjklN0QlOEQlMTglRjIlN0VnZCU5RWklQ0JwWSUyOSU5OSU4MyU4RiU5RSVBNSU5RTMlOTIlQUMlQTVaJTE1JTkwJUQ5JUEwJUMzJUNBJUNBRiUzRiUyMiVCMSUyMSVC
QiUxRSUyMyU3RiU3RSU3RSU3RCVGOCVGNSVGRCVFRiVGRCVERCVDMyU4RiVERjYlQTlnJUZEJThDUCVEMiVBRiUyQSU3QyU5RCVCNyVENUMlMjElQjNrJUI5JUZBJTA0JUM2JTFGJTEyJUM0eCUwOCUxQSVERCU5QWUlQzB5OF9yJTI1JUI0JTlFJTgzJTgyJUM0JUQ4JUEwJUVCJUI0JUI0JUI3MiU1QiVCNSVGMCU4MCUw
RiUxNiVDQiVDNiVGRCVDNiVBNCVFQSUxNCU3QyUyMlIlRjglN0Z2JUFGJTg1RyU3RUtoRiVGOXY0JTBBJUZBJTVFJUI0JUI4JTNBJUMxVCU5OCVGNSU5MUglMTglRUYlREFBJUQ3eSUwQVQlMjglMDAlM0EtJUYyJTBEJTk2JUEwJTAxcGElRTh1JUY3aiVBQSU4NCVCOSVDOSU4QiU5NGIlMkIlOTBpVCU5OSUzRTVFJURE
JThFYyUzRlolRTclMDZNJUE3JUI5NiVGNSU5QiVGQSU5OTYlMjJLJTQwdyU5QSVFQTQlQjElRUUlQ0UlQzl5JTNBJUJCJUY1JUFFJTkxJTFBJTk1JUU2RyVEQnpaZSVENyVBRSUxMiUyNyVBOSU5MyVENCVEQTglOEZSJTBFJTBBJTVDJUVGJTE3JTE4JUU2JUM5ZyU3QiUxNjYlODYlRDclOTMlQjUlMTJ6JUNEJTI1JUM1
UCVDOCUxQiUwOSUwNSVDRiU5NS0lODhDJTNDJTAyVyVGNSU5OVklMTklNUUycnFRJTk2bSVBMiVCQSUzRHYlQUFEVSU1RCU1RSUzRSU3RiUwNiUzQyUxRSVDRCUyMiVBRGYlOUIlRDklMjElODglN0MlMjclODglQzZXJUVGZCVDQyUyNyUxQiUxRiU3RCVFM3klQjIlREQlQUFwJTNCJTA5YiUxRSVGM3AlREJrcSU3QiU4
QkMlMUIlQTMlOEQlODIlQzUlQzBFJURCRyUzQyVFQSU3RSVFMCVEMSU3RXIlODhuJUMzJUMxJUQ5JTk5JUQ1JUEyJUZBJTA3djQlMDQlRjc!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>