<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 
 *
 * @access public
 */
class Ext_JCCMS_ModelCategory
	extends JCAT_DBAdjacensyCategory 
{	
    
    const PROP_ITEMS = 'aItems' ;
    
    const PROP_NAME = 'sName' ;
    
    const PROP_SERVICEID = 'nServiceId' ;
    
	static private $arrORMConf_Base = array(
		'hub' => array(
			'table' => 'Ext_JCCMS_Category'
			, 'primaryKey' => 'nCategoryId'
		)
	) ;
	
	static private $arrORMConf_Full = array(
		
		'hasMany' => array(
			
			array(
				'table' => 'Ext_JCCMS_Item'
				, 'foreignKeyTo' => 'nItemId'
				, 'property' => self::PROP_ITEMS
			)
			
		)	
	) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @static
	 * @return	void
	 */
	static public function MakeCategoryTypeValue($sCategoryType)
	{
		return "\1{CATEGORY TYPE:{$sCategoryType}}\1" ;
	}
	
	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function Ext_JCCMS_ModelCategory($nServiceId=0,$bFull=false,JCAT_DB $aDB=null)
	{
		$this->JCAT_DBAdjacensyCategory( self::CreateShareORM($bFull,$aDB) ) ;
		
		$this->Set(Ext_JCCMS_ModelCategory::PROP_SERVICEID,$nServiceId) ;
		if($nServiceId)
		{
			$this->FindBy(self::PROP_SERVICEID,$nServiceId);
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_ORM
	 */
	static public function CreateShareORM($bFull=false,JCAT_DB $aDB=null)
	{
		$sORMConfName = $bFull? 'full': 'base' ;
		$arrORMConf = self::$arrORMConf_Base ;
		if($bFull)
		{
			$arrORMConf = array_merge($arrORMConf,self::$arrORMConf_Full) ;
		}
		
		if( !isset(self::$arrShareORM[$sORMConfName]) )
		{
			self::$arrShareORM[$sORMConfName] = new JCAT_ORM($aDB) ;
			self::$arrShareORM[$sORMConfName]->InitFromConfig($arrORMConf) ;
		}

		return self::$arrShareORM[$sORMConfName] ;
	}

	/**
	 * create a db aggregation model by passing a ORM
	 *
	 * @access	public
	 * @param	$aORM			JCAT_ORM
	 * @static
	 * @return	Ext_JCCMS_ModelCategory
	 */
	static public function CreateByORM(JCAT_ORM $aORM)
	{
		return new self(0,false,$aORM->GetDB()) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function LoadRoot($sInRootName)
	{
		$sRootName = self::MakeCategoryTypeValue($sInRootName) ;
		$this->FindBy('sName',$sRootName) ;
		return $this->Load() ;
	}
	
	/**
	 * 检查一个 分类类型 是否有效
	 *
	 * @access	public
	 * @param	$aService	W3B_Service
	 * @param	$sType		string
	 * @static
	 * @return	bool
	 */
	static public function CheckCategoryType(W3B_Service $aService,$sType)
	{
		if(!$sType)
		{
			return false ;
		}
		
		$sTypeData = $aService->GetExtensionData('Ext_JCCMS',Ext_JCCMS::CATEGORY_TYPE,$sType) ;
		return $sTypeData!==null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sCategoryType		
	 * @param	$nServiceId		
	 * @static	
	 * @return	Ext_JCCMS_ModelCategory
	 */
	static public function CreateRootCategory($nServiceId,$sCategoryType)
	{
		$aCategory = new Ext_JCCMS_ModelCategory($nServiceId) ;
		$sCategoryName = self::MakeCategoryTypeValue($sCategoryType) ;
		$aCategory->FindBy('sName',$sCategoryName) ;
		
		return $aCategory->Load()? $aCategory: null ;
	}
	
	// 属性 ///////////////////////////////////

	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array:JCAT_ORM
	 */
	static private $arrShareORM=array() ;
}


?>