<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class Ext_JCCMS_ModelCategoryTree extends JCAT_DBAdjacensyCategoryTree 
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function Ext_JCCMS_ModelCategoryTree($nServiceId,$bFull=false)
	{
		$this->JCAT_DBAdjacensyCategoryTree(Ext_JCCMS_ModelCategory::CreateShareORM($bFull)) ;
		$this->SetPrototype('Ext_JCCMS_ModelCategory') ;
	
		$this->FindBy(Ext_JCCMS_ModelCategory::PROP_SERVICEID,$nServiceId) ;
		JCAT_Model::Set('nServiceId',$nServiceId) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sRootName
	 * @return	void
	 */
	public function LoadByRoot($sRootName)
	{
		$nServiceId = JCAT_Model::Get('nServiceId') ;
		$sCategoryName = Ext_JCCMS_ModelCategory::MakeCategoryTypeValue($sRootName) ;
		
		$this->sCategoryName = $sCategoryName ;
		
		// query the root
		$aRootCategory = new Ext_JCCMS_ModelCategory($nServiceId) ;
		$aRootCategory->FindBy(
				Ext_JCCMS_ModelCategory::PROP_NAME
				, $sCategoryName ) ;


		// 根分类 丢失，新建根分类
		if( !$aRootCategory->Load() )
		{
			$aRootCategory->Set(Ext_JCCMS_ModelCategory::PROP_NAME
				, Ext_JCCMS_ModelCategory::MakeCategoryTypeValue($sRootName)) ;
			$aRootCategory->Create() ;
		}
		
		// load categories by root
		$this->FindBy(JCAT_DBAdjacensyCategory::BORDER_LEFT,$aRootCategory->GetLeftBorder(),'>=') ;
		$this->FindBy(JCAT_DBAdjacensyCategory::BORDER_RIGHT,$aRootCategory->GetRightBorder(),'<=') ;
		$this->Load(true) ;
	}

	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_DBAdjacensyCategory
	 * @return	void
	 */
	public function AddModel( JCAT_IModel $aModel, $sName=null )
	{
		parent::AddModel($aModel, $sName) ;
		
		if( $aModel->Get('sName')==$this->sCategoryName )
		{
			$this->aRootCategory = $aModel ;
		}
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	Ext_JCCMS_ModelCategory
	 */
	public function GetRootCategory()
	{
		return $this->aRootCategory ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function ExcludeCategory($nCategoryId)
	{
		$nExcludeLft = $nExcludeRgt = 0 ;
		
		$aIter = $this->CreateModelIterator() ;
		for ( $aIter->First(); !$aIter->IsDone(); $aIter->Next() )
		{
			$aCategory = $aIter->Current();
			
			if( $aCategory->GetId()==$nCategoryId )
			{
				$nExcludeLft = $aCategory->GetLeftBorder() ;
				$nExcludeRgt = $aCategory->GetRightBorder() ;
			}
		
			// 排除一些分类
			if( $nExcludeLft>0 and $nExcludeRgt>0 )
			{
				if( $nExcludeLft<=$aCategory->GetLeftBorder() and $nExcludeRgt>=$aCategory->GetRightBorder() )
				{
					$this->RemoveModel($aCategory) ;
				}
			}
		}
	}

	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_DBAdjacensyCategory
	 */
	private $aRootCategory ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sCategoryName ;
}

?>