<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_PostAdminList 
 *
 * @access public
 */
class Ext_JCCMS_AdminCommentList 
	extends W3B_Controller 
{
	const MODEL_LIST = 'MODEL_LIST' ;
	const VIEW_LIST = 'VIEW_LIST' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_AdminCommentList(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$this->InitializeMessageQueue() ;
		
		// create model and view
		$aService = $this->GetService() ;
		$aModel = new Ext_JCCMS_AggModelComment(false) ;
		$this->AddModel($aModel,self::MODEL_LIST) ;
		
		$aView = new JCAT_ViewHtmlList('template.Ext_JCCMS_ViewAdminCommentList.html',$this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_LIST) ;

		$this->InitializeFrameMenuPath() ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeMessageQueue()
	{
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
	}


	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('用户评论管理','Ext_JCCMS',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$nStartTime = microtime(true) ; 
		
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		// 执行操作
		$this->Action();
		
		$aModel = $this->GetModel(self::MODEL_LIST) ;
		$aView = $this->GetView(self::VIEW_LIST) ;
		
		
		$aRequest = $this->GetRequest() ;
		$nOnlyItem = $aRequest->GetParam('nOnlyItem') ;
		if($nOnlyItem)
		{
			$aModel->FindBy('nReplyTo',$nOnlyItem) ;
		}
		
		else
		{
			$aModel->FindBy('nReplyTo',0,'>') ;
		}
		
		if( !$aModel->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('文档遇到错误.','Ext_JCCMS',null),MSGMVC_BAD) ;
		}
		
		$aConn = $aModel->GetORM()->GetDB()->GetConnect() ;
		$aConn->GetLastSQL() ;		
		$aView->SetViewVar('nQueryTime',$aConn->GetQueryTime()) ;
		$aView->SetViewVar('nLoadTime',microtime(true)-$nStartTime) ;
		
		
		$aFrame->RenderFrame($aView) ;
	}
	
	/**
	 * 操作
	 *
	 * @access	private
	 * @return	void
	 */
	private function Action()
	{
		$this->ActionDelete() ;
		
	}

	/**
	 * 操作：删除
	 *
	 * @access	private
	 * @return	void
	 */
	private function ActionDelete()
	{
		$aRequest = $this->GetRequest() ;
		if( $aRequest->GetParam('action')!=='Delete' )
		{
			return ;
		}
		
		$nItemId = intval($aRequest->GetParam('nItemId')) ;
		$aRequest->RemoveParam('nItemId') ;
		$aRequest->RemoveParam('action') ;
		
		// 检查参数		
		if( !is_numeric($nItemId) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数nItemId，或参数nItemId无效','Ext_JCCMS',null),MSGMVC_BAD) ;
			return ;
		}
		
		$aModel = $this->CreateModelForAction($this->GetService()) ;
		$aModel->FindById($nItemId) ;
		if( !$aModel->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法找到 id 为：%d 的记录','Ext_JCCMS',null,$nItemId),MSGMVC_BAD) ;
			return ;
		}
	
		if( $aModel->Delete() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('删除一项记录','Ext_JCCMS',null,$nItemId),MSGMVC_OK) ;
			
			// 更新 items 表中的冗余
			$aDB = $this->GetService()->GetPlatform()->GetDefaultDB() ;
			$aDB->Decrease('Ext_JCCMS_Item','nComment',"nItemId=".$aModel->Get('nReplyTo')) ;
			echo $aDB->GetConnect()->GetLastSQL() ;
		}
		
		else
		{
			new JCAT_Message(JCAT_Language::SentenceEx('删除记录失败','Ext_JCCMS',null,$nItemId),MSGMVC_BAD) ;
		}
		
	}


	/**
	 * Description
	 *
	 * @access	protected
	 * @return	JCAT_IDBModel
	 */
	protected function CreateModelForAction(W3B_Service $aService)
	{
		return new Ext_JCCMS_ModelComment() ;
	}
}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFMlQ0JuJURCMCUxMCVCQyUxNyVFOCUzRiUyNCVGQSU4MEglQjIlQUQ2JUE1JTgzJTAwNmUlQTdRLSVEOSU4QUQlMDUlM0UlMTklOEMlQ0QlREElOEElMjglMjklMTBlJUY4JTA1X3MlRUElQTUlRTclQTIlODclMDAlMDV6JUNDJUI5JTI4JURBJUFGaSU4QSU3Q0YlOTclRjIlMjMlQzklMjFxJTIxJTEwJTEw
d2d2JTk2JUMzJTI1RSUyNSVCNCUxMCVBOCU4MiUxNCU5MyVFNlQlQTlSZCVDOCVCRCUwRSUwMSU5QyUyNnklOTZyJUNFJUIyJTBFJUNER0olMTUlQTIlQkElOEUlMTR1JTk0JUM2TCVBNSU5QzElQjUlOTMlQTUlOTclQUMlOUYlQUIlMTYlQzM0VyVDRiVDQiVGNSUwRSVBNyVGOSVDNzQlOEIlRDUlQzY0ZyU4OSUwOCVE
M0QlRkUlRjUlMkMlOENtTyVENSUwRjQlRjklQTklOThTJTIxJTk4UCUzQiVBOSVDOCVENSVCRSVEQyUxQ2xBJTNEJTE5JUFDJTBEJUUyMGklODUlMjIlM0YlQjglMUElNUQlMTUlQkFPJUJBcWglQ0NkJUI0VEYlQ0EzRCU5OSU3RSU4QiUxNCU1QiUwQyVGRCVEOSUxNSU1QiU5RiUyQUQlMUElRkMlMTQlQzclM0RESiU3
RiUxNCVGMkElQzYlMTIlOTklRDQlRDBiJTI5JUIzJTAyJUJEJTAxJTkyd2IlMDdYJUE5QkQlREYlODklN0YlQjclQzElRjclREElMUYlMEFKaSUyN0UlRDclQjYlOUN6JUNEJTJDSCVFNSVERCVBNCVEMiU5NmQ2JUVBJUU0JUE0JUEwVXYlRDIlNDAlMEElOTAlQ0JVJTlGYiVEOCVDOSVDMiU5Q2UlMTJSJURFJUQ4UXkl
ODElN0YlMDElMDZIJTEzJUU0JUM1JTIzJUU1JUJEbyVCNyVGNiVFRSVCRl8lREYlN0QlRjklQURUJUU1QVc3JTYwJUUxJTlBJURGJUIzJTk5JTEwdCVDOCUyNCUwNDQlOTJCZCVFRCVERiVDQiUwMiVEQUYlMDAlMkElOUQlRTQlRDElREUlREQlRUQlOEYlRkIlREIlQUYlN0ZvJUFFJUI3JTEyJTg3TyUyNSUwMGQlODYl
OTQlQTclQzMlQzclM0ElQTUlRkYlRDYlMDElMUYlRUUlM0UlRkYlRkElRjMlRjMlREIlRkQlQ0QlQTclOEREWSU3QiUyQSU4MSVEMzglQTYlQzklODAlODclMDklN0IlMTBZJUFFTCslODIlODElOEYlRUUlOTglOEQlOEIlMTElODQlODglMEUlQzlCJTE4JTNGJTEyJUQ2NyVGNiU5NmVXJTA2dCUyNSVDNyVCQyUxOFpj
JTI1JTA2NyVEOSVCRSU5MCU4RkclQ0U1JTA1JUE5JUNDTCVGQiUxMiUwMCVBMyU5RSVBQyUwNyU1QyUwQSUwMiVFRSVBMXAlOTElMUQlMTQlRUYlMTQlMkFVKyU3RHQlQjRYJTAwcSUxQyVCMyUyNCUyRiVERSUxNXolQjYlRjhyeSU3QyVGQyVGQSUxNSVDM0ElQzMlMjUlODIlQkIlOTclRUUlQ0MlMjIlQTclOUFFJTlB
JUY1ViUxOCU2MCVFNyVGMiUxNGJNJUFGJTFGRSVEQyU4RSUxQyUyQiVDMCUwMSVCNiVBMyVDQSUwQSVFNyVENyUwMCVEQiU5RCVCNiVCQyVBMCVFRSVDRSU4OCVFMSU2MGIlQjhzJTdCJUQ2JUQ3T3klQkIlRDElRjQrNyVCNyU3Q3clRDIlMEQlQzklQzQlRTElNUQlN0VmJTEyJUUwJUMxJTlBJTA3JUU3JTk2JTNGJTJD
JUM5JTE1RCUyOSUzRiUyMyVDNCUwMCVBQyVFMXklQTQlRDIlRjYlMjMlRUVoJTg0JUI3JUNEJTA4JUIwJUIwJTYwJUVGJUNFJUM5JTA0JUIwJTgwOSVBQiU5RkMtJTVCJUY2JTNBJTBCJTFBJUI2RyVBNiU4RSUxNzQlRUQlREElRkUlQkUlQkMlOEElRTUlM0YlMUElOTUlODklOTg!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>