<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_CreateNewPost 
 *
 * @access public
 */
class Ext_JCCMS_AdminItem 
	extends W3B_Controller 
{
	const MODEL_ITEM = 'theModelItem' ;
	const MODEL_ATTACHMENTS = 'MODEL_ATTACHMENTS' ;
	
	const VIEW_ITEMFORM = 'theViewItemForm' ;
	const VIEW_ATTACHMENTS = 'VIEW_ATTACHMENTS' ;
	
	const CTLR_FRAME = 'CTLR_FRAME' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_AdminItem(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeMessageQueue()
	{
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
	}
	
	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$this->InitializeMessageQueue() ;
		

		// 创建并加载文档
		$aService = $this->GetService() ;
		$aModel = new Ext_JCCMS_ModelItem($aService) ;
		$this->AddModel($aModel,self::MODEL_ITEM) ;
		
		$aAttasModel = new Ext_JCCMS_AggModelAttachment($aService) ;
		$this->AddModel($aAttasModel,self::MODEL_ATTACHMENTS) ;

		// 创建并加载视图
		$aView = new Ext_JCCMS_ViewItemForm($this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_ITEMFORM) ;

		$aViewAttas = new JCAT_ViewHtmlList("template.Ext_JCCMS_ViewAdminAttachmentList.html",$this) ;
		$aViewAttas->SetModel($aAttasModel) ;
		$aViewAttas->SetViewVar('sAdminController','Ext_JCCMS_AdminItemAttachment') ;
		$this->AddView($aViewAttas,self::VIEW_ATTACHMENTS) ;

		// 
		$aRequest = $this->GetRequest() ;
		if( !$aRequest->GetParam('type') )
		{
			$aRequest->SetParam('type',Ext_JCCMS::CATEGORY_TYPE_ARTICLE) ;
			$aView->SetViewVar('sItemType',JCAT_Language::SentenceEx('文章','Ext_JCCMS',null)) ;
		}
		
		$this->InitializeFrameMenuPath() ;
		
		// controller
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$this->AddController($aFrame,self::CTLR_FRAME) ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('新建文章','Ext_JCCMS',null)
		) ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function LoadCategorySelete()
	{
		$aService = $this->GetService() ;
		$aRequest = $this->GetRequest() ;
		
		$aCategoryList = new Ext_JCCMS_ModelCategoryTree($aService->GetServiceId()) ;
		$aCategoryList->LoadByRoot($aRequest->GetParam('type')) ;
		
		$aView = $this->GetView('theViewItemForm') ;
		$aView->LoadCategoriesMenu($aCategoryList) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = $this->GetController(self::CTLR_FRAME) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFrame,'Ext_JCHtmlFrame_IController' );
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		// zhxi
		$this->DoAction() ;
		
		// 载入分类菜单
		$this->LoadCategorySelete() ;
		
		$aID = $aIdMgr->QueryIdentity(Ext_JCUser_Identity::ID_CLASS) ;
		$aModel = $this->LoadModelFromRequest() ;
		$aView = $this->GetView('theViewItemForm') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','Ext_JCCMS_PostFormView')) ;


		// 提交表单视图 Ext_JCCMS_PostFormView
		if( $aView->IsSubmitingForm() ) 
		{
			$aView->SetDataFromSubmited() ;
			$aView->ExchangeData(JCAT_IViewForm::UICTRL_TO_DOC) ;

			// 用户输入校验
			if( $aView->VerifyData() )
			{

				$nNow = time() ;
				$aModel->Set('nModifyTime',$nNow) ;
				if( $this->IsCreateNew() )
				{
					$aModel->Set('nCreateTime',$nNow) ;
					$aModel->Set('nUserId',$aID->GetUID()) ;
				}
				
				if( $aModel->Serialize() )
				{
					new JCAT_Message(JCAT_Language::SentenceEx('保存成功','Ext_JCCMS',null),MSGMVC_OK) ;
					if( $this->IsCreateNew() )
					{
						$aView->ShowForm(false) ;
					}
				}
				else 
				{
					new JCAT_Message(JCAT_Language::SentenceEx('保存失败','Ext_JCCMS',null),MSGMVC_BAD) ;					
				}
			}
		}

		$aFrame->RenderFrame($aView) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsCreateNew()
	{
		return ($this->GetRequest()->GetParam('nItemId')===null) ;
	}
	/**
	 * Description
	 *
	 * @access	private
	 * @return	Ext_JCCMS_ModelCategory
	 */
	private function LoadModelFromRequest()
	{
		$aRequest = $this->GetRequest() ;
		$aModel = $this->GetModel('theModelItem') ;
		$aView = $this->GetView('theViewItemForm') ;
		
		// 根据 参数nCategoryId 载入模型
		if( !$this->IsCreateNew() )
		{
			$nItemId = $aRequest->GetParam('nItemId') ; 
			
			$aModel->FindById($nItemId) ;
			if( $aModel->Load() )
			{
				$aView->ExchangeData(JCAT_IViewForm::DOC_TO_UICTRL) ;
			}
			else
			{
				new JCAT_Message(JCAT_Language::SentenceEx('载入分类失败, 分类ID：%s','Ext_JCCMS',null,$aRequest->GetParam('nCategoryId')),MSGMVC_BAD) ;
				$aView->ShowForm(false) ;
			}
			
			// 载入附件
			$aAttasModel = $this->GetModel(self::MODEL_ATTACHMENTS) ;
			$aAttasModel->FindBy('nItemId',$nItemId) ;
			
			if(!$aAttasModel->Load())
			{
				
			}
		}
		
		return $aModel ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$Parameter
	 * @return	void
	 */
	protected function ActionDelAttachment()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->MakeUrl() ;
		$nAId = $aRequest->GetParam('nAId') ;
		if(!$nAId)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nAId 或参数无效','Ext_JCCMS',null),MSGMVC_BAD) ;
			return ;
		}
		
		$aAttaModel = new Ext_JCCMS_ModelAttachment($this->GetService()) ;
		$aAttaModel->FindBy('nAId',$nAId) ;
		
		if( !$aAttaModel->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法找到指定的附件（nAId:%s）','Ext_JCCMS',null,$nAId),MSGMVC_BAD) ;
			return ;
		}
		
		if( $aAttaModel->Delete() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('附件已经删除（nAId:%s）','Ext_JCCMS',null,$nAId),MSGMVC_OK) ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('删除附件时遇到了错误（nAId:%s）','Ext_JCCMS',null,$nAId),MSGMVC_BAD) ;
		}
	}
}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFQlQ0JuJURCRiUxNCVERCUxNyVFOCUzRiUyNCVGQyUwMCU4QiUxNCVDNSVENiVBNiU4MyUwMCVFNnAlMjQlOEIlMEQlMjklOTElRTIwJTkxNyUwNi1NJTI1WiUyMyVDOSUxMCVFOUolQjQlQTBtViVERHQlNUR0JTExJUEwJTQwJTk3WSUxN0UlRkI1dSVFMSVDRiVFOCVCOSVBMyVEOCU4OSUxNyU4OSUwM2El
QzAlOTklQjklOEZzJUVFJUI5dyU5NCVCQk13JTVCJUJBLSVENyVGMCVGMyUyQTclOEVzJUQ3JUExJUIzJTg1JTBCJUI2JTVDVCVBQiVBNVJyJUQ1JUNGJUFCJUE5cSU4QyU1QiVDQnIlOEQlQzZ0OSU5NyU4RCU1Q0klRDklRTglQUYlOTYlOTdyVDUlMDIlQzklRjIlQUElRjElREElRjYlRkElMkElQUYlN0UlNUMlQUUl
RTYlMEQlQkUlQTklRTQlQTIlMkMlOTYlMEIlREElOUQlMDclOEMlODUlODMlODZ1JTYwJUQyJUFGJUMxVCU1RSU5NiVCMmwlRjQlOTdlJUQ1JTE4JUQxJUUxJUUwJUMxJUU5JTlDJUFEZCU1RSVDOUglQUUlQzl6cDUlQkQlRDIlQjglOEYlRDhEJUY5JTVDJUQybSVEM3YlOEQlQ0YlMDQlOTIlRjklN0IlRDclMDglQ0JJ
Wl9JJUFBJUVBJTNCdyU1QiVCOCUyNjYlQkElRENDJUQ3JTE4TSUwQjUlNUUlQzklMDUlMTlNdyVCQiUyM2slMDk3JTIzJTFDdCVDMiU4QyUxOSVDNyVCOCVCMSU5RSVGNCUzRiVCQSVGNyUzRiVFRiVGRCVBMEMlOUFPJTg2WCVFNkMlOEN3JUUyJUVCKyVGQiVFOSVBMCVFNkMlOTAlQ0YlM0QlRDElRDFhJUFEJTI3JUMz
JTAwJUE1JTNEJTlEJUFGJUY0JURDJUVEJTJCJTJBJTI3JUZEVVElQzklMTUlQjklRDglRjclQzIlQjUlQkUlMTAlN0YlMDElQTlILiUxQSUxMSVENzhNJUMzVyVDRiVFRSVGRXglN0IlRkIlRUIlM0YlQzYxSSVCMiVFRlUlQzBOJUQyJUYzUCU5NmUlM0UlOTElRTQlMDIlOEMlODUlMDYlRjklQTAlRjQlOTclMDElQ0Ml
N0IlMDBkJUVBVCVCM2clQjclRUYlRkYlQkMlN0IlRkYlREIlN0YlRUYlREUlM0UlNDAlMUMlM0UlODYlODAlOTNfJUU0ajklRjklMTQlQTclRjklRDU4JUQwJUUxJUY2JTk3JUJGJUZGJUZEJUVCJUY3JUJCdyUzRiVERkMlRDglRTZjJTA4JUI2JTlDJUNGJUYzJUM1WCUxNSUwQiVGOSUxMWQlQjclMTdBJTk0JTEyJTNB
JUM2JUQ3JUYyWiUwRiUyQm4lMkMlMTg1MCVGQiUwNCVEOCVCQSU5NyVENyUyNlYlMEVYJUQxJTgzJUQwJUUzJUVEJUVDJUMxJUQwJUYzJURFJTA1JTNEM3olMDE5JUEwViVGRXJEJTBFeCUxNCU4QiUwRk8lODElMDAlRTElRjcxJUIxJUI2JThFJUY1JThCJTA2JUU0JTExJURFJUMyJThCJTE3JURCLSUwMiVBRiVFN3JR
JUU5JTE3JUU4JTdFNiVGOW4lRjclRjIlRTUlQjclREZIJTk2JUYxeCslOUMlODQlMDklMjclMUNkJTNDJUUxLSVENSVGMyVFM3UlOTAlRjJ1UiVFMCU1Q2QlNUU0JTEwJUQ4JTBCM2QlOTlHJTNFcSUyMSVBQyVFNDRWJUYxJUU1JUE0JTBFRCVEQiUwRiVEMiVBODMlQThhJTJCRCUwRCUzQiU4QiUwN1klMjdEJUNFJUE4
JTEwJTlCJTA4eSVFM1olRDRYTiU4RndVJUU4JUNGVCUyMiU5Mk4lOTAlQ0UlRUErJUY1eCslQjIlMEVWJTFCJTdFLSVDNG9iJUUycCUzQVFJJUNBVSVDMmMlOTUlRjglMjMlMTUlREYrJUU2MiVENiUyQjQlQkIlMkFOZyVFMEglQjklQTYlM0QlRjBsJTA2aSVENyUwQ0R3JTBELiU3Q1QlODglMTYlRUElQTklODkzJUJF
LSVFNCVCREklRDQlMjElN0MlQkRXJUMwYSVBOCUwNyUwQiVCNiUzQSVFMyUzRCU5NiVGOSUwOSVDQlhYJThCdTRDJTNFJTBFJUNDJUNCJUY2JUE5JUNFJTg1JUZBJTgzdGIlMDUlMjJEJURFLiVFQSUxQyU5QTklRjIlMjQlMjJUJTNEJTIxVCUyOCVCQSUyQTIlQTMlQ0IlMDFwJTEwJUJGJTA5JTg1aSVFNyVCNWhCJTIz
JTE2JURGJTBDJUFCJUQxJTVFJUI3TSVGOGYlMDYlQ0VCJUY1JUQyJUU5JTlCJUJEVlglMjIlRUElODRtJURDcSU4MSUzQSVDNzZyJTNCJTgxSCVEQSVDMGwlMDVpJUM2JTgzVHklRDBnQyVCQSUwNiU4MiVBMyU5NiVDQyU4RkhfJTYwJUM2JUIzbCUxNSU4OCVEOCUwQSVEMiU5MyUwRHg5JTA5cSU4NyVBRSUzRCU5RTEl
RENBJThCMSUxRiVENyVEMCVERiVGNyVCQyU5MFElM0YlQTAlMkJDJUJGJUEwJTJGJUY1MkEuJUQ0JUNEJUMzJTIyJUVCRCUyQyVFQiVFMCVFQyVGNSVGNCUxRCVFQyVBNyVDMiUzRSU5Qk8lQzB1RCVCQyU1RSUyMyVCRiUwOSUwRDclODglQjUlQTklN0ZRJUZCJTA4JTlDJTE0JUY4JUNEJUNDJTBDJUIzJUEwJTdCRiVC
M0ElQjElRUQzJUY0KyUwMCVERiUxOFpFJTFFJUVBJUMxJTEyJUQwMEIlQ0QlNUQlRTglMjhaJUE0JTNGJUUyJURCJUZBJTlDJUNFbi5qJUMyJTA3NyVCRSVCRSUxRWIlQTYlRDAlNUQlRTglMUElQUIlMDh1JTkyJUNFJTA5JTBGJUQxJUVCJTkxJUZFJTI2JUE5JTQwJUVEQyU3QyVFMSU5NSUwRVVsRiUzRiVBMTclRTAl
RDNFJURFMyVDQSVFOSUwQ0glRkJCJUQ4JUQ0YyU3QyU1QiVEMCU4RHolRUIlRDAlNUUlRjd6JTdGJUJGJTAxZyVFQSUxMyVDNyU3QyUzQTQlMjMlQTglN0RDMyVBMWclMTczJThGOCUyRlIlOTglQjdZJTFCNXQlQUQlOUN0JUUyJTIzJUNDJURDJUQ5WiVGN0YlNjAlRTYlODRwJUQwSyU4RSVGOSVGMWklQzZJJTgzOCU3
RSVGRSU5QyVGRSUxQXYlRkYlMDMlQjklQzBnUw!!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>