<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_AdminItemAttachment
 *
 * @access public
 */
class Ext_JCCMS_AdminItemAttachment
	extends W3B_Controller 
{
	const MODEL_ITEM = 'MODEL_ITEM' ;
	const MODEL_ATTACHMENT = 'MODEL_ATTACHMENT' ;
	const VIEW_ATTACHMENT = 'VIEW_ATTACHMENT' ;
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_AdminItemAttachment(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		

		// 创建并加载文档：
		$aService = $this->GetService() ;
		$aModel = new Ext_JCCMS_ModelAttachment($aService) ;
		$this->AddModel($aModel,self::MODEL_ATTACHMENT) ;
		
		$aItemModel = new Ext_JCCMS_ModelItem($aService) ;
		$this->AddModel($aItemModel,self::MODEL_ITEM) ;

		// 创建并加载视图：
		$aView = new Ext_ViewAttachmentForm($this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_ATTACHMENT) ;
		
		
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('文章系统','Ext_JCCMS',null)
		) ;
	}

	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		$this->Doing() ;
		
		$aView = $this->GetView(self::VIEW_ATTACHMENT) ;
		$aFrame->RenderFrame($aView) ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function Doing()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;
		$aID = $aIdMgr->QueryIdentity(Ext_JCUser_Identity::ID_CLASS) ;
		
		$aView = $this->GetView(self::VIEW_ATTACHMENT) ;
		$aModel = $this->GetModel(self::MODEL_ATTACHMENT) ;
		$aItemModel = $this->GetModel(self::MODEL_ITEM) ;
		
		do{
			$aView->ShowForm(false) ;
				
			$aRequest = $this->GetRequest() ;
			$nItemId = intval($aRequest->GetParam('nItemId')) ;
			if( !$nItemId )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nItemId，或参数无效','Ext_JCCMS',null),MSGMVC_BAD) ;
				break ;
			}
	
			$aItemModel->FindBy('nItemId',$nItemId) ;
			if( !$aItemModel->Load() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的内容不存在（nItemId:%s）','Ext_JCCMS',null,$nItemId),MSGMVC_BAD) ;
				break ;
			}
			
			$aView->SetViewVar('TheItemModel',$aItemModel) ;
			/*
			// 修改 附件
			$nAId = $aRequest->GetParam('nAId') ;
			if($nAId)
			{
				// 载入附件
				$aModel->FindBy('nAId',$nAId) ;
				if(!$aModel->Load())
				{
					new JCAT_Message(JCAT_Language::SentenceEx('指定的附件不存在（nAId:%s）','Ext_JCCMS',null,$nAId),MSGMVC_BAD) ;
					break ;
				}
			}
			*/
			
			$aView->ShowForm(true) ;
	
			// 提交表单视图 Ext_JCCMS_PostFormView
			if( $aView->IsSubmitingForm() ) 
			{
				$aView->SetDataFromSubmited() ;
				$aView->ExchangeData(JCAT_IViewForm::UICTRL_TO_DOC) ;
	
				// 用户输入校验
				if( $aView->VerifyData() )
				{
					$aModel->Set('nItemId',$nItemId) ;
					$aModel->Set('nServiceId',$aService->GetServiceId()) ;
					$aModel->Set('nUploaderId',$aID->GetUID()) ;
					$aModel->Set('nUploadTime',time()) ;
					
					if( $aModel->Serialize() )
					{
						new JCAT_Message(JCAT_Language::SentenceEx('保存成功','Ext_JCCMS',null),MSGMVC_OK) ;
						$aView->ShowForm(false) ;
					}
					else 
					{
						new JCAT_Message(JCAT_Language::SentenceEx('保存失败','Ext_JCCMS',null),MSGMVC_BAD) ;					
					}
				}
			}

		} while(0) ;
	}

}

?>