<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_PostAdminList 
 *
 * @access public
 */
class Ext_JCCMS_CategoryPath 
	extends W3B_Controller 
{
	const MODELNAME_CATEGORYTREE = 'theModelCategoryTree' ;
	const MODELNAME_CATEGORY = 'theModelCategory' ;
	const VIEWNAME_PATH = 'theViewPath' ;
	const VIEWNAME_MENU = 'theViewMenu' ;
	
	const PARAM_CTLR_ITEM = 'sControllerItem' ;
	const PARAM_CTLR_ITEMLIST = 'sControllerItemList' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_CategoryPath(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		$aCategoryTree = new Ext_JCCMS_ModelCategoryTree($this->GetService()->GetServiceId(),false) ;
		$this->AddModel($aCategoryTree,self::MODELNAME_CATEGORYTREE) ;

		// 
		$aRequest = $this->GetRequest() ;
		$sControllerItemList = $aRequest->GetParam(self::PARAM_CTLR_ITEMLIST) ;
		if( !$sControllerItemList )
		{
			$sControllerItemList = 'Ext_JCCMS_DisplayItemList' ;
			$aRequest->SetParam(self::PARAM_CTLR_ITEMLIST,$sControllerItemList) ;
		}
		
		$aView = new JCAT_ViewHtml('template.Ext_JCCMS_CategoryPath.html',$this,'Ext_JCCMS_CategoryPath') ;
		$aView->SetViewVar('sControllerItemList',$sControllerItemList) ;
		$this->AddView($aView,self::VIEWNAME_PATH) ;
		
		$aView = new JCAT_ViewHtml('template.Ext_JCCMS_CategoryPath_Menu.html',$this,'Ext_JCCMS_CategoryPath_Menu') ; 
		// $aView->SetViewVar('sControllerItemList',$sControllerItemList) ;
		$this->AddView( $aView, self::VIEWNAME_MENU ) ;
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aRequest = $this->GetRequest() ;
		$aCategoryTree = $this->GetModel(self::MODELNAME_CATEGORYTREE) ;
		$aViewContainer = $this->GetViewContainer() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aViewContainer,'JCAT_IViewContainer'
			, JCAT_Language::SentenceEx('尚未设置 view container','Ext_JCCMS',null)) ;
		
		// 载入分类
		$sType = $aRequest->GetParam('type') ;
		if(!$sType)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'缺少参数 type', 'Ext_JCCMS', null
			)) ;
		}
		$aCategoryTree->LoadByRoot($sType) ;	
		
		// 当前分类
		$nCategoryId = $aRequest->GetParam('category') ;
		if($nCategoryId)
		{
			$theCategory = $aCategoryTree->GetModelById($nCategoryId) ;	
			if(!$theCategory)
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'无法找到指定的分类（id:%s）', 'Ext_JCCMS', null, $nCategoryId
				)) ;
			}
		}
		
		else 
		{
			$theCategory = $aCategoryTree->GetRootCategory() ;
		}			
		$this->AddModel($theCategory,self::MODELNAME_CATEGORY) ;

		$arrCategoryPath = $theCategory->GetCategoryPath() ;
		array_shift($arrCategoryPath) ; // 移除tree中的 虚拟 root 分类	
		array_shift($arrCategoryPath) ; // 移除 root 分类
		
		// 分类路径
		$aView = $this->GetView(self::VIEWNAME_PATH) ;
		$aView->SetViewVar('arrCategoryPath',$arrCategoryPath) ;
				
		// 建立 相关分类菜单
		$this->BuildCategoryBranchMenu($theCategory,$arrCategoryPath) ;

		// 
		$aViewContainer->AddView($this->GetView(self::VIEWNAME_PATH),self::VIEWNAME_PATH) ;
		$aViewContainer->AddView($this->GetView(self::VIEWNAME_MENU),self::VIEWNAME_MENU) ;
	}
	
	
	/**
	 * 建立分类分支菜单
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function BuildCategoryBranchMenu(Ext_JCCMS_ModelCategory $theCategory,array $arrCategoryPath)
	{
		$aView = $this->GetView(self::VIEWNAME_MENU) ;
		$aCategoryTree = $this->GetModel(self::MODELNAME_CATEGORYTREE) ;
		$aRootCategory = $aCategoryTree->GetRootCategory() ;
		
		// 分类树枝干
		// ------------------------------------------------
		$aCategoryBranch = new JCAT_DBAdjacensyCategoryTree((clone $aCategoryTree->GetORM())) ;
		$arrCategoryBranch = array_merge($arrCategoryPath,$theCategory->GetBrothers()) ;
		
		// 顶层菜单
		$aIterator = $aRootCategory->CreateChildCategoryIter() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aTopCategory = $aIterator->Current() ;
			if( !in_array($aTopCategory,$arrCategoryBranch) )
			{
				$arrCategoryBranch[] = $aTopCategory ;
			}
		}
		
		// 下级分类
		if( $theCategory!=$aRootCategory )
		{
			$aIterator = $theCategory->CreateChildCategoryIter() ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$aChildCategory = $aIterator->Current() ;
				$aChildCategory->ClearChildren() ;
				$aCategoryBranch->AddCategory($aChildCategory) ;
			}
		}
		
		// 路径上的菜单
		foreach ($arrCategoryBranch as $aCategoryInBrance)
		{
			$aCategoryInBrance->ClearChildren() ;
			$aCategoryBranch->AddCategory($aCategoryInBrance) ;
		}
	
		// 创建菜单
		function OnCreateMenuItem(JCAT_DBAdjacensyCategory $aCategory,JCAT_UICtrlHtmlMenuItem $aMenuItem,JCAT_UICtrlHtmlMenuForAdjCategory $aMenu, $sControllerName)
		{			
			$aMenuItem->SetLink("/?controller={$sControllerName}&category=".$aCategory->GetId()) ;
		}
		$aRequest = $this->GetRequest() ;
		$sControllerItemList = $aRequest->GetParam(self::PARAM_CTLR_ITEMLIST) ;
			
		$wndCategoryBranch = new JCAT_UICtrlHtmlMenuForAdjCategory('CategoryBranch') ;
		$aVirtualRoot = $aCategoryBranch->GetVirtualRootCategory() ;
		if($aVirtualRoot)
		{
			$wndCategoryBranch->LoadFromCategory($aVirtualRoot,'OnCreateMenuItem',array($sControllerItemList));
		}
		$aView->AddUICtrl($wndCategoryBranch) ;
		
		// 设置菜单活动项
		$arrCategoryTextPath = array() ;
		foreach ($arrCategoryPath as $aCategoryInPath) 
		{
			$arrCategoryTextPath[] = $aCategoryInPath->GetText() ;
		}
		$wndCategoryBranch->SetActiveByPath($arrCategoryTextPath) ;
	}
		
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetCategoryBorder()
	{
		$theCategory = $this->GetModel(self::MODELNAME_CATEGORY) ;
		JCAT_ASSERT::ASSERT_NOTNULL($theCategory,JCAT_Language::SentenceEx('尚未调用 Ext_JCCMS_CategoryPath::MainRun() 方法','Ext_JCCMS',null));
		
		return array(
			$theCategory->GetLeftBorder()
			, $theCategory->GetRightBorder()
		) ;
	}
}

?>